/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * EHCacheProvider.java
 * ------------
 */
package org.pentaho.reporting.libraries.resourceloader.modules.cache.ehcache;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceFactoryCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCacheProvider;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceBundleDataCache;

/**
 * Creation-Date: 13.04.2006, 16:32:20
 *
 * @author Thomas Morgner
 */
public class EHCacheProvider implements ResourceDataCacheProvider,
        ResourceFactoryCacheProvider, ResourceBundleDataCacheProvider
{
  private static CacheManager cacheManager;

  public static CacheManager getCacheManager() throws CacheException
  {
    if (cacheManager == null)
    {
      cacheManager = CacheManager.create();
    }
    return cacheManager;
  }

  public EHCacheProvider()
  {
  }

  public ResourceDataCache createDataCache()
  {
    try
    {
      final CacheManager manager = getCacheManager();
      synchronized(manager)
      {
        if (manager.cacheExists("libloader-data") == false)
        {
          manager.addCache("libloader-data");
        }
        return new EHResourceDataCache(manager.getCache("libloader-data"));
      }
    }
    catch (CacheException e)
    {
      return null;
    }
  }

  public ResourceBundleDataCache createBundleDataCache()
  {
    try
    {
      final CacheManager manager = getCacheManager();
      synchronized(manager)
      {
        if (manager.cacheExists("libloader-bundles") == false)
        {
          manager.addCache("libloader-bundles");
        }
        return new EHResourceBundleDataCache(manager.getCache("libloader-bundles"));
      }
    }
    catch (CacheException e)
    {
      return null;
    }
  }

  public ResourceFactoryCache createFactoryCache()
  {
    try
    {
      final CacheManager manager = getCacheManager();
      synchronized(manager)
      {
        if (manager.cacheExists("libloader-factory") == false)
        {
          manager.addCache("libloader-factory");
        }
        return new EHResourceFactoryCache(manager.getCache("libloader-factory"));
      }
    }
    catch (CacheException e)
    {
      return null;
    }
  }
}
