/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: baseprimitive2d.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: aw $ $Date: 2008-05-27 14:11:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_drawinglayer.hxx"

#include <drawinglayer/primitive2d/baseprimitive2d.hxx>
#include <drawinglayer/geometry/viewinformation2d.hxx>
#include <basegfx/tools/canvastools.hxx>

//////////////////////////////////////////////////////////////////////////////

using namespace com::sun::star;

//////////////////////////////////////////////////////////////////////////////

namespace drawinglayer
{
	namespace primitive2d
	{
		Primitive2DSequence BasePrimitive2D::createLocalDecomposition(const geometry::ViewInformation2D& /*rViewInformation*/) const
		{
			return Primitive2DSequence();
		}

		BasePrimitive2D::BasePrimitive2D()
		:	BasePrimitive2DImplBase(m_aMutex),
			maLocalDecomposition()
		{
		}

		bool BasePrimitive2D::operator==( const BasePrimitive2D& rPrimitive ) const
		{
			return (getPrimitiveID() == rPrimitive.getPrimitiveID());
		}

		basegfx::B2DRange BasePrimitive2D::getB2DRange(const geometry::ViewInformation2D& rViewInformation) const
		{
			return getB2DRangeFromPrimitive2DSequence(get2DDecomposition(rViewInformation), rViewInformation);
		}

		Primitive2DSequence BasePrimitive2D::get2DDecomposition(const geometry::ViewInformation2D& rViewInformation) const
		{
			::osl::MutexGuard aGuard( m_aMutex );

			if(!getLocalDecomposition().hasElements())
			{
				const Primitive2DSequence aNewSequence(createLocalDecomposition(rViewInformation));
				const_cast< BasePrimitive2D* >(this)->setLocalDecomposition(aNewSequence);
			}

			return getLocalDecomposition();
		}

		Primitive2DSequence SAL_CALL BasePrimitive2D::getDecomposition( const uno::Sequence< beans::PropertyValue >& rViewParameters ) throw ( uno::RuntimeException )
		{
			const geometry::ViewInformation2D aViewInformation(rViewParameters);
			return get2DDecomposition(aViewInformation);
		}

		com::sun::star::geometry::RealRectangle2D SAL_CALL BasePrimitive2D::getRange( const uno::Sequence< beans::PropertyValue >& rViewParameters ) throw ( uno::RuntimeException )
		{
			const geometry::ViewInformation2D aViewInformation(rViewParameters);
			return basegfx::unotools::rectangle2DFromB2DRectangle(getB2DRange(aViewInformation));
		}
	} // end of namespace primitive2d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// tooling

namespace drawinglayer
{
	namespace primitive2d
	{
		// get B2DRange from a given Primitive2DReference
		basegfx::B2DRange getB2DRangeFromPrimitive2DReference(const Primitive2DReference& rCandidate, const geometry::ViewInformation2D& aViewInformation)
		{
			basegfx::B2DRange aRetval;

			if(rCandidate.is())
			{
				// try to get C++ implementation base
				const BasePrimitive2D* pCandidate(dynamic_cast< BasePrimitive2D* >(rCandidate.get()));

				if(pCandidate)
				{
					// use it if possible
					aRetval.expand(pCandidate->getB2DRange(aViewInformation));
				}
				else
				{
					// use UNO API call instead
					const uno::Sequence< beans::PropertyValue >& rViewParameters(aViewInformation.getViewInformationSequence());
					aRetval.expand(basegfx::unotools::b2DRectangleFromRealRectangle2D(rCandidate->getRange(rViewParameters)));
				}
			}

			return aRetval;
		}

		// get B2DRange from a given Primitive2DSequence
		basegfx::B2DRange getB2DRangeFromPrimitive2DSequence(const Primitive2DSequence& rCandidate, const geometry::ViewInformation2D& aViewInformation)
		{
			basegfx::B2DRange aRetval;

			if(rCandidate.hasElements())
			{
				const sal_Int32 nCount(rCandidate.getLength());

				for(sal_Int32 a(0L); a < nCount; a++)
				{
					aRetval.expand(getB2DRangeFromPrimitive2DReference(rCandidate[a], aViewInformation));
				}
			}

			return aRetval;
		}

		bool arePrimitive2DReferencesEqual(const Primitive2DReference& rxA, const Primitive2DReference& rxB)
		{
			const sal_Bool bAIs(rxA.is());

			if(bAIs != rxB.is())
			{
				return false;
			}

			if(!bAIs)
			{
				return true;
			}

			const BasePrimitive2D* pA(dynamic_cast< const BasePrimitive2D* >(rxA.get()));
			const BasePrimitive2D* pB(dynamic_cast< const BasePrimitive2D* >(rxB.get()));
			const bool bAEqualZero(pA == 0L);

			if(bAEqualZero != (pB == 0L))
			{
				return false;
			}

			if(bAEqualZero)
			{
				return false;
			}

			return (pA->operator==(*pB));
		}

		bool arePrimitive2DSequencesEqual(const Primitive2DSequence& rA, const Primitive2DSequence& rB)
		{
			const sal_Bool bAHasElements(rA.hasElements());

			if(bAHasElements != rB.hasElements())
			{
				return false;
			}

			if(!bAHasElements)
			{
				return true;
			}

			const sal_Int32 nCount(rA.getLength());

			if(nCount != rB.getLength())
			{
				return false;
			}

			for(sal_Int32 a(0L); a < nCount; a++)
			{
				if(!arePrimitive2DReferencesEqual(rA[a], rB[a]))
				{
					return false;
				}
			}

			return true;
		}

		// concatenate sequence
		void appendPrimitive2DSequenceToPrimitive2DSequence(Primitive2DSequence& rDest, const Primitive2DSequence& rSource)
		{
			if(rSource.hasElements())
			{
				if(rDest.hasElements())
				{
					const sal_Int32 nSourceCount(rSource.getLength());
					const sal_Int32 nDestCount(rDest.getLength());
					const sal_Int32 nTargetCount(nSourceCount + nDestCount);
					sal_Int32 nInsertPos(nDestCount);

					rDest.realloc(nTargetCount);

					for(sal_Int32 a(0L); a < nSourceCount; a++)
					{
						if(rSource[a].is())
						{
							rDest[nInsertPos++] = rSource[a];
						}
					}

					if(nInsertPos != nTargetCount)
					{
						rDest.realloc(nInsertPos);
					}
				}
				else
				{
					rDest = rSource;
				}
			}
		}

		// concatenate single Primitive2D
		void appendPrimitive2DReferenceToPrimitive2DSequence(Primitive2DSequence& rDest, const Primitive2DReference& rSource)
		{
			if(rSource.is())
			{
				const sal_Int32 nDestCount(rDest.getLength());
				rDest.realloc(nDestCount + 1L);
				rDest[nDestCount] = rSource;
			}
		}

	} // end of namespace primitive2d
} // end of namespace drawinglayer

//////////////////////////////////////////////////////////////////////////////
// eof
