/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: it_sequence.cxx,v $
 * $Revision: 1.7 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#include <precomp.h>
#include "it_sequence.hxx"


// NOT FULLY DEFINED SERVICES
#include <cosv/tpl/processor.hxx>
#include <ary/idl/i_gate.hxx>
#include <ary/idl/ip_type.hxx>
#include "i_strconst.hxx"



namespace ary
{
namespace idl
{


Sequence::Sequence( Type_id i_nRelatedType )
    :   nRelatedType(i_nRelatedType)
{
}

Sequence::~Sequence()
{
}

ClassId
Sequence::get_AryClass() const
{
    return class_id;
}

void
Sequence::do_Accept( csv::ProcessorIfc & io_processor ) const
{
    csv::CheckedCall(io_processor, *this);
}

void
Sequence::inq_Get_Text( StringVector &      o_module,
                        String &            o_name,
                        Ce_id &             o_nRelatedCe,
                        int &               o_nSequenceCount,
                        const Gate &        i_rGate ) const
{
    ++o_nSequenceCount;

    i_rGate.Types().Find_Type(nRelatedType)
            .Get_Text(  o_module,
                        o_name,
                        o_nRelatedCe,
                        o_nSequenceCount,
                        i_rGate );
}



}   // namespace idl
}   // namespace ary
