/*************************************************************************
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2008, by Kohei Yoshida.
 *    1039 Kingsway Dr., Apex, NC 27502, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "numeric/baselinesearch.hxx"
#include "numeric/funcobj.hxx"

namespace scsolver { namespace numeric { 

BaseLineSearch::BaseLineSearch() :
    m_pFuncObj(NULL),
    m_pTimer(NULL),
    m_goal(GOAL_UNKNOWN),
    m_debug(false)
{
}

BaseLineSearch::BaseLineSearch(SingleVarFuncObj* pFuncObj) :
    m_pFuncObj(pFuncObj),
    m_pTimer(NULL),
    m_goal(GOAL_UNKNOWN),
    m_debug(false)
{
}

BaseLineSearch::~BaseLineSearch()
{
}

void BaseLineSearch::setGoal(GoalType goal)
{
    m_goal = goal;
}

GoalType BaseLineSearch::getGoal() const
{
    return m_goal;
}

void BaseLineSearch::setDebug(bool b)
{
    m_debug = b;
}

bool BaseLineSearch::isDebug() const
{
    return m_debug;
}

void BaseLineSearch::setFuncObj(SingleVarFuncObj* p)
{
    m_pFuncObj = p;
}

SingleVarFuncObj* BaseLineSearch::getFuncObj() const
{
    return m_pFuncObj;
}

void BaseLineSearch::setTimer(const ::scsolver::Timer* pTimer)
{
    m_pTimer = pTimer;
}

const ::scsolver::Timer* BaseLineSearch::getTimer() const
{
    return m_pTimer;
}

}}
