/***************************************************************************
 *   Copyright (C) 2005 by TAM(Teppei Tamra)                               *
 *   tam-t@par.odn.ne.jp                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef HONOKA_PLUGIN_DEF_H
#define HONOKA_PLUGIN_DEF_H

// Wnn

#define HONOKA_CONFIG_JSERVERTYPE                  "/IMEngine/Honoka/Wnn/JServerType"
#ifdef HAVE_LIBWNN7
  #define HONOKA_DEFAULT_JSERVERTYPE                  "Wnn7"
#else
  #define HONOKA_DEFAULT_JSERVERTYPE                  "Wnn4"
#endif

#define HONOKA_CONFIG_JSERVER                      "/IMEngine/Honoka/Wnn/JServer"
#define HONOKA_DEFAULT_JSERVER                     "localhost"
#define HONOKA_CONFIG_WNNENVRC                     "/IMEngine/Honoka/Wnn/Wnnenvrc"
#define HONOKA_DEFAULT_WNNENVRC                    "/usr/lib/wnn7/ja_JP/wnnenvrc"

#define HONOKA_CONFIG_WNNYOSOKU                     "/IMEngine/Honoka/Wnn/Yosoku"
#ifdef HAVE_LIBWNN7
  #define HONOKA_DEFAULT_WNNYOSOKU                   true
#else
  #define HONOKA_DEFAULT_WNNYOSOKU                   false
#endif


// Romkan

#define HONOKA_CONFIG_ROMKAN_TABLE_FILE            "/IMEngine/Honoka/Romkan/TableFile"
#define HONOKA_DEFAULT_ROMKAN_TABLE_FILE           "honoka-def.rkt"

// KanaInput
#define HONOKA_CONFIG_KANAINPUT_FAKEKANA           "/IMEngine/Honoka/KanaInput/FakeKanaKey"
#define HONOKA_DEFAULT_KANAINPUT_FAKEKANA          true

// NicolaInput
#define HONOKA_CONFIG_NICOLAINPUT_LSHIFT           "/IMEngine/Honoka/NicolaInput/LeftShift"
#define HONOKA_DEFAULT_NICOLAINPUT_LSHIFT          "Muhenkan"
#define HONOKA_CONFIG_NICOLAINPUT_RSHIFT           "/IMEngine/Honoka/NicolaInput/RightShift"
#define HONOKA_DEFAULT_NICOLAINPUT_RSHIFT          "Henkan"

// SimplePrediction
#define HONOKA_CONFIG_SIMPLEPREDICTION_SIZE        "/IMEngine/Honoka/SimplePrediction/Size"
#define HONOKA_DEFAULT_SIMPLEPREDICTION_SIZE       200

// Canna

#define HONOKA_CONFIG_CANNA_DICHOMEDIRPATH         "/IMEngine/Honoka/Canna/DicHomeDirPath"
#define HONOKA_DEFAULT_CANNA_DICHOMEDIRPATH        ""
#define HONOKA_CONFIG_CANNA_SERVER                 "/IMEngine/Honoka/Canna/Server"
#define HONOKA_DEFAULT_CANNA_SERVER                "localhost"

// SKKDic
#define HONOKA_CONFIG_SKKDIC_DICFILE    "/IMEngine/Honoka/SKKDic/File"
#define HONOKA_DEFAULT_SKKDIC_DICFILE    ""

// Prime
#define HONOKA_CONFIG_PRIME_PREDICTION_LM           "/IMEngine/Honoka/Prime/LookupMethod"
#define HONOKA_DEFAULT_PRIME_PREDICTION_LM         "lookup_hybrid"

#endif
