/***************************************************************************
    smb4khost  -  Smb4K's container class for information about a host.
                             -------------------
    begin                : Sa Jan 26 2008
    copyright            : (C) 2008 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <QHostAddress>
#include <QAbstractSocket>

// application specific includes
#include <smb4khost.h>


Smb4KHost::Smb4KHost( const QString &name )
: m_name( name ), m_workgroup( QString() ), m_ip( QString() ), m_comment( QString() ),
  m_server_string( QString() ), m_os_string( QString() ), m_info_checked( false ),
  m_ip_checked( false ), m_is_master( false ), m_protocol( Automatic )
{
}


Smb4KHost::Smb4KHost( const Smb4KHost &h )
: m_name( h.name() ), m_workgroup( h.workgroup() ), m_ip( h.ip() ), m_comment( h.comment() ),
  m_server_string( h.serverString() ), m_os_string( h.osString() ),
  m_info_checked( h.infoChecked() ),  m_ip_checked( h.ipChecked() ), m_is_master( h.isMasterBrowser() ),
  m_protocol( h.protocol() )
{
}


Smb4KHost::Smb4KHost()
: m_name( QString() ), m_workgroup( QString() ), m_ip( QString() ), m_comment( QString() ),
  m_server_string( QString() ), m_os_string( QString() ), m_info_checked( false ),
  m_ip_checked( false ), m_is_master( false ), m_protocol( Automatic )
{
}


Smb4KHost::~Smb4KHost()
{
}


void Smb4KHost::setName( const QString &name )
{
  m_name = name;
}


void Smb4KHost::setWorkgroup( const QString &workgroup )
{
  m_workgroup = workgroup;
}


void Smb4KHost::setIP( const QString &ip )
{
  m_ip         = ipIsValid( ip );

  m_ip_checked = true;
}


void Smb4KHost::setComment( const QString &comment )
{
  m_comment = comment;
}


void Smb4KHost::setInfo( const QString &serverString, const QString &osString )
{
  m_server_string = serverString;
  m_os_string     = osString;

  m_info_checked  = true;
}


void Smb4KHost::resetInfo()
{
  m_info_checked = false;

  m_server_string.clear();
  m_os_string.clear();
}


void Smb4KHost::setIsMasterBrowser( bool master )
{
  m_is_master = master;
}


void Smb4KHost::setProtocol( Smb4KHost::Protocol protocol )
{
  m_protocol = protocol;
}


bool Smb4KHost::isEmpty() const
{
  if ( !m_name.isEmpty() )
  {
    return false;
  }

  if ( !m_workgroup.isEmpty() )
  {
    return false;
  }

  if (!m_ip.isEmpty() )
  {
    return false;
  }

  if ( !m_comment.isEmpty() )
  {
    return false;
  }

  if ( !m_server_string.isEmpty() )
  {
    return false;
  }

  if ( !m_os_string.isEmpty() )
  {
    return false;
  }

  if ( m_protocol != Automatic )
  {
    return false;
  }

  return true;
}


const QString &Smb4KHost::ipIsValid( const QString &ip )
{
  QHostAddress ip_address( ip );

  if ( ip_address.protocol() == QAbstractSocket::UnknownNetworkLayerProtocol )
  {
    // The IP address is invalid.
    static_cast<QString>( ip ).clear();
  }

  return ip;
}
