//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUIWindow.cpp
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/07/28
// RCS-ID:      $Id: SVGUIWindow.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#include "SVGUIWindow.h"

BEGIN_EVENT_TABLE(SVGUIWindow, wxSVGCtrl)
	EVT_LEFT_DOWN (SVGUIWindow::OnLeftDown)
  	EVT_MOTION (SVGUIWindow::OnMotion)
  	EVT_LEFT_UP (SVGUIWindow::OnLeftUp)
  	EVT_CHAR (SVGUIWindow::OnChar)
  	EVT_SIZE (SVGUIWindow::OnSize)
  	EVT_COMMAND(-1, wxEVT_COMMAND_ENTER, SVGUIWindow::OnRefresh)
END_EVENT_TABLE()

SVGUIWindow::SVGUIWindow(wxWindow* parent, wxWindowID id, const wxPoint& pos,
	const wxSize& size, long style, const wxString& name): 
	wxSVGCtrl(parent, id, pos, size, style, wxDefaultValidator, name)
{
	m_scale = 1.;
}

bool SVGUIWindow::LoadFiles(const wxString& svgfile, const wxString& deffile)
{
	bool res = wxSVGCtrl::Load(svgfile);
	if (res)
    {
		wxXmlDocument::Load(deffile);
		Update_Elements();
    }
	return res;
}

SVGUIElement* SVGUIWindow::CreateElement(const wxString& tagName)
{
  return CreateElementNS(wxT(""), tagName);
}

SVGUIElement* SVGUIWindow::CreateElementNS(const wxString& namespaceURI,
  const wxString& qualifiedName)
{
  SVGUIElement* res = NULL;
  if (qualifiedName == wxT("Container"))
    res = new SVGUIContainer(GetSVG());
  else if (qualifiedName == wxT("Button"))
    res = new SVGUIButton(GetSVG(), (wxEvtHandler*)this);
  else if (qualifiedName == wxT("TextCtrl"))
    res = new SVGUITextCtrl(GetSVG(), (wxEvtHandler*)this);
  else if (qualifiedName == wxT("ScrollBar"))
    res = new SVGUIScrollBar(GetSVG(), (wxEvtHandler*)this);
  else if (qualifiedName == wxT("NoteBook"))
    res = new SVGUINoteBook(GetSVG(), (wxEvtHandler*)this);
  else 
	res = new SVGUIContainer(GetSVG());
  return res;
}

wxWindow* SVGUIWindow::CreateWindow(const wxString& classname)
{
	return NULL;
}

SVGUIElement* RecurseElementId(SVGUIElement* elem, const wxString& id)
{
    if (elem->GetId() == id) return elem;
    SVGUIElement* n = (SVGUIElement*)elem->GetChildren();
    while (n)
    {
        SVGUIElement* res = RecurseElementId(n, id);
        if (res)
           return res;
        else
           n = (SVGUIElement*)n->GetNext();
    }
    return NULL;
} 

SVGUIElement* SVGUIWindow::GetElementById(const wxString& id)
{
	return RecurseElementId((SVGUIElement*)GetRoot(), id);
}

void SVGUIWindow::RefreshScale()
{
	wxSVGRect rect = wxSVGCtrl::m_doc->GetRootElement()->GetBBox();
	wxSize size = GetClientSize();
	if ((float)rect.GetWidth()/(float)rect.GetHeight() > (float)size.GetWidth()/(float)size.GetHeight())
		m_scale = (float)rect.GetWidth() / (float)size.GetWidth();
	else
		m_scale = (float)rect.GetHeight() / (float)size.GetHeight();
}

void SVGUIWindow::Update_Elements()
{
	((SVGUIElement*)GetRoot())->Update_Elements();
}

void SVGUIWindow::OnLeftDown (wxMouseEvent& event)
{
	event.m_x = (long)((float)event.m_x * m_scale);
	event.m_y = (long)((float)event.m_y * m_scale);
	((SVGUIElement*)GetRoot())->HitTest(event.GetPosition());
	CaptureMouse();
	((SVGUIElement*)GetRoot())->SendMouseEvent(event);
	event.Skip();
}

void SVGUIWindow::OnMotion (wxMouseEvent& event)
{
	event.m_x = (long)((float)event.m_x * m_scale);
	event.m_y = (long)((float)event.m_y * m_scale);
	((SVGUIElement*)GetRoot())->SendMouseEvent(event);
	event.Skip();
}

void SVGUIWindow::OnLeftUp (wxMouseEvent& event)
{
	event.m_x = (long)((float)event.m_x * m_scale);
	event.m_y = (long)((float)event.m_y * m_scale);
	((SVGUIElement*)GetRoot())->SendMouseEvent(event);
	ReleaseMouse();
	event.Skip();
}

void SVGUIWindow::OnChar(wxKeyEvent& event)
{
	((SVGUIElement*)GetRoot())->SendKeyEvent(event);
	event.Skip();
}

void SVGUIWindow::OnRefresh(wxCommandEvent& event)
{
	wxString elem_name = event.GetString();
	if (elem_name.length())
	{
		SVGUIElement* elem = GetElementById(elem_name);
		if (elem)
			RefreshRect(elem->GetBBox());
	}
	else
		Refresh();
}

void SVGUIWindow::OnSize(wxSizeEvent& event)
{
	RefreshScale();
	event.Skip();
}
