
/*
 *  devinfo.cpp
 *
 *  Copyright (C) 2009 David Hubner <hubnerd@ntlworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#include "devinfo.h"

K_PLUGIN_FACTORY(devInfoModuleFactory, registerPlugin<DevInfoPlugin>();)
K_EXPORT_PLUGIN(devInfoModuleFactory("kcmdevinfo"))

DevInfoPlugin::DevInfoPlugin(QWidget *parent, const QVariantList &)  : 
  KCModule(devInfoModuleFactory::componentData(), parent)
{
  
  KAboutData *about =
  new KAboutData(I18N_NOOP("kcmdevinfo"), 0, ki18n("KDE Solid Based Device Viewer"),
                  0, KLocalizedString(), KAboutData::License_GPL,
                  ki18n("(c) 2009 David Hubner"));
		  
  setAboutData(about);
  layout = new QVBoxLayout(this);
  uidStatus = new QStatusBar(this);
 
  info = new InfoPanel(this, this);
  devList = new DeviceListing(this, info);
  QList<int> defaultSizes; 
   
  split = new QSplitter();
  split->setChildrenCollapsible(false);

  split->addWidget(devList);  
  split->addWidget(info);
  
  defaultSizes << panePercent(parent->width(),65) << panePercent(parent->width(),35) ;
  split->setSizes(defaultSizes);
 
  layout->addWidget(split); 
  
  uidStatus->setMaximumHeight(18);
  uidStatus->setSizeGripEnabled(false);
  updateStatus("");
  layout->addWidget(uidStatus);
  
  setButtons(Help);
}

DevInfoPlugin::~DevInfoPlugin() {
  
  delete layout; 
  delete info;
  delete devList;
  delete split;
}

int DevInfoPlugin::panePercent(int parentWidth, int percent) {
  
  return (parentWidth/100)*percent;
}
  
void DevInfoPlugin::updateStatus(QString message) {
  
  uidStatus->clearMessage();
  uidStatus->showMessage(message);
};