/* Copyright (c) 2002-2009 Dovecot Sieve authors, see the included COPYING file
 */

#include "common.h"
#include "commands.h"
#include "str.h"
#include "strfuncs.h"
#include "ostream.h"

#include "sieve.h"

bool cmd_capability(struct client_command_context *cmd)
{
	struct client *client = cmd->client;
	const char *sievecap, *notifycap;

	o_stream_cork(client->output);

	T_BEGIN {
		/* Get capabilities */
		sievecap = sieve_get_capabilities(client->svinst, NULL);
		notifycap = sieve_get_capabilities(client->svinst, "notify");


		/* Default capabilities */
		client_send_line(client, t_strconcat("\"IMPLEMENTATION\" \"", 
			managesieve_implementation_string, "\"", NULL));
		client_send_line(client, t_strconcat("\"SIEVE\" \"", 
			( sievecap == NULL ? "" : sievecap ), "\"", NULL));

		/* Notify methods */
		if ( notifycap != NULL ) {
			client_send_line(client, t_strconcat("\"NOTIFY\" \"", 
				notifycap, "\"", NULL));
		}

		/* Protocol version */
		client_send_line(client, "\"VERSION\" \"1.0\"");

		/* Finish */
		client_send_line(client, "OK \"Capability completed.\"");
	} T_END;

	o_stream_uncork(client->output);

	return TRUE;

}

