/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: salinst.cxx,v $
 * $Revision: 1.34.154.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_vcl.hxx"

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <salunx.h>

#ifndef _VOS_MUTEX_HXX
#include <vos/mutex.hxx>
#endif
#include <saldata.hxx>
#include <saldisp.hxx>
#include <salinst.h>
#include <salframe.h>
#include <vcl/salwtype.hxx>
#include <vcl/salatype.hxx>
#include <dtint.hxx>
#include <salprn.h>
#include <sm.hxx>

// -------------------------------------------------------------------------
//
// SalYieldMutex
//
// -------------------------------------------------------------------------

SalYieldMutex::SalYieldMutex()
{
	mnCount 	= 0;
	mnThreadId	= 0;
}

void SalYieldMutex::acquire()
{
	OMutex::acquire();
	mnThreadId = NAMESPACE_VOS(OThread)::getCurrentIdentifier();
	mnCount++;
}

void SalYieldMutex::release()
{
	if ( mnThreadId == NAMESPACE_VOS(OThread)::getCurrentIdentifier() )
	{
		if ( mnCount == 1 )
			mnThreadId = 0;
		mnCount--;
	}
	OMutex::release();
}

sal_Bool SalYieldMutex::tryToAcquire()
{
	if ( OMutex::tryToAcquire() )
	{
		mnThreadId = NAMESPACE_VOS(OThread)::getCurrentIdentifier();
		mnCount++;
		return True;
	}
	else
		return False;
}

//----------------------------------------------------------------------------

// -=-= SalInstance =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// plugin factory function
extern "C"
{
    VCL_DLLPUBLIC SalInstance* create_SalInstance()
    {
        X11SalInstance* pInstance = new X11SalInstance( new SalYieldMutex() );

        // initialize SalData
        X11SalData *pSalData = new X11SalData;
        SetSalData( pSalData );
        pSalData->m_pInstance = pInstance;
        pSalData->Init();

        return pInstance;
    }
}

X11SalInstance::~X11SalInstance()
{
    // close session management
    SessionManagerClient::close();

    // dispose SalDisplay list from SalData
    // would be done in a static destructor else which is
    // a little late

	X11SalData *pSalData = GetX11SalData();
    pSalData->deInitNWF();
	delete pSalData;
	SetSalData( NULL );

  	delete mpSalYieldMutex;
}


// --------------------------------------------------------
// AnyInput from sv/mow/source/app/svapp.cxx

struct PredicateReturn
{
	USHORT	nType;
	BOOL	bRet;
};

extern "C" {
Bool ImplPredicateEvent( Display *, XEvent *pEvent, char *pData )
{
	PredicateReturn *pPre = (PredicateReturn *)pData;

	if ( pPre->bRet )
		return False;

	USHORT nType;

	switch( pEvent->type )
	{
		case ButtonPress:
		case ButtonRelease:
		case MotionNotify:
		case EnterNotify:
		case LeaveNotify:
			nType = INPUT_MOUSE;
			break;

		case XLIB_KeyPress:
		//case KeyRelease:
			nType = INPUT_KEYBOARD;
			break;
		case Expose:
		case GraphicsExpose:
		case NoExpose:
			nType = INPUT_PAINT;
			break;
		default:
			nType = 0;
	}

	if ( (nType & pPre->nType) || ( ! nType && (pPre->nType & INPUT_OTHER) ) )
		pPre->bRet = TRUE;

	return False;
}
}

bool X11SalInstance::AnyInput(USHORT nType)
{
	X11SalData *pSalData = GetX11SalData();
	Display *pDisplay  = pSalData->GetDisplay()->GetDisplay();
    BOOL bRet = FALSE;

    if( (nType & INPUT_TIMER) &&
        pSalData->GetDisplay()->GetXLib()->CheckTimeout( false ) )
    {
        bRet = TRUE;
    }
	else if (XPending(pDisplay) )
	{
        PredicateReturn aInput;
        XEvent			aEvent;

        aInput.bRet 	= FALSE;
        aInput.nType	= nType;

        XCheckIfEvent(pDisplay, &aEvent, ImplPredicateEvent,
                      (char *)&aInput );

        bRet = aInput.bRet;
	}
	return bRet;
}

vos::IMutex* X11SalInstance::GetYieldMutex()
{
	return mpSalYieldMutex;
}

// -----------------------------------------------------------------------

ULONG X11SalInstance::ReleaseYieldMutex()
{
	SalYieldMutex* pYieldMutex = mpSalYieldMutex;
	if ( pYieldMutex->GetThreadId() ==
		 NAMESPACE_VOS(OThread)::getCurrentIdentifier() )
	{
		ULONG nCount = pYieldMutex->GetAcquireCount();
		ULONG n = nCount;
		while ( n )
		{
			pYieldMutex->release();
			n--;
		}

		return nCount;
	}
	else
		return 0;
}

// -----------------------------------------------------------------------

void X11SalInstance::AcquireYieldMutex( ULONG nCount )
{
	SalYieldMutex* pYieldMutex = mpSalYieldMutex;
	while ( nCount )
	{
		pYieldMutex->acquire();
		nCount--;
	}
}

void X11SalInstance::Yield( bool bWait, bool bHandleAllCurrentEvents )
{ GetX11SalData()->GetLib()->Yield( bWait, bHandleAllCurrentEvents ); }

void* X11SalInstance::GetConnectionIdentifier( ConnectionIdentifierType& rReturnedType, int& rReturnedBytes )
{
	static const char* pDisplay = getenv( "DISPLAY" );
	rReturnedType	= AsciiCString;
	rReturnedBytes	= pDisplay ? strlen( pDisplay )+1 : 1;
	return pDisplay ? (void*)pDisplay : (void*)"";
}

SalFrame *X11SalInstance::CreateFrame( SalFrame *pParent, ULONG nSalFrameStyle )
{
	SalFrame *pFrame = new X11SalFrame( pParent, nSalFrameStyle );

	return pFrame;
}

SalFrame* X11SalInstance::CreateChildFrame( SystemParentData* pParentData, ULONG nStyle )
{
	SalFrame* pFrame = new X11SalFrame( NULL, nStyle, pParentData );

	return pFrame;
}

void X11SalInstance::DestroyFrame( SalFrame* pFrame )
{
	delete pFrame;
}
