/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sheetinfobuffer.hxx,v $
 *
 *  $Revision: 1.1.2.5 $
 *
 *  last change: $Author: dr $ $Date: 2007/08/09 14:14:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_XLS_SHEETINFOBUFFER_HXX
#define OOX_XLS_SHEETINFOBUFFER_HXX

#include "oox/core/containerhelper.hxx"
#include "oox/xls/globaldatahelper.hxx"

namespace oox { namespace core {
    class AttributeList;
} }

namespace oox {
namespace xls {

// ============================================================================

/** Contains data from the 'sheet' element describing a sheet in the workbook. */
struct OoxSheetInfo
{
    ::rtl::OUString     maId;           /// Relation identifier for the sheet substream.
    ::rtl::OUString     maName;         /// Original name of the sheet.
    ::rtl::OUString     maFinalName;    /// Final (converted) name of the sheet.
    bool                mbVisible;      /// True = sheet is visible.

    explicit            OoxSheetInfo();
};

// ============================================================================

/** Stores information about all sheets in a spreadsheet document.

    Information about sheets includes the sheet name, the visibility state, and
    for the OOX filter, the relation identifier of the sheet used to obtain the
    related worksheet fragment.
 */
class SheetInfoBuffer : public GlobalDataHelper
{
public:
    explicit            SheetInfoBuffer( const GlobalDataHelper& rGlobalData );

    /** Imports the attributes of a sheet element. */
    void                importSheet( const ::oox::core::AttributeList& rAttribs );
    /** Imports the BOUNDSHEET record from the passed BIFF stream. */
    void                importBoundSheet( BiffInputStream& rStrm );

    /** Finalizes import. Creates all sheets in the spreadsheet document. */
    void                finalizeImport();

    /** Returns the OOX relation identifier of the specified sheet. */
    ::rtl::OUString     getSheetId( sal_Int32 nSheet ) const;
    /** Returns the finalized name of the specified sheet. */
    ::rtl::OUString     getFinalSheetName( sal_Int32 nSheet ) const;
    /** Returns the finalized name of the sheet with the passed original name. */
    ::rtl::OUString     getFinalSheetName( const ::rtl::OUString& rName ) const;

private:
    typedef ::oox::core::RefVector< OoxSheetInfo > SheetInfoVec;

    SheetInfoVec        maSheetInfos;
};

// ============================================================================

} // namespace xls
} // namespace oox

#endif

