#!/bin/sh
#
# ptetex -- Japanese patche collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

#
# Don't edit this file directly. See 'my_option.sample'.
#

JAPANESE=traditional
# JAPANESE=international
# JAPANESE=without

KANJI_CODE=EUC
# KANJI_CODE=SJIS
# KANJI_CODE=JIS
# KANJI_CODE=UTF8

PLATEX209=yes
# PLATEX209=no

STRIP=yes
# STRIP=no

TMP_PREFIX=/var/tmp/ptetex3
PREFIX=/usr/local/teTeX

TEXSRC_EXTRACTED=
# TEXSRC_EXTRACTED=/tmp/ptetex3/build

TEXMFDIST=
# TEXMFDIST=/usr/local/share/texmf-dist
# TEXMFDIST=/usr/local/teTeX/share/texmf-dist

MAKE=make
# MAKE=gmake

PATCH=patch
# PATCH=gpatch

MD5=md5
# MD5=md5sum
# MD5=gmd5sum
# MD5="digest -a md5"
# MD5=none

NKFJIS="perl -I `pwd`/archive -ne 'BEGIN {require \"jcode.pl\";} print jcode::jis(\$_)'"
# NKFJIS="nkf -jd"
# NKFJIS="qkc -bj -u"
# NKFJIS="ruby -rkconv -ne 'print Kconv::tojis(\$_)'"
# NKFJIS="perl -MJcode -ne 'print jcode(\$_)->jis'"

SYSTEM_FREETYPE2=no
# SYSTEM_FREETYPE2=yes

### auto detect
gmake   --version > /dev/null 2>&1 && MAKE=gmake
gpatch  --version > /dev/null 2>&1 && PATCH=gpatch
digest  -l        > /dev/null 2>&1 && MD5="digest -a md5"
gmd5sum --version > /dev/null 2>&1 && MD5=gmd5sum
md5sum  --version > /dev/null 2>&1 && MD5=md5sum
md5sum  -h        > /dev/null 2>&1 && MD5=md5sum
nkf < /dev/null   > /dev/null 2>&1 && NKFJIS="nkf -jd"
test "$JAPANESE" = "without"       && KANJI_CODE=no
# freetype-2.1.10 or latter has '--ftversion' option
freetype-config --ftversion > /dev/null 2>&1 && SYSTEM_FREETYPE2=yes

test "$PRINT_MY_OPTION" != "yes" && \
echo "------------------------------------------------------------------------"
CP="cp -pf"
LN="ln -sf"
RM="rm -f"
MKDIR="mkdir -p"
RMDIR="rmdir -p"

TETEX_VER=3.0
TEXMF_VER=3.0po
SRC_DIR=..

MKTEXLSR="texconfig-sys rehash"
#MKTEXLSR="eval mktexlsr \$TEXMF \$TEXMF-config \$TEXMF-var"
UPDMAP="updmap-sys"
PTETEX_TMP=ptetex-tmp.$$

# remove space in PATH (especially for Cygwin)
PATH=`echo $PATH | tr -d ' '`

# usage: tarcp src-dir dist-dir
tarcp() {
    echo "[copying]    $1 -> $2"
    if test ! -d "$1"; then echo "'$1' isn't a directory"; exit 1; fi
    test -d "$2" || $MKDIR "$2"
    (cd "$1" && tar cf - .) | (cd "$2" && tar xf -) || exit
}

# usage: tarx hoge.tar.gz dist-dir
tarx() {
    echo "[extracting] $1"
    if test ! -f "$1"; then echo "'$1' doesn't exist"; exit 1; fi
    test -d "$2" || $MKDIR "$2"
    case $1 in
	*.zip) unzip -q "$1" -d "$2" || exit 1;;
	*.lzh) lha ew="$2" "$1" || exit 1;;
	*.bz2) bzip2 -cd "$1" | (umask 0; cd "$2"; tar xf -) || exit 1;;
	*)     gzip  -cd "$1" | (umask 0; cd "$2"; tar xf -) || exit 1;;
    esac
}

# usage: cpatch hoge.patch strip-num dist-dir
cpatch() {
    echo "[patching]   $1"
    if test ! -f "$1"; then echo "'$1' doesn't exist"; exit 1; fi
    cat "$1" | $PATCH -p$2 -s -d "$3" || exit 1
}

# usage: zpatch hoge.patch.gz strip-num dist-dir
zpatch() {
    echo "[patching]   $1"
    if test ! -f "$1"; then echo "'$1' doesn't exist"; exit 1; fi
    gzip -cd "$1" | $PATCH -p$2 -s -d "$3" || exit 1
}

# usage: perlprint one-line-script target-file
perlprint() {
    echo "[rewriting]  $2"
    perl -pi -e "$1" "$2" || exit
}

# usage: perlnoprint one-line-script target-file
perlnoprint() {
    echo "[rewriting]  $2"
    perl -ni -e "$1" "$2" || exit
}

# usage: nkfjis target-file
nkfjis() {
    echo "[to JIScode] $1"
    $CP "$1" ptetex-nkf.$$ || exit 1
    eval $NKFJIS < ptetex-nkf.$$ > "$1" || exit 1
    $RM ptetex-nkf.$$
}

# usege: eightbit2hex $TEXMF path name
# It converts 8bit character into '^^??' form,
# which is convenient for Japanese pTeX 3.1.8 and latter.
# '^^??' form prevents both "platex --kanji=euc" and "platex --kanji=sjis"
# from occurring errors.
eightbit2hex() {
    echo "[to hex]     $1/$2/$3"
    test -d "$1/p$2" || $MKDIR "$1/p$2"
    if   test -f "$1/$2/$3";   then DIR="$1"
    elif test -z "$TEXMFDIST"; then DIR="$1-dist"
    else                            DIR="$TEXMFDIST"
    fi
    perl -p -e 's/([\x80-\xff])/sprintf("^^%x", ord $1)/eg' \
	< "$DIR/$2/$3" > "$1/p$2/$3" || exit 1
}

# usage: distcp $TEXMF path name
distcp() {
    echo "[copying]    $1/$2/$3"
    test -d "$1/$2" || $MKDIR "$1/$2"
    if test -z "$TEXMFDIST"; then
	$CP    "$1-dist/$2/$3" "$1/$2/$3" || exit 1
    else
	$CP "$TEXMFDIST/$2/$3" "$1/$2/$3" || exit 1
    fi
}

# usage: lndir src-dir dist-dir name
lndir() {
    test -d "$2" || $MKDIR "$2"
    test -h "$2/$3" && $RM "$2/$3"
    $LN "$1" "$2/$3"
}

# usage: md5check < md5sum.file
md5check() {
    test "$MD5" = "none" && exit 0 # no check
    ERROR=0
    while read SUM FILE; do
	if test "`$MD5 < $FILE | awk '{print $1}'`" != $SUM; then
	    echo "$FILE: FAILED"; ERROR=1
	fi
    done
    if test $ERROR -ne 0; then
	echo "md5check: WARNING: checksums did NOT match"
	exit 1
    fi
}

shouldnotexist() {
    if test -f "$1" -o -d "$1"; then
	echo ""
	echo "'$1' already exists."
	echo "Please 'rm -rf $1'. ('make distclean' maybe convenient)."
	echo ""
	exit 1
    fi
}

enoughspace() {
    DISKFREE=`df -k "$1" | tail -1 | awk '{print $4}'`
    if test $DISKFREE -le $2; then
	echo ""
	echo "We need about $2 Kbyte free disk space."
	echo "'$1' has only $DISKFREE Kbyte free."
	echo -n "Continue? (yes/No) "
	read REPLY
	case $REPLY in
	    yes) ;;
	    *) exit 1;;
	esac
    fi
}

root_check() {
    if test "$UID" = 0; then
	echo ""
	echo "You are root."
	echo "It is RECOMMENDED to execute by a user."
	echo "Executing by root may cause SERIOUS DAMAGE for your system."
	echo -n "Are you sure to execute by root AT YOUR OWN RISK? (yes/NO) "
	read REPLY
	case $REPLY in
	    yes) ;;
	    *) exit 1;;
	esac
    fi
}

# usage: necessitycommand command arg1 arg2 ...
necessity_command() {
    echo "[searching]  $1 	-- `which $1`"
    $@ > /dev/null 2>&1 && return
    echo ""
    echo "We need '$1' command."
    echo ""
    exit 1
}

# usage: read_my_option file-name
read_my_option() {
    if test -f  $1; then
	echo "[reading]    $1"
	.  $1
	MY_OPTION=yes
	if test "$PRINT_MY_OPTION" = "yes"; then
	    perl -ne 's/\s*#.*//; if (/^$/) {print unless $empty; $empty=1}
		else {print; $empty=0}' < $1
	    echo "------------------------------------------------------------------------"
	fi
    fi
}

conf_option() {
    CONF_OPTION="$CONF_OPTION $@"
}

make_option() {
    MAKE_OPTION="$MAKE_OPTION $@"
}

read_my_option  ./my_option
read_my_option ../my_option
read_my_option ../my_option.`hostname | sed -e 's/\..*//'`
test -z "$MY_OPTION" && cat <<EOF
Warning: No "my_option" was found.
         Please read "my_option.sample" or "my_option.sample.en".
------------------------------------------------------------------------
EOF

           PATH=$TMP_PREFIX/bin:$PATH
LD_LIBRARY_PATH=$TMP_PREFIX/lib:$LD_LIBRARY_PATH
    TMP_DATADIR=$TMP_PREFIX/share
TEXMF=$TMP_DATADIR/texmf
TEXMFMAIN=$TEXMF
CONFIG_SHELL=$BASH
export PATH LD_LIBRARY_PATH TEXMFMAIN CONFIG_SHELL
test -z "$DATADIR" && DATADIR=$PREFIX/share
if test -z "$TEXSRC_EXTRACTED"; then SRC=$TMP_PREFIX/tetex-src-$TETEX_VER
else                           SRC=$TEXSRC_EXTRACTED/tetex-src-$TETEX_VER
fi

unset TEXINPUTS
unset PTEX_KANJI_ENC
PTEX_IN_FILTER=no
export PTEX_IN_FILTER
