#!/bin/sh
#
# txpxfonts.zip maker for ptetex3
#  N. Tsuchimura  2009/ 5/ 4
#
#  arrange tx/pxfonts.zip as tetex-texmf-3.0po.tar.gz
#  and delete the same file.

rm -rf txfonts pxfonts texmf txpxfonts.zip

mkdir -p texmf/fonts/afm/public
mkdir -p texmf/tex/latex
mkdir -p texmf/fonts/type1/public
mkdir -p texmf/fonts/tfm/public
mkdir -p texmf/fonts/vf/public
mkdir -p texmf/doc/fonts

# wget http://www.ctan.org/tex-archive/fonts/txfonts.zip
# wget http://www.ctan.org/tex-archive/fonts/pxfonts.zip

for f in txfonts pxfonts; do
    unzip $f.zip
    mv $f/afm   texmf/fonts/afm/public/$f
    mv $f/input texmf/tex/latex/$f
    mv $f/pfb   texmf/fonts/type1/public/$f
    mv $f/tfm   texmf/fonts/tfm/public/$f
    mv $f/vf    texmf/fonts/vf/public/$f
    mkdir       texmf/doc/fonts/$f
    mv $f/{00bug_fix.txt,COPYRIGHT,README} texmf/doc/fonts/$f
done

rm texmf/fonts/vf/public/txfonts/txmi.vpl # no such file in tetex-texmf-3.0po
cp -a $0 texmf/doc/fonts/txfonts/

cd texmf
find . -type f -exec diff \{\} /usr/share/texmf-dist/\{\} \; -a -exec rm \{\} \;
find . -type d -exec rmdir -p \{\} \;
zip -r ../txpxfonts.zip .
