/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSClipboard.h"

#include <wtf/GetPtr.h>

#include "Clipboard.h"
#include "KURL.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSClipboard)

/* Hash table */

static const HashTableValue JSClipboardTableValues[5] =
{
    { "dropEffect", DontDelete, (intptr_t)jsClipboardDropEffect, (intptr_t)setJSClipboardDropEffect },
    { "effectAllowed", DontDelete, (intptr_t)jsClipboardEffectAllowed, (intptr_t)setJSClipboardEffectAllowed },
    { "types", DontDelete|ReadOnly, (intptr_t)jsClipboardTypes, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsClipboardConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSClipboardTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSClipboardTableValues, 0 };
#else
    { 10, 7, JSClipboardTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSClipboardConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSClipboardConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSClipboardConstructorTableValues, 0 };
#else
    { 1, 0, JSClipboardConstructorTableValues, 0 };
#endif

class JSClipboardConstructor : public DOMObject {
public:
    JSClipboardConstructor(ExecState* exec)
        : DOMObject(JSClipboardConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSClipboardPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSClipboardConstructor::s_info = { "ClipboardConstructor", 0, &JSClipboardConstructorTable, 0 };

bool JSClipboardConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboardConstructor, DOMObject>(exec, &JSClipboardConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSClipboardPrototypeTableValues[5] =
{
    { "clearData", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionClearData, (intptr_t)1 },
    { "getData", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionGetData, (intptr_t)1 },
    { "setData", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionSetData, (intptr_t)2 },
    { "setDragImage", DontDelete|Function, (intptr_t)jsClipboardPrototypeFunctionSetDragImage, (intptr_t)3 },
    { 0, 0, 0, 0 }
};

static const HashTable JSClipboardPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSClipboardPrototypeTableValues, 0 };
#else
    { 8, 7, JSClipboardPrototypeTableValues, 0 };
#endif

const ClassInfo JSClipboardPrototype::s_info = { "ClipboardPrototype", 0, &JSClipboardPrototypeTable, 0 };

JSObject* JSClipboardPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSClipboard>(exec, globalObject);
}

bool JSClipboardPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSClipboardPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSClipboard::s_info = { "Clipboard", 0, &JSClipboardTable, 0 };

JSClipboard::JSClipboard(PassRefPtr<Structure> structure, PassRefPtr<Clipboard> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSClipboard::~JSClipboard()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSClipboard::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSClipboardPrototype(JSClipboardPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSClipboard::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSClipboard, Base>(exec, &JSClipboardTable, this, propertyName, slot);
}

JSValuePtr jsClipboardDropEffect(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Clipboard* imp = static_cast<Clipboard*>(static_cast<JSClipboard*>(asObject(slot.slotBase()))->impl());
    return jsStringOrUndefined(exec, imp->dropEffect());
}

JSValuePtr jsClipboardEffectAllowed(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Clipboard* imp = static_cast<Clipboard*>(static_cast<JSClipboard*>(asObject(slot.slotBase()))->impl());
    return jsStringOrUndefined(exec, imp->effectAllowed());
}

JSValuePtr jsClipboardTypes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSClipboard*>(asObject(slot.slotBase()))->types(exec);
}

JSValuePtr jsClipboardConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSClipboard*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSClipboard::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSClipboard, Base>(exec, propertyName, value, &JSClipboardTable, this, slot);
}

void setJSClipboardDropEffect(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Clipboard* imp = static_cast<Clipboard*>(static_cast<JSClipboard*>(thisObject)->impl());
    imp->setDropEffect(value->toString(exec));
}

void setJSClipboardEffectAllowed(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    Clipboard* imp = static_cast<Clipboard*>(static_cast<JSClipboard*>(thisObject)->impl());
    imp->setEffectAllowed(value->toString(exec));
}

JSValuePtr JSClipboard::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSClipboardConstructor>(exec);
}

JSValuePtr jsClipboardPrototypeFunctionClearData(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->clearData(exec, args);
}

JSValuePtr jsClipboardPrototypeFunctionGetData(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->getData(exec, args);
}

JSValuePtr jsClipboardPrototypeFunctionSetData(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->setData(exec, args);
}

JSValuePtr jsClipboardPrototypeFunctionSetDragImage(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSClipboard::s_info))
        return throwError(exec, TypeError);
    JSClipboard* castedThisObj = static_cast<JSClipboard*>(asObject(thisValue));
    return castedThisObj->setDragImage(exec, args);
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, Clipboard* object)
{
    return getDOMObjectWrapper<JSClipboard>(exec, object);
}
Clipboard* toClipboard(JSC::JSValuePtr value)
{
    return value->isObject(&JSClipboard::s_info) ? static_cast<JSClipboard*>(asObject(value))->impl() : 0;
}

}
