/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSEventTargetNode.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "EventListener.h"
#include "EventTargetNode.h"
#include "Frame.h"
#include "JSDOMGlobalObject.h"
#include "JSEvent.h"
#include "JSEventListener.h"

#include <runtime/Error.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSEventTargetNode)

/* Hash table */

static const HashTableValue JSEventTargetNodeTableValues[41] =
{
    { "onabort", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnabort, (intptr_t)setJSEventTargetNodeOnabort },
    { "onblur", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnblur, (intptr_t)setJSEventTargetNodeOnblur },
    { "onchange", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnchange, (intptr_t)setJSEventTargetNodeOnchange },
    { "onclick", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnclick, (intptr_t)setJSEventTargetNodeOnclick },
    { "oncontextmenu", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOncontextmenu, (intptr_t)setJSEventTargetNodeOncontextmenu },
    { "ondblclick", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndblclick, (intptr_t)setJSEventTargetNodeOndblclick },
    { "onerror", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnerror, (intptr_t)setJSEventTargetNodeOnerror },
    { "onfocus", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnfocus, (intptr_t)setJSEventTargetNodeOnfocus },
    { "oninput", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOninput, (intptr_t)setJSEventTargetNodeOninput },
    { "onkeydown", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnkeydown, (intptr_t)setJSEventTargetNodeOnkeydown },
    { "onkeypress", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnkeypress, (intptr_t)setJSEventTargetNodeOnkeypress },
    { "onkeyup", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnkeyup, (intptr_t)setJSEventTargetNodeOnkeyup },
    { "onload", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnload, (intptr_t)setJSEventTargetNodeOnload },
    { "onmousedown", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnmousedown, (intptr_t)setJSEventTargetNodeOnmousedown },
    { "onmousemove", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnmousemove, (intptr_t)setJSEventTargetNodeOnmousemove },
    { "onmouseout", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnmouseout, (intptr_t)setJSEventTargetNodeOnmouseout },
    { "onmouseover", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnmouseover, (intptr_t)setJSEventTargetNodeOnmouseover },
    { "onmouseup", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnmouseup, (intptr_t)setJSEventTargetNodeOnmouseup },
    { "onmousewheel", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnmousewheel, (intptr_t)setJSEventTargetNodeOnmousewheel },
    { "onbeforecut", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnbeforecut, (intptr_t)setJSEventTargetNodeOnbeforecut },
    { "oncut", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOncut, (intptr_t)setJSEventTargetNodeOncut },
    { "onbeforecopy", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnbeforecopy, (intptr_t)setJSEventTargetNodeOnbeforecopy },
    { "oncopy", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOncopy, (intptr_t)setJSEventTargetNodeOncopy },
    { "onbeforepaste", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnbeforepaste, (intptr_t)setJSEventTargetNodeOnbeforepaste },
    { "onpaste", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnpaste, (intptr_t)setJSEventTargetNodeOnpaste },
    { "ondragenter", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndragenter, (intptr_t)setJSEventTargetNodeOndragenter },
    { "ondragover", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndragover, (intptr_t)setJSEventTargetNodeOndragover },
    { "ondragleave", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndragleave, (intptr_t)setJSEventTargetNodeOndragleave },
    { "ondrop", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndrop, (intptr_t)setJSEventTargetNodeOndrop },
    { "ondragstart", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndragstart, (intptr_t)setJSEventTargetNodeOndragstart },
    { "ondrag", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndrag, (intptr_t)setJSEventTargetNodeOndrag },
    { "ondragend", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOndragend, (intptr_t)setJSEventTargetNodeOndragend },
    { "onreset", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnreset, (intptr_t)setJSEventTargetNodeOnreset },
    { "onresize", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnresize, (intptr_t)setJSEventTargetNodeOnresize },
    { "onscroll", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnscroll, (intptr_t)setJSEventTargetNodeOnscroll },
    { "onsearch", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnsearch, (intptr_t)setJSEventTargetNodeOnsearch },
    { "onselect", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnselect, (intptr_t)setJSEventTargetNodeOnselect },
    { "onselectstart", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnselectstart, (intptr_t)setJSEventTargetNodeOnselectstart },
    { "onsubmit", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnsubmit, (intptr_t)setJSEventTargetNodeOnsubmit },
    { "onunload", DontDelete|DontEnum, (intptr_t)jsEventTargetNodeOnunload, (intptr_t)setJSEventTargetNodeOnunload },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventTargetNodeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSEventTargetNodeTableValues, 0 };
#else
    { 133, 127, JSEventTargetNodeTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSEventTargetNodePrototypeTableValues[4] =
{
    { "addEventListener", DontDelete|Function, (intptr_t)jsEventTargetNodePrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsEventTargetNodePrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsEventTargetNodePrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSEventTargetNodePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSEventTargetNodePrototypeTableValues, 0 };
#else
    { 8, 7, JSEventTargetNodePrototypeTableValues, 0 };
#endif

const ClassInfo JSEventTargetNodePrototype::s_info = { "EventTargetNodePrototype", 0, &JSEventTargetNodePrototypeTable, 0 };

JSObject* JSEventTargetNodePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEventTargetNode>(exec, globalObject);
}

bool JSEventTargetNodePrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSEventTargetNodePrototypeTable, this, propertyName, slot);
}

const ClassInfo JSEventTargetNode::s_info = { "EventTargetNode", &JSNode::s_info, &JSEventTargetNodeTable, 0 };

JSEventTargetNode::JSEventTargetNode(PassRefPtr<Structure> structure, PassRefPtr<EventTargetNode> impl)
    : JSNode(structure, impl)
{
}

JSObject* JSEventTargetNode::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSEventTargetNodePrototype(JSEventTargetNodePrototype::createStructure(JSNodePrototype::self(exec, globalObject)));
}

bool JSEventTargetNode::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventTargetNode, Base>(exec, &JSEventTargetNodeTable, this, propertyName, slot);
}

JSValuePtr jsEventTargetNodeOnabort(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onabort())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnblur(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onblur())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnchange(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onchange())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onclick())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOncontextmenu(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->oncontextmenu())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndblclick(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondblclick())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnerror(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onerror())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnfocus(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onfocus())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOninput(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->oninput())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnkeydown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onkeydown())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnkeypress(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onkeypress())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnkeyup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onkeyup())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onload())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnmousedown(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmousedown())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnmousemove(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmousemove())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnmouseout(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmouseout())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnmouseover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmouseover())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnmouseup(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmouseup())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnmousewheel(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onmousewheel())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnbeforecut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onbeforecut())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOncut(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->oncut())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnbeforecopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onbeforecopy())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOncopy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->oncopy())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnbeforepaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onbeforepaste())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnpaste(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onpaste())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndragenter(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondragenter())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndragover(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondragover())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndragleave(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondragleave())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndrop(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondrop())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndragstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondragstart())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndrag(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondrag())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOndragend(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->ondragend())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnreset(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onreset())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnresize(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onresize())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnscroll(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onscroll())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnsearch(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onsearch())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnselect(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onselect())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnselectstart(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onselectstart())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnsubmit(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onsubmit())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsEventTargetNodeOnunload(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(asObject(slot.slotBase()))->impl());
    if (JSEventListener* listener = static_cast<JSEventListener*>(imp->onunload())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

void JSEventTargetNode::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSEventTargetNode, Base>(exec, propertyName, value, &JSEventTargetNodeTable, this, slot);
}

void setJSEventTargetNodeOnabort(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnabort(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnblur(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnblur(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnchange(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnchange(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnclick(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnclick(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOncontextmenu(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOncontextmenu(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndblclick(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndblclick(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnerror(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnerror(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnfocus(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnfocus(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOninput(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOninput(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnkeydown(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnkeydown(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnkeypress(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnkeypress(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnkeyup(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnkeyup(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnload(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnload(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnmousedown(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmousedown(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnmousemove(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmousemove(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnmouseout(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmouseout(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnmouseover(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmouseover(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnmouseup(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmouseup(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnmousewheel(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmousewheel(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnbeforecut(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnbeforecut(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOncut(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOncut(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnbeforecopy(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOncopy(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOncopy(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnbeforepaste(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnpaste(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnpaste(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndragenter(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragenter(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndragover(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragover(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndragleave(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragleave(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndrop(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndrop(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndragstart(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragstart(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndrag(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndrag(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOndragend(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOndragend(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnreset(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnreset(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnresize(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnresize(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnscroll(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnscroll(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnsearch(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnsearch(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnselect(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnselect(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnselectstart(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnselectstart(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnsubmit(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnsubmit(globalObject->findOrCreateJSEventListener(exec, value, true));
}

void setJSEventTargetNodeOnunload(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    EventTargetNode* imp = static_cast<EventTargetNode*>(static_cast<JSEventTargetNode*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnunload(globalObject->findOrCreateJSEventListener(exec, value, true));
}

JSValuePtr jsEventTargetNodePrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEventTargetNode::s_info))
        return throwError(exec, TypeError);
    JSEventTargetNode* castedThisObj = static_cast<JSEventTargetNode*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValuePtr jsEventTargetNodePrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEventTargetNode::s_info))
        return throwError(exec, TypeError);
    JSEventTargetNode* castedThisObj = static_cast<JSEventTargetNode*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValuePtr jsEventTargetNodePrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSEventTargetNode::s_info))
        return throwError(exec, TypeError);
    JSEventTargetNode* castedThisObj = static_cast<JSEventTargetNode*>(asObject(thisValue));
    EventTargetNode* imp = static_cast<EventTargetNode*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* event = toEvent(args.at(exec, 0));


    JSC::JSValuePtr result = jsBoolean(imp->dispatchEvent(event, ec));
    setDOMException(exec, ec);
    return result;
}

EventTargetNode* toEventTargetNode(JSC::JSValuePtr value)
{
    return value->isObject(&JSEventTargetNode::s_info) ? static_cast<JSEventTargetNode*>(asObject(value))->impl() : 0;
}

}
