/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNavigator.h"

#include <wtf/GetPtr.h>

#include "JSMimeTypeArray.h"
#include "JSPluginArray.h"
#include "KURL.h"
#include "MimeTypeArray.h"
#include "Navigator.h"
#include "PluginArray.h"

#include <runtime/Error.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNavigator)

/* Hash table */

static const HashTableValue JSNavigatorTableValues[15] =
{
    { "appCodeName", DontDelete|ReadOnly, (intptr_t)jsNavigatorAppCodeName, (intptr_t)0 },
    { "appName", DontDelete|ReadOnly, (intptr_t)jsNavigatorAppName, (intptr_t)0 },
    { "appVersion", DontDelete|ReadOnly, (intptr_t)jsNavigatorAppVersion, (intptr_t)0 },
    { "language", DontDelete|ReadOnly, (intptr_t)jsNavigatorLanguage, (intptr_t)0 },
    { "userAgent", DontDelete|ReadOnly, (intptr_t)jsNavigatorUserAgent, (intptr_t)0 },
    { "platform", DontDelete|ReadOnly, (intptr_t)jsNavigatorPlatform, (intptr_t)0 },
    { "plugins", DontDelete|ReadOnly, (intptr_t)jsNavigatorPlugins, (intptr_t)0 },
    { "mimeTypes", DontDelete|ReadOnly, (intptr_t)jsNavigatorMimeTypes, (intptr_t)0 },
    { "product", DontDelete|ReadOnly, (intptr_t)jsNavigatorProduct, (intptr_t)0 },
    { "productSub", DontDelete|ReadOnly, (intptr_t)jsNavigatorProductSub, (intptr_t)0 },
    { "vendor", DontDelete|ReadOnly, (intptr_t)jsNavigatorVendor, (intptr_t)0 },
    { "vendorSub", DontDelete|ReadOnly, (intptr_t)jsNavigatorVendorSub, (intptr_t)0 },
    { "cookieEnabled", DontDelete|ReadOnly, (intptr_t)jsNavigatorCookieEnabled, (intptr_t)0 },
    { "onLine", DontDelete|ReadOnly, (intptr_t)jsNavigatorOnLine, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNavigatorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 511, JSNavigatorTableValues, 0 };
#else
    { 36, 31, JSNavigatorTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSNavigatorPrototypeTableValues[2] =
{
    { "javaEnabled", DontDelete|Function, (intptr_t)jsNavigatorPrototypeFunctionJavaEnabled, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSNavigatorPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSNavigatorPrototypeTableValues, 0 };
#else
    { 2, 1, JSNavigatorPrototypeTableValues, 0 };
#endif

const ClassInfo JSNavigatorPrototype::s_info = { "NavigatorPrototype", 0, &JSNavigatorPrototypeTable, 0 };

JSObject* JSNavigatorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNavigator>(exec, globalObject);
}

bool JSNavigatorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNavigatorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNavigator::s_info = { "Navigator", 0, &JSNavigatorTable, 0 };

JSNavigator::JSNavigator(PassRefPtr<Structure> structure, PassRefPtr<Navigator> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSNavigator::~JSNavigator()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSNavigator::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSNavigatorPrototype(JSNavigatorPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSNavigator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigator, Base>(exec, &JSNavigatorTable, this, propertyName, slot);
}

JSValuePtr jsNavigatorAppCodeName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->appCodeName());
}

JSValuePtr jsNavigatorAppName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->appName());
}

JSValuePtr jsNavigatorAppVersion(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSNavigator*>(asObject(slot.slotBase()))->appVersion(exec);
}

JSValuePtr jsNavigatorLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->language());
}

JSValuePtr jsNavigatorUserAgent(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->userAgent());
}

JSValuePtr jsNavigatorPlatform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->platform());
}

JSValuePtr jsNavigatorPlugins(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->plugins()));
}

JSValuePtr jsNavigatorMimeTypes(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->mimeTypes()));
}

JSValuePtr jsNavigatorProduct(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->product());
}

JSValuePtr jsNavigatorProductSub(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->productSub());
}

JSValuePtr jsNavigatorVendor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->vendor());
}

JSValuePtr jsNavigatorVendorSub(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->vendorSub());
}

JSValuePtr jsNavigatorCookieEnabled(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->cookieEnabled());
}

JSValuePtr jsNavigatorOnLine(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->onLine());
}

JSValuePtr jsNavigatorPrototypeFunctionJavaEnabled(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSNavigator::s_info))
        return throwError(exec, TypeError);
    JSNavigator* castedThisObj = static_cast<JSNavigator*>(asObject(thisValue));
    Navigator* imp = static_cast<Navigator*>(castedThisObj->impl());


    JSC::JSValuePtr result = jsBoolean(imp->javaEnabled());
    return result;
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, Navigator* object)
{
    return getDOMObjectWrapper<JSNavigator>(exec, object);
}
Navigator* toNavigator(JSC::JSValuePtr value)
{
    return value->isObject(&JSNavigator::s_info) ? static_cast<JSNavigator*>(asObject(value))->impl() : 0;
}

}
