/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGBANKPLUGINWIDGET_H
#define SKGBANKPLUGINWIDGET_H
/** @file
* This file is Skrooge plugin for bank management.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
*/
#include "ui_skgbankpluginwidget_base.h"
#include "skgtabpage.h"

#include <QStringList>
#include <QTimer>

class SKGDocumentBank;
class SKGObjectModel;

/**
 * This file is Skrooge plugin for bank management
 */
class SKGBankPluginWidget : public SKGTabPage
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGBankPluginWidget ( SKGDocumentBank* iDocument );

        /**
         * Default Destructor
         */
        virtual ~SKGBankPluginWidget();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState ( const QString& iState );

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttribute();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

private slots:
        void dataModified(const QString& iTableName, int iIdTransaction);
        void onAccountCreatorModified();
        void onAddAccountClicked();
        void onModifyAccountClicked();
        void onDoubleClickedAccount();
        void onSelectionChanged();
        void onFilterChanged();
        void onComputeRIB();
        void onBtnModeClicked();
        void cleanEditor();
        void refreshInfoZone();

private:
        Q_DISABLE_COPY ( SKGBankPluginWidget );

        int getCurrentMode();
        void setCurrentMode(int iMode);

        Ui::skgbankplugin_base ui;;
        SKGObjectModel* objectModel;
        QStringList listBankNumbers;
        int mode;
        QTimer* timer;
};

#endif // SKGDEBUGPLUGIN_H
