/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGCALCULATORPLUGINWIDGET_H
#define SKGCALCULATORPLUGINWIDGET_H
/** @file
 * A skrooge plugin to calculate
*
* @author Stephane MANKOWSKI
*/
#include "ui_skgcalculatorpluginwidget_base.h"
#include "skgtabpage.h"

class SKGObjectModel;

/**
 * A skrooge plugin to calculate
 */
class SKGCalculatorPluginWidget : public SKGTabPage
{
        Q_OBJECT

public:
        /**
         * Default Constructor
         */
        SKGCalculatorPluginWidget(SKGDocument* iDocument);

        /**
         * Default Destructor
         */
        virtual ~SKGCalculatorPluginWidget();

        /**
         * Get the current state
         * MUST BE OVERWRITTEN
         * @return a string containing all information needed to set the same state.
         * Could be an XML stream
         */
        virtual QString getState();

        /**
         * Set the current state
         * MUST BE OVERWRITTEN
         * @param iState must be interpreted to set the state of the widget
         */
        virtual void setState(const QString& iState);

        /**
         * Get attribute name to save the default state
         * MUST BE OVERWRITTEN
         * @return attribute name to save the default state.
         */
        virtual QString getDefaultStateAttribute();

        /**
         * Get the current selection
         * @return selected objects
         */
        virtual SKGObjectBase::SKGListSKGObjectBase getSelectedObjects();

        /**
         * Get the number of seleted object
         * @return number of selected objects
         */
        virtual int getNbSelectedObjects();

        /**
         * Get the widget must be printed
         * @return a widget
         */
        virtual QWidget* getWidgetForPrint();

private slots:
        void dataModified(const QString& iTableName, int iIdTransaction);
        void onBtnModeClicked();
        void onCalculatorReturnPressed(const QString& iText);
        void onCalculatorListClicked(const QString& iText);
        void onSelectionChanged();
        void onAdd();
        void onUpdate();
        void onFilterChanged();
        void onSelectedInterestChanged();

private:
        Q_DISABLE_COPY(SKGCalculatorPluginWidget);
        int getCurrentMode();
        void setCurrentMode(int iMode);
        void computeInterest();

        int mode;
        Ui::skgcalculatorplugin_base ui;

        SKGObjectModel* objectModel;
};

#endif // SKGCALCULATORPLUGINWIDGET_H
