/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A dashboard for skrooge
 *
 * @author Stephane MANKOWSKI
 */
#include "skgdashboardplugin.h"
#include "skgdashboardpluginwidget.h"
#include "skgdashboard_settings.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGDashboardPluginFactory, registerPlugin<SKGDashboardPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGDashboardPluginFactory("skrooge_dashboard", "skrooge_dashboard"))

SKGDashboardPlugin::SKGDashboardPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGDashboardPlugin::SKGDashboardPlugin");
}

SKGDashboardPlugin::~SKGDashboardPlugin()
{
        SKGTRACEIN(10, "SKGDashboardPlugin::~SKGDashboardPlugin");
        currentBankDocument=NULL;
}

void SKGDashboardPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGDashboardPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;


        setComponentData( SKGDashboardPluginFactory::componentData() );
        setXMLFile("skrooge_dashboard.rc");

        //Create yours actions here
}

void SKGDashboardPlugin::refresh()
{
        SKGTRACEIN(10, "SKGDashboardPlugin::refresh");
}

void SKGDashboardPlugin::close()
{
        SKGTRACEIN(10, "SKGDashboardPlugin::close");
}

SKGTabPage* SKGDashboardPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGDashboardPlugin::getWidget");
        return new SKGDashboardPluginWidget(currentBankDocument);
}

QWidget* SKGDashboardPlugin::getPreferenceWidget()
{
        SKGTRACEIN(10, "SKGDashboardPlugin::getPreferenceWidget");
/*        QWidget* widget=new QWidget();
        ui.setupUi(widget);*/

        return NULL;
}

KConfigSkeleton* SKGDashboardPlugin::getPreferenceSkeleton()
{
        return skgdashboard_settings::self();
}

QString SKGDashboardPlugin::title() const
{
        return i18nc("Noun, a summary of your financial situation","Dashboard");
}

QString SKGDashboardPlugin::icon() const
{
        return "go-home";
}

QString SKGDashboardPlugin::toolTip () const
{
        return i18nc("Noun, a summary of your financial situation","Dashboard");
}


int SKGDashboardPlugin::getOrder() const
{
        return 8;
}

QStringList SKGDashboardPlugin::tips() const
{
        QStringList output;
        output.push_back(i18n("<p>... the dashboard is there to give you a summary of your situation.</p>"));
        return output;
}

bool SKGDashboardPlugin::isInContext() const
{
        return true;
}

#include "skgdashboardplugin.moc"
