/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/

#include "skgcorona.h"
#include <kaction.h>

#include <plasma/containment.h>
#include <plasma/view.h>


SKGCorona::SKGCorona(QObject* parent): Corona(parent)
{
    skgContainment = addContainment("overallContainment");
    Plasma::View* skgView = new Plasma::View(skgContainment);
    
    // Add a dummy applet, just for the fun of it
    skgContainment->addApplet("calculator");
    
    // Set up the containment
    QSizeF parentSize = qobject_cast< const QWidget* >(parent)->size();
    skgContainment->resize(parentSize.width()/3,parentSize.height());
    
    setupActions();
    
}


void SKGCorona::setupActions()
{
    KAction* unlock = new KAction(KIcon("document-decrypt"),i18n("Unlock Skroogoids"),this);
    skgContainment->addToolBoxAction(unlock);


}



