/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * ##DESCRIPTION##
 *
 * @author ##AUTHOR##
 */
#include "skgxxxplugin.h"
#include "skgxxxpluginwidget.h"
#include "skgxxx_settings.h"
#include "skgtraces.h"

#include <kactioncollection.h>
#include <kstandardaction.h>

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGXXXPluginFactory, registerPlugin<SKGXXXPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGXXXPluginFactory("skrooge_xxx", "skrooge_xxx"))

SKGXXXPlugin::SKGXXXPlugin(QObject* iParent, const QVariantList& /*iArg*/) : SKGInterfacePlugin(iParent)
{
        SKGTRACEIN(10, "SKGXXXPlugin::SKGXXXPlugin");
}

SKGXXXPlugin::~SKGXXXPlugin()
{
        SKGTRACEIN(10, "SKGXXXPlugin::~SKGXXXPlugin");
        currentBankDocument=NULL;
}

void SKGXXXPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
        SKGTRACEIN(10, "SKGXXXPlugin::setupActions");
        Q_UNUSED(iArgument);

        currentBankDocument=iDocument;


        setComponentData( SKGXXXPluginFactory::componentData() );
        setXMLFile("skrooge_xxx.rc");

        //Create yours actions here
}

void SKGXXXPlugin::refresh()
{
        SKGTRACEIN(10, "SKGXXXPlugin::refresh");
}

void SKGXXXPlugin::close()
{
        SKGTRACEIN(10, "SKGXXXPlugin::close");
}

SKGTabPage* SKGXXXPlugin::getWidget()
{
        SKGTRACEIN(10, "SKGXXXPlugin::getWidget");
        return new SKGXXXPluginWidget(currentBankDocument);
}

QWidget* SKGXXXPlugin::getPreferenceWidget()
{
        SKGTRACEIN(10, "SKGXXXPlugin::getPreferenceWidget");
        QWidget* widget=new QWidget();
        ui.setupUi(widget);

        return widget;
}

KConfigSkeleton* SKGXXXPlugin::getPreferenceSkeleton()
{
        return skgxxx_settings::self();
}

SKGError SKGXXXPlugin::savePreferences() const
{
        return SKGError();
}

QString SKGXXXPlugin::title() const
{
        return i18n("xxx"); //TODO MUST BE CHANGED
}

QString SKGXXXPlugin::icon() const
{
        return "dialog-information";//TODO MUST BE CHANGED
}

QString SKGXXXPlugin::toolTip () const
{
        return i18n("xxx");//TODO MUST BE CHANGED
}


int SKGXXXPlugin::getOrder() const
{
        return 999;
}

QStringList SKGXXXPlugin::tips() const
{
        QStringList output;
        output.push_back(i18n("<p>... xxx is the best plugin of the world</p>")); //TODO MUST BE CHANGED
        return output;
}

bool SKGXXXPlugin::isInContext() const
{
        return true;
}

#include "skgxxxplugin.moc"
