/*
 * Photo Image Print System
 * Copyright (C) 2000-2005 EPSON AVASYS Corporation.
 * Copyright (C) SEIKO EPSON CORPORATION 2000-2005.
 *
 *  This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, EPSON AVASYS Corporation gives permission to
 * link the code of this program with libraries which are covered by
 * the EPSON AVASYS Public License and distribute their linked
 * combinations.  You must obey the GNU General Public License in all
 * respects for all of the code used other than the libraries which
 * are covered by EPSON AVASYS Public License.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include "pipsError.h"

int pipsError(char *edata, int ecode){

  if(ecode == NO_ERROR) return 0;

  fprintf(stderr, _("ERROR : "));

  if(ecode == RESOURCE_ERROR){
    fprintf(stderr, _("Line %s : Resource file file format error\n"), edata);
    return 0;
  }

  if(edata != NULL) fprintf(stderr, "%s : ", edata);

  switch(ecode){

  case NO_OPTION_ERROR:
    fprintf(stderr, _("Invalid option\n"));
    break;

  case OPTION_LESS_ERROR:
  case OPTION_VALUES_ERROR:
    fprintf(stderr, _(" Option value is incorrect\n"));
    break;

  case DUB_FILENAME_ERROR:
    fprintf(stderr, _("Too many input files\n"));
    break;

  case CONNECTION_ERROR:
    fprintf(stderr, _("Illegal option combination\n"));
    break;

  case RESOURCE_FORM_ERROR:
    fprintf(stderr, _("Command line is incorrect\n"));
    break;

  case NO_RESOURCE_ERROR:
    fprintf(stderr, _("The resource does not exist\n"));
    break;

  case RESOURCE_LESS_ERROR:
  case RESOURCE_VALUES_ERROR:
    fprintf(stderr, _("Resource value is incorrect\n"));
    break;

  case GRAPHICS_LOAD_ERROR:
    fprintf(stderr, _("Failed in the load of a graphics\n"));
    break;

  case NO_SUCH_LIBRARY:
  case NO_FILE_ERROR:
    fprintf(stderr, _("Can not open file\n"));
    break;

  case FAILED_FILE_ERROR:
    fprintf(stderr, _("Can not open file\n"));
    break;

  case GRAPHICS_FORMAT_ERROR:
    fprintf(stderr, _("The data format is unsupported\n"));
    break;

  case NOT_COMMUNICATE_LPR_ERROR:
    fprintf(stderr, _("lpr command failed\n"));
    break;

  case LIBRARY_PARAM_ERROR:
    fprintf(stderr, _("The parameter of library is wrong\n"));
    break;

  case MEMORY_ERROR:
    fprintf(stderr, _("Out of memory\n"));
    break;
    
  case UNEXPECTED_ERROR:
    fprintf(stderr, _("Unexpected error\n"));
    break;

  case ABNORMAL_END:
    fprintf(stderr, _("...ABEND\n"));
    break;

  default:
	fprintf( stderr, _("Unknown error occurd(%d).\n"), ecode ); 
	break;
  }
  if ( stderr )
    fflush( stderr );
  return ecode;
}

