/* decodeselfid.c
 * written 19.10.1999 - 20.10.1999 by Andreas Micklei
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "decodeselfid.h"

void printbin(unsigned int i, unsigned char width) {
	int j;
	for (j=0; j<width; j++) {
		printf("%i", (i & (1<<(width-1)))>>(width-1));
		i = i << 1;
	}
}

unsigned int bit_extract(unsigned int shift, unsigned int width, unsigned int i)
{
	unsigned int mask = 0;
	while (width>0) {
		mask=mask<<1;
		mask++;
		width--;
	}
	return (i >> shift) & mask;
}

int decode_selfid(SelfIdPacket_t *selfid, unsigned int i) {
	selfid->packetZero.designator = bit_extract(SHIFT_START, WIDTH_START, i);
	selfid->packetZero.phyID = bit_extract(SHIFT_PHY_ID, WIDTH_PHY_ID, i);
	selfid->packetZero.ZeroOrMore = bit_extract(SHIFT_CONT, WIDTH_CONT, i);
	selfid->packetZero.linkActive = bit_extract(SHIFT_L, WIDTH_L, i);
	selfid->packetZero.gapCount = bit_extract(SHIFT_GAP_CNT, WIDTH_GAP_CNT, i);
	selfid->packetZero.phySpeed = bit_extract(SHIFT_SP, WIDTH_SP, i);
	selfid->packetZero.phyDelay = bit_extract(SHIFT_DEL, WIDTH_DEL, i);
	selfid->packetZero.contender = bit_extract(SHIFT_C, WIDTH_C, i);
	selfid->packetZero.powerClass = bit_extract(SHIFT_PWR, WIDTH_PWR, i);
	selfid->packetZero.port0 = bit_extract(SHIFT_P0, WIDTH_P0, i);
	selfid->packetZero.port1 = bit_extract(SHIFT_P1, WIDTH_P1, i);
	selfid->packetZero.port2 = bit_extract(SHIFT_P2, WIDTH_P2, i);
	selfid->packetZero.initiatedReset = bit_extract(SHIFT_I, WIDTH_I, i);
	selfid->packetZero.morePackets = bit_extract(SHIFT_M, WIDTH_M, i);
	if (selfid->packetZero.designator != 2) return -1;
	if (selfid->packetZero.morePackets == 1) return -2;
	else return 0;
}

char *yes_no(unsigned char i) {
	if (i) return "Yes";
	else return "No";
}

char *decode_speed(unsigned char i) {
	if (i == 0) return "S100";
	if (i == 1) return "S200";
	if (i == 2) return "S400";
	if (i == 3) return "Unknown";
	else return "Error";
}

char *decode_delay(unsigned char i) {
	if (i == 0) return "<=144ns";
	else return "Unknown";
}

char *decode_pwr(unsigned char i) {
	if (i == 0) return "None";
	if (i == 1) return "+15W";
	if (i == 2) return "+30W";
	if (i == 3) return "+45W";
	if (i == 4) return "-1W";
	if (i == 5) return "-3W";
	if (i == 6) return "-6W";
	if (i == 7) return "-10W";
	else return "Error";
}

char *decode_port_status(unsigned char i) {
	if (i == 3) return "Connected to child node";
	if (i == 2) return "Connected to parent node";
	if (i == 1) return "Not connected";
	if (i == 0) return "Not present";
	return "Unknown";
}

void print_selfid(SelfIdPacket_t *selfid) {
	printf("Physical ID:\t%i (0x%x)\n",selfid->packetZero.phyID,selfid->packetZero.phyID);
	printf("  Link active:\t%s\n",yes_no(selfid->packetZero.linkActive));
	printf("  Gap Count:\t%i\n",selfid->packetZero.gapCount);
	printf("  PHY Speed:\t%s\n",decode_speed(selfid->packetZero.phySpeed));
	printf("  PHY Delay:\t%s\n",decode_delay(selfid->packetZero.phyDelay));
	printf("  IRM Capable:\t%s\n",yes_no(selfid->packetZero.contender));
	printf("  Power Class:\t%s\n",decode_pwr(selfid->packetZero.powerClass));
	printf("  Port 0:\t%s\n",decode_port_status(selfid->packetZero.port0));
	printf("  Port 1:\t%s\n",decode_port_status(selfid->packetZero.port1));
	printf("  Port 2:\t%s\n",decode_port_status(selfid->packetZero.port2));
	printf("  Init. reset:\t%s\n",yes_no(selfid->packetZero.initiatedReset));
}

