/* decodeselfid.h
 * written 19.10.1999 - 20.19.1999 by Andreas Micklei
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __DECODESELFID_H__
#define __DECODESELFID_H__

#include "raw1394support.h"
#include <raw1394.h>
#include <stdio.h>

#define SHIFT_START	30
#define WIDTH_START	2
#define SHIFT_PHY_ID	24
#define WIDTH_PHY_ID	6
#define SHIFT_CONT	23
#define WIDTH_CONT	1
#define SHIFT_L		22
#define WIDTH_L		1
#define SHIFT_GAP_CNT	16
#define WIDTH_GAP_CNT	6
#define SHIFT_SP	14
#define WIDTH_SP	2
#define SHIFT_DEL	12
#define WIDTH_DEL	2
#define SHIFT_C		11
#define WIDTH_C		1
#define SHIFT_PWR	8
#define WIDTH_PWR	3
#define SHIFT_P0	6
#define WIDTH_P0	2
#define SHIFT_P1	4
#define WIDTH_P1	2
#define SHIFT_P2	2
#define WIDTH_P2	2
#define SHIFT_I		1
#define WIDTH_I		1
#define SHIFT_M		0
#define WIDTH_M		1

void printbin(unsigned int i, unsigned char width);

int decode_selfid(SelfIdPacket_t *selfid, unsigned int i);

char *yes_no(unsigned char i);

char *decode_speed(unsigned char i);

char *decode_delay(unsigned char i);

char *decode_pwr(unsigned char i);

char *decode_port_status(unsigned char i);

void print_selfid(SelfIdPacket_t *selfid);

#endif

