/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information
    
    A huge THANKS to:
    
        * Marcin Wiacek and the gammu developers
          for gammu ;-)
        
        * the amaroK development sqad
          for inspiration on the summary page
        
        * the kopete developers
          for the system tray notification balloon
          
        * Igor Palkin
          for KPM and sharing it with us :-)
          hopefully we will find a way to share our
          efforts in the future.
*/
    
#include "kammu.h"
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("Mobile management tool for KDE");

static const char version[] = "0.1";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kammu", I18N_NOOP("Kammu"), version, description,
                     KAboutData::License_GPL, "(C) 2004 Stefan Bogner", 0, 0, "bochi@online.ms");
    about.addAuthor( "Stefan Bogner", 0, "bochi@online.ms" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication app;

    if (app.isRestored())
    {
        RESTORE(Kammu);
    }
    else
    {
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            Kammu *widget = new Kammu;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                Kammu *widget = new Kammu;
                widget->show();
            }
        }
        args->clear();
    }

    return app.exec();
}

