/* (c) 2004 Stefan Bogner <bochi@online.ms>
    See COPYING file for licensing information */
    
#include "kammu.h"
#include "settings.h"
#include "configdialog.h"
#include "statusbar.h"
#include "trayicon.h"

#include <qdragobject.h>
#include <qfile.h>
#include <qtextstream.h>
#include <kprinter.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>

#include <kconfigdialog.h>
#include <kdebug.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kdeversion.h>
#include <kmenubar.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kmessagebox.h>
#include <kprogress.h>

Kammu::Kammu()
    : KMainWindow( 0, "Kammu" )
    , m_view(new KammuMain(this))
    , m_statusbar(new StatusBar::StatusBar(this))
    , m_trayicon(new TrayIcon(this))
      
{
    KammuConfig::setConnected( false );
    setAcceptDrops(true);
    setCentralWidget(m_view);
    setupActions();
    m_statusbar->show();
    if( KammuConfig::showSystray() ) m_trayicon->show();
    setAutoSaveSettings();
    
    connect(m_view, SIGNAL(signalChangeStatusbarMessage(const QString&)),
            m_statusbar,   SLOT(message(const QString&)));
    connect(m_view, SIGNAL(signalChangeStatusbarProgress( int, int, QString )),
            m_statusbar,   SLOT(progress( int, int, QString )));
    
    connect( m_view, SIGNAL( signalClose( QWidget*, QEvent* ) ), this, SLOT( keepTray( QWidget*, QEvent* ) ) );
    
    connect( m_view, SIGNAL( signalNotification( int, QString, QString ) ), m_trayicon, SLOT( notify( int, QString, QString )));
    
     connect ( m_view , SIGNAL( signalOperationInProgress(int)) , this , SLOT(operationInProgress(int)));
     
     connect( m_view , SIGNAL( signalOpProgressSetup(int)) , this , SLOT(setupOpProgress( int )));
     
     connect ( m_view , SIGNAL( signalOpIncProgress()) , this , SLOT( incOpProgress() ));
     
    KPopupMenu* menu = m_trayicon->contextMenu();
    menu->insertItem( "Configure Kammu...", this, SLOT(optionsPreferences()) );
    
    m_view->initPhone();
}

Kammu::~Kammu()
{
}

void Kammu::setupActions()
{
    KStdAction::quit(kapp, SLOT(quit()), actionCollection());

    m_toolbarAction = KStdAction::showToolbar(this, SLOT(optionsShowToolbar()), actionCollection());
    m_statusbarAction = KStdAction::showStatusbar(this, SLOT(optionsShowStatusbar()), actionCollection());

    KStdAction::keyBindings(this, SLOT(optionsConfigureKeys()), actionCollection());
    KStdAction::configureToolbars(this, SLOT(optionsConfigureToolbars()), actionCollection());
    KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());
    
    createGUI();
}

void Kammu::optionsShowToolbar()
{
    if (m_toolbarAction->isChecked())
        toolBar()->show();
    else
        toolBar()->hide();
}

void Kammu::optionsShowStatusbar()
{
    if (m_statusbarAction->isChecked())
        statusBar()->show();
    else
        statusBar()->hide();
}

void Kammu::optionsConfigureKeys()
{
    KKeyDialog::configure(actionCollection());
}

void Kammu::optionsConfigureToolbars()
{
    saveMainWindowSettings(KGlobal::config(), autoSaveGroup());
}

void Kammu::newToolbarConfig()
{
    createGUI();
    applyMainWindowSettings(KGlobal::config(), autoSaveGroup());
}

void Kammu::optionsPreferences()
{
    KConfigDialog *dialog = KConfigDialog::exists( "settings" );
    if( !dialog ) dialog = new ConfigDialog( m_view, "settings", KammuConfig::self() );
    connect( dialog, SIGNAL(settingsChanged()), SLOT(settingsChanged()));
    dialog->show();
}

void Kammu::settingsChanged()
{
    m_view->setStyleSheet();
    m_view->writeToBrowser();
    m_trayicon->setShown( KammuConfig::showSystray() );
}

void Kammu::changeCaption(const QString& text)
{
    setCaption(text);
}

void Kammu::keepTray( QWidget *widget, QEvent *event )
{
        
    static_cast<QCloseEvent*>(event)->accept();
    
    if( KammuConfig::showSystray() ) {
        
        KMessageBox::information( widget,
        i18n( "<qt>Closing the main-window will keep kammu running in the System Tray. "
              "Use <B>Quit</B> from the menu, or the tray-icon to exit kammu.</qt>" ),
        i18n( "Docking in System Tray" ), "hideOnCloseInfo" );
        widget->hide();
    }
    else close();
}


#include "kammu.moc"



/*!
    \fn Kammu::setupOpProgress(int p)
 */
void Kammu::setupOpProgress(int p)
{
    /// @todo implement me
    m_statusbar->opProgress->setTotalSteps(p);
    m_statusbar->opProgress->setProgress(0);
    m_statusbar->opProgress->show();
}


/*!
    \fn Kammu::operationInProgress(int)
 */
void Kammu::operationInProgress(int p)
{
    /// @todo implement me
    m_statusbar->opProgress->setProgress(p);
    if ( p == m_statusbar->opProgress->totalSteps()) m_statusbar->opProgress->hide();
}


/*!
    \fn Kammu::incOpProgress()
 */
void Kammu::incOpProgress()
{
    /// @todo implement me
}
