#ifndef PARAM_CONVERSION_H
#define PARAM_CONVERSION_H

#include <string>
#include <vector>

const char *parameter2word(const char *cstring);
double parameter2double(const char *cstring);
int parameter2int(const char *cstring);
long parameter2long(const char *cstring);
size_t parameter2sizet(const char *cstring);
int parameter2intlist(const char *cstring);

const std::string &parameter2word(const std::string &string);
double parameter2double(const std::string &string);
bool parameter2bool(const std::string &string);
int parameter2int(const std::string &string);
long parameter2long(const std::string &string);
size_t parameter2sizet(const std::string &string);
int parameter2intlist(const std::string &string);

double radius_str_to_deg(const char *string);

int stringToParam(const std::string &paramstr);
int stringToParam(const char *paramstr);
void paramToString(int param, char *paramstr, int maxlen);

/* time/date/season converisons */
/* =================================================================================== */
void season_to_months(const char *season, int *imonths);
double datestrToDouble(const char *datestr, int opt);

/* argv conversions */
std::vector<int> cdoArgvToInt(const std::vector<std::string> &argv);
std::vector<double> cdoArgvToFlt(const std::vector<std::string> &argv);

void split_intstring(const std::string &intstr, int &first, int &last, int &inc);
void split_intstring(const char *intstr, int &first, int &last, int &inc);

#endif
