/* $Id: splice.h 224745 2021-12-04 15:54:54Z twu $ */
#ifndef SPLICE_INCLUDED
#define SPLICE_INCLUDED

typedef struct Spliceinfo_T *Spliceinfo_T;

#include "bool.h"
#include "types.h"	/* For Splicetype_T */
#include "list.h"
#include "method.h"
#include "chrnum.h"
#include "genomicpos.h"
#include "compress.h"
#include "genome.h"
#include "indel.h"


struct Spliceinfo_T {
  int *int_memory;

  int *donor_positions_alloc;
  int *donor_knowni_alloc;
  int *acceptor_positions_alloc;
  int *acceptor_knowni_alloc;

  int *segmenti_donor_knownpos;
  int *segmentj_acceptor_knownpos;
  int *segmentj_antidonor_knownpos;
  int *segmenti_antiacceptor_knownpos;

  int *segmenti_donor_knowni;
  int *segmentj_acceptor_knowni;
  int *segmentj_antidonor_knowni;
  int *segmenti_antiacceptor_knowni;

  int *saved_knowni_i;
  int *saved_knowni_j;
  int *saved_segmenti_nmismatches;
  int *saved_segmentj_nmismatches;
  int *saved_segmenti_ref_nmismatches;
  int *saved_segmentj_ref_nmismatches;

  int *ambig_qstarts;
  int *ambig_qends;

  int segmenti_donor_nknown;
  int segmentj_acceptor_nknown;
  int segmentj_antidonor_nknown;
  int segmenti_antiacceptor_nknown;


  double *double_memory;

  double *donor_probs_alloc;
  double *acceptor_probs_alloc;

  double *saved_probi;
  double *saved_probj;

  double *ambig_probs_5;
  double *ambig_probs_3;
};


extern void
Splice_setup (Genome_T genomebits_in, Genome_T genomebits_alt_in,
	      bool novelsplicingp_in, int min_shortend_in);

extern void
Spliceinfo_free (Spliceinfo_T *old);

extern Spliceinfo_T
Spliceinfo_new (int querylength);

extern int
Splice_resolve_sense (int *best_nindels, int *best_indel_pos, int *best_knowni_i, int *best_knowni_j,
		      int *best_nmismatches_i, int *best_nmismatches_j, int *best_nmismatches_indel,
		      int *best_ref_nmismatches_i, int *best_ref_nmismatches_j,
		      int *best_ref_nmismatches_indel, double *best_prob_i, double *best_prob_j,

		      Univcoord_T segmenti_left, Univcoord_T segmentj_left, Univcoord_T chroffset,
		     
		      int pos5, int pos3, int querylength, Compress_T query_compress,
		      Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
		      bool plusp, int genestrand, int max_deletionlen, int max_insertionlen,
		      bool allow_indel_p);

extern int
Splice_resolve_antisense (int *best_nindels, int *best_indel_pos, int *best_knowni_i, int *best_knowni_j,
			  int *best_nmismatches_i, int *best_nmismatches_j, int *best_nmismatches_indel,
			  int *best_ref_nmismatches_i, int *best_ref_nmismatches_j,
			  int *best_ref_nmismatches_indel, double *best_prob_i, double *best_prob_j,
			  
			  Univcoord_T segmenti_left, Univcoord_T segmentj_left, Univcoord_T chroffset,
			  
			  int pos5, int pos3, int querylength, Compress_T query_compress,
			  Indelinfo_T indelinfo, Spliceinfo_T spliceinfo,
			  bool plusp, int genestrand, int max_deletionlen, int max_insertionlen,
			  bool allow_indel_p);

extern int
Splice_resolve_distant (int *best_nmismatches_i, int *best_nmismatches_j,
			double *best_prob_i, double *best_prob_j, int *sensedir_distant_guess,

			int *mismatch_positions_i, int segmenti_nmismatches,
			int *mismatch_positions_j, int segmentj_nmismatches,

			Univcoord_T segmenti_left, Univcoord_T segmentj_left,
			Univcoord_T segmenti_chroffset, Univcoord_T segmentj_chroffset,

			int pos5, int pos3, int splice_pos_start, int splice_pos_end, int querylength,
			bool plusp_i, bool plusp_j);

extern int
Splice_trim_novel_spliceends_5 (Splicetype_T *splicetype, Spliceinfo_T spliceinfo,
				int *found_sensedir, int try_sensedir,
				Univcoord_T left, int qstart, int qend,
				int *mismatch_positions, int nmismatches,
				Univcoord_T chroffset, double end_splicesite_prob_match,
				int max_nconsecutive, bool plusp);

extern int
Splice_trim_novel_spliceends_3 (Splicetype_T *splicetype, Spliceinfo_T spliceinfo,
				int *found_sensedir, int try_sensedir,
				Univcoord_T left, int qstart, int qend, int querylength,
				int *mismatch_positions, int nmismatches,
				Univcoord_T chroffset, double end_splicesite_prob_match,
				int max_nconsecutive, bool plusp);

#endif

