// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotdataplane

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opDeleteThingShadow = "DeleteThingShadow"

// DeleteThingShadowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteThingShadow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteThingShadow for more information on using the DeleteThingShadow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteThingShadowRequest method.
//	req, resp := client.DeleteThingShadowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *IoTDataPlane) DeleteThingShadowRequest(input *DeleteThingShadowInput) (req *request.Request, output *DeleteThingShadowOutput) {
	op := &request.Operation{
		Name:       opDeleteThingShadow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/things/{thingName}/shadow",
	}

	if input == nil {
		input = &DeleteThingShadowInput{}
	}

	output = &DeleteThingShadowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteThingShadow API operation for AWS IoT Data Plane.
//
// Deletes the shadow for the specified thing.
//
// Requires permission to access the DeleteThingShadow (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
//
// For more information, see DeleteThingShadow (http://docs.aws.amazon.com/iot/latest/developerguide/API_DeleteThingShadow.html)
// in the IoT Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Data Plane's
// API operation DeleteThingShadow for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - UnauthorizedException
//     You are not authorized to perform this operation.
//
//   - ServiceUnavailableException
//     The service is temporarily unavailable.
//
//   - InternalFailureException
//     An unexpected error has occurred.
//
//   - MethodNotAllowedException
//     The specified combination of HTTP verb and URI is not supported.
//
//   - UnsupportedDocumentEncodingException
//     The document encoding is not supported.
func (c *IoTDataPlane) DeleteThingShadow(input *DeleteThingShadowInput) (*DeleteThingShadowOutput, error) {
	req, out := c.DeleteThingShadowRequest(input)
	return out, req.Send()
}

// DeleteThingShadowWithContext is the same as DeleteThingShadow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteThingShadow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) DeleteThingShadowWithContext(ctx aws.Context, input *DeleteThingShadowInput, opts ...request.Option) (*DeleteThingShadowOutput, error) {
	req, out := c.DeleteThingShadowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRetainedMessage = "GetRetainedMessage"

// GetRetainedMessageRequest generates a "aws/request.Request" representing the
// client's request for the GetRetainedMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRetainedMessage for more information on using the GetRetainedMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRetainedMessageRequest method.
//	req, resp := client.GetRetainedMessageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *IoTDataPlane) GetRetainedMessageRequest(input *GetRetainedMessageInput) (req *request.Request, output *GetRetainedMessageOutput) {
	op := &request.Operation{
		Name:       opGetRetainedMessage,
		HTTPMethod: "GET",
		HTTPPath:   "/retainedMessage/{topic}",
	}

	if input == nil {
		input = &GetRetainedMessageInput{}
	}

	output = &GetRetainedMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRetainedMessage API operation for AWS IoT Data Plane.
//
// Gets the details of a single retained message for the specified topic.
//
// This action returns the message payload of the retained message, which can
// incur messaging costs. To list only the topic names of the retained messages,
// call ListRetainedMessages (/iot/latest/developerguide/API_iotdata_ListRetainedMessages.html).
//
// Requires permission to access the GetRetainedMessage (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleethubfordevicemanagement.html#awsiotfleethubfordevicemanagement-actions-as-permissions)
// action.
//
// For more information about messaging costs, see Amazon Web Services IoT Core
// pricing - Messaging (http://aws.amazon.com/iot-core/pricing/#Messaging).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Data Plane's
// API operation GetRetainedMessage for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - UnauthorizedException
//     You are not authorized to perform this operation.
//
//   - ServiceUnavailableException
//     The service is temporarily unavailable.
//
//   - InternalFailureException
//     An unexpected error has occurred.
//
//   - MethodNotAllowedException
//     The specified combination of HTTP verb and URI is not supported.
func (c *IoTDataPlane) GetRetainedMessage(input *GetRetainedMessageInput) (*GetRetainedMessageOutput, error) {
	req, out := c.GetRetainedMessageRequest(input)
	return out, req.Send()
}

// GetRetainedMessageWithContext is the same as GetRetainedMessage with the addition of
// the ability to pass a context and additional request options.
//
// See GetRetainedMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) GetRetainedMessageWithContext(ctx aws.Context, input *GetRetainedMessageInput, opts ...request.Option) (*GetRetainedMessageOutput, error) {
	req, out := c.GetRetainedMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetThingShadow = "GetThingShadow"

// GetThingShadowRequest generates a "aws/request.Request" representing the
// client's request for the GetThingShadow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetThingShadow for more information on using the GetThingShadow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetThingShadowRequest method.
//	req, resp := client.GetThingShadowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *IoTDataPlane) GetThingShadowRequest(input *GetThingShadowInput) (req *request.Request, output *GetThingShadowOutput) {
	op := &request.Operation{
		Name:       opGetThingShadow,
		HTTPMethod: "GET",
		HTTPPath:   "/things/{thingName}/shadow",
	}

	if input == nil {
		input = &GetThingShadowInput{}
	}

	output = &GetThingShadowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetThingShadow API operation for AWS IoT Data Plane.
//
// Gets the shadow for the specified thing.
//
// Requires permission to access the GetThingShadow (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
//
// For more information, see GetThingShadow (http://docs.aws.amazon.com/iot/latest/developerguide/API_GetThingShadow.html)
// in the IoT Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Data Plane's
// API operation GetThingShadow for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - UnauthorizedException
//     You are not authorized to perform this operation.
//
//   - ServiceUnavailableException
//     The service is temporarily unavailable.
//
//   - InternalFailureException
//     An unexpected error has occurred.
//
//   - MethodNotAllowedException
//     The specified combination of HTTP verb and URI is not supported.
//
//   - UnsupportedDocumentEncodingException
//     The document encoding is not supported.
func (c *IoTDataPlane) GetThingShadow(input *GetThingShadowInput) (*GetThingShadowOutput, error) {
	req, out := c.GetThingShadowRequest(input)
	return out, req.Send()
}

// GetThingShadowWithContext is the same as GetThingShadow with the addition of
// the ability to pass a context and additional request options.
//
// See GetThingShadow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) GetThingShadowWithContext(ctx aws.Context, input *GetThingShadowInput, opts ...request.Option) (*GetThingShadowOutput, error) {
	req, out := c.GetThingShadowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListNamedShadowsForThing = "ListNamedShadowsForThing"

// ListNamedShadowsForThingRequest generates a "aws/request.Request" representing the
// client's request for the ListNamedShadowsForThing operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamedShadowsForThing for more information on using the ListNamedShadowsForThing
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNamedShadowsForThingRequest method.
//	req, resp := client.ListNamedShadowsForThingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *IoTDataPlane) ListNamedShadowsForThingRequest(input *ListNamedShadowsForThingInput) (req *request.Request, output *ListNamedShadowsForThingOutput) {
	op := &request.Operation{
		Name:       opListNamedShadowsForThing,
		HTTPMethod: "GET",
		HTTPPath:   "/api/things/shadow/ListNamedShadowsForThing/{thingName}",
	}

	if input == nil {
		input = &ListNamedShadowsForThingInput{}
	}

	output = &ListNamedShadowsForThingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamedShadowsForThing API operation for AWS IoT Data Plane.
//
// Lists the shadows for the specified thing.
//
// Requires permission to access the ListNamedShadowsForThing (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Data Plane's
// API operation ListNamedShadowsForThing for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource does not exist.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - UnauthorizedException
//     You are not authorized to perform this operation.
//
//   - ServiceUnavailableException
//     The service is temporarily unavailable.
//
//   - InternalFailureException
//     An unexpected error has occurred.
//
//   - MethodNotAllowedException
//     The specified combination of HTTP verb and URI is not supported.
func (c *IoTDataPlane) ListNamedShadowsForThing(input *ListNamedShadowsForThingInput) (*ListNamedShadowsForThingOutput, error) {
	req, out := c.ListNamedShadowsForThingRequest(input)
	return out, req.Send()
}

// ListNamedShadowsForThingWithContext is the same as ListNamedShadowsForThing with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamedShadowsForThing for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) ListNamedShadowsForThingWithContext(ctx aws.Context, input *ListNamedShadowsForThingInput, opts ...request.Option) (*ListNamedShadowsForThingOutput, error) {
	req, out := c.ListNamedShadowsForThingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRetainedMessages = "ListRetainedMessages"

// ListRetainedMessagesRequest generates a "aws/request.Request" representing the
// client's request for the ListRetainedMessages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRetainedMessages for more information on using the ListRetainedMessages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRetainedMessagesRequest method.
//	req, resp := client.ListRetainedMessagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *IoTDataPlane) ListRetainedMessagesRequest(input *ListRetainedMessagesInput) (req *request.Request, output *ListRetainedMessagesOutput) {
	op := &request.Operation{
		Name:       opListRetainedMessages,
		HTTPMethod: "GET",
		HTTPPath:   "/retainedMessage",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRetainedMessagesInput{}
	}

	output = &ListRetainedMessagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRetainedMessages API operation for AWS IoT Data Plane.
//
// Lists summary information about the retained messages stored for the account.
//
// This action returns only the topic names of the retained messages. It doesn't
// return any message payloads. Although this action doesn't return a message
// payload, it can still incur messaging costs.
//
// To get the message payload of a retained message, call GetRetainedMessage
// (https://docs.aws.amazon.com/iot/latest/developerguide/API_iotdata_GetRetainedMessage.html)
// with the topic name of the retained message.
//
// Requires permission to access the ListRetainedMessages (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotfleethubfordevicemanagement.html#awsiotfleethubfordevicemanagement-actions-as-permissions)
// action.
//
// For more information about messaging costs, see Amazon Web Services IoT Core
// pricing - Messaging (http://aws.amazon.com/iot-core/pricing/#Messaging).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Data Plane's
// API operation ListRetainedMessages for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - UnauthorizedException
//     You are not authorized to perform this operation.
//
//   - ServiceUnavailableException
//     The service is temporarily unavailable.
//
//   - InternalFailureException
//     An unexpected error has occurred.
//
//   - MethodNotAllowedException
//     The specified combination of HTTP verb and URI is not supported.
func (c *IoTDataPlane) ListRetainedMessages(input *ListRetainedMessagesInput) (*ListRetainedMessagesOutput, error) {
	req, out := c.ListRetainedMessagesRequest(input)
	return out, req.Send()
}

// ListRetainedMessagesWithContext is the same as ListRetainedMessages with the addition of
// the ability to pass a context and additional request options.
//
// See ListRetainedMessages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) ListRetainedMessagesWithContext(ctx aws.Context, input *ListRetainedMessagesInput, opts ...request.Option) (*ListRetainedMessagesOutput, error) {
	req, out := c.ListRetainedMessagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRetainedMessagesPages iterates over the pages of a ListRetainedMessages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRetainedMessages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRetainedMessages operation.
//	pageNum := 0
//	err := client.ListRetainedMessagesPages(params,
//	    func(page *iotdataplane.ListRetainedMessagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IoTDataPlane) ListRetainedMessagesPages(input *ListRetainedMessagesInput, fn func(*ListRetainedMessagesOutput, bool) bool) error {
	return c.ListRetainedMessagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRetainedMessagesPagesWithContext same as ListRetainedMessagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) ListRetainedMessagesPagesWithContext(ctx aws.Context, input *ListRetainedMessagesInput, fn func(*ListRetainedMessagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRetainedMessagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRetainedMessagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRetainedMessagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPublish = "Publish"

// PublishRequest generates a "aws/request.Request" representing the
// client's request for the Publish operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Publish for more information on using the Publish
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PublishRequest method.
//	req, resp := client.PublishRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *IoTDataPlane) PublishRequest(input *PublishInput) (req *request.Request, output *PublishOutput) {
	op := &request.Operation{
		Name:       opPublish,
		HTTPMethod: "POST",
		HTTPPath:   "/topics/{topic}",
	}

	if input == nil {
		input = &PublishInput{}
	}

	output = &PublishOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// Publish API operation for AWS IoT Data Plane.
//
// Publishes an MQTT message.
//
// Requires permission to access the Publish (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
//
// For more information about MQTT messages, see MQTT Protocol (http://docs.aws.amazon.com/iot/latest/developerguide/mqtt.html)
// in the IoT Developer Guide.
//
// For more information about messaging costs, see Amazon Web Services IoT Core
// pricing - Messaging (http://aws.amazon.com/iot-core/pricing/#Messaging).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Data Plane's
// API operation Publish for usage and error information.
//
// Returned Error Types:
//
//   - InternalFailureException
//     An unexpected error has occurred.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - UnauthorizedException
//     You are not authorized to perform this operation.
//
//   - MethodNotAllowedException
//     The specified combination of HTTP verb and URI is not supported.
func (c *IoTDataPlane) Publish(input *PublishInput) (*PublishOutput, error) {
	req, out := c.PublishRequest(input)
	return out, req.Send()
}

// PublishWithContext is the same as Publish with the addition of
// the ability to pass a context and additional request options.
//
// See Publish for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) PublishWithContext(ctx aws.Context, input *PublishInput, opts ...request.Option) (*PublishOutput, error) {
	req, out := c.PublishRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateThingShadow = "UpdateThingShadow"

// UpdateThingShadowRequest generates a "aws/request.Request" representing the
// client's request for the UpdateThingShadow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateThingShadow for more information on using the UpdateThingShadow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateThingShadowRequest method.
//	req, resp := client.UpdateThingShadowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
func (c *IoTDataPlane) UpdateThingShadowRequest(input *UpdateThingShadowInput) (req *request.Request, output *UpdateThingShadowOutput) {
	op := &request.Operation{
		Name:       opUpdateThingShadow,
		HTTPMethod: "POST",
		HTTPPath:   "/things/{thingName}/shadow",
	}

	if input == nil {
		input = &UpdateThingShadowInput{}
	}

	output = &UpdateThingShadowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateThingShadow API operation for AWS IoT Data Plane.
//
// Updates the shadow for the specified thing.
//
// Requires permission to access the UpdateThingShadow (https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions)
// action.
//
// For more information, see UpdateThingShadow (http://docs.aws.amazon.com/iot/latest/developerguide/API_UpdateThingShadow.html)
// in the IoT Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Data Plane's
// API operation UpdateThingShadow for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     The specified version does not match the version of the document.
//
//   - RequestEntityTooLargeException
//     The payload exceeds the maximum size allowed.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The rate exceeds the limit.
//
//   - UnauthorizedException
//     You are not authorized to perform this operation.
//
//   - ServiceUnavailableException
//     The service is temporarily unavailable.
//
//   - InternalFailureException
//     An unexpected error has occurred.
//
//   - MethodNotAllowedException
//     The specified combination of HTTP verb and URI is not supported.
//
//   - UnsupportedDocumentEncodingException
//     The document encoding is not supported.
func (c *IoTDataPlane) UpdateThingShadow(input *UpdateThingShadowInput) (*UpdateThingShadowOutput, error) {
	req, out := c.UpdateThingShadowRequest(input)
	return out, req.Send()
}

// UpdateThingShadowWithContext is the same as UpdateThingShadow with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateThingShadow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDataPlane) UpdateThingShadowWithContext(ctx aws.Context, input *UpdateThingShadowInput, opts ...request.Option) (*UpdateThingShadowOutput, error) {
	req, out := c.UpdateThingShadowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The specified version does not match the version of the document.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input for the DeleteThingShadow operation.
type DeleteThingShadowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the shadow.
	ShadowName *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThingShadowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThingShadowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteThingShadowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteThingShadowInput"}
	if s.ShadowName != nil && len(*s.ShadowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShadowName", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShadowName sets the ShadowName field's value.
func (s *DeleteThingShadowInput) SetShadowName(v string) *DeleteThingShadowInput {
	s.ShadowName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *DeleteThingShadowInput) SetThingName(v string) *DeleteThingShadowInput {
	s.ThingName = &v
	return s
}

// The output from the DeleteThingShadow operation.
type DeleteThingShadowOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The state information, in JSON format.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThingShadowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteThingShadowOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *DeleteThingShadowOutput) SetPayload(v []byte) *DeleteThingShadowOutput {
	s.Payload = v
	return s
}

// The input for the GetRetainedMessage operation.
type GetRetainedMessageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The topic name of the retained message to retrieve.
	//
	// Topic is a required field
	Topic *string `location:"uri" locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetainedMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetainedMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRetainedMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRetainedMessageInput"}
	if s.Topic == nil {
		invalidParams.Add(request.NewErrParamRequired("Topic"))
	}
	if s.Topic != nil && len(*s.Topic) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Topic", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTopic sets the Topic field's value.
func (s *GetRetainedMessageInput) SetTopic(v string) *GetRetainedMessageInput {
	s.Topic = &v
	return s
}

// The output from the GetRetainedMessage operation.
type GetRetainedMessageOutput struct {
	_ struct{} `type:"structure"`

	// The Epoch date and time, in milliseconds, when the retained message was stored
	// by IoT.
	LastModifiedTime *int64 `locationName:"lastModifiedTime" type:"long"`

	// The Base64-encoded message payload of the retained message body.
	// Payload is automatically base64 encoded/decoded by the SDK.
	Payload []byte `locationName:"payload" type:"blob"`

	// The quality of service (QoS) level used to publish the retained message.
	Qos *int64 `locationName:"qos" type:"integer"`

	// The topic name to which the retained message was published.
	Topic *string `locationName:"topic" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetainedMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRetainedMessageOutput) GoString() string {
	return s.String()
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetRetainedMessageOutput) SetLastModifiedTime(v int64) *GetRetainedMessageOutput {
	s.LastModifiedTime = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *GetRetainedMessageOutput) SetPayload(v []byte) *GetRetainedMessageOutput {
	s.Payload = v
	return s
}

// SetQos sets the Qos field's value.
func (s *GetRetainedMessageOutput) SetQos(v int64) *GetRetainedMessageOutput {
	s.Qos = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *GetRetainedMessageOutput) SetTopic(v string) *GetRetainedMessageOutput {
	s.Topic = &v
	return s
}

// The input for the GetThingShadow operation.
type GetThingShadowInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the shadow.
	ShadowName *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThingShadowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThingShadowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetThingShadowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetThingShadowInput"}
	if s.ShadowName != nil && len(*s.ShadowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShadowName", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetShadowName sets the ShadowName field's value.
func (s *GetThingShadowInput) SetShadowName(v string) *GetThingShadowInput {
	s.ShadowName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *GetThingShadowInput) SetThingName(v string) *GetThingShadowInput {
	s.ThingName = &v
	return s
}

// The output from the GetThingShadow operation.
type GetThingShadowOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The state information, in JSON format.
	Payload []byte `locationName:"payload" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThingShadowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetThingShadowOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *GetThingShadowOutput) SetPayload(v []byte) *GetThingShadowOutput {
	s.Payload = v
	return s
}

// An unexpected error has occurred.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is not valid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListNamedShadowsForThingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The result page size.
	PageSize *int64 `location:"querystring" locationName:"pageSize" min:"1" type:"integer"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamedShadowsForThingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamedShadowsForThingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamedShadowsForThingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNamedShadowsForThingInput"}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedShadowsForThingInput) SetNextToken(v string) *ListNamedShadowsForThingInput {
	s.NextToken = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListNamedShadowsForThingInput) SetPageSize(v int64) *ListNamedShadowsForThingInput {
	s.PageSize = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *ListNamedShadowsForThingInput) SetThingName(v string) *ListNamedShadowsForThingInput {
	s.ThingName = &v
	return s
}

type ListNamedShadowsForThingOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of shadows for the specified thing.
	Results []*string `locationName:"results" type:"list"`

	// The Epoch date and time the response was generated by IoT.
	Timestamp *int64 `locationName:"timestamp" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamedShadowsForThingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamedShadowsForThingOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamedShadowsForThingOutput) SetNextToken(v string) *ListNamedShadowsForThingOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *ListNamedShadowsForThingOutput) SetResults(v []*string) *ListNamedShadowsForThingOutput {
	s.Results = v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *ListNamedShadowsForThingOutput) SetTimestamp(v int64) *ListNamedShadowsForThingOutput {
	s.Timestamp = &v
	return s
}

type ListRetainedMessagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return at one time.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetainedMessagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetainedMessagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRetainedMessagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRetainedMessagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRetainedMessagesInput) SetMaxResults(v int64) *ListRetainedMessagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRetainedMessagesInput) SetNextToken(v string) *ListRetainedMessagesInput {
	s.NextToken = &v
	return s
}

type ListRetainedMessagesOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null if there are no additional
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A summary list the account's retained messages. The information returned
	// doesn't include the message payloads of the retained messages.
	RetainedTopics []*RetainedMessageSummary `locationName:"retainedTopics" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetainedMessagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRetainedMessagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRetainedMessagesOutput) SetNextToken(v string) *ListRetainedMessagesOutput {
	s.NextToken = &v
	return s
}

// SetRetainedTopics sets the RetainedTopics field's value.
func (s *ListRetainedMessagesOutput) SetRetainedTopics(v []*RetainedMessageSummary) *ListRetainedMessagesOutput {
	s.RetainedTopics = v
	return s
}

// The specified combination of HTTP verb and URI is not supported.
type MethodNotAllowedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodNotAllowedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodNotAllowedException) GoString() string {
	return s.String()
}

func newErrorMethodNotAllowedException(v protocol.ResponseMetadata) error {
	return &MethodNotAllowedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MethodNotAllowedException) Code() string {
	return "MethodNotAllowedException"
}

// Message returns the exception's message.
func (s *MethodNotAllowedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MethodNotAllowedException) OrigErr() error {
	return nil
}

func (s *MethodNotAllowedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MethodNotAllowedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MethodNotAllowedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input for the Publish operation.
type PublishInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The message body. MQTT accepts text, binary, and empty (null) message payloads.
	//
	// Publishing an empty (null) payload with retain = true deletes the retained
	// message identified by topic from Amazon Web Services IoT Core.
	Payload []byte `locationName:"payload" type:"blob"`

	// The Quality of Service (QoS) level.
	Qos *int64 `location:"querystring" locationName:"qos" type:"integer"`

	// A Boolean value that determines whether to set the RETAIN flag when the message
	// is published.
	//
	// Setting the RETAIN flag causes the message to be retained and sent to new
	// subscribers to the topic.
	//
	// Valid values: true | false
	//
	// Default value: false
	Retain *bool `location:"querystring" locationName:"retain" type:"boolean"`

	// The name of the MQTT topic.
	//
	// Topic is a required field
	Topic *string `location:"uri" locationName:"topic" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishInput"}
	if s.Topic == nil {
		invalidParams.Add(request.NewErrParamRequired("Topic"))
	}
	if s.Topic != nil && len(*s.Topic) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Topic", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayload sets the Payload field's value.
func (s *PublishInput) SetPayload(v []byte) *PublishInput {
	s.Payload = v
	return s
}

// SetQos sets the Qos field's value.
func (s *PublishInput) SetQos(v int64) *PublishInput {
	s.Qos = &v
	return s
}

// SetRetain sets the Retain field's value.
func (s *PublishInput) SetRetain(v bool) *PublishInput {
	s.Retain = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *PublishInput) SetTopic(v string) *PublishInput {
	s.Topic = &v
	return s
}

type PublishOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PublishOutput) GoString() string {
	return s.String()
}

// The payload exceeds the maximum size allowed.
type RequestEntityTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestEntityTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RequestEntityTooLargeException) GoString() string {
	return s.String()
}

func newErrorRequestEntityTooLargeException(v protocol.ResponseMetadata) error {
	return &RequestEntityTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestEntityTooLargeException) Code() string {
	return "RequestEntityTooLargeException"
}

// Message returns the exception's message.
func (s *RequestEntityTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestEntityTooLargeException) OrigErr() error {
	return nil
}

func (s *RequestEntityTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestEntityTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestEntityTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a single retained message.
type RetainedMessageSummary struct {
	_ struct{} `type:"structure"`

	// The Epoch date and time, in milliseconds, when the retained message was stored
	// by IoT.
	LastModifiedTime *int64 `locationName:"lastModifiedTime" type:"long"`

	// The size of the retained message's payload in bytes.
	PayloadSize *int64 `locationName:"payloadSize" type:"long"`

	// The quality of service (QoS) level used to publish the retained message.
	Qos *int64 `locationName:"qos" type:"integer"`

	// The topic name to which the retained message was published.
	Topic *string `locationName:"topic" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetainedMessageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetainedMessageSummary) GoString() string {
	return s.String()
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *RetainedMessageSummary) SetLastModifiedTime(v int64) *RetainedMessageSummary {
	s.LastModifiedTime = &v
	return s
}

// SetPayloadSize sets the PayloadSize field's value.
func (s *RetainedMessageSummary) SetPayloadSize(v int64) *RetainedMessageSummary {
	s.PayloadSize = &v
	return s
}

// SetQos sets the Qos field's value.
func (s *RetainedMessageSummary) SetQos(v int64) *RetainedMessageSummary {
	s.Qos = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *RetainedMessageSummary) SetTopic(v string) *RetainedMessageSummary {
	s.Topic = &v
	return s
}

// The service is temporarily unavailable.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The rate exceeds the limit.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You are not authorized to perform this operation.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The document encoding is not supported.
type UnsupportedDocumentEncodingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message for the exception.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedDocumentEncodingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedDocumentEncodingException) GoString() string {
	return s.String()
}

func newErrorUnsupportedDocumentEncodingException(v protocol.ResponseMetadata) error {
	return &UnsupportedDocumentEncodingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedDocumentEncodingException) Code() string {
	return "UnsupportedDocumentEncodingException"
}

// Message returns the exception's message.
func (s *UnsupportedDocumentEncodingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedDocumentEncodingException) OrigErr() error {
	return nil
}

func (s *UnsupportedDocumentEncodingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedDocumentEncodingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedDocumentEncodingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input for the UpdateThingShadow operation.
type UpdateThingShadowInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The state information, in JSON format.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`

	// The name of the shadow.
	ShadowName *string `location:"querystring" locationName:"name" min:"1" type:"string"`

	// The name of the thing.
	//
	// ThingName is a required field
	ThingName *string `location:"uri" locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThingShadowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThingShadowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateThingShadowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateThingShadowInput"}
	if s.Payload == nil {
		invalidParams.Add(request.NewErrParamRequired("Payload"))
	}
	if s.ShadowName != nil && len(*s.ShadowName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ShadowName", 1))
	}
	if s.ThingName == nil {
		invalidParams.Add(request.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPayload sets the Payload field's value.
func (s *UpdateThingShadowInput) SetPayload(v []byte) *UpdateThingShadowInput {
	s.Payload = v
	return s
}

// SetShadowName sets the ShadowName field's value.
func (s *UpdateThingShadowInput) SetShadowName(v string) *UpdateThingShadowInput {
	s.ShadowName = &v
	return s
}

// SetThingName sets the ThingName field's value.
func (s *UpdateThingShadowInput) SetThingName(v string) *UpdateThingShadowInput {
	s.ThingName = &v
	return s
}

// The output from the UpdateThingShadow operation.
type UpdateThingShadowOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// The state information, in JSON format.
	Payload []byte `locationName:"payload" type:"blob"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThingShadowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateThingShadowOutput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *UpdateThingShadowOutput) SetPayload(v []byte) *UpdateThingShadowOutput {
	s.Payload = v
	return s
}
