//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armeventhub

import "time"

// AccessKeys - Namespace/EventHub Connection String
type AccessKeys struct {
	// READ-ONLY; Primary connection string of the alias if GEO DR is enabled
	AliasPrimaryConnectionString *string `json:"aliasPrimaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; Secondary connection string of the alias if GEO DR is enabled
	AliasSecondaryConnectionString *string `json:"aliasSecondaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A string that describes the AuthorizationRule.
	KeyName *string `json:"keyName,omitempty" azure:"ro"`

	// READ-ONLY; Primary connection string of the created namespace AuthorizationRule.
	PrimaryConnectionString *string `json:"primaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string `json:"primaryKey,omitempty" azure:"ro"`

	// READ-ONLY; Secondary connection string of the created namespace AuthorizationRule.
	SecondaryConnectionString *string `json:"secondaryConnectionString,omitempty" azure:"ro"`

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string `json:"secondaryKey,omitempty" azure:"ro"`
}

// AuthorizationRule - Single item in a List or Get AuthorizationRule operation
type AuthorizationRule struct {
	// Properties supplied to create or update AuthorizationRule
	Properties *AuthorizationRuleProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AuthorizationRuleListResult - The response from the List namespace operation.
type AuthorizationRuleListResult struct {
	// Link to the next set of results. Not empty if Value contains an incomplete list of Authorization Rules
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Authorization Rules operation.
	Value []*AuthorizationRule `json:"value,omitempty"`
}

// AuthorizationRuleProperties - Properties supplied to create or update AuthorizationRule
type AuthorizationRuleProperties struct {
	// REQUIRED; The rights associated with the rule.
	Rights []*AccessRights `json:"rights,omitempty"`
}

// AvailableCluster - Pre-provisioned and readily available Event Hubs Cluster count per region.
type AvailableCluster struct {
	// Location fo the Available Cluster
	Location *string `json:"location,omitempty"`
}

// AvailableClustersList - The response of the List Available Clusters operation.
type AvailableClustersList struct {
	// The count of readily available and pre-provisioned Event Hubs Clusters per region.
	Value []*AvailableCluster `json:"value,omitempty"`
}

// CaptureDescription - Properties to configure capture description for eventhub
type CaptureDescription struct {
	// Properties of Destination where capture will be stored. (Storage Account, Blob Names)
	Destination *Destination `json:"destination,omitempty"`

	// A value that indicates whether capture description is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Enumerates the possible values for the encoding format of capture description. Note: 'AvroDeflate' will be deprecated in
	// New API Version
	Encoding *EncodingCaptureDescription `json:"encoding,omitempty"`

	// The time window allows you to set the frequency with which the capture to Azure Blobs will happen, value should between
	// 60 to 900 seconds
	IntervalInSeconds *int32 `json:"intervalInSeconds,omitempty"`

	// The size window defines the amount of data built up in your Event Hub before an capture operation, value should be between
	// 10485760 to 524288000 bytes
	SizeLimitInBytes *int32 `json:"sizeLimitInBytes,omitempty"`

	// A value that indicates whether to Skip Empty Archives
	SkipEmptyArchives *bool `json:"skipEmptyArchives,omitempty"`
}

// CheckNameAvailabilityParameter - Parameter supplied to check Namespace name availability operation
type CheckNameAvailabilityParameter struct {
	// REQUIRED; Name to check the namespace name availability
	Name *string `json:"name,omitempty"`
}

// CheckNameAvailabilityResult - The Result of the CheckNameAvailability operation
type CheckNameAvailabilityResult struct {
	// Value indicating Namespace is availability, true if the Namespace is available; otherwise, false.
	NameAvailable *bool `json:"nameAvailable,omitempty"`

	// The reason for unavailability of a Namespace.
	Reason *UnavailableReason `json:"reason,omitempty"`

	// READ-ONLY; The detailed info regarding the reason associated with the Namespace.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// Cluster - Single Event Hubs Cluster resource in List or Get operations.
type Cluster struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Event Hubs Cluster properties supplied in responses in List or Get operations.
	Properties *ClusterProperties `json:"properties,omitempty"`

	// Properties of the cluster SKU.
	SKU *ClusterSKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ClusterListResult - The response of the List Event Hubs Clusters operation.
type ClusterListResult struct {
	// Link to the next set of results. Empty unless the value parameter contains an incomplete list of Event Hubs Clusters.
	NextLink *string `json:"nextLink,omitempty"`

	// The Event Hubs Clusters present in the List Event Hubs operation results.
	Value []*Cluster `json:"value,omitempty"`
}

// ClusterProperties - Event Hubs Cluster properties supplied in responses in List or Get operations.
type ClusterProperties struct {
	// READ-ONLY; The UTC time when the Event Hubs Cluster was created.
	CreatedAt *string `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; The metric ID of the cluster resource. Provided by the service and not modifiable by the user.
	MetricID *string `json:"metricId,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Cluster resource
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The UTC time when the Event Hubs Cluster was last updated.
	UpdatedAt *string `json:"updatedAt,omitempty" azure:"ro"`
}

// ClusterSKU - SKU parameters particular to a cluster instance.
type ClusterSKU struct {
	// REQUIRED; Name of this SKU.
	Name *ClusterSKUName `json:"name,omitempty"`

	// The quantity of Event Hubs Cluster Capacity Units contained in this cluster.
	Capacity *int32 `json:"capacity,omitempty"`
}

// ClustersClientBeginCreateOrUpdateOptions contains the optional parameters for the ClustersClient.BeginCreateOrUpdate method.
type ClustersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginDeleteOptions contains the optional parameters for the ClustersClient.BeginDelete method.
type ClustersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientBeginUpdateOptions contains the optional parameters for the ClustersClient.BeginUpdate method.
type ClustersClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ClustersClientGetOptions contains the optional parameters for the ClustersClient.Get method.
type ClustersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListAvailableClusterRegionOptions contains the optional parameters for the ClustersClient.ListAvailableClusterRegion
// method.
type ClustersClientListAvailableClusterRegionOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListByResourceGroupOptions contains the optional parameters for the ClustersClient.NewListByResourceGroupPager
// method.
type ClustersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ClustersClientListNamespacesOptions contains the optional parameters for the ClustersClient.ListNamespaces method.
type ClustersClientListNamespacesOptions struct {
	// placeholder for future optional parameters
}

// ConnectionState information.
type ConnectionState struct {
	// Description of the connection state.
	Description *string `json:"description,omitempty"`

	// Status of the connection.
	Status *PrivateLinkConnectionStatus `json:"status,omitempty"`
}

// ConsumerGroup - Single item in List or Get Consumer group operation
type ConsumerGroup struct {
	// Single item in List or Get Consumer group operation
	Properties *ConsumerGroupProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConsumerGroupListResult - The result to the List Consumer Group operation.
type ConsumerGroupListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Consumer Group
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Consumer Group operation.
	Value []*ConsumerGroup `json:"value,omitempty"`
}

// ConsumerGroupProperties - Single item in List or Get Consumer group operation
type ConsumerGroupProperties struct {
	// User Metadata is a placeholder to store user-defined string data with maximum length 1024. e.g. it can be used to store
	// descriptive data, such as list of teams and their contact information also
	// user-defined configuration settings can be stored.
	UserMetadata *string `json:"userMetadata,omitempty"`

	// READ-ONLY; Exact time the message was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// ConsumerGroupsClientCreateOrUpdateOptions contains the optional parameters for the ConsumerGroupsClient.CreateOrUpdate
// method.
type ConsumerGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ConsumerGroupsClientDeleteOptions contains the optional parameters for the ConsumerGroupsClient.Delete method.
type ConsumerGroupsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ConsumerGroupsClientGetOptions contains the optional parameters for the ConsumerGroupsClient.Get method.
type ConsumerGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConsumerGroupsClientListByEventHubOptions contains the optional parameters for the ConsumerGroupsClient.NewListByEventHubPager
// method.
type ConsumerGroupsClientListByEventHubOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// Destination - Capture storage details for capture description
type Destination struct {
	// Name for capture destination
	Name *string `json:"name,omitempty"`

	// Properties describing the storage account, blob container and archive name format for capture destination
	Properties *DestinationProperties `json:"properties,omitempty"`
}

// DestinationProperties - Properties describing the storage account, blob container and archive name format for capture destination
type DestinationProperties struct {
	// Blob naming convention for archive, e.g. {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}.
	// Here all the parameters (Namespace,EventHub .. etc) are mandatory
	// irrespective of order
	ArchiveNameFormat *string `json:"archiveNameFormat,omitempty"`

	// Blob container Name
	BlobContainer *string `json:"blobContainer,omitempty"`

	// Resource id of the storage account to be used to create the blobs
	StorageAccountResourceID *string `json:"storageAccountResourceId,omitempty"`
}

// DisasterRecoveryConfigsClientGetAuthorizationRuleOptions contains the optional parameters for the DisasterRecoveryConfigsClient.GetAuthorizationRule
// method.
type DisasterRecoveryConfigsClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListAuthorizationRulesOptions contains the optional parameters for the DisasterRecoveryConfigsClient.NewListAuthorizationRulesPager
// method.
type DisasterRecoveryConfigsClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// DisasterRecoveryConfigsClientListKeysOptions contains the optional parameters for the DisasterRecoveryConfigsClient.ListKeys
// method.
type DisasterRecoveryConfigsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// EHNamespace - Single Namespace item in List or Get Operation
type EHNamespace struct {
	// Properties of BYOK Identity description
	Identity *Identity `json:"identity,omitempty"`

	// Resource location.
	Location *string `json:"location,omitempty"`

	// Namespace properties supplied for create namespace operation.
	Properties *EHNamespaceProperties `json:"properties,omitempty"`

	// Properties of sku resource
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// EHNamespaceIDContainer - The full ARM ID of an Event Hubs Namespace
type EHNamespaceIDContainer struct {
	// id parameter
	ID *string `json:"id,omitempty"`
}

// EHNamespaceIDListResult - The response of the List Namespace IDs operation
type EHNamespaceIDListResult struct {
	// Result of the List Namespace IDs operation
	Value []*EHNamespaceIDContainer `json:"value,omitempty"`
}

// EHNamespaceListResult - The response of the List Namespace operation
type EHNamespaceListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of namespaces.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List Namespace operation
	Value []*EHNamespace `json:"value,omitempty"`
}

// EHNamespaceProperties - Namespace properties supplied for create namespace operation.
type EHNamespaceProperties struct {
	// Cluster ARM ID of the Namespace.
	ClusterArmID *string `json:"clusterArmId,omitempty"`

	// Properties of BYOK Encryption description
	Encryption *Encryption `json:"encryption,omitempty"`

	// Value that indicates whether AutoInflate is enabled for eventhub namespace.
	IsAutoInflateEnabled *bool `json:"isAutoInflateEnabled,omitempty"`

	// Value that indicates whether Kafka is enabled for eventhub namespace.
	KafkaEnabled *bool `json:"kafkaEnabled,omitempty"`

	// Upper limit of throughput units when AutoInflate is enabled, value should be within 0 to 20 throughput units. ( '0' if
	// AutoInflateEnabled = true)
	MaximumThroughputUnits *int32 `json:"maximumThroughputUnits,omitempty"`

	// Enabling this property creates a Standard Event Hubs Namespace in regions supported availability zones.
	ZoneRedundant *bool `json:"zoneRedundant,omitempty"`

	// READ-ONLY; The time the Namespace was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Identifier for Azure Insights metrics.
	MetricID *string `json:"metricId,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Namespace.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Endpoint you can use to perform Service Bus operations.
	ServiceBusEndpoint *string `json:"serviceBusEndpoint,omitempty" azure:"ro"`

	// READ-ONLY; Status of the Namespace.
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The time the Namespace was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// Encryption - Properties to configure Encryption
type Encryption struct {
	// Enumerates the possible value of keySource for Encryption
	KeySource *string `json:"keySource,omitempty"`

	// Properties of KeyVault
	KeyVaultProperties []*KeyVaultProperties `json:"keyVaultProperties,omitempty"`
}

// ErrorResponse - Error response indicates Event Hub service is not able to process the incoming request. The reason is provided
// in the error message.
type ErrorResponse struct {
	// Error code.
	Code *string `json:"code,omitempty"`

	// Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// EventHubsClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the EventHubsClient.CreateOrUpdateAuthorizationRule
// method.
type EventHubsClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientCreateOrUpdateOptions contains the optional parameters for the EventHubsClient.CreateOrUpdate method.
type EventHubsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientDeleteAuthorizationRuleOptions contains the optional parameters for the EventHubsClient.DeleteAuthorizationRule
// method.
type EventHubsClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientDeleteOptions contains the optional parameters for the EventHubsClient.Delete method.
type EventHubsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientGetAuthorizationRuleOptions contains the optional parameters for the EventHubsClient.GetAuthorizationRule
// method.
type EventHubsClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientGetOptions contains the optional parameters for the EventHubsClient.Get method.
type EventHubsClientGetOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientListAuthorizationRulesOptions contains the optional parameters for the EventHubsClient.NewListAuthorizationRulesPager
// method.
type EventHubsClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientListByNamespaceOptions contains the optional parameters for the EventHubsClient.NewListByNamespacePager
// method.
type EventHubsClientListByNamespaceOptions struct {
	// Skip is only used if a previous operation returned a partial result. If a previous response contains a nextLink element,
	// the value of the nextLink element will include a skip parameter that specifies
	// a starting point to use for subsequent calls.
	Skip *int32
	// May be used to limit the number of results to the most recent N usageDetails.
	Top *int32
}

// EventHubsClientListKeysOptions contains the optional parameters for the EventHubsClient.ListKeys method.
type EventHubsClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// EventHubsClientRegenerateKeysOptions contains the optional parameters for the EventHubsClient.RegenerateKeys method.
type EventHubsClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// Eventhub - Single item in List or Get Event Hub operation
type Eventhub struct {
	// Properties supplied to the Create Or Update Event Hub operation.
	Properties *Properties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Identity - Properties to configure Identity for Bring your Own Keys
type Identity struct {
	// ObjectId from the KeyVault
	PrincipalID *string `json:"principalId,omitempty"`

	// TenantId from the KeyVault
	TenantID *string `json:"tenantId,omitempty"`

	// Enumerates the possible value Identity type, which currently supports only 'SystemAssigned'
	Type *string `json:"type,omitempty"`
}

// KeyVaultProperties - Properties to configure keyVault Properties
type KeyVaultProperties struct {
	// Name of the Key from KeyVault
	KeyName *string `json:"keyName,omitempty"`

	// Uri of KeyVault
	KeyVaultURI *string `json:"keyVaultUri,omitempty"`

	// Key Version
	KeyVersion *string `json:"keyVersion,omitempty"`
}

// ListResult - The result of the List EventHubs operation.
type ListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of EventHubs.
	NextLink *string `json:"nextLink,omitempty"`

	// Result of the List EventHubs operation.
	Value []*Eventhub `json:"value,omitempty"`
}

// MessagingRegions - Messaging Region
type MessagingRegions struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Properties of Messaging Region
	Properties *MessagingRegionsProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MessagingRegionsListResult - The response of the List MessagingRegions operation.
type MessagingRegionsListResult struct {
	// Result of the List MessagingRegions type.
	Value []*MessagingRegions `json:"value,omitempty"`

	// READ-ONLY; Link to the next set of results. Not empty if Value contains incomplete list of MessagingRegions.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MessagingRegionsProperties - Properties of Messaging Region
type MessagingRegionsProperties struct {
	// READ-ONLY; Region code
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Full name of the region
	FullName *string `json:"fullName,omitempty" azure:"ro"`
}

// NamespacesClientBeginCreateOrUpdateOptions contains the optional parameters for the NamespacesClient.BeginCreateOrUpdate
// method.
type NamespacesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientBeginDeleteOptions contains the optional parameters for the NamespacesClient.BeginDelete method.
type NamespacesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// NamespacesClientCheckNameAvailabilityOptions contains the optional parameters for the NamespacesClient.CheckNameAvailability
// method.
type NamespacesClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientCreateOrUpdateAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.CreateOrUpdateAuthorizationRule
// method.
type NamespacesClientCreateOrUpdateAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientDeleteAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.DeleteAuthorizationRule
// method.
type NamespacesClientDeleteAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetAuthorizationRuleOptions contains the optional parameters for the NamespacesClient.GetAuthorizationRule
// method.
type NamespacesClientGetAuthorizationRuleOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientGetOptions contains the optional parameters for the NamespacesClient.Get method.
type NamespacesClientGetOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListAuthorizationRulesOptions contains the optional parameters for the NamespacesClient.NewListAuthorizationRulesPager
// method.
type NamespacesClientListAuthorizationRulesOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListByResourceGroupOptions contains the optional parameters for the NamespacesClient.NewListByResourceGroupPager
// method.
type NamespacesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListKeysOptions contains the optional parameters for the NamespacesClient.ListKeys method.
type NamespacesClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientListOptions contains the optional parameters for the NamespacesClient.NewListPager method.
type NamespacesClientListOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientRegenerateKeysOptions contains the optional parameters for the NamespacesClient.RegenerateKeys method.
type NamespacesClientRegenerateKeysOptions struct {
	// placeholder for future optional parameters
}

// NamespacesClientUpdateOptions contains the optional parameters for the NamespacesClient.Update method.
type NamespacesClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// Operation - A Event Hub REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; Service provider: Microsoft.EventHub
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list Event Hub operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; List of Event Hub operations supported by the Microsoft.EventHub resource provider.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpoint information.
type PrivateEndpoint struct {
	// The ARM identifier for Private Endpoint.
	ID *string `json:"id,omitempty"`
}

// PrivateEndpointConnection - Properties of the PrivateEndpointConnection.
type PrivateEndpointConnection struct {
	// Properties of the PrivateEndpointConnection.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionListResult - Result of the list of all private endpoint connections operation.
type PrivateEndpointConnectionListResult struct {
	// A link for the next page of private endpoint connection resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private endpoint connection resources.
	Value []*PrivateEndpointConnection `json:"value,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// The Private Endpoint resource for this Connection.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Details about the state of the connection.
	PrivateLinkServiceConnectionState *ConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// Provisioning state of the Private Endpoint Connection.
	ProvisioningState *EndPointProvisioningState `json:"provisioningState,omitempty"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientCreateOrUpdateOptions contains the optional parameters for the PrivateEndpointConnectionsClient.CreateOrUpdate
// method.
type PrivateEndpointConnectionsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientListOptions contains the optional parameters for the PrivateEndpointConnectionsClient.NewListPager
// method.
type PrivateEndpointConnectionsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - Information of the private link resource.
type PrivateLinkResource struct {
	// Fully qualified identifier of the resource.
	ID *string `json:"id,omitempty"`

	// Name of the resource
	Name *string `json:"name,omitempty"`

	// Properties of the private link resource.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// Type of the resource
	Type *string `json:"type,omitempty"`
}

// PrivateLinkResourceProperties - Properties of PrivateLinkResource
type PrivateLinkResourceProperties struct {
	// The private link resource group id.
	GroupID *string `json:"groupId,omitempty"`

	// The private link resource required member names.
	RequiredMembers []*string `json:"requiredMembers,omitempty"`

	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`
}

// PrivateLinkResourcesClientGetOptions contains the optional parameters for the PrivateLinkResourcesClient.Get method.
type PrivateLinkResourcesClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResourcesListResult - Result of the List private link resources operation.
type PrivateLinkResourcesListResult struct {
	// A link for the next page of private link resources.
	NextLink *string `json:"nextLink,omitempty"`

	// A collection of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// Properties supplied to the Create Or Update Event Hub operation.
type Properties struct {
	// Properties of capture description
	CaptureDescription *CaptureDescription `json:"captureDescription,omitempty"`

	// Number of days to retain the events for this Event Hub, value should be 1 to 7 days
	MessageRetentionInDays *int64 `json:"messageRetentionInDays,omitempty"`

	// Number of partitions created for the Event Hub, allowed values are from 1 to 32 partitions.
	PartitionCount *int64 `json:"partitionCount,omitempty"`

	// Enumerates the possible values for the status of the Event Hub.
	Status *EntityStatus `json:"status,omitempty"`

	// READ-ONLY; Exact time the Event Hub was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Current number of shards on the Event Hub.
	PartitionIDs []*string `json:"partitionIds,omitempty" azure:"ro"`

	// READ-ONLY; The exact time the message was updated.
	UpdatedAt *time.Time `json:"updatedAt,omitempty" azure:"ro"`
}

// RegenerateAccessKeyParameters - Parameters supplied to the Regenerate Authorization Rule operation, specifies which key
// needs to be reset.
type RegenerateAccessKeyParameters struct {
	// REQUIRED; The access key to regenerate.
	KeyType *KeyType `json:"keyType,omitempty"`

	// Optional, if the key value provided, is set for KeyType or autogenerated Key value set for keyType
	Key *string `json:"key,omitempty"`
}

// RegionsClientListBySKUOptions contains the optional parameters for the RegionsClient.NewListBySKUPager method.
type RegionsClientListBySKUOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SKU parameters supplied to the create namespace operation
type SKU struct {
	// REQUIRED; Name of this SKU.
	Name *SKUName `json:"name,omitempty"`

	// The Event Hubs throughput units, value should be 0 to 20 throughput units.
	Capacity *int32 `json:"capacity,omitempty"`

	// The billing tier of this particular SKU.
	Tier *SKUTier `json:"tier,omitempty"`
}

// TrackedResource - Definition of resource.
type TrackedResource struct {
	// Resource location.
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}
