//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billingbenefits/armbillingbenefits/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReservationOrderAliasServer is a fake server for instances of the armbillingbenefits.ReservationOrderAliasClient type.
type ReservationOrderAliasServer struct {
	// BeginCreate is the fake for method ReservationOrderAliasClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, reservationOrderAliasName string, body armbillingbenefits.ReservationOrderAliasRequest, options *armbillingbenefits.ReservationOrderAliasClientBeginCreateOptions) (resp azfake.PollerResponder[armbillingbenefits.ReservationOrderAliasClientCreateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReservationOrderAliasClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, reservationOrderAliasName string, options *armbillingbenefits.ReservationOrderAliasClientGetOptions) (resp azfake.Responder[armbillingbenefits.ReservationOrderAliasClientGetResponse], errResp azfake.ErrorResponder)
}

// NewReservationOrderAliasServerTransport creates a new instance of ReservationOrderAliasServerTransport with the provided implementation.
// The returned ReservationOrderAliasServerTransport instance is connected to an instance of armbillingbenefits.ReservationOrderAliasClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReservationOrderAliasServerTransport(srv *ReservationOrderAliasServer) *ReservationOrderAliasServerTransport {
	return &ReservationOrderAliasServerTransport{
		srv:         srv,
		beginCreate: newTracker[azfake.PollerResponder[armbillingbenefits.ReservationOrderAliasClientCreateResponse]](),
	}
}

// ReservationOrderAliasServerTransport connects instances of armbillingbenefits.ReservationOrderAliasClient to instances of ReservationOrderAliasServer.
// Don't use this type directly, use NewReservationOrderAliasServerTransport instead.
type ReservationOrderAliasServerTransport struct {
	srv         *ReservationOrderAliasServer
	beginCreate *tracker[azfake.PollerResponder[armbillingbenefits.ReservationOrderAliasClientCreateResponse]]
}

// Do implements the policy.Transporter interface for ReservationOrderAliasServerTransport.
func (r *ReservationOrderAliasServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReservationOrderAliasClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "ReservationOrderAliasClient.Get":
		resp, err = r.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReservationOrderAliasServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/providers/Microsoft\.BillingBenefits/reservationOrderAliases/(?P<reservationOrderAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armbillingbenefits.ReservationOrderAliasRequest](req)
		if err != nil {
			return nil, err
		}
		reservationOrderAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("reservationOrderAliasName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), reservationOrderAliasNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *ReservationOrderAliasServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.BillingBenefits/reservationOrderAliases/(?P<reservationOrderAliasName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	reservationOrderAliasNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("reservationOrderAliasName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), reservationOrderAliasNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReservationOrderAliasResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
