//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/chaos/armchaos"
	"net/http"
	"net/url"
	"regexp"
)

// CapabilitiesServer is a fake server for instances of the armchaos.CapabilitiesClient type.
type CapabilitiesServer struct {
	// CreateOrUpdate is the fake for method CapabilitiesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, parentProviderNamespace string, parentResourceType string, parentResourceName string, targetName string, capabilityName string, capability armchaos.Capability, options *armchaos.CapabilitiesClientCreateOrUpdateOptions) (resp azfake.Responder[armchaos.CapabilitiesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method CapabilitiesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, parentProviderNamespace string, parentResourceType string, parentResourceName string, targetName string, capabilityName string, options *armchaos.CapabilitiesClientDeleteOptions) (resp azfake.Responder[armchaos.CapabilitiesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method CapabilitiesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, parentProviderNamespace string, parentResourceType string, parentResourceName string, targetName string, capabilityName string, options *armchaos.CapabilitiesClientGetOptions) (resp azfake.Responder[armchaos.CapabilitiesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method CapabilitiesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, parentProviderNamespace string, parentResourceType string, parentResourceName string, targetName string, options *armchaos.CapabilitiesClientListOptions) (resp azfake.PagerResponder[armchaos.CapabilitiesClientListResponse])
}

// NewCapabilitiesServerTransport creates a new instance of CapabilitiesServerTransport with the provided implementation.
// The returned CapabilitiesServerTransport instance is connected to an instance of armchaos.CapabilitiesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCapabilitiesServerTransport(srv *CapabilitiesServer) *CapabilitiesServerTransport {
	return &CapabilitiesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armchaos.CapabilitiesClientListResponse]](),
	}
}

// CapabilitiesServerTransport connects instances of armchaos.CapabilitiesClient to instances of CapabilitiesServer.
// Don't use this type directly, use NewCapabilitiesServerTransport instead.
type CapabilitiesServerTransport struct {
	srv          *CapabilitiesServer
	newListPager *tracker[azfake.PagerResponder[armchaos.CapabilitiesClientListResponse]]
}

// Do implements the policy.Transporter interface for CapabilitiesServerTransport.
func (c *CapabilitiesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CapabilitiesClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "CapabilitiesClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "CapabilitiesClient.Get":
		resp, err = c.dispatchGet(req)
	case "CapabilitiesClient.NewListPager":
		resp, err = c.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CapabilitiesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<parentProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/targets/(?P<targetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities/(?P<capabilityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armchaos.Capability](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	parentProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceName")])
	if err != nil {
		return nil, err
	}
	targetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("targetName")])
	if err != nil {
		return nil, err
	}
	capabilityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("capabilityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, parentProviderNamespaceParam, parentResourceTypeParam, parentResourceNameParam, targetNameParam, capabilityNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Capability, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapabilitiesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<parentProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/targets/(?P<targetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities/(?P<capabilityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	parentProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceName")])
	if err != nil {
		return nil, err
	}
	targetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("targetName")])
	if err != nil {
		return nil, err
	}
	capabilityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("capabilityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupNameParam, parentProviderNamespaceParam, parentResourceTypeParam, parentResourceNameParam, targetNameParam, capabilityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapabilitiesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<parentProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/targets/(?P<targetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities/(?P<capabilityName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 7 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	parentProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentProviderNamespace")])
	if err != nil {
		return nil, err
	}
	parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
	if err != nil {
		return nil, err
	}
	parentResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceName")])
	if err != nil {
		return nil, err
	}
	targetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("targetName")])
	if err != nil {
		return nil, err
	}
	capabilityNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("capabilityName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, parentProviderNamespaceParam, parentResourceTypeParam, parentResourceNameParam, targetNameParam, capabilityNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Capability, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CapabilitiesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := c.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<parentProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/targets/(?P<targetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/capabilities`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		parentProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentProviderNamespace")])
		if err != nil {
			return nil, err
		}
		parentResourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceType")])
		if err != nil {
			return nil, err
		}
		parentResourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourceName")])
		if err != nil {
			return nil, err
		}
		targetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("targetName")])
		if err != nil {
			return nil, err
		}
		continuationTokenUnescaped, err := url.QueryUnescape(qp.Get("continuationToken"))
		if err != nil {
			return nil, err
		}
		continuationTokenParam := getOptional(continuationTokenUnescaped)
		var options *armchaos.CapabilitiesClientListOptions
		if continuationTokenParam != nil {
			options = &armchaos.CapabilitiesClientListOptions{
				ContinuationToken: continuationTokenParam,
			}
		}
		resp := c.srv.NewListPager(resourceGroupNameParam, parentProviderNamespaceParam, parentResourceTypeParam, parentResourceNameParam, targetNameParam, options)
		newListPager = &resp
		c.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armchaos.CapabilitiesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		c.newListPager.remove(req)
	}
	return resp, nil
}
