//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcompute_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/compute/armcompute/v5"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2022-03-03/examples/communityGalleryExamples/CommunityGalleryImage_Get.json
func ExampleCommunityGalleryImagesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcompute.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewCommunityGalleryImagesClient().Get(ctx, "myLocation", "publicGalleryName", "myGalleryImageName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CommunityGalleryImage = armcompute.CommunityGalleryImage{
	// 	Name: to.Ptr("myGalleryImageName"),
	// 	Type: to.Ptr("Microsoft.Compute/Locations/CommunityGalleryImage"),
	// 	Identifier: &armcompute.CommunityGalleryIdentifier{
	// 		UniqueID: to.Ptr("/CommunityGalleries/publicGalleryName/Images/myGalleryImageName"),
	// 	},
	// 	Location: to.Ptr("myLocation"),
	// 	Properties: &armcompute.CommunityGalleryImageProperties{
	// 		Eula: to.Ptr("https://www.microsoft.com/en-us/"),
	// 		HyperVGeneration: to.Ptr(armcompute.HyperVGenerationV1),
	// 		Identifier: &armcompute.CommunityGalleryImageIdentifier{
	// 			Offer: to.Ptr("myOfferName"),
	// 			Publisher: to.Ptr("myPublisherName"),
	// 			SKU: to.Ptr("mySkuName"),
	// 		},
	// 		OSState: to.Ptr(armcompute.OperatingSystemStateTypesGeneralized),
	// 		OSType: to.Ptr(armcompute.OperatingSystemTypesWindows),
	// 		PrivacyStatementURI: to.Ptr("https://www.microsoft.com/en-us/"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/compute/resource-manager/Microsoft.Compute/GalleryRP/stable/2022-03-03/examples/communityGalleryExamples/CommunityGalleryImage_List.json
func ExampleCommunityGalleryImagesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcompute.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewCommunityGalleryImagesClient().NewListPager("myLocation", "publicGalleryName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.CommunityGalleryImageList = armcompute.CommunityGalleryImageList{
		// 	Value: []*armcompute.CommunityGalleryImage{
		// 		{
		// 			Name: to.Ptr("myGalleryImageName"),
		// 			Identifier: &armcompute.CommunityGalleryIdentifier{
		// 				UniqueID: to.Ptr("/CommunityGalleries/publicGalleryName/Images/myGalleryImageName"),
		// 			},
		// 			Location: to.Ptr("myLocation"),
		// 			Properties: &armcompute.CommunityGalleryImageProperties{
		// 				HyperVGeneration: to.Ptr(armcompute.HyperVGenerationV1),
		// 				Identifier: &armcompute.CommunityGalleryImageIdentifier{
		// 					Offer: to.Ptr("myOfferName"),
		// 					Publisher: to.Ptr("myPublisherName"),
		// 					SKU: to.Ptr("mySkuName"),
		// 				},
		// 				OSState: to.Ptr(armcompute.OperatingSystemStateTypesGeneralized),
		// 				OSType: to.Ptr(armcompute.OperatingSystemTypesWindows),
		// 			},
		// 	}},
		// }
	}
}
