//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armconfluent

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// AccessClient contains the methods for the Access group.
// Don't use this type directly, use NewAccessClient() instead.
type AccessClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewAccessClient creates a new instance of AccessClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewAccessClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*AccessClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &AccessClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// InviteUser - Invite user to the organization
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-22
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - organizationName - Organization resource name
//   - body - Invite user account model
//   - options - AccessClientInviteUserOptions contains the optional parameters for the AccessClient.InviteUser method.
func (client *AccessClient) InviteUser(ctx context.Context, resourceGroupName string, organizationName string, body AccessInviteUserAccountModel, options *AccessClientInviteUserOptions) (AccessClientInviteUserResponse, error) {
	var err error
	const operationName = "AccessClient.InviteUser"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.inviteUserCreateRequest(ctx, resourceGroupName, organizationName, body, options)
	if err != nil {
		return AccessClientInviteUserResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AccessClientInviteUserResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AccessClientInviteUserResponse{}, err
	}
	resp, err := client.inviteUserHandleResponse(httpResp)
	return resp, err
}

// inviteUserCreateRequest creates the InviteUser request.
func (client *AccessClient) inviteUserCreateRequest(ctx context.Context, resourceGroupName string, organizationName string, body AccessInviteUserAccountModel, options *AccessClientInviteUserOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/createInvitation"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if organizationName == "" {
		return nil, errors.New("parameter organizationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{organizationName}", url.PathEscape(organizationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-22")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// inviteUserHandleResponse handles the InviteUser response.
func (client *AccessClient) inviteUserHandleResponse(resp *http.Response) (AccessClientInviteUserResponse, error) {
	result := AccessClientInviteUserResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.InvitationRecord); err != nil {
		return AccessClientInviteUserResponse{}, err
	}
	return result, nil
}

// ListClusters - Cluster details
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-22
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - organizationName - Organization resource name
//   - body - List Access Request Model
//   - options - AccessClientListClustersOptions contains the optional parameters for the AccessClient.ListClusters method.
func (client *AccessClient) ListClusters(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListClustersOptions) (AccessClientListClustersResponse, error) {
	var err error
	const operationName = "AccessClient.ListClusters"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listClustersCreateRequest(ctx, resourceGroupName, organizationName, body, options)
	if err != nil {
		return AccessClientListClustersResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AccessClientListClustersResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AccessClientListClustersResponse{}, err
	}
	resp, err := client.listClustersHandleResponse(httpResp)
	return resp, err
}

// listClustersCreateRequest creates the ListClusters request.
func (client *AccessClient) listClustersCreateRequest(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListClustersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listClusters"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if organizationName == "" {
		return nil, errors.New("parameter organizationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{organizationName}", url.PathEscape(organizationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-22")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// listClustersHandleResponse handles the ListClusters response.
func (client *AccessClient) listClustersHandleResponse(resp *http.Response) (AccessClientListClustersResponse, error) {
	result := AccessClientListClustersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessListClusterSuccessResponse); err != nil {
		return AccessClientListClustersResponse{}, err
	}
	return result, nil
}

// ListEnvironments - Environment list of an organization
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-22
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - organizationName - Organization resource name
//   - body - List Access Request Model
//   - options - AccessClientListEnvironmentsOptions contains the optional parameters for the AccessClient.ListEnvironments method.
func (client *AccessClient) ListEnvironments(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListEnvironmentsOptions) (AccessClientListEnvironmentsResponse, error) {
	var err error
	const operationName = "AccessClient.ListEnvironments"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listEnvironmentsCreateRequest(ctx, resourceGroupName, organizationName, body, options)
	if err != nil {
		return AccessClientListEnvironmentsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AccessClientListEnvironmentsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AccessClientListEnvironmentsResponse{}, err
	}
	resp, err := client.listEnvironmentsHandleResponse(httpResp)
	return resp, err
}

// listEnvironmentsCreateRequest creates the ListEnvironments request.
func (client *AccessClient) listEnvironmentsCreateRequest(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListEnvironmentsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listEnvironments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if organizationName == "" {
		return nil, errors.New("parameter organizationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{organizationName}", url.PathEscape(organizationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-22")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// listEnvironmentsHandleResponse handles the ListEnvironments response.
func (client *AccessClient) listEnvironmentsHandleResponse(resp *http.Response) (AccessClientListEnvironmentsResponse, error) {
	result := AccessClientListEnvironmentsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessListEnvironmentsSuccessResponse); err != nil {
		return AccessClientListEnvironmentsResponse{}, err
	}
	return result, nil
}

// ListInvitations - Organization accounts invitation details
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-22
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - organizationName - Organization resource name
//   - body - List Access Request Model
//   - options - AccessClientListInvitationsOptions contains the optional parameters for the AccessClient.ListInvitations method.
func (client *AccessClient) ListInvitations(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListInvitationsOptions) (AccessClientListInvitationsResponse, error) {
	var err error
	const operationName = "AccessClient.ListInvitations"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listInvitationsCreateRequest(ctx, resourceGroupName, organizationName, body, options)
	if err != nil {
		return AccessClientListInvitationsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AccessClientListInvitationsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AccessClientListInvitationsResponse{}, err
	}
	resp, err := client.listInvitationsHandleResponse(httpResp)
	return resp, err
}

// listInvitationsCreateRequest creates the ListInvitations request.
func (client *AccessClient) listInvitationsCreateRequest(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListInvitationsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listInvitations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if organizationName == "" {
		return nil, errors.New("parameter organizationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{organizationName}", url.PathEscape(organizationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-22")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// listInvitationsHandleResponse handles the ListInvitations response.
func (client *AccessClient) listInvitationsHandleResponse(resp *http.Response) (AccessClientListInvitationsResponse, error) {
	result := AccessClientListInvitationsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessListInvitationsSuccessResponse); err != nil {
		return AccessClientListInvitationsResponse{}, err
	}
	return result, nil
}

// ListRoleBindings - Organization role bindings
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-22
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - organizationName - Organization resource name
//   - body - List Access Request Model
//   - options - AccessClientListRoleBindingsOptions contains the optional parameters for the AccessClient.ListRoleBindings method.
func (client *AccessClient) ListRoleBindings(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListRoleBindingsOptions) (AccessClientListRoleBindingsResponse, error) {
	var err error
	const operationName = "AccessClient.ListRoleBindings"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listRoleBindingsCreateRequest(ctx, resourceGroupName, organizationName, body, options)
	if err != nil {
		return AccessClientListRoleBindingsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AccessClientListRoleBindingsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AccessClientListRoleBindingsResponse{}, err
	}
	resp, err := client.listRoleBindingsHandleResponse(httpResp)
	return resp, err
}

// listRoleBindingsCreateRequest creates the ListRoleBindings request.
func (client *AccessClient) listRoleBindingsCreateRequest(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListRoleBindingsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listRoleBindings"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if organizationName == "" {
		return nil, errors.New("parameter organizationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{organizationName}", url.PathEscape(organizationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-22")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// listRoleBindingsHandleResponse handles the ListRoleBindings response.
func (client *AccessClient) listRoleBindingsHandleResponse(resp *http.Response) (AccessClientListRoleBindingsResponse, error) {
	result := AccessClientListRoleBindingsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessListRoleBindingsSuccessResponse); err != nil {
		return AccessClientListRoleBindingsResponse{}, err
	}
	return result, nil
}

// ListServiceAccounts - Organization service accounts details
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-22
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - organizationName - Organization resource name
//   - body - List Access Request Model
//   - options - AccessClientListServiceAccountsOptions contains the optional parameters for the AccessClient.ListServiceAccounts
//     method.
func (client *AccessClient) ListServiceAccounts(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListServiceAccountsOptions) (AccessClientListServiceAccountsResponse, error) {
	var err error
	const operationName = "AccessClient.ListServiceAccounts"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listServiceAccountsCreateRequest(ctx, resourceGroupName, organizationName, body, options)
	if err != nil {
		return AccessClientListServiceAccountsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AccessClientListServiceAccountsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AccessClientListServiceAccountsResponse{}, err
	}
	resp, err := client.listServiceAccountsHandleResponse(httpResp)
	return resp, err
}

// listServiceAccountsCreateRequest creates the ListServiceAccounts request.
func (client *AccessClient) listServiceAccountsCreateRequest(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListServiceAccountsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listServiceAccounts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if organizationName == "" {
		return nil, errors.New("parameter organizationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{organizationName}", url.PathEscape(organizationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-22")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// listServiceAccountsHandleResponse handles the ListServiceAccounts response.
func (client *AccessClient) listServiceAccountsHandleResponse(resp *http.Response) (AccessClientListServiceAccountsResponse, error) {
	result := AccessClientListServiceAccountsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessListServiceAccountsSuccessResponse); err != nil {
		return AccessClientListServiceAccountsResponse{}, err
	}
	return result, nil
}

// ListUsers - Organization users details
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-08-22
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - organizationName - Organization resource name
//   - body - List Access Request Model
//   - options - AccessClientListUsersOptions contains the optional parameters for the AccessClient.ListUsers method.
func (client *AccessClient) ListUsers(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListUsersOptions) (AccessClientListUsersResponse, error) {
	var err error
	const operationName = "AccessClient.ListUsers"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listUsersCreateRequest(ctx, resourceGroupName, organizationName, body, options)
	if err != nil {
		return AccessClientListUsersResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return AccessClientListUsersResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return AccessClientListUsersResponse{}, err
	}
	resp, err := client.listUsersHandleResponse(httpResp)
	return resp, err
}

// listUsersCreateRequest creates the ListUsers request.
func (client *AccessClient) listUsersCreateRequest(ctx context.Context, resourceGroupName string, organizationName string, body ListAccessRequestModel, options *AccessClientListUsersOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listUsers"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if organizationName == "" {
		return nil, errors.New("parameter organizationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{organizationName}", url.PathEscape(organizationName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-08-22")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// listUsersHandleResponse handles the ListUsers response.
func (client *AccessClient) listUsersHandleResponse(resp *http.Response) (AccessClientListUsersResponse, error) {
	result := AccessClientListUsersResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessListUsersSuccessResponse); err != nil {
		return AccessClientListUsersResponse{}, err
	}
	return result, nil
}
