//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armcostmanagement_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledActions-list-private.json
func ExampleScheduledActionsClient_NewListPager_privateScheduledActionsList() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewScheduledActionsClient().NewListPager(&armcostmanagement.ScheduledActionsClientListOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ScheduledActionListResult = armcostmanagement.ScheduledActionListResult{
		// 	Value: []*armcostmanagement.ScheduledAction{
		// 		{
		// 			Name: to.Ptr("monthlyCostByResource"),
		// 			Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 			ID: to.Ptr("providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
		// 			ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
		// 			Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 			SystemData: &armcostmanagement.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				CreatedBy: to.Ptr("testuser"),
		// 				CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("testuser"),
		// 				LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcostmanagement.ScheduledActionProperties{
		// 				DisplayName: to.Ptr("Monthly Cost By Resource"),
		// 				Notification: &armcostmanagement.NotificationProperties{
		// 					Subject: to.Ptr("Cost by resource this month"),
		// 					To: []*string{
		// 						to.Ptr("user@gmail.com"),
		// 						to.Ptr("team@gmail.com")},
		// 					},
		// 					Schedule: &armcostmanagement.ScheduleProperties{
		// 						DaysOfWeek: []*armcostmanagement.DaysOfWeek{
		// 							to.Ptr(armcostmanagement.DaysOfWeekMonday)},
		// 							EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 							Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
		// 							HourOfDay: to.Ptr[int32](10),
		// 							StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 							WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
		// 								to.Ptr(armcostmanagement.WeeksOfMonthFirst),
		// 								to.Ptr(armcostmanagement.WeeksOfMonthThird)},
		// 							},
		// 							Scope: to.Ptr(""),
		// 							Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
		// 							ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("dailyCostByResource"),
		// 						Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 						ID: to.Ptr("providers/Microsoft.CostManagement/scheduledActions/dailyCostByResource"),
		// 						ETag: to.Ptr("\"1d4ff9fe66f1d15\""),
		// 						Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 						SystemData: &armcostmanagement.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							CreatedBy: to.Ptr("testuser"),
		// 							CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("testuser"),
		// 							LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 						},
		// 						Properties: &armcostmanagement.ScheduledActionProperties{
		// 							DisplayName: to.Ptr("Daily Cost By Resource"),
		// 							Notification: &armcostmanagement.NotificationProperties{
		// 								Subject: to.Ptr("Daily Cost By Resource"),
		// 								To: []*string{
		// 									to.Ptr("user@gmail.com"),
		// 									to.Ptr("team@gmail.com")},
		// 								},
		// 								Schedule: &armcostmanagement.ScheduleProperties{
		// 									EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 									Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyDaily),
		// 									HourOfDay: to.Ptr[int32](12),
		// 									StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 								},
		// 								Scope: to.Ptr(""),
		// 								Status: to.Ptr(armcostmanagement.ScheduledActionStatusDisabled),
		// 								ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledActions-listWithFilter-private.json
func ExampleScheduledActionsClient_NewListPager_privateScheduledActionsListFilterByViewId() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewScheduledActionsClient().NewListPager(&armcostmanagement.ScheduledActionsClientListOptions{Filter: to.Ptr("properties/viewId eq '/providers/Microsoft.CostManagement/views/swaggerExample'")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ScheduledActionListResult = armcostmanagement.ScheduledActionListResult{
		// 	Value: []*armcostmanagement.ScheduledAction{
		// 		{
		// 			Name: to.Ptr("monthlyCostByResource"),
		// 			Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 			ID: to.Ptr("providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
		// 			ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
		// 			Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 			SystemData: &armcostmanagement.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				CreatedBy: to.Ptr("testuser"),
		// 				CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("testuser"),
		// 				LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcostmanagement.ScheduledActionProperties{
		// 				DisplayName: to.Ptr("Monthly Cost By Resource"),
		// 				Notification: &armcostmanagement.NotificationProperties{
		// 					Subject: to.Ptr("Cost by resource this month"),
		// 					To: []*string{
		// 						to.Ptr("user@gmail.com"),
		// 						to.Ptr("team@gmail.com")},
		// 					},
		// 					Schedule: &armcostmanagement.ScheduleProperties{
		// 						DaysOfWeek: []*armcostmanagement.DaysOfWeek{
		// 							to.Ptr(armcostmanagement.DaysOfWeekMonday)},
		// 							EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 							Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
		// 							HourOfDay: to.Ptr[int32](10),
		// 							StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 							WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
		// 								to.Ptr(armcostmanagement.WeeksOfMonthFirst),
		// 								to.Ptr(armcostmanagement.WeeksOfMonthThird)},
		// 							},
		// 							Scope: to.Ptr(""),
		// 							Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
		// 							ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("dailyCostByResource"),
		// 						Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 						ID: to.Ptr("providers/Microsoft.CostManagement/scheduledActions/dailyCostByResource"),
		// 						ETag: to.Ptr("\"1d4ff9fe66f1d15\""),
		// 						Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 						SystemData: &armcostmanagement.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							CreatedBy: to.Ptr("testuser"),
		// 							CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("testuser"),
		// 							LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 						},
		// 						Properties: &armcostmanagement.ScheduledActionProperties{
		// 							DisplayName: to.Ptr("Daily Cost By Resource"),
		// 							Notification: &armcostmanagement.NotificationProperties{
		// 								Subject: to.Ptr("Daily Cost By Resource"),
		// 								To: []*string{
		// 									to.Ptr("user@gmail.com"),
		// 									to.Ptr("team@gmail.com")},
		// 								},
		// 								Schedule: &armcostmanagement.ScheduleProperties{
		// 									EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 									Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyDaily),
		// 									HourOfDay: to.Ptr[int32](12),
		// 									StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 								},
		// 								Scope: to.Ptr(""),
		// 								Status: to.Ptr(armcostmanagement.ScheduledActionStatusDisabled),
		// 								ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledActions-list-shared.json
func ExampleScheduledActionsClient_NewListByScopePager_scheduledActionsListByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewScheduledActionsClient().NewListByScopePager("subscriptions/00000000-0000-0000-0000-000000000000", &armcostmanagement.ScheduledActionsClientListByScopeOptions{Filter: nil})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ScheduledActionListResult = armcostmanagement.ScheduledActionListResult{
		// 	Value: []*armcostmanagement.ScheduledAction{
		// 		{
		// 			Name: to.Ptr("monthlyCostByResource"),
		// 			Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
		// 			ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
		// 			Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 			SystemData: &armcostmanagement.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				CreatedBy: to.Ptr("testuser"),
		// 				CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("testuser"),
		// 				LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcostmanagement.ScheduledActionProperties{
		// 				DisplayName: to.Ptr("Monthly Cost By Resource"),
		// 				Notification: &armcostmanagement.NotificationProperties{
		// 					Subject: to.Ptr("Cost by resource this month"),
		// 					To: []*string{
		// 						to.Ptr("user@gmail.com"),
		// 						to.Ptr("team@gmail.com")},
		// 					},
		// 					Schedule: &armcostmanagement.ScheduleProperties{
		// 						DaysOfWeek: []*armcostmanagement.DaysOfWeek{
		// 							to.Ptr(armcostmanagement.DaysOfWeekMonday)},
		// 							EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 							Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
		// 							HourOfDay: to.Ptr[int32](10),
		// 							StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 							WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
		// 								to.Ptr(armcostmanagement.WeeksOfMonthFirst),
		// 								to.Ptr(armcostmanagement.WeeksOfMonthThird)},
		// 							},
		// 							Scope: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000"),
		// 							Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
		// 							ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("dailyCostByResource"),
		// 						Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 						ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/dailyCostByResource"),
		// 						ETag: to.Ptr("\"1d4ff9fe66f1d15\""),
		// 						Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 						SystemData: &armcostmanagement.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							CreatedBy: to.Ptr("testuser"),
		// 							CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("testuser"),
		// 							LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 						},
		// 						Properties: &armcostmanagement.ScheduledActionProperties{
		// 							DisplayName: to.Ptr("Daily Cost By Resource"),
		// 							Notification: &armcostmanagement.NotificationProperties{
		// 								Subject: to.Ptr("Daily Cost By Resource"),
		// 								To: []*string{
		// 									to.Ptr("user@gmail.com"),
		// 									to.Ptr("team@gmail.com")},
		// 								},
		// 								Schedule: &armcostmanagement.ScheduleProperties{
		// 									EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 									Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyDaily),
		// 									HourOfDay: to.Ptr[int32](12),
		// 									StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 								},
		// 								Scope: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000"),
		// 								Status: to.Ptr(armcostmanagement.ScheduledActionStatusDisabled),
		// 								ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledActions-listWithFilter-shared.json
func ExampleScheduledActionsClient_NewListByScopePager_scheduledActionsListByScopeFilterByViewId() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewScheduledActionsClient().NewListByScopePager("subscriptions/00000000-0000-0000-0000-000000000000", &armcostmanagement.ScheduledActionsClientListByScopeOptions{Filter: to.Ptr("properties/viewId eq '/providers/Microsoft.CostManagement/views/swaggerExample'")})
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ScheduledActionListResult = armcostmanagement.ScheduledActionListResult{
		// 	Value: []*armcostmanagement.ScheduledAction{
		// 		{
		// 			Name: to.Ptr("monthlyCostByResource"),
		// 			Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 			ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
		// 			ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
		// 			Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 			SystemData: &armcostmanagement.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				CreatedBy: to.Ptr("testuser"),
		// 				CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("testuser"),
		// 				LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 			},
		// 			Properties: &armcostmanagement.ScheduledActionProperties{
		// 				DisplayName: to.Ptr("Monthly Cost By Resource"),
		// 				Notification: &armcostmanagement.NotificationProperties{
		// 					Subject: to.Ptr("Cost by resource this month"),
		// 					To: []*string{
		// 						to.Ptr("user@gmail.com"),
		// 						to.Ptr("team@gmail.com")},
		// 					},
		// 					Schedule: &armcostmanagement.ScheduleProperties{
		// 						DaysOfWeek: []*armcostmanagement.DaysOfWeek{
		// 							to.Ptr(armcostmanagement.DaysOfWeekMonday)},
		// 							EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 							Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
		// 							HourOfDay: to.Ptr[int32](10),
		// 							StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 							WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
		// 								to.Ptr(armcostmanagement.WeeksOfMonthFirst),
		// 								to.Ptr(armcostmanagement.WeeksOfMonthThird)},
		// 							},
		// 							Scope: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000"),
		// 							Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
		// 							ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 						},
		// 					},
		// 					{
		// 						Name: to.Ptr("dailyCostByResource"),
		// 						Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
		// 						ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/dailyCostByResource"),
		// 						ETag: to.Ptr("\"1d4ff9fe66f1d15\""),
		// 						Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		// 						SystemData: &armcostmanagement.SystemData{
		// 							CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							CreatedBy: to.Ptr("testuser"),
		// 							CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 							LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
		// 							LastModifiedBy: to.Ptr("testuser"),
		// 							LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
		// 						},
		// 						Properties: &armcostmanagement.ScheduledActionProperties{
		// 							DisplayName: to.Ptr("Daily Cost By Resource"),
		// 							Notification: &armcostmanagement.NotificationProperties{
		// 								Subject: to.Ptr("Daily Cost By Resource"),
		// 								To: []*string{
		// 									to.Ptr("user@gmail.com"),
		// 									to.Ptr("team@gmail.com")},
		// 								},
		// 								Schedule: &armcostmanagement.ScheduleProperties{
		// 									EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
		// 									Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyDaily),
		// 									HourOfDay: to.Ptr[int32](12),
		// 									StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
		// 								},
		// 								Scope: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000"),
		// 								Status: to.Ptr(armcostmanagement.ScheduledActionStatusDisabled),
		// 								ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		// 							},
		// 					}},
		// 				}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-createOrUpdate-private.json
func ExampleScheduledActionsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduledActionsClient().CreateOrUpdate(ctx, "monthlyCostByResource", armcostmanagement.ScheduledAction{
		Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		Properties: &armcostmanagement.ScheduledActionProperties{
			DisplayName: to.Ptr("Monthly Cost By Resource"),
			Notification: &armcostmanagement.NotificationProperties{
				Subject: to.Ptr("Cost by resource this month"),
				To: []*string{
					to.Ptr("user@gmail.com"),
					to.Ptr("team@gmail.com")},
			},
			Schedule: &armcostmanagement.ScheduleProperties{
				DaysOfWeek: []*armcostmanagement.DaysOfWeek{
					to.Ptr(armcostmanagement.DaysOfWeekMonday)},
				EndDate:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t }()),
				Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
				HourOfDay: to.Ptr[int32](10),
				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t }()),
				WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
					to.Ptr(armcostmanagement.WeeksOfMonthFirst),
					to.Ptr(armcostmanagement.WeeksOfMonthThird)},
			},
			Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
			ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		},
	}, &armcostmanagement.ScheduledActionsClientCreateOrUpdateOptions{IfMatch: to.Ptr("")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScheduledAction = armcostmanagement.ScheduledAction{
	// 	Name: to.Ptr("monthlyCostByResource"),
	// 	Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
	// 	ID: to.Ptr("providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
	// 	ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
	// 	Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
	// 	SystemData: &armcostmanagement.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
	// 		CreatedBy: to.Ptr("testuser"),
	// 		CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("testuser"),
	// 		LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcostmanagement.ScheduledActionProperties{
	// 		DisplayName: to.Ptr("Monthly Cost By Resource"),
	// 		Notification: &armcostmanagement.NotificationProperties{
	// 			RegionalFormat: to.Ptr("fr"),
	// 			Subject: to.Ptr("Cost by resource this month"),
	// 			To: []*string{
	// 				to.Ptr("user@gmail.com"),
	// 				to.Ptr("team@gmail.com")},
	// 				Language: to.Ptr("fr"),
	// 			},
	// 			Schedule: &armcostmanagement.ScheduleProperties{
	// 				DaysOfWeek: []*armcostmanagement.DaysOfWeek{
	// 					to.Ptr(armcostmanagement.DaysOfWeekMonday)},
	// 					EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
	// 					Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
	// 					HourOfDay: to.Ptr[int32](10),
	// 					StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 					WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
	// 						to.Ptr(armcostmanagement.WeeksOfMonthFirst),
	// 						to.Ptr(armcostmanagement.WeeksOfMonthThird)},
	// 					},
	// 					Scope: to.Ptr(""),
	// 					Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
	// 					ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-get-private.json
func ExampleScheduledActionsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduledActionsClient().Get(ctx, "monthlyCostByResource", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScheduledAction = armcostmanagement.ScheduledAction{
	// 	Name: to.Ptr("monthlyCostByResource"),
	// 	Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
	// 	ID: to.Ptr("providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
	// 	ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
	// 	Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
	// 	SystemData: &armcostmanagement.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
	// 		CreatedBy: to.Ptr("testuser"),
	// 		CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("testuser"),
	// 		LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcostmanagement.ScheduledActionProperties{
	// 		DisplayName: to.Ptr("Monthly Cost By Resource"),
	// 		Notification: &armcostmanagement.NotificationProperties{
	// 			Subject: to.Ptr("Cost by resource this month"),
	// 			To: []*string{
	// 				to.Ptr("user@gmail.com"),
	// 				to.Ptr("team@gmail.com")},
	// 			},
	// 			Schedule: &armcostmanagement.ScheduleProperties{
	// 				DaysOfWeek: []*armcostmanagement.DaysOfWeek{
	// 					to.Ptr(armcostmanagement.DaysOfWeekMonday)},
	// 					EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
	// 					Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
	// 					HourOfDay: to.Ptr[int32](10),
	// 					StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 					WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
	// 						to.Ptr(armcostmanagement.WeeksOfMonthFirst),
	// 						to.Ptr(armcostmanagement.WeeksOfMonthThird)},
	// 					},
	// 					Scope: to.Ptr(""),
	// 					Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
	// 					ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-delete-private.json
func ExampleScheduledActionsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewScheduledActionsClient().Delete(ctx, "monthlyCostByResource", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-insightAlert-createOrUpdate-shared.json
func ExampleScheduledActionsClient_CreateOrUpdateByScope_createOrUpdateInsightAlertScheduledActionByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduledActionsClient().CreateOrUpdateByScope(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "dailyAnomalyByResource", armcostmanagement.ScheduledAction{
		Kind: to.Ptr(armcostmanagement.ScheduledActionKindInsightAlert),
		Properties: &armcostmanagement.ScheduledActionProperties{
			DisplayName: to.Ptr("Daily anomaly by resource"),
			Notification: &armcostmanagement.NotificationProperties{
				Subject: to.Ptr("Cost anomaly detected in the resource"),
				To: []*string{
					to.Ptr("user@gmail.com"),
					to.Ptr("team@gmail.com")},
			},
			Schedule: &armcostmanagement.ScheduleProperties{
				EndDate:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t }()),
				Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyDaily),
				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t }()),
			},
			Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
			ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		},
	}, &armcostmanagement.ScheduledActionsClientCreateOrUpdateByScopeOptions{IfMatch: to.Ptr("")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScheduledAction = armcostmanagement.ScheduledAction{
	// 	Name: to.Ptr("dailyAnomalyByResource"),
	// 	Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/dailyAnomalyByResource"),
	// 	ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
	// 	Kind: to.Ptr(armcostmanagement.ScheduledActionKindInsightAlert),
	// 	SystemData: &armcostmanagement.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
	// 		CreatedBy: to.Ptr("testuser"),
	// 		CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("testuser"),
	// 		LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcostmanagement.ScheduledActionProperties{
	// 		DisplayName: to.Ptr("Daily anomaly by resource"),
	// 		FileDestination: &armcostmanagement.FileDestination{
	// 			FileFormats: []*armcostmanagement.FileFormat{
	// 			},
	// 		},
	// 		Notification: &armcostmanagement.NotificationProperties{
	// 			Subject: to.Ptr("Cost anomaly detected in the resource"),
	// 			To: []*string{
	// 				to.Ptr("user@gmail.com"),
	// 				to.Ptr("team@gmail.com")},
	// 			},
	// 			Schedule: &armcostmanagement.ScheduleProperties{
	// 				EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
	// 				Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyDaily),
	// 				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 			},
	// 			Scope: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000"),
	// 			Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
	// 			ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-createOrUpdate-shared.json
func ExampleScheduledActionsClient_CreateOrUpdateByScope_createOrUpdateScheduledActionByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduledActionsClient().CreateOrUpdateByScope(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "monthlyCostByResource", armcostmanagement.ScheduledAction{
		Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
		Properties: &armcostmanagement.ScheduledActionProperties{
			DisplayName: to.Ptr("Monthly Cost By Resource"),
			FileDestination: &armcostmanagement.FileDestination{
				FileFormats: []*armcostmanagement.FileFormat{
					to.Ptr(armcostmanagement.FileFormatCSV)},
			},
			Notification: &armcostmanagement.NotificationProperties{
				Subject: to.Ptr("Cost by resource this month"),
				To: []*string{
					to.Ptr("user@gmail.com"),
					to.Ptr("team@gmail.com")},
			},
			Schedule: &armcostmanagement.ScheduleProperties{
				DaysOfWeek: []*armcostmanagement.DaysOfWeek{
					to.Ptr(armcostmanagement.DaysOfWeekMonday)},
				EndDate:   to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t }()),
				Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
				HourOfDay: to.Ptr[int32](10),
				StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t }()),
				WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
					to.Ptr(armcostmanagement.WeeksOfMonthFirst),
					to.Ptr(armcostmanagement.WeeksOfMonthThird)},
			},
			Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
			ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
		},
	}, &armcostmanagement.ScheduledActionsClientCreateOrUpdateByScopeOptions{IfMatch: to.Ptr("")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScheduledAction = armcostmanagement.ScheduledAction{
	// 	Name: to.Ptr("monthlyCostByResource"),
	// 	Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
	// 	ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
	// 	Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
	// 	SystemData: &armcostmanagement.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
	// 		CreatedBy: to.Ptr("testuser"),
	// 		CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("testuser"),
	// 		LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcostmanagement.ScheduledActionProperties{
	// 		DisplayName: to.Ptr("Monthly Cost By Resource"),
	// 		Notification: &armcostmanagement.NotificationProperties{
	// 			Subject: to.Ptr("Cost by resource this month"),
	// 			To: []*string{
	// 				to.Ptr("user@gmail.com"),
	// 				to.Ptr("team@gmail.com")},
	// 			},
	// 			Schedule: &armcostmanagement.ScheduleProperties{
	// 				DaysOfWeek: []*armcostmanagement.DaysOfWeek{
	// 					to.Ptr(armcostmanagement.DaysOfWeekMonday)},
	// 					EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
	// 					Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
	// 					HourOfDay: to.Ptr[int32](10),
	// 					StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 					WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
	// 						to.Ptr(armcostmanagement.WeeksOfMonthFirst),
	// 						to.Ptr(armcostmanagement.WeeksOfMonthThird)},
	// 					},
	// 					Scope: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000"),
	// 					Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
	// 					ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-get-shared.json
func ExampleScheduledActionsClient_GetByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduledActionsClient().GetByScope(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "monthlyCostByResource", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ScheduledAction = armcostmanagement.ScheduledAction{
	// 	Name: to.Ptr("monthlyCostByResource"),
	// 	Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
	// 	ID: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.CostManagement/scheduledActions/monthlyCostByResource"),
	// 	ETag: to.Ptr("\"1d4ff9fe66f1d10\""),
	// 	Kind: to.Ptr(armcostmanagement.ScheduledActionKindEmail),
	// 	SystemData: &armcostmanagement.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
	// 		CreatedBy: to.Ptr("testuser"),
	// 		CreatedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-18T22:21:51.128Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("testuser"),
	// 		LastModifiedByType: to.Ptr(armcostmanagement.CreatedByTypeUser),
	// 	},
	// 	Properties: &armcostmanagement.ScheduledActionProperties{
	// 		DisplayName: to.Ptr("Monthly Cost By Resource"),
	// 		Notification: &armcostmanagement.NotificationProperties{
	// 			Subject: to.Ptr("Cost by resource this month"),
	// 			To: []*string{
	// 				to.Ptr("user@gmail.com"),
	// 				to.Ptr("team@gmail.com")},
	// 			},
	// 			Schedule: &armcostmanagement.ScheduleProperties{
	// 				DaysOfWeek: []*armcostmanagement.DaysOfWeek{
	// 					to.Ptr(armcostmanagement.DaysOfWeekMonday)},
	// 					EndDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-06-19T22:21:51.128Z"); return t}()),
	// 					Frequency: to.Ptr(armcostmanagement.ScheduleFrequencyMonthly),
	// 					HourOfDay: to.Ptr[int32](10),
	// 					StartDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2020-06-19T22:21:51.128Z"); return t}()),
	// 					WeeksOfMonth: []*armcostmanagement.WeeksOfMonth{
	// 						to.Ptr(armcostmanagement.WeeksOfMonthFirst),
	// 						to.Ptr(armcostmanagement.WeeksOfMonthThird)},
	// 					},
	// 					Scope: to.Ptr("subscriptions/00000000-0000-0000-0000-000000000000"),
	// 					Status: to.Ptr(armcostmanagement.ScheduledActionStatusEnabled),
	// 					ViewID: to.Ptr("/providers/Microsoft.CostManagement/views/swaggerExample"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-delete-shared.json
func ExampleScheduledActionsClient_DeleteByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewScheduledActionsClient().DeleteByScope(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "monthlyCostByResource", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-sendNow-private.json
func ExampleScheduledActionsClient_Run() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewScheduledActionsClient().Run(ctx, "monthlyCostByResource", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/scheduledAction-sendNow-shared.json
func ExampleScheduledActionsClient_RunByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewScheduledActionsClient().RunByScope(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", "monthlyCostByResource", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/checkNameAvailability-private-scheduledAction.json
func ExampleScheduledActionsClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduledActionsClient().CheckNameAvailability(ctx, armcostmanagement.CheckNameAvailabilityRequest{
		Name: to.Ptr("testName"),
		Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResponse = armcostmanagement.CheckNameAvailabilityResponse{
	// 	Message: to.Ptr("A private scheduled action with name 'testName' is already present. Please specify a differnt name."),
	// 	NameAvailable: to.Ptr(false),
	// 	Reason: to.Ptr(armcostmanagement.CheckNameAvailabilityReasonAlreadyExists),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/17aa6a1314de5aafef059d9aa2229901df506e75/specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/scheduledActions/checkNameAvailability-shared-scheduledAction.json
func ExampleScheduledActionsClient_CheckNameAvailabilityByScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armcostmanagement.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewScheduledActionsClient().CheckNameAvailabilityByScope(ctx, "subscriptions/00000000-0000-0000-0000-000000000000", armcostmanagement.CheckNameAvailabilityRequest{
		Name: to.Ptr("testName"),
		Type: to.Ptr("Microsoft.CostManagement/ScheduledActions"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CheckNameAvailabilityResponse = armcostmanagement.CheckNameAvailabilityResponse{
	// 	NameAvailable: to.Ptr(true),
	// }
}
