//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/customerinsights/armcustomerinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ConnectorMappingsServer is a fake server for instances of the armcustomerinsights.ConnectorMappingsClient type.
type ConnectorMappingsServer struct {
	// CreateOrUpdate is the fake for method ConnectorMappingsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, hubName string, connectorName string, mappingName string, parameters armcustomerinsights.ConnectorMappingResourceFormat, options *armcustomerinsights.ConnectorMappingsClientCreateOrUpdateOptions) (resp azfake.Responder[armcustomerinsights.ConnectorMappingsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ConnectorMappingsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, hubName string, connectorName string, mappingName string, options *armcustomerinsights.ConnectorMappingsClientDeleteOptions) (resp azfake.Responder[armcustomerinsights.ConnectorMappingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ConnectorMappingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, hubName string, connectorName string, mappingName string, options *armcustomerinsights.ConnectorMappingsClientGetOptions) (resp azfake.Responder[armcustomerinsights.ConnectorMappingsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByConnectorPager is the fake for method ConnectorMappingsClient.NewListByConnectorPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByConnectorPager func(resourceGroupName string, hubName string, connectorName string, options *armcustomerinsights.ConnectorMappingsClientListByConnectorOptions) (resp azfake.PagerResponder[armcustomerinsights.ConnectorMappingsClientListByConnectorResponse])
}

// NewConnectorMappingsServerTransport creates a new instance of ConnectorMappingsServerTransport with the provided implementation.
// The returned ConnectorMappingsServerTransport instance is connected to an instance of armcustomerinsights.ConnectorMappingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConnectorMappingsServerTransport(srv *ConnectorMappingsServer) *ConnectorMappingsServerTransport {
	return &ConnectorMappingsServerTransport{
		srv:                     srv,
		newListByConnectorPager: newTracker[azfake.PagerResponder[armcustomerinsights.ConnectorMappingsClientListByConnectorResponse]](),
	}
}

// ConnectorMappingsServerTransport connects instances of armcustomerinsights.ConnectorMappingsClient to instances of ConnectorMappingsServer.
// Don't use this type directly, use NewConnectorMappingsServerTransport instead.
type ConnectorMappingsServerTransport struct {
	srv                     *ConnectorMappingsServer
	newListByConnectorPager *tracker[azfake.PagerResponder[armcustomerinsights.ConnectorMappingsClientListByConnectorResponse]]
}

// Do implements the policy.Transporter interface for ConnectorMappingsServerTransport.
func (c *ConnectorMappingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConnectorMappingsClient.CreateOrUpdate":
		resp, err = c.dispatchCreateOrUpdate(req)
	case "ConnectorMappingsClient.Delete":
		resp, err = c.dispatchDelete(req)
	case "ConnectorMappingsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConnectorMappingsClient.NewListByConnectorPager":
		resp, err = c.dispatchNewListByConnectorPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConnectorMappingsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if c.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mappings/(?P<mappingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcustomerinsights.ConnectorMappingResourceFormat](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
	if err != nil {
		return nil, err
	}
	mappingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mappingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, hubNameParam, connectorNameParam, mappingNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectorMappingResourceFormat, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectorMappingsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if c.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mappings/(?P<mappingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
	if err != nil {
		return nil, err
	}
	mappingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mappingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Delete(req.Context(), resourceGroupNameParam, hubNameParam, connectorNameParam, mappingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectorMappingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mappings/(?P<mappingName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
	if err != nil {
		return nil, err
	}
	connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
	if err != nil {
		return nil, err
	}
	mappingNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("mappingName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, hubNameParam, connectorNameParam, mappingNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConnectorMappingResourceFormat, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConnectorMappingsServerTransport) dispatchNewListByConnectorPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByConnectorPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByConnectorPager not implemented")}
	}
	newListByConnectorPager := c.newListByConnectorPager.get(req)
	if newListByConnectorPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CustomerInsights/hubs/(?P<hubName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connectors/(?P<connectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mappings`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		hubNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("hubName")])
		if err != nil {
			return nil, err
		}
		connectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("connectorName")])
		if err != nil {
			return nil, err
		}
		resp := c.srv.NewListByConnectorPager(resourceGroupNameParam, hubNameParam, connectorNameParam, nil)
		newListByConnectorPager = &resp
		c.newListByConnectorPager.add(req, newListByConnectorPager)
		server.PagerResponderInjectNextLinks(newListByConnectorPager, req, func(page *armcustomerinsights.ConnectorMappingsClientListByConnectorResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByConnectorPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByConnectorPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByConnectorPager) {
		c.newListByConnectorPager.remove(req)
	}
	return resp, nil
}
