//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhdinsightcontainers

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AksClusterProfileAksClusterAgentPoolIdentityProfile.
func (a AksClusterProfileAksClusterAgentPoolIdentityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "msiClientId", a.MsiClientID)
	populate(objectMap, "msiObjectId", a.MsiObjectID)
	populate(objectMap, "msiResourceId", a.MsiResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AksClusterProfileAksClusterAgentPoolIdentityProfile.
func (a *AksClusterProfileAksClusterAgentPoolIdentityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "msiClientId":
			err = unpopulate(val, "MsiClientID", &a.MsiClientID)
			delete(rawMsg, key)
		case "msiObjectId":
			err = unpopulate(val, "MsiObjectID", &a.MsiObjectID)
			delete(rawMsg, key)
		case "msiResourceId":
			err = unpopulate(val, "MsiResourceID", &a.MsiResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AuthorizationProfile.
func (a AuthorizationProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupIds", a.GroupIDs)
	populate(objectMap, "userIds", a.UserIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AuthorizationProfile.
func (a *AuthorizationProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupIds":
			err = unpopulate(val, "GroupIDs", &a.GroupIDs)
			delete(rawMsg, key)
		case "userIds":
			err = unpopulate(val, "UserIDs", &a.UserIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoscaleProfile.
func (a AutoscaleProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoscaleType", a.AutoscaleType)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "gracefulDecommissionTimeout", a.GracefulDecommissionTimeout)
	populate(objectMap, "loadBasedConfig", a.LoadBasedConfig)
	populate(objectMap, "scheduleBasedConfig", a.ScheduleBasedConfig)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoscaleProfile.
func (a *AutoscaleProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoscaleType":
			err = unpopulate(val, "AutoscaleType", &a.AutoscaleType)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "gracefulDecommissionTimeout":
			err = unpopulate(val, "GracefulDecommissionTimeout", &a.GracefulDecommissionTimeout)
			delete(rawMsg, key)
		case "loadBasedConfig":
			err = unpopulate(val, "LoadBasedConfig", &a.LoadBasedConfig)
			delete(rawMsg, key)
		case "scheduleBasedConfig":
			err = unpopulate(val, "ScheduleBasedConfig", &a.ScheduleBasedConfig)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CatalogOptions.
func (c CatalogOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hive", c.Hive)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CatalogOptions.
func (c *CatalogOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hive":
			err = unpopulate(val, "Hive", &c.Hive)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Cluster.
func (c *Cluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterComponentsItem.
func (c ClusterComponentsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterComponentsItem.
func (c *ClusterComponentsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterConfigFile.
func (c ClusterConfigFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", c.Content)
	populate(objectMap, "encoding", c.Encoding)
	populate(objectMap, "fileName", c.FileName)
	populate(objectMap, "path", c.Path)
	populate(objectMap, "values", c.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterConfigFile.
func (c *ClusterConfigFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &c.Content)
			delete(rawMsg, key)
		case "encoding":
			err = unpopulate(val, "Encoding", &c.Encoding)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &c.FileName)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &c.Path)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &c.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterInstanceViewPropertiesStatus.
func (c ClusterInstanceViewPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "ready", c.Ready)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterInstanceViewPropertiesStatus.
func (c *ClusterInstanceViewPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &c.Ready)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterInstanceViewResult.
func (c ClusterInstanceViewResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterInstanceViewResult.
func (c *ClusterInstanceViewResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterInstanceViewResultProperties.
func (c ClusterInstanceViewResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "serviceStatuses", c.ServiceStatuses)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterInstanceViewResultProperties.
func (c *ClusterInstanceViewResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "serviceStatuses":
			err = unpopulate(val, "ServiceStatuses", &c.ServiceStatuses)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterInstanceViewsResult.
func (c ClusterInstanceViewsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterInstanceViewsResult.
func (c *ClusterInstanceViewsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterJob.
func (c ClusterJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterJob.
func (c *ClusterJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			c.Properties, err = unmarshalClusterJobPropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterJobList.
func (c ClusterJobList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterJobList.
func (c *ClusterJobList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterJobProperties.
func (c ClusterJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["jobType"] = c.JobType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterJobProperties.
func (c *ClusterJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobType":
			err = unpopulate(val, "JobType", &c.JobType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterListResult.
func (c ClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterListResult.
func (c *ClusterListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterLogAnalyticsApplicationLogs.
func (c ClusterLogAnalyticsApplicationLogs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "stdErrorEnabled", c.StdErrorEnabled)
	populate(objectMap, "stdOutEnabled", c.StdOutEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterLogAnalyticsApplicationLogs.
func (c *ClusterLogAnalyticsApplicationLogs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "stdErrorEnabled":
			err = unpopulate(val, "StdErrorEnabled", &c.StdErrorEnabled)
			delete(rawMsg, key)
		case "stdOutEnabled":
			err = unpopulate(val, "StdOutEnabled", &c.StdOutEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterLogAnalyticsProfile.
func (c ClusterLogAnalyticsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationLogs", c.ApplicationLogs)
	populate(objectMap, "enabled", c.Enabled)
	populate(objectMap, "metricsEnabled", c.MetricsEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterLogAnalyticsProfile.
func (c *ClusterLogAnalyticsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationLogs":
			err = unpopulate(val, "ApplicationLogs", &c.ApplicationLogs)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "metricsEnabled":
			err = unpopulate(val, "MetricsEnabled", &c.MetricsEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPatch.
func (c ClusterPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPatch.
func (c *ClusterPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPatchProperties.
func (c ClusterPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterProfile", c.ClusterProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPatchProperties.
func (c *ClusterPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterProfile":
			err = unpopulate(val, "ClusterProfile", &c.ClusterProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPool.
func (c ClusterPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPool.
func (c *ClusterPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolListResult.
func (c ClusterPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolListResult.
func (c *ClusterPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolResourceProperties.
func (c ClusterPoolResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aksClusterProfile", c.AksClusterProfile)
	populate(objectMap, "aksManagedResourceGroupName", c.AksManagedResourceGroupName)
	populate(objectMap, "clusterPoolProfile", c.ClusterPoolProfile)
	populate(objectMap, "computeProfile", c.ComputeProfile)
	populate(objectMap, "deploymentId", c.DeploymentID)
	populate(objectMap, "logAnalyticsProfile", c.LogAnalyticsProfile)
	populate(objectMap, "managedResourceGroupName", c.ManagedResourceGroupName)
	populate(objectMap, "networkProfile", c.NetworkProfile)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolResourceProperties.
func (c *ClusterPoolResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aksClusterProfile":
			err = unpopulate(val, "AksClusterProfile", &c.AksClusterProfile)
			delete(rawMsg, key)
		case "aksManagedResourceGroupName":
			err = unpopulate(val, "AksManagedResourceGroupName", &c.AksManagedResourceGroupName)
			delete(rawMsg, key)
		case "clusterPoolProfile":
			err = unpopulate(val, "ClusterPoolProfile", &c.ClusterPoolProfile)
			delete(rawMsg, key)
		case "computeProfile":
			err = unpopulate(val, "ComputeProfile", &c.ComputeProfile)
			delete(rawMsg, key)
		case "deploymentId":
			err = unpopulate(val, "DeploymentID", &c.DeploymentID)
			delete(rawMsg, key)
		case "logAnalyticsProfile":
			err = unpopulate(val, "LogAnalyticsProfile", &c.LogAnalyticsProfile)
			delete(rawMsg, key)
		case "managedResourceGroupName":
			err = unpopulate(val, "ManagedResourceGroupName", &c.ManagedResourceGroupName)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &c.NetworkProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolResourcePropertiesAksClusterProfile.
func (c ClusterPoolResourcePropertiesAksClusterProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aksClusterAgentPoolIdentityProfile", c.AksClusterAgentPoolIdentityProfile)
	populate(objectMap, "aksClusterResourceId", c.AksClusterResourceID)
	populate(objectMap, "aksVersion", c.AksVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolResourcePropertiesAksClusterProfile.
func (c *ClusterPoolResourcePropertiesAksClusterProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aksClusterAgentPoolIdentityProfile":
			err = unpopulate(val, "AksClusterAgentPoolIdentityProfile", &c.AksClusterAgentPoolIdentityProfile)
			delete(rawMsg, key)
		case "aksClusterResourceId":
			err = unpopulate(val, "AksClusterResourceID", &c.AksClusterResourceID)
			delete(rawMsg, key)
		case "aksVersion":
			err = unpopulate(val, "AksVersion", &c.AksVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolResourcePropertiesClusterPoolProfile.
func (c ClusterPoolResourcePropertiesClusterPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterPoolVersion", c.ClusterPoolVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolResourcePropertiesClusterPoolProfile.
func (c *ClusterPoolResourcePropertiesClusterPoolProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterPoolVersion":
			err = unpopulate(val, "ClusterPoolVersion", &c.ClusterPoolVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolResourcePropertiesComputeProfile.
func (c ClusterPoolResourcePropertiesComputeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", c.Count)
	populate(objectMap, "vmSize", c.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolResourcePropertiesComputeProfile.
func (c *ClusterPoolResourcePropertiesComputeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &c.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolResourcePropertiesLogAnalyticsProfile.
func (c ClusterPoolResourcePropertiesLogAnalyticsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", c.Enabled)
	populate(objectMap, "workspaceId", c.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolResourcePropertiesLogAnalyticsProfile.
func (c *ClusterPoolResourcePropertiesLogAnalyticsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &c.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolResourcePropertiesNetworkProfile.
func (c ClusterPoolResourcePropertiesNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetId", c.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolResourcePropertiesNetworkProfile.
func (c *ClusterPoolResourcePropertiesNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetId":
			err = unpopulate(val, "SubnetID", &c.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolVersion.
func (c ClusterPoolVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolVersion.
func (c *ClusterPoolVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolVersionProperties.
func (c ClusterPoolVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aksVersion", c.AksVersion)
	populate(objectMap, "clusterPoolVersion", c.ClusterPoolVersion)
	populate(objectMap, "isPreview", c.IsPreview)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolVersionProperties.
func (c *ClusterPoolVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aksVersion":
			err = unpopulate(val, "AksVersion", &c.AksVersion)
			delete(rawMsg, key)
		case "clusterPoolVersion":
			err = unpopulate(val, "ClusterPoolVersion", &c.ClusterPoolVersion)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &c.IsPreview)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPoolVersionsListResult.
func (c ClusterPoolVersionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPoolVersionsListResult.
func (c *ClusterPoolVersionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterProfile.
func (c ClusterProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationProfile", c.AuthorizationProfile)
	populate(objectMap, "autoscaleProfile", c.AutoscaleProfile)
	populate(objectMap, "clusterVersion", c.ClusterVersion)
	populate(objectMap, "components", c.Components)
	populate(objectMap, "connectivityProfile", c.ConnectivityProfile)
	populate(objectMap, "flinkProfile", c.FlinkProfile)
	populate(objectMap, "identityProfile", c.IdentityProfile)
	populate(objectMap, "kafkaProfile", c.KafkaProfile)
	populate(objectMap, "llapProfile", c.LlapProfile)
	populate(objectMap, "logAnalyticsProfile", c.LogAnalyticsProfile)
	populate(objectMap, "ossVersion", c.OssVersion)
	populate(objectMap, "prometheusProfile", c.PrometheusProfile)
	populate(objectMap, "sshProfile", c.SSHProfile)
	populate(objectMap, "scriptActionProfiles", c.ScriptActionProfiles)
	populate(objectMap, "secretsProfile", c.SecretsProfile)
	populate(objectMap, "serviceConfigsProfiles", c.ServiceConfigsProfiles)
	populate(objectMap, "sparkProfile", c.SparkProfile)
	populate(objectMap, "stubProfile", c.StubProfile)
	populate(objectMap, "trinoProfile", c.TrinoProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterProfile.
func (c *ClusterProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationProfile":
			err = unpopulate(val, "AuthorizationProfile", &c.AuthorizationProfile)
			delete(rawMsg, key)
		case "autoscaleProfile":
			err = unpopulate(val, "AutoscaleProfile", &c.AutoscaleProfile)
			delete(rawMsg, key)
		case "clusterVersion":
			err = unpopulate(val, "ClusterVersion", &c.ClusterVersion)
			delete(rawMsg, key)
		case "components":
			err = unpopulate(val, "Components", &c.Components)
			delete(rawMsg, key)
		case "connectivityProfile":
			err = unpopulate(val, "ConnectivityProfile", &c.ConnectivityProfile)
			delete(rawMsg, key)
		case "flinkProfile":
			err = unpopulate(val, "FlinkProfile", &c.FlinkProfile)
			delete(rawMsg, key)
		case "identityProfile":
			err = unpopulate(val, "IdentityProfile", &c.IdentityProfile)
			delete(rawMsg, key)
		case "kafkaProfile":
			err = unpopulate(val, "KafkaProfile", &c.KafkaProfile)
			delete(rawMsg, key)
		case "llapProfile":
			err = unpopulate(val, "LlapProfile", &c.LlapProfile)
			delete(rawMsg, key)
		case "logAnalyticsProfile":
			err = unpopulate(val, "LogAnalyticsProfile", &c.LogAnalyticsProfile)
			delete(rawMsg, key)
		case "ossVersion":
			err = unpopulate(val, "OssVersion", &c.OssVersion)
			delete(rawMsg, key)
		case "prometheusProfile":
			err = unpopulate(val, "PrometheusProfile", &c.PrometheusProfile)
			delete(rawMsg, key)
		case "sshProfile":
			err = unpopulate(val, "SSHProfile", &c.SSHProfile)
			delete(rawMsg, key)
		case "scriptActionProfiles":
			err = unpopulate(val, "ScriptActionProfiles", &c.ScriptActionProfiles)
			delete(rawMsg, key)
		case "secretsProfile":
			err = unpopulate(val, "SecretsProfile", &c.SecretsProfile)
			delete(rawMsg, key)
		case "serviceConfigsProfiles":
			err = unpopulate(val, "ServiceConfigsProfiles", &c.ServiceConfigsProfiles)
			delete(rawMsg, key)
		case "sparkProfile":
			err = unpopulate(val, "SparkProfile", &c.SparkProfile)
			delete(rawMsg, key)
		case "stubProfile":
			err = unpopulate(val, "StubProfile", &c.StubProfile)
			delete(rawMsg, key)
		case "trinoProfile":
			err = unpopulate(val, "TrinoProfile", &c.TrinoProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterPrometheusProfile.
func (c ClusterPrometheusProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", c.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterPrometheusProfile.
func (c *ClusterPrometheusProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterResizeData.
func (c ClusterResizeData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterResizeData.
func (c *ClusterResizeData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterResizeProperties.
func (c ClusterResizeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetWorkerNodeCount", c.TargetWorkerNodeCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterResizeProperties.
func (c *ClusterResizeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetWorkerNodeCount":
			err = unpopulate(val, "TargetWorkerNodeCount", &c.TargetWorkerNodeCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterResourceProperties.
func (c ClusterResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterProfile", c.ClusterProfile)
	populate(objectMap, "clusterType", c.ClusterType)
	populate(objectMap, "computeProfile", c.ComputeProfile)
	populate(objectMap, "deploymentId", c.DeploymentID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterResourceProperties.
func (c *ClusterResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterProfile":
			err = unpopulate(val, "ClusterProfile", &c.ClusterProfile)
			delete(rawMsg, key)
		case "clusterType":
			err = unpopulate(val, "ClusterType", &c.ClusterType)
			delete(rawMsg, key)
		case "computeProfile":
			err = unpopulate(val, "ComputeProfile", &c.ComputeProfile)
			delete(rawMsg, key)
		case "deploymentId":
			err = unpopulate(val, "DeploymentID", &c.DeploymentID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterServiceConfig.
func (c ClusterServiceConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "component", c.Component)
	populate(objectMap, "files", c.Files)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterServiceConfig.
func (c *ClusterServiceConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "component":
			err = unpopulate(val, "Component", &c.Component)
			delete(rawMsg, key)
		case "files":
			err = unpopulate(val, "Files", &c.Files)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterServiceConfigsProfile.
func (c ClusterServiceConfigsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configs", c.Configs)
	populate(objectMap, "serviceName", c.ServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterServiceConfigsProfile.
func (c *ClusterServiceConfigsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configs":
			err = unpopulate(val, "Configs", &c.Configs)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &c.ServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterVersion.
func (c ClusterVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterVersion.
func (c *ClusterVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterVersionProperties.
func (c ClusterVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterPoolVersion", c.ClusterPoolVersion)
	populate(objectMap, "clusterType", c.ClusterType)
	populate(objectMap, "clusterVersion", c.ClusterVersion)
	populate(objectMap, "components", c.Components)
	populate(objectMap, "isPreview", c.IsPreview)
	populate(objectMap, "ossVersion", c.OssVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterVersionProperties.
func (c *ClusterVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterPoolVersion":
			err = unpopulate(val, "ClusterPoolVersion", &c.ClusterPoolVersion)
			delete(rawMsg, key)
		case "clusterType":
			err = unpopulate(val, "ClusterType", &c.ClusterType)
			delete(rawMsg, key)
		case "clusterVersion":
			err = unpopulate(val, "ClusterVersion", &c.ClusterVersion)
			delete(rawMsg, key)
		case "components":
			err = unpopulate(val, "Components", &c.Components)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &c.IsPreview)
			delete(rawMsg, key)
		case "ossVersion":
			err = unpopulate(val, "OssVersion", &c.OssVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterVersionsListResult.
func (c ClusterVersionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterVersionsListResult.
func (c *ClusterVersionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComparisonRule.
func (c ComparisonRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operator", c.Operator)
	populate(objectMap, "threshold", c.Threshold)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComparisonRule.
func (c *ComparisonRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operator":
			err = unpopulate(val, "Operator", &c.Operator)
			delete(rawMsg, key)
		case "threshold":
			err = unpopulate(val, "Threshold", &c.Threshold)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeProfile.
func (c ComputeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodes", c.Nodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeProfile.
func (c *ComputeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodes":
			err = unpopulate(val, "Nodes", &c.Nodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeResourceDefinition.
func (c ComputeResourceDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpu", c.CPU)
	populate(objectMap, "memory", c.Memory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeResourceDefinition.
func (c *ComputeResourceDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpu":
			err = unpopulate(val, "CPU", &c.CPU)
			delete(rawMsg, key)
		case "memory":
			err = unpopulate(val, "Memory", &c.Memory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityProfile.
func (c ConnectivityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ssh", c.SSH)
	populate(objectMap, "web", c.Web)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityProfile.
func (c *ConnectivityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ssh":
			err = unpopulate(val, "SSH", &c.SSH)
			delete(rawMsg, key)
		case "web":
			err = unpopulate(val, "Web", &c.Web)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectivityProfileWeb.
func (c ConnectivityProfileWeb) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdn", c.Fqdn)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectivityProfileWeb.
func (c *ConnectivityProfileWeb) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdn":
			err = unpopulate(val, "Fqdn", &c.Fqdn)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlinkCatalogOptions.
func (f FlinkCatalogOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hive", f.Hive)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlinkCatalogOptions.
func (f *FlinkCatalogOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hive":
			err = unpopulate(val, "Hive", &f.Hive)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlinkHiveCatalogOption.
func (f FlinkHiveCatalogOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metastoreDbConnectionPasswordSecret", f.MetastoreDbConnectionPasswordSecret)
	populate(objectMap, "metastoreDbConnectionURL", f.MetastoreDbConnectionURL)
	populate(objectMap, "metastoreDbConnectionUserName", f.MetastoreDbConnectionUserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlinkHiveCatalogOption.
func (f *FlinkHiveCatalogOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metastoreDbConnectionPasswordSecret":
			err = unpopulate(val, "MetastoreDbConnectionPasswordSecret", &f.MetastoreDbConnectionPasswordSecret)
			delete(rawMsg, key)
		case "metastoreDbConnectionURL":
			err = unpopulate(val, "MetastoreDbConnectionURL", &f.MetastoreDbConnectionURL)
			delete(rawMsg, key)
		case "metastoreDbConnectionUserName":
			err = unpopulate(val, "MetastoreDbConnectionUserName", &f.MetastoreDbConnectionUserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlinkJobProperties.
func (f FlinkJobProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", f.Action)
	populate(objectMap, "actionResult", f.ActionResult)
	populate(objectMap, "args", f.Args)
	populate(objectMap, "entryClass", f.EntryClass)
	populate(objectMap, "flinkConfiguration", f.FlinkConfiguration)
	populate(objectMap, "jarName", f.JarName)
	populate(objectMap, "jobId", f.JobID)
	populate(objectMap, "jobJarDirectory", f.JobJarDirectory)
	populate(objectMap, "jobName", f.JobName)
	populate(objectMap, "jobOutput", f.JobOutput)
	objectMap["jobType"] = JobTypeFlinkJob
	populate(objectMap, "lastSavePoint", f.LastSavePoint)
	populate(objectMap, "savePointName", f.SavePointName)
	populate(objectMap, "status", f.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlinkJobProperties.
func (f *FlinkJobProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &f.Action)
			delete(rawMsg, key)
		case "actionResult":
			err = unpopulate(val, "ActionResult", &f.ActionResult)
			delete(rawMsg, key)
		case "args":
			err = unpopulate(val, "Args", &f.Args)
			delete(rawMsg, key)
		case "entryClass":
			err = unpopulate(val, "EntryClass", &f.EntryClass)
			delete(rawMsg, key)
		case "flinkConfiguration":
			err = unpopulate(val, "FlinkConfiguration", &f.FlinkConfiguration)
			delete(rawMsg, key)
		case "jarName":
			err = unpopulate(val, "JarName", &f.JarName)
			delete(rawMsg, key)
		case "jobId":
			err = unpopulate(val, "JobID", &f.JobID)
			delete(rawMsg, key)
		case "jobJarDirectory":
			err = unpopulate(val, "JobJarDirectory", &f.JobJarDirectory)
			delete(rawMsg, key)
		case "jobName":
			err = unpopulate(val, "JobName", &f.JobName)
			delete(rawMsg, key)
		case "jobOutput":
			err = unpopulate(val, "JobOutput", &f.JobOutput)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &f.JobType)
			delete(rawMsg, key)
		case "lastSavePoint":
			err = unpopulate(val, "LastSavePoint", &f.LastSavePoint)
			delete(rawMsg, key)
		case "savePointName":
			err = unpopulate(val, "SavePointName", &f.SavePointName)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &f.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlinkProfile.
func (f FlinkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "catalogOptions", f.CatalogOptions)
	populate(objectMap, "historyServer", f.HistoryServer)
	populate(objectMap, "jobManager", f.JobManager)
	populate(objectMap, "numReplicas", f.NumReplicas)
	populate(objectMap, "storage", f.Storage)
	populate(objectMap, "taskManager", f.TaskManager)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlinkProfile.
func (f *FlinkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogOptions":
			err = unpopulate(val, "CatalogOptions", &f.CatalogOptions)
			delete(rawMsg, key)
		case "historyServer":
			err = unpopulate(val, "HistoryServer", &f.HistoryServer)
			delete(rawMsg, key)
		case "jobManager":
			err = unpopulate(val, "JobManager", &f.JobManager)
			delete(rawMsg, key)
		case "numReplicas":
			err = unpopulate(val, "NumReplicas", &f.NumReplicas)
			delete(rawMsg, key)
		case "storage":
			err = unpopulate(val, "Storage", &f.Storage)
			delete(rawMsg, key)
		case "taskManager":
			err = unpopulate(val, "TaskManager", &f.TaskManager)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlinkStorageProfile.
func (f FlinkStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storageUri", f.StorageURI)
	populate(objectMap, "storagekey", f.Storagekey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlinkStorageProfile.
func (f *FlinkStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storageUri":
			err = unpopulate(val, "StorageURI", &f.StorageURI)
			delete(rawMsg, key)
		case "storagekey":
			err = unpopulate(val, "Storagekey", &f.Storagekey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HiveCatalogOption.
func (h HiveCatalogOption) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "catalogName", h.CatalogName)
	populate(objectMap, "metastoreDbConnectionPasswordSecret", h.MetastoreDbConnectionPasswordSecret)
	populate(objectMap, "metastoreDbConnectionURL", h.MetastoreDbConnectionURL)
	populate(objectMap, "metastoreDbConnectionUserName", h.MetastoreDbConnectionUserName)
	populate(objectMap, "metastoreWarehouseDir", h.MetastoreWarehouseDir)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HiveCatalogOption.
func (h *HiveCatalogOption) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogName":
			err = unpopulate(val, "CatalogName", &h.CatalogName)
			delete(rawMsg, key)
		case "metastoreDbConnectionPasswordSecret":
			err = unpopulate(val, "MetastoreDbConnectionPasswordSecret", &h.MetastoreDbConnectionPasswordSecret)
			delete(rawMsg, key)
		case "metastoreDbConnectionURL":
			err = unpopulate(val, "MetastoreDbConnectionURL", &h.MetastoreDbConnectionURL)
			delete(rawMsg, key)
		case "metastoreDbConnectionUserName":
			err = unpopulate(val, "MetastoreDbConnectionUserName", &h.MetastoreDbConnectionUserName)
			delete(rawMsg, key)
		case "metastoreWarehouseDir":
			err = unpopulate(val, "MetastoreWarehouseDir", &h.MetastoreWarehouseDir)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProfile.
func (i IdentityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "msiClientId", i.MsiClientID)
	populate(objectMap, "msiObjectId", i.MsiObjectID)
	populate(objectMap, "msiResourceId", i.MsiResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProfile.
func (i *IdentityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "msiClientId":
			err = unpopulate(val, "MsiClientID", &i.MsiClientID)
			delete(rawMsg, key)
		case "msiObjectId":
			err = unpopulate(val, "MsiObjectID", &i.MsiObjectID)
			delete(rawMsg, key)
		case "msiResourceId":
			err = unpopulate(val, "MsiResourceID", &i.MsiResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LoadBasedConfig.
func (l LoadBasedConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cooldownPeriod", l.CooldownPeriod)
	populate(objectMap, "maxNodes", l.MaxNodes)
	populate(objectMap, "minNodes", l.MinNodes)
	populate(objectMap, "pollInterval", l.PollInterval)
	populate(objectMap, "scalingRules", l.ScalingRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LoadBasedConfig.
func (l *LoadBasedConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cooldownPeriod":
			err = unpopulate(val, "CooldownPeriod", &l.CooldownPeriod)
			delete(rawMsg, key)
		case "maxNodes":
			err = unpopulate(val, "MaxNodes", &l.MaxNodes)
			delete(rawMsg, key)
		case "minNodes":
			err = unpopulate(val, "MinNodes", &l.MinNodes)
			delete(rawMsg, key)
		case "pollInterval":
			err = unpopulate(val, "PollInterval", &l.PollInterval)
			delete(rawMsg, key)
		case "scalingRules":
			err = unpopulate(val, "ScalingRules", &l.ScalingRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameAvailabilityParameters.
func (n NameAvailabilityParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameAvailabilityParameters.
func (n *NameAvailabilityParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NameAvailabilityResult.
func (n NameAvailabilityResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", n.Message)
	populate(objectMap, "nameAvailable", n.NameAvailable)
	populate(objectMap, "reason", n.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NameAvailabilityResult.
func (n *NameAvailabilityResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &n.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &n.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &n.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeProfile.
func (n NodeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", n.Count)
	populate(objectMap, "type", n.Type)
	populate(objectMap, "vmSize", n.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NodeProfile.
func (n *NodeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &n.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHConnectivityEndpoint.
func (s SSHConnectivityEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpoint", s.Endpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHConnectivityEndpoint.
func (s *SSHConnectivityEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			err = unpopulate(val, "Endpoint", &s.Endpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHProfile.
func (s SSHProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "podPrefix", s.PodPrefix)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHProfile.
func (s *SSHProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "podPrefix":
			err = unpopulate(val, "PodPrefix", &s.PodPrefix)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScalingRule.
func (s ScalingRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", s.ActionType)
	populate(objectMap, "comparisonRule", s.ComparisonRule)
	populate(objectMap, "evaluationCount", s.EvaluationCount)
	populate(objectMap, "scalingMetric", s.ScalingMetric)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScalingRule.
func (s *ScalingRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &s.ActionType)
			delete(rawMsg, key)
		case "comparisonRule":
			err = unpopulate(val, "ComparisonRule", &s.ComparisonRule)
			delete(rawMsg, key)
		case "evaluationCount":
			err = unpopulate(val, "EvaluationCount", &s.EvaluationCount)
			delete(rawMsg, key)
		case "scalingMetric":
			err = unpopulate(val, "ScalingMetric", &s.ScalingMetric)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "days", s.Days)
	populate(objectMap, "endTime", s.EndTime)
	populate(objectMap, "startTime", s.StartTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Schedule.
func (s *Schedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "days":
			err = unpopulate(val, "Days", &s.Days)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulate(val, "EndTime", &s.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &s.StartTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleBasedConfig.
func (s ScheduleBasedConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultCount", s.DefaultCount)
	populate(objectMap, "schedules", s.Schedules)
	populate(objectMap, "timeZone", s.TimeZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleBasedConfig.
func (s *ScheduleBasedConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultCount":
			err = unpopulate(val, "DefaultCount", &s.DefaultCount)
			delete(rawMsg, key)
		case "schedules":
			err = unpopulate(val, "Schedules", &s.Schedules)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &s.TimeZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptActionProfile.
func (s ScriptActionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "parameters", s.Parameters)
	populate(objectMap, "services", s.Services)
	populate(objectMap, "shouldPersist", s.ShouldPersist)
	populate(objectMap, "timeoutInMinutes", s.TimeoutInMinutes)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "url", s.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptActionProfile.
func (s *ScriptActionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &s.Parameters)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &s.Services)
			delete(rawMsg, key)
		case "shouldPersist":
			err = unpopulate(val, "ShouldPersist", &s.ShouldPersist)
			delete(rawMsg, key)
		case "timeoutInMinutes":
			err = unpopulate(val, "TimeoutInMinutes", &s.TimeoutInMinutes)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &s.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretReference.
func (s SecretReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVaultObjectName", s.KeyVaultObjectName)
	populate(objectMap, "referenceName", s.ReferenceName)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretReference.
func (s *SecretReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVaultObjectName":
			err = unpopulate(val, "KeyVaultObjectName", &s.KeyVaultObjectName)
			delete(rawMsg, key)
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &s.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretsProfile.
func (s SecretsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVaultResourceId", s.KeyVaultResourceID)
	populate(objectMap, "secrets", s.Secrets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretsProfile.
func (s *SecretsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVaultResourceId":
			err = unpopulate(val, "KeyVaultResourceID", &s.KeyVaultResourceID)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &s.Secrets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceConfigListResult.
func (s ServiceConfigListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceConfigListResult.
func (s *ServiceConfigListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceConfigListResultValueEntity.
func (s ServiceConfigListResultValueEntity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceConfigListResultValueEntity.
func (s *ServiceConfigListResultValueEntity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceConfigResult.
func (s ServiceConfigResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceConfigResult.
func (s *ServiceConfigResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceConfigResultProperties.
func (s ServiceConfigResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentName", s.ComponentName)
	populate(objectMap, "content", s.Content)
	populate(objectMap, "customKeys", s.CustomKeys)
	populate(objectMap, "defaultKeys", s.DefaultKeys)
	populate(objectMap, "fileName", s.FileName)
	populate(objectMap, "path", s.Path)
	populate(objectMap, "serviceName", s.ServiceName)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceConfigResultProperties.
func (s *ServiceConfigResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentName":
			err = unpopulate(val, "ComponentName", &s.ComponentName)
			delete(rawMsg, key)
		case "content":
			err = unpopulate(val, "Content", &s.Content)
			delete(rawMsg, key)
		case "customKeys":
			err = unpopulate(val, "CustomKeys", &s.CustomKeys)
			delete(rawMsg, key)
		case "defaultKeys":
			err = unpopulate(val, "DefaultKeys", &s.DefaultKeys)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &s.FileName)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		case "serviceName":
			err = unpopulate(val, "ServiceName", &s.ServiceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceStatus.
func (s ServiceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "ready", s.Ready)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceStatus.
func (s *ServiceStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &s.Ready)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkMetastoreSpec.
func (s SparkMetastoreSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dbName", s.DbName)
	populate(objectMap, "dbPasswordSecretName", s.DbPasswordSecretName)
	populate(objectMap, "dbServerHost", s.DbServerHost)
	populate(objectMap, "dbUserName", s.DbUserName)
	populate(objectMap, "keyVaultId", s.KeyVaultID)
	populate(objectMap, "thriftUrl", s.ThriftURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkMetastoreSpec.
func (s *SparkMetastoreSpec) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dbName":
			err = unpopulate(val, "DbName", &s.DbName)
			delete(rawMsg, key)
		case "dbPasswordSecretName":
			err = unpopulate(val, "DbPasswordSecretName", &s.DbPasswordSecretName)
			delete(rawMsg, key)
		case "dbServerHost":
			err = unpopulate(val, "DbServerHost", &s.DbServerHost)
			delete(rawMsg, key)
		case "dbUserName":
			err = unpopulate(val, "DbUserName", &s.DbUserName)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &s.KeyVaultID)
			delete(rawMsg, key)
		case "thriftUrl":
			err = unpopulate(val, "ThriftURL", &s.ThriftURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkProfile.
func (s SparkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultStorageUrl", s.DefaultStorageURL)
	populate(objectMap, "metastoreSpec", s.MetastoreSpec)
	populate(objectMap, "userPluginsSpec", s.UserPluginsSpec)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkProfile.
func (s *SparkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultStorageUrl":
			err = unpopulate(val, "DefaultStorageURL", &s.DefaultStorageURL)
			delete(rawMsg, key)
		case "metastoreSpec":
			err = unpopulate(val, "MetastoreSpec", &s.MetastoreSpec)
			delete(rawMsg, key)
		case "userPluginsSpec":
			err = unpopulate(val, "UserPluginsSpec", &s.UserPluginsSpec)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkUserPlugin.
func (s SparkUserPlugin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "path", s.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkUserPlugin.
func (s *SparkUserPlugin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "path":
			err = unpopulate(val, "Path", &s.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SparkUserPlugins.
func (s SparkUserPlugins) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "plugins", s.Plugins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SparkUserPlugins.
func (s *SparkUserPlugins) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "plugins":
			err = unpopulate(val, "Plugins", &s.Plugins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoCoordinator.
func (t TrinoCoordinator) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "debug", t.Debug)
	populate(objectMap, "highAvailabilityEnabled", t.HighAvailabilityEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoCoordinator.
func (t *TrinoCoordinator) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "debug":
			err = unpopulate(val, "Debug", &t.Debug)
			delete(rawMsg, key)
		case "highAvailabilityEnabled":
			err = unpopulate(val, "HighAvailabilityEnabled", &t.HighAvailabilityEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoDebugConfig.
func (t TrinoDebugConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enable", t.Enable)
	populate(objectMap, "port", t.Port)
	populate(objectMap, "suspend", t.Suspend)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoDebugConfig.
func (t *TrinoDebugConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enable":
			err = unpopulate(val, "Enable", &t.Enable)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &t.Port)
			delete(rawMsg, key)
		case "suspend":
			err = unpopulate(val, "Suspend", &t.Suspend)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoProfile.
func (t TrinoProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "catalogOptions", t.CatalogOptions)
	populate(objectMap, "coordinator", t.Coordinator)
	populate(objectMap, "userPluginsSpec", t.UserPluginsSpec)
	populate(objectMap, "userTelemetrySpec", t.UserTelemetrySpec)
	populate(objectMap, "worker", t.Worker)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoProfile.
func (t *TrinoProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogOptions":
			err = unpopulate(val, "CatalogOptions", &t.CatalogOptions)
			delete(rawMsg, key)
		case "coordinator":
			err = unpopulate(val, "Coordinator", &t.Coordinator)
			delete(rawMsg, key)
		case "userPluginsSpec":
			err = unpopulate(val, "UserPluginsSpec", &t.UserPluginsSpec)
			delete(rawMsg, key)
		case "userTelemetrySpec":
			err = unpopulate(val, "UserTelemetrySpec", &t.UserTelemetrySpec)
			delete(rawMsg, key)
		case "worker":
			err = unpopulate(val, "Worker", &t.Worker)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoTelemetryConfig.
func (t TrinoTelemetryConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hivecatalogName", t.HivecatalogName)
	populate(objectMap, "hivecatalogSchema", t.HivecatalogSchema)
	populate(objectMap, "partitionRetentionInDays", t.PartitionRetentionInDays)
	populate(objectMap, "path", t.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoTelemetryConfig.
func (t *TrinoTelemetryConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hivecatalogName":
			err = unpopulate(val, "HivecatalogName", &t.HivecatalogName)
			delete(rawMsg, key)
		case "hivecatalogSchema":
			err = unpopulate(val, "HivecatalogSchema", &t.HivecatalogSchema)
			delete(rawMsg, key)
		case "partitionRetentionInDays":
			err = unpopulate(val, "PartitionRetentionInDays", &t.PartitionRetentionInDays)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &t.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoUserPlugin.
func (t TrinoUserPlugin) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", t.Enabled)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "path", t.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoUserPlugin.
func (t *TrinoUserPlugin) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &t.Enabled)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &t.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoUserPlugins.
func (t TrinoUserPlugins) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "plugins", t.Plugins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoUserPlugins.
func (t *TrinoUserPlugins) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "plugins":
			err = unpopulate(val, "Plugins", &t.Plugins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoUserTelemetry.
func (t TrinoUserTelemetry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "storage", t.Storage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoUserTelemetry.
func (t *TrinoUserTelemetry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "storage":
			err = unpopulate(val, "Storage", &t.Storage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrinoWorker.
func (t TrinoWorker) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "debug", t.Debug)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrinoWorker.
func (t *TrinoWorker) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "debug":
			err = unpopulate(val, "Debug", &t.Debug)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdatableClusterProfile.
func (u UpdatableClusterProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizationProfile", u.AuthorizationProfile)
	populate(objectMap, "autoscaleProfile", u.AutoscaleProfile)
	populate(objectMap, "logAnalyticsProfile", u.LogAnalyticsProfile)
	populate(objectMap, "prometheusProfile", u.PrometheusProfile)
	populate(objectMap, "sshProfile", u.SSHProfile)
	populate(objectMap, "scriptActionProfiles", u.ScriptActionProfiles)
	populate(objectMap, "serviceConfigsProfiles", u.ServiceConfigsProfiles)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdatableClusterProfile.
func (u *UpdatableClusterProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationProfile":
			err = unpopulate(val, "AuthorizationProfile", &u.AuthorizationProfile)
			delete(rawMsg, key)
		case "autoscaleProfile":
			err = unpopulate(val, "AutoscaleProfile", &u.AutoscaleProfile)
			delete(rawMsg, key)
		case "logAnalyticsProfile":
			err = unpopulate(val, "LogAnalyticsProfile", &u.LogAnalyticsProfile)
			delete(rawMsg, key)
		case "prometheusProfile":
			err = unpopulate(val, "PrometheusProfile", &u.PrometheusProfile)
			delete(rawMsg, key)
		case "sshProfile":
			err = unpopulate(val, "SSHProfile", &u.SSHProfile)
			delete(rawMsg, key)
		case "scriptActionProfiles":
			err = unpopulate(val, "ScriptActionProfiles", &u.ScriptActionProfiles)
			delete(rawMsg, key)
		case "serviceConfigsProfiles":
			err = unpopulate(val, "ServiceConfigsProfiles", &u.ServiceConfigsProfiles)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
