//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListWorkspaceManagedSqlServerRecoverableSqlPool.json
func ExampleWorkspaceManagedSQLServerRecoverableSQLPoolsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewWorkspaceManagedSQLServerRecoverableSQLPoolsClient().NewListPager("wsg-7398", "testWorkspace", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.RecoverableSQLPoolListResult = armsynapse.RecoverableSQLPoolListResult{
		// 	Value: []*armsynapse.RecoverableSQLPool{
		// 		{
		// 			Name: to.Ptr("recoverableSqlpools-1235"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/recoverableSqlpools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/recoverableSqlpools/recoverableSqlpools-1235"),
		// 			Properties: &armsynapse.RecoverableSQLPoolProperties{
		// 				Edition: to.Ptr("Standard"),
		// 				LastAvailableBackupDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-26T01:06:29.780Z"); return t}()),
		// 				ServiceLevelObjective: to.Ptr("S0"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("recoverableSqlpools-9231"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/recoverableSqlpools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/recoverableSqlpools/recoverableSqlpools-9231"),
		// 			Properties: &armsynapse.RecoverableSQLPoolProperties{
		// 				Edition: to.Ptr("Premium"),
		// 				LastAvailableBackupDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-26T03:20:31.780Z"); return t}()),
		// 				ServiceLevelObjective: to.Ptr("P1"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("recoverableSqlpools-0342"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/recoverableSqlpools"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/recoverableSqlpools/recoverableSqlpools-0342"),
		// 			Properties: &armsynapse.RecoverableSQLPoolProperties{
		// 				Edition: to.Ptr("Basic"),
		// 				LastAvailableBackupDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-24T02:06:18.780Z"); return t}()),
		// 				ServiceLevelObjective: to.Ptr("Basic"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/GetWorkspaceManagedSqlServerRecoverableSqlPool.json
func ExampleWorkspaceManagedSQLServerRecoverableSQLPoolsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewWorkspaceManagedSQLServerRecoverableSQLPoolsClient().Get(ctx, "wsg-7398", "testWorkspace", "recoverableSqlpools-1235", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RecoverableSQLPool = armsynapse.RecoverableSQLPool{
	// 	Name: to.Ptr("recoverableSqlpools-1235"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/recoverableSqlpools"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/wsg-7398/providers/Microsoft.Synapse/workspaces/testWorkspace/recoverableSqlpools/recoverableSqlpools-1235"),
	// 	Properties: &armsynapse.RecoverableSQLPoolProperties{
	// 		Edition: to.Ptr("Standard"),
	// 		LastAvailableBackupDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-26T01:06:29.780Z"); return t}()),
	// 		ServiceLevelObjective: to.Ptr("S0"),
	// 	},
	// }
}
