/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.docbook;

import org.dbdoclet.xiphias.XmlConstants;
import org.dbdoclet.xiphias.dom.DocumentImpl;

public class DocBookDocument extends DocumentImpl {

    public void setDocumentElement(DocBookElement documentElement) {

        if (documentElement == null) {
            throw new IllegalArgumentException("The argument documentElement must not be null!");
        }

        super.setDocumentElement(documentElement);
        
        if (documentElement.isDocBook5()) {

            documentElement.setAttribute("xmlns", XmlConstants.NAMESPACE_DOCBOOK);
            documentElement.setAttribute("xmlns:xl", XmlConstants.NAMESPACE_XLINK);
            documentElement.setAttribute("xmlns:xi", XmlConstants.NAMESPACE_XINCLUDE);
            documentElement.setAttribute("version", "5.0");
        }
    }
}
