/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.lisaac.ldt.LisaacMessages;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.lip.LIP;
import org.lisaac.ldt.model.lip.LIPSlotCode;

public class LaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String LISAAC_LAUNCH_PROJECT = "launchProject";
    public static final String LISAAC_LAUNCH_PROTOTYPE = "mainPrototype";
    public static final String LISAAC_LAUNCH_COMPILER = "launchCompiler";
    public static final String LISAAC_LAUNCH_PROGRAM = "launchProgram";
    public static final String LISAAC_LAUNCH_ARGUMENTS = "programArguments";
    public static final String LISAAC_LAUNCH_OPTION = "lipOption";
    public static final String LISAAC_LAUNCH_OPTION_ARG = "lipOptionARG";
    private Text projectText;
    private Text mainPrototypeText;
    private Table lipTable;
    private LIP lipCode;
    private Button doLaunchCompiler;
    private Button doLaunchProgram;
    private Text argumentsText;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        comp.setLayout((Layout)topLayout);
        Group projComp = new Group(comp, 4);
        projComp.setText(LisaacMessages.getString("LaunchConfigurationTab.6"));
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 3;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        Label fProjLabel = new Label((Composite)projComp, 0);
        fProjLabel.setText(LisaacMessages.getString("LaunchConfigurationTab.7"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        fProjLabel.setLayoutData((Object)gd);
        fProjLabel.setFont(font);
        this.projectText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.projectText.setLayoutData((Object)gd);
        this.projectText.setFont(font);
        this.projectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseButton = new Button((Composite)projComp, 8);
        browseButton.setText(LisaacMessages.getString("LaunchConfigurationTab.9"));
        gd = new GridData(128);
        gd.horizontalSpan = 1;
        browseButton.setLayoutData((Object)gd);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationTab.this.handleBrowseContainer(LaunchConfigurationTab.this.projectText);
            }
        });
        Label label = new Label((Composite)projComp, 0);
        label.setText(LisaacMessages.getString("LaunchConfigurationTab.8"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.mainPrototypeText = new Text((Composite)projComp, 2052);
        gd = new GridData(768);
        this.mainPrototypeText.setLayoutData((Object)gd);
        this.mainPrototypeText.setFont(font);
        this.mainPrototypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        browseButton = new Button((Composite)projComp, 8);
        browseButton.setText(LisaacMessages.getString("LaunchConfigurationTab.9"));
        gd = new GridData(128);
        browseButton.setLayoutData((Object)gd);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationTab.this.handleBrowseFile(LaunchConfigurationTab.this.mainPrototypeText);
            }
        });
        Label separator = new Label(comp, 258);
        separator.setLayoutData((Object)new GridData(768));
        Group compilerOptions = new Group(comp, 4);
        compilerOptions.setText(LisaacMessages.getString("LaunchConfigurationTab.12"));
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        compilerOptions.setLayout((Layout)gl);
        gd = new GridData(1808);
        compilerOptions.setLayoutData((Object)gd);
        this.doLaunchCompiler = new Button((Composite)compilerOptions, 32);
        this.doLaunchCompiler.setText("Always Compile (cannot run program)");
        this.doLaunchCompiler.setSelection(false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.doLaunchCompiler.setLayoutData((Object)gd);
        this.doLaunchCompiler.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationTab.this.doLaunchProgram.setEnabled(!LaunchConfigurationTab.this.doLaunchCompiler.getSelection());
                LaunchConfigurationTab.this.argumentsText.setEnabled(!LaunchConfigurationTab.this.doLaunchCompiler.getSelection());
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite tableGroup = new Composite((Composite)compilerOptions, 0);
        tableGroup.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.verticalSpan = 3;
        tableGroup.setLayoutData((Object)gd);
        this.lipTable = new Table(tableGroup, 67876);
        TableColumn c1 = new TableColumn(this.lipTable, 16384);
        c1.setText(LisaacMessages.getString("LaunchConfigurationTab.15"));
        c1.setWidth(130);
        TableColumn c2 = new TableColumn(this.lipTable, 16384);
        c2.setText(LisaacMessages.getString("LaunchConfigurationTab.16"));
        c2.setWidth(80);
        TableColumn c3 = new TableColumn(this.lipTable, 16384);
        c3.setText(LisaacMessages.getString("LaunchConfigurationTab.17"));
        c3.setWidth(100);
        this.lipTable.setHeaderVisible(true);
        this.lipTable.setLinesVisible(true);
        this.lipTable.setItemCount(4);
        this.lipTable.setLayoutData((Object)new GridData(1808));
        TableEditor editor = new TableEditor(this.lipTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        this.lipTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Text newEditor = new Text((Composite)LaunchConfigurationTab.this.lipTable, 0);
                newEditor.setText(item.getText(1));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent me) {
                        Text text = (Text)editor.getEditor();
                        editor.getItem().setText(1, text.getText());
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 1);
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        tableGroup.setLayoutData((Object)gridData);
        separator = new Label(comp, 258);
        separator.setLayoutData((Object)new GridData(768));
        Group programOptions = new Group(comp, 4);
        programOptions.setText("Program Options");
        gl = new GridLayout();
        gl.numColumns = 2;
        programOptions.setLayout((Layout)gl);
        programOptions.setLayoutData((Object)new GridData(768));
        this.doLaunchProgram = new Button((Composite)programOptions, 32);
        this.doLaunchProgram.setText("Run the program");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.doLaunchProgram.setLayoutData((Object)gd);
        this.doLaunchProgram.setSelection(true);
        this.doLaunchProgram.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LaunchConfigurationTab.this.argumentsText != null) {
                    LaunchConfigurationTab.this.argumentsText.setEnabled(LaunchConfigurationTab.this.doLaunchProgram.getSelection());
                }
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label((Composite)programOptions, 0);
        label.setText("Command-Line:");
        label.setLayoutData((Object)new GridData(1));
        this.argumentsText = new Text((Composite)programOptions, 2052);
        this.argumentsText.setLayoutData((Object)new GridData(768));
        this.argumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public String getName() {
        return LisaacMessages.getString("LaunchConfigurationTab.18");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute(LISAAC_LAUNCH_PROJECT, "");
            this.projectText.setText(projectName);
            String mainPrototypeName = configuration.getAttribute(LISAAC_LAUNCH_PROTOTYPE, "");
            this.mainPrototypeText.setText(mainPrototypeName);
            boolean check = configuration.getAttribute(LISAAC_LAUNCH_COMPILER, false);
            this.doLaunchCompiler.setSelection(check);
            check = configuration.getAttribute(LISAAC_LAUNCH_PROGRAM, true);
            this.doLaunchProgram.setSelection(check);
            String commandLine = configuration.getAttribute(LISAAC_LAUNCH_ARGUMENTS, "");
            this.argumentsText.setText(commandLine);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            LisaacModel model = LisaacModel.getModel(project);
            if (model != null) {
                this.lipCode = model.getLipCode();
                if (this.lipCode != null) {
                    this.lipTable.setItemCount(0);
                    int i = 0;
                    while (i < this.lipCode.getMethodCount()) {
                        LIPSlotCode method = this.lipCode.getMethod(i);
                        if (method.isPublic()) {
                            String methodComment = method.getComment();
                            if (methodComment == null) {
                                methodComment = LisaacMessages.getString("LaunchConfigurationTab.23");
                            }
                            methodComment = methodComment.replaceAll("\t", "");
                            methodComment = methodComment.replaceAll("\n", "");
                            if (!this.lipTable.isDisposed()) {
                                TableItem item = new TableItem(this.lipTable, 0);
                                item.setText(0, method.getName());
                                item.setText(2, methodComment);
                                if (method.getName().compareTo("run_mode") == 0) {
                                    item.setChecked(true);
                                    item.setText(1, this.getLaunchConfigurationDialog().getMode());
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (CoreException ce) {
            Status status = new Status(4, "org.lisaac.ldt", 0, "Error in Lisaac launch: " + ce.getMessage(), (Throwable)ce);
            LisaacPlugin.log((IStatus)status);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(LISAAC_LAUNCH_PROJECT, this.projectText.getText());
        configuration.setAttribute(LISAAC_LAUNCH_PROTOTYPE, this.mainPrototypeText.getText());
        configuration.setAttribute(LISAAC_LAUNCH_COMPILER, this.doLaunchCompiler.getSelection());
        configuration.setAttribute(LISAAC_LAUNCH_PROGRAM, this.doLaunchProgram.getSelection());
        configuration.setAttribute(LISAAC_LAUNCH_ARGUMENTS, this.argumentsText.getText());
        TableItem[] options = this.lipTable.getItems();
        if (options != null && options.length > 0) {
            int i = 0;
            while (i < options.length) {
                configuration.removeAttribute(LISAAC_LAUNCH_OPTION + i);
                configuration.removeAttribute(LISAAC_LAUNCH_OPTION_ARG + i);
                ++i;
            }
            int count = 0;
            int i2 = 0;
            while (i2 < options.length) {
                TableItem item = options[i2];
                if (item.getChecked()) {
                    configuration.setAttribute(LISAAC_LAUNCH_OPTION + count, item.getText(0));
                    configuration.setAttribute(LISAAC_LAUNCH_OPTION_ARG + count, item.getText(1));
                    ++count;
                }
                ++i2;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        TableItem[] options;
        IProject project = this.getSelectedProject();
        String projectName = "";
        String mainPrototypeName = "";
        if (project != null) {
            projectName = project.getName();
            mainPrototypeName = String.valueOf(projectName) + ".li";
        }
        configuration.setAttribute(LISAAC_LAUNCH_PROJECT, projectName);
        configuration.setAttribute(LISAAC_LAUNCH_PROTOTYPE, mainPrototypeName);
        configuration.setAttribute(LISAAC_LAUNCH_COMPILER, false);
        configuration.setAttribute(LISAAC_LAUNCH_PROGRAM, true);
        configuration.setAttribute(LISAAC_LAUNCH_ARGUMENTS, "");
        if (this.lipTable != null && (options = this.lipTable.getItems()) != null && options.length > 0) {
            int i = 0;
            while (i < options.length) {
                configuration.removeAttribute(LISAAC_LAUNCH_OPTION + i);
                configuration.removeAttribute(LISAAC_LAUNCH_OPTION_ARG + i);
                ++i;
            }
        }
    }

    private IProject getSelectedProject() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            Object obj;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IResource) {
                IResource i = (IResource)obj;
                IProject pro = i.getProject();
                return pro;
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null) {
                IEditorInput input = part.getEditorInput();
                IFile file = (IFile)input.getAdapter(IFile.class);
                return file.getProject();
            }
        }
        return null;
    }

    private void handleBrowseContainer(Text text) {
        Object result;
        Object[] results;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), null, false, "Select Folder");
        if (dialog.open() == 0 && (results = dialog.getResult()).length == 1 && (result = results[0]) instanceof IPath) {
            IPath ipath = (IPath)result;
            text.setText(ipath.toString());
        }
    }

    private void handleBrowseFile(Text text) {
        Object result;
        Object[] results;
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Select File");
        dialog.setInitialSelections(new Object[0]);
        if (dialog.open() == 0 && (results = dialog.getResult()).length == 1 && (result = results[0]) instanceof IResource) {
            text.setText(((IResource)result).getName());
        }
    }
}

