; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc %s -o - -verify-machineinstrs | FileCheck %s

target datalayout = "e-m:o-p:32:32-f64:32:64-v64:32:64-v128:32:128-a:0:32-n32-S32"
target triple = "thumbv7s-apple-unknown"

; The subtract instruction %3 will be optimized (combined and predicated) with the select
; inside the loop.  In this case, the kill flag on the subtract should be removed or else
; it will fail verification.

%struct.PROOFSEARCH_HELP = type { ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, ptr, i32, i32, i32, i32, i32, i32, i32, i32 }
%struct.SORTTHEORY_HELP = type { ptr, [4000 x ptr], ptr, ptr, i32 }
%struct.st = type { ptr, ptr, ptr, i16, i16 }
%struct.subst = type { ptr, i32, ptr }
%struct.term = type { i32, %union.anon, ptr, i32, i32 }
%union.anon = type { ptr }
%struct.NODE_HELP = type { ptr, i32, i32, i32, ptr, i32 }
%struct.SHARED_INDEX_NODE = type { ptr, [3001 x ptr], [4000 x ptr], i32 }
%struct.LIST_HELP = type { ptr, ptr }
%struct.CLAUSE_HELP = type { i32, i32, i32, i32, ptr, i32, ptr, ptr, i32, i32, ptr, i32, i32, i32, i32 }
%struct.LITERAL_HELP = type { i32, i32, i32, ptr, ptr }

declare void @foo(ptr, ptr)

define hidden fastcc ptr @test(ptr %Search, ptr %ClauseList, i32 %Level, ptr nocapture %New) {
; CHECK-LABEL: test:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    push.w {r4, r5, r6, r7, r8, r9, lr}
; CHECK-NEXT:    sub sp, #4
; CHECK-NEXT:    sub.w r8, r2, #32
; CHECK-NEXT:    mov r6, r0
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    mov r4, r2
; CHECK-NEXT:    add.w r7, r0, r8, lsr #5
; CHECK-NEXT:    mov r5, r1
; CHECK-NEXT:    mov.w r9, #0
; CHECK-NEXT:    b .LBB0_2
; CHECK-NEXT:  .LBB0_1: @ %for.inc
; CHECK-NEXT:    @ in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    ldr r5, [r5]
; CHECK-NEXT:  .LBB0_2: @ %for.body
; CHECK-NEXT:    @ =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    ldr r1, [r5, #4]
; CHECK-NEXT:    mov r2, r4
; CHECK-NEXT:    cmp r4, #31
; CHECK-NEXT:    ldr r0, [r1, #16]
; CHECK-NEXT:    add.w r0, r0, r7, lsl #2
; CHECK-NEXT:    ldr r0, [r0, #40]
; CHECK-NEXT:    it hi
; CHECK-NEXT:    andhi r2, r8, #31
; CHECK-NEXT:    lsrs r0, r2
; CHECK-NEXT:    lsls r0, r0, #31
; CHECK-NEXT:    beq .LBB0_1
; CHECK-NEXT:  @ %bb.3: @ %if.then
; CHECK-NEXT:    @ in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    mov r0, r6
; CHECK-NEXT:    bl foo
; CHECK-NEXT:    str.w r9, [r5, #4]
; CHECK-NEXT:    b .LBB0_1
entry:
  %cmp4.i.i = icmp ugt i32 %Level, 31
  %i = add i32 %Level, -32
  %i1 = lshr i32 %i, 5
  %i2 = shl nuw i32 %i1, 5
  %i3 = sub i32 %i, %i2
  %i4 = add nuw nsw i32 %i1, 1
  br label %for.body

for.body:                                         ; preds = %for.inc, %entry
  %Scan.038 = phi ptr [ %ClauseList, %entry ], [ %i9, %for.inc ]
  %car.i33 = getelementptr inbounds %struct.LIST_HELP, ptr %Scan.038, i32 0, i32 1
  %i6 = load ptr, ptr %car.i33, align 4
  %. = add i32 %i4, 10
  %.Level = select i1 %cmp4.i.i, i32 %i3, i32 %Level
  %splitfield.i = getelementptr inbounds %struct.CLAUSE_HELP, ptr %i6, i32 0, i32 4
  %i7 = load ptr, ptr %splitfield.i, align 4
  %arrayidx.i = getelementptr inbounds i32, ptr %i7, i32 %.
  %i8 = load i32, ptr %arrayidx.i, align 4
  %shl.i = shl i32 1, %.Level
  %and.i = and i32 %i8, %shl.i
  %cmp4.i = icmp eq i32 %and.i, 0
  br i1 %cmp4.i, label %for.inc, label %if.then

if.then:                                          ; preds = %for.body
  tail call void @foo(ptr %Search, ptr %i6)
  store ptr null, ptr %car.i33, align 4
  br label %for.inc

for.inc:                                          ; preds = %if.then, %for.body
  %cdr.i = getelementptr inbounds %struct.LIST_HELP, ptr %Scan.038, i32 0, i32 0
  %i9 = load ptr, ptr %cdr.i, align 4
  br label %for.body
}
