/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef FPSCOUNTER_H
#define FPSCOUNTER_H

#include "Font.h"
#include "Shaders.h"
#include "types.h"

#define VERTSHADER "uniform mat4 projMatrix;\n"\
    "uniform mat4 modelViewMatrix;\n"\
    "attribute vec2 inPosition;\n"\
    "attribute vec2 inCoord;\n"\
    "varying vec2 texCoord;\n"\
    "void main()\n"\
    "{\n"\
    "    gl_Position = projMatrix * modelViewMatrix *\n"\
    "                    vec4(inPosition, 0.0, 1.0);\n"\
    "    texCoord = inCoord;\n"\
    "}"

#define FRAGSHADER "varying vec2 texCoord;\n"\
    "uniform sampler2D gSampler;\n"\
    "uniform vec4 vColor;\n"\
    "void main()\n"\
    "{\n"\
    "    vec4 vTexColor = texture2D(gSampler, texCoord);\n"\
    "    gl_FragColor = vec4(vTexColor.r, vTexColor.r, vTexColor.r,"\
    "                  vTexColor.r)*vColor;\n"\
    "}"

namespace libgltf
{

class FPSCounter
{
public:
    void timeStamp();

    void printFPS(glTFViewport* pViewpoit);
    bool loadFPSShader(ShaderProgram* pShaderProgram);

    FPSCounter(ShaderProgram* pShaderProgram);
    ~FPSCounter();

private:
    FPSCounter(const FPSCounter&);
    FPSCounter& operator=(const FPSCounter&);

    void init(ShaderProgram* pShaderProgram);
    Font* pFont;

    unsigned int uiFPSProgram;

    double mLastTime;

    int mFrames;
    int mFPS;
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
