# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::CN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20200904144528;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '96',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              10|
              2[0-57-9]
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1[1-9]|
            26|
            [3-9]|
            (?:
              10|
              2[0-57-9]
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '16[08]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            85[23](?:
              100|
              95
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              100|
              9[56]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            26|
            3(?:
              [0268]|
              3[0-46-9]|
              4[0-8]|
              9[079]
            )|
            4(?:
              [049]|
              2[02-68]|
              [35]0|
              6[0-356]|
              8[014-9]
            )|
            5(?:
              0|
              2[0-24-689]|
              4[0-2457-9]|
              6[057-9]|
              90
            )|
            6(?:
              [0-24578]|
              3[06-9]|
              6[14-79]|
              9[03-9]
            )|
            7(?:
              0[02-9]|
              2[0135-79]|
              3[23]|
              4[0-27-9]|
              6[1457]|
              8
            )|
            8(?:
              [046]|
              1[01459]|
              2[0-489]|
              5(?:
                0|
                [23](?:
                  [02-8]|
                  1[1-9]|
                  9[0-46-9]
                )
              )|
              8[0-2459]|
              9[09]
            )|
            9(?:
              0[0457]|
              1[08]|
              [268]|
              4[024-9]|
              5[06-9]
            )|
            (?:
              1|
              58|
              85[23]10
            )[1-9]|
            (?:
              10|
              2[0-57-9]
            )(?:
              [0-8]|
              9[0-47-9]
            )|
            (?:
              3(?:
                [157]\\d|
                35|
                49|
                9[1-68]
              )|
              4(?:
                [17]\\d|
                2[179]|
                [35][1-9]|
                6[47-9]|
                8[23]
              )|
              5(?:
                [1357]\\d|
                2[37]|
                4[36]|
                6[1-46]|
                80|
                9[1-9]
              )|
              6(?:
                3[1-5]|
                6[0238]|
                9[12]
              )|
              7(?:
                01|
                [1579]\\d|
                2[248]|
                3[014-9]|
                4[3-6]|
                6[023689]
              )|
              8(?:
                1[236-8]|
                2[5-7]|
                [37]\\d|
                5[14-9]|
                8[36-8]|
                9[1-8]
              )|
              9(?:
                0[1-3689]|
                1[1-79]|
                [379]\\d|
                4[13]|
                5[1-5]
              )
            )(?:
              [02-8]|
              1(?:
                0[1-9]|
                [1-9]
              )|
              9[0-47-9]
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              4|
              80
            )0
          ',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            10[0-79]|
            2(?:
              [02-57-9]|
              1[1-79]
            )|
            (?:
              10|
              21
            )8(?:
              0[1-9]|
              [1-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            3(?:
              [3-59]|
              7[02-68]
            )|
            4(?:
              [26-8]|
              3[3-9]|
              5[2-9]
            )|
            5(?:
              3[03-9]|
              [468]|
              7[028]|
              9[2-46-9]
            )|
            6|
            7(?:
              [0-247]|
              3[04-9]|
              5[0-4689]|
              6[2368]
            )|
            8(?:
              [1-358]|
              9[1-7]
            )|
            9(?:
              [013479]|
              5[1-5]
            )|
            (?:
              [34]1|
              55|
              79|
              87
            )[02-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '80',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[3-578]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '1[3-9]',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'geographic' => '
          (?:
            10(?:
              [02-79]\\d\\d|
              [18](?:
                0[1-9]|
                [1-9]\\d
              )
            )|
            21(?:
              [18](?:
                0[1-9]|
                [1-9]\\d
              )|
              [2-79]\\d\\d
            )
          )\\d{5}|
          (?:
            43[35]|
            754
          )\\d{7,8}|
          8(?:
            078\\d{7}|
            51\\d{7,8}
          )|
          (?:
            10|
            (?:
              2|
              85
            )1|
            43[35]|
            754
          )(?:
            100\\d\\d|
            95\\d{3,4}
          )|
          (?:
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              [39]1|
              5[57]|
              6[09]
            )|
            8(?:
              71|
              98
            )
          )(?:
            [02-8]\\d{7}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{3}
                )?|
                [1-9]\\d{5}
              )|
              [1-9]\\d{6}
            )|
            9(?:
              [0-46-9]\\d{6}|
              5\\d{3}(?:
                \\d(?:
                  \\d{2}
                )?
              )?
            )
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[46-9]|
              5[2-9]|
              6[47-9]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[2-9]|
              7[02-9]|
              8[36-8]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            [02-8]\\d{6}|
            1(?:
              0(?:
                0\\d\\d(?:
                  \\d{2}
                )?|
                [1-9]\\d{4}
              )|
              [1-9]\\d{5}
            )|
            9(?:
              [0-46-9]\\d{5}|
              5\\d{3,5}
            )
          )
        ',
                'mobile' => '
          1740[0-5]\\d{6}|
          1(?:
            [38]\\d|
            4[57]|
            5[0-35-9]|
            6[25-7]|
            7[0-35-8]|
            9[0135-9]
          )\\d{8}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          400\\d{7}|
          950\\d{7,8}|
          (?:
            10|
            2[0-57-9]|
            3(?:
              [157]\\d|
              35|
              49|
              9[1-68]
            )|
            4(?:
              [17]\\d|
              2[179]|
              [35][1-9]|
              6[47-9]|
              8[23]
            )|
            5(?:
              [1357]\\d|
              2[37]|
              4[36]|
              6[1-46]|
              80|
              9[1-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]\\d|
              2[248]|
              3[014-9]|
              4[3-6]|
              6[023689]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              [37]\\d|
              5[14-9]|
              8[36-8]|
              9[1-8]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )96\\d{3,4}
        )|(16[08]\\d{5})',
                'toll_free' => '
          (?:
            (?:
              10|
              21
            )8|
            8
          )00\\d{7}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{en}->{8610} = "Beijing";
$areanames{en}->{861300000} = "Jinan\,\ Shandong";
$areanames{en}->{861300001} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861300002} = "Chaohu\,\ Anhui";
$areanames{en}->{861300006} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300008} = "Wuhan\,\ Hubei";
$areanames{en}->{861300010} = "Beijing";
$areanames{en}->{861300011} = "Beijing";
$areanames{en}->{861300012} = "Tianjin";
$areanames{en}->{861300013} = "Tianjin";
$areanames{en}->{861300014} = "Tianjin";
$areanames{en}->{861300015} = "Zibo\,\ Shandong";
$areanames{en}->{861300016} = "Yantai\,\ Shandong";
$areanames{en}->{861300017} = "Jinan\,\ Shandong";
$areanames{en}->{861300018} = "Tianjin";
$areanames{en}->{861300019} = "Tianjin";
$areanames{en}->{861300020} = "Shanghai";
$areanames{en}->{861300021} = "Shanghai";
$areanames{en}->{861300022} = "Shanghai";
$areanames{en}->{861300023} = "Shanghai";
$areanames{en}->{861300024} = "Shanghai";
$areanames{en}->{861300025} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300026} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300027} = "Yantai\,\ Shandong";
$areanames{en}->{861300028} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300029} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86130003} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861300030} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300031} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300032} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300040} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300041} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300042} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300043} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300044} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300045} = "Beijing";
$areanames{en}->{861300046} = "Beijing";
$areanames{en}->{861300047} = "Beijing";
$areanames{en}->{861300048} = "Beijing";
$areanames{en}->{861300049} = "Beijing";
$areanames{en}->{86130005} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130006} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300061} = "Jingmen\,\ Hubei";
$areanames{en}->{861300065} = "Weifang\,\ Shandong";
$areanames{en}->{861300067} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861300069} = "Nanning\,\ Guangxi";
$areanames{en}->{86130007} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300071} = "Wuhan\,\ Hubei";
$areanames{en}->{86130008} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300087} = "Lanzhou\,\ Gansu";
$areanames{en}->{861300091} = "Changchun\,\ Jilin";
$areanames{en}->{861300092} = "Benxi\,\ Liaoning";
$areanames{en}->{861300093} = "Yingkou\,\ Liaoning";
$areanames{en}->{861300094} = "Dalian\,\ Liaoning";
$areanames{en}->{861300095} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861300096} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861300097} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861300098} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130010} = "Beijing";
$areanames{en}->{86130011} = "Beijing";
$areanames{en}->{86130012} = "Beijing";
$areanames{en}->{86130013} = "Tianjin";
$areanames{en}->{861300140} = "Baoding\,\ Hebei";
$areanames{en}->{861300141} = "Tangshan\,\ Hebei";
$areanames{en}->{861300142} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861300143} = "Langfang\,\ Hebei";
$areanames{en}->{861300144} = "Cangzhou\,\ Hebei";
$areanames{en}->{861300145} = "Xingtai\,\ Hebei";
$areanames{en}->{861300146} = "Handan\,\ Hebei";
$areanames{en}->{861300147} = "Hengshui\,\ Hebei";
$areanames{en}->{861300148} = "Cangzhou\,\ Hebei";
$areanames{en}->{861300149} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861300150} = "Zibo\,\ Shandong";
$areanames{en}->{861300151} = "Zibo\,\ Shandong";
$areanames{en}->{861300152} = "Binzhou\,\ Shandong";
$areanames{en}->{861300153} = "Weifang\,\ Shandong";
$areanames{en}->{861300154} = "Weifang\,\ Shandong";
$areanames{en}->{861300155} = "Weifang\,\ Shandong";
$areanames{en}->{861300156} = "Dongying\,\ Shandong";
$areanames{en}->{861300157} = "Linyi\,\ Shandong";
$areanames{en}->{861300158} = "Rizhao\,\ Shandong";
$areanames{en}->{861300159} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861300160} = "Yantai\,\ Shandong";
$areanames{en}->{861300161} = "Yantai\,\ Shandong";
$areanames{en}->{861300162} = "Yantai\,\ Shandong";
$areanames{en}->{861300163} = "Weihai\,\ Shandong";
$areanames{en}->{861300164} = "Weihai\,\ Shandong";
$areanames{en}->{861300165} = "Weihai\,\ Shandong";
$areanames{en}->{861300166} = "Qingdao\,\ Shandong";
$areanames{en}->{861300167} = "Qingdao\,\ Shandong";
$areanames{en}->{861300168} = "Qingdao\,\ Shandong";
$areanames{en}->{861300169} = "Qingdao\,\ Shandong";
$areanames{en}->{861300170} = "Jinan\,\ Shandong";
$areanames{en}->{861300171} = "Jinan\,\ Shandong";
$areanames{en}->{861300172} = "Jinan\,\ Shandong";
$areanames{en}->{861300173} = "Jinan\,\ Shandong";
$areanames{en}->{861300174} = "Jinan\,\ Shandong";
$areanames{en}->{861300175} = "Liaocheng\,\ Shandong";
$areanames{en}->{861300176} = "Dezhou\,\ Shandong";
$areanames{en}->{861300177} = "TaiAn\,\ Shandong";
$areanames{en}->{861300178} = "Jining\,\ Shandong";
$areanames{en}->{861300179} = "Heze\,\ Shandong";
$areanames{en}->{861300180} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861300181} = "Tangshan\,\ Hebei";
$areanames{en}->{861300182} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861300183} = "Langfang\,\ Hebei";
$areanames{en}->{861300184} = "Tangshan\,\ Hebei";
$areanames{en}->{861300185} = "Xingtai\,\ Hebei";
$areanames{en}->{861300186} = "Handan\,\ Hebei";
$areanames{en}->{861300187} = "Baoding\,\ Hebei";
$areanames{en}->{861300188} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861300189} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86130019} = "Beijing";
$areanames{en}->{86130020} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130021} = "Shanghai";
$areanames{en}->{86130022} = "Tianjin";
$areanames{en}->{86130023} = "Chongqing";
$areanames{en}->{86130024} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130025} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300260} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861300261} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861300262} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861300263} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861300264} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861300265} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861300266} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861300267} = "Lishui\,\ Zhejiang";
$areanames{en}->{861300268} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861300269} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861300270} = "Zibo\,\ Shandong";
$areanames{en}->{861300271} = "Zibo\,\ Shandong";
$areanames{en}->{861300272} = "Yantai\,\ Shandong";
$areanames{en}->{861300273} = "Yantai\,\ Shandong";
$areanames{en}->{861300274} = "Yantai\,\ Shandong";
$areanames{en}->{861300275} = "Yantai\,\ Shandong";
$areanames{en}->{861300276} = "Laiwu\,\ Shandong";
$areanames{en}->{861300277} = "TaiAn\,\ Shandong";
$areanames{en}->{861300278} = "Weifang\,\ Shandong";
$areanames{en}->{861300279} = "Linyi\,\ Shandong";
$areanames{en}->{861300280} = "Liangshan\,\ Sichuan";
$areanames{en}->{861300281} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861300282} = "Nanchong\,\ Sichuan";
$areanames{en}->{861300283} = "Suining\,\ Sichuan";
$areanames{en}->{861300284} = "Suining\,\ Sichuan";
$areanames{en}->{861300285} = "Dazhou\,\ Sichuan";
$areanames{en}->{861300286} = "Luzhou\,\ Sichuan";
$areanames{en}->{861300287} = "Neijiang\,\ Sichuan";
$areanames{en}->{861300288} = "Yibin\,\ Sichuan";
$areanames{en}->{861300289} = "Zigong\,\ Sichuan";
$areanames{en}->{86130029} = "XiAn\,\ Shaanxi";
$areanames{en}->{861300300} = "Hefei\,\ Anhui";
$areanames{en}->{861300301} = "Bengbu\,\ Anhui";
$areanames{en}->{861300302} = "Bengbu\,\ Anhui";
$areanames{en}->{861300303} = "Wuhu\,\ Anhui";
$areanames{en}->{861300304} = "Wuhu\,\ Anhui";
$areanames{en}->{861300305} = "Hefei\,\ Anhui";
$areanames{en}->{861300306} = "Hefei\,\ Anhui";
$areanames{en}->{861300307} = "Huainan\,\ Anhui";
$areanames{en}->{861300308} = "Hefei\,\ Anhui";
$areanames{en}->{861300309} = "Hefei\,\ Anhui";
$areanames{en}->{86130031} = "Shanghai";
$areanames{en}->{86130032} = "Shanghai";
$areanames{en}->{86130033} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861300340} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300341} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300342} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861300343} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861300344} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861300345} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861300346} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861300347} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861300348} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861300349} = "Suqian\,\ Jiangsu";
$areanames{en}->{86130035} = "Nantong\,\ Jiangsu";
$areanames{en}->{861300350} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861300351} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861300352} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861300354} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{86130036} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130037} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130038} = "Fuzhou\,\ Fujian";
$areanames{en}->{861300385} = "Putian\,\ Fujian";
$areanames{en}->{861300386} = "Putian\,\ Fujian";
$areanames{en}->{86130039} = "Xiamen\,\ Fujian";
$areanames{en}->{861300395} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861300396} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861300400} = "Huainan\,\ Anhui";
$areanames{en}->{861300401} = "Fuyang\,\ Anhui";
$areanames{en}->{861300402} = "Fuyang\,\ Anhui";
$areanames{en}->{861300403} = "Fuyang\,\ Anhui";
$areanames{en}->{861300404} = "Wuhu\,\ Anhui";
$areanames{en}->{861300405} = "Wuhu\,\ Anhui";
$areanames{en}->{861300406} = "Wuhu\,\ Anhui";
$areanames{en}->{861300407} = "Bengbu\,\ Anhui";
$areanames{en}->{861300408} = "Bengbu\,\ Anhui";
$areanames{en}->{861300409} = "Bengbu\,\ Anhui";
$areanames{en}->{86130041} = "Shanghai";
$areanames{en}->{861300420} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861300421} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861300422} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861300423} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861300424} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861300425} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861300426} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861300427} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861300428} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861300429} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{86130043} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861300435} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861300436} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861300437} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861300438} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861300440} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861300441} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861300442} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861300443} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861300444} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861300445} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861300446} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861300447} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861300448} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861300449} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86130045} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861300460} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861300461} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861300462} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861300463} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861300464} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861300465} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861300466} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861300467} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861300468} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861300469} = "Lishui\,\ Zhejiang";
$areanames{en}->{86130047} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861300476} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861300477} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861300478} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861300479} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86130048} = "Quanzhou\,\ Fujian";
$areanames{en}->{861300490} = "Sanming\,\ Fujian";
$areanames{en}->{861300491} = "Ningde\,\ Fujian";
$areanames{en}->{861300492} = "Ningde\,\ Fujian";
$areanames{en}->{861300493} = "Ningde\,\ Fujian";
$areanames{en}->{861300494} = "Nanping\,\ Fujian";
$areanames{en}->{861300495} = "Nanping\,\ Fujian";
$areanames{en}->{861300496} = "Nanping\,\ Fujian";
$areanames{en}->{861300497} = "Longyan\,\ Fujian";
$areanames{en}->{861300498} = "Longyan\,\ Fujian";
$areanames{en}->{861300499} = "Sanming\,\ Fujian";
$areanames{en}->{86130050} = "Haikou\,\ Hainan";
$areanames{en}->{86130051} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300520} = "Shantou\,\ Guangdong";
$areanames{en}->{861300521} = "Shantou\,\ Guangdong";
$areanames{en}->{861300522} = "Shantou\,\ Guangdong";
$areanames{en}->{861300523} = "Shantou\,\ Guangdong";
$areanames{en}->{861300524} = "Shantou\,\ Guangdong";
$areanames{en}->{861300525} = "Shanwei\,\ Guangdong";
$areanames{en}->{861300526} = "Jieyang\,\ Guangdong";
$areanames{en}->{861300527} = "Jieyang\,\ Guangdong";
$areanames{en}->{861300528} = "Meizhou\,\ Guangdong";
$areanames{en}->{861300529} = "Meizhou\,\ Guangdong";
$areanames{en}->{861300530} = "Heyuan\,\ Guangdong";
$areanames{en}->{861300531} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861300532} = "Shantou\,\ Guangdong";
$areanames{en}->{861300533} = "Shantou\,\ Guangdong";
$areanames{en}->{861300534} = "Shantou\,\ Guangdong";
$areanames{en}->{861300535} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861300536} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861300537} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861300538} = "Yunfu\,\ Guangdong";
$areanames{en}->{861300539} = "Yunfu\,\ Guangdong";
$areanames{en}->{86130054} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130055} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861300556} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861300557} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861300558} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861300559} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861300560} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861300561} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861300562} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861300563} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861300564} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861300565} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861300566} = "Maoming\,\ Guangdong";
$areanames{en}->{861300567} = "Maoming\,\ Guangdong";
$areanames{en}->{861300568} = "Maoming\,\ Guangdong";
$areanames{en}->{861300569} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86130057} = "Huizhou\,\ Guangdong";
$areanames{en}->{861300576} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861300577} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861300578} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861300579} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86130058} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861300590} = "Nanning\,\ Guangxi";
$areanames{en}->{861300591} = "Nanning\,\ Guangxi";
$areanames{en}->{861300592} = "Nanning\,\ Guangxi";
$areanames{en}->{861300593} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861300594} = "Guilin\,\ Guangxi";
$areanames{en}->{861300595} = "Guilin\,\ Guangxi";
$areanames{en}->{861300596} = "Yulin\,\ Guangxi";
$areanames{en}->{861300597} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861300598} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861300599} = "Beihai\,\ Guangxi";
$areanames{en}->{86130060} = "Haikou\,\ Hainan";
$areanames{en}->{86130061} = "Wuhan\,\ Hubei";
$areanames{en}->{861300620} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861300621} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861300622} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861300623} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861300624} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861300625} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861300626} = "Yichun\,\ Jiangxi";
$areanames{en}->{861300627} = "Yichun\,\ Jiangxi";
$areanames{en}->{861300628} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861300629} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86130063} = "Wuhan\,\ Hubei";
$areanames{en}->{861300640} = "Leshan\,\ Sichuan";
$areanames{en}->{861300641} = "Meishan\,\ Sichuan";
$areanames{en}->{861300642} = "Leshan\,\ Sichuan";
$areanames{en}->{861300643} = "Deyang\,\ Sichuan";
$areanames{en}->{861300644} = "Deyang\,\ Sichuan";
$areanames{en}->{861300645} = "Deyang\,\ Sichuan";
$areanames{en}->{861300646} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861300647} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861300648} = "Mianyang\,\ Sichuan";
$areanames{en}->{861300649} = "Mianyang\,\ Sichuan";
$areanames{en}->{861300650} = "Qingdao\,\ Shandong";
$areanames{en}->{861300651} = "Qingdao\,\ Shandong";
$areanames{en}->{861300652} = "Qingdao\,\ Shandong";
$areanames{en}->{861300653} = "Qingdao\,\ Shandong";
$areanames{en}->{861300654} = "Dongying\,\ Shandong";
$areanames{en}->{861300655} = "Weifang\,\ Shandong";
$areanames{en}->{861300656} = "Weifang\,\ Shandong";
$areanames{en}->{861300657} = "Jinan\,\ Shandong";
$areanames{en}->{861300658} = "Jinan\,\ Shandong";
$areanames{en}->{861300659} = "Jinan\,\ Shandong";
$areanames{en}->{86130066} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130067} = "Foshan\,\ Guangdong";
$areanames{en}->{86130068} = "Dongguan\,\ Guangdong";
$areanames{en}->{861300686} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300687} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300688} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300689} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861300690} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861300691} = "Nanning\,\ Guangxi";
$areanames{en}->{861300692} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861300693} = "Guilin\,\ Guangxi";
$areanames{en}->{861300694} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861300695} = "Yulin\,\ Guangxi";
$areanames{en}->{861300696} = "Baise\,\ Guangxi";
$areanames{en}->{861300697} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861300698} = "Hechi\,\ Guangxi";
$areanames{en}->{861300699} = "Beihai\,\ Guangxi";
$areanames{en}->{86130070} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861300705} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861300706} = "Jinzhong\,\ Shanxi";
$areanames{en}->{86130071} = "Wuhan\,\ Hubei";
$areanames{en}->{86130072} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861300725} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861300726} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861300727} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861300729} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861300730} = "Yueyang\,\ Hunan";
$areanames{en}->{861300731} = "Changsha\,\ Hunan";
$areanames{en}->{861300732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861300733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861300734} = "Hengyang\,\ Hunan";
$areanames{en}->{861300735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861300736} = "Changde\,\ Hunan";
$areanames{en}->{861300737} = "Yiyang\,\ Hunan";
$areanames{en}->{861300738} = "Loudi\,\ Hunan";
$areanames{en}->{861300739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861300740} = "Changde\,\ Hunan";
$areanames{en}->{861300741} = "Changsha\,\ Hunan";
$areanames{en}->{861300742} = "Changsha\,\ Hunan";
$areanames{en}->{861300743} = "Changsha\,\ Hunan";
$areanames{en}->{861300744} = "Xiangtan\,\ Hunan";
$areanames{en}->{861300745} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861300746} = "Hengyang\,\ Hunan";
$areanames{en}->{861300747} = "Yueyang\,\ Hunan";
$areanames{en}->{861300748} = "Changsha\,\ Hunan";
$areanames{en}->{861300749} = "Changsha\,\ Hunan";
$areanames{en}->{861300750} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300751} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300752} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300753} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300754} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300755} = "Luoyang\,\ Henan";
$areanames{en}->{861300756} = "Luoyang\,\ Henan";
$areanames{en}->{861300757} = "Luoyang\,\ Henan";
$areanames{en}->{861300758} = "Luoyang\,\ Henan";
$areanames{en}->{861300759} = "Anyang\,\ Henan";
$areanames{en}->{861300760} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300761} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300762} = "Zhengzhou\,\ Henan";
$areanames{en}->{861300763} = "Luoyang\,\ Henan";
$areanames{en}->{861300764} = "Kaifeng\,\ Henan";
$areanames{en}->{861300765} = "Jiaozuo\,\ Henan";
$areanames{en}->{861300766} = "Xinxiang\,\ Henan";
$areanames{en}->{861300767} = "Xuchang\,\ Henan";
$areanames{en}->{861300768} = "Luohe\,\ Henan";
$areanames{en}->{861300769} = "Anyang\,\ Henan";
$areanames{en}->{861300770} = "Haixi\,\ Qinghai";
$areanames{en}->{861300771} = "Xining\,\ Qinghai";
$areanames{en}->{861300772} = "Haidong\,\ Qinghai";
$areanames{en}->{861300773} = "Haidong\,\ Qinghai";
$areanames{en}->{861300774} = "Hainan\,\ Qinghai";
$areanames{en}->{861300775} = "Haibei\,\ Qinghai";
$areanames{en}->{861300776} = "Xining\,\ Qinghai";
$areanames{en}->{861300777} = "Xining\,\ Qinghai";
$areanames{en}->{861300778} = "Xining\,\ Qinghai";
$areanames{en}->{861300779} = "Xining\,\ Qinghai";
$areanames{en}->{86130078} = "Guiyang\,\ Guizhou";
$areanames{en}->{861300787} = "Zunyi\,\ Guizhou";
$areanames{en}->{861300789} = "Anshun\,\ Guizhou";
$areanames{en}->{861300790} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861300791} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861300792} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861300793} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861300794} = "Guyuan\,\ Ningxia";
$areanames{en}->{861300795} = "Guyuan\,\ Ningxia";
$areanames{en}->{861300796} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861300797} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861300798} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861300799} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861300800} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861300801} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861300802} = "Linfen\,\ Shanxi";
$areanames{en}->{861300803} = "Linfen\,\ Shanxi";
$areanames{en}->{861300804} = "Datong\,\ Shanxi";
$areanames{en}->{861300805} = "Jincheng\,\ Shanxi";
$areanames{en}->{861300806} = "Changzhi\,\ Shanxi";
$areanames{en}->{861300807} = "Changzhi\,\ Shanxi";
$areanames{en}->{861300808} = "Datong\,\ Shanxi";
$areanames{en}->{861300809} = "Datong\,\ Shanxi";
$areanames{en}->{86130081} = "Chengdu\,\ Sichuan";
$areanames{en}->{861300820} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861300821} = "Fuxin\,\ Liaoning";
$areanames{en}->{861300822} = "Panjin\,\ Liaoning";
$areanames{en}->{861300823} = "Panjin\,\ Liaoning";
$areanames{en}->{861300824} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861300825} = "Panjin\,\ Liaoning";
$areanames{en}->{861300826} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861300827} = "Tieling\,\ Liaoning";
$areanames{en}->{861300828} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861300829} = "Fuxin\,\ Liaoning";
$areanames{en}->{86130083} = "Chongqing";
$areanames{en}->{861300840} = "XiAn\,\ Shaanxi";
$areanames{en}->{861300841} = "XiAn\,\ Shaanxi";
$areanames{en}->{861300842} = "XiAn\,\ Shaanxi";
$areanames{en}->{861300843} = "Weinan\,\ Shaanxi";
$areanames{en}->{861300844} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861300845} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861300846} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861300847} = "Baoji\,\ Shaanxi";
$areanames{en}->{861300848} = "Baoji\,\ Shaanxi";
$areanames{en}->{861300849} = "Baoji\,\ Shaanxi";
$areanames{en}->{861300850} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861300851} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861300852} = "Weinan\,\ Shaanxi";
$areanames{en}->{861300853} = "Weinan\,\ Shaanxi";
$areanames{en}->{861300854} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861300855} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861300856} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861300857} = "YanAn\,\ Shaanxi";
$areanames{en}->{861300858} = "YanAn\,\ Shaanxi";
$areanames{en}->{861300859} = "YanAn\,\ Shaanxi";
$areanames{en}->{861300860} = "Honghe\,\ Yunnan";
$areanames{en}->{861300861} = "Honghe\,\ Yunnan";
$areanames{en}->{861300862} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861300863} = "Qujing\,\ Yunnan";
$areanames{en}->{861300864} = "Yuxi\,\ Yunnan";
$areanames{en}->{861300865} = "Kunming\,\ Yunnan";
$areanames{en}->{861300866} = "Kunming\,\ Yunnan";
$areanames{en}->{861300867} = "Kunming\,\ Yunnan";
$areanames{en}->{861300868} = "Kunming\,\ Yunnan";
$areanames{en}->{861300869} = "Kunming\,\ Yunnan";
$areanames{en}->{86130087} = "Lanzhou\,\ Gansu";
$areanames{en}->{86130088} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130089} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861300900} = "Changchun\,\ Jilin";
$areanames{en}->{861300901} = "Changchun\,\ Jilin";
$areanames{en}->{861300902} = "Siping\,\ Jilin";
$areanames{en}->{861300903} = "Siping\,\ Jilin";
$areanames{en}->{861300904} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861300905} = "Songyuan\,\ Jilin";
$areanames{en}->{861300906} = "Baicheng\,\ Jilin";
$areanames{en}->{861300907} = "Baishan\,\ Jilin";
$areanames{en}->{861300908} = "Yanbian\,\ Jilin";
$areanames{en}->{861300909} = "Yanbian\,\ Jilin";
$areanames{en}->{861300910} = "Changchun\,\ Jilin";
$areanames{en}->{861300911} = "Changchun\,\ Jilin";
$areanames{en}->{861300912} = "Changchun\,\ Jilin";
$areanames{en}->{861300913} = "Changchun\,\ Jilin";
$areanames{en}->{861300914} = "Changchun\,\ Jilin";
$areanames{en}->{861300915} = "Jilin\,\ Jilin";
$areanames{en}->{861300916} = "Jilin\,\ Jilin";
$areanames{en}->{861300917} = "Jilin\,\ Jilin";
$areanames{en}->{861300918} = "Jilin\,\ Jilin";
$areanames{en}->{861300919} = "Tonghua\,\ Jilin";
$areanames{en}->{861300920} = "Dandong\,\ Liaoning";
$areanames{en}->{861300921} = "Dandong\,\ Liaoning";
$areanames{en}->{861300922} = "Benxi\,\ Liaoning";
$areanames{en}->{861300923} = "Benxi\,\ Liaoning";
$areanames{en}->{861300924} = "Fushun\,\ Liaoning";
$areanames{en}->{861300925} = "Fushun\,\ Liaoning";
$areanames{en}->{861300926} = "Fushun\,\ Liaoning";
$areanames{en}->{861300927} = "Tieling\,\ Liaoning";
$areanames{en}->{861300928} = "Huludao\,\ Liaoning";
$areanames{en}->{861300929} = "Huludao\,\ Liaoning";
$areanames{en}->{861300930} = "Yingkou\,\ Liaoning";
$areanames{en}->{861300931} = "Yingkou\,\ Liaoning";
$areanames{en}->{861300932} = "Yingkou\,\ Liaoning";
$areanames{en}->{861300933} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861300934} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861300935} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861300936} = "Anshan\,\ Liaoning";
$areanames{en}->{861300937} = "Anshan\,\ Liaoning";
$areanames{en}->{861300938} = "Anshan\,\ Liaoning";
$areanames{en}->{861300939} = "Anshan\,\ Liaoning";
$areanames{en}->{86130094} = "Dalian\,\ Liaoning";
$areanames{en}->{861300950} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861300951} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861300952} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861300953} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861300954} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861300955} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861300956} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861300957} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861300958} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861300959} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{86130096} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861300960} = "Changji\,\ Xinjiang";
$areanames{en}->{861300970} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300971} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300972} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300973} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861300974} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861300975} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861300976} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861300977} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861300978} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861300979} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861300980} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300981} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861300982} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861300983} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861300984} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300985} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300986} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300987} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861300988} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861300989} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861300990} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861300991} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861300992} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861300993} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861300994} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861300995} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861300996} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861300997} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861300998} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861300999} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861301000} = "Shanghai";
$areanames{en}->{861301006} = "Beijing";
$areanames{en}->{861301007} = "Beijing";
$areanames{en}->{861301008} = "Beijing";
$areanames{en}->{861301009} = "Beijing";
$areanames{en}->{861301010} = "Beijing";
$areanames{en}->{861301011} = "Beijing";
$areanames{en}->{861301012} = "Beijing";
$areanames{en}->{861301013} = "Tianjin";
$areanames{en}->{861301014} = "Hengshui\,\ Hebei";
$areanames{en}->{861301015} = "Zibo\,\ Shandong";
$areanames{en}->{861301016} = "Yantai\,\ Shandong";
$areanames{en}->{861301017} = "Jinan\,\ Shandong";
$areanames{en}->{861301018} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301019} = "Beijing";
$areanames{en}->{861301020} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861301024} = "Shenyang\,\ Liaoning";
$areanames{en}->{861301027} = "Laiwu\,\ Shandong";
$areanames{en}->{861301030} = "Hefei\,\ Anhui";
$areanames{en}->{861301031} = "Shanghai";
$areanames{en}->{861301033} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861301034} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861301035} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861301036} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861301037} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861301038} = "Fuzhou\,\ Fujian";
$areanames{en}->{861301039} = "Xiamen\,\ Fujian";
$areanames{en}->{861301042} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861301043} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861301044} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861301045} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861301046} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861301047} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861301048} = "Quanzhou\,\ Fujian";
$areanames{en}->{861301049} = "Ningde\,\ Fujian";
$areanames{en}->{861301050} = "Haikou\,\ Hainan";
$areanames{en}->{861301051} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861301052} = "Shantou\,\ Guangdong";
$areanames{en}->{861301053} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861301054} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861301055} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861301056} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861301057} = "Huizhou\,\ Guangdong";
$areanames{en}->{861301058} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861301059} = "Nanning\,\ Guangxi";
$areanames{en}->{861301062} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861301064} = "Leshan\,\ Sichuan";
$areanames{en}->{861301066} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861301067} = "Foshan\,\ Guangdong";
$areanames{en}->{861301068} = "Dongguan\,\ Guangdong";
$areanames{en}->{861301070} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301071} = "Wuhan\,\ Hubei";
$areanames{en}->{861301072} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861301073} = "Yueyang\,\ Hunan";
$areanames{en}->{861301074} = "Changsha\,\ Hunan";
$areanames{en}->{861301075} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861301076} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301077} = "Wuhan\,\ Hubei";
$areanames{en}->{861301078} = "Guiyang\,\ Guizhou";
$areanames{en}->{861301079} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861301081} = "Chengdu\,\ Sichuan";
$areanames{en}->{861301082} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861301083} = "Chongqing";
$areanames{en}->{861301084} = "XiAn\,\ Shaanxi";
$areanames{en}->{861301085} = "XiAn\,\ Shaanxi";
$areanames{en}->{861301086} = "Kunming\,\ Yunnan";
$areanames{en}->{861301087} = "Lanzhou\,\ Gansu";
$areanames{en}->{861301088} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861301089} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861301091} = "Changchun\,\ Jilin";
$areanames{en}->{861301092} = "Dandong\,\ Liaoning";
$areanames{en}->{861301093} = "Yingkou\,\ Liaoning";
$areanames{en}->{861301094} = "Dalian\,\ Liaoning";
$areanames{en}->{861301095} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301096} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861301097} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861301098} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130110} = "Beijing";
$areanames{en}->{86130111} = "Beijing";
$areanames{en}->{86130112} = "Beijing";
$areanames{en}->{86130113} = "Tianjin";
$areanames{en}->{861301140} = "Baoding\,\ Hebei";
$areanames{en}->{861301141} = "Baoding\,\ Hebei";
$areanames{en}->{861301142} = "Cangzhou\,\ Hebei";
$areanames{en}->{861301143} = "Tangshan\,\ Hebei";
$areanames{en}->{861301144} = "Tangshan\,\ Hebei";
$areanames{en}->{861301145} = "Xingtai\,\ Hebei";
$areanames{en}->{861301146} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861301147} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861301148} = "Langfang\,\ Hebei";
$areanames{en}->{861301149} = "Handan\,\ Hebei";
$areanames{en}->{861301150} = "Tangshan\,\ Hebei";
$areanames{en}->{861301151} = "Tangshan\,\ Hebei";
$areanames{en}->{861301152} = "Tangshan\,\ Hebei";
$areanames{en}->{861301153} = "Handan\,\ Hebei";
$areanames{en}->{861301154} = "Handan\,\ Hebei";
$areanames{en}->{861301155} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301156} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301157} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301158} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301159} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301160} = "Zibo\,\ Shandong";
$areanames{en}->{861301161} = "Zibo\,\ Shandong";
$areanames{en}->{861301162} = "Zibo\,\ Shandong";
$areanames{en}->{861301163} = "Zibo\,\ Shandong";
$areanames{en}->{861301164} = "Zibo\,\ Shandong";
$areanames{en}->{861301165} = "Weifang\,\ Shandong";
$areanames{en}->{861301166} = "Weifang\,\ Shandong";
$areanames{en}->{861301167} = "Weifang\,\ Shandong";
$areanames{en}->{861301168} = "Weifang\,\ Shandong";
$areanames{en}->{861301169} = "Weifang\,\ Shandong";
$areanames{en}->{861301170} = "Jinan\,\ Shandong";
$areanames{en}->{861301171} = "Jinan\,\ Shandong";
$areanames{en}->{861301172} = "Jinan\,\ Shandong";
$areanames{en}->{861301173} = "Jinan\,\ Shandong";
$areanames{en}->{861301174} = "Jinan\,\ Shandong";
$areanames{en}->{861301175} = "Dezhou\,\ Shandong";
$areanames{en}->{861301176} = "Dezhou\,\ Shandong";
$areanames{en}->{861301177} = "TaiAn\,\ Shandong";
$areanames{en}->{861301178} = "TaiAn\,\ Shandong";
$areanames{en}->{861301179} = "Binzhou\,\ Shandong";
$areanames{en}->{86130118} = "Beijing";
$areanames{en}->{861301190} = "Baoding\,\ Hebei";
$areanames{en}->{861301191} = "Baoding\,\ Hebei";
$areanames{en}->{861301192} = "Baoding\,\ Hebei";
$areanames{en}->{861301193} = "Langfang\,\ Hebei";
$areanames{en}->{861301194} = "Langfang\,\ Hebei";
$areanames{en}->{861301195} = "Xingtai\,\ Hebei";
$areanames{en}->{861301196} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861301197} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861301198} = "Cangzhou\,\ Hebei";
$areanames{en}->{861301199} = "Cangzhou\,\ Hebei";
$areanames{en}->{861301200} = "Langfang\,\ Hebei";
$areanames{en}->{861301201} = "Tangshan\,\ Hebei";
$areanames{en}->{861301202} = "Cangzhou\,\ Hebei";
$areanames{en}->{861301203} = "Cangzhou\,\ Hebei";
$areanames{en}->{861301204} = "Cangzhou\,\ Hebei";
$areanames{en}->{861301205} = "Baoding\,\ Hebei";
$areanames{en}->{861301206} = "Baoding\,\ Hebei";
$areanames{en}->{861301207} = "Baoding\,\ Hebei";
$areanames{en}->{861301208} = "Langfang\,\ Hebei";
$areanames{en}->{861301209} = "Hengshui\,\ Hebei";
$areanames{en}->{861301210} = "Handan\,\ Hebei";
$areanames{en}->{861301211} = "Handan\,\ Hebei";
$areanames{en}->{861301212} = "Xingtai\,\ Hebei";
$areanames{en}->{861301213} = "Xingtai\,\ Hebei";
$areanames{en}->{861301214} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301215} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301216} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301217} = "Tangshan\,\ Hebei";
$areanames{en}->{861301218} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861301219} = "Tangshan\,\ Hebei";
$areanames{en}->{86130122} = "Tianjin";
$areanames{en}->{86130123} = "Chongqing";
$areanames{en}->{86130124} = "Qingdao\,\ Shandong";
$areanames{en}->{86130125} = "Qingdao\,\ Shandong";
$areanames{en}->{861301256} = "Yantai\,\ Shandong";
$areanames{en}->{861301257} = "Yantai\,\ Shandong";
$areanames{en}->{861301258} = "Yantai\,\ Shandong";
$areanames{en}->{861301259} = "Yantai\,\ Shandong";
$areanames{en}->{86130126} = "Jining\,\ Shandong";
$areanames{en}->{861301266} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861301267} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861301268} = "Liaocheng\,\ Shandong";
$areanames{en}->{861301269} = "Heze\,\ Shandong";
$areanames{en}->{861301270} = "Zibo\,\ Shandong";
$areanames{en}->{861301271} = "Zibo\,\ Shandong";
$areanames{en}->{861301272} = "Binzhou\,\ Shandong";
$areanames{en}->{861301273} = "Weihai\,\ Shandong";
$areanames{en}->{861301274} = "TaiAn\,\ Shandong";
$areanames{en}->{861301275} = "Laiwu\,\ Shandong";
$areanames{en}->{861301276} = "Dezhou\,\ Shandong";
$areanames{en}->{861301277} = "Rizhao\,\ Shandong";
$areanames{en}->{861301278} = "Liaocheng\,\ Shandong";
$areanames{en}->{861301279} = "Linyi\,\ Shandong";
$areanames{en}->{86130128} = "Shanghai";
$areanames{en}->{861301290} = "Dongying\,\ Shandong";
$areanames{en}->{861301291} = "Dongying\,\ Shandong";
$areanames{en}->{861301292} = "Jining\,\ Shandong";
$areanames{en}->{861301293} = "Jining\,\ Shandong";
$areanames{en}->{861301294} = "Qingdao\,\ Shandong";
$areanames{en}->{861301295} = "Qingdao\,\ Shandong";
$areanames{en}->{861301296} = "Heze\,\ Shandong";
$areanames{en}->{861301297} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861301298} = "Jinan\,\ Shandong";
$areanames{en}->{861301299} = "Jinan\,\ Shandong";
$areanames{en}->{861301300} = "Chuzhou\,\ Anhui";
$areanames{en}->{861301301} = "Chuzhou\,\ Anhui";
$areanames{en}->{861301302} = "Chuzhou\,\ Anhui";
$areanames{en}->{861301303} = "Hefei\,\ Anhui";
$areanames{en}->{861301304} = "Chizhou\,\ Anhui";
$areanames{en}->{861301305} = "Huainan\,\ Anhui";
$areanames{en}->{861301306} = "Hefei\,\ Anhui";
$areanames{en}->{861301307} = "Hefei\,\ Anhui";
$areanames{en}->{861301308} = "Hefei\,\ Anhui";
$areanames{en}->{861301309} = "Hefei\,\ Anhui";
$areanames{en}->{861301310} = "MaAnshan\,\ Anhui";
$areanames{en}->{861301311} = "MaAnshan\,\ Anhui";
$areanames{en}->{861301312} = "Huangshan\,\ Anhui";
$areanames{en}->{861301313} = "Xuancheng\,\ Anhui";
$areanames{en}->{861301314} = "Xuancheng\,\ Anhui";
$areanames{en}->{861301315} = "Tongling\,\ Anhui";
$areanames{en}->{861301316} = "Anqing\,\ Anhui";
$areanames{en}->{861301317} = "Anqing\,\ Anhui";
$areanames{en}->{861301318} = "Anqing\,\ Anhui";
$areanames{en}->{861301319} = "Anqing\,\ Anhui";
$areanames{en}->{861301320} = "Handan\,\ Hebei";
$areanames{en}->{861301321} = "Langfang\,\ Hebei";
$areanames{en}->{861301322} = "Cangzhou\,\ Hebei";
$areanames{en}->{861301323} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301324} = "Baoding\,\ Hebei";
$areanames{en}->{861301325} = "Baoding\,\ Hebei";
$areanames{en}->{861301326} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861301327} = "Hengshui\,\ Hebei";
$areanames{en}->{861301328} = "Tangshan\,\ Hebei";
$areanames{en}->{861301329} = "Xingtai\,\ Hebei";
$areanames{en}->{861301330} = "Kunming\,\ Yunnan";
$areanames{en}->{861301331} = "Kunming\,\ Yunnan";
$areanames{en}->{861301332} = "Kunming\,\ Yunnan";
$areanames{en}->{861301333} = "Kunming\,\ Yunnan";
$areanames{en}->{861301334} = "Qujing\,\ Yunnan";
$areanames{en}->{861301335} = "Kunming\,\ Yunnan";
$areanames{en}->{861301336} = "Dali\,\ Yunnan";
$areanames{en}->{861301337} = "Yuxi\,\ Yunnan";
$areanames{en}->{861301338} = "Lijiang\,\ Yunnan";
$areanames{en}->{861301339} = "Dali\,\ Yunnan";
$areanames{en}->{861301340} = "Honghe\,\ Yunnan";
$areanames{en}->{861301341} = "Honghe\,\ Yunnan";
$areanames{en}->{861301342} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861301343} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861301344} = "Dali\,\ Yunnan";
$areanames{en}->{861301345} = "Qujing\,\ Yunnan";
$areanames{en}->{861301346} = "Qujing\,\ Yunnan";
$areanames{en}->{861301347} = "Lijiang\,\ Yunnan";
$areanames{en}->{861301348} = "Yuxi\,\ Yunnan";
$areanames{en}->{861301349} = "Yuxi\,\ Yunnan";
$areanames{en}->{86130135} = "Linyi\,\ Shandong";
$areanames{en}->{861301356} = "Dongying\,\ Shandong";
$areanames{en}->{861301357} = "Weihai\,\ Shandong";
$areanames{en}->{861301358} = "Weihai\,\ Shandong";
$areanames{en}->{861301359} = "Rizhao\,\ Shandong";
$areanames{en}->{86130136} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861301370} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861301371} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861301372} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861301373} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861301374} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861301375} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861301376} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861301377} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861301378} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861301379} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130138} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130139} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861301390} = "Suqian\,\ Jiangsu";
$areanames{en}->{861301391} = "Suqian\,\ Jiangsu";
$areanames{en}->{861301392} = "Suqian\,\ Jiangsu";
$areanames{en}->{861301400} = "Suzhou\,\ Anhui";
$areanames{en}->{861301401} = "Suzhou\,\ Anhui";
$areanames{en}->{861301402} = "LuAn\,\ Anhui";
$areanames{en}->{861301403} = "LuAn\,\ Anhui";
$areanames{en}->{861301404} = "Huaibei\,\ Anhui";
$areanames{en}->{861301405} = "Huaibei\,\ Anhui";
$areanames{en}->{861301406} = "Fuyang\,\ Anhui";
$areanames{en}->{861301407} = "Fuyang\,\ Anhui";
$areanames{en}->{861301408} = "Fuyang\,\ Anhui";
$areanames{en}->{861301409} = "Fuyang\,\ Anhui";
$areanames{en}->{861301410} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861301411} = "Zhangye\,\ Gansu";
$areanames{en}->{861301412} = "Zhangye\,\ Gansu";
$areanames{en}->{861301413} = "Wuwei\,\ Gansu";
$areanames{en}->{861301414} = "Lanzhou\,\ Gansu";
$areanames{en}->{861301415} = "Wuwei\,\ Gansu";
$areanames{en}->{861301416} = "Wuwei\,\ Gansu";
$areanames{en}->{861301417} = "Wuwei\,\ Gansu";
$areanames{en}->{861301418} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861301419} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861301420} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861301421} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861301422} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861301423} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861301424} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861301425} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861301426} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861301427} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861301428} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861301429} = "Yinchuan\,\ Ningxia";
$areanames{en}->{86130143} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861301430} = "Baoding\,\ Hebei";
$areanames{en}->{861301431} = "Tangshan\,\ Hebei";
$areanames{en}->{861301432} = "Tangshan\,\ Hebei";
$areanames{en}->{861301440} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861301441} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861301442} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861301443} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861301444} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861301445} = "Yichun\,\ Jiangxi";
$areanames{en}->{861301446} = "Yichun\,\ Jiangxi";
$areanames{en}->{861301447} = "Yichun\,\ Jiangxi";
$areanames{en}->{861301448} = "Yichun\,\ Jiangxi";
$areanames{en}->{861301449} = "Yichun\,\ Jiangxi";
$areanames{en}->{86130145} = "Zhengzhou\,\ Henan";
$areanames{en}->{86130146} = "Zhengzhou\,\ Henan";
$areanames{en}->{86130147} = "Luoyang\,\ Henan";
$areanames{en}->{861301480} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861301481} = "Guigang\,\ Guangxi";
$areanames{en}->{861301482} = "Guigang\,\ Guangxi";
$areanames{en}->{861301483} = "Beihai\,\ Guangxi";
$areanames{en}->{861301484} = "Beihai\,\ Guangxi";
$areanames{en}->{861301485} = "Guilin\,\ Guangxi";
$areanames{en}->{861301486} = "Guilin\,\ Guangxi";
$areanames{en}->{861301487} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861301488} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861301489} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861301490} = "Nanning\,\ Guangxi";
$areanames{en}->{861301491} = "Nanning\,\ Guangxi";
$areanames{en}->{861301492} = "Yulin\,\ Guangxi";
$areanames{en}->{861301493} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861301494} = "Hezhou\,\ Guangxi";
$areanames{en}->{861301495} = "Yulin\,\ Guangxi";
$areanames{en}->{861301496} = "Yulin\,\ Guangxi";
$areanames{en}->{861301497} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861301498} = "Nanning\,\ Guangxi";
$areanames{en}->{861301499} = "Nanning\,\ Guangxi";
$areanames{en}->{861301500} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301501} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301502} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301503} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861301504} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301505} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301506} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301507} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861301508} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861301509} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861301510} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301511} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861301512} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861301513} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861301514} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861301515} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301516} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301517} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861301518} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861301519} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861301520} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301521} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301522} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301523} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861301524} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301525} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301526} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301527} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861301528} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861301529} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861301530} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301531} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861301532} = "Linfen\,\ Shanxi";
$areanames{en}->{861301533} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861301534} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301535} = "Jincheng\,\ Shanxi";
$areanames{en}->{861301536} = "Changzhi\,\ Shanxi";
$areanames{en}->{861301537} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301538} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301539} = "Datong\,\ Shanxi";
$areanames{en}->{861301540} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301541} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861301542} = "Linfen\,\ Shanxi";
$areanames{en}->{861301543} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861301544} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301545} = "Jincheng\,\ Shanxi";
$areanames{en}->{861301546} = "Changzhi\,\ Shanxi";
$areanames{en}->{861301547} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301548} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861301549} = "Datong\,\ Shanxi";
$areanames{en}->{861301550} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301551} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301552} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301553} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301554} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301555} = "Luoyang\,\ Henan";
$areanames{en}->{861301556} = "Luoyang\,\ Henan";
$areanames{en}->{861301557} = "Luoyang\,\ Henan";
$areanames{en}->{861301558} = "Luoyang\,\ Henan";
$areanames{en}->{861301559} = "Luoyang\,\ Henan";
$areanames{en}->{86130156} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861301560} = "Longyan\,\ Fujian";
$areanames{en}->{861301568} = "Sanming\,\ Fujian";
$areanames{en}->{861301569} = "Nanping\,\ Fujian";
$areanames{en}->{86130157} = "Fuzhou\,\ Fujian";
$areanames{en}->{861301570} = "Ningde\,\ Fujian";
$areanames{en}->{861301579} = "Ningde\,\ Fujian";
$areanames{en}->{86130158} = "Quanzhou\,\ Fujian";
$areanames{en}->{861301580} = "Ningde\,\ Fujian";
$areanames{en}->{861301589} = "Ningde\,\ Fujian";
$areanames{en}->{861301590} = "Putian\,\ Fujian";
$areanames{en}->{861301591} = "Xiamen\,\ Fujian";
$areanames{en}->{861301592} = "Xiamen\,\ Fujian";
$areanames{en}->{861301593} = "Xiamen\,\ Fujian";
$areanames{en}->{861301594} = "Xiamen\,\ Fujian";
$areanames{en}->{861301595} = "Xiamen\,\ Fujian";
$areanames{en}->{861301596} = "Putian\,\ Fujian";
$areanames{en}->{861301597} = "Putian\,\ Fujian";
$areanames{en}->{861301598} = "Putian\,\ Fujian";
$areanames{en}->{861301599} = "Putian\,\ Fujian";
$areanames{en}->{86130160} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861301610} = "Chenzhou\,\ Hunan";
$areanames{en}->{861301611} = "Chenzhou\,\ Hunan";
$areanames{en}->{861301612} = "Chenzhou\,\ Hunan";
$areanames{en}->{861301613} = "Yiyang\,\ Hunan";
$areanames{en}->{861301614} = "Yiyang\,\ Hunan";
$areanames{en}->{861301615} = "Yiyang\,\ Hunan";
$areanames{en}->{861301616} = "Changsha\,\ Hunan";
$areanames{en}->{861301617} = "Xiangtan\,\ Hunan";
$areanames{en}->{861301618} = "Hengyang\,\ Hunan";
$areanames{en}->{861301619} = "Hengyang\,\ Hunan";
$areanames{en}->{86130162} = "Haikou\,\ Hainan";
$areanames{en}->{86130163} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86130164} = "Wuhan\,\ Hubei";
$areanames{en}->{86130165} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861301656} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861301657} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861301658} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861301659} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861301660} = "Foshan\,\ Guangdong";
$areanames{en}->{861301661} = "Foshan\,\ Guangdong";
$areanames{en}->{861301662} = "Foshan\,\ Guangdong";
$areanames{en}->{861301663} = "Dongguan\,\ Guangdong";
$areanames{en}->{861301664} = "Dongguan\,\ Guangdong";
$areanames{en}->{861301665} = "Shantou\,\ Guangdong";
$areanames{en}->{861301666} = "Shantou\,\ Guangdong";
$areanames{en}->{861301667} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861301668} = "Shantou\,\ Guangdong";
$areanames{en}->{861301669} = "Jieyang\,\ Guangdong";
$areanames{en}->{86130167} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861301676} = "Nantong\,\ Jiangsu";
$areanames{en}->{861301677} = "Nantong\,\ Jiangsu";
$areanames{en}->{861301678} = "Nantong\,\ Jiangsu";
$areanames{en}->{861301679} = "Nantong\,\ Jiangsu";
$areanames{en}->{86130168} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861301680} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861301681} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861301682} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861301683} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{86130169} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861301690} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861301691} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861301692} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861301700} = "Tongren\,\ Guizhou";
$areanames{en}->{861301701} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861301702} = "Qiannan\,\ Guizhou";
$areanames{en}->{861301703} = "Qiannan\,\ Guizhou";
$areanames{en}->{861301704} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861301705} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861301706} = "Bijie\,\ Guizhou";
$areanames{en}->{861301707} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861301708} = "Anshun\,\ Guizhou";
$areanames{en}->{861301709} = "Anshun\,\ Guizhou";
$areanames{en}->{861301710} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861301711} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861301712} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861301713} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861301714} = "Xiangtan\,\ Hunan";
$areanames{en}->{861301715} = "Xiangtan\,\ Hunan";
$areanames{en}->{861301716} = "Hengyang\,\ Hunan";
$areanames{en}->{861301717} = "Hengyang\,\ Hunan";
$areanames{en}->{861301718} = "Changsha\,\ Hunan";
$areanames{en}->{861301719} = "Changsha\,\ Hunan";
$areanames{en}->{861301720} = "Yueyang\,\ Hunan";
$areanames{en}->{861301721} = "Yueyang\,\ Hunan";
$areanames{en}->{861301722} = "Yueyang\,\ Hunan";
$areanames{en}->{861301723} = "Yueyang\,\ Hunan";
$areanames{en}->{861301724} = "Changde\,\ Hunan";
$areanames{en}->{861301725} = "Changde\,\ Hunan";
$areanames{en}->{861301726} = "Changde\,\ Hunan";
$areanames{en}->{861301727} = "Changde\,\ Hunan";
$areanames{en}->{861301728} = "Changsha\,\ Hunan";
$areanames{en}->{861301729} = "Changsha\,\ Hunan";
$areanames{en}->{861301730} = "Yueyang\,\ Hunan";
$areanames{en}->{861301731} = "Changsha\,\ Hunan";
$areanames{en}->{861301732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861301733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861301734} = "Hengyang\,\ Hunan";
$areanames{en}->{861301735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861301736} = "Changde\,\ Hunan";
$areanames{en}->{861301737} = "Yiyang\,\ Hunan";
$areanames{en}->{861301738} = "Changsha\,\ Hunan";
$areanames{en}->{861301739} = "Changsha\,\ Hunan";
$areanames{en}->{861301740} = "Zunyi\,\ Guizhou";
$areanames{en}->{861301741} = "Zunyi\,\ Guizhou";
$areanames{en}->{861301742} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861301743} = "Guiyang\,\ Guizhou";
$areanames{en}->{861301744} = "Anshun\,\ Guizhou";
$areanames{en}->{861301745} = "Guiyang\,\ Guizhou";
$areanames{en}->{861301746} = "Guiyang\,\ Guizhou";
$areanames{en}->{861301747} = "Guiyang\,\ Guizhou";
$areanames{en}->{861301748} = "Guiyang\,\ Guizhou";
$areanames{en}->{861301749} = "Zunyi\,\ Guizhou";
$areanames{en}->{861301750} = "Jiaozuo\,\ Henan";
$areanames{en}->{861301751} = "Jiaozuo\,\ Henan";
$areanames{en}->{861301752} = "Anyang\,\ Henan";
$areanames{en}->{861301753} = "Xinxiang\,\ Henan";
$areanames{en}->{861301754} = "Xinxiang\,\ Henan";
$areanames{en}->{861301755} = "Pingdingshan\,\ Henan";
$areanames{en}->{861301756} = "Pingdingshan\,\ Henan";
$areanames{en}->{861301757} = "Pingdingshan\,\ Henan";
$areanames{en}->{861301758} = "Kaifeng\,\ Henan";
$areanames{en}->{861301759} = "Xuchang\,\ Henan";
$areanames{en}->{861301760} = "Xinxiang\,\ Henan";
$areanames{en}->{861301761} = "Luohe\,\ Henan";
$areanames{en}->{861301762} = "Kaifeng\,\ Henan";
$areanames{en}->{861301763} = "Luoyang\,\ Henan";
$areanames{en}->{861301764} = "Luoyang\,\ Henan";
$areanames{en}->{861301765} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301766} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301767} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301768} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301769} = "Zhengzhou\,\ Henan";
$areanames{en}->{861301770} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861301771} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861301772} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861301773} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861301774} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861301775} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861301776} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861301777} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861301778} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861301779} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{86130178} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130179} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861301790} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861301791} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861301792} = "Lishui\,\ Zhejiang";
$areanames{en}->{861301793} = "Lishui\,\ Zhejiang";
$areanames{en}->{86130180} = "Wuhan\,\ Hubei";
$areanames{en}->{861301810} = "Liangshan\,\ Sichuan";
$areanames{en}->{861301811} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861301812} = "Nanchong\,\ Sichuan";
$areanames{en}->{861301813} = "Mianyang\,\ Sichuan";
$areanames{en}->{861301814} = "Mianyang\,\ Sichuan";
$areanames{en}->{861301815} = "Luzhou\,\ Sichuan";
$areanames{en}->{861301816} = "Neijiang\,\ Sichuan";
$areanames{en}->{861301817} = "Yibin\,\ Sichuan";
$areanames{en}->{861301818} = "Zigong\,\ Sichuan";
$areanames{en}->{861301819} = "Deyang\,\ Sichuan";
$areanames{en}->{86130182} = "Chengdu\,\ Sichuan";
$areanames{en}->{86130183} = "Chongqing";
$areanames{en}->{86130184} = "Huizhou\,\ Guangdong";
$areanames{en}->{861301847} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861301848} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861301849} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86130185} = "Foshan\,\ Guangdong";
$areanames{en}->{861301850} = "Maoming\,\ Guangdong";
$areanames{en}->{861301851} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861301858} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861301859} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86130186} = "Dongguan\,\ Guangdong";
$areanames{en}->{861301870} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861301871} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861301872} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861301873} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861301874} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861301875} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861301876} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861301877} = "Meizhou\,\ Guangdong";
$areanames{en}->{861301878} = "Meizhou\,\ Guangdong";
$areanames{en}->{861301879} = "Heyuan\,\ Guangdong";
$areanames{en}->{86130188} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861301880} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861301881} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{86130189} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861301900} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861301901} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861301902} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861301903} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861301904} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861301905} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861301906} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861301907} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861301908} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861301909} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861301910} = "Changchun\,\ Jilin";
$areanames{en}->{861301911} = "Changchun\,\ Jilin";
$areanames{en}->{861301912} = "Changchun\,\ Jilin";
$areanames{en}->{861301913} = "Changchun\,\ Jilin";
$areanames{en}->{861301914} = "Songyuan\,\ Jilin";
$areanames{en}->{861301915} = "Jilin\,\ Jilin";
$areanames{en}->{861301916} = "Jilin\,\ Jilin";
$areanames{en}->{861301917} = "Jilin\,\ Jilin";
$areanames{en}->{861301918} = "Yanbian\,\ Jilin";
$areanames{en}->{861301919} = "Tonghua\,\ Jilin";
$areanames{en}->{861301920} = "Changchun\,\ Jilin";
$areanames{en}->{861301921} = "Changchun\,\ Jilin";
$areanames{en}->{861301922} = "Changchun\,\ Jilin";
$areanames{en}->{861301923} = "Yanbian\,\ Jilin";
$areanames{en}->{861301924} = "Jilin\,\ Jilin";
$areanames{en}->{861301925} = "Jilin\,\ Jilin";
$areanames{en}->{861301926} = "Jilin\,\ Jilin";
$areanames{en}->{861301927} = "Jilin\,\ Jilin";
$areanames{en}->{861301928} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861301929} = "Liaoyuan\,\ Jilin";
$areanames{en}->{86130193} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130194} = "Dalian\,\ Liaoning";
$areanames{en}->{861301950} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861301951} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861301952} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861301953} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861301954} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861301955} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301956} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861301957} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861301958} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861301959} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861301960} = "Anshan\,\ Liaoning";
$areanames{en}->{861301961} = "Anshan\,\ Liaoning";
$areanames{en}->{861301962} = "Anshan\,\ Liaoning";
$areanames{en}->{861301963} = "Anshan\,\ Liaoning";
$areanames{en}->{861301964} = "Anshan\,\ Liaoning";
$areanames{en}->{861301965} = "Fushun\,\ Liaoning";
$areanames{en}->{861301966} = "Fushun\,\ Liaoning";
$areanames{en}->{861301967} = "Benxi\,\ Liaoning";
$areanames{en}->{861301968} = "Benxi\,\ Liaoning";
$areanames{en}->{861301969} = "Dandong\,\ Liaoning";
$areanames{en}->{861301970} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861301971} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861301972} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861301973} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861301974} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861301975} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861301976} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861301977} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861301978} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861301979} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861301980} = "Dandong\,\ Liaoning";
$areanames{en}->{861301981} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861301982} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861301983} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861301984} = "Yingkou\,\ Liaoning";
$areanames{en}->{861301985} = "Yingkou\,\ Liaoning";
$areanames{en}->{861301986} = "Fuxin\,\ Liaoning";
$areanames{en}->{861301987} = "Fuxin\,\ Liaoning";
$areanames{en}->{861301988} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861301989} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861301990} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861301991} = "Tieling\,\ Liaoning";
$areanames{en}->{861301992} = "Tieling\,\ Liaoning";
$areanames{en}->{861301993} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861301994} = "Panjin\,\ Liaoning";
$areanames{en}->{861301995} = "Panjin\,\ Liaoning";
$areanames{en}->{861301996} = "Panjin\,\ Liaoning";
$areanames{en}->{861301997} = "Huludao\,\ Liaoning";
$areanames{en}->{861301998} = "Huludao\,\ Liaoning";
$areanames{en}->{861301999} = "Huludao\,\ Liaoning";
$areanames{en}->{86130200} = "Beijing";
$areanames{en}->{86130201} = "Shanghai";
$areanames{en}->{86130202} = "Shanghai";
$areanames{en}->{861302030} = "Shenyang\,\ Liaoning";
$areanames{en}->{861302031} = "Shenyang\,\ Liaoning";
$areanames{en}->{861302032} = "Shenyang\,\ Liaoning";
$areanames{en}->{861302033} = "Anshan\,\ Liaoning";
$areanames{en}->{861302034} = "Fushun\,\ Liaoning";
$areanames{en}->{861302035} = "Dandong\,\ Liaoning";
$areanames{en}->{861302036} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861302037} = "Yingkou\,\ Liaoning";
$areanames{en}->{861302038} = "Fuxin\,\ Liaoning";
$areanames{en}->{861302039} = "Tieling\,\ Liaoning";
$areanames{en}->{861302040} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861302041} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861302042} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861302043} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861302044} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861302045} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861302046} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861302047} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861302048} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861302049} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861302050} = "Jining\,\ Shandong";
$areanames{en}->{861302051} = "Heze\,\ Shandong";
$areanames{en}->{861302052} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861302053} = "Rizhao\,\ Shandong";
$areanames{en}->{861302054} = "Binzhou\,\ Shandong";
$areanames{en}->{861302055} = "Liaocheng\,\ Shandong";
$areanames{en}->{861302056} = "Dezhou\,\ Shandong";
$areanames{en}->{861302057} = "Liaocheng\,\ Shandong";
$areanames{en}->{861302058} = "Liaocheng\,\ Shandong";
$areanames{en}->{861302059} = "Liaocheng\,\ Shandong";
$areanames{en}->{861302060} = "Dongying\,\ Shandong";
$areanames{en}->{861302061} = "Dezhou\,\ Shandong";
$areanames{en}->{861302062} = "Binzhou\,\ Shandong";
$areanames{en}->{861302063} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861302064} = "Heze\,\ Shandong";
$areanames{en}->{861302065} = "Linyi\,\ Shandong";
$areanames{en}->{861302066} = "Linyi\,\ Shandong";
$areanames{en}->{861302067} = "Jining\,\ Shandong";
$areanames{en}->{861302068} = "Jining\,\ Shandong";
$areanames{en}->{861302069} = "Jining\,\ Shandong";
$areanames{en}->{86130207} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861302080} = "Baoding\,\ Hebei";
$areanames{en}->{861302081} = "Baoding\,\ Hebei";
$areanames{en}->{861302082} = "Baoding\,\ Hebei";
$areanames{en}->{861302083} = "Handan\,\ Hebei";
$areanames{en}->{861302084} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861302085} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861302086} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861302087} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861302088} = "Tangshan\,\ Hebei";
$areanames{en}->{861302089} = "Chengde\,\ Hebei";
$areanames{en}->{861302090} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302091} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302092} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302093} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302094} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302095} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861302096} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861302097} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861302098} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861302099} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{86130210} = "Beijing";
$areanames{en}->{86130211} = "Beijing";
$areanames{en}->{86130212} = "Beijing";
$areanames{en}->{86130213} = "Tianjin";
$areanames{en}->{861302140} = "Baoding\,\ Hebei";
$areanames{en}->{861302141} = "Tangshan\,\ Hebei";
$areanames{en}->{861302142} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861302143} = "Langfang\,\ Hebei";
$areanames{en}->{861302144} = "Cangzhou\,\ Hebei";
$areanames{en}->{861302145} = "Xingtai\,\ Hebei";
$areanames{en}->{861302146} = "Handan\,\ Hebei";
$areanames{en}->{861302147} = "Hengshui\,\ Hebei";
$areanames{en}->{861302148} = "Cangzhou\,\ Hebei";
$areanames{en}->{861302149} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861302150} = "Zibo\,\ Shandong";
$areanames{en}->{861302151} = "Zibo\,\ Shandong";
$areanames{en}->{861302152} = "Binzhou\,\ Shandong";
$areanames{en}->{861302153} = "Weifang\,\ Shandong";
$areanames{en}->{861302154} = "Weifang\,\ Shandong";
$areanames{en}->{861302155} = "Weifang\,\ Shandong";
$areanames{en}->{861302156} = "Dongying\,\ Shandong";
$areanames{en}->{861302157} = "Linyi\,\ Shandong";
$areanames{en}->{861302158} = "Rizhao\,\ Shandong";
$areanames{en}->{861302159} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861302160} = "Yantai\,\ Shandong";
$areanames{en}->{861302161} = "Yantai\,\ Shandong";
$areanames{en}->{861302162} = "Yantai\,\ Shandong";
$areanames{en}->{861302163} = "Weihai\,\ Shandong";
$areanames{en}->{861302164} = "Weihai\,\ Shandong";
$areanames{en}->{861302165} = "Weihai\,\ Shandong";
$areanames{en}->{861302166} = "Qingdao\,\ Shandong";
$areanames{en}->{861302167} = "Qingdao\,\ Shandong";
$areanames{en}->{861302168} = "Qingdao\,\ Shandong";
$areanames{en}->{861302169} = "Qingdao\,\ Shandong";
$areanames{en}->{861302170} = "Jinan\,\ Shandong";
$areanames{en}->{861302171} = "Jinan\,\ Shandong";
$areanames{en}->{861302172} = "Jinan\,\ Shandong";
$areanames{en}->{861302173} = "Jinan\,\ Shandong";
$areanames{en}->{861302174} = "Jinan\,\ Shandong";
$areanames{en}->{861302175} = "Liaocheng\,\ Shandong";
$areanames{en}->{861302176} = "Dezhou\,\ Shandong";
$areanames{en}->{861302177} = "TaiAn\,\ Shandong";
$areanames{en}->{861302178} = "Jining\,\ Shandong";
$areanames{en}->{861302179} = "Heze\,\ Shandong";
$areanames{en}->{861302180} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861302181} = "Tangshan\,\ Hebei";
$areanames{en}->{861302182} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861302183} = "Langfang\,\ Hebei";
$areanames{en}->{861302184} = "Tangshan\,\ Hebei";
$areanames{en}->{861302185} = "Xingtai\,\ Hebei";
$areanames{en}->{861302186} = "Handan\,\ Hebei";
$areanames{en}->{861302187} = "Baoding\,\ Hebei";
$areanames{en}->{861302188} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861302189} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86130219} = "Beijing";
$areanames{en}->{86130220} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130221} = "Shanghai";
$areanames{en}->{86130222} = "Tianjin";
$areanames{en}->{86130223} = "Chongqing";
$areanames{en}->{86130224} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130225} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861302260} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861302261} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861302262} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861302263} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861302264} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861302265} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861302266} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861302267} = "Lishui\,\ Zhejiang";
$areanames{en}->{861302268} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302269} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302270} = "Zibo\,\ Shandong";
$areanames{en}->{861302271} = "Zibo\,\ Shandong";
$areanames{en}->{861302272} = "Yantai\,\ Shandong";
$areanames{en}->{861302273} = "Yantai\,\ Shandong";
$areanames{en}->{861302274} = "Yantai\,\ Shandong";
$areanames{en}->{861302275} = "Yantai\,\ Shandong";
$areanames{en}->{861302276} = "Laiwu\,\ Shandong";
$areanames{en}->{861302277} = "TaiAn\,\ Shandong";
$areanames{en}->{861302278} = "Weifang\,\ Shandong";
$areanames{en}->{861302279} = "Linyi\,\ Shandong";
$areanames{en}->{86130228} = "XiAn\,\ Shaanxi";
$areanames{en}->{86130229} = "XiAn\,\ Shaanxi";
$areanames{en}->{861302300} = "Hefei\,\ Anhui";
$areanames{en}->{861302301} = "Bengbu\,\ Anhui";
$areanames{en}->{861302302} = "Bengbu\,\ Anhui";
$areanames{en}->{861302303} = "Wuhu\,\ Anhui";
$areanames{en}->{861302304} = "Wuhu\,\ Anhui";
$areanames{en}->{861302305} = "Hefei\,\ Anhui";
$areanames{en}->{861302306} = "Hefei\,\ Anhui";
$areanames{en}->{861302307} = "Huainan\,\ Anhui";
$areanames{en}->{861302308} = "Hefei\,\ Anhui";
$areanames{en}->{861302309} = "Hefei\,\ Anhui";
$areanames{en}->{86130231} = "Shanghai";
$areanames{en}->{86130232} = "Shanghai";
$areanames{en}->{86130233} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861302334} = "Xiangtan\,\ Hunan";
$areanames{en}->{861302340} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861302341} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861302342} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861302343} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861302344} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861302345} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861302346} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861302347} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861302348} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861302349} = "Suqian\,\ Jiangsu";
$areanames{en}->{86130235} = "Nantong\,\ Jiangsu";
$areanames{en}->{861302350} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861302351} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861302352} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861302354} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{86130236} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130237} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130238} = "Fuzhou\,\ Fujian";
$areanames{en}->{861302385} = "Putian\,\ Fujian";
$areanames{en}->{861302386} = "Putian\,\ Fujian";
$areanames{en}->{86130239} = "Xiamen\,\ Fujian";
$areanames{en}->{861302395} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861302396} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861302400} = "Huainan\,\ Anhui";
$areanames{en}->{861302401} = "Fuyang\,\ Anhui";
$areanames{en}->{861302402} = "Bozhou\,\ Anhui";
$areanames{en}->{861302403} = "Fuyang\,\ Anhui";
$areanames{en}->{861302404} = "Wuhu\,\ Anhui";
$areanames{en}->{861302405} = "Wuhu\,\ Anhui";
$areanames{en}->{861302406} = "Wuhu\,\ Anhui";
$areanames{en}->{861302407} = "Bengbu\,\ Anhui";
$areanames{en}->{861302408} = "Bengbu\,\ Anhui";
$areanames{en}->{861302409} = "Bengbu\,\ Anhui";
$areanames{en}->{86130241} = "Shanghai";
$areanames{en}->{861302420} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861302421} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861302422} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861302423} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861302424} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861302425} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861302426} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861302427} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861302428} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861302429} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130243} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861302435} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861302436} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861302437} = "Shaoyang\,\ Hunan";
$areanames{en}->{861302438} = "Shaoyang\,\ Hunan";
$areanames{en}->{861302440} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861302441} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861302442} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861302443} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861302444} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861302445} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861302446} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861302447} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861302448} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861302449} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86130245} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861302460} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861302461} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861302462} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861302463} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861302464} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861302465} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861302466} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861302467} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861302468} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861302469} = "Lishui\,\ Zhejiang";
$areanames{en}->{86130247} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302476} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861302477} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861302478} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861302479} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86130248} = "Quanzhou\,\ Fujian";
$areanames{en}->{861302490} = "Sanming\,\ Fujian";
$areanames{en}->{861302491} = "Ningde\,\ Fujian";
$areanames{en}->{861302492} = "Ningde\,\ Fujian";
$areanames{en}->{861302493} = "Ningde\,\ Fujian";
$areanames{en}->{861302494} = "Nanping\,\ Fujian";
$areanames{en}->{861302495} = "Nanping\,\ Fujian";
$areanames{en}->{861302496} = "Nanping\,\ Fujian";
$areanames{en}->{861302497} = "Longyan\,\ Fujian";
$areanames{en}->{861302498} = "Longyan\,\ Fujian";
$areanames{en}->{861302499} = "Sanming\,\ Fujian";
$areanames{en}->{86130250} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130251} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861302520} = "Shantou\,\ Guangdong";
$areanames{en}->{861302521} = "Shantou\,\ Guangdong";
$areanames{en}->{861302522} = "Shantou\,\ Guangdong";
$areanames{en}->{861302523} = "Shantou\,\ Guangdong";
$areanames{en}->{861302524} = "Shantou\,\ Guangdong";
$areanames{en}->{861302525} = "Shanwei\,\ Guangdong";
$areanames{en}->{861302526} = "Jieyang\,\ Guangdong";
$areanames{en}->{861302527} = "Jieyang\,\ Guangdong";
$areanames{en}->{861302528} = "Meizhou\,\ Guangdong";
$areanames{en}->{861302529} = "Meizhou\,\ Guangdong";
$areanames{en}->{861302530} = "Heyuan\,\ Guangdong";
$areanames{en}->{861302531} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861302532} = "Shantou\,\ Guangdong";
$areanames{en}->{861302533} = "Shantou\,\ Guangdong";
$areanames{en}->{861302534} = "Shantou\,\ Guangdong";
$areanames{en}->{861302535} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861302536} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861302537} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861302538} = "Yunfu\,\ Guangdong";
$areanames{en}->{861302539} = "Yunfu\,\ Guangdong";
$areanames{en}->{86130254} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130255} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861302556} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861302557} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861302558} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861302559} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861302560} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861302561} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861302562} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861302563} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861302564} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861302565} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861302566} = "Maoming\,\ Guangdong";
$areanames{en}->{861302567} = "Maoming\,\ Guangdong";
$areanames{en}->{861302568} = "Maoming\,\ Guangdong";
$areanames{en}->{861302569} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86130257} = "Huizhou\,\ Guangdong";
$areanames{en}->{861302576} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861302577} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861302578} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861302579} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86130258} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861302590} = "Nanning\,\ Guangxi";
$areanames{en}->{861302591} = "Nanning\,\ Guangxi";
$areanames{en}->{861302592} = "Nanning\,\ Guangxi";
$areanames{en}->{861302593} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861302594} = "Guilin\,\ Guangxi";
$areanames{en}->{861302595} = "Guilin\,\ Guangxi";
$areanames{en}->{861302596} = "Yulin\,\ Guangxi";
$areanames{en}->{861302597} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861302598} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861302599} = "Beihai\,\ Guangxi";
$areanames{en}->{861302600} = "Anqing\,\ Anhui";
$areanames{en}->{861302601} = "Anqing\,\ Anhui";
$areanames{en}->{861302602} = "Chuzhou\,\ Anhui";
$areanames{en}->{861302603} = "Chuzhou\,\ Anhui";
$areanames{en}->{861302604} = "Huaibei\,\ Anhui";
$areanames{en}->{861302605} = "Huaibei\,\ Anhui";
$areanames{en}->{861302606} = "LuAn\,\ Anhui";
$areanames{en}->{861302607} = "Xuancheng\,\ Anhui";
$areanames{en}->{861302608} = "MaAnshan\,\ Anhui";
$areanames{en}->{861302609} = "Suzhou\,\ Anhui";
$areanames{en}->{86130261} = "Wuhan\,\ Hubei";
$areanames{en}->{861302620} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861302621} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861302622} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861302623} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861302624} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861302625} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861302626} = "Yichun\,\ Jiangxi";
$areanames{en}->{861302627} = "Yichun\,\ Jiangxi";
$areanames{en}->{861302628} = "Yichun\,\ Jiangxi";
$areanames{en}->{861302629} = "Yichun\,\ Jiangxi";
$areanames{en}->{86130263} = "Wuhan\,\ Hubei";
$areanames{en}->{861302640} = "Yulin\,\ Shaanxi";
$areanames{en}->{861302641} = "Weinan\,\ Shaanxi";
$areanames{en}->{861302642} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861302643} = "YanAn\,\ Shaanxi";
$areanames{en}->{861302644} = "Baoji\,\ Shaanxi";
$areanames{en}->{861302645} = "Deyang\,\ Sichuan";
$areanames{en}->{861302646} = "Weinan\,\ Shaanxi";
$areanames{en}->{861302647} = "YanAn\,\ Shaanxi";
$areanames{en}->{861302648} = "Mianyang\,\ Sichuan";
$areanames{en}->{861302649} = "Mianyang\,\ Sichuan";
$areanames{en}->{861302650} = "Qingdao\,\ Shandong";
$areanames{en}->{861302651} = "Qingdao\,\ Shandong";
$areanames{en}->{861302652} = "Qingdao\,\ Shandong";
$areanames{en}->{861302653} = "Qingdao\,\ Shandong";
$areanames{en}->{861302654} = "Dongying\,\ Shandong";
$areanames{en}->{861302655} = "Weifang\,\ Shandong";
$areanames{en}->{861302656} = "Weifang\,\ Shandong";
$areanames{en}->{861302657} = "Jinan\,\ Shandong";
$areanames{en}->{861302658} = "Jinan\,\ Shandong";
$areanames{en}->{861302659} = "Jinan\,\ Shandong";
$areanames{en}->{86130266} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130267} = "Foshan\,\ Guangdong";
$areanames{en}->{86130268} = "Dongguan\,\ Guangdong";
$areanames{en}->{861302686} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861302687} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861302688} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861302689} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861302690} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861302691} = "Nanning\,\ Guangxi";
$areanames{en}->{861302692} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861302693} = "Guilin\,\ Guangxi";
$areanames{en}->{861302694} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861302695} = "Yulin\,\ Guangxi";
$areanames{en}->{861302696} = "Baise\,\ Guangxi";
$areanames{en}->{861302697} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861302698} = "Hechi\,\ Guangxi";
$areanames{en}->{861302699} = "Beihai\,\ Guangxi";
$areanames{en}->{86130270} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861302705} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861302706} = "Jinzhong\,\ Shanxi";
$areanames{en}->{86130271} = "Wuhan\,\ Hubei";
$areanames{en}->{86130272} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861302725} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861302726} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861302727} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861302729} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861302730} = "Yueyang\,\ Hunan";
$areanames{en}->{861302731} = "Changsha\,\ Hunan";
$areanames{en}->{861302732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861302733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861302734} = "Hengyang\,\ Hunan";
$areanames{en}->{861302735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861302736} = "Changde\,\ Hunan";
$areanames{en}->{861302737} = "Yiyang\,\ Hunan";
$areanames{en}->{861302738} = "Loudi\,\ Hunan";
$areanames{en}->{861302739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861302740} = "Changde\,\ Hunan";
$areanames{en}->{861302741} = "Changsha\,\ Hunan";
$areanames{en}->{861302742} = "Changsha\,\ Hunan";
$areanames{en}->{861302743} = "Changsha\,\ Hunan";
$areanames{en}->{861302744} = "Xiangtan\,\ Hunan";
$areanames{en}->{861302745} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861302746} = "Hengyang\,\ Hunan";
$areanames{en}->{861302747} = "Yueyang\,\ Hunan";
$areanames{en}->{861302748} = "Changsha\,\ Hunan";
$areanames{en}->{861302749} = "Changsha\,\ Hunan";
$areanames{en}->{861302750} = "Zhengzhou\,\ Henan";
$areanames{en}->{861302751} = "Zhengzhou\,\ Henan";
$areanames{en}->{861302752} = "Zhengzhou\,\ Henan";
$areanames{en}->{861302753} = "Luoyang\,\ Henan";
$areanames{en}->{861302754} = "Luoyang\,\ Henan";
$areanames{en}->{861302755} = "Xinxiang\,\ Henan";
$areanames{en}->{861302756} = "Pingdingshan\,\ Henan";
$areanames{en}->{861302757} = "Pingdingshan\,\ Henan";
$areanames{en}->{861302758} = "Jiaozuo\,\ Henan";
$areanames{en}->{861302759} = "Anyang\,\ Henan";
$areanames{en}->{861302760} = "Zhengzhou\,\ Henan";
$areanames{en}->{861302761} = "Zhengzhou\,\ Henan";
$areanames{en}->{861302762} = "Zhengzhou\,\ Henan";
$areanames{en}->{861302763} = "Luoyang\,\ Henan";
$areanames{en}->{861302764} = "Kaifeng\,\ Henan";
$areanames{en}->{861302765} = "Jiaozuo\,\ Henan";
$areanames{en}->{861302766} = "Xinxiang\,\ Henan";
$areanames{en}->{861302767} = "Xuchang\,\ Henan";
$areanames{en}->{861302768} = "Luohe\,\ Henan";
$areanames{en}->{861302769} = "Anyang\,\ Henan";
$areanames{en}->{86130277} = "Zhengzhou\,\ Henan";
$areanames{en}->{86130278} = "Guiyang\,\ Guizhou";
$areanames{en}->{861302787} = "Zunyi\,\ Guizhou";
$areanames{en}->{861302789} = "Anshun\,\ Guizhou";
$areanames{en}->{86130279} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861302800} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861302801} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861302802} = "Linfen\,\ Shanxi";
$areanames{en}->{861302803} = "Linfen\,\ Shanxi";
$areanames{en}->{861302804} = "Datong\,\ Shanxi";
$areanames{en}->{861302805} = "Jincheng\,\ Shanxi";
$areanames{en}->{861302806} = "Changzhi\,\ Shanxi";
$areanames{en}->{861302807} = "Changzhi\,\ Shanxi";
$areanames{en}->{861302808} = "Datong\,\ Shanxi";
$areanames{en}->{861302809} = "Datong\,\ Shanxi";
$areanames{en}->{86130281} = "Chengdu\,\ Sichuan";
$areanames{en}->{861302820} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861302821} = "Fuxin\,\ Liaoning";
$areanames{en}->{861302822} = "Panjin\,\ Liaoning";
$areanames{en}->{861302823} = "Panjin\,\ Liaoning";
$areanames{en}->{861302824} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861302825} = "Panjin\,\ Liaoning";
$areanames{en}->{861302826} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861302827} = "Tieling\,\ Liaoning";
$areanames{en}->{861302828} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861302829} = "Fuxin\,\ Liaoning";
$areanames{en}->{86130283} = "Chongqing";
$areanames{en}->{861302840} = "XiAn\,\ Shaanxi";
$areanames{en}->{861302841} = "XiAn\,\ Shaanxi";
$areanames{en}->{861302842} = "XiAn\,\ Shaanxi";
$areanames{en}->{861302843} = "Weinan\,\ Shaanxi";
$areanames{en}->{861302844} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861302845} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861302846} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861302847} = "Baoji\,\ Shaanxi";
$areanames{en}->{861302848} = "Baoji\,\ Shaanxi";
$areanames{en}->{861302849} = "Baoji\,\ Shaanxi";
$areanames{en}->{861302850} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861302851} = "XiAn\,\ Shaanxi";
$areanames{en}->{861302852} = "Weinan\,\ Shaanxi";
$areanames{en}->{861302853} = "Weinan\,\ Shaanxi";
$areanames{en}->{861302854} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861302855} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861302856} = "XiAn\,\ Shaanxi";
$areanames{en}->{861302857} = "YanAn\,\ Shaanxi";
$areanames{en}->{861302858} = "YanAn\,\ Shaanxi";
$areanames{en}->{861302859} = "XiAn\,\ Shaanxi";
$areanames{en}->{86130286} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861302870} = "Lanzhou\,\ Gansu";
$areanames{en}->{861302871} = "Lanzhou\,\ Gansu";
$areanames{en}->{861302872} = "Baiyin\,\ Gansu";
$areanames{en}->{861302873} = "Baiyin\,\ Gansu";
$areanames{en}->{861302874} = "Baiyin\,\ Gansu";
$areanames{en}->{861302875} = "Jiuquan\,\ Gansu";
$areanames{en}->{861302876} = "Dingxi\,\ Gansu";
$areanames{en}->{861302877} = "Linxia\,\ Gansu";
$areanames{en}->{861302878} = "Linxia\,\ Gansu";
$areanames{en}->{861302879} = "Lanzhou\,\ Gansu";
$areanames{en}->{86130288} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130289} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861302900} = "Changchun\,\ Jilin";
$areanames{en}->{861302901} = "Changchun\,\ Jilin";
$areanames{en}->{861302902} = "Siping\,\ Jilin";
$areanames{en}->{861302903} = "Siping\,\ Jilin";
$areanames{en}->{861302904} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861302905} = "Songyuan\,\ Jilin";
$areanames{en}->{861302906} = "Baicheng\,\ Jilin";
$areanames{en}->{861302907} = "Baishan\,\ Jilin";
$areanames{en}->{861302908} = "Yanbian\,\ Jilin";
$areanames{en}->{861302909} = "Yanbian\,\ Jilin";
$areanames{en}->{861302910} = "Changchun\,\ Jilin";
$areanames{en}->{861302911} = "Changchun\,\ Jilin";
$areanames{en}->{861302912} = "Changchun\,\ Jilin";
$areanames{en}->{861302913} = "Changchun\,\ Jilin";
$areanames{en}->{861302914} = "Changchun\,\ Jilin";
$areanames{en}->{861302915} = "Jilin\,\ Jilin";
$areanames{en}->{861302916} = "Jilin\,\ Jilin";
$areanames{en}->{861302917} = "Jilin\,\ Jilin";
$areanames{en}->{861302918} = "Jilin\,\ Jilin";
$areanames{en}->{861302919} = "Tonghua\,\ Jilin";
$areanames{en}->{861302920} = "Dandong\,\ Liaoning";
$areanames{en}->{861302921} = "Dandong\,\ Liaoning";
$areanames{en}->{861302922} = "Benxi\,\ Liaoning";
$areanames{en}->{861302923} = "Benxi\,\ Liaoning";
$areanames{en}->{861302924} = "Fushun\,\ Liaoning";
$areanames{en}->{861302925} = "Fushun\,\ Liaoning";
$areanames{en}->{861302926} = "Fushun\,\ Liaoning";
$areanames{en}->{861302927} = "Tieling\,\ Liaoning";
$areanames{en}->{861302928} = "Huludao\,\ Liaoning";
$areanames{en}->{861302929} = "Huludao\,\ Liaoning";
$areanames{en}->{861302930} = "Yingkou\,\ Liaoning";
$areanames{en}->{861302931} = "Yingkou\,\ Liaoning";
$areanames{en}->{861302932} = "Yingkou\,\ Liaoning";
$areanames{en}->{861302933} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861302934} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861302935} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861302936} = "Anshan\,\ Liaoning";
$areanames{en}->{861302937} = "Anshan\,\ Liaoning";
$areanames{en}->{861302938} = "Anshan\,\ Liaoning";
$areanames{en}->{861302939} = "Anshan\,\ Liaoning";
$areanames{en}->{86130294} = "Dalian\,\ Liaoning";
$areanames{en}->{861302950} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861302951} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861302952} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861302953} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861302954} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861302955} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861302956} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861302957} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861302958} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861302959} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861302960} = "Changji\,\ Xinjiang";
$areanames{en}->{861302961} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861302962} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861302963} = "Kashi\,\ Xinjiang";
$areanames{en}->{861302964} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861302965} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861302966} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861302967} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861302968} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302969} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861302970} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302971} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302972} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302973} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861302974} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861302975} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861302976} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861302977} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861302978} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861302979} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861302980} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302981} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861302982} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861302983} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861302984} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302985} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302986} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302987} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861302988} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861302989} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861302990} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861302991} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861302992} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861302993} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861302994} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861302995} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861302996} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861302997} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861302998} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861302999} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130300} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861303010} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861303011} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861303012} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861303013} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861303014} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861303015} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861303016} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861303017} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861303018} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861303019} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86130302} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861303027} = "Yunfu\,\ Guangdong";
$areanames{en}->{861303028} = "Yunfu\,\ Guangdong";
$areanames{en}->{861303029} = "Yunfu\,\ Guangdong";
$areanames{en}->{861303030} = "Puyang\,\ Henan";
$areanames{en}->{861303031} = "Puyang\,\ Henan";
$areanames{en}->{861303032} = "Puyang\,\ Henan";
$areanames{en}->{861303033} = "Puyang\,\ Henan";
$areanames{en}->{861303034} = "Sanmenxia\,\ Henan";
$areanames{en}->{861303035} = "Sanmenxia\,\ Henan";
$areanames{en}->{861303036} = "Sanmenxia\,\ Henan";
$areanames{en}->{861303037} = "Sanmenxia\,\ Henan";
$areanames{en}->{861303038} = "Sanmenxia\,\ Henan";
$areanames{en}->{861303039} = "Hebi\,\ Henan";
$areanames{en}->{861303040} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861303041} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861303042} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861303043} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861303044} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861303045} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861303046} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303047} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303048} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303049} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303050} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861303051} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861303052} = "JiAn\,\ Jiangxi";
$areanames{en}->{861303053} = "JiAn\,\ Jiangxi";
$areanames{en}->{861303054} = "JiAn\,\ Jiangxi";
$areanames{en}->{861303055} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861303056} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861303057} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861303058} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861303059} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861303060} = "Huaibei\,\ Anhui";
$areanames{en}->{861303061} = "Huaibei\,\ Anhui";
$areanames{en}->{861303062} = "Chizhou\,\ Anhui";
$areanames{en}->{861303063} = "Chuzhou\,\ Anhui";
$areanames{en}->{861303064} = "Bozhou\,\ Anhui";
$areanames{en}->{861303065} = "Bozhou\,\ Anhui";
$areanames{en}->{861303066} = "Fuyang\,\ Anhui";
$areanames{en}->{861303067} = "Fuyang\,\ Anhui";
$areanames{en}->{861303068} = "Fuyang\,\ Anhui";
$areanames{en}->{861303069} = "Bozhou\,\ Anhui";
$areanames{en}->{861303070} = "Fushun\,\ Liaoning";
$areanames{en}->{861303071} = "Fushun\,\ Liaoning";
$areanames{en}->{861303072} = "Benxi\,\ Liaoning";
$areanames{en}->{861303073} = "Benxi\,\ Liaoning";
$areanames{en}->{861303074} = "Dandong\,\ Liaoning";
$areanames{en}->{861303075} = "Dandong\,\ Liaoning";
$areanames{en}->{861303076} = "Panjin\,\ Liaoning";
$areanames{en}->{861303077} = "Panjin\,\ Liaoning";
$areanames{en}->{861303078} = "Tieling\,\ Liaoning";
$areanames{en}->{861303079} = "Tieling\,\ Liaoning";
$areanames{en}->{861303080} = "Sanming\,\ Fujian";
$areanames{en}->{861303081} = "Putian\,\ Fujian";
$areanames{en}->{861303082} = "Putian\,\ Fujian";
$areanames{en}->{861303083} = "Putian\,\ Fujian";
$areanames{en}->{861303084} = "Xiamen\,\ Fujian";
$areanames{en}->{861303085} = "Putian\,\ Fujian";
$areanames{en}->{861303086} = "Putian\,\ Fujian";
$areanames{en}->{861303087} = "Xiamen\,\ Fujian";
$areanames{en}->{861303088} = "Xiamen\,\ Fujian";
$areanames{en}->{861303089} = "Xiamen\,\ Fujian";
$areanames{en}->{86130309} = "Ningde\,\ Fujian";
$areanames{en}->{861303094} = "Quanzhou\,\ Fujian";
$areanames{en}->{861303097} = "Quanzhou\,\ Fujian";
$areanames{en}->{861303098} = "Quanzhou\,\ Fujian";
$areanames{en}->{861303099} = "Quanzhou\,\ Fujian";
$areanames{en}->{86130310} = "Beijing";
$areanames{en}->{86130311} = "Beijing";
$areanames{en}->{861303120} = "Turpan\,\ Xinjiang";
$areanames{en}->{861303121} = "Hami\,\ Xinjiang";
$areanames{en}->{861303122} = "Hami\,\ Xinjiang";
$areanames{en}->{861303123} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861303124} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861303125} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861303126} = "Aksu\,\ Xinjiang";
$areanames{en}->{861303127} = "Aksu\,\ Xinjiang";
$areanames{en}->{861303128} = "Kashi\,\ Xinjiang";
$areanames{en}->{861303129} = "Kashi\,\ Xinjiang";
$areanames{en}->{861303130} = "Ili\,\ Xinjiang";
$areanames{en}->{861303131} = "Ili\,\ Xinjiang";
$areanames{en}->{861303132} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861303133} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861303134} = "Bortala\,\ Xinjiang";
$areanames{en}->{861303135} = "Bortala\,\ Xinjiang";
$areanames{en}->{861303136} = "Ili\,\ Xinjiang";
$areanames{en}->{861303137} = "Ili\,\ Xinjiang";
$areanames{en}->{861303138} = "Karamay\,\ Xinjiang";
$areanames{en}->{861303139} = "Karamay\,\ Xinjiang";
$areanames{en}->{861303140} = "Chengde\,\ Hebei";
$areanames{en}->{861303141} = "Chengde\,\ Hebei";
$areanames{en}->{861303142} = "Chengde\,\ Hebei";
$areanames{en}->{861303143} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861303144} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861303145} = "Handan\,\ Hebei";
$areanames{en}->{861303146} = "Handan\,\ Hebei";
$areanames{en}->{861303147} = "Handan\,\ Hebei";
$areanames{en}->{861303148} = "Langfang\,\ Hebei";
$areanames{en}->{861303149} = "Langfang\,\ Hebei";
$areanames{en}->{86130315} = "Tangshan\,\ Hebei";
$areanames{en}->{861303159} = "Cangzhou\,\ Hebei";
$areanames{en}->{86130316} = "Yantai\,\ Shandong";
$areanames{en}->{861303166} = "Weifang\,\ Shandong";
$areanames{en}->{861303167} = "Weifang\,\ Shandong";
$areanames{en}->{861303168} = "Weifang\,\ Shandong";
$areanames{en}->{861303169} = "Weifang\,\ Shandong";
$areanames{en}->{861303170} = "Jinan\,\ Shandong";
$areanames{en}->{861303171} = "Jinan\,\ Shandong";
$areanames{en}->{861303172} = "Jinan\,\ Shandong";
$areanames{en}->{861303173} = "Jinan\,\ Shandong";
$areanames{en}->{861303174} = "Jinan\,\ Shandong";
$areanames{en}->{861303175} = "Laiwu\,\ Shandong";
$areanames{en}->{861303176} = "Laiwu\,\ Shandong";
$areanames{en}->{861303177} = "Zibo\,\ Shandong";
$areanames{en}->{861303178} = "Zibo\,\ Shandong";
$areanames{en}->{861303179} = "Zibo\,\ Shandong";
$areanames{en}->{861303180} = "Langfang\,\ Hebei";
$areanames{en}->{861303181} = "Langfang\,\ Hebei";
$areanames{en}->{861303182} = "Hengshui\,\ Hebei";
$areanames{en}->{861303183} = "Hengshui\,\ Hebei";
$areanames{en}->{861303184} = "Hengshui\,\ Hebei";
$areanames{en}->{861303185} = "Hengshui\,\ Hebei";
$areanames{en}->{861303186} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861303187} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861303188} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861303189} = "Cangzhou\,\ Hebei";
$areanames{en}->{861303190} = "Xingtai\,\ Hebei";
$areanames{en}->{861303191} = "Xingtai\,\ Hebei";
$areanames{en}->{861303192} = "Xingtai\,\ Hebei";
$areanames{en}->{861303193} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861303194} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861303195} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861303196} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861303197} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861303198} = "Handan\,\ Hebei";
$areanames{en}->{861303199} = "Handan\,\ Hebei";
$areanames{en}->{86130320} = "Baoding\,\ Hebei";
$areanames{en}->{861303209} = "Chengde\,\ Hebei";
$areanames{en}->{86130321} = "Shanghai";
$areanames{en}->{86130322} = "Tianjin";
$areanames{en}->{86130323} = "Chongqing";
$areanames{en}->{86130324} = "Shenyang\,\ Liaoning";
$areanames{en}->{861303250} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861303251} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861303252} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861303253} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861303254} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861303255} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861303256} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861303257} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861303258} = "Suqian\,\ Jiangsu";
$areanames{en}->{861303259} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86130326} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861303270} = "Yichang\,\ Hubei";
$areanames{en}->{861303271} = "Yichang\,\ Hubei";
$areanames{en}->{861303272} = "Yichang\,\ Hubei";
$areanames{en}->{861303273} = "Yichang\,\ Hubei";
$areanames{en}->{861303274} = "Yichang\,\ Hubei";
$areanames{en}->{861303275} = "Jingmen\,\ Hubei";
$areanames{en}->{861303276} = "Jingmen\,\ Hubei";
$areanames{en}->{861303277} = "Jingmen\,\ Hubei";
$areanames{en}->{861303278} = "Enshi\,\ Hubei";
$areanames{en}->{861303279} = "Enshi\,\ Hubei";
$areanames{en}->{86130328} = "Chengdu\,\ Sichuan";
$areanames{en}->{86130329} = "XiAn\,\ Shaanxi";
$areanames{en}->{861303300} = "Hefei\,\ Anhui";
$areanames{en}->{861303301} = "Bengbu\,\ Anhui";
$areanames{en}->{861303302} = "Bengbu\,\ Anhui";
$areanames{en}->{861303303} = "Wuhu\,\ Anhui";
$areanames{en}->{861303304} = "Wuhu\,\ Anhui";
$areanames{en}->{861303305} = "Hefei\,\ Anhui";
$areanames{en}->{861303306} = "Hefei\,\ Anhui";
$areanames{en}->{861303307} = "Huainan\,\ Anhui";
$areanames{en}->{861303308} = "Hefei\,\ Anhui";
$areanames{en}->{861303309} = "Hefei\,\ Anhui";
$areanames{en}->{861303310} = "MaAnshan\,\ Anhui";
$areanames{en}->{861303311} = "MaAnshan\,\ Anhui";
$areanames{en}->{861303312} = "Huangshan\,\ Anhui";
$areanames{en}->{861303313} = "Xuancheng\,\ Anhui";
$areanames{en}->{861303314} = "Xuancheng\,\ Anhui";
$areanames{en}->{861303315} = "Tongling\,\ Anhui";
$areanames{en}->{861303316} = "Anqing\,\ Anhui";
$areanames{en}->{861303317} = "Anqing\,\ Anhui";
$areanames{en}->{861303318} = "Anqing\,\ Anhui";
$areanames{en}->{861303319} = "Anqing\,\ Anhui";
$areanames{en}->{86130332} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861303329} = "JiAn\,\ Jiangxi";
$areanames{en}->{86130333} = "Kunming\,\ Yunnan";
$areanames{en}->{861303330} = "Wenshan\,\ Yunnan";
$areanames{en}->{861303331} = "Puer\,\ Yunnan";
$areanames{en}->{861303332} = "Baoshan\,\ Yunnan";
$areanames{en}->{861303340} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861303341} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861303342} = "Linfen\,\ Shanxi";
$areanames{en}->{861303343} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861303344} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861303345} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861303346} = "Changzhi\,\ Shanxi";
$areanames{en}->{861303347} = "Lüliang\,\ Shanxi";
$areanames{en}->{861303348} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861303349} = "Datong\,\ Shanxi";
$areanames{en}->{861303350} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861303351} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861303352} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861303353} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861303354} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861303355} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861303356} = "Nantong\,\ Jiangsu";
$areanames{en}->{861303357} = "Nantong\,\ Jiangsu";
$areanames{en}->{861303358} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861303359} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861303360} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861303361} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861303362} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861303363} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861303364} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861303365} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861303366} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861303367} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861303368} = "Lishui\,\ Zhejiang";
$areanames{en}->{861303369} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86130337} = "Xinyang\,\ Henan";
$areanames{en}->{86130338} = "Zhumadian\,\ Henan";
$areanames{en}->{861303387} = "Hebi\,\ Henan";
$areanames{en}->{861303388} = "Hebi\,\ Henan";
$areanames{en}->{861303389} = "Hebi\,\ Henan";
$areanames{en}->{86130339} = "Zhoukou\,\ Henan";
$areanames{en}->{861303398} = "Puyang\,\ Henan";
$areanames{en}->{861303399} = "Puyang\,\ Henan";
$areanames{en}->{861303400} = "Suzhou\,\ Anhui";
$areanames{en}->{861303401} = "Suzhou\,\ Anhui";
$areanames{en}->{861303402} = "LuAn\,\ Anhui";
$areanames{en}->{861303403} = "LuAn\,\ Anhui";
$areanames{en}->{861303404} = "Hefei\,\ Anhui";
$areanames{en}->{861303405} = "Hefei\,\ Anhui";
$areanames{en}->{861303406} = "Fuyang\,\ Anhui";
$areanames{en}->{861303407} = "Fuyang\,\ Anhui";
$areanames{en}->{861303408} = "Fuyang\,\ Anhui";
$areanames{en}->{861303409} = "Fuyang\,\ Anhui";
$areanames{en}->{861303410} = "Qingyang\,\ Gansu";
$areanames{en}->{861303411} = "Tianshui\,\ Gansu";
$areanames{en}->{861303412} = "Tianshui\,\ Gansu";
$areanames{en}->{861303413} = "Linxia\,\ Gansu";
$areanames{en}->{861303414} = "Dingxi\,\ Gansu";
$areanames{en}->{861303415} = "Baiyin\,\ Gansu";
$areanames{en}->{861303416} = "Baiyin\,\ Gansu";
$areanames{en}->{861303417} = "Pingliang\,\ Gansu";
$areanames{en}->{861303418} = "Pingliang\,\ Gansu";
$areanames{en}->{861303419} = "Qingyang\,\ Gansu";
$areanames{en}->{861303420} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861303421} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861303422} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861303423} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861303424} = "Lishui\,\ Zhejiang";
$areanames{en}->{861303425} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861303426} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861303427} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861303428} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861303429} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86130343} = "Tianjin";
$areanames{en}->{861303440} = "Huangshi\,\ Hubei";
$areanames{en}->{861303441} = "Huangshi\,\ Hubei";
$areanames{en}->{861303442} = "Huangshi\,\ Hubei";
$areanames{en}->{861303443} = "Huangshi\,\ Hubei";
$areanames{en}->{861303444} = "Ezhou\,\ Hubei";
$areanames{en}->{861303445} = "Ezhou\,\ Hubei";
$areanames{en}->{861303446} = "Huanggang\,\ Hubei";
$areanames{en}->{861303447} = "Huanggang\,\ Hubei";
$areanames{en}->{861303448} = "Huanggang\,\ Hubei";
$areanames{en}->{861303449} = "Huanggang\,\ Hubei";
$areanames{en}->{861303450} = "Zibo\,\ Shandong";
$areanames{en}->{861303451} = "Zibo\,\ Shandong";
$areanames{en}->{861303452} = "Binzhou\,\ Shandong";
$areanames{en}->{861303453} = "Liaocheng\,\ Shandong";
$areanames{en}->{861303454} = "Liaocheng\,\ Shandong";
$areanames{en}->{861303455} = "Heze\,\ Shandong";
$areanames{en}->{861303456} = "Weihai\,\ Shandong";
$areanames{en}->{861303457} = "Weihai\,\ Shandong";
$areanames{en}->{861303458} = "Weihai\,\ Shandong";
$areanames{en}->{861303459} = "Weihai\,\ Shandong";
$areanames{en}->{86130346} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861303470} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861303471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861303472} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861303473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861303474} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861303475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861303476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861303477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861303478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861303479} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861303480} = "Loudi\,\ Hunan";
$areanames{en}->{861303481} = "Loudi\,\ Hunan";
$areanames{en}->{861303482} = "Loudi\,\ Hunan";
$areanames{en}->{861303483} = "Loudi\,\ Hunan";
$areanames{en}->{861303484} = "Loudi\,\ Hunan";
$areanames{en}->{861303485} = "Huaihua\,\ Hunan";
$areanames{en}->{861303486} = "Huaihua\,\ Hunan";
$areanames{en}->{861303487} = "Huaihua\,\ Hunan";
$areanames{en}->{861303488} = "Huaihua\,\ Hunan";
$areanames{en}->{861303489} = "Huaihua\,\ Hunan";
$areanames{en}->{86130349} = "Haikou\,\ Hainan";
$areanames{en}->{861303500} = "Suzhou\,\ Anhui";
$areanames{en}->{861303501} = "Bengbu\,\ Anhui";
$areanames{en}->{861303502} = "Bengbu\,\ Anhui";
$areanames{en}->{861303503} = "Chuzhou\,\ Anhui";
$areanames{en}->{861303504} = "Wuhu\,\ Anhui";
$areanames{en}->{861303505} = "Hefei\,\ Anhui";
$areanames{en}->{861303506} = "Hefei\,\ Anhui";
$areanames{en}->{861303507} = "Fuyang\,\ Anhui";
$areanames{en}->{861303508} = "Fuyang\,\ Anhui";
$areanames{en}->{861303509} = "Hefei\,\ Anhui";
$areanames{en}->{861303510} = "Wuhan\,\ Hubei";
$areanames{en}->{861303511} = "Wuhan\,\ Hubei";
$areanames{en}->{861303512} = "Wuhan\,\ Hubei";
$areanames{en}->{861303513} = "Wuhan\,\ Hubei";
$areanames{en}->{861303514} = "Wuhan\,\ Hubei";
$areanames{en}->{861303515} = "Xiaogan\,\ Hubei";
$areanames{en}->{861303516} = "Xiaogan\,\ Hubei";
$areanames{en}->{861303517} = "Xiaogan\,\ Hubei";
$areanames{en}->{861303518} = "Xiaogan\,\ Hubei";
$areanames{en}->{861303519} = "Suizhou\,\ Hubei";
$areanames{en}->{861303520} = "Xiangfan\,\ Hubei";
$areanames{en}->{861303521} = "Xiangfan\,\ Hubei";
$areanames{en}->{861303522} = "Xiangfan\,\ Hubei";
$areanames{en}->{861303523} = "Xiangfan\,\ Hubei";
$areanames{en}->{861303524} = "Xiangfan\,\ Hubei";
$areanames{en}->{861303525} = "Shiyan\,\ Hubei";
$areanames{en}->{861303526} = "Shiyan\,\ Hubei";
$areanames{en}->{861303527} = "Shiyan\,\ Hubei";
$areanames{en}->{861303528} = "Shiyan\,\ Hubei";
$areanames{en}->{861303529} = "Shiyan\,\ Hubei";
$areanames{en}->{86130353} = "Wuhan\,\ Hubei";
$areanames{en}->{861303530} = "Jingzhou\,\ Hubei";
$areanames{en}->{861303531} = "Jingzhou\,\ Hubei";
$areanames{en}->{861303532} = "Jingzhou\,\ Hubei";
$areanames{en}->{861303533} = "Jingzhou\,\ Hubei";
$areanames{en}->{861303540} = "Hefei\,\ Anhui";
$areanames{en}->{861303541} = "Fuyang\,\ Anhui";
$areanames{en}->{861303542} = "LuAn\,\ Anhui";
$areanames{en}->{861303543} = "Huangshan\,\ Anhui";
$areanames{en}->{861303544} = "MaAnshan\,\ Anhui";
$areanames{en}->{861303545} = "Chuzhou\,\ Anhui";
$areanames{en}->{861303546} = "Huaibei\,\ Anhui";
$areanames{en}->{861303547} = "Huainan\,\ Anhui";
$areanames{en}->{861303548} = "Tongling\,\ Anhui";
$areanames{en}->{861303549} = "Chizhou\,\ Anhui";
$areanames{en}->{861303550} = "Zunyi\,\ Guizhou";
$areanames{en}->{861303551} = "Zunyi\,\ Guizhou";
$areanames{en}->{861303552} = "Zunyi\,\ Guizhou";
$areanames{en}->{861303553} = "Zunyi\,\ Guizhou";
$areanames{en}->{861303554} = "Bijie\,\ Guizhou";
$areanames{en}->{861303555} = "Qiannan\,\ Guizhou";
$areanames{en}->{861303556} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861303557} = "Tongren\,\ Guizhou";
$areanames{en}->{861303558} = "Anshun\,\ Guizhou";
$areanames{en}->{861303559} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86130356} = "Mianyang\,\ Sichuan";
$areanames{en}->{861303560} = "Zigong\,\ Sichuan";
$areanames{en}->{861303561} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861303562} = "Guangyuan\,\ Sichuan";
$areanames{en}->{86130357} = "Meizhou\,\ Guangdong";
$areanames{en}->{861303570} = "Heyuan\,\ Guangdong";
$areanames{en}->{861303571} = "Heyuan\,\ Guangdong";
$areanames{en}->{861303572} = "Heyuan\,\ Guangdong";
$areanames{en}->{861303573} = "Heyuan\,\ Guangdong";
$areanames{en}->{86130358} = "Maoming\,\ Guangdong";
$areanames{en}->{861303586} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861303587} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861303588} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861303589} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861303590} = "Honghe\,\ Yunnan";
$areanames{en}->{861303591} = "Honghe\,\ Yunnan";
$areanames{en}->{861303592} = "Lincang\,\ Yunnan";
$areanames{en}->{861303593} = "Nujiang\,\ Yunnan";
$areanames{en}->{861303594} = "Dehong\,\ Yunnan";
$areanames{en}->{861303595} = "Dehong\,\ Yunnan";
$areanames{en}->{861303596} = "Dehong\,\ Yunnan";
$areanames{en}->{861303597} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861303598} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861303599} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{86130360} = "Haikou\,\ Hainan";
$areanames{en}->{86130361} = "Wuhan\,\ Hubei";
$areanames{en}->{861303617} = "Xianning\,\ Hubei";
$areanames{en}->{861303618} = "Xianning\,\ Hubei";
$areanames{en}->{861303619} = "Xianning\,\ Hubei";
$areanames{en}->{861303620} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861303621} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861303622} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861303623} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861303624} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861303625} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861303626} = "Yichun\,\ Jiangxi";
$areanames{en}->{861303627} = "Yichun\,\ Jiangxi";
$areanames{en}->{861303628} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861303629} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86130363} = "Chongqing";
$areanames{en}->{861303640} = "Zigong\,\ Sichuan";
$areanames{en}->{861303641} = "Zigong\,\ Sichuan";
$areanames{en}->{861303642} = "Luzhou\,\ Sichuan";
$areanames{en}->{861303643} = "Luzhou\,\ Sichuan";
$areanames{en}->{861303644} = "Meishan\,\ Sichuan";
$areanames{en}->{861303645} = "Leshan\,\ Sichuan";
$areanames{en}->{861303646} = "Suining\,\ Sichuan";
$areanames{en}->{861303647} = "Dazhou\,\ Sichuan";
$areanames{en}->{861303648} = "Yibin\,\ Sichuan";
$areanames{en}->{861303649} = "Yibin\,\ Sichuan";
$areanames{en}->{861303650} = "Yibin\,\ Sichuan";
$areanames{en}->{861303651} = "Yibin\,\ Sichuan";
$areanames{en}->{861303652} = "Yibin\,\ Sichuan";
$areanames{en}->{861303653} = "Yibin\,\ Sichuan";
$areanames{en}->{861303654} = "Luzhou\,\ Sichuan";
$areanames{en}->{861303655} = "Luzhou\,\ Sichuan";
$areanames{en}->{861303656} = "Nanchong\,\ Sichuan";
$areanames{en}->{861303657} = "Leshan\,\ Sichuan";
$areanames{en}->{861303658} = "Leshan\,\ Sichuan";
$areanames{en}->{861303659} = "Leshan\,\ Sichuan";
$areanames{en}->{861303660} = "Meishan\,\ Sichuan";
$areanames{en}->{861303661} = "Meishan\,\ Sichuan";
$areanames{en}->{861303662} = "Dazhou\,\ Sichuan";
$areanames{en}->{861303663} = "Dazhou\,\ Sichuan";
$areanames{en}->{861303664} = "Dazhou\,\ Sichuan";
$areanames{en}->{861303665} = "Dazhou\,\ Sichuan";
$areanames{en}->{861303666} = "Chengdu\,\ Sichuan";
$areanames{en}->{861303667} = "Chengdu\,\ Sichuan";
$areanames{en}->{861303668} = "Chengdu\,\ Sichuan";
$areanames{en}->{861303669} = "Chengdu\,\ Sichuan";
$areanames{en}->{861303670} = "Shaoyang\,\ Hunan";
$areanames{en}->{861303671} = "Shaoyang\,\ Hunan";
$areanames{en}->{861303672} = "Shaoyang\,\ Hunan";
$areanames{en}->{861303673} = "Shaoyang\,\ Hunan";
$areanames{en}->{861303674} = "Shaoyang\,\ Hunan";
$areanames{en}->{861303675} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861303676} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861303677} = "Yongzhou\,\ Hunan";
$areanames{en}->{861303678} = "Changsha\,\ Hunan";
$areanames{en}->{861303679} = "Changsha\,\ Hunan";
$areanames{en}->{861303680} = "Guigang\,\ Guangxi";
$areanames{en}->{861303681} = "Nanning\,\ Guangxi";
$areanames{en}->{861303682} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861303683} = "Guilin\,\ Guangxi";
$areanames{en}->{861303684} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861303685} = "Guigang\,\ Guangxi";
$areanames{en}->{861303686} = "Nanning\,\ Guangxi";
$areanames{en}->{861303687} = "Hezhou\,\ Guangxi";
$areanames{en}->{861303688} = "Nanning\,\ Guangxi";
$areanames{en}->{861303689} = "Beihai\,\ Guangxi";
$areanames{en}->{861303690} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861303691} = "Nanning\,\ Guangxi";
$areanames{en}->{861303692} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861303693} = "Guilin\,\ Guangxi";
$areanames{en}->{861303694} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861303695} = "Yulin\,\ Guangxi";
$areanames{en}->{861303696} = "Baise\,\ Guangxi";
$areanames{en}->{861303697} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861303698} = "Hechi\,\ Guangxi";
$areanames{en}->{861303699} = "Beihai\,\ Guangxi";
$areanames{en}->{861303700} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861303701} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861303702} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861303703} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861303704} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861303705} = "Yangquan\,\ Shanxi";
$areanames{en}->{861303706} = "Yangquan\,\ Shanxi";
$areanames{en}->{861303707} = "Lüliang\,\ Shanxi";
$areanames{en}->{861303708} = "Lüliang\,\ Shanxi";
$areanames{en}->{861303709} = "Lüliang\,\ Shanxi";
$areanames{en}->{86130371} = "Wuhan\,\ Hubei";
$areanames{en}->{86130372} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861303725} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861303726} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861303727} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861303729} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861303730} = "Yueyang\,\ Hunan";
$areanames{en}->{861303731} = "Changsha\,\ Hunan";
$areanames{en}->{861303732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861303733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861303734} = "Hengyang\,\ Hunan";
$areanames{en}->{861303735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861303736} = "Changde\,\ Hunan";
$areanames{en}->{861303737} = "Yiyang\,\ Hunan";
$areanames{en}->{861303738} = "Loudi\,\ Hunan";
$areanames{en}->{861303739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861303740} = "Xiangxi\,\ Hunan";
$areanames{en}->{861303741} = "Xiangxi\,\ Hunan";
$areanames{en}->{861303742} = "Xiangxi\,\ Hunan";
$areanames{en}->{861303743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861303744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861303745} = "Huaihua\,\ Hunan";
$areanames{en}->{861303746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861303747} = "Yongzhou\,\ Hunan";
$areanames{en}->{861303748} = "Yongzhou\,\ Hunan";
$areanames{en}->{861303749} = "Yongzhou\,\ Hunan";
$areanames{en}->{86130375} = "Shangqiu\,\ Henan";
$areanames{en}->{86130376} = "Nanyang\,\ Henan";
$areanames{en}->{86130377} = "Liangshan\,\ Sichuan";
$areanames{en}->{861303770} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861303771} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861303772} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861303773} = "Panzhihua\,\ Sichuan";
$areanames{en}->{86130378} = "Guiyang\,\ Guizhou";
$areanames{en}->{861303790} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861303791} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861303792} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861303793} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861303794} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861303795} = "Guyuan\,\ Ningxia";
$areanames{en}->{861303796} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861303797} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861303798} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861303799} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861303800} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861303801} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861303802} = "Linfen\,\ Shanxi";
$areanames{en}->{861303803} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861303804} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861303805} = "Jincheng\,\ Shanxi";
$areanames{en}->{861303806} = "Changzhi\,\ Shanxi";
$areanames{en}->{861303807} = "Yangquan\,\ Shanxi";
$areanames{en}->{861303808} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861303809} = "Datong\,\ Shanxi";
$areanames{en}->{861303810} = "Zigong\,\ Sichuan";
$areanames{en}->{861303811} = "Luzhou\,\ Sichuan";
$areanames{en}->{861303812} = "Leshan\,\ Sichuan";
$areanames{en}->{861303813} = "Leshan\,\ Sichuan";
$areanames{en}->{861303814} = "Ziyang\,\ Sichuan";
$areanames{en}->{861303815} = "Ziyang\,\ Sichuan";
$areanames{en}->{861303816} = "Ziyang\,\ Sichuan";
$areanames{en}->{861303817} = "Neijiang\,\ Sichuan";
$areanames{en}->{861303818} = "Neijiang\,\ Sichuan";
$areanames{en}->{861303819} = "Neijiang\,\ Sichuan";
$areanames{en}->{86130382} = "Deyang\,\ Sichuan";
$areanames{en}->{861303820} = "Nanchong\,\ Sichuan";
$areanames{en}->{861303821} = "Nanchong\,\ Sichuan";
$areanames{en}->{861303822} = "Suining\,\ Sichuan";
$areanames{en}->{861303823} = "Yibin\,\ Sichuan";
$areanames{en}->{86130383} = "Chongqing";
$areanames{en}->{861303840} = "Weinan\,\ Shaanxi";
$areanames{en}->{861303841} = "Weinan\,\ Shaanxi";
$areanames{en}->{861303842} = "Weinan\,\ Shaanxi";
$areanames{en}->{861303843} = "Weinan\,\ Shaanxi";
$areanames{en}->{861303844} = "YanAn\,\ Shaanxi";
$areanames{en}->{861303845} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861303846} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861303847} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861303848} = "Baoji\,\ Shaanxi";
$areanames{en}->{861303849} = "Baoji\,\ Shaanxi";
$areanames{en}->{861303850} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861303851} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861303852} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861303853} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861303854} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861303855} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861303856} = "YanAn\,\ Shaanxi";
$areanames{en}->{861303857} = "YanAn\,\ Shaanxi";
$areanames{en}->{861303858} = "XiAn\,\ Shaanxi";
$areanames{en}->{861303859} = "XiAn\,\ Shaanxi";
$areanames{en}->{861303860} = "Deqen\,\ Yunnan";
$areanames{en}->{861303861} = "Lijiang\,\ Yunnan";
$areanames{en}->{861303862} = "Dali\,\ Yunnan";
$areanames{en}->{861303863} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861303864} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861303865} = "Yuxi\,\ Yunnan";
$areanames{en}->{861303866} = "Yuxi\,\ Yunnan";
$areanames{en}->{861303867} = "Qujing\,\ Yunnan";
$areanames{en}->{861303868} = "Qujing\,\ Yunnan";
$areanames{en}->{861303869} = "Chuxiong\,\ Yunnan";
$areanames{en}->{86130387} = "Lanzhou\,\ Gansu";
$areanames{en}->{86130388} = "Dongguan\,\ Guangdong";
$areanames{en}->{86130389} = "Yulin\,\ Shaanxi";
$areanames{en}->{861303890} = "Ankang\,\ Shaanxi";
$areanames{en}->{861303891} = "Ankang\,\ Shaanxi";
$areanames{en}->{861303892} = "Ankang\,\ Shaanxi";
$areanames{en}->{861303893} = "XiAn\,\ Shaanxi";
$areanames{en}->{861303900} = "Changchun\,\ Jilin";
$areanames{en}->{861303901} = "Changchun\,\ Jilin";
$areanames{en}->{861303902} = "Siping\,\ Jilin";
$areanames{en}->{861303903} = "Siping\,\ Jilin";
$areanames{en}->{861303904} = "Changchun\,\ Jilin";
$areanames{en}->{861303905} = "Songyuan\,\ Jilin";
$areanames{en}->{861303906} = "Baicheng\,\ Jilin";
$areanames{en}->{861303907} = "Baishan\,\ Jilin";
$areanames{en}->{861303908} = "Yanbian\,\ Jilin";
$areanames{en}->{861303909} = "Yanbian\,\ Jilin";
$areanames{en}->{861303910} = "Changchun\,\ Jilin";
$areanames{en}->{861303911} = "Changchun\,\ Jilin";
$areanames{en}->{861303912} = "Changchun\,\ Jilin";
$areanames{en}->{861303913} = "Changchun\,\ Jilin";
$areanames{en}->{861303914} = "Changchun\,\ Jilin";
$areanames{en}->{861303915} = "Jilin\,\ Jilin";
$areanames{en}->{861303916} = "Jilin\,\ Jilin";
$areanames{en}->{861303917} = "Jilin\,\ Jilin";
$areanames{en}->{861303918} = "Yanbian\,\ Jilin";
$areanames{en}->{861303919} = "Tonghua\,\ Jilin";
$areanames{en}->{861303920} = "Changchun\,\ Jilin";
$areanames{en}->{861303921} = "Changchun\,\ Jilin";
$areanames{en}->{861303922} = "Changchun\,\ Jilin";
$areanames{en}->{861303923} = "Yanbian\,\ Jilin";
$areanames{en}->{861303924} = "Jilin\,\ Jilin";
$areanames{en}->{861303925} = "Jilin\,\ Jilin";
$areanames{en}->{861303926} = "Jilin\,\ Jilin";
$areanames{en}->{861303927} = "Jilin\,\ Jilin";
$areanames{en}->{861303928} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861303929} = "Tonghua\,\ Jilin";
$areanames{en}->{861303930} = "Changchun\,\ Jilin";
$areanames{en}->{861303931} = "Changchun\,\ Jilin";
$areanames{en}->{861303932} = "Changchun\,\ Jilin";
$areanames{en}->{861303933} = "Yanbian\,\ Jilin";
$areanames{en}->{861303934} = "Changchun\,\ Jilin";
$areanames{en}->{861303935} = "Songyuan\,\ Jilin";
$areanames{en}->{861303936} = "Baicheng\,\ Jilin";
$areanames{en}->{861303937} = "Baicheng\,\ Jilin";
$areanames{en}->{861303938} = "Baishan\,\ Jilin";
$areanames{en}->{861303939} = "Baishan\,\ Jilin";
$areanames{en}->{86130394} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861303940} = "Changji\,\ Xinjiang";
$areanames{en}->{861303941} = "Changji\,\ Xinjiang";
$areanames{en}->{861303942} = "Changji\,\ Xinjiang";
$areanames{en}->{861303950} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861303951} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861303952} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861303953} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861303954} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861303955} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303956} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303957} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303958} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861303959} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{86130396} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861303966} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861303967} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861303968} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861303969} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861303970} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861303971} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861303972} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861303973} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861303974} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861303975} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861303976} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861303977} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861303978} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861303979} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{86130398} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861303989} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861303990} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861303991} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861303992} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861303993} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861303994} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861303995} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861303996} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861303997} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861303998} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861303999} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130400} = "Tangshan\,\ Hebei";
$areanames{en}->{86130401} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861304019} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{86130402} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861304029} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861304030} = "Siping\,\ Jilin";
$areanames{en}->{861304031} = "Baicheng\,\ Jilin";
$areanames{en}->{861304032} = "Baishan\,\ Jilin";
$areanames{en}->{861304033} = "Songyuan\,\ Jilin";
$areanames{en}->{861304034} = "Songyuan\,\ Jilin";
$areanames{en}->{861304035} = "Tonghua\,\ Jilin";
$areanames{en}->{861304036} = "Baicheng\,\ Jilin";
$areanames{en}->{861304037} = "Tonghua\,\ Jilin";
$areanames{en}->{861304038} = "Siping\,\ Jilin";
$areanames{en}->{861304039} = "Baishan\,\ Jilin";
$areanames{en}->{861304040} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861304041} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861304042} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861304043} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861304044} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861304045} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861304046} = "Aksu\,\ Xinjiang";
$areanames{en}->{861304047} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861304048} = "Kashi\,\ Xinjiang";
$areanames{en}->{861304049} = "Hotan\,\ Xinjiang";
$areanames{en}->{861304050} = "Changji\,\ Xinjiang";
$areanames{en}->{861304051} = "Turpan\,\ Xinjiang";
$areanames{en}->{861304052} = "Hami\,\ Xinjiang";
$areanames{en}->{861304053} = "Ili\,\ Xinjiang";
$areanames{en}->{861304054} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861304055} = "Karamay\,\ Xinjiang";
$areanames{en}->{861304056} = "Ili\,\ Xinjiang";
$areanames{en}->{861304057} = "Bortala\,\ Xinjiang";
$areanames{en}->{861304058} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861304059} = "Altay\,\ Xinjiang";
$areanames{en}->{86130406} = "Shanghai";
$areanames{en}->{86130407} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861304074} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861304075} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861304078} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861304079} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86130408} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861304090} = "Jingzhou\,\ Hubei";
$areanames{en}->{861304091} = "Jingzhou\,\ Hubei";
$areanames{en}->{861304092} = "Jingzhou\,\ Hubei";
$areanames{en}->{861304093} = "Jingzhou\,\ Hubei";
$areanames{en}->{861304094} = "Jingzhou\,\ Hubei";
$areanames{en}->{861304095} = "Yichang\,\ Hubei";
$areanames{en}->{861304096} = "Yichang\,\ Hubei";
$areanames{en}->{861304097} = "Yichang\,\ Hubei";
$areanames{en}->{861304098} = "Yichang\,\ Hubei";
$areanames{en}->{861304099} = "Yichang\,\ Hubei";
$areanames{en}->{86130410} = "Beijing";
$areanames{en}->{86130411} = "Beijing";
$areanames{en}->{86130412} = "Beijing";
$areanames{en}->{86130413} = "Jilin\,\ Jilin";
$areanames{en}->{861304136} = "Changchun\,\ Jilin";
$areanames{en}->{861304137} = "Changchun\,\ Jilin";
$areanames{en}->{861304138} = "Changchun\,\ Jilin";
$areanames{en}->{861304139} = "Changchun\,\ Jilin";
$areanames{en}->{86130414} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130415} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86130416} = "Shanghai";
$areanames{en}->{86130417} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861304170} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861304171} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861304172} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861304176} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{86130418} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130419} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861304199} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{86130420} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130421} = "Shanghai";
$areanames{en}->{86130422} = "Tianjin";
$areanames{en}->{86130423} = "Chongqing";
$areanames{en}->{861304240} = "Shenyang\,\ Liaoning";
$areanames{en}->{861304241} = "Shenyang\,\ Liaoning";
$areanames{en}->{861304242} = "Shenyang\,\ Liaoning";
$areanames{en}->{861304243} = "Shenyang\,\ Liaoning";
$areanames{en}->{861304244} = "Shenyang\,\ Liaoning";
$areanames{en}->{861304245} = "Dalian\,\ Liaoning";
$areanames{en}->{861304246} = "Dalian\,\ Liaoning";
$areanames{en}->{861304247} = "Dalian\,\ Liaoning";
$areanames{en}->{861304248} = "Dalian\,\ Liaoning";
$areanames{en}->{861304249} = "Dalian\,\ Liaoning";
$areanames{en}->{86130425} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861304260} = "Anshan\,\ Liaoning";
$areanames{en}->{861304261} = "Anshan\,\ Liaoning";
$areanames{en}->{861304262} = "Anshan\,\ Liaoning";
$areanames{en}->{861304263} = "Fushun\,\ Liaoning";
$areanames{en}->{861304264} = "Fushun\,\ Liaoning";
$areanames{en}->{861304265} = "Benxi\,\ Liaoning";
$areanames{en}->{861304266} = "Dandong\,\ Liaoning";
$areanames{en}->{861304267} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861304268} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861304269} = "Yingkou\,\ Liaoning";
$areanames{en}->{861304270} = "Huangshi\,\ Hubei";
$areanames{en}->{861304271} = "Huanggang\,\ Hubei";
$areanames{en}->{861304272} = "Huanggang\,\ Hubei";
$areanames{en}->{861304273} = "Ezhou\,\ Hubei";
$areanames{en}->{861304274} = "Xiaogan\,\ Hubei";
$areanames{en}->{861304275} = "Suizhou\,\ Hubei";
$areanames{en}->{861304276} = "Shiyan\,\ Hubei";
$areanames{en}->{861304277} = "Xianning\,\ Hubei";
$areanames{en}->{861304278} = "Xiangfan\,\ Hubei";
$areanames{en}->{861304279} = "Xiangfan\,\ Hubei";
$areanames{en}->{86130428} = "Wuhan\,\ Hubei";
$areanames{en}->{861304280} = "Xiangfan\,\ Hubei";
$areanames{en}->{861304281} = "Xiangfan\,\ Hubei";
$areanames{en}->{861304282} = "Xiangfan\,\ Hubei";
$areanames{en}->{861304283} = "Xiangfan\,\ Hubei";
$areanames{en}->{861304290} = "Baiyin\,\ Gansu";
$areanames{en}->{861304291} = "Linxia\,\ Gansu";
$areanames{en}->{861304292} = "Zhangye\,\ Gansu";
$areanames{en}->{861304293} = "Qingyang\,\ Gansu";
$areanames{en}->{861304294} = "Dingxi\,\ Gansu";
$areanames{en}->{861304295} = "Tianshui\,\ Gansu";
$areanames{en}->{861304296} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861304297} = "Tianshui\,\ Gansu";
$areanames{en}->{861304298} = "Tianshui\,\ Gansu";
$areanames{en}->{861304299} = "Pingliang\,\ Gansu";
$areanames{en}->{861304300} = "Xiamen\,\ Fujian";
$areanames{en}->{861304301} = "Zhengzhou\,\ Henan";
$areanames{en}->{861304302} = "Luoyang\,\ Henan";
$areanames{en}->{861304303} = "Pingdingshan\,\ Henan";
$areanames{en}->{861304304} = "Xiamen\,\ Fujian";
$areanames{en}->{861304305} = "Sanming\,\ Fujian";
$areanames{en}->{861304306} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304307} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304308} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304309} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304310} = "Handan\,\ Hebei";
$areanames{en}->{861304311} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861304312} = "Baoding\,\ Hebei";
$areanames{en}->{861304313} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861304314} = "Tangshan\,\ Hebei";
$areanames{en}->{861304315} = "Tangshan\,\ Hebei";
$areanames{en}->{861304316} = "Langfang\,\ Hebei";
$areanames{en}->{861304317} = "Cangzhou\,\ Hebei";
$areanames{en}->{861304318} = "Hengshui\,\ Hebei";
$areanames{en}->{861304319} = "Xingtai\,\ Hebei";
$areanames{en}->{86130432} = "Tianjin";
$areanames{en}->{861304330} = "Changchun\,\ Jilin";
$areanames{en}->{861304331} = "Changchun\,\ Jilin";
$areanames{en}->{861304332} = "Changchun\,\ Jilin";
$areanames{en}->{861304333} = "Changchun\,\ Jilin";
$areanames{en}->{861304334} = "Changchun\,\ Jilin";
$areanames{en}->{861304335} = "Yanbian\,\ Jilin";
$areanames{en}->{861304336} = "Yanbian\,\ Jilin";
$areanames{en}->{861304337} = "Yanbian\,\ Jilin";
$areanames{en}->{861304338} = "Yanbian\,\ Jilin";
$areanames{en}->{861304339} = "Yanbian\,\ Jilin";
$areanames{en}->{86130434} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130435} = "Fuzhou\,\ Fujian";
$areanames{en}->{861304356} = "Longyan\,\ Fujian";
$areanames{en}->{861304357} = "Sanming\,\ Fujian";
$areanames{en}->{861304358} = "Nanping\,\ Fujian";
$areanames{en}->{861304359} = "Longyan\,\ Fujian";
$areanames{en}->{861304360} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861304361} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861304362} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861304363} = "Loudi\,\ Hunan";
$areanames{en}->{861304364} = "Loudi\,\ Hunan";
$areanames{en}->{861304365} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861304366} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861304367} = "Loudi\,\ Hunan";
$areanames{en}->{861304368} = "Loudi\,\ Hunan";
$areanames{en}->{861304369} = "Loudi\,\ Hunan";
$areanames{en}->{861304370} = "Shangqiu\,\ Henan";
$areanames{en}->{861304371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861304372} = "Anyang\,\ Henan";
$areanames{en}->{861304373} = "Xinxiang\,\ Henan";
$areanames{en}->{861304374} = "Xuchang\,\ Henan";
$areanames{en}->{861304375} = "Pingdingshan\,\ Henan";
$areanames{en}->{861304376} = "Xinyang\,\ Henan";
$areanames{en}->{861304377} = "Nanyang\,\ Henan";
$areanames{en}->{861304378} = "Kaifeng\,\ Henan";
$areanames{en}->{861304379} = "Luoyang\,\ Henan";
$areanames{en}->{861304380} = "Fuxin\,\ Liaoning";
$areanames{en}->{861304381} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861304382} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861304383} = "Tieling\,\ Liaoning";
$areanames{en}->{861304384} = "Tieling\,\ Liaoning";
$areanames{en}->{861304385} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861304386} = "Panjin\,\ Liaoning";
$areanames{en}->{861304387} = "Panjin\,\ Liaoning";
$areanames{en}->{861304388} = "Huludao\,\ Liaoning";
$areanames{en}->{861304389} = "Huludao\,\ Liaoning";
$areanames{en}->{861304390} = "Nanyang\,\ Henan";
$areanames{en}->{861304391} = "Jiaozuo\,\ Henan";
$areanames{en}->{861304392} = "Hebi\,\ Henan";
$areanames{en}->{861304393} = "Puyang\,\ Henan";
$areanames{en}->{861304394} = "Zhoukou\,\ Henan";
$areanames{en}->{861304395} = "Luohe\,\ Henan";
$areanames{en}->{861304396} = "Zhumadian\,\ Henan";
$areanames{en}->{861304397} = "Zhengzhou\,\ Henan";
$areanames{en}->{861304398} = "Sanmenxia\,\ Henan";
$areanames{en}->{861304399} = "Zhengzhou\,\ Henan";
$areanames{en}->{861304400} = "TaiAn\,\ Shandong";
$areanames{en}->{861304401} = "TaiAn\,\ Shandong";
$areanames{en}->{861304402} = "TaiAn\,\ Shandong";
$areanames{en}->{861304403} = "Laiwu\,\ Shandong";
$areanames{en}->{861304404} = "Linyi\,\ Shandong";
$areanames{en}->{861304405} = "Linyi\,\ Shandong";
$areanames{en}->{861304406} = "Linyi\,\ Shandong";
$areanames{en}->{861304407} = "Jining\,\ Shandong";
$areanames{en}->{861304408} = "Jining\,\ Shandong";
$areanames{en}->{861304409} = "Jining\,\ Shandong";
$areanames{en}->{86130441} = "Shanghai";
$areanames{en}->{86130442} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861304430} = "Changchun\,\ Jilin";
$areanames{en}->{861304431} = "Changchun\,\ Jilin";
$areanames{en}->{861304432} = "Jilin\,\ Jilin";
$areanames{en}->{861304433} = "Yanbian\,\ Jilin";
$areanames{en}->{861304434} = "Siping\,\ Jilin";
$areanames{en}->{861304435} = "Tonghua\,\ Jilin";
$areanames{en}->{861304436} = "Baicheng\,\ Jilin";
$areanames{en}->{861304437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861304438} = "Songyuan\,\ Jilin";
$areanames{en}->{861304439} = "Baishan\,\ Jilin";
$areanames{en}->{861304440} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861304441} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861304442} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861304443} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861304444} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861304445} = "Jincheng\,\ Shanxi";
$areanames{en}->{861304446} = "Yangquan\,\ Shanxi";
$areanames{en}->{861304447} = "Yangquan\,\ Shanxi";
$areanames{en}->{861304448} = "Lüliang\,\ Shanxi";
$areanames{en}->{861304449} = "Lüliang\,\ Shanxi";
$areanames{en}->{861304450} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304451} = "Zhengzhou\,\ Henan";
$areanames{en}->{861304452} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304453} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304454} = "Quanzhou\,\ Fujian";
$areanames{en}->{861304455} = "Quanzhou\,\ Fujian";
$areanames{en}->{861304456} = "Quanzhou\,\ Fujian";
$areanames{en}->{861304457} = "Fuzhou\,\ Fujian";
$areanames{en}->{861304458} = "Fuzhou\,\ Fujian";
$areanames{en}->{861304459} = "Fuzhou\,\ Fujian";
$areanames{en}->{86130446} = "Shanghai";
$areanames{en}->{861304470} = "Zhengzhou\,\ Henan";
$areanames{en}->{861304471} = "Zhengzhou\,\ Henan";
$areanames{en}->{861304472} = "Luoyang\,\ Henan";
$areanames{en}->{861304473} = "Luoyang\,\ Henan";
$areanames{en}->{861304474} = "Luoyang\,\ Henan";
$areanames{en}->{861304475} = "Xinxiang\,\ Henan";
$areanames{en}->{861304476} = "Anyang\,\ Henan";
$areanames{en}->{861304477} = "Luohe\,\ Henan";
$areanames{en}->{861304478} = "Kaifeng\,\ Henan";
$areanames{en}->{861304479} = "Pingdingshan\,\ Henan";
$areanames{en}->{861304480} = "Xiaogan\,\ Hubei";
$areanames{en}->{861304481} = "Xiaogan\,\ Hubei";
$areanames{en}->{861304482} = "Xiaogan\,\ Hubei";
$areanames{en}->{861304483} = "Enshi\,\ Hubei";
$areanames{en}->{861304484} = "Enshi\,\ Hubei";
$areanames{en}->{861304485} = "Enshi\,\ Hubei";
$areanames{en}->{861304486} = "Enshi\,\ Hubei";
$areanames{en}->{861304487} = "Jingmen\,\ Hubei";
$areanames{en}->{861304488} = "Jingmen\,\ Hubei";
$areanames{en}->{861304489} = "Jingmen\,\ Hubei";
$areanames{en}->{861304490} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861304491} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861304492} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861304493} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861304494} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861304495} = "Yichun\,\ Jiangxi";
$areanames{en}->{861304496} = "JiAn\,\ Jiangxi";
$areanames{en}->{861304497} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861304498} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861304499} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86130450} = "Qingdao\,\ Shandong";
$areanames{en}->{86130451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861304525} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861304526} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861304528} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861304529} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861304530} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861304531} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861304532} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861304533} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861304534} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861304535} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861304536} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861304537} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861304538} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861304539} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861304540} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861304541} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861304542} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861304543} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861304544} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861304545} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861304546} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861304547} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861304548} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861304549} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861304550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861304551} = "Hefei\,\ Anhui";
$areanames{en}->{861304552} = "LuAn\,\ Anhui";
$areanames{en}->{861304553} = "Chizhou\,\ Anhui";
$areanames{en}->{861304554} = "Xuancheng\,\ Anhui";
$areanames{en}->{861304555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861304556} = "Anqing\,\ Anhui";
$areanames{en}->{861304557} = "Tongling\,\ Anhui";
$areanames{en}->{861304558} = "Xuancheng\,\ Anhui";
$areanames{en}->{861304559} = "Huangshan\,\ Anhui";
$areanames{en}->{86130456} = "Shanghai";
$areanames{en}->{861304570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861304571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861304572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861304573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861304574} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861304575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861304576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861304577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861304578} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861304579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86130458} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861304590} = "Longyan\,\ Fujian";
$areanames{en}->{861304591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861304592} = "Xiamen\,\ Fujian";
$areanames{en}->{861304593} = "Ningde\,\ Fujian";
$areanames{en}->{861304594} = "Putian\,\ Fujian";
$areanames{en}->{861304595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861304596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861304597} = "Xiamen\,\ Fujian";
$areanames{en}->{861304598} = "Sanming\,\ Fujian";
$areanames{en}->{861304599} = "Nanping\,\ Fujian";
$areanames{en}->{861304600} = "Jinan\,\ Shandong";
$areanames{en}->{861304601} = "Jinan\,\ Shandong";
$areanames{en}->{861304602} = "Jinan\,\ Shandong";
$areanames{en}->{861304603} = "Jinan\,\ Shandong";
$areanames{en}->{861304604} = "Jinan\,\ Shandong";
$areanames{en}->{861304605} = "Zibo\,\ Shandong";
$areanames{en}->{861304606} = "Zibo\,\ Shandong";
$areanames{en}->{861304607} = "Zibo\,\ Shandong";
$areanames{en}->{861304608} = "Zibo\,\ Shandong";
$areanames{en}->{861304609} = "Zibo\,\ Shandong";
$areanames{en}->{861304610} = "Shanwei\,\ Guangdong";
$areanames{en}->{861304611} = "Shanwei\,\ Guangdong";
$areanames{en}->{861304612} = "Shanwei\,\ Guangdong";
$areanames{en}->{861304613} = "Shanwei\,\ Guangdong";
$areanames{en}->{861304614} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861304615} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861304616} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861304617} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861304618} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861304619} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861304620} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861304621} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861304622} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861304623} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861304624} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861304625} = "Maoming\,\ Guangdong";
$areanames{en}->{861304626} = "Maoming\,\ Guangdong";
$areanames{en}->{861304627} = "Maoming\,\ Guangdong";
$areanames{en}->{861304628} = "Maoming\,\ Guangdong";
$areanames{en}->{861304629} = "Maoming\,\ Guangdong";
$areanames{en}->{861304630} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861304631} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861304632} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861304633} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861304634} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861304635} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861304636} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861304637} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861304638} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861304639} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861304640} = "Yantai\,\ Shandong";
$areanames{en}->{861304641} = "Yantai\,\ Shandong";
$areanames{en}->{861304642} = "Yantai\,\ Shandong";
$areanames{en}->{861304643} = "Weihai\,\ Shandong";
$areanames{en}->{861304644} = "Weihai\,\ Shandong";
$areanames{en}->{861304645} = "Weihai\,\ Shandong";
$areanames{en}->{861304646} = "Weifang\,\ Shandong";
$areanames{en}->{861304647} = "Weifang\,\ Shandong";
$areanames{en}->{861304648} = "Weifang\,\ Shandong";
$areanames{en}->{861304649} = "Weifang\,\ Shandong";
$areanames{en}->{86130465} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86130466} = "Shanghai";
$areanames{en}->{86130467} = "Nantong\,\ Jiangsu";
$areanames{en}->{861304679} = "Suqian\,\ Jiangsu";
$areanames{en}->{86130468} = "Dongguan\,\ Guangdong";
$areanames{en}->{861304680} = "Shantou\,\ Guangdong";
$areanames{en}->{861304681} = "Shantou\,\ Guangdong";
$areanames{en}->{861304690} = "Putian\,\ Fujian";
$areanames{en}->{861304691} = "Pingdingshan\,\ Henan";
$areanames{en}->{861304692} = "Ningde\,\ Fujian";
$areanames{en}->{861304693} = "Ningde\,\ Fujian";
$areanames{en}->{861304694} = "Ningde\,\ Fujian";
$areanames{en}->{861304695} = "Ningde\,\ Fujian";
$areanames{en}->{861304696} = "Quanzhou\,\ Fujian";
$areanames{en}->{861304697} = "Quanzhou\,\ Fujian";
$areanames{en}->{861304698} = "Quanzhou\,\ Fujian";
$areanames{en}->{861304699} = "Quanzhou\,\ Fujian";
$areanames{en}->{86130470} = "Foshan\,\ Guangdong";
$areanames{en}->{861304700} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861304701} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861304702} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861304703} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861304710} = "Jingzhou\,\ Hubei";
$areanames{en}->{861304711} = "Jingzhou\,\ Hubei";
$areanames{en}->{861304712} = "Wuhan\,\ Hubei";
$areanames{en}->{861304713} = "Wuhan\,\ Hubei";
$areanames{en}->{861304714} = "Wuhan\,\ Hubei";
$areanames{en}->{861304715} = "Yichang\,\ Hubei";
$areanames{en}->{861304716} = "Yichang\,\ Hubei";
$areanames{en}->{861304717} = "Yichang\,\ Hubei";
$areanames{en}->{861304718} = "Jingmen\,\ Hubei";
$areanames{en}->{861304719} = "Enshi\,\ Hubei";
$areanames{en}->{861304720} = "Yueyang\,\ Hunan";
$areanames{en}->{861304721} = "Changsha\,\ Hunan";
$areanames{en}->{861304722} = "Xiangtan\,\ Hunan";
$areanames{en}->{861304723} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861304724} = "Hengyang\,\ Hunan";
$areanames{en}->{861304725} = "Chenzhou\,\ Hunan";
$areanames{en}->{861304726} = "Changde\,\ Hunan";
$areanames{en}->{861304727} = "Yiyang\,\ Hunan";
$areanames{en}->{861304728} = "Shaoyang\,\ Hunan";
$areanames{en}->{861304729} = "Huaihua\,\ Hunan";
$areanames{en}->{86130473} = "Chongqing";
$areanames{en}->{861304740} = "Qingdao\,\ Shandong";
$areanames{en}->{861304741} = "Qingdao\,\ Shandong";
$areanames{en}->{861304742} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861304743} = "Rizhao\,\ Shandong";
$areanames{en}->{861304744} = "Dongying\,\ Shandong";
$areanames{en}->{861304745} = "Liaocheng\,\ Shandong";
$areanames{en}->{861304746} = "Dezhou\,\ Shandong";
$areanames{en}->{861304747} = "Linyi\,\ Shandong";
$areanames{en}->{861304748} = "Jinan\,\ Shandong";
$areanames{en}->{861304749} = "Yantai\,\ Shandong";
$areanames{en}->{86130475} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861304758} = "Suqian\,\ Jiangsu";
$areanames{en}->{861304759} = "Suqian\,\ Jiangsu";
$areanames{en}->{86130476} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861304768} = "Suqian\,\ Jiangsu";
$areanames{en}->{861304769} = "Suqian\,\ Jiangsu";
$areanames{en}->{86130477} = "Handan\,\ Hebei";
$areanames{en}->{861304780} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861304781} = "Nanning\,\ Guangxi";
$areanames{en}->{861304782} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861304783} = "Hezhou\,\ Guangxi";
$areanames{en}->{861304784} = "Guigang\,\ Guangxi";
$areanames{en}->{861304785} = "Yulin\,\ Guangxi";
$areanames{en}->{861304786} = "Baise\,\ Guangxi";
$areanames{en}->{861304787} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861304788} = "Hechi\,\ Guangxi";
$areanames{en}->{861304789} = "Guigang\,\ Guangxi";
$areanames{en}->{861304790} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861304791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861304792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861304793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861304794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861304795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861304796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861304797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861304798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861304799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86130480} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130481} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861304820} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861304821} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861304822} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861304823} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861304824} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861304825} = "Meizhou\,\ Guangdong";
$areanames{en}->{861304826} = "Meizhou\,\ Guangdong";
$areanames{en}->{861304827} = "Meizhou\,\ Guangdong";
$areanames{en}->{861304828} = "Meizhou\,\ Guangdong";
$areanames{en}->{861304829} = "Meizhou\,\ Guangdong";
$areanames{en}->{86130483} = "Chongqing";
$areanames{en}->{86130484} = "Chongqing";
$areanames{en}->{861304850} = "Zunyi\,\ Guizhou";
$areanames{en}->{861304851} = "Zunyi\,\ Guizhou";
$areanames{en}->{861304852} = "Qiannan\,\ Guizhou";
$areanames{en}->{861304853} = "Qiannan\,\ Guizhou";
$areanames{en}->{861304854} = "Bijie\,\ Guizhou";
$areanames{en}->{861304855} = "Bijie\,\ Guizhou";
$areanames{en}->{861304856} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861304857} = "Zunyi\,\ Guizhou";
$areanames{en}->{861304858} = "Zunyi\,\ Guizhou";
$areanames{en}->{861304859} = "Zunyi\,\ Guizhou";
$areanames{en}->{861304860} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861304861} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861304862} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861304863} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861304864} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861304865} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861304866} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861304867} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861304868} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861304869} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{86130487} = "Huizhou\,\ Guangdong";
$areanames{en}->{861304878} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861304879} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86130488} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130489} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130490} = "Shantou\,\ Guangdong";
$areanames{en}->{86130491} = "Foshan\,\ Guangdong";
$areanames{en}->{86130492} = "Jieyang\,\ Guangdong";
$areanames{en}->{861304920} = "Yunfu\,\ Guangdong";
$areanames{en}->{861304921} = "Yunfu\,\ Guangdong";
$areanames{en}->{861304922} = "Yunfu\,\ Guangdong";
$areanames{en}->{86130493} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130494} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861304950} = "Anshun\,\ Guizhou";
$areanames{en}->{861304951} = "Anshun\,\ Guizhou";
$areanames{en}->{861304952} = "Qiannan\,\ Guizhou";
$areanames{en}->{861304953} = "Qiannan\,\ Guizhou";
$areanames{en}->{861304954} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861304955} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861304956} = "Tongren\,\ Guizhou";
$areanames{en}->{861304957} = "Bijie\,\ Guizhou";
$areanames{en}->{861304958} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861304959} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86130496} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861304960} = "Heyuan\,\ Guangdong";
$areanames{en}->{861304961} = "Heyuan\,\ Guangdong";
$areanames{en}->{86130497} = "Dongguan\,\ Guangdong";
$areanames{en}->{86130498} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130499} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86130500} = "Anshan\,\ Liaoning";
$areanames{en}->{86130501} = "Fushun\,\ Liaoning";
$areanames{en}->{86130502} = "Benxi\,\ Liaoning";
$areanames{en}->{86130503} = "Dandong\,\ Liaoning";
$areanames{en}->{86130504} = "Jinzhou\,\ Liaoning";
$areanames{en}->{86130505} = "Dalian\,\ Liaoning";
$areanames{en}->{86130506} = "Yingkou\,\ Liaoning";
$areanames{en}->{861305070} = "Fuxin\,\ Liaoning";
$areanames{en}->{861305071} = "Fuxin\,\ Liaoning";
$areanames{en}->{861305072} = "Fuxin\,\ Liaoning";
$areanames{en}->{861305073} = "Fuxin\,\ Liaoning";
$areanames{en}->{861305074} = "Fuxin\,\ Liaoning";
$areanames{en}->{861305075} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861305076} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861305077} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861305078} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861305079} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861305080} = "Tieling\,\ Liaoning";
$areanames{en}->{861305081} = "Tieling\,\ Liaoning";
$areanames{en}->{861305082} = "Tieling\,\ Liaoning";
$areanames{en}->{861305083} = "Tieling\,\ Liaoning";
$areanames{en}->{861305084} = "Tieling\,\ Liaoning";
$areanames{en}->{861305085} = "Panjin\,\ Liaoning";
$areanames{en}->{861305086} = "Panjin\,\ Liaoning";
$areanames{en}->{861305087} = "Panjin\,\ Liaoning";
$areanames{en}->{861305088} = "Panjin\,\ Liaoning";
$areanames{en}->{861305089} = "Panjin\,\ Liaoning";
$areanames{en}->{861305090} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305091} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305092} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305093} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305094} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305095} = "Huludao\,\ Liaoning";
$areanames{en}->{861305096} = "Huludao\,\ Liaoning";
$areanames{en}->{861305097} = "Huludao\,\ Liaoning";
$areanames{en}->{861305098} = "Huludao\,\ Liaoning";
$areanames{en}->{861305099} = "Huludao\,\ Liaoning";
$areanames{en}->{8613051} = "Beijing";
$areanames{en}->{8613052} = "Shanghai";
$areanames{en}->{861305260} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305261} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305262} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305263} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305264} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861305265} = "Huludao\,\ Liaoning";
$areanames{en}->{861305266} = "Huludao\,\ Liaoning";
$areanames{en}->{861305267} = "Huludao\,\ Liaoning";
$areanames{en}->{861305268} = "Huludao\,\ Liaoning";
$areanames{en}->{861305269} = "Huludao\,\ Liaoning";
$areanames{en}->{86130527} = "Dalian\,\ Liaoning";
$areanames{en}->{86130528} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861305290} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861305291} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861305292} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861305293} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861305294} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861305295} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861305296} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861305297} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861305298} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861305299} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861305300} = "Suzhou\,\ Anhui";
$areanames{en}->{861305301} = "Suzhou\,\ Anhui";
$areanames{en}->{861305302} = "LuAn\,\ Anhui";
$areanames{en}->{861305303} = "LuAn\,\ Anhui";
$areanames{en}->{861305304} = "Hefei\,\ Anhui";
$areanames{en}->{861305305} = "Hefei\,\ Anhui";
$areanames{en}->{861305306} = "Hefei\,\ Anhui";
$areanames{en}->{861305307} = "Huainan\,\ Anhui";
$areanames{en}->{861305308} = "Hefei\,\ Anhui";
$areanames{en}->{861305309} = "Hefei\,\ Anhui";
$areanames{en}->{861305310} = "Chuzhou\,\ Anhui";
$areanames{en}->{861305311} = "Bengbu\,\ Anhui";
$areanames{en}->{861305312} = "Bengbu\,\ Anhui";
$areanames{en}->{861305313} = "Hefei\,\ Anhui";
$areanames{en}->{861305314} = "Chuzhou\,\ Anhui";
$areanames{en}->{861305315} = "Huaibei\,\ Anhui";
$areanames{en}->{861305316} = "Wuhu\,\ Anhui";
$areanames{en}->{861305317} = "Huainan\,\ Anhui";
$areanames{en}->{861305318} = "Bozhou\,\ Anhui";
$areanames{en}->{861305319} = "Fuyang\,\ Anhui";
$areanames{en}->{861305320} = "MaAnshan\,\ Anhui";
$areanames{en}->{861305321} = "MaAnshan\,\ Anhui";
$areanames{en}->{861305322} = "Huangshan\,\ Anhui";
$areanames{en}->{861305323} = "Xuancheng\,\ Anhui";
$areanames{en}->{861305324} = "Xuancheng\,\ Anhui";
$areanames{en}->{861305325} = "Tongling\,\ Anhui";
$areanames{en}->{861305326} = "Wuhu\,\ Anhui";
$areanames{en}->{861305327} = "Anqing\,\ Anhui";
$areanames{en}->{861305328} = "Anqing\,\ Anhui";
$areanames{en}->{861305329} = "Chizhou\,\ Anhui";
$areanames{en}->{86130533} = "Zibo\,\ Shandong";
$areanames{en}->{86130534} = "Dezhou\,\ Shandong";
$areanames{en}->{86130535} = "Yantai\,\ Shandong";
$areanames{en}->{86130536} = "Weifang\,\ Shandong";
$areanames{en}->{86130537} = "Jining\,\ Shandong";
$areanames{en}->{86130538} = "TaiAn\,\ Shandong";
$areanames{en}->{86130539} = "Linyi\,\ Shandong";
$areanames{en}->{861305400} = "Chenzhou\,\ Hunan";
$areanames{en}->{861305401} = "Chenzhou\,\ Hunan";
$areanames{en}->{861305402} = "Changde\,\ Hunan";
$areanames{en}->{861305403} = "Changde\,\ Hunan";
$areanames{en}->{861305404} = "Changde\,\ Hunan";
$areanames{en}->{861305405} = "Hengyang\,\ Hunan";
$areanames{en}->{861305406} = "Hengyang\,\ Hunan";
$areanames{en}->{861305407} = "Yueyang\,\ Hunan";
$areanames{en}->{861305408} = "Yueyang\,\ Hunan";
$areanames{en}->{861305409} = "Yiyang\,\ Hunan";
$areanames{en}->{861305410} = "Yiyang\,\ Hunan";
$areanames{en}->{861305411} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861305412} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861305413} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861305414} = "Xiangtan\,\ Hunan";
$areanames{en}->{861305415} = "Xiangtan\,\ Hunan";
$areanames{en}->{861305416} = "Changsha\,\ Hunan";
$areanames{en}->{861305417} = "Changsha\,\ Hunan";
$areanames{en}->{861305418} = "Changsha\,\ Hunan";
$areanames{en}->{861305419} = "Changsha\,\ Hunan";
$areanames{en}->{861305420} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861305421} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861305422} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861305423} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861305424} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861305425} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861305426} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861305427} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861305428} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861305429} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861305430} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861305431} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861305432} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861305433} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861305434} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861305435} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861305436} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861305437} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861305438} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861305439} = "Suihua\,\ Heilongjiang";
$areanames{en}->{86130544} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130545} = "Yantai\,\ Shandong";
$areanames{en}->{86130546} = "Dongying\,\ Shandong";
$areanames{en}->{86130547} = "Weifang\,\ Shandong";
$areanames{en}->{861305480} = "Laiwu\,\ Shandong";
$areanames{en}->{861305481} = "Laiwu\,\ Shandong";
$areanames{en}->{861305482} = "Laiwu\,\ Shandong";
$areanames{en}->{861305483} = "Laiwu\,\ Shandong";
$areanames{en}->{861305484} = "Laiwu\,\ Shandong";
$areanames{en}->{861305485} = "Zibo\,\ Shandong";
$areanames{en}->{861305486} = "Zibo\,\ Shandong";
$areanames{en}->{861305487} = "Zibo\,\ Shandong";
$areanames{en}->{861305488} = "Zibo\,\ Shandong";
$areanames{en}->{861305489} = "Zibo\,\ Shandong";
$areanames{en}->{861305490} = "Linyi\,\ Shandong";
$areanames{en}->{861305491} = "Linyi\,\ Shandong";
$areanames{en}->{861305492} = "Linyi\,\ Shandong";
$areanames{en}->{861305493} = "Linyi\,\ Shandong";
$areanames{en}->{861305494} = "Linyi\,\ Shandong";
$areanames{en}->{861305495} = "Jining\,\ Shandong";
$areanames{en}->{861305496} = "Jining\,\ Shandong";
$areanames{en}->{861305497} = "Jining\,\ Shandong";
$areanames{en}->{861305498} = "Jining\,\ Shandong";
$areanames{en}->{861305499} = "Jining\,\ Shandong";
$areanames{en}->{861305500} = "Chenzhou\,\ Hunan";
$areanames{en}->{861305501} = "Chenzhou\,\ Hunan";
$areanames{en}->{861305502} = "Changde\,\ Hunan";
$areanames{en}->{861305503} = "Changde\,\ Hunan";
$areanames{en}->{861305504} = "Changde\,\ Hunan";
$areanames{en}->{861305505} = "Hengyang\,\ Hunan";
$areanames{en}->{861305506} = "Hengyang\,\ Hunan";
$areanames{en}->{861305507} = "Yueyang\,\ Hunan";
$areanames{en}->{861305508} = "Yueyang\,\ Hunan";
$areanames{en}->{861305509} = "Yiyang\,\ Hunan";
$areanames{en}->{861305510} = "Yiyang\,\ Hunan";
$areanames{en}->{861305511} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861305512} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861305513} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861305514} = "Xiangtan\,\ Hunan";
$areanames{en}->{861305515} = "Xiangtan\,\ Hunan";
$areanames{en}->{861305516} = "Changsha\,\ Hunan";
$areanames{en}->{861305517} = "Changsha\,\ Hunan";
$areanames{en}->{861305518} = "Changsha\,\ Hunan";
$areanames{en}->{861305519} = "Changsha\,\ Hunan";
$areanames{en}->{861305520} = "Xiamen\,\ Fujian";
$areanames{en}->{861305521} = "Xiamen\,\ Fujian";
$areanames{en}->{861305522} = "Xiamen\,\ Fujian";
$areanames{en}->{861305523} = "Xiamen\,\ Fujian";
$areanames{en}->{861305524} = "Xiamen\,\ Fujian";
$areanames{en}->{861305525} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305526} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305527} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305528} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305529} = "Fuzhou\,\ Fujian";
$areanames{en}->{86130553} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861305530} = "Putian\,\ Fujian";
$areanames{en}->{861305531} = "Putian\,\ Fujian";
$areanames{en}->{861305532} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305533} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305540} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305541} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305542} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305543} = "Xiamen\,\ Fujian";
$areanames{en}->{861305544} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861305545} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861305546} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305547} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305548} = "Ningde\,\ Fujian";
$areanames{en}->{861305549} = "Nanping\,\ Fujian";
$areanames{en}->{861305550} = "Xiamen\,\ Fujian";
$areanames{en}->{861305551} = "Xiamen\,\ Fujian";
$areanames{en}->{861305552} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305553} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305554} = "Sanming\,\ Fujian";
$areanames{en}->{861305555} = "Sanming\,\ Fujian";
$areanames{en}->{861305556} = "Sanming\,\ Fujian";
$areanames{en}->{861305557} = "Ningde\,\ Fujian";
$areanames{en}->{861305558} = "Ningde\,\ Fujian";
$areanames{en}->{861305559} = "Ningde\,\ Fujian";
$areanames{en}->{86130556} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305568} = "Putian\,\ Fujian";
$areanames{en}->{861305569} = "Putian\,\ Fujian";
$areanames{en}->{86130557} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305570} = "Nanping\,\ Fujian";
$areanames{en}->{861305571} = "Nanping\,\ Fujian";
$areanames{en}->{861305580} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305581} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305582} = "Nanping\,\ Fujian";
$areanames{en}->{861305583} = "Nanping\,\ Fujian";
$areanames{en}->{861305584} = "Longyan\,\ Fujian";
$areanames{en}->{861305585} = "Longyan\,\ Fujian";
$areanames{en}->{861305586} = "Longyan\,\ Fujian";
$areanames{en}->{861305587} = "Xiamen\,\ Fujian";
$areanames{en}->{861305588} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861305589} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861305590} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861305592} = "Xiamen\,\ Fujian";
$areanames{en}->{861305593} = "Ningde\,\ Fujian";
$areanames{en}->{861305594} = "Putian\,\ Fujian";
$areanames{en}->{861305595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861305596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861305597} = "Longyan\,\ Fujian";
$areanames{en}->{861305598} = "Nanping\,\ Fujian";
$areanames{en}->{861305599} = "Nanping\,\ Fujian";
$areanames{en}->{86130560} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861305600} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861305601} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861305602} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861305603} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{86130561} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861305610} = "Suqian\,\ Jiangsu";
$areanames{en}->{861305611} = "Suqian\,\ Jiangsu";
$areanames{en}->{861305612} = "Suqian\,\ Jiangsu";
$areanames{en}->{86130562} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{86130563} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861305640} = "Leshan\,\ Sichuan";
$areanames{en}->{861305641} = "Meishan\,\ Sichuan";
$areanames{en}->{861305642} = "Nanchong\,\ Sichuan";
$areanames{en}->{861305643} = "Nanchong\,\ Sichuan";
$areanames{en}->{861305644} = "Dazhou\,\ Sichuan";
$areanames{en}->{861305645} = "Garze\,\ Sichuan";
$areanames{en}->{861305646} = "Aba\,\ Sichuan";
$areanames{en}->{861305647} = "Aba\,\ Sichuan";
$areanames{en}->{861305648} = "Bazhong\,\ Sichuan";
$areanames{en}->{861305649} = "Bazhong\,\ Sichuan";
$areanames{en}->{861305650} = "Bazhong\,\ Sichuan";
$areanames{en}->{861305651} = "Bazhong\,\ Sichuan";
$areanames{en}->{861305652} = "GuangAn\,\ Sichuan";
$areanames{en}->{861305653} = "GuangAn\,\ Sichuan";
$areanames{en}->{861305654} = "GuangAn\,\ Sichuan";
$areanames{en}->{861305655} = "GuangAn\,\ Sichuan";
$areanames{en}->{861305656} = "YaAn\,\ Sichuan";
$areanames{en}->{861305657} = "YaAn\,\ Sichuan";
$areanames{en}->{861305658} = "YaAn\,\ Sichuan";
$areanames{en}->{861305659} = "YaAn\,\ Sichuan";
$areanames{en}->{861305660} = "Meishan\,\ Sichuan";
$areanames{en}->{861305661} = "Meishan\,\ Sichuan";
$areanames{en}->{861305662} = "Leshan\,\ Sichuan";
$areanames{en}->{861305663} = "Leshan\,\ Sichuan";
$areanames{en}->{861305664} = "Yibin\,\ Sichuan";
$areanames{en}->{861305665} = "Yibin\,\ Sichuan";
$areanames{en}->{861305666} = "Chengdu\,\ Sichuan";
$areanames{en}->{861305667} = "Chengdu\,\ Sichuan";
$areanames{en}->{861305668} = "Chengdu\,\ Sichuan";
$areanames{en}->{861305669} = "Chengdu\,\ Sichuan";
$areanames{en}->{86130567} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130568} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130569} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130570} = "Nantong\,\ Jiangsu";
$areanames{en}->{86130571} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86130572} = "Wuxi\,\ Jiangsu";
$areanames{en}->{86130573} = "Wuxi\,\ Jiangsu";
$areanames{en}->{86130574} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130575} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86130576} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86130577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130578} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130579} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130580} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130581} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861305820} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861305821} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861305822} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861305823} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861305824} = "Shanwei\,\ Guangdong";
$areanames{en}->{861305825} = "Shanwei\,\ Guangdong";
$areanames{en}->{861305826} = "Shantou\,\ Guangdong";
$areanames{en}->{861305827} = "Shantou\,\ Guangdong";
$areanames{en}->{861305828} = "Shantou\,\ Guangdong";
$areanames{en}->{861305829} = "Shantou\,\ Guangdong";
$areanames{en}->{86130583} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861305830} = "Foshan\,\ Guangdong";
$areanames{en}->{861305831} = "Foshan\,\ Guangdong";
$areanames{en}->{861305832} = "Foshan\,\ Guangdong";
$areanames{en}->{861305833} = "Foshan\,\ Guangdong";
$areanames{en}->{861305840} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861305841} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861305842} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861305843} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861305844} = "Jieyang\,\ Guangdong";
$areanames{en}->{861305845} = "Jieyang\,\ Guangdong";
$areanames{en}->{861305846} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861305847} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861305848} = "Shantou\,\ Guangdong";
$areanames{en}->{861305849} = "Shantou\,\ Guangdong";
$areanames{en}->{86130585} = "Dongguan\,\ Guangdong";
$areanames{en}->{86130586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86130587} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86130588} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861305890} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861305891} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861305892} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861305893} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861305894} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861305895} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861305896} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861305897} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861305898} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861305899} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86130590} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861305900} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861305901} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861305902} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861305903} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130591} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130592} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861305930} = "Yunfu\,\ Guangdong";
$areanames{en}->{861305931} = "Yunfu\,\ Guangdong";
$areanames{en}->{861305932} = "Yunfu\,\ Guangdong";
$areanames{en}->{861305933} = "Yunfu\,\ Guangdong";
$areanames{en}->{861305934} = "Yunfu\,\ Guangdong";
$areanames{en}->{861305935} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861305936} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861305937} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861305938} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861305939} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{86130594} = "Dongguan\,\ Guangdong";
$areanames{en}->{861305947} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861305948} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861305949} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{86130595} = "Huizhou\,\ Guangdong";
$areanames{en}->{861305957} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861305958} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861305959} = "Qingyuan\,\ Guangdong";
$areanames{en}->{86130596} = "Lishui\,\ Zhejiang";
$areanames{en}->{86130597} = "Quzhou\,\ Zhejiang";
$areanames{en}->{86130598} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{86130599} = "Huzhou\,\ Zhejiang";
$areanames{en}->{86130600} = "Chengdu\,\ Sichuan";
$areanames{en}->{861306010} = "Deyang\,\ Sichuan";
$areanames{en}->{861306011} = "Deyang\,\ Sichuan";
$areanames{en}->{861306012} = "Deyang\,\ Sichuan";
$areanames{en}->{861306013} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861306014} = "Luzhou\,\ Sichuan";
$areanames{en}->{861306015} = "Luzhou\,\ Sichuan";
$areanames{en}->{861306016} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861306017} = "Mianyang\,\ Sichuan";
$areanames{en}->{861306018} = "Mianyang\,\ Sichuan";
$areanames{en}->{861306019} = "Mianyang\,\ Sichuan";
$areanames{en}->{86130602} = "Chongqing";
$areanames{en}->{861306030} = "Weinan\,\ Shaanxi";
$areanames{en}->{861306031} = "Weinan\,\ Shaanxi";
$areanames{en}->{861306032} = "Weinan\,\ Shaanxi";
$areanames{en}->{861306033} = "Weinan\,\ Shaanxi";
$areanames{en}->{861306034} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861306035} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861306036} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861306037} = "XiAn\,\ Shaanxi";
$areanames{en}->{861306038} = "XiAn\,\ Shaanxi";
$areanames{en}->{861306039} = "XiAn\,\ Shaanxi";
$areanames{en}->{861306040} = "XiAn\,\ Shaanxi";
$areanames{en}->{861306041} = "XiAn\,\ Shaanxi";
$areanames{en}->{861306042} = "XiAn\,\ Shaanxi";
$areanames{en}->{861306043} = "Weinan\,\ Shaanxi";
$areanames{en}->{861306044} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861306045} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861306046} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861306047} = "Baoji\,\ Shaanxi";
$areanames{en}->{861306048} = "Baoji\,\ Shaanxi";
$areanames{en}->{861306049} = "Baoji\,\ Shaanxi";
$areanames{en}->{861306050} = "Shanwei\,\ Guangdong";
$areanames{en}->{861306051} = "Shanwei\,\ Guangdong";
$areanames{en}->{861306052} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861306053} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861306054} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861306055} = "Jieyang\,\ Guangdong";
$areanames{en}->{861306056} = "Jieyang\,\ Guangdong";
$areanames{en}->{861306057} = "Jieyang\,\ Guangdong";
$areanames{en}->{861306058} = "Jieyang\,\ Guangdong";
$areanames{en}->{861306059} = "Jieyang\,\ Guangdong";
$areanames{en}->{86130606} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861306070} = "Meizhou\,\ Guangdong";
$areanames{en}->{861306071} = "Meizhou\,\ Guangdong";
$areanames{en}->{861306072} = "Meizhou\,\ Guangdong";
$areanames{en}->{861306073} = "Meizhou\,\ Guangdong";
$areanames{en}->{861306074} = "Meizhou\,\ Guangdong";
$areanames{en}->{861306075} = "Foshan\,\ Guangdong";
$areanames{en}->{861306076} = "Foshan\,\ Guangdong";
$areanames{en}->{861306077} = "Foshan\,\ Guangdong";
$areanames{en}->{861306078} = "Foshan\,\ Guangdong";
$areanames{en}->{861306079} = "Foshan\,\ Guangdong";
$areanames{en}->{86130608} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130609} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130610} = "Binzhou\,\ Shandong";
$areanames{en}->{861306107} = "Liaocheng\,\ Shandong";
$areanames{en}->{861306108} = "Liaocheng\,\ Shandong";
$areanames{en}->{861306109} = "Liaocheng\,\ Shandong";
$areanames{en}->{86130611} = "Weihai\,\ Shandong";
$areanames{en}->{86130612} = "Qingdao\,\ Shandong";
$areanames{en}->{86130613} = "Qingdao\,\ Shandong";
$areanames{en}->{86130614} = "Qingdao\,\ Shandong";
$areanames{en}->{86130615} = "Heze\,\ Shandong";
$areanames{en}->{861306150} = "Liaocheng\,\ Shandong";
$areanames{en}->{861306151} = "Liaocheng\,\ Shandong";
$areanames{en}->{861306152} = "Liaocheng\,\ Shandong";
$areanames{en}->{86130616} = "Shanghai";
$areanames{en}->{86130617} = "Shanghai";
$areanames{en}->{86130618} = "Shanghai";
$areanames{en}->{86130619} = "Shanghai";
$areanames{en}->{86130620} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861306210} = "Sanming\,\ Fujian";
$areanames{en}->{861306211} = "Sanming\,\ Fujian";
$areanames{en}->{861306212} = "Sanming\,\ Fujian";
$areanames{en}->{861306213} = "Putian\,\ Fujian";
$areanames{en}->{861306214} = "Putian\,\ Fujian";
$areanames{en}->{861306215} = "Putian\,\ Fujian";
$areanames{en}->{861306216} = "Ningde\,\ Fujian";
$areanames{en}->{861306217} = "Ningde\,\ Fujian";
$areanames{en}->{861306218} = "Ningde\,\ Fujian";
$areanames{en}->{861306219} = "Ningde\,\ Fujian";
$areanames{en}->{86130622} = "Longyan\,\ Fujian";
$areanames{en}->{861306226} = "Nanping\,\ Fujian";
$areanames{en}->{861306227} = "Nanping\,\ Fujian";
$areanames{en}->{861306228} = "Nanping\,\ Fujian";
$areanames{en}->{861306229} = "Putian\,\ Fujian";
$areanames{en}->{86130623} = "Chongqing";
$areanames{en}->{861306240} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861306241} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861306242} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861306243} = "Xiamen\,\ Fujian";
$areanames{en}->{861306244} = "Xiamen\,\ Fujian";
$areanames{en}->{861306245} = "Longyan\,\ Fujian";
$areanames{en}->{861306246} = "Ningde\,\ Fujian";
$areanames{en}->{861306247} = "Nanping\,\ Fujian";
$areanames{en}->{861306248} = "Sanming\,\ Fujian";
$areanames{en}->{861306249} = "Sanming\,\ Fujian";
$areanames{en}->{86130625} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86130626} = "Shanghai";
$areanames{en}->{86130627} = "Shanghai";
$areanames{en}->{86130628} = "Shanghai";
$areanames{en}->{861306290} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861306291} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861306292} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861306293} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861306294} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861306295} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861306296} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861306297} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861306298} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861306299} = "Taizhou\,\ Jiangsu";
$areanames{en}->{86130630} = "Xiamen\,\ Fujian";
$areanames{en}->{861306300} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861306301} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861306302} = "Zhangzhou\,\ Fujian";
$areanames{en}->{86130631} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861306320} = "MaAnshan\,\ Anhui";
$areanames{en}->{861306321} = "Hefei\,\ Anhui";
$areanames{en}->{861306322} = "Huangshan\,\ Anhui";
$areanames{en}->{861306323} = "Xuancheng\,\ Anhui";
$areanames{en}->{861306324} = "Xuancheng\,\ Anhui";
$areanames{en}->{861306325} = "Tongling\,\ Anhui";
$areanames{en}->{861306326} = "Wuhu\,\ Anhui";
$areanames{en}->{861306327} = "Anqing\,\ Anhui";
$areanames{en}->{861306328} = "Anqing\,\ Anhui";
$areanames{en}->{861306329} = "Chizhou\,\ Anhui";
$areanames{en}->{861306330} = "Chuzhou\,\ Anhui";
$areanames{en}->{861306331} = "Bengbu\,\ Anhui";
$areanames{en}->{861306332} = "Bengbu\,\ Anhui";
$areanames{en}->{861306333} = "Hefei\,\ Anhui";
$areanames{en}->{861306334} = "Chuzhou\,\ Anhui";
$areanames{en}->{861306335} = "Huaibei\,\ Anhui";
$areanames{en}->{861306336} = "Wuhu\,\ Anhui";
$areanames{en}->{861306337} = "Fuyang\,\ Anhui";
$areanames{en}->{861306338} = "Fuyang\,\ Anhui";
$areanames{en}->{861306339} = "Bozhou\,\ Anhui";
$areanames{en}->{861306340} = "Suzhou\,\ Anhui";
$areanames{en}->{861306341} = "Anqing\,\ Anhui";
$areanames{en}->{861306342} = "LuAn\,\ Anhui";
$areanames{en}->{861306343} = "LuAn\,\ Anhui";
$areanames{en}->{861306344} = "Hefei\,\ Anhui";
$areanames{en}->{861306345} = "Hefei\,\ Anhui";
$areanames{en}->{861306346} = "Huainan\,\ Anhui";
$areanames{en}->{861306347} = "Huainan\,\ Anhui";
$areanames{en}->{861306348} = "Hefei\,\ Anhui";
$areanames{en}->{861306349} = "Hefei\,\ Anhui";
$areanames{en}->{861306350} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861306351} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861306352} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861306353} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861306354} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861306355} = "Nantong\,\ Jiangsu";
$areanames{en}->{861306356} = "Nantong\,\ Jiangsu";
$areanames{en}->{861306357} = "Nantong\,\ Jiangsu";
$areanames{en}->{861306358} = "Nantong\,\ Jiangsu";
$areanames{en}->{861306359} = "Nantong\,\ Jiangsu";
$areanames{en}->{86130636} = "Wuxi\,\ Jiangsu";
$areanames{en}->{86130637} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130638} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130639} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86130640} = "Jinan\,\ Shandong";
$areanames{en}->{861306410} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861306411} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861306412} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861306413} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861306414} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861306415} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861306416} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861306417} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861306418} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861306419} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{86130642} = "Kunming\,\ Yunnan";
$areanames{en}->{861306430} = "Nanchong\,\ Sichuan";
$areanames{en}->{861306431} = "Nanchong\,\ Sichuan";
$areanames{en}->{861306432} = "Dazhou\,\ Sichuan";
$areanames{en}->{861306433} = "Dazhou\,\ Sichuan";
$areanames{en}->{861306434} = "Neijiang\,\ Sichuan";
$areanames{en}->{861306435} = "Neijiang\,\ Sichuan";
$areanames{en}->{861306436} = "Ziyang\,\ Sichuan";
$areanames{en}->{861306437} = "Ziyang\,\ Sichuan";
$areanames{en}->{861306438} = "Zigong\,\ Sichuan";
$areanames{en}->{861306439} = "Zigong\,\ Sichuan";
$areanames{en}->{861306440} = "Anyang\,\ Henan";
$areanames{en}->{861306441} = "Anyang\,\ Henan";
$areanames{en}->{861306442} = "Anyang\,\ Henan";
$areanames{en}->{861306443} = "Anyang\,\ Henan";
$areanames{en}->{861306444} = "Anyang\,\ Henan";
$areanames{en}->{861306445} = "Pingdingshan\,\ Henan";
$areanames{en}->{861306446} = "Pingdingshan\,\ Henan";
$areanames{en}->{861306447} = "Pingdingshan\,\ Henan";
$areanames{en}->{861306448} = "Pingdingshan\,\ Henan";
$areanames{en}->{861306449} = "Pingdingshan\,\ Henan";
$areanames{en}->{86130645} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130646} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86130647} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861306480} = "Suqian\,\ Jiangsu";
$areanames{en}->{861306481} = "Suqian\,\ Jiangsu";
$areanames{en}->{861306482} = "Suqian\,\ Jiangsu";
$areanames{en}->{861306483} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861306484} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861306485} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861306486} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861306487} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861306488} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861306489} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861306490} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861306491} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861306492} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861306493} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861306494} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861306495} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861306496} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861306497} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861306498} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861306499} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{86130650} = "Jinan\,\ Shandong";
$areanames{en}->{86130651} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861306520} = "Tieling\,\ Liaoning";
$areanames{en}->{861306521} = "Tieling\,\ Liaoning";
$areanames{en}->{861306522} = "Tieling\,\ Liaoning";
$areanames{en}->{861306523} = "Tieling\,\ Liaoning";
$areanames{en}->{861306524} = "Tieling\,\ Liaoning";
$areanames{en}->{861306525} = "Panjin\,\ Liaoning";
$areanames{en}->{861306526} = "Panjin\,\ Liaoning";
$areanames{en}->{861306527} = "Panjin\,\ Liaoning";
$areanames{en}->{861306528} = "Panjin\,\ Liaoning";
$areanames{en}->{861306529} = "Panjin\,\ Liaoning";
$areanames{en}->{861306530} = "Fuxin\,\ Liaoning";
$areanames{en}->{861306531} = "Fuxin\,\ Liaoning";
$areanames{en}->{861306532} = "Fuxin\,\ Liaoning";
$areanames{en}->{861306533} = "Fuxin\,\ Liaoning";
$areanames{en}->{861306534} = "Fuxin\,\ Liaoning";
$areanames{en}->{861306535} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861306536} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861306537} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861306538} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861306539} = "Liaoyang\,\ Liaoning";
$areanames{en}->{86130654} = "Anshan\,\ Liaoning";
$areanames{en}->{86130655} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86130656} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861306570} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861306571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861306572} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861306573} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861306574} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861306575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861306576} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861306577} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861306578} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861306579} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86130658} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130659} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86130660} = "Rizhao\,\ Shandong";
$areanames{en}->{861306600} = "Jinan\,\ Shandong";
$areanames{en}->{861306601} = "Jinan\,\ Shandong";
$areanames{en}->{861306602} = "Jinan\,\ Shandong";
$areanames{en}->{861306603} = "Jinan\,\ Shandong";
$areanames{en}->{86130661} = "Dongguan\,\ Guangdong";
$areanames{en}->{86130662} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86130663} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130664} = "Foshan\,\ Guangdong";
$areanames{en}->{861306640} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861306641} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861306642} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861306643} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86130665} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130666} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130667} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130668} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130669} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130670} = "Quanzhou\,\ Fujian";
$areanames{en}->{861306700} = "Sanming\,\ Fujian";
$areanames{en}->{861306701} = "Sanming\,\ Fujian";
$areanames{en}->{86130671} = "Quanzhou\,\ Fujian";
$areanames{en}->{861306710} = "Fuzhou\,\ Fujian";
$areanames{en}->{861306711} = "Fuzhou\,\ Fujian";
$areanames{en}->{86130672} = "Fuzhou\,\ Fujian";
$areanames{en}->{86130673} = "Fuzhou\,\ Fujian";
$areanames{en}->{86130674} = "Fuzhou\,\ Fujian";
$areanames{en}->{861306747} = "Quanzhou\,\ Fujian";
$areanames{en}->{861306748} = "Quanzhou\,\ Fujian";
$areanames{en}->{861306749} = "Quanzhou\,\ Fujian";
$areanames{en}->{86130675} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{86130676} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{86130677} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130678} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130679} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861306800} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861306801} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861306802} = "Linfen\,\ Shanxi";
$areanames{en}->{861306803} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861306804} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861306805} = "Jincheng\,\ Shanxi";
$areanames{en}->{861306806} = "Changzhi\,\ Shanxi";
$areanames{en}->{861306807} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861306808} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861306809} = "Datong\,\ Shanxi";
$areanames{en}->{86130681} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86130682} = "Huizhou\,\ Guangdong";
$areanames{en}->{86130683} = "Chongqing";
$areanames{en}->{86130684} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861306850} = "Maoming\,\ Guangdong";
$areanames{en}->{861306851} = "Maoming\,\ Guangdong";
$areanames{en}->{861306852} = "Maoming\,\ Guangdong";
$areanames{en}->{861306853} = "Maoming\,\ Guangdong";
$areanames{en}->{861306854} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861306855} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861306856} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861306857} = "Heyuan\,\ Guangdong";
$areanames{en}->{861306858} = "Heyuan\,\ Guangdong";
$areanames{en}->{861306859} = "Heyuan\,\ Guangdong";
$areanames{en}->{86130686} = "Foshan\,\ Guangdong";
$areanames{en}->{86130687} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861306875} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861306876} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861306877} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861306879} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86130688} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130689} = "Shantou\,\ Guangdong";
$areanames{en}->{861306900} = "Changchun\,\ Jilin";
$areanames{en}->{861306901} = "Changchun\,\ Jilin";
$areanames{en}->{861306902} = "Siping\,\ Jilin";
$areanames{en}->{861306903} = "Siping\,\ Jilin";
$areanames{en}->{861306904} = "Changchun\,\ Jilin";
$areanames{en}->{861306905} = "Songyuan\,\ Jilin";
$areanames{en}->{861306906} = "Songyuan\,\ Jilin";
$areanames{en}->{861306907} = "Tonghua\,\ Jilin";
$areanames{en}->{861306908} = "Yanbian\,\ Jilin";
$areanames{en}->{861306909} = "Yanbian\,\ Jilin";
$areanames{en}->{861306910} = "Changchun\,\ Jilin";
$areanames{en}->{861306911} = "Changchun\,\ Jilin";
$areanames{en}->{861306912} = "Changchun\,\ Jilin";
$areanames{en}->{861306913} = "Changchun\,\ Jilin";
$areanames{en}->{861306914} = "Changchun\,\ Jilin";
$areanames{en}->{861306915} = "Jilin\,\ Jilin";
$areanames{en}->{861306916} = "Jilin\,\ Jilin";
$areanames{en}->{861306917} = "Jilin\,\ Jilin";
$areanames{en}->{861306918} = "Jilin\,\ Jilin";
$areanames{en}->{861306919} = "Tonghua\,\ Jilin";
$areanames{en}->{861306920} = "Changchun\,\ Jilin";
$areanames{en}->{861306921} = "Changchun\,\ Jilin";
$areanames{en}->{861306922} = "Siping\,\ Jilin";
$areanames{en}->{861306923} = "Yanbian\,\ Jilin";
$areanames{en}->{861306924} = "Changchun\,\ Jilin";
$areanames{en}->{861306925} = "Songyuan\,\ Jilin";
$areanames{en}->{861306926} = "Songyuan\,\ Jilin";
$areanames{en}->{861306927} = "Tonghua\,\ Jilin";
$areanames{en}->{861306928} = "Siping\,\ Jilin";
$areanames{en}->{861306929} = "Tonghua\,\ Jilin";
$areanames{en}->{861306930} = "Kaifeng\,\ Henan";
$areanames{en}->{861306931} = "Kaifeng\,\ Henan";
$areanames{en}->{861306932} = "Kaifeng\,\ Henan";
$areanames{en}->{861306933} = "Kaifeng\,\ Henan";
$areanames{en}->{861306934} = "Kaifeng\,\ Henan";
$areanames{en}->{861306935} = "Xinxiang\,\ Henan";
$areanames{en}->{861306936} = "Xinxiang\,\ Henan";
$areanames{en}->{861306937} = "Xinxiang\,\ Henan";
$areanames{en}->{861306938} = "Xinxiang\,\ Henan";
$areanames{en}->{861306939} = "Xinxiang\,\ Henan";
$areanames{en}->{86130694} = "Jiaozuo\,\ Henan";
$areanames{en}->{861306950} = "Xuchang\,\ Henan";
$areanames{en}->{861306951} = "Xuchang\,\ Henan";
$areanames{en}->{861306952} = "Xuchang\,\ Henan";
$areanames{en}->{861306953} = "Xuchang\,\ Henan";
$areanames{en}->{861306954} = "Xuchang\,\ Henan";
$areanames{en}->{861306955} = "Luohe\,\ Henan";
$areanames{en}->{861306956} = "Luohe\,\ Henan";
$areanames{en}->{861306957} = "Luohe\,\ Henan";
$areanames{en}->{861306958} = "Luohe\,\ Henan";
$areanames{en}->{861306959} = "Luohe\,\ Henan";
$areanames{en}->{86130696} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861306963} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861306968} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861306970} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861306971} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861306972} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861306973} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861306974} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861306975} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861306976} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861306977} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861306978} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861306979} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861306980} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861306981} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861306982} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861306983} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861306984} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861306985} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861306986} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861306987} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861306988} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861306989} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861306990} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861306991} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861306992} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861306993} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861306994} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861306995} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861306996} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861306997} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861306998} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861306999} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861307000} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861307001} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861307002} = "Aksu\,\ Xinjiang";
$areanames{en}->{861307003} = "Aksu\,\ Xinjiang";
$areanames{en}->{861307004} = "Kashi\,\ Xinjiang";
$areanames{en}->{861307005} = "Kashi\,\ Xinjiang";
$areanames{en}->{861307006} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861307007} = "Hotan\,\ Xinjiang";
$areanames{en}->{861307008} = "Hotan\,\ Xinjiang";
$areanames{en}->{861307009} = "Shihezi\,\ Xinjiang";
$areanames{en}->{86130701} = "Beijing";
$areanames{en}->{86130702} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861307030} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861307031} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861307032} = "Altay\,\ Xinjiang";
$areanames{en}->{861307033} = "Altay\,\ Xinjiang";
$areanames{en}->{861307034} = "Turpan\,\ Xinjiang";
$areanames{en}->{861307035} = "Ili\,\ Xinjiang";
$areanames{en}->{861307036} = "Ili\,\ Xinjiang";
$areanames{en}->{861307037} = "Karamay\,\ Xinjiang";
$areanames{en}->{861307038} = "Changji\,\ Xinjiang";
$areanames{en}->{861307039} = "Karamay\,\ Xinjiang";
$areanames{en}->{86130704} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861307046} = "Karamay\,\ Xinjiang";
$areanames{en}->{861307047} = "Ili\,\ Xinjiang";
$areanames{en}->{861307048} = "Hami\,\ Xinjiang";
$areanames{en}->{861307049} = "Ili\,\ Xinjiang";
$areanames{en}->{86130705} = "Baoding\,\ Hebei";
$areanames{en}->{86130706} = "Zibo\,\ Shandong";
$areanames{en}->{86130707} = "Weifang\,\ Shandong";
$areanames{en}->{86130708} = "Qingdao\,\ Shandong";
$areanames{en}->{86130709} = "Dongguan\,\ Guangdong";
$areanames{en}->{86130710} = "Zhengzhou\,\ Henan";
$areanames{en}->{86130711} = "Beijing";
$areanames{en}->{86130712} = "Wuhan\,\ Hubei";
$areanames{en}->{86130713} = "Dongguan\,\ Guangdong";
$areanames{en}->{86130714} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86130715} = "Shanwei\,\ Guangdong";
$areanames{en}->{86130716} = "Maoming\,\ Guangdong";
$areanames{en}->{86130717} = "Pingdingshan\,\ Henan";
$areanames{en}->{86130718} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130719} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130720} = "Tianjin";
$areanames{en}->{86130721} = "Shanghai";
$areanames{en}->{86130722} = "Tianjin";
$areanames{en}->{86130723} = "Chongqing";
$areanames{en}->{86130724} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130725} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86130726} = "Xinxiang\,\ Henan";
$areanames{en}->{86130727} = "Wuhan\,\ Hubei";
$areanames{en}->{86130728} = "Chengdu\,\ Sichuan";
$areanames{en}->{86130729} = "XiAn\,\ Shaanxi";
$areanames{en}->{86130730} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130731} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86130732} = "Nantong\,\ Jiangsu";
$areanames{en}->{86130733} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86130734} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86130735} = "Taiyuan\,\ Shanxi";
$areanames{en}->{86130736} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130737} = "Zhengzhou\,\ Henan";
$areanames{en}->{86130738} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86130739} = "Ningde\,\ Fujian";
$areanames{en}->{86130740} = "Anqing\,\ Anhui";
$areanames{en}->{86130741} = "Dalian\,\ Liaoning";
$areanames{en}->{86130742} = "Foshan\,\ Guangdong";
$areanames{en}->{86130743} = "Changchun\,\ Jilin";
$areanames{en}->{86130744} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{86130745} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130746} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130747} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{86130748} = "Xiamen\,\ Fujian";
$areanames{en}->{86130749} = "Quanzhou\,\ Fujian";
$areanames{en}->{861307494} = "Xinyang\,\ Henan";
$areanames{en}->{86130750} = "Fuyang\,\ Anhui";
$areanames{en}->{861307501} = "Bozhou\,\ Anhui";
$areanames{en}->{861307503} = "Bozhou\,\ Anhui";
$areanames{en}->{861307504} = "Bozhou\,\ Anhui";
$areanames{en}->{861307507} = "Bozhou\,\ Anhui";
$areanames{en}->{86130751} = "Meizhou\,\ Guangdong";
$areanames{en}->{86130752} = "Huizhou\,\ Guangdong";
$areanames{en}->{86130753} = "Jinan\,\ Shandong";
$areanames{en}->{86130754} = "Chongqing";
$areanames{en}->{86130755} = "Hefei\,\ Anhui";
$areanames{en}->{86130756} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86130757} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130758} = "Fuzhou\,\ Fujian";
$areanames{en}->{86130759} = "Fuzhou\,\ Fujian";
$areanames{en}->{86130760} = "Chengdu\,\ Sichuan";
$areanames{en}->{86130761} = "Heyuan\,\ Guangdong";
$areanames{en}->{86130762} = "Shaoguan\,\ Guangdong";
$areanames{en}->{86130763} = "Shantou\,\ Guangdong";
$areanames{en}->{86130764} = "Chaozhou\,\ Guangdong";
$areanames{en}->{86130765} = "Jieyang\,\ Guangdong";
$areanames{en}->{86130766} = "Qingyuan\,\ Guangdong";
$areanames{en}->{86130767} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130768} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130769} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130770} = "Zhuzhou\,\ Hunan";
$areanames{en}->{86130771} = "Yueyang\,\ Hunan";
$areanames{en}->{86130772} = "Changde\,\ Hunan";
$areanames{en}->{86130773} = "Changsha\,\ Hunan";
$areanames{en}->{86130774} = "Foshan\,\ Guangdong";
$areanames{en}->{86130775} = "Yunfu\,\ Guangdong";
$areanames{en}->{86130776} = "Guilin\,\ Guangxi";
$areanames{en}->{86130777} = "Nanning\,\ Guangxi";
$areanames{en}->{86130778} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86130779} = "Nanchang\,\ Jiangxi";
$areanames{en}->{86130780} = "Liuzhou\,\ Guangxi";
$areanames{en}->{86130781} = "Foshan\,\ Guangdong";
$areanames{en}->{86130782} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86130783} = "Yangjiang\,\ Guangdong";
$areanames{en}->{86130784} = "Foshan\,\ Guangdong";
$areanames{en}->{86130785} = "Guiyang\,\ Guizhou";
$areanames{en}->{86130786} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86130787} = "Kunming\,\ Yunnan";
$areanames{en}->{86130788} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86130789} = "Haikou\,\ Hainan";
$areanames{en}->{86130790} = "Dazhou\,\ Sichuan";
$areanames{en}->{86130791} = "Luzhou\,\ Sichuan";
$areanames{en}->{86130792} = "Shenyang\,\ Liaoning";
$areanames{en}->{861307930} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861307931} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861307932} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861307933} = "Wuwei\,\ Gansu";
$areanames{en}->{861307934} = "Dingxi\,\ Gansu";
$areanames{en}->{861307935} = "Wuwei\,\ Gansu";
$areanames{en}->{861307936} = "Dingxi\,\ Gansu";
$areanames{en}->{861307937} = "Wuwei\,\ Gansu";
$areanames{en}->{861307938} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861307939} = "Wuwei\,\ Gansu";
$areanames{en}->{86130794} = "Yingkou\,\ Liaoning";
$areanames{en}->{861307950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861307951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861307952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861307953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861307954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861307955} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861307956} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861307957} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861307958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861307959} = "Yinchuan\,\ Ningxia";
$areanames{en}->{86130796} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{86130797} = "Jilin\,\ Jilin";
$areanames{en}->{86130798} = "Dalian\,\ Liaoning";
$areanames{en}->{86130799} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861308000} = "Tonghua\,\ Jilin";
$areanames{en}->{861308001} = "Changchun\,\ Jilin";
$areanames{en}->{861308002} = "Changchun\,\ Jilin";
$areanames{en}->{861308003} = "Changchun\,\ Jilin";
$areanames{en}->{861308004} = "Changchun\,\ Jilin";
$areanames{en}->{861308005} = "Tonghua\,\ Jilin";
$areanames{en}->{861308006} = "Baicheng\,\ Jilin";
$areanames{en}->{861308007} = "Songyuan\,\ Jilin";
$areanames{en}->{861308008} = "Songyuan\,\ Jilin";
$areanames{en}->{861308009} = "Songyuan\,\ Jilin";
$areanames{en}->{861308010} = "Puyang\,\ Henan";
$areanames{en}->{861308011} = "Puyang\,\ Henan";
$areanames{en}->{861308012} = "Puyang\,\ Henan";
$areanames{en}->{861308013} = "Luohe\,\ Henan";
$areanames{en}->{861308014} = "Luohe\,\ Henan";
$areanames{en}->{861308015} = "Xuchang\,\ Henan";
$areanames{en}->{861308016} = "Xuchang\,\ Henan";
$areanames{en}->{861308017} = "Xuchang\,\ Henan";
$areanames{en}->{861308018} = "Xuchang\,\ Henan";
$areanames{en}->{861308019} = "Xuchang\,\ Henan";
$areanames{en}->{861308020} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308021} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308022} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308023} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861308024} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861308025} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861308026} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308027} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308028} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861308029} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861308030} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861308031} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861308032} = "Datong\,\ Shanxi";
$areanames{en}->{861308033} = "Yangquan\,\ Shanxi";
$areanames{en}->{861308034} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861308035} = "Changzhi\,\ Shanxi";
$areanames{en}->{861308036} = "Jincheng\,\ Shanxi";
$areanames{en}->{861308037} = "Linfen\,\ Shanxi";
$areanames{en}->{861308038} = "Lüliang\,\ Shanxi";
$areanames{en}->{861308039} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861308040} = "Handan\,\ Hebei";
$areanames{en}->{861308041} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861308042} = "Baoding\,\ Hebei";
$areanames{en}->{861308043} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861308044} = "Handan\,\ Hebei";
$areanames{en}->{861308045} = "Tangshan\,\ Hebei";
$areanames{en}->{861308046} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861308047} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308048} = "Tangshan\,\ Hebei";
$areanames{en}->{861308049} = "Baoding\,\ Hebei";
$areanames{en}->{86130805} = "Changsha\,\ Hunan";
$areanames{en}->{861308057} = "Yiyang\,\ Hunan";
$areanames{en}->{861308058} = "Yiyang\,\ Hunan";
$areanames{en}->{861308059} = "Yiyang\,\ Hunan";
$areanames{en}->{86130806} = "Wuhan\,\ Hubei";
$areanames{en}->{86130807} = "Shenyang\,\ Liaoning";
$areanames{en}->{86130808} = "Shenyang\,\ Liaoning";
$areanames{en}->{861308090} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308091} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308092} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308093} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308094} = "YanAn\,\ Shaanxi";
$areanames{en}->{861308095} = "YanAn\,\ Shaanxi";
$areanames{en}->{861308096} = "Yulin\,\ Shaanxi";
$areanames{en}->{861308097} = "Yulin\,\ Shaanxi";
$areanames{en}->{861308098} = "Yulin\,\ Shaanxi";
$areanames{en}->{861308099} = "Shangluo\,\ Shaanxi";
$areanames{en}->{86130810} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86130811} = "Tangshan\,\ Hebei";
$areanames{en}->{861308110} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861308111} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861308112} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861308120} = "Anshan\,\ Liaoning";
$areanames{en}->{861308121} = "Anshan\,\ Liaoning";
$areanames{en}->{861308122} = "Anshan\,\ Liaoning";
$areanames{en}->{861308123} = "Anshan\,\ Liaoning";
$areanames{en}->{861308124} = "Anshan\,\ Liaoning";
$areanames{en}->{861308125} = "Dandong\,\ Liaoning";
$areanames{en}->{861308126} = "Dandong\,\ Liaoning";
$areanames{en}->{861308127} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861308128} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861308129} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861308130} = "Fushun\,\ Liaoning";
$areanames{en}->{861308131} = "Fushun\,\ Liaoning";
$areanames{en}->{861308132} = "Fushun\,\ Liaoning";
$areanames{en}->{861308133} = "Fushun\,\ Liaoning";
$areanames{en}->{861308134} = "Fushun\,\ Liaoning";
$areanames{en}->{861308135} = "Benxi\,\ Liaoning";
$areanames{en}->{861308136} = "Benxi\,\ Liaoning";
$areanames{en}->{861308137} = "Benxi\,\ Liaoning";
$areanames{en}->{861308138} = "Benxi\,\ Liaoning";
$areanames{en}->{861308139} = "Benxi\,\ Liaoning";
$areanames{en}->{861308140} = "Dongying\,\ Shandong";
$areanames{en}->{861308141} = "Dongying\,\ Shandong";
$areanames{en}->{861308142} = "Jinan\,\ Shandong";
$areanames{en}->{861308143} = "Weifang\,\ Shandong";
$areanames{en}->{861308144} = "Weifang\,\ Shandong";
$areanames{en}->{861308145} = "Weifang\,\ Shandong";
$areanames{en}->{861308146} = "Liaocheng\,\ Shandong";
$areanames{en}->{861308147} = "TaiAn\,\ Shandong";
$areanames{en}->{861308148} = "Heze\,\ Shandong";
$areanames{en}->{861308149} = "Weihai\,\ Shandong";
$areanames{en}->{861308150} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308151} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308152} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308153} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308154} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308155} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861308156} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861308157} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308158} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861308159} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861308160} = "Yantai\,\ Shandong";
$areanames{en}->{861308161} = "Yantai\,\ Shandong";
$areanames{en}->{861308162} = "Yantai\,\ Shandong";
$areanames{en}->{861308163} = "Yantai\,\ Shandong";
$areanames{en}->{861308164} = "Yantai\,\ Shandong";
$areanames{en}->{861308165} = "Weifang\,\ Shandong";
$areanames{en}->{861308166} = "Weifang\,\ Shandong";
$areanames{en}->{861308167} = "Weifang\,\ Shandong";
$areanames{en}->{861308168} = "Weifang\,\ Shandong";
$areanames{en}->{861308169} = "Weifang\,\ Shandong";
$areanames{en}->{861308170} = "Yingkou\,\ Liaoning";
$areanames{en}->{861308171} = "Yingkou\,\ Liaoning";
$areanames{en}->{861308172} = "Yingkou\,\ Liaoning";
$areanames{en}->{861308173} = "Yingkou\,\ Liaoning";
$areanames{en}->{861308174} = "Fuxin\,\ Liaoning";
$areanames{en}->{861308175} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861308176} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861308177} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861308178} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861308179} = "Tieling\,\ Liaoning";
$areanames{en}->{861308180} = "Hengshui\,\ Hebei";
$areanames{en}->{861308181} = "Hengshui\,\ Hebei";
$areanames{en}->{861308182} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861308183} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861308184} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861308185} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861308186} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861308187} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861308188} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861308189} = "Chengde\,\ Hebei";
$areanames{en}->{86130819} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86130820} = "Langfang\,\ Hebei";
$areanames{en}->{861308200} = "Xingtai\,\ Hebei";
$areanames{en}->{861308201} = "Xingtai\,\ Hebei";
$areanames{en}->{861308202} = "Xingtai\,\ Hebei";
$areanames{en}->{861308203} = "Xingtai\,\ Hebei";
$areanames{en}->{86130821} = "Handan\,\ Hebei";
$areanames{en}->{861308216} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308217} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308218} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308219} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308220} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861308221} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861308222} = "Panjin\,\ Liaoning";
$areanames{en}->{861308223} = "Panjin\,\ Liaoning";
$areanames{en}->{861308224} = "Huludao\,\ Liaoning";
$areanames{en}->{861308225} = "Anshan\,\ Liaoning";
$areanames{en}->{861308226} = "Anshan\,\ Liaoning";
$areanames{en}->{861308227} = "Fushun\,\ Liaoning";
$areanames{en}->{861308228} = "Fushun\,\ Liaoning";
$areanames{en}->{861308229} = "Yingkou\,\ Liaoning";
$areanames{en}->{86130823} = "Baoding\,\ Hebei";
$areanames{en}->{86130824} = "Shenyang\,\ Liaoning";
$areanames{en}->{861308250} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861308251} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861308252} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861308253} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861308254} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861308255} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861308256} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861308257} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861308258} = "Suqian\,\ Jiangsu";
$areanames{en}->{861308259} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861308260} = "Dongying\,\ Shandong";
$areanames{en}->{861308261} = "Dongying\,\ Shandong";
$areanames{en}->{861308262} = "Jining\,\ Shandong";
$areanames{en}->{861308263} = "Jining\,\ Shandong";
$areanames{en}->{861308264} = "Linyi\,\ Shandong";
$areanames{en}->{861308265} = "Linyi\,\ Shandong";
$areanames{en}->{861308266} = "Linyi\,\ Shandong";
$areanames{en}->{861308267} = "Weihai\,\ Shandong";
$areanames{en}->{861308268} = "Weihai\,\ Shandong";
$areanames{en}->{861308269} = "Heze\,\ Shandong";
$areanames{en}->{861308270} = "Zibo\,\ Shandong";
$areanames{en}->{861308271} = "Zibo\,\ Shandong";
$areanames{en}->{861308272} = "Binzhou\,\ Shandong";
$areanames{en}->{861308273} = "Jinan\,\ Shandong";
$areanames{en}->{861308274} = "Jinan\,\ Shandong";
$areanames{en}->{861308275} = "Jinan\,\ Shandong";
$areanames{en}->{861308276} = "Dezhou\,\ Shandong";
$areanames{en}->{861308277} = "TaiAn\,\ Shandong";
$areanames{en}->{861308278} = "Liaocheng\,\ Shandong";
$areanames{en}->{861308279} = "Rizhao\,\ Shandong";
$areanames{en}->{86130828} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861308286} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861308287} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861308288} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861308289} = "Lishui\,\ Zhejiang";
$areanames{en}->{86130829} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861308300} = "Hefei\,\ Anhui";
$areanames{en}->{861308301} = "Bengbu\,\ Anhui";
$areanames{en}->{861308302} = "Suzhou\,\ Anhui";
$areanames{en}->{861308303} = "Wuhu\,\ Anhui";
$areanames{en}->{861308304} = "Chizhou\,\ Anhui";
$areanames{en}->{861308305} = "Hefei\,\ Anhui";
$areanames{en}->{861308306} = "Hefei\,\ Anhui";
$areanames{en}->{861308307} = "Huainan\,\ Anhui";
$areanames{en}->{861308308} = "Hefei\,\ Anhui";
$areanames{en}->{861308309} = "Hefei\,\ Anhui";
$areanames{en}->{861308310} = "MaAnshan\,\ Anhui";
$areanames{en}->{861308311} = "MaAnshan\,\ Anhui";
$areanames{en}->{861308312} = "Xuancheng\,\ Anhui";
$areanames{en}->{861308313} = "Xuancheng\,\ Anhui";
$areanames{en}->{861308314} = "Chuzhou\,\ Anhui";
$areanames{en}->{861308315} = "Tongling\,\ Anhui";
$areanames{en}->{861308316} = "Anqing\,\ Anhui";
$areanames{en}->{861308317} = "Anqing\,\ Anhui";
$areanames{en}->{861308318} = "Anqing\,\ Anhui";
$areanames{en}->{861308319} = "Hefei\,\ Anhui";
$areanames{en}->{861308320} = "MaAnshan\,\ Anhui";
$areanames{en}->{861308321} = "Wuhu\,\ Anhui";
$areanames{en}->{861308322} = "Huangshan\,\ Anhui";
$areanames{en}->{861308323} = "Huangshan\,\ Anhui";
$areanames{en}->{861308324} = "Xuancheng\,\ Anhui";
$areanames{en}->{861308325} = "Tongling\,\ Anhui";
$areanames{en}->{861308326} = "Wuhu\,\ Anhui";
$areanames{en}->{861308327} = "Bengbu\,\ Anhui";
$areanames{en}->{861308328} = "Chizhou\,\ Anhui";
$areanames{en}->{861308329} = "Chizhou\,\ Anhui";
$areanames{en}->{861308330} = "Chuzhou\,\ Anhui";
$areanames{en}->{861308331} = "Chuzhou\,\ Anhui";
$areanames{en}->{861308332} = "Chuzhou\,\ Anhui";
$areanames{en}->{861308333} = "Chuzhou\,\ Anhui";
$areanames{en}->{861308334} = "Fuyang\,\ Anhui";
$areanames{en}->{861308335} = "Huaibei\,\ Anhui";
$areanames{en}->{861308336} = "Bozhou\,\ Anhui";
$areanames{en}->{861308337} = "Fuyang\,\ Anhui";
$areanames{en}->{861308338} = "Bozhou\,\ Anhui";
$areanames{en}->{861308339} = "Fuyang\,\ Anhui";
$areanames{en}->{86130834} = "Hefei\,\ Anhui";
$areanames{en}->{861308343} = "Tongling\,\ Anhui";
$areanames{en}->{861308346} = "Huainan\,\ Anhui";
$areanames{en}->{861308347} = "Fuyang\,\ Anhui";
$areanames{en}->{861308350} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861308351} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861308352} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861308353} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861308354} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861308355} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861308356} = "Nantong\,\ Jiangsu";
$areanames{en}->{861308357} = "Nantong\,\ Jiangsu";
$areanames{en}->{861308358} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861308359} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861308360} = "Zhengzhou\,\ Henan";
$areanames{en}->{861308361} = "Xuchang\,\ Henan";
$areanames{en}->{861308362} = "Luoyang\,\ Henan";
$areanames{en}->{861308363} = "Luoyang\,\ Henan";
$areanames{en}->{861308364} = "Luoyang\,\ Henan";
$areanames{en}->{861308365} = "Luoyang\,\ Henan";
$areanames{en}->{861308366} = "Zhengzhou\,\ Henan";
$areanames{en}->{861308367} = "Jiaozuo\,\ Henan";
$areanames{en}->{861308368} = "Jiaozuo\,\ Henan";
$areanames{en}->{861308369} = "Zhengzhou\,\ Henan";
$areanames{en}->{861308370} = "Shangqiu\,\ Henan";
$areanames{en}->{861308371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861308372} = "Anyang\,\ Henan";
$areanames{en}->{861308373} = "Xinxiang\,\ Henan";
$areanames{en}->{861308374} = "Xuchang\,\ Henan";
$areanames{en}->{861308375} = "Pingdingshan\,\ Henan";
$areanames{en}->{861308376} = "Xinyang\,\ Henan";
$areanames{en}->{861308377} = "Nanyang\,\ Henan";
$areanames{en}->{861308378} = "Kaifeng\,\ Henan";
$areanames{en}->{861308379} = "Luoyang\,\ Henan";
$areanames{en}->{861308380} = "Xinxiang\,\ Henan";
$areanames{en}->{861308381} = "Xinxiang\,\ Henan";
$areanames{en}->{861308382} = "Xinxiang\,\ Henan";
$areanames{en}->{861308383} = "Jiaozuo\,\ Henan";
$areanames{en}->{861308384} = "Jiaozuo\,\ Henan";
$areanames{en}->{861308385} = "Anyang\,\ Henan";
$areanames{en}->{861308386} = "Anyang\,\ Henan";
$areanames{en}->{861308387} = "Anyang\,\ Henan";
$areanames{en}->{861308388} = "Kaifeng\,\ Henan";
$areanames{en}->{861308389} = "Puyang\,\ Henan";
$areanames{en}->{861308390} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861308391} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861308392} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861308393} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308394} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861308395} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861308396} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861308397} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861308398} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861308399} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861308400} = "Suzhou\,\ Anhui";
$areanames{en}->{861308401} = "Suzhou\,\ Anhui";
$areanames{en}->{861308402} = "Fuyang\,\ Anhui";
$areanames{en}->{861308403} = "LuAn\,\ Anhui";
$areanames{en}->{861308404} = "LuAn\,\ Anhui";
$areanames{en}->{861308405} = "Huaibei\,\ Anhui";
$areanames{en}->{861308406} = "Bozhou\,\ Anhui";
$areanames{en}->{861308407} = "Bengbu\,\ Anhui";
$areanames{en}->{861308408} = "Bengbu\,\ Anhui";
$areanames{en}->{861308409} = "Xuancheng\,\ Anhui";
$areanames{en}->{86130841} = "Dalian\,\ Liaoning";
$areanames{en}->{861308420} = "Xinxiang\,\ Henan";
$areanames{en}->{861308421} = "Xinxiang\,\ Henan";
$areanames{en}->{861308422} = "Hebi\,\ Henan";
$areanames{en}->{861308423} = "Hebi\,\ Henan";
$areanames{en}->{861308424} = "Kaifeng\,\ Henan";
$areanames{en}->{861308425} = "Luohe\,\ Henan";
$areanames{en}->{861308426} = "Luohe\,\ Henan";
$areanames{en}->{861308427} = "Luohe\,\ Henan";
$areanames{en}->{861308428} = "Zhoukou\,\ Henan";
$areanames{en}->{861308429} = "Zhoukou\,\ Henan";
$areanames{en}->{861308430} = "YaAn\,\ Sichuan";
$areanames{en}->{861308431} = "Dazhou\,\ Sichuan";
$areanames{en}->{861308432} = "Bazhong\,\ Sichuan";
$areanames{en}->{861308433} = "Nanchong\,\ Sichuan";
$areanames{en}->{861308434} = "Suining\,\ Sichuan";
$areanames{en}->{861308435} = "GuangAn\,\ Sichuan";
$areanames{en}->{861308436} = "Liangshan\,\ Sichuan";
$areanames{en}->{861308437} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861308438} = "Deyang\,\ Sichuan";
$areanames{en}->{861308439} = "Panzhihua\,\ Sichuan";
$areanames{en}->{86130844} = "Chengdu\,\ Sichuan";
$areanames{en}->{861308448} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308449} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308450} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308451} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308452} = "Cangzhou\,\ Hebei";
$areanames{en}->{861308453} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861308454} = "Hengshui\,\ Hebei";
$areanames{en}->{861308455} = "Langfang\,\ Hebei";
$areanames{en}->{861308456} = "Xingtai\,\ Hebei";
$areanames{en}->{861308457} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861308458} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861308459} = "Chengde\,\ Hebei";
$areanames{en}->{861308460} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861308461} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308462} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308463} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308464} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861308465} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861308466} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861308467} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861308468} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861308469} = "Lishui\,\ Zhejiang";
$areanames{en}->{861308470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861308471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861308474} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861308475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861308476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861308478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861308479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861308480} = "Ankang\,\ Shaanxi";
$areanames{en}->{861308481} = "Ankang\,\ Shaanxi";
$areanames{en}->{861308482} = "Yulin\,\ Shaanxi";
$areanames{en}->{861308483} = "Yulin\,\ Shaanxi";
$areanames{en}->{861308484} = "Yulin\,\ Shaanxi";
$areanames{en}->{861308485} = "YanAn\,\ Shaanxi";
$areanames{en}->{861308486} = "YanAn\,\ Shaanxi";
$areanames{en}->{861308487} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861308488} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861308489} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861308490} = "Baise\,\ Guangxi";
$areanames{en}->{861308491} = "Nanning\,\ Guangxi";
$areanames{en}->{861308492} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861308493} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861308494} = "Hechi\,\ Guangxi";
$areanames{en}->{861308495} = "Guigang\,\ Guangxi";
$areanames{en}->{861308496} = "Yulin\,\ Guangxi";
$areanames{en}->{861308497} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861308498} = "Nanning\,\ Guangxi";
$areanames{en}->{861308499} = "Nanning\,\ Guangxi";
$areanames{en}->{861308500} = "Hefei\,\ Anhui";
$areanames{en}->{861308501} = "Suzhou\,\ Anhui";
$areanames{en}->{861308502} = "LuAn\,\ Anhui";
$areanames{en}->{861308503} = "LuAn\,\ Anhui";
$areanames{en}->{861308504} = "LuAn\,\ Anhui";
$areanames{en}->{861308505} = "Hefei\,\ Anhui";
$areanames{en}->{861308506} = "Hefei\,\ Anhui";
$areanames{en}->{861308507} = "Huaibei\,\ Anhui";
$areanames{en}->{861308508} = "Huainan\,\ Anhui";
$areanames{en}->{861308509} = "LuAn\,\ Anhui";
$areanames{en}->{861308510} = "Jingzhou\,\ Hubei";
$areanames{en}->{861308511} = "Jingzhou\,\ Hubei";
$areanames{en}->{861308512} = "Wuhan\,\ Hubei";
$areanames{en}->{861308513} = "Wuhan\,\ Hubei";
$areanames{en}->{861308514} = "Wuhan\,\ Hubei";
$areanames{en}->{861308515} = "Yichang\,\ Hubei";
$areanames{en}->{861308516} = "Yichang\,\ Hubei";
$areanames{en}->{861308517} = "Jingmen\,\ Hubei";
$areanames{en}->{861308518} = "Jingmen\,\ Hubei";
$areanames{en}->{861308519} = "Enshi\,\ Hubei";
$areanames{en}->{861308520} = "Huangshi\,\ Hubei";
$areanames{en}->{861308521} = "Huanggang\,\ Hubei";
$areanames{en}->{861308522} = "Huanggang\,\ Hubei";
$areanames{en}->{861308523} = "Ezhou\,\ Hubei";
$areanames{en}->{861308524} = "Suizhou\,\ Hubei";
$areanames{en}->{861308525} = "Suizhou\,\ Hubei";
$areanames{en}->{861308526} = "Shiyan\,\ Hubei";
$areanames{en}->{861308527} = "Xianning\,\ Hubei";
$areanames{en}->{861308528} = "Xiangfan\,\ Hubei";
$areanames{en}->{861308529} = "Xiangfan\,\ Hubei";
$areanames{en}->{86130853} = "Kunming\,\ Yunnan";
$areanames{en}->{861308530} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861308531} = "Puer\,\ Yunnan";
$areanames{en}->{861308532} = "Puer\,\ Yunnan";
$areanames{en}->{861308540} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861308541} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861308542} = "Yongzhou\,\ Hunan";
$areanames{en}->{861308543} = "Yongzhou\,\ Hunan";
$areanames{en}->{861308544} = "Yongzhou\,\ Hunan";
$areanames{en}->{861308545} = "Xiangxi\,\ Hunan";
$areanames{en}->{861308546} = "Xiangxi\,\ Hunan";
$areanames{en}->{861308547} = "Huaihua\,\ Hunan";
$areanames{en}->{861308548} = "Loudi\,\ Hunan";
$areanames{en}->{861308549} = "Loudi\,\ Hunan";
$areanames{en}->{861308550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861308551} = "Hefei\,\ Anhui";
$areanames{en}->{861308552} = "Bengbu\,\ Anhui";
$areanames{en}->{861308553} = "Wuhu\,\ Anhui";
$areanames{en}->{861308554} = "Huainan\,\ Anhui";
$areanames{en}->{861308555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861308556} = "Anqing\,\ Anhui";
$areanames{en}->{861308557} = "Suzhou\,\ Anhui";
$areanames{en}->{861308558} = "Fuyang\,\ Anhui";
$areanames{en}->{861308559} = "Huangshan\,\ Anhui";
$areanames{en}->{861308560} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861308561} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861308562} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861308563} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861308564} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861308565} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861308566} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861308567} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861308568} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861308569} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861308570} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861308571} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861308572} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861308573} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861308574} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861308575} = "Shantou\,\ Guangdong";
$areanames{en}->{861308576} = "Shantou\,\ Guangdong";
$areanames{en}->{861308577} = "Shantou\,\ Guangdong";
$areanames{en}->{861308578} = "Shantou\,\ Guangdong";
$areanames{en}->{861308579} = "Shantou\,\ Guangdong";
$areanames{en}->{861308580} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861308581} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861308582} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861308583} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861308584} = "Xingtai\,\ Hebei";
$areanames{en}->{861308585} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861308586} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861308587} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861308588} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861308589} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861308590} = "Baiyin\,\ Gansu";
$areanames{en}->{861308591} = "Linxia\,\ Gansu";
$areanames{en}->{861308592} = "Zhangye\,\ Gansu";
$areanames{en}->{861308593} = "Qingyang\,\ Gansu";
$areanames{en}->{861308594} = "Tianshui\,\ Gansu";
$areanames{en}->{861308595} = "Wuwei\,\ Gansu";
$areanames{en}->{861308596} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861308597} = "Tianshui\,\ Gansu";
$areanames{en}->{861308598} = "Tianshui\,\ Gansu";
$areanames{en}->{861308599} = "Pingliang\,\ Gansu";
$areanames{en}->{86130860} = "Haikou\,\ Hainan";
$areanames{en}->{861308610} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861308611} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861308612} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861308613} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861308614} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861308615} = "Yichun\,\ Jiangxi";
$areanames{en}->{861308616} = "JiAn\,\ Jiangxi";
$areanames{en}->{861308617} = "Yichun\,\ Jiangxi";
$areanames{en}->{861308618} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861308619} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861308620} = "Haixi\,\ Qinghai";
$areanames{en}->{861308621} = "Haixi\,\ Qinghai";
$areanames{en}->{861308622} = "Haixi\,\ Qinghai";
$areanames{en}->{861308623} = "Hainan\,\ Qinghai";
$areanames{en}->{861308624} = "Haibei\,\ Qinghai";
$areanames{en}->{861308625} = "Xining\,\ Qinghai";
$areanames{en}->{861308626} = "Xining\,\ Qinghai";
$areanames{en}->{861308627} = "Xining\,\ Qinghai";
$areanames{en}->{861308628} = "Xining\,\ Qinghai";
$areanames{en}->{861308629} = "Xining\,\ Qinghai";
$areanames{en}->{861308630} = "YaAn\,\ Sichuan";
$areanames{en}->{861308631} = "YaAn\,\ Sichuan";
$areanames{en}->{861308632} = "Dazhou\,\ Sichuan";
$areanames{en}->{861308633} = "Dazhou\,\ Sichuan";
$areanames{en}->{861308634} = "Bazhong\,\ Sichuan";
$areanames{en}->{861308635} = "Garze\,\ Sichuan";
$areanames{en}->{861308636} = "Nanchong\,\ Sichuan";
$areanames{en}->{861308637} = "Nanchong\,\ Sichuan";
$areanames{en}->{861308638} = "Suining\,\ Sichuan";
$areanames{en}->{861308639} = "GuangAn\,\ Sichuan";
$areanames{en}->{861308640} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308641} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308642} = "Zigong\,\ Sichuan";
$areanames{en}->{861308643} = "Neijiang\,\ Sichuan";
$areanames{en}->{861308644} = "Luzhou\,\ Sichuan";
$areanames{en}->{861308645} = "Leshan\,\ Sichuan";
$areanames{en}->{861308646} = "Leshan\,\ Sichuan";
$areanames{en}->{861308647} = "Meishan\,\ Sichuan";
$areanames{en}->{861308648} = "Meishan\,\ Sichuan";
$areanames{en}->{861308649} = "Liangshan\,\ Sichuan";
$areanames{en}->{861308650} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861308651} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861308652} = "Neijiang\,\ Sichuan";
$areanames{en}->{861308653} = "Aba\,\ Sichuan";
$areanames{en}->{861308654} = "Yibin\,\ Sichuan";
$areanames{en}->{861308655} = "Yibin\,\ Sichuan";
$areanames{en}->{861308656} = "Yibin\,\ Sichuan";
$areanames{en}->{861308657} = "Ziyang\,\ Sichuan";
$areanames{en}->{861308658} = "Ziyang\,\ Sichuan";
$areanames{en}->{861308659} = "Luzhou\,\ Sichuan";
$areanames{en}->{86130866} = "Chengdu\,\ Sichuan";
$areanames{en}->{861308670} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861308671} = "Nanning\,\ Guangxi";
$areanames{en}->{861308672} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861308673} = "Guilin\,\ Guangxi";
$areanames{en}->{861308674} = "Baise\,\ Guangxi";
$areanames{en}->{861308675} = "Yulin\,\ Guangxi";
$areanames{en}->{861308676} = "Hezhou\,\ Guangxi";
$areanames{en}->{861308677} = "Guigang\,\ Guangxi";
$areanames{en}->{861308678} = "Hechi\,\ Guangxi";
$areanames{en}->{861308679} = "Beihai\,\ Guangxi";
$areanames{en}->{86130868} = "Changchun\,\ Jilin";
$areanames{en}->{861308690} = "Anshun\,\ Guizhou";
$areanames{en}->{861308691} = "Qiannan\,\ Guizhou";
$areanames{en}->{861308692} = "Qiannan\,\ Guizhou";
$areanames{en}->{861308693} = "Qiannan\,\ Guizhou";
$areanames{en}->{861308694} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861308695} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861308696} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861308697} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861308698} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861308699} = "Tongren\,\ Guizhou";
$areanames{en}->{861308700} = "Kaifeng\,\ Henan";
$areanames{en}->{861308701} = "Xinyang\,\ Henan";
$areanames{en}->{861308702} = "Shangqiu\,\ Henan";
$areanames{en}->{861308703} = "Nanyang\,\ Henan";
$areanames{en}->{861308704} = "Pingdingshan\,\ Henan";
$areanames{en}->{861308705} = "Pingdingshan\,\ Henan";
$areanames{en}->{861308706} = "Pingdingshan\,\ Henan";
$areanames{en}->{861308707} = "Sanmenxia\,\ Henan";
$areanames{en}->{861308708} = "Zhumadian\,\ Henan";
$areanames{en}->{861308709} = "Zhumadian\,\ Henan";
$areanames{en}->{861308710} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308711} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308712} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861308713} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861308714} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861308715} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861308716} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861308717} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861308718} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861308719} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861308720} = "Huaihua\,\ Hunan";
$areanames{en}->{861308721} = "Xiangtan\,\ Hunan";
$areanames{en}->{861308722} = "Xiangtan\,\ Hunan";
$areanames{en}->{861308723} = "Xiangtan\,\ Hunan";
$areanames{en}->{861308724} = "Hengyang\,\ Hunan";
$areanames{en}->{861308725} = "Chenzhou\,\ Hunan";
$areanames{en}->{861308726} = "Shaoyang\,\ Hunan";
$areanames{en}->{861308727} = "Yiyang\,\ Hunan";
$areanames{en}->{861308728} = "Shaoyang\,\ Hunan";
$areanames{en}->{861308729} = "Huaihua\,\ Hunan";
$areanames{en}->{861308730} = "Yueyang\,\ Hunan";
$areanames{en}->{861308731} = "Changsha\,\ Hunan";
$areanames{en}->{861308732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861308733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861308734} = "Hengyang\,\ Hunan";
$areanames{en}->{861308735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861308736} = "Changde\,\ Hunan";
$areanames{en}->{861308737} = "Yiyang\,\ Hunan";
$areanames{en}->{861308738} = "Loudi\,\ Hunan";
$areanames{en}->{861308739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861308740} = "Dali\,\ Yunnan";
$areanames{en}->{861308741} = "Dali\,\ Yunnan";
$areanames{en}->{861308742} = "Deqen\,\ Yunnan";
$areanames{en}->{861308743} = "Yuxi\,\ Yunnan";
$areanames{en}->{861308744} = "Nujiang\,\ Yunnan";
$areanames{en}->{861308745} = "Honghe\,\ Yunnan";
$areanames{en}->{861308746} = "Wenshan\,\ Yunnan";
$areanames{en}->{861308747} = "Qujing\,\ Yunnan";
$areanames{en}->{861308748} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861308749} = "Baoshan\,\ Yunnan";
$areanames{en}->{86130875} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308760} = "Weinan\,\ Shaanxi";
$areanames{en}->{861308761} = "Weinan\,\ Shaanxi";
$areanames{en}->{861308762} = "Weinan\,\ Shaanxi";
$areanames{en}->{861308763} = "Weinan\,\ Shaanxi";
$areanames{en}->{861308764} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861308765} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861308766} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861308767} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861308768} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861308769} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861308770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861308771} = "Nanning\,\ Guangxi";
$areanames{en}->{861308772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861308773} = "Guilin\,\ Guangxi";
$areanames{en}->{861308774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861308775} = "Yulin\,\ Guangxi";
$areanames{en}->{861308776} = "Baise\,\ Guangxi";
$areanames{en}->{861308777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861308778} = "Hechi\,\ Guangxi";
$areanames{en}->{861308779} = "Beihai\,\ Guangxi";
$areanames{en}->{86130878} = "Guiyang\,\ Guizhou";
$areanames{en}->{861308786} = "Bijie\,\ Guizhou";
$areanames{en}->{861308787} = "Zunyi\,\ Guizhou";
$areanames{en}->{861308788} = "Zunyi\,\ Guizhou";
$areanames{en}->{861308789} = "Zunyi\,\ Guizhou";
$areanames{en}->{861308790} = "Nanning\,\ Guangxi";
$areanames{en}->{861308791} = "Nanning\,\ Guangxi";
$areanames{en}->{861308792} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861308793} = "Guilin\,\ Guangxi";
$areanames{en}->{861308794} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861308795} = "Yulin\,\ Guangxi";
$areanames{en}->{861308796} = "Nanning\,\ Guangxi";
$areanames{en}->{861308797} = "Nanning\,\ Guangxi";
$areanames{en}->{861308798} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861308799} = "Nanning\,\ Guangxi";
$areanames{en}->{86130880} = "Chengdu\,\ Sichuan";
$areanames{en}->{861308810} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308811} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308812} = "GuangAn\,\ Sichuan";
$areanames{en}->{861308813} = "Nanchong\,\ Sichuan";
$areanames{en}->{861308814} = "Dazhou\,\ Sichuan";
$areanames{en}->{861308815} = "Dazhou\,\ Sichuan";
$areanames{en}->{861308816} = "Suining\,\ Sichuan";
$areanames{en}->{861308817} = "Luzhou\,\ Sichuan";
$areanames{en}->{861308818} = "Deyang\,\ Sichuan";
$areanames{en}->{861308819} = "Nanchong\,\ Sichuan";
$areanames{en}->{861308820} = "Deyang\,\ Sichuan";
$areanames{en}->{861308821} = "Bazhong\,\ Sichuan";
$areanames{en}->{861308822} = "Neijiang\,\ Sichuan";
$areanames{en}->{861308823} = "Neijiang\,\ Sichuan";
$areanames{en}->{861308824} = "Ziyang\,\ Sichuan";
$areanames{en}->{861308825} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308826} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308827} = "Mianyang\,\ Sichuan";
$areanames{en}->{861308828} = "Zigong\,\ Sichuan";
$areanames{en}->{861308829} = "Zigong\,\ Sichuan";
$areanames{en}->{861308830} = "Ziyang\,\ Sichuan";
$areanames{en}->{861308831} = "Luzhou\,\ Sichuan";
$areanames{en}->{861308832} = "Zigong\,\ Sichuan";
$areanames{en}->{861308833} = "Yibin\,\ Sichuan";
$areanames{en}->{861308834} = "Deyang\,\ Sichuan";
$areanames{en}->{861308835} = "Leshan\,\ Sichuan";
$areanames{en}->{861308836} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861308837} = "Liangshan\,\ Sichuan";
$areanames{en}->{861308838} = "Meishan\,\ Sichuan";
$areanames{en}->{861308839} = "Leshan\,\ Sichuan";
$areanames{en}->{861308840} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308841} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308842} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308843} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861308844} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308845} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308846} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861308847} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861308848} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861308849} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{86130885} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861308856} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861308857} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861308858} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861308859} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861308860} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861308861} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861308862} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861308863} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861308864} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861308865} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308866} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308867} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308868} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861308869} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130887} = "Lanzhou\,\ Gansu";
$areanames{en}->{86130888} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861308890} = "Baoji\,\ Shaanxi";
$areanames{en}->{861308891} = "Baoji\,\ Shaanxi";
$areanames{en}->{861308892} = "Baoji\,\ Shaanxi";
$areanames{en}->{861308893} = "Baoji\,\ Shaanxi";
$areanames{en}->{861308894} = "Baoji\,\ Shaanxi";
$areanames{en}->{861308895} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308896} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308897} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308898} = "XiAn\,\ Shaanxi";
$areanames{en}->{861308899} = "XiAn\,\ Shaanxi";
$areanames{en}->{86130890} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861308909} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861308910} = "Changchun\,\ Jilin";
$areanames{en}->{861308911} = "Changchun\,\ Jilin";
$areanames{en}->{861308912} = "Changchun\,\ Jilin";
$areanames{en}->{861308913} = "Changchun\,\ Jilin";
$areanames{en}->{861308914} = "Changchun\,\ Jilin";
$areanames{en}->{861308915} = "Jilin\,\ Jilin";
$areanames{en}->{861308916} = "Jilin\,\ Jilin";
$areanames{en}->{861308917} = "Jilin\,\ Jilin";
$areanames{en}->{861308918} = "Jilin\,\ Jilin";
$areanames{en}->{861308919} = "Tonghua\,\ Jilin";
$areanames{en}->{861308920} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861308921} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861308922} = "Siping\,\ Jilin";
$areanames{en}->{861308923} = "Siping\,\ Jilin";
$areanames{en}->{861308924} = "Jilin\,\ Jilin";
$areanames{en}->{861308925} = "Songyuan\,\ Jilin";
$areanames{en}->{861308926} = "Songyuan\,\ Jilin";
$areanames{en}->{861308927} = "Tonghua\,\ Jilin";
$areanames{en}->{861308928} = "Siping\,\ Jilin";
$areanames{en}->{861308929} = "Tonghua\,\ Jilin";
$areanames{en}->{861308930} = "Yanbian\,\ Jilin";
$areanames{en}->{861308931} = "Yanbian\,\ Jilin";
$areanames{en}->{861308932} = "Yanbian\,\ Jilin";
$areanames{en}->{861308933} = "Yanbian\,\ Jilin";
$areanames{en}->{861308934} = "Yanbian\,\ Jilin";
$areanames{en}->{861308935} = "Songyuan\,\ Jilin";
$areanames{en}->{861308936} = "Baicheng\,\ Jilin";
$areanames{en}->{861308937} = "Baicheng\,\ Jilin";
$areanames{en}->{861308938} = "Baishan\,\ Jilin";
$areanames{en}->{861308939} = "Baishan\,\ Jilin";
$areanames{en}->{861308940} = "Changchun\,\ Jilin";
$areanames{en}->{861308941} = "Changchun\,\ Jilin";
$areanames{en}->{861308942} = "Changchun\,\ Jilin";
$areanames{en}->{861308943} = "Yanbian\,\ Jilin";
$areanames{en}->{861308944} = "Yanbian\,\ Jilin";
$areanames{en}->{861308945} = "Jilin\,\ Jilin";
$areanames{en}->{861308946} = "Jilin\,\ Jilin";
$areanames{en}->{861308947} = "Jilin\,\ Jilin";
$areanames{en}->{861308948} = "Jilin\,\ Jilin";
$areanames{en}->{861308949} = "Jilin\,\ Jilin";
$areanames{en}->{861308950} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861308951} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861308952} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861308953} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861308954} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861308955} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861308956} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861308957} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861308958} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861308959} = "Yichun\,\ Heilongjiang";
$areanames{en}->{86130896} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861308960} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861308961} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861308962} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861308970} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861308971} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861308972} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861308973} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861308974} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861308975} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861308976} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861308977} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861308978} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861308979} = "Jixi\,\ Heilongjiang";
$areanames{en}->{86130898} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861308980} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861308981} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861308982} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861308990} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861308991} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861308992} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861308993} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861308994} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861308995} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861308996} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861308997} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861308998} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861308999} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130900} = "Changji\,\ Xinjiang";
$areanames{en}->{861309024} = "Shenyang\,\ Liaoning";
$areanames{en}->{861309029} = "XiAn\,\ Shaanxi";
$areanames{en}->{861309042} = "Beijing";
$areanames{en}->{861309044} = "Jinzhou\,\ Liaoning";
$areanames{en}->{86130905} = "Zunyi\,\ Guizhou";
$areanames{en}->{861309066} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861309067} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861309069} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861309100} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861309101} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861309102} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861309103} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861309104} = "Tangshan\,\ Hebei";
$areanames{en}->{861309105} = "Tangshan\,\ Hebei";
$areanames{en}->{861309106} = "Tangshan\,\ Hebei";
$areanames{en}->{861309107} = "Tangshan\,\ Hebei";
$areanames{en}->{861309108} = "Tangshan\,\ Hebei";
$areanames{en}->{861309109} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861309110} = "Handan\,\ Hebei";
$areanames{en}->{861309111} = "Handan\,\ Hebei";
$areanames{en}->{861309112} = "Handan\,\ Hebei";
$areanames{en}->{861309113} = "Handan\,\ Hebei";
$areanames{en}->{861309114} = "Cangzhou\,\ Hebei";
$areanames{en}->{861309115} = "Cangzhou\,\ Hebei";
$areanames{en}->{861309116} = "Cangzhou\,\ Hebei";
$areanames{en}->{861309117} = "Hengshui\,\ Hebei";
$areanames{en}->{861309118} = "Hengshui\,\ Hebei";
$areanames{en}->{861309119} = "Hengshui\,\ Hebei";
$areanames{en}->{86130912} = "Baoding\,\ Hebei";
$areanames{en}->{861309127} = "Xingtai\,\ Hebei";
$areanames{en}->{861309128} = "Xingtai\,\ Hebei";
$areanames{en}->{861309129} = "Xingtai\,\ Hebei";
$areanames{en}->{861309130} = "Langfang\,\ Hebei";
$areanames{en}->{861309131} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861309132} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861309133} = "Chengde\,\ Hebei";
$areanames{en}->{861309134} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861309135} = "Chengde\,\ Hebei";
$areanames{en}->{861309136} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861309137} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861309138} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861309139} = "Langfang\,\ Hebei";
$areanames{en}->{861309140} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861309141} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861309142} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861309143} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309144} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309145} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309146} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861309147} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861309148} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861309149} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861309150} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861309151} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861309152} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861309153} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861309154} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861309155} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861309156} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861309157} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861309158} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861309159} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861309160} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861309161} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861309162} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861309163} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861309164} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861309165} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861309166} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861309167} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861309168} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861309169} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861309170} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309171} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309172} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309173} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861309174} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861309175} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861309176} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861309177} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861309178} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861309179} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861309180} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861309181} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861309182} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861309183} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861309184} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861309185} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861309186} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309187} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309188} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861309189} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86130919} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86130920} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{86130921} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86130922} = "Taizhou\,\ Jiangsu";
$areanames{en}->{86130923} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861309237} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861309238} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861309239} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861309240} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309241} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309242} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861309243} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861309244} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861309245} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861309246} = "Suqian\,\ Jiangsu";
$areanames{en}->{861309247} = "Suqian\,\ Jiangsu";
$areanames{en}->{861309248} = "Suqian\,\ Jiangsu";
$areanames{en}->{861309249} = "Suqian\,\ Jiangsu";
$areanames{en}->{86130925} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86130926} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861309268} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861309269} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861309270} = "Ezhou\,\ Hubei";
$areanames{en}->{861309271} = "Ezhou\,\ Hubei";
$areanames{en}->{861309272} = "Huanggang\,\ Hubei";
$areanames{en}->{861309273} = "Huanggang\,\ Hubei";
$areanames{en}->{861309274} = "Huanggang\,\ Hubei";
$areanames{en}->{861309275} = "Huangshi\,\ Hubei";
$areanames{en}->{861309276} = "Huangshi\,\ Hubei";
$areanames{en}->{861309277} = "Huangshi\,\ Hubei";
$areanames{en}->{861309278} = "Huangshi\,\ Hubei";
$areanames{en}->{861309279} = "Huangshi\,\ Hubei";
$areanames{en}->{861309280} = "Liangshan\,\ Sichuan";
$areanames{en}->{861309281} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861309282} = "Nanchong\,\ Sichuan";
$areanames{en}->{861309283} = "Suining\,\ Sichuan";
$areanames{en}->{861309284} = "GuangAn\,\ Sichuan";
$areanames{en}->{861309285} = "Dazhou\,\ Sichuan";
$areanames{en}->{861309286} = "Deyang\,\ Sichuan";
$areanames{en}->{861309287} = "Neijiang\,\ Sichuan";
$areanames{en}->{861309288} = "Yibin\,\ Sichuan";
$areanames{en}->{861309289} = "Zigong\,\ Sichuan";
$areanames{en}->{86130929} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861309290} = "Baoji\,\ Shaanxi";
$areanames{en}->{861309291} = "Baoji\,\ Shaanxi";
$areanames{en}->{861309292} = "Baoji\,\ Shaanxi";
$areanames{en}->{861309293} = "Baoji\,\ Shaanxi";
$areanames{en}->{86130930} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309310} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309311} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309312} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309313} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309314} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861309315} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861309316} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861309317} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861309318} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861309319} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861309320} = "Jingmen\,\ Hubei";
$areanames{en}->{861309321} = "Jingmen\,\ Hubei";
$areanames{en}->{861309322} = "Jingmen\,\ Hubei";
$areanames{en}->{861309323} = "Jingmen\,\ Hubei";
$areanames{en}->{861309324} = "Enshi\,\ Hubei";
$areanames{en}->{861309325} = "Enshi\,\ Hubei";
$areanames{en}->{861309326} = "Enshi\,\ Hubei";
$areanames{en}->{861309327} = "Suizhou\,\ Hubei";
$areanames{en}->{861309328} = "Suizhou\,\ Hubei";
$areanames{en}->{861309329} = "Wuhan\,\ Hubei";
$areanames{en}->{861309330} = "Chuzhou\,\ Anhui";
$areanames{en}->{861309331} = "Chuzhou\,\ Anhui";
$areanames{en}->{861309332} = "Chuzhou\,\ Anhui";
$areanames{en}->{861309333} = "Tongling\,\ Anhui";
$areanames{en}->{861309334} = "Fuyang\,\ Anhui";
$areanames{en}->{861309335} = "Bozhou\,\ Anhui";
$areanames{en}->{861309336} = "Fuyang\,\ Anhui";
$areanames{en}->{861309337} = "Bozhou\,\ Anhui";
$areanames{en}->{861309338} = "Fuyang\,\ Anhui";
$areanames{en}->{861309339} = "Fuyang\,\ Anhui";
$areanames{en}->{861309340} = "Hefei\,\ Anhui";
$areanames{en}->{861309341} = "LuAn\,\ Anhui";
$areanames{en}->{861309342} = "LuAn\,\ Anhui";
$areanames{en}->{861309343} = "LuAn\,\ Anhui";
$areanames{en}->{861309344} = "Wuhu\,\ Anhui";
$areanames{en}->{861309345} = "Hefei\,\ Anhui";
$areanames{en}->{861309346} = "Xuancheng\,\ Anhui";
$areanames{en}->{861309347} = "Xuancheng\,\ Anhui";
$areanames{en}->{861309348} = "Xuancheng\,\ Anhui";
$areanames{en}->{861309349} = "Chizhou\,\ Anhui";
$areanames{en}->{861309350} = "MaAnshan\,\ Anhui";
$areanames{en}->{861309351} = "Huaibei\,\ Anhui";
$areanames{en}->{861309352} = "Huaibei\,\ Anhui";
$areanames{en}->{861309353} = "Huaibei\,\ Anhui";
$areanames{en}->{861309354} = "Hefei\,\ Anhui";
$areanames{en}->{861309355} = "Hefei\,\ Anhui";
$areanames{en}->{861309356} = "Suzhou\,\ Anhui";
$areanames{en}->{861309357} = "Suzhou\,\ Anhui";
$areanames{en}->{861309358} = "Suzhou\,\ Anhui";
$areanames{en}->{861309359} = "Suzhou\,\ Anhui";
$areanames{en}->{861309360} = "Xuancheng\,\ Anhui";
$areanames{en}->{861309361} = "Xuancheng\,\ Anhui";
$areanames{en}->{861309362} = "Wuhu\,\ Anhui";
$areanames{en}->{861309363} = "Wuhu\,\ Anhui";
$areanames{en}->{861309364} = "Wuhu\,\ Anhui";
$areanames{en}->{861309365} = "Bengbu\,\ Anhui";
$areanames{en}->{861309366} = "Bengbu\,\ Anhui";
$areanames{en}->{861309367} = "Bengbu\,\ Anhui";
$areanames{en}->{861309368} = "Chizhou\,\ Anhui";
$areanames{en}->{861309369} = "Chizhou\,\ Anhui";
$areanames{en}->{86130937} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86130938} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86130939} = "Weinan\,\ Shaanxi";
$areanames{en}->{861309390} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861309391} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861309392} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861309393} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861309400} = "Altay\,\ Xinjiang";
$areanames{en}->{861309401} = "Changji\,\ Xinjiang";
$areanames{en}->{861309402} = "Hami\,\ Xinjiang";
$areanames{en}->{861309403} = "Ili\,\ Xinjiang";
$areanames{en}->{861309404} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861309405} = "Karamay\,\ Xinjiang";
$areanames{en}->{861309406} = "Ili\,\ Xinjiang";
$areanames{en}->{861309407} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861309408} = "Aksu\,\ Xinjiang";
$areanames{en}->{861309409} = "Hotan\,\ Xinjiang";
$areanames{en}->{861309410} = "Xiangfan\,\ Hubei";
$areanames{en}->{861309411} = "Xiangfan\,\ Hubei";
$areanames{en}->{861309412} = "Xiangfan\,\ Hubei";
$areanames{en}->{861309413} = "Xiangfan\,\ Hubei";
$areanames{en}->{861309414} = "Xiaogan\,\ Hubei";
$areanames{en}->{861309415} = "Xiaogan\,\ Hubei";
$areanames{en}->{861309416} = "Yichang\,\ Hubei";
$areanames{en}->{861309417} = "Yichang\,\ Hubei";
$areanames{en}->{861309418} = "Yichang\,\ Hubei";
$areanames{en}->{861309419} = "Xianning\,\ Hubei";
$areanames{en}->{861309420} = "Jingzhou\,\ Hubei";
$areanames{en}->{861309421} = "Jingzhou\,\ Hubei";
$areanames{en}->{861309422} = "Jingzhou\,\ Hubei";
$areanames{en}->{861309423} = "Jingzhou\,\ Hubei";
$areanames{en}->{861309424} = "Jingzhou\,\ Hubei";
$areanames{en}->{861309425} = "Wuhan\,\ Hubei";
$areanames{en}->{861309426} = "Wuhan\,\ Hubei";
$areanames{en}->{861309427} = "Shiyan\,\ Hubei";
$areanames{en}->{861309428} = "Shiyan\,\ Hubei";
$areanames{en}->{861309429} = "Wuhan\,\ Hubei";
$areanames{en}->{861309430} = "Yuxi\,\ Yunnan";
$areanames{en}->{861309431} = "Qujing\,\ Yunnan";
$areanames{en}->{861309432} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861309433} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861309434} = "Honghe\,\ Yunnan";
$areanames{en}->{861309435} = "Baoshan\,\ Yunnan";
$areanames{en}->{861309436} = "Baoshan\,\ Yunnan";
$areanames{en}->{861309437} = "Wenshan\,\ Yunnan";
$areanames{en}->{861309438} = "Wenshan\,\ Yunnan";
$areanames{en}->{861309439} = "Lincang\,\ Yunnan";
$areanames{en}->{86130944} = "Chengdu\,\ Sichuan";
$areanames{en}->{861309450} = "Dazhou\,\ Sichuan";
$areanames{en}->{861309451} = "Bazhong\,\ Sichuan";
$areanames{en}->{861309452} = "Bazhong\,\ Sichuan";
$areanames{en}->{861309453} = "Yibin\,\ Sichuan";
$areanames{en}->{861309454} = "Liangshan\,\ Sichuan";
$areanames{en}->{861309455} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861309456} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861309457} = "YaAn\,\ Sichuan";
$areanames{en}->{861309458} = "Yibin\,\ Sichuan";
$areanames{en}->{861309459} = "Yibin\,\ Sichuan";
$areanames{en}->{861309460} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309461} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309462} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309463} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309464} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861309465} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861309466} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861309467} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309468} = "Lishui\,\ Zhejiang";
$areanames{en}->{861309469} = "Lishui\,\ Zhejiang";
$areanames{en}->{861309470} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861309471} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861309472} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861309473} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861309474} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861309475} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861309476} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861309477} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861309478} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861309479} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861309480} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861309481} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861309482} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861309483} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861309484} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861309485} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861309486} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861309487} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309488} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309489} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309490} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861309491} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861309492} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861309493} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861309494} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861309495} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861309496} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861309497} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861309498} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861309499} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861309500} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861309501} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861309502} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861309503} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861309504} = "Turpan\,\ Xinjiang";
$areanames{en}->{861309505} = "Changji\,\ Xinjiang";
$areanames{en}->{861309506} = "Changji\,\ Xinjiang";
$areanames{en}->{861309507} = "Hami\,\ Xinjiang";
$areanames{en}->{861309508} = "Ili\,\ Xinjiang";
$areanames{en}->{861309509} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861309510} = "Karamay\,\ Xinjiang";
$areanames{en}->{861309511} = "Ili\,\ Xinjiang";
$areanames{en}->{861309512} = "Ili\,\ Xinjiang";
$areanames{en}->{861309513} = "Bortala\,\ Xinjiang";
$areanames{en}->{861309514} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861309515} = "Kashi\,\ Xinjiang";
$areanames{en}->{861309516} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861309517} = "Aksu\,\ Xinjiang";
$areanames{en}->{861309518} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861309519} = "Kashi\,\ Xinjiang";
$areanames{en}->{861309520} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861309521} = "Dehong\,\ Yunnan";
$areanames{en}->{861309522} = "Lincang\,\ Yunnan";
$areanames{en}->{861309523} = "Lijiang\,\ Yunnan";
$areanames{en}->{861309524} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861309525} = "Dali\,\ Yunnan";
$areanames{en}->{861309526} = "Honghe\,\ Yunnan";
$areanames{en}->{861309527} = "Qujing\,\ Yunnan";
$areanames{en}->{861309528} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861309529} = "Yuxi\,\ Yunnan";
$areanames{en}->{86130953} = "Kunming\,\ Yunnan";
$areanames{en}->{861309537} = "Puer\,\ Yunnan";
$areanames{en}->{861309538} = "Wenshan\,\ Yunnan";
$areanames{en}->{861309539} = "Baoshan\,\ Yunnan";
$areanames{en}->{861309540} = "Fuyang\,\ Anhui";
$areanames{en}->{861309541} = "Fuyang\,\ Anhui";
$areanames{en}->{861309542} = "Fuyang\,\ Anhui";
$areanames{en}->{861309543} = "Huangshan\,\ Anhui";
$areanames{en}->{861309544} = "Huangshan\,\ Anhui";
$areanames{en}->{861309545} = "Hefei\,\ Anhui";
$areanames{en}->{861309546} = "MaAnshan\,\ Anhui";
$areanames{en}->{861309547} = "Huainan\,\ Anhui";
$areanames{en}->{861309548} = "Tongling\,\ Anhui";
$areanames{en}->{861309549} = "Wuhu\,\ Anhui";
$areanames{en}->{861309550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861309551} = "Hefei\,\ Anhui";
$areanames{en}->{861309552} = "Bengbu\,\ Anhui";
$areanames{en}->{861309553} = "Wuhu\,\ Anhui";
$areanames{en}->{861309554} = "Huainan\,\ Anhui";
$areanames{en}->{861309555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861309556} = "Anqing\,\ Anhui";
$areanames{en}->{861309557} = "Suzhou\,\ Anhui";
$areanames{en}->{861309558} = "Fuyang\,\ Anhui";
$areanames{en}->{861309559} = "Huangshan\,\ Anhui";
$areanames{en}->{861309560} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309561} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309562} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309563} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309564} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309565} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309566} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309567} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309568} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309569} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861309571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861309572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861309573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861309574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861309575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861309576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861309577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861309578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861309579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861309580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861309581} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861309582} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861309583} = "Lishui\,\ Zhejiang";
$areanames{en}->{861309584} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861309585} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861309586} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861309587} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861309588} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861309589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86130959} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861309600} = "Zigong\,\ Sichuan";
$areanames{en}->{861309601} = "Zigong\,\ Sichuan";
$areanames{en}->{861309602} = "Meishan\,\ Sichuan";
$areanames{en}->{861309603} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861309604} = "Mianyang\,\ Sichuan";
$areanames{en}->{861309605} = "Leshan\,\ Sichuan";
$areanames{en}->{861309606} = "Ziyang\,\ Sichuan";
$areanames{en}->{861309607} = "Meishan\,\ Sichuan";
$areanames{en}->{861309608} = "Neijiang\,\ Sichuan";
$areanames{en}->{861309609} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861309610} = "Deyang\,\ Sichuan";
$areanames{en}->{861309611} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861309612} = "Mianyang\,\ Sichuan";
$areanames{en}->{861309613} = "Nanchong\,\ Sichuan";
$areanames{en}->{861309614} = "Nanchong\,\ Sichuan";
$areanames{en}->{861309615} = "Ziyang\,\ Sichuan";
$areanames{en}->{861309616} = "Ziyang\,\ Sichuan";
$areanames{en}->{861309617} = "Mianyang\,\ Sichuan";
$areanames{en}->{861309618} = "Yibin\,\ Sichuan";
$areanames{en}->{861309619} = "Dazhou\,\ Sichuan";
$areanames{en}->{861309620} = "Yibin\,\ Sichuan";
$areanames{en}->{861309621} = "Yibin\,\ Sichuan";
$areanames{en}->{861309622} = "Yibin\,\ Sichuan";
$areanames{en}->{861309623} = "Mianyang\,\ Sichuan";
$areanames{en}->{861309624} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861309625} = "Meishan\,\ Sichuan";
$areanames{en}->{861309626} = "Garze\,\ Sichuan";
$areanames{en}->{861309627} = "YaAn\,\ Sichuan";
$areanames{en}->{861309628} = "Deyang\,\ Sichuan";
$areanames{en}->{861309629} = "Deyang\,\ Sichuan";
$areanames{en}->{86130963} = "Chengdu\,\ Sichuan";
$areanames{en}->{861309640} = "Leshan\,\ Sichuan";
$areanames{en}->{861309641} = "Meishan\,\ Sichuan";
$areanames{en}->{861309642} = "Leshan\,\ Sichuan";
$areanames{en}->{861309643} = "Deyang\,\ Sichuan";
$areanames{en}->{861309644} = "Deyang\,\ Sichuan";
$areanames{en}->{861309645} = "Deyang\,\ Sichuan";
$areanames{en}->{861309646} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861309647} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861309648} = "Mianyang\,\ Sichuan";
$areanames{en}->{861309649} = "Mianyang\,\ Sichuan";
$areanames{en}->{861309650} = "Yangquan\,\ Shanxi";
$areanames{en}->{861309651} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861309652} = "Linfen\,\ Shanxi";
$areanames{en}->{861309653} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861309654} = "Datong\,\ Shanxi";
$areanames{en}->{861309655} = "Jincheng\,\ Shanxi";
$areanames{en}->{861309656} = "Changzhi\,\ Shanxi";
$areanames{en}->{861309657} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861309658} = "Datong\,\ Shanxi";
$areanames{en}->{861309659} = "Datong\,\ Shanxi";
$areanames{en}->{861309660} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861309661} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861309662} = "Linfen\,\ Shanxi";
$areanames{en}->{861309663} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861309664} = "Linfen\,\ Shanxi";
$areanames{en}->{861309665} = "Jincheng\,\ Shanxi";
$areanames{en}->{861309666} = "Changzhi\,\ Shanxi";
$areanames{en}->{861309667} = "Lüliang\,\ Shanxi";
$areanames{en}->{861309668} = "Datong\,\ Shanxi";
$areanames{en}->{861309669} = "Datong\,\ Shanxi";
$areanames{en}->{86130967} = "Zunyi\,\ Guizhou";
$areanames{en}->{861309680} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861309681} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861309682} = "Bijie\,\ Guizhou";
$areanames{en}->{861309683} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861309684} = "Qiannan\,\ Guizhou";
$areanames{en}->{861309685} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861309686} = "Tongren\,\ Guizhou";
$areanames{en}->{861309687} = "Bijie\,\ Guizhou";
$areanames{en}->{861309688} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861309689} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86130969} = "XiAn\,\ Shaanxi";
$areanames{en}->{861309700} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861309701} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861309702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861309703} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861309704} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861309705} = "Yichun\,\ Jiangxi";
$areanames{en}->{861309706} = "JiAn\,\ Jiangxi";
$areanames{en}->{861309707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309708} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861309709} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861309710} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861309711} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861309712} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861309713} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861309714} = "JiAn\,\ Jiangxi";
$areanames{en}->{861309715} = "Yichun\,\ Jiangxi";
$areanames{en}->{861309716} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309717} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309718} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861309719} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861309720} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861309721} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861309722} = "JiAn\,\ Jiangxi";
$areanames{en}->{861309723} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861309724} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309725} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861309726} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861309727} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861309728} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861309729} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861309730} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309731} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309732} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309733} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309734} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861309735} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861309736} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861309737} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861309738} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861309739} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861309740} = "Yuxi\,\ Yunnan";
$areanames{en}->{861309741} = "Yuxi\,\ Yunnan";
$areanames{en}->{861309742} = "Honghe\,\ Yunnan";
$areanames{en}->{861309743} = "Honghe\,\ Yunnan";
$areanames{en}->{861309744} = "Lijiang\,\ Yunnan";
$areanames{en}->{861309745} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861309746} = "Qujing\,\ Yunnan";
$areanames{en}->{861309747} = "Qujing\,\ Yunnan";
$areanames{en}->{861309748} = "Wenshan\,\ Yunnan";
$areanames{en}->{861309749} = "Dali\,\ Yunnan";
$areanames{en}->{861309750} = "Yangquan\,\ Shanxi";
$areanames{en}->{861309751} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861309752} = "Linfen\,\ Shanxi";
$areanames{en}->{861309753} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861309754} = "Datong\,\ Shanxi";
$areanames{en}->{861309755} = "Jincheng\,\ Shanxi";
$areanames{en}->{861309756} = "Changzhi\,\ Shanxi";
$areanames{en}->{861309757} = "Lüliang\,\ Shanxi";
$areanames{en}->{861309758} = "Lüliang\,\ Shanxi";
$areanames{en}->{861309759} = "Datong\,\ Shanxi";
$areanames{en}->{861309760} = "Yangquan\,\ Shanxi";
$areanames{en}->{861309761} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861309762} = "Linfen\,\ Shanxi";
$areanames{en}->{861309763} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861309764} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861309765} = "Jincheng\,\ Shanxi";
$areanames{en}->{861309766} = "Changzhi\,\ Shanxi";
$areanames{en}->{861309767} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861309768} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861309769} = "Datong\,\ Shanxi";
$areanames{en}->{861309770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861309771} = "Nanning\,\ Guangxi";
$areanames{en}->{861309772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861309773} = "Guilin\,\ Guangxi";
$areanames{en}->{861309774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861309775} = "Yulin\,\ Guangxi";
$areanames{en}->{861309776} = "Baise\,\ Guangxi";
$areanames{en}->{861309777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861309778} = "Hechi\,\ Guangxi";
$areanames{en}->{861309779} = "Beihai\,\ Guangxi";
$areanames{en}->{861309780} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861309781} = "Beihai\,\ Guangxi";
$areanames{en}->{861309782} = "Guigang\,\ Guangxi";
$areanames{en}->{861309783} = "Hezhou\,\ Guangxi";
$areanames{en}->{861309784} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861309785} = "Yulin\,\ Guangxi";
$areanames{en}->{861309786} = "Baise\,\ Guangxi";
$areanames{en}->{861309787} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861309788} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861309789} = "Beihai\,\ Guangxi";
$areanames{en}->{861309790} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861309791} = "Beihai\,\ Guangxi";
$areanames{en}->{861309792} = "Guigang\,\ Guangxi";
$areanames{en}->{861309793} = "Guilin\,\ Guangxi";
$areanames{en}->{861309794} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861309795} = "Yulin\,\ Guangxi";
$areanames{en}->{861309796} = "Baise\,\ Guangxi";
$areanames{en}->{861309797} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861309798} = "Hechi\,\ Guangxi";
$areanames{en}->{861309799} = "Beihai\,\ Guangxi";
$areanames{en}->{86130980} = "YanAn\,\ Shaanxi";
$areanames{en}->{861309800} = "Ankang\,\ Shaanxi";
$areanames{en}->{861309801} = "Ankang\,\ Shaanxi";
$areanames{en}->{861309802} = "Ankang\,\ Shaanxi";
$areanames{en}->{861309803} = "Ankang\,\ Shaanxi";
$areanames{en}->{861309810} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861309811} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861309812} = "Weinan\,\ Shaanxi";
$areanames{en}->{861309813} = "Weinan\,\ Shaanxi";
$areanames{en}->{861309814} = "Weinan\,\ Shaanxi";
$areanames{en}->{861309815} = "Baoji\,\ Shaanxi";
$areanames{en}->{861309816} = "Baoji\,\ Shaanxi";
$areanames{en}->{861309817} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861309818} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861309819} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{86130982} = "Yulin\,\ Shaanxi";
$areanames{en}->{861309820} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861309821} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861309822} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861309823} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861309830} = "Jingzhou\,\ Hubei";
$areanames{en}->{861309831} = "Jingzhou\,\ Hubei";
$areanames{en}->{861309832} = "Wuhan\,\ Hubei";
$areanames{en}->{861309833} = "Wuhan\,\ Hubei";
$areanames{en}->{861309834} = "Wuhan\,\ Hubei";
$areanames{en}->{861309835} = "Xianning\,\ Hubei";
$areanames{en}->{861309836} = "Huanggang\,\ Hubei";
$areanames{en}->{861309837} = "Huanggang\,\ Hubei";
$areanames{en}->{861309838} = "Ezhou\,\ Hubei";
$areanames{en}->{861309839} = "Huangshi\,\ Hubei";
$areanames{en}->{861309840} = "Yichang\,\ Hubei";
$areanames{en}->{861309841} = "Yichang\,\ Hubei";
$areanames{en}->{861309842} = "Jingmen\,\ Hubei";
$areanames{en}->{861309843} = "Jingmen\,\ Hubei";
$areanames{en}->{861309844} = "Suizhou\,\ Hubei";
$areanames{en}->{861309845} = "Xiangfan\,\ Hubei";
$areanames{en}->{861309846} = "Xiangfan\,\ Hubei";
$areanames{en}->{861309847} = "Enshi\,\ Hubei";
$areanames{en}->{861309848} = "Xiaogan\,\ Hubei";
$areanames{en}->{861309849} = "Shiyan\,\ Hubei";
$areanames{en}->{861309850} = "Guiyang\,\ Guizhou";
$areanames{en}->{861309851} = "Guiyang\,\ Guizhou";
$areanames{en}->{861309852} = "Zunyi\,\ Guizhou";
$areanames{en}->{861309853} = "Anshun\,\ Guizhou";
$areanames{en}->{861309854} = "Qiannan\,\ Guizhou";
$areanames{en}->{861309855} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861309856} = "Tongren\,\ Guizhou";
$areanames{en}->{861309857} = "Bijie\,\ Guizhou";
$areanames{en}->{861309858} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861309859} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86130986} = "Chongqing";
$areanames{en}->{86130987} = "Chongqing";
$areanames{en}->{86130988} = "Wuhan\,\ Hubei";
$areanames{en}->{86130989} = "Haikou\,\ Hainan";
$areanames{en}->{86130990} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861309901} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861309902} = "Linfen\,\ Shanxi";
$areanames{en}->{861309903} = "Xinzhou\,\ Shanxi";
$areanames{en}->{86130991} = "Lanzhou\,\ Gansu";
$areanames{en}->{86130992} = "Lanzhou\,\ Gansu";
$areanames{en}->{861309927} = "Baiyin\,\ Gansu";
$areanames{en}->{861309928} = "Baiyin\,\ Gansu";
$areanames{en}->{861309929} = "Linxia\,\ Gansu";
$areanames{en}->{861309930} = "Gannan\,\ Gansu";
$areanames{en}->{861309931} = "Gannan\,\ Gansu";
$areanames{en}->{861309932} = "Longnan\,\ Gansu";
$areanames{en}->{861309933} = "Pingliang\,\ Gansu";
$areanames{en}->{861309934} = "Longnan\,\ Gansu";
$areanames{en}->{861309935} = "Qingyang\,\ Gansu";
$areanames{en}->{861309936} = "Qingyang\,\ Gansu";
$areanames{en}->{861309937} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861309938} = "Zhangye\,\ Gansu";
$areanames{en}->{861309939} = "Jiayuguan\,\ Gansu";
$areanames{en}->{86130994} = "Kunming\,\ Yunnan";
$areanames{en}->{861309947} = "Dehong\,\ Yunnan";
$areanames{en}->{861309948} = "Dehong\,\ Yunnan";
$areanames{en}->{861309949} = "Dehong\,\ Yunnan";
$areanames{en}->{861309950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861309951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861309952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861309953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861309954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861309955} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861309956} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861309957} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861309958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861309959} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861309960} = "Lincang\,\ Yunnan";
$areanames{en}->{861309961} = "Lincang\,\ Yunnan";
$areanames{en}->{861309962} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861309963} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861309964} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861309965} = "Puer\,\ Yunnan";
$areanames{en}->{861309966} = "Puer\,\ Yunnan";
$areanames{en}->{861309967} = "Baoshan\,\ Yunnan";
$areanames{en}->{861309968} = "Baoshan\,\ Yunnan";
$areanames{en}->{861309969} = "Wenshan\,\ Yunnan";
$areanames{en}->{86130997} = "Xining\,\ Qinghai";
$areanames{en}->{861309970} = "Yushu\,\ Qinghai";
$areanames{en}->{861309971} = "Golog\,\ Qinghai";
$areanames{en}->{861309972} = "Haidong\,\ Qinghai";
$areanames{en}->{861309973} = "Huangnan\,\ Qinghai";
$areanames{en}->{861309980} = "Honghe\,\ Yunnan";
$areanames{en}->{861309981} = "Honghe\,\ Yunnan";
$areanames{en}->{861309982} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861309983} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861309984} = "Dali\,\ Yunnan";
$areanames{en}->{861309985} = "Dali\,\ Yunnan";
$areanames{en}->{861309986} = "Qujing\,\ Yunnan";
$areanames{en}->{861309987} = "Qujing\,\ Yunnan";
$areanames{en}->{861309988} = "Yuxi\,\ Yunnan";
$areanames{en}->{861309989} = "Yuxi\,\ Yunnan";
$areanames{en}->{86130999} = "Kunming\,\ Yunnan";
$areanames{en}->{861310000} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310001} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310002} = "Datong\,\ Shanxi";
$areanames{en}->{861310003} = "Yangquan\,\ Shanxi";
$areanames{en}->{861310004} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861310005} = "Changzhi\,\ Shanxi";
$areanames{en}->{861310006} = "Jincheng\,\ Shanxi";
$areanames{en}->{861310007} = "Linfen\,\ Shanxi";
$areanames{en}->{861310008} = "Lüliang\,\ Shanxi";
$areanames{en}->{861310009} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861310010} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861310011} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310012} = "Datong\,\ Shanxi";
$areanames{en}->{861310013} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861310014} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310015} = "Changzhi\,\ Shanxi";
$areanames{en}->{861310016} = "Jincheng\,\ Shanxi";
$areanames{en}->{861310017} = "Linfen\,\ Shanxi";
$areanames{en}->{861310018} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861310019} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861310020} = "Yueyang\,\ Hunan";
$areanames{en}->{861310021} = "Huaihua\,\ Hunan";
$areanames{en}->{861310022} = "Yongzhou\,\ Hunan";
$areanames{en}->{861310023} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861310024} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861310025} = "Changsha\,\ Hunan";
$areanames{en}->{861310026} = "Hengyang\,\ Hunan";
$areanames{en}->{861310027} = "Xiangxi\,\ Hunan";
$areanames{en}->{861310028} = "Changde\,\ Hunan";
$areanames{en}->{861310029} = "Changde\,\ Hunan";
$areanames{en}->{861310030} = "Yueyang\,\ Hunan";
$areanames{en}->{861310031} = "Changsha\,\ Hunan";
$areanames{en}->{861310032} = "Xiangtan\,\ Hunan";
$areanames{en}->{861310033} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861310034} = "Hengyang\,\ Hunan";
$areanames{en}->{861310035} = "Chenzhou\,\ Hunan";
$areanames{en}->{861310036} = "Loudi\,\ Hunan";
$areanames{en}->{861310037} = "Yiyang\,\ Hunan";
$areanames{en}->{861310038} = "Chenzhou\,\ Hunan";
$areanames{en}->{861310039} = "Shaoyang\,\ Hunan";
$areanames{en}->{861310040} = "Nanning\,\ Guangxi";
$areanames{en}->{861310041} = "Nanning\,\ Guangxi";
$areanames{en}->{861310042} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861310043} = "Guilin\,\ Guangxi";
$areanames{en}->{861310044} = "Hezhou\,\ Guangxi";
$areanames{en}->{861310045} = "Yulin\,\ Guangxi";
$areanames{en}->{861310046} = "Baise\,\ Guangxi";
$areanames{en}->{861310047} = "Guigang\,\ Guangxi";
$areanames{en}->{861310048} = "Hechi\,\ Guangxi";
$areanames{en}->{861310049} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861310050} = "Nanning\,\ Guangxi";
$areanames{en}->{861310051} = "Nanning\,\ Guangxi";
$areanames{en}->{861310052} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861310053} = "Guilin\,\ Guangxi";
$areanames{en}->{861310054} = "Hezhou\,\ Guangxi";
$areanames{en}->{861310055} = "Yulin\,\ Guangxi";
$areanames{en}->{861310056} = "Baise\,\ Guangxi";
$areanames{en}->{861310057} = "Guigang\,\ Guangxi";
$areanames{en}->{861310058} = "Hechi\,\ Guangxi";
$areanames{en}->{861310059} = "Guilin\,\ Guangxi";
$areanames{en}->{86131006} = "Wuhan\,\ Hubei";
$areanames{en}->{861310070} = "Wuhan\,\ Hubei";
$areanames{en}->{861310071} = "Wuhan\,\ Hubei";
$areanames{en}->{861310072} = "Wuhan\,\ Hubei";
$areanames{en}->{861310073} = "Wuhan\,\ Hubei";
$areanames{en}->{861310074} = "Huanggang\,\ Hubei";
$areanames{en}->{861310075} = "Suizhou\,\ Hubei";
$areanames{en}->{861310076} = "Enshi\,\ Hubei";
$areanames{en}->{861310077} = "Xiangfan\,\ Hubei";
$areanames{en}->{861310078} = "Yichang\,\ Hubei";
$areanames{en}->{861310079} = "Jingzhou\,\ Hubei";
$areanames{en}->{86131008} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310082} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310086} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861310089} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86131009} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310092} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310094} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861310098} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310099} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{86131010} = "Chongqing";
$areanames{en}->{86131011} = "Chongqing";
$areanames{en}->{86131012} = "Chongqing";
$areanames{en}->{86131013} = "Chongqing";
$areanames{en}->{861310140} = "Fuzhou\,\ Fujian";
$areanames{en}->{861310141} = "Fuzhou\,\ Fujian";
$areanames{en}->{861310142} = "Fuzhou\,\ Fujian";
$areanames{en}->{861310143} = "Xiamen\,\ Fujian";
$areanames{en}->{861310144} = "Quanzhou\,\ Fujian";
$areanames{en}->{861310145} = "Quanzhou\,\ Fujian";
$areanames{en}->{861310146} = "Quanzhou\,\ Fujian";
$areanames{en}->{861310147} = "Ningde\,\ Fujian";
$areanames{en}->{861310148} = "Ningde\,\ Fujian";
$areanames{en}->{861310149} = "Sanming\,\ Fujian";
$areanames{en}->{861310150} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310151} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310152} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310153} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861310154} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861310155} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861310156} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310157} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861310158} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310159} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861310160} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310161} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310162} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310163} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861310164} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861310165} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861310166} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310167} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861310168} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861310169} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861310170} = "Shangqiu\,\ Henan";
$areanames{en}->{861310171} = "Zhengzhou\,\ Henan";
$areanames{en}->{861310172} = "Anyang\,\ Henan";
$areanames{en}->{861310173} = "Xinxiang\,\ Henan";
$areanames{en}->{861310174} = "Nanyang\,\ Henan";
$areanames{en}->{861310175} = "Pingdingshan\,\ Henan";
$areanames{en}->{861310176} = "Xinyang\,\ Henan";
$areanames{en}->{861310177} = "Nanyang\,\ Henan";
$areanames{en}->{861310178} = "Kaifeng\,\ Henan";
$areanames{en}->{861310179} = "Luoyang\,\ Henan";
$areanames{en}->{861310180} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861310181} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861310182} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861310183} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861310184} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861310185} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861310186} = "Suqian\,\ Jiangsu";
$areanames{en}->{861310187} = "Suqian\,\ Jiangsu";
$areanames{en}->{861310188} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861310189} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861310190} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861310191} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861310192} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861310193} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861310194} = "Nantong\,\ Jiangsu";
$areanames{en}->{861310195} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861310196} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861310197} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861310198} = "Nantong\,\ Jiangsu";
$areanames{en}->{861310199} = "Nantong\,\ Jiangsu";
$areanames{en}->{86131020} = "Tianjin";
$areanames{en}->{86131021} = "Tianjin";
$areanames{en}->{86131022} = "Tianjin";
$areanames{en}->{86131023} = "Chongqing";
$areanames{en}->{861310240} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310241} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310242} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310243} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310244} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310245} = "Langfang\,\ Hebei";
$areanames{en}->{861310246} = "Langfang\,\ Hebei";
$areanames{en}->{861310247} = "Langfang\,\ Hebei";
$areanames{en}->{861310248} = "Langfang\,\ Hebei";
$areanames{en}->{861310249} = "Langfang\,\ Hebei";
$areanames{en}->{861310250} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861310251} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861310252} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861310253} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861310254} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861310255} = "Xingtai\,\ Hebei";
$areanames{en}->{861310256} = "Xingtai\,\ Hebei";
$areanames{en}->{861310257} = "Xingtai\,\ Hebei";
$areanames{en}->{861310258} = "Xingtai\,\ Hebei";
$areanames{en}->{861310259} = "Xingtai\,\ Hebei";
$areanames{en}->{86131026} = "Tangshan\,\ Hebei";
$areanames{en}->{861310270} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310271} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310272} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310273} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310274} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310275} = "Hengshui\,\ Hebei";
$areanames{en}->{861310276} = "Hengshui\,\ Hebei";
$areanames{en}->{861310277} = "Hengshui\,\ Hebei";
$areanames{en}->{861310278} = "Hengshui\,\ Hebei";
$areanames{en}->{861310279} = "Hengshui\,\ Hebei";
$areanames{en}->{86131028} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86131029} = "Baoding\,\ Hebei";
$areanames{en}->{861310300} = "Handan\,\ Hebei";
$areanames{en}->{861310301} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861310302} = "Baoding\,\ Hebei";
$areanames{en}->{861310303} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861310304} = "Chengde\,\ Hebei";
$areanames{en}->{861310305} = "Tangshan\,\ Hebei";
$areanames{en}->{861310306} = "Langfang\,\ Hebei";
$areanames{en}->{861310307} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310308} = "Hengshui\,\ Hebei";
$areanames{en}->{861310309} = "Xingtai\,\ Hebei";
$areanames{en}->{861310310} = "Handan\,\ Hebei";
$areanames{en}->{861310311} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861310312} = "Baoding\,\ Hebei";
$areanames{en}->{861310313} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861310314} = "Chengde\,\ Hebei";
$areanames{en}->{861310315} = "Tangshan\,\ Hebei";
$areanames{en}->{861310316} = "Langfang\,\ Hebei";
$areanames{en}->{861310317} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310318} = "Hengshui\,\ Hebei";
$areanames{en}->{861310319} = "Xingtai\,\ Hebei";
$areanames{en}->{861310320} = "Handan\,\ Hebei";
$areanames{en}->{861310321} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861310322} = "Baoding\,\ Hebei";
$areanames{en}->{861310323} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861310324} = "Chengde\,\ Hebei";
$areanames{en}->{861310325} = "Tangshan\,\ Hebei";
$areanames{en}->{861310326} = "Langfang\,\ Hebei";
$areanames{en}->{861310327} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310328} = "Hengshui\,\ Hebei";
$areanames{en}->{861310329} = "Xingtai\,\ Hebei";
$areanames{en}->{861310330} = "Handan\,\ Hebei";
$areanames{en}->{861310331} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861310332} = "Baoding\,\ Hebei";
$areanames{en}->{861310333} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861310334} = "Chengde\,\ Hebei";
$areanames{en}->{861310335} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861310336} = "Langfang\,\ Hebei";
$areanames{en}->{861310337} = "Cangzhou\,\ Hebei";
$areanames{en}->{861310338} = "Hengshui\,\ Hebei";
$areanames{en}->{861310339} = "Xingtai\,\ Hebei";
$areanames{en}->{861310340} = "Datong\,\ Shanxi";
$areanames{en}->{861310341} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310342} = "Datong\,\ Shanxi";
$areanames{en}->{861310343} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310344} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310345} = "Changzhi\,\ Shanxi";
$areanames{en}->{861310346} = "Jincheng\,\ Shanxi";
$areanames{en}->{861310347} = "Linfen\,\ Shanxi";
$areanames{en}->{861310348} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861310349} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861310350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861310351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861310352} = "Datong\,\ Shanxi";
$areanames{en}->{861310353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861310354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861310355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861310356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861310357} = "Linfen\,\ Shanxi";
$areanames{en}->{861310358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861310359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861310360} = "Shangqiu\,\ Henan";
$areanames{en}->{861310361} = "Jiaozuo\,\ Henan";
$areanames{en}->{861310362} = "Anyang\,\ Henan";
$areanames{en}->{861310363} = "Puyang\,\ Henan";
$areanames{en}->{861310364} = "Puyang\,\ Henan";
$areanames{en}->{861310365} = "Pingdingshan\,\ Henan";
$areanames{en}->{861310366} = "Zhumadian\,\ Henan";
$areanames{en}->{861310367} = "Nanyang\,\ Henan";
$areanames{en}->{861310368} = "Nanyang\,\ Henan";
$areanames{en}->{861310369} = "Luohe\,\ Henan";
$areanames{en}->{861310370} = "Shangqiu\,\ Henan";
$areanames{en}->{861310371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861310372} = "Anyang\,\ Henan";
$areanames{en}->{861310373} = "Xinxiang\,\ Henan";
$areanames{en}->{861310374} = "Xuchang\,\ Henan";
$areanames{en}->{861310375} = "Pingdingshan\,\ Henan";
$areanames{en}->{861310376} = "Xinyang\,\ Henan";
$areanames{en}->{861310377} = "Nanyang\,\ Henan";
$areanames{en}->{861310378} = "Kaifeng\,\ Henan";
$areanames{en}->{861310379} = "Luoyang\,\ Henan";
$areanames{en}->{86131038} = "Zhengzhou\,\ Henan";
$areanames{en}->{861310380} = "Xinxiang\,\ Henan";
$areanames{en}->{861310387} = "Zhoukou\,\ Henan";
$areanames{en}->{861310388} = "Xuchang\,\ Henan";
$areanames{en}->{861310389} = "Jiaozuo\,\ Henan";
$areanames{en}->{861310390} = "Shangqiu\,\ Henan";
$areanames{en}->{861310391} = "Jiaozuo\,\ Henan";
$areanames{en}->{861310392} = "Hebi\,\ Henan";
$areanames{en}->{861310393} = "Puyang\,\ Henan";
$areanames{en}->{861310394} = "Zhoukou\,\ Henan";
$areanames{en}->{861310395} = "Luohe\,\ Henan";
$areanames{en}->{861310396} = "Zhumadian\,\ Henan";
$areanames{en}->{861310397} = "Xinyang\,\ Henan";
$areanames{en}->{861310398} = "Sanmenxia\,\ Henan";
$areanames{en}->{861310399} = "Jiaozuo\,\ Henan";
$areanames{en}->{861310400} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310401} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310402} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310403} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310404} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310405} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310406} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861310407} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310408} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310409} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861310410} = "Tieling\,\ Liaoning";
$areanames{en}->{861310411} = "Dalian\,\ Liaoning";
$areanames{en}->{861310412} = "Anshan\,\ Liaoning";
$areanames{en}->{861310413} = "Fushun\,\ Liaoning";
$areanames{en}->{861310414} = "Benxi\,\ Liaoning";
$areanames{en}->{861310415} = "Dandong\,\ Liaoning";
$areanames{en}->{861310416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861310417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861310418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861310419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861310420} = "Yingkou\,\ Liaoning";
$areanames{en}->{861310421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861310422} = "Anshan\,\ Liaoning";
$areanames{en}->{861310423} = "Fushun\,\ Liaoning";
$areanames{en}->{861310424} = "Benxi\,\ Liaoning";
$areanames{en}->{861310425} = "Dandong\,\ Liaoning";
$areanames{en}->{861310426} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861310427} = "Panjin\,\ Liaoning";
$areanames{en}->{861310428} = "Fuxin\,\ Liaoning";
$areanames{en}->{861310429} = "Huludao\,\ Liaoning";
$areanames{en}->{861310430} = "Changchun\,\ Jilin";
$areanames{en}->{861310431} = "Changchun\,\ Jilin";
$areanames{en}->{861310432} = "Jilin\,\ Jilin";
$areanames{en}->{861310433} = "Yanbian\,\ Jilin";
$areanames{en}->{861310434} = "Siping\,\ Jilin";
$areanames{en}->{861310435} = "Tonghua\,\ Jilin";
$areanames{en}->{861310436} = "Baicheng\,\ Jilin";
$areanames{en}->{861310437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861310438} = "Songyuan\,\ Jilin";
$areanames{en}->{861310439} = "Baishan\,\ Jilin";
$areanames{en}->{86131044} = "Changchun\,\ Jilin";
$areanames{en}->{861310450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861310453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861310454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861310455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861310456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861310457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861310458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861310459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86131046} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861310464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861310467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861310468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861310469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861310470} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310471} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310472} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310473} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310474} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310475} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310476} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310477} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310478} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310479} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310480} = "Yunfu\,\ Guangdong";
$areanames{en}->{861310481} = "Yunfu\,\ Guangdong";
$areanames{en}->{861310482} = "Shantou\,\ Guangdong";
$areanames{en}->{861310483} = "Shantou\,\ Guangdong";
$areanames{en}->{861310484} = "Xingtai\,\ Hebei";
$areanames{en}->{861310485} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861310486} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861310487} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861310488} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861310489} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861310490} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310491} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310492} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310493} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310494} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861310495} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861310496} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861310497} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861310498} = "Maoming\,\ Guangdong";
$areanames{en}->{861310499} = "Maoming\,\ Guangdong";
$areanames{en}->{86131050} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861310506} = "Quanzhou\,\ Fujian";
$areanames{en}->{861310507} = "Quanzhou\,\ Fujian";
$areanames{en}->{861310508} = "Quanzhou\,\ Fujian";
$areanames{en}->{861310509} = "Quanzhou\,\ Fujian";
$areanames{en}->{86131051} = "Qingdao\,\ Shandong";
$areanames{en}->{861310510} = "Rizhao\,\ Shandong";
$areanames{en}->{861310511} = "Zaozhuang\,\ Shandong";
$areanames{en}->{86131052} = "Yantai\,\ Shandong";
$areanames{en}->{861310530} = "Heze\,\ Shandong";
$areanames{en}->{861310531} = "Jinan\,\ Shandong";
$areanames{en}->{861310532} = "Qingdao\,\ Shandong";
$areanames{en}->{861310533} = "Zibo\,\ Shandong";
$areanames{en}->{861310534} = "Dezhou\,\ Shandong";
$areanames{en}->{861310535} = "Yantai\,\ Shandong";
$areanames{en}->{861310536} = "Weifang\,\ Shandong";
$areanames{en}->{861310537} = "Jining\,\ Shandong";
$areanames{en}->{861310538} = "TaiAn\,\ Shandong";
$areanames{en}->{861310539} = "Linyi\,\ Shandong";
$areanames{en}->{861310540} = "Heze\,\ Shandong";
$areanames{en}->{861310541} = "Jinan\,\ Shandong";
$areanames{en}->{861310542} = "Qingdao\,\ Shandong";
$areanames{en}->{861310543} = "Binzhou\,\ Shandong";
$areanames{en}->{861310544} = "Dezhou\,\ Shandong";
$areanames{en}->{861310545} = "Yantai\,\ Shandong";
$areanames{en}->{861310546} = "Dongying\,\ Shandong";
$areanames{en}->{861310547} = "Jining\,\ Shandong";
$areanames{en}->{861310548} = "TaiAn\,\ Shandong";
$areanames{en}->{861310549} = "Linyi\,\ Shandong";
$areanames{en}->{86131055} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861310550} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861310551} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861310559} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86131056} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861310571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861310572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861310573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861310574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861310575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861310576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861310578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861310579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861310580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861310581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861310582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861310583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861310584} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861310585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861310586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310587} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861310588} = "Lishui\,\ Zhejiang";
$areanames{en}->{861310589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861310590} = "Longyan\,\ Fujian";
$areanames{en}->{861310591} = "Longyan\,\ Fujian";
$areanames{en}->{861310592} = "Longyan\,\ Fujian";
$areanames{en}->{861310593} = "Ningde\,\ Fujian";
$areanames{en}->{861310594} = "Longyan\,\ Fujian";
$areanames{en}->{861310595} = "Ningde\,\ Fujian";
$areanames{en}->{861310596} = "Ningde\,\ Fujian";
$areanames{en}->{861310597} = "Ningde\,\ Fujian";
$areanames{en}->{861310598} = "Nanping\,\ Fujian";
$areanames{en}->{861310599} = "Nanping\,\ Fujian";
$areanames{en}->{86131060} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310606} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861310607} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861310608} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861310609} = "Quzhou\,\ Zhejiang";
$areanames{en}->{86131061} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86131062} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861310627} = "Lishui\,\ Zhejiang";
$areanames{en}->{861310628} = "Lishui\,\ Zhejiang";
$areanames{en}->{861310629} = "Lishui\,\ Zhejiang";
$areanames{en}->{86131063} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861310638} = "Lishui\,\ Zhejiang";
$areanames{en}->{861310639} = "Lishui\,\ Zhejiang";
$areanames{en}->{861310640} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861310641} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861310642} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861310643} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861310644} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861310645} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310646} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310647} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310648} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861310649} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86131065} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861310654} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861310657} = "Foshan\,\ Guangdong";
$areanames{en}->{861310658} = "Foshan\,\ Guangdong";
$areanames{en}->{861310659} = "Foshan\,\ Guangdong";
$areanames{en}->{861310660} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310661} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310662} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310663} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310664} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861310665} = "Foshan\,\ Guangdong";
$areanames{en}->{861310666} = "Foshan\,\ Guangdong";
$areanames{en}->{861310667} = "Foshan\,\ Guangdong";
$areanames{en}->{861310668} = "Foshan\,\ Guangdong";
$areanames{en}->{861310669} = "Langfang\,\ Hebei";
$areanames{en}->{86131067} = "Foshan\,\ Guangdong";
$areanames{en}->{861310677} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861310678} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861310679} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861310680} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310681} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310682} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310683} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310684} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861310685} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310686} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310687} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310688} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310689} = "Dongguan\,\ Guangdong";
$areanames{en}->{861310690} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861310691} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861310692} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861310693} = "Jieyang\,\ Guangdong";
$areanames{en}->{861310694} = "Jieyang\,\ Guangdong";
$areanames{en}->{861310695} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861310696} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861310697} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861310698} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861310699} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861310700} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861310701} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861310702} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861310703} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861310704} = "Hengyang\,\ Hunan";
$areanames{en}->{861310705} = "Chenzhou\,\ Hunan";
$areanames{en}->{861310706} = "Chenzhou\,\ Hunan";
$areanames{en}->{861310707} = "Yiyang\,\ Hunan";
$areanames{en}->{861310708} = "Chenzhou\,\ Hunan";
$areanames{en}->{861310709} = "Shaoyang\,\ Hunan";
$areanames{en}->{861310710} = "Yueyang\,\ Hunan";
$areanames{en}->{861310711} = "Changsha\,\ Hunan";
$areanames{en}->{861310712} = "Xiangtan\,\ Hunan";
$areanames{en}->{861310713} = "Xiangxi\,\ Hunan";
$areanames{en}->{861310714} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861310715} = "Huaihua\,\ Hunan";
$areanames{en}->{861310716} = "Yongzhou\,\ Hunan";
$areanames{en}->{861310717} = "Yiyang\,\ Hunan";
$areanames{en}->{861310718} = "Loudi\,\ Hunan";
$areanames{en}->{861310719} = "Shaoyang\,\ Hunan";
$areanames{en}->{861310720} = "Yueyang\,\ Hunan";
$areanames{en}->{861310721} = "Changsha\,\ Hunan";
$areanames{en}->{861310722} = "Xiangtan\,\ Hunan";
$areanames{en}->{861310723} = "Xiangxi\,\ Hunan";
$areanames{en}->{861310724} = "Hengyang\,\ Hunan";
$areanames{en}->{861310725} = "Huaihua\,\ Hunan";
$areanames{en}->{861310726} = "Yongzhou\,\ Hunan";
$areanames{en}->{861310727} = "Yiyang\,\ Hunan";
$areanames{en}->{861310728} = "Loudi\,\ Hunan";
$areanames{en}->{861310729} = "Shaoyang\,\ Hunan";
$areanames{en}->{861310730} = "Yueyang\,\ Hunan";
$areanames{en}->{861310731} = "Changsha\,\ Hunan";
$areanames{en}->{861310732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861310733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861310734} = "Hengyang\,\ Hunan";
$areanames{en}->{861310735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861310736} = "Changde\,\ Hunan";
$areanames{en}->{861310737} = "Yiyang\,\ Hunan";
$areanames{en}->{861310738} = "Loudi\,\ Hunan";
$areanames{en}->{861310739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861310740} = "Changde\,\ Hunan";
$areanames{en}->{861310741} = "Changsha\,\ Hunan";
$areanames{en}->{861310742} = "Changsha\,\ Hunan";
$areanames{en}->{861310743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861310744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861310745} = "Huaihua\,\ Hunan";
$areanames{en}->{861310746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861310747} = "Yueyang\,\ Hunan";
$areanames{en}->{861310748} = "Changsha\,\ Hunan";
$areanames{en}->{861310749} = "Changsha\,\ Hunan";
$areanames{en}->{861310750} = "Haidong\,\ Qinghai";
$areanames{en}->{861310751} = "Haidong\,\ Qinghai";
$areanames{en}->{861310752} = "Haidong\,\ Qinghai";
$areanames{en}->{861310753} = "Haidong\,\ Qinghai";
$areanames{en}->{861310754} = "Haixi\,\ Qinghai";
$areanames{en}->{861310755} = "Xining\,\ Qinghai";
$areanames{en}->{861310756} = "Haixi\,\ Qinghai";
$areanames{en}->{861310757} = "Haixi\,\ Qinghai";
$areanames{en}->{861310758} = "Xining\,\ Qinghai";
$areanames{en}->{861310759} = "Xining\,\ Qinghai";
$areanames{en}->{86131076} = "Fuzhou\,\ Fujian";
$areanames{en}->{861310770} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861310771} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861310772} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861310773} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861310774} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861310775} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861310776} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861310777} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861310778} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861310779} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86131078} = "Quanzhou\,\ Fujian";
$areanames{en}->{861310790} = "Sanming\,\ Fujian";
$areanames{en}->{861310791} = "Sanming\,\ Fujian";
$areanames{en}->{861310792} = "Fuzhou\,\ Fujian";
$areanames{en}->{861310793} = "Fuzhou\,\ Fujian";
$areanames{en}->{861310794} = "Fuzhou\,\ Fujian";
$areanames{en}->{861310795} = "Putian\,\ Fujian";
$areanames{en}->{861310796} = "Putian\,\ Fujian";
$areanames{en}->{861310797} = "Putian\,\ Fujian";
$areanames{en}->{861310798} = "Putian\,\ Fujian";
$areanames{en}->{861310799} = "Putian\,\ Fujian";
$areanames{en}->{861310800} = "Yibin\,\ Sichuan";
$areanames{en}->{861310801} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861310802} = "YanAn\,\ Shaanxi";
$areanames{en}->{861310803} = "Neijiang\,\ Sichuan";
$areanames{en}->{861310804} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310805} = "Luzhou\,\ Sichuan";
$areanames{en}->{861310806} = "Luzhou\,\ Sichuan";
$areanames{en}->{861310807} = "Ziyang\,\ Sichuan";
$areanames{en}->{861310808} = "Zigong\,\ Sichuan";
$areanames{en}->{861310809} = "YanAn\,\ Shaanxi";
$areanames{en}->{86131081} = "Mianyang\,\ Sichuan";
$areanames{en}->{861310812} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861310813} = "YanAn\,\ Shaanxi";
$areanames{en}->{861310817} = "Nanchong\,\ Sichuan";
$areanames{en}->{861310818} = "Dazhou\,\ Sichuan";
$areanames{en}->{861310820} = "Meishan\,\ Sichuan";
$areanames{en}->{861310821} = "Deyang\,\ Sichuan";
$areanames{en}->{861310822} = "Deyang\,\ Sichuan";
$areanames{en}->{861310823} = "Leshan\,\ Sichuan";
$areanames{en}->{861310824} = "Leshan\,\ Sichuan";
$areanames{en}->{861310825} = "Suining\,\ Sichuan";
$areanames{en}->{861310826} = "GuangAn\,\ Sichuan";
$areanames{en}->{861310827} = "Bazhong\,\ Sichuan";
$areanames{en}->{861310828} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310829} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310830} = "Luzhou\,\ Sichuan";
$areanames{en}->{861310831} = "Yibin\,\ Sichuan";
$areanames{en}->{861310832} = "Neijiang\,\ Sichuan";
$areanames{en}->{861310833} = "Leshan\,\ Sichuan";
$areanames{en}->{861310834} = "Liangshan\,\ Sichuan";
$areanames{en}->{861310835} = "YaAn\,\ Sichuan";
$areanames{en}->{861310836} = "Garze\,\ Sichuan";
$areanames{en}->{861310837} = "Aba\,\ Sichuan";
$areanames{en}->{861310838} = "Deyang\,\ Sichuan";
$areanames{en}->{861310839} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861310840} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861310841} = "Deyang\,\ Sichuan";
$areanames{en}->{861310842} = "GuangAn\,\ Sichuan";
$areanames{en}->{861310843} = "Meishan\,\ Sichuan";
$areanames{en}->{861310844} = "Dazhou\,\ Sichuan";
$areanames{en}->{861310845} = "Suining\,\ Sichuan";
$areanames{en}->{861310846} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861310847} = "Weinan\,\ Shaanxi";
$areanames{en}->{861310848} = "Liangshan\,\ Sichuan";
$areanames{en}->{861310849} = "Yulin\,\ Shaanxi";
$areanames{en}->{861310850} = "Kunming\,\ Yunnan";
$areanames{en}->{861310851} = "Kunming\,\ Yunnan";
$areanames{en}->{861310852} = "Kunming\,\ Yunnan";
$areanames{en}->{861310853} = "Kunming\,\ Yunnan";
$areanames{en}->{861310854} = "Kunming\,\ Yunnan";
$areanames{en}->{861310855} = "Dehong\,\ Yunnan";
$areanames{en}->{861310856} = "Dali\,\ Yunnan";
$areanames{en}->{861310857} = "Dali\,\ Yunnan";
$areanames{en}->{861310858} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861310859} = "Puer\,\ Yunnan";
$areanames{en}->{861310860} = "Honghe\,\ Yunnan";
$areanames{en}->{861310861} = "Honghe\,\ Yunnan";
$areanames{en}->{861310862} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861310863} = "Qujing\,\ Yunnan";
$areanames{en}->{861310864} = "Yuxi\,\ Yunnan";
$areanames{en}->{861310865} = "Kunming\,\ Yunnan";
$areanames{en}->{861310866} = "Kunming\,\ Yunnan";
$areanames{en}->{861310867} = "Kunming\,\ Yunnan";
$areanames{en}->{861310868} = "Kunming\,\ Yunnan";
$areanames{en}->{861310869} = "Kunming\,\ Yunnan";
$areanames{en}->{861310870} = "Kunming\,\ Yunnan";
$areanames{en}->{861310871} = "Kunming\,\ Yunnan";
$areanames{en}->{861310872} = "Dali\,\ Yunnan";
$areanames{en}->{861310873} = "Honghe\,\ Yunnan";
$areanames{en}->{861310874} = "Qujing\,\ Yunnan";
$areanames{en}->{861310875} = "Baoshan\,\ Yunnan";
$areanames{en}->{861310876} = "Kunming\,\ Yunnan";
$areanames{en}->{861310877} = "Yuxi\,\ Yunnan";
$areanames{en}->{861310878} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861310879} = "Puer\,\ Yunnan";
$areanames{en}->{86131088} = "Kunming\,\ Yunnan";
$areanames{en}->{861310881} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861310882} = "Dehong\,\ Yunnan";
$areanames{en}->{861310888} = "Lijiang\,\ Yunnan";
$areanames{en}->{86131089} = "Chongqing";
$areanames{en}->{861310900} = "Changji\,\ Xinjiang";
$areanames{en}->{861310901} = "Changji\,\ Xinjiang";
$areanames{en}->{861310902} = "Changji\,\ Xinjiang";
$areanames{en}->{861310903} = "Turpan\,\ Xinjiang";
$areanames{en}->{861310904} = "Ili\,\ Xinjiang";
$areanames{en}->{861310905} = "Ili\,\ Xinjiang";
$areanames{en}->{861310906} = "Ili\,\ Xinjiang";
$areanames{en}->{861310907} = "Ili\,\ Xinjiang";
$areanames{en}->{861310908} = "Ili\,\ Xinjiang";
$areanames{en}->{861310909} = "Aksu\,\ Xinjiang";
$areanames{en}->{861310910} = "Weinan\,\ Shaanxi";
$areanames{en}->{861310911} = "Weinan\,\ Shaanxi";
$areanames{en}->{861310912} = "Weinan\,\ Shaanxi";
$areanames{en}->{861310913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861310914} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310915} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310916} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310918} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861310919} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{86131092} = "Yulin\,\ Shaanxi";
$areanames{en}->{861310926} = "Ankang\,\ Shaanxi";
$areanames{en}->{861310927} = "Ankang\,\ Shaanxi";
$areanames{en}->{861310928} = "Ankang\,\ Shaanxi";
$areanames{en}->{861310929} = "Ankang\,\ Shaanxi";
$areanames{en}->{86131093} = "Lanzhou\,\ Gansu";
$areanames{en}->{861310934} = "Qingyang\,\ Gansu";
$areanames{en}->{86131094} = "Lanzhou\,\ Gansu";
$areanames{en}->{861310944} = "Dingxi\,\ Gansu";
$areanames{en}->{861310945} = "Jinchang\,\ Gansu";
$areanames{en}->{861310946} = "Tianshui\,\ Gansu";
$areanames{en}->{861310947} = "Jiuquan\,\ Gansu";
$areanames{en}->{86131095} = "XiAn\,\ Shaanxi";
$areanames{en}->{861310960} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861310961} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861310962} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861310963} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861310964} = "Weinan\,\ Shaanxi";
$areanames{en}->{861310965} = "Weinan\,\ Shaanxi";
$areanames{en}->{861310966} = "Baoji\,\ Shaanxi";
$areanames{en}->{861310967} = "YanAn\,\ Shaanxi";
$areanames{en}->{861310968} = "Yulin\,\ Shaanxi";
$areanames{en}->{861310969} = "Yulin\,\ Shaanxi";
$areanames{en}->{86131097} = "Xining\,\ Qinghai";
$areanames{en}->{861310980} = "Dalian\,\ Liaoning";
$areanames{en}->{861310981} = "Dalian\,\ Liaoning";
$areanames{en}->{861310982} = "Dalian\,\ Liaoning";
$areanames{en}->{861310983} = "Dalian\,\ Liaoning";
$areanames{en}->{861310984} = "Dalian\,\ Liaoning";
$areanames{en}->{861310985} = "Shenyang\,\ Liaoning";
$areanames{en}->{861310986} = "Shenyang\,\ Liaoning";
$areanames{en}->{861310987} = "Shenyang\,\ Liaoning";
$areanames{en}->{861310988} = "Shenyang\,\ Liaoning";
$areanames{en}->{861310989} = "Shenyang\,\ Liaoning";
$areanames{en}->{86131099} = "Urumchi\,\ Xinjiang";
$areanames{en}->{86131100} = "Tianjin";
$areanames{en}->{86131101} = "Chongqing";
$areanames{en}->{86131102} = "Chongqing";
$areanames{en}->{86131103} = "Weinan\,\ Shaanxi";
$areanames{en}->{861311036} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861311037} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861311038} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861311039} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{86131104} = "XiAn\,\ Shaanxi";
$areanames{en}->{861311050} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311051} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311052} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311053} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311054} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311055} = "Putian\,\ Fujian";
$areanames{en}->{861311056} = "Putian\,\ Fujian";
$areanames{en}->{861311057} = "Nanping\,\ Fujian";
$areanames{en}->{861311058} = "Sanming\,\ Fujian";
$areanames{en}->{861311059} = "Xiamen\,\ Fujian";
$areanames{en}->{861311060} = "Longyan\,\ Fujian";
$areanames{en}->{861311061} = "Longyan\,\ Fujian";
$areanames{en}->{861311062} = "Longyan\,\ Fujian";
$areanames{en}->{861311063} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311064} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311065} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861311066} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861311067} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861311068} = "Longyan\,\ Fujian";
$areanames{en}->{861311069} = "Putian\,\ Fujian";
$areanames{en}->{861311070} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311071} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311072} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311073} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311074} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311075} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311076} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311077} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311078} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311079} = "Fuzhou\,\ Fujian";
$areanames{en}->{86131108} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311084} = "Sanming\,\ Fujian";
$areanames{en}->{861311087} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311088} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311089} = "Fuzhou\,\ Fujian";
$areanames{en}->{86131109} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311090} = "Nanping\,\ Fujian";
$areanames{en}->{861311091} = "Nanping\,\ Fujian";
$areanames{en}->{861311092} = "Xiamen\,\ Fujian";
$areanames{en}->{861311093} = "Xiamen\,\ Fujian";
$areanames{en}->{86131110} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861311101} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861311102} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861311103} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861311110} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861311111} = "Linfen\,\ Shanxi";
$areanames{en}->{861311112} = "Datong\,\ Shanxi";
$areanames{en}->{861311113} = "Yangquan\,\ Shanxi";
$areanames{en}->{861311114} = "Jincheng\,\ Shanxi";
$areanames{en}->{861311115} = "Changzhi\,\ Shanxi";
$areanames{en}->{861311116} = "Jincheng\,\ Shanxi";
$areanames{en}->{861311117} = "Linfen\,\ Shanxi";
$areanames{en}->{861311118} = "Lüliang\,\ Shanxi";
$areanames{en}->{861311119} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861311120} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861311121} = "Lüliang\,\ Shanxi";
$areanames{en}->{861311122} = "Datong\,\ Shanxi";
$areanames{en}->{861311123} = "Yangquan\,\ Shanxi";
$areanames{en}->{861311124} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861311125} = "Changzhi\,\ Shanxi";
$areanames{en}->{861311126} = "Jincheng\,\ Shanxi";
$areanames{en}->{861311127} = "Linfen\,\ Shanxi";
$areanames{en}->{861311128} = "Datong\,\ Shanxi";
$areanames{en}->{861311129} = "Yuncheng\,\ Shanxi";
$areanames{en}->{86131113} = "Handan\,\ Hebei";
$areanames{en}->{86131114} = "Tangshan\,\ Hebei";
$areanames{en}->{861311140} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861311141} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861311142} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861311143} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86131115} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86131116} = "Baoding\,\ Hebei";
$areanames{en}->{86131117} = "Cangzhou\,\ Hebei";
$areanames{en}->{861311180} = "Aba\,\ Sichuan";
$areanames{en}->{861311181} = "Garze\,\ Sichuan";
$areanames{en}->{861311182} = "YaAn\,\ Sichuan";
$areanames{en}->{861311183} = "YaAn\,\ Sichuan";
$areanames{en}->{861311184} = "YaAn\,\ Sichuan";
$areanames{en}->{861311185} = "Chengdu\,\ Sichuan";
$areanames{en}->{861311186} = "Chengdu\,\ Sichuan";
$areanames{en}->{861311187} = "Chengdu\,\ Sichuan";
$areanames{en}->{861311188} = "Chengdu\,\ Sichuan";
$areanames{en}->{861311189} = "Chengdu\,\ Sichuan";
$areanames{en}->{86131119} = "Haikou\,\ Hainan";
$areanames{en}->{86131120} = "Shaoguan\,\ Guangdong";
$areanames{en}->{86131121} = "Jieyang\,\ Guangdong";
$areanames{en}->{86131122} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131123} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86131124} = "Meizhou\,\ Guangdong";
$areanames{en}->{86131125} = "Shantou\,\ Guangdong";
$areanames{en}->{861311250} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861311251} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861311252} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861311253} = "Chaozhou\,\ Guangdong";
$areanames{en}->{86131126} = "Huizhou\,\ Guangdong";
$areanames{en}->{86131127} = "Foshan\,\ Guangdong";
$areanames{en}->{86131128} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131129} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861311300} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861311301} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861311302} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861311303} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861311304} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861311305} = "Dongguan\,\ Guangdong";
$areanames{en}->{861311306} = "Dongguan\,\ Guangdong";
$areanames{en}->{861311307} = "Dongguan\,\ Guangdong";
$areanames{en}->{861311308} = "Dongguan\,\ Guangdong";
$areanames{en}->{861311309} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131131} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131132} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131133} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861311340} = "Huizhou\,\ Guangdong";
$areanames{en}->{861311341} = "Huizhou\,\ Guangdong";
$areanames{en}->{861311342} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861311343} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861311344} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861311345} = "Xingtai\,\ Hebei";
$areanames{en}->{861311346} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861311347} = "Shantou\,\ Guangdong";
$areanames{en}->{861311348} = "Shantou\,\ Guangdong";
$areanames{en}->{861311349} = "Shantou\,\ Guangdong";
$areanames{en}->{861311350} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861311351} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861311352} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861311353} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861311354} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861311355} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861311356} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861311357} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861311358} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861311359} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{86131136} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131137} = "Foshan\,\ Guangdong";
$areanames{en}->{861311370} = "Langfang\,\ Hebei";
$areanames{en}->{86131138} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861311388} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861311389} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861311390} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861311391} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861311392} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861311393} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861311394} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861311395} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861311396} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861311397} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861311398} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861311399} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131140} = "Chongqing";
$areanames{en}->{861311410} = "Yuxi\,\ Yunnan";
$areanames{en}->{861311411} = "Qujing\,\ Yunnan";
$areanames{en}->{861311412} = "Dali\,\ Yunnan";
$areanames{en}->{861311413} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861311414} = "Kunming\,\ Yunnan";
$areanames{en}->{861311415} = "Puer\,\ Yunnan";
$areanames{en}->{861311416} = "Lincang\,\ Yunnan";
$areanames{en}->{861311417} = "Wenshan\,\ Yunnan";
$areanames{en}->{861311418} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861311419} = "Baoshan\,\ Yunnan";
$areanames{en}->{86131142} = "Kunming\,\ Yunnan";
$areanames{en}->{86131143} = "Wuhan\,\ Hubei";
$areanames{en}->{861311430} = "Jingzhou\,\ Hubei";
$areanames{en}->{861311431} = "Jingzhou\,\ Hubei";
$areanames{en}->{861311440} = "Suizhou\,\ Hubei";
$areanames{en}->{861311441} = "Xiaogan\,\ Hubei";
$areanames{en}->{861311442} = "Huangshi\,\ Hubei";
$areanames{en}->{861311443} = "Huanggang\,\ Hubei";
$areanames{en}->{861311444} = "Shiyan\,\ Hubei";
$areanames{en}->{861311445} = "Yichang\,\ Hubei";
$areanames{en}->{861311446} = "Yichang\,\ Hubei";
$areanames{en}->{861311447} = "Xiangfan\,\ Hubei";
$areanames{en}->{861311448} = "Xiangfan\,\ Hubei";
$areanames{en}->{861311449} = "Jingmen\,\ Hubei";
$areanames{en}->{861311450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861311453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861311454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861311455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861311456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861311457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861311458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861311459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311460} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311461} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311462} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861311463} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861311464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861311465} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861311466} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861311467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861311468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861311469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861311470} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861311471} = "Nanning\,\ Guangxi";
$areanames{en}->{861311472} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861311473} = "Guilin\,\ Guangxi";
$areanames{en}->{861311474} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861311475} = "Yulin\,\ Guangxi";
$areanames{en}->{861311476} = "Baise\,\ Guangxi";
$areanames{en}->{861311477} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861311478} = "Hechi\,\ Guangxi";
$areanames{en}->{861311479} = "Beihai\,\ Guangxi";
$areanames{en}->{86131148} = "Tianjin";
$areanames{en}->{86131149} = "Tianjin";
$areanames{en}->{861311500} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861311501} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861311502} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861311503} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861311504} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861311505} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861311506} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861311507} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861311508} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861311509} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861311510} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861311511} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861311512} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861311513} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861311514} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861311515} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861311516} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861311517} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861311518} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861311519} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861311520} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861311521} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861311522} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861311523} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861311524} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861311525} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861311526} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861311527} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861311528} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861311529} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861311530} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311531} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311532} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861311533} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861311534} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861311535} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861311536} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861311537} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861311538} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861311539} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311540} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311541} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311542} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311543} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311544} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311545} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311546} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861311547} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861311548} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861311549} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311550} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311551} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311552} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861311553} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861311554} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861311555} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311556} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861311557} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861311558} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861311559} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311560} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311561} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861311562} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861311563} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861311564} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861311565} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861311566} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861311567} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861311568} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861311569} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861311570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861311571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861311572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861311573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861311574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861311575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861311576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861311577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861311578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861311579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86131158} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861311580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861311590} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311592} = "Fuzhou\,\ Fujian";
$areanames{en}->{861311593} = "Ningde\,\ Fujian";
$areanames{en}->{861311594} = "Putian\,\ Fujian";
$areanames{en}->{861311595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861311596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861311597} = "Ningde\,\ Fujian";
$areanames{en}->{861311598} = "Sanming\,\ Fujian";
$areanames{en}->{861311599} = "Quanzhou\,\ Fujian";
$areanames{en}->{86131160} = "Tianjin";
$areanames{en}->{86131161} = "Tianjin";
$areanames{en}->{86131162} = "Kunming\,\ Yunnan";
$areanames{en}->{861311630} = "Guiyang\,\ Guizhou";
$areanames{en}->{861311631} = "Guiyang\,\ Guizhou";
$areanames{en}->{861311632} = "Guiyang\,\ Guizhou";
$areanames{en}->{861311633} = "Zunyi\,\ Guizhou";
$areanames{en}->{861311634} = "Zunyi\,\ Guizhou";
$areanames{en}->{861311635} = "Zunyi\,\ Guizhou";
$areanames{en}->{861311636} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861311637} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861311638} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861311639} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861311640} = "Anshun\,\ Guizhou";
$areanames{en}->{861311641} = "Anshun\,\ Guizhou";
$areanames{en}->{861311642} = "Qiannan\,\ Guizhou";
$areanames{en}->{861311643} = "Qiannan\,\ Guizhou";
$areanames{en}->{861311644} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861311645} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861311646} = "Bijie\,\ Guizhou";
$areanames{en}->{861311647} = "Bijie\,\ Guizhou";
$areanames{en}->{861311648} = "Tongren\,\ Guizhou";
$areanames{en}->{861311649} = "Guiyang\,\ Guizhou";
$areanames{en}->{86131165} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86131166} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86131167} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861311680} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861311681} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861311682} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861311683} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861311684} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861311685} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861311686} = "Lishui\,\ Zhejiang";
$areanames{en}->{861311687} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861311688} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861311689} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861311690} = "Deqen\,\ Yunnan";
$areanames{en}->{861311691} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861311692} = "Dehong\,\ Yunnan";
$areanames{en}->{861311693} = "Nujiang\,\ Yunnan";
$areanames{en}->{861311694} = "Lijiang\,\ Yunnan";
$areanames{en}->{861311695} = "Kunming\,\ Yunnan";
$areanames{en}->{861311696} = "Lijiang\,\ Yunnan";
$areanames{en}->{861311697} = "Honghe\,\ Yunnan";
$areanames{en}->{861311698} = "Dehong\,\ Yunnan";
$areanames{en}->{861311699} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861311700} = "Xiaogan\,\ Hubei";
$areanames{en}->{861311701} = "Huangshi\,\ Hubei";
$areanames{en}->{861311702} = "Huangshi\,\ Hubei";
$areanames{en}->{861311703} = "Huangshi\,\ Hubei";
$areanames{en}->{861311704} = "Xianning\,\ Hubei";
$areanames{en}->{861311705} = "Jingmen\,\ Hubei";
$areanames{en}->{861311706} = "Jingmen\,\ Hubei";
$areanames{en}->{861311707} = "Huanggang\,\ Hubei";
$areanames{en}->{861311708} = "Huanggang\,\ Hubei";
$areanames{en}->{861311709} = "Huanggang\,\ Hubei";
$areanames{en}->{861311710} = "Shiyan\,\ Hubei";
$areanames{en}->{861311711} = "Wuhan\,\ Hubei";
$areanames{en}->{861311712} = "Wuhan\,\ Hubei";
$areanames{en}->{861311713} = "Enshi\,\ Hubei";
$areanames{en}->{861311714} = "Enshi\,\ Hubei";
$areanames{en}->{861311715} = "Xianning\,\ Hubei";
$areanames{en}->{861311716} = "Xianning\,\ Hubei";
$areanames{en}->{861311717} = "Jingzhou\,\ Hubei";
$areanames{en}->{861311718} = "Jingzhou\,\ Hubei";
$areanames{en}->{861311719} = "Jingzhou\,\ Hubei";
$areanames{en}->{861311720} = "Ezhou\,\ Hubei";
$areanames{en}->{861311721} = "Xiangfan\,\ Hubei";
$areanames{en}->{861311722} = "Xiangfan\,\ Hubei";
$areanames{en}->{861311723} = "Xiangfan\,\ Hubei";
$areanames{en}->{861311724} = "Wuhan\,\ Hubei";
$areanames{en}->{861311725} = "Wuhan\,\ Hubei";
$areanames{en}->{861311726} = "Suizhou\,\ Hubei";
$areanames{en}->{861311727} = "Yichang\,\ Hubei";
$areanames{en}->{861311728} = "Yichang\,\ Hubei";
$areanames{en}->{861311729} = "Yichang\,\ Hubei";
$areanames{en}->{861311730} = "Yueyang\,\ Hunan";
$areanames{en}->{861311731} = "Changsha\,\ Hunan";
$areanames{en}->{861311732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861311733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861311734} = "Hengyang\,\ Hunan";
$areanames{en}->{861311735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861311736} = "Changde\,\ Hunan";
$areanames{en}->{861311737} = "Yiyang\,\ Hunan";
$areanames{en}->{861311738} = "Loudi\,\ Hunan";
$areanames{en}->{861311739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861311740} = "Yueyang\,\ Hunan";
$areanames{en}->{861311741} = "Changsha\,\ Hunan";
$areanames{en}->{861311742} = "Xiangtan\,\ Hunan";
$areanames{en}->{861311743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861311744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861311745} = "Huaihua\,\ Hunan";
$areanames{en}->{861311746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861311747} = "Yiyang\,\ Hunan";
$areanames{en}->{861311748} = "Loudi\,\ Hunan";
$areanames{en}->{861311749} = "Shaoyang\,\ Hunan";
$areanames{en}->{861311750} = "Yueyang\,\ Hunan";
$areanames{en}->{861311751} = "Changsha\,\ Hunan";
$areanames{en}->{861311752} = "Xiangtan\,\ Hunan";
$areanames{en}->{861311753} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861311754} = "Hengyang\,\ Hunan";
$areanames{en}->{861311755} = "Chenzhou\,\ Hunan";
$areanames{en}->{861311756} = "Changde\,\ Hunan";
$areanames{en}->{861311757} = "Yiyang\,\ Hunan";
$areanames{en}->{861311758} = "Loudi\,\ Hunan";
$areanames{en}->{861311759} = "Shaoyang\,\ Hunan";
$areanames{en}->{861311760} = "Nanning\,\ Guangxi";
$areanames{en}->{861311761} = "Nanning\,\ Guangxi";
$areanames{en}->{861311762} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861311763} = "Guilin\,\ Guangxi";
$areanames{en}->{861311764} = "Hezhou\,\ Guangxi";
$areanames{en}->{861311765} = "Yulin\,\ Guangxi";
$areanames{en}->{861311766} = "Guigang\,\ Guangxi";
$areanames{en}->{861311767} = "Hezhou\,\ Guangxi";
$areanames{en}->{861311768} = "Hechi\,\ Guangxi";
$areanames{en}->{861311769} = "Guigang\,\ Guangxi";
$areanames{en}->{861311770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861311771} = "Nanning\,\ Guangxi";
$areanames{en}->{861311772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861311773} = "Guilin\,\ Guangxi";
$areanames{en}->{861311774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861311775} = "Yulin\,\ Guangxi";
$areanames{en}->{861311776} = "Baise\,\ Guangxi";
$areanames{en}->{861311777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861311778} = "Hechi\,\ Guangxi";
$areanames{en}->{861311779} = "Beihai\,\ Guangxi";
$areanames{en}->{861311780} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861311781} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861311782} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861311783} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861311784} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861311785} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861311786} = "JiAn\,\ Jiangxi";
$areanames{en}->{861311787} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861311788} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861311789} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861311790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861311791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861311792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861311793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861311794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861311795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861311796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861311797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861311798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861311799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861311800} = "Yibin\,\ Sichuan";
$areanames{en}->{861311801} = "Yibin\,\ Sichuan";
$areanames{en}->{861311802} = "Luzhou\,\ Sichuan";
$areanames{en}->{861311803} = "Luzhou\,\ Sichuan";
$areanames{en}->{861311804} = "Ziyang\,\ Sichuan";
$areanames{en}->{861311805} = "Ziyang\,\ Sichuan";
$areanames{en}->{861311806} = "Neijiang\,\ Sichuan";
$areanames{en}->{861311807} = "Neijiang\,\ Sichuan";
$areanames{en}->{861311808} = "Zigong\,\ Sichuan";
$areanames{en}->{861311809} = "Zigong\,\ Sichuan";
$areanames{en}->{861311810} = "Deyang\,\ Sichuan";
$areanames{en}->{861311811} = "Deyang\,\ Sichuan";
$areanames{en}->{861311812} = "Deyang\,\ Sichuan";
$areanames{en}->{861311813} = "Deyang\,\ Sichuan";
$areanames{en}->{861311814} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861311815} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861311816} = "Mianyang\,\ Sichuan";
$areanames{en}->{861311817} = "Mianyang\,\ Sichuan";
$areanames{en}->{861311818} = "Mianyang\,\ Sichuan";
$areanames{en}->{861311819} = "Mianyang\,\ Sichuan";
$areanames{en}->{861311820} = "Suining\,\ Sichuan";
$areanames{en}->{861311821} = "Suining\,\ Sichuan";
$areanames{en}->{861311822} = "Suining\,\ Sichuan";
$areanames{en}->{861311823} = "GuangAn\,\ Sichuan";
$areanames{en}->{861311824} = "GuangAn\,\ Sichuan";
$areanames{en}->{861311825} = "GuangAn\,\ Sichuan";
$areanames{en}->{861311826} = "Nanchong\,\ Sichuan";
$areanames{en}->{861311827} = "Nanchong\,\ Sichuan";
$areanames{en}->{861311828} = "Nanchong\,\ Sichuan";
$areanames{en}->{861311829} = "Nanchong\,\ Sichuan";
$areanames{en}->{861311830} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861311831} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861311832} = "Liangshan\,\ Sichuan";
$areanames{en}->{861311833} = "Liangshan\,\ Sichuan";
$areanames{en}->{861311834} = "Meishan\,\ Sichuan";
$areanames{en}->{861311835} = "Meishan\,\ Sichuan";
$areanames{en}->{861311836} = "Meishan\,\ Sichuan";
$areanames{en}->{861311837} = "Leshan\,\ Sichuan";
$areanames{en}->{861311838} = "Leshan\,\ Sichuan";
$areanames{en}->{861311839} = "Leshan\,\ Sichuan";
$areanames{en}->{861311840} = "Ziyang\,\ Sichuan";
$areanames{en}->{861311841} = "Ziyang\,\ Sichuan";
$areanames{en}->{861311842} = "Ziyang\,\ Sichuan";
$areanames{en}->{861311843} = "Luzhou\,\ Sichuan";
$areanames{en}->{861311844} = "Luzhou\,\ Sichuan";
$areanames{en}->{861311845} = "Neijiang\,\ Sichuan";
$areanames{en}->{861311846} = "Neijiang\,\ Sichuan";
$areanames{en}->{861311847} = "Yibin\,\ Sichuan";
$areanames{en}->{861311848} = "Yibin\,\ Sichuan";
$areanames{en}->{861311849} = "Yibin\,\ Sichuan";
$areanames{en}->{861311850} = "Guiyang\,\ Guizhou";
$areanames{en}->{861311851} = "Guiyang\,\ Guizhou";
$areanames{en}->{861311852} = "Zunyi\,\ Guizhou";
$areanames{en}->{861311853} = "Anshun\,\ Guizhou";
$areanames{en}->{861311854} = "Qiannan\,\ Guizhou";
$areanames{en}->{861311855} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861311856} = "Tongren\,\ Guizhou";
$areanames{en}->{861311857} = "Bijie\,\ Guizhou";
$areanames{en}->{861311858} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861311859} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86131186} = "Shantou\,\ Guangdong";
$areanames{en}->{861311860} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861311861} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861311862} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861311863} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861311870} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861311871} = "Kunming\,\ Yunnan";
$areanames{en}->{861311872} = "Dali\,\ Yunnan";
$areanames{en}->{861311873} = "Honghe\,\ Yunnan";
$areanames{en}->{861311874} = "Qujing\,\ Yunnan";
$areanames{en}->{861311875} = "Baoshan\,\ Yunnan";
$areanames{en}->{861311876} = "Wenshan\,\ Yunnan";
$areanames{en}->{861311877} = "Yuxi\,\ Yunnan";
$areanames{en}->{861311878} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861311879} = "Puer\,\ Yunnan";
$areanames{en}->{86131188} = "Foshan\,\ Guangdong";
$areanames{en}->{86131189} = "Haikou\,\ Hainan";
$areanames{en}->{861311900} = "Changji\,\ Xinjiang";
$areanames{en}->{861311901} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861311902} = "Hami\,\ Xinjiang";
$areanames{en}->{861311903} = "Hotan\,\ Xinjiang";
$areanames{en}->{861311904} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861311905} = "Altay\,\ Xinjiang";
$areanames{en}->{861311906} = "Altay\,\ Xinjiang";
$areanames{en}->{861311907} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861311908} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861311909} = "Bortala\,\ Xinjiang";
$areanames{en}->{86131191} = "XiAn\,\ Shaanxi";
$areanames{en}->{86131192} = "YanAn\,\ Shaanxi";
$areanames{en}->{861311928} = "Yulin\,\ Shaanxi";
$areanames{en}->{861311929} = "Yulin\,\ Shaanxi";
$areanames{en}->{861311930} = "Lanzhou\,\ Gansu";
$areanames{en}->{861311931} = "Lanzhou\,\ Gansu";
$areanames{en}->{861311932} = "Dingxi\,\ Gansu";
$areanames{en}->{861311933} = "Pingliang\,\ Gansu";
$areanames{en}->{861311934} = "Qingyang\,\ Gansu";
$areanames{en}->{861311935} = "Wuwei\,\ Gansu";
$areanames{en}->{861311936} = "Zhangye\,\ Gansu";
$areanames{en}->{861311937} = "Jiuquan\,\ Gansu";
$areanames{en}->{861311938} = "Tianshui\,\ Gansu";
$areanames{en}->{861311939} = "Qingyang\,\ Gansu";
$areanames{en}->{861311940} = "Lanzhou\,\ Gansu";
$areanames{en}->{861311941} = "Lanzhou\,\ Gansu";
$areanames{en}->{861311942} = "Lanzhou\,\ Gansu";
$areanames{en}->{861311943} = "Lanzhou\,\ Gansu";
$areanames{en}->{861311944} = "Lanzhou\,\ Gansu";
$areanames{en}->{861311945} = "Jiuquan\,\ Gansu";
$areanames{en}->{861311946} = "Jiuquan\,\ Gansu";
$areanames{en}->{861311947} = "Pingliang\,\ Gansu";
$areanames{en}->{861311948} = "Wuwei\,\ Gansu";
$areanames{en}->{861311949} = "Qingyang\,\ Gansu";
$areanames{en}->{86131195} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131196} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861311970} = "Haibei\,\ Qinghai";
$areanames{en}->{861311971} = "Xining\,\ Qinghai";
$areanames{en}->{861311972} = "Haidong\,\ Qinghai";
$areanames{en}->{861311973} = "Huangnan\,\ Qinghai";
$areanames{en}->{861311974} = "Hainan\,\ Qinghai";
$areanames{en}->{861311975} = "Haixi\,\ Qinghai";
$areanames{en}->{861311976} = "Xining\,\ Qinghai";
$areanames{en}->{861311977} = "Haixi\,\ Qinghai";
$areanames{en}->{861311978} = "Xining\,\ Qinghai";
$areanames{en}->{861311979} = "Haixi\,\ Qinghai";
$areanames{en}->{861311980} = "Shanwei\,\ Guangdong";
$areanames{en}->{861311981} = "Shanwei\,\ Guangdong";
$areanames{en}->{861311982} = "Shanwei\,\ Guangdong";
$areanames{en}->{861311983} = "Shanwei\,\ Guangdong";
$areanames{en}->{861311984} = "Shanwei\,\ Guangdong";
$areanames{en}->{861311985} = "Foshan\,\ Guangdong";
$areanames{en}->{861311986} = "Foshan\,\ Guangdong";
$areanames{en}->{861311987} = "Foshan\,\ Guangdong";
$areanames{en}->{861311988} = "Foshan\,\ Guangdong";
$areanames{en}->{861311989} = "Foshan\,\ Guangdong";
$areanames{en}->{861311990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861311991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861311992} = "Ili\,\ Xinjiang";
$areanames{en}->{861311993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861311994} = "Changji\,\ Xinjiang";
$areanames{en}->{861311995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861311996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861311997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861311998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861311999} = "Ili\,\ Xinjiang";
$areanames{en}->{86131200} = "Beijing";
$areanames{en}->{86131201} = "Beijing";
$areanames{en}->{86131202} = "Beijing";
$areanames{en}->{86131203} = "Beijing";
$areanames{en}->{86131204} = "Beijing";
$areanames{en}->{86131205} = "Shanghai";
$areanames{en}->{86131206} = "Shanghai";
$areanames{en}->{86131207} = "Shanghai";
$areanames{en}->{86131208} = "Shanghai";
$areanames{en}->{86131209} = "Shanghai";
$areanames{en}->{8613121} = "Beijing";
$areanames{en}->{861312144} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861312174} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{8613122} = "Shanghai";
$areanames{en}->{861312300} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312301} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312302} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312303} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312304} = "Sanming\,\ Fujian";
$areanames{en}->{861312305} = "Sanming\,\ Fujian";
$areanames{en}->{861312306} = "Sanming\,\ Fujian";
$areanames{en}->{861312307} = "Longyan\,\ Fujian";
$areanames{en}->{861312308} = "Longyan\,\ Fujian";
$areanames{en}->{861312309} = "Longyan\,\ Fujian";
$areanames{en}->{861312310} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312311} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312312} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312313} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312314} = "Ningde\,\ Fujian";
$areanames{en}->{861312315} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312316} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312317} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312318} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312319} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312320} = "Nanping\,\ Fujian";
$areanames{en}->{861312321} = "Nanping\,\ Fujian";
$areanames{en}->{861312322} = "Nanping\,\ Fujian";
$areanames{en}->{861312323} = "Ningde\,\ Fujian";
$areanames{en}->{861312324} = "Zhengzhou\,\ Henan";
$areanames{en}->{861312325} = "Ningde\,\ Fujian";
$areanames{en}->{861312326} = "Ningde\,\ Fujian";
$areanames{en}->{861312327} = "Putian\,\ Fujian";
$areanames{en}->{861312328} = "Putian\,\ Fujian";
$areanames{en}->{861312329} = "Putian\,\ Fujian";
$areanames{en}->{86131233} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861312336} = "Xiamen\,\ Fujian";
$areanames{en}->{861312337} = "Xiamen\,\ Fujian";
$areanames{en}->{861312338} = "Xiamen\,\ Fujian";
$areanames{en}->{861312339} = "Xiamen\,\ Fujian";
$areanames{en}->{861312340} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861312341} = "Nanning\,\ Guangxi";
$areanames{en}->{861312342} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861312343} = "Guilin\,\ Guangxi";
$areanames{en}->{861312344} = "Guigang\,\ Guangxi";
$areanames{en}->{861312345} = "Yulin\,\ Guangxi";
$areanames{en}->{861312346} = "Baise\,\ Guangxi";
$areanames{en}->{861312347} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861312348} = "Hechi\,\ Guangxi";
$areanames{en}->{861312349} = "Beihai\,\ Guangxi";
$areanames{en}->{861312350} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861312351} = "Nanning\,\ Guangxi";
$areanames{en}->{861312352} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861312353} = "Guilin\,\ Guangxi";
$areanames{en}->{861312354} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861312355} = "Yulin\,\ Guangxi";
$areanames{en}->{861312356} = "Baise\,\ Guangxi";
$areanames{en}->{861312357} = "Hezhou\,\ Guangxi";
$areanames{en}->{861312358} = "Hechi\,\ Guangxi";
$areanames{en}->{861312359} = "Beihai\,\ Guangxi";
$areanames{en}->{861312360} = "Guiyang\,\ Guizhou";
$areanames{en}->{861312361} = "Guiyang\,\ Guizhou";
$areanames{en}->{861312362} = "Zunyi\,\ Guizhou";
$areanames{en}->{861312363} = "Anshun\,\ Guizhou";
$areanames{en}->{861312364} = "Qiannan\,\ Guizhou";
$areanames{en}->{861312365} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861312366} = "Tongren\,\ Guizhou";
$areanames{en}->{861312367} = "Bijie\,\ Guizhou";
$areanames{en}->{861312368} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861312369} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86131237} = "Zhumadian\,\ Henan";
$areanames{en}->{86131238} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86131239} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861312396} = "Kashi\,\ Xinjiang";
$areanames{en}->{861312397} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861312398} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861312399} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861312400} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312401} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312402} = "Fuzhou\,\ Fujian";
$areanames{en}->{861312403} = "Xinyang\,\ Henan";
$areanames{en}->{861312404} = "Longyan\,\ Fujian";
$areanames{en}->{861312405} = "Jiaozuo\,\ Henan";
$areanames{en}->{861312406} = "Putian\,\ Fujian";
$areanames{en}->{861312407} = "Xiamen\,\ Fujian";
$areanames{en}->{861312408} = "Xiamen\,\ Fujian";
$areanames{en}->{861312409} = "Xiamen\,\ Fujian";
$areanames{en}->{861312410} = "Dalian\,\ Liaoning";
$areanames{en}->{861312411} = "Dalian\,\ Liaoning";
$areanames{en}->{861312412} = "Anshan\,\ Liaoning";
$areanames{en}->{861312413} = "Fushun\,\ Liaoning";
$areanames{en}->{861312414} = "Benxi\,\ Liaoning";
$areanames{en}->{861312415} = "Dandong\,\ Liaoning";
$areanames{en}->{861312416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861312417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861312418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861312419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{86131242} = "Shenyang\,\ Liaoning";
$areanames{en}->{861312427} = "Dalian\,\ Liaoning";
$areanames{en}->{861312428} = "Dalian\,\ Liaoning";
$areanames{en}->{861312429} = "Yingkou\,\ Liaoning";
$areanames{en}->{861312430} = "Jilin\,\ Jilin";
$areanames{en}->{861312431} = "Jilin\,\ Jilin";
$areanames{en}->{861312432} = "Jilin\,\ Jilin";
$areanames{en}->{861312433} = "Yanbian\,\ Jilin";
$areanames{en}->{861312434} = "Jilin\,\ Jilin";
$areanames{en}->{861312435} = "Tonghua\,\ Jilin";
$areanames{en}->{861312436} = "Baicheng\,\ Jilin";
$areanames{en}->{861312437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861312438} = "Songyuan\,\ Jilin";
$areanames{en}->{861312439} = "Baishan\,\ Jilin";
$areanames{en}->{861312440} = "Kaifeng\,\ Henan";
$areanames{en}->{861312441} = "Anyang\,\ Henan";
$areanames{en}->{861312442} = "Anyang\,\ Henan";
$areanames{en}->{861312443} = "Anyang\,\ Henan";
$areanames{en}->{861312444} = "Puyang\,\ Henan";
$areanames{en}->{861312445} = "Xiamen\,\ Fujian";
$areanames{en}->{861312446} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312447} = "Quanzhou\,\ Fujian";
$areanames{en}->{861312448} = "Ningde\,\ Fujian";
$areanames{en}->{861312449} = "Ningde\,\ Fujian";
$areanames{en}->{861312450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861312451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861312452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861312453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861312454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861312455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861312456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861312457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861312458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861312459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861312460} = "Guiyang\,\ Guizhou";
$areanames{en}->{861312461} = "Guiyang\,\ Guizhou";
$areanames{en}->{861312462} = "Zunyi\,\ Guizhou";
$areanames{en}->{861312463} = "Anshun\,\ Guizhou";
$areanames{en}->{861312464} = "Zunyi\,\ Guizhou";
$areanames{en}->{861312465} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861312466} = "Qiannan\,\ Guizhou";
$areanames{en}->{861312467} = "Guiyang\,\ Guizhou";
$areanames{en}->{861312468} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861312469} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{86131247} = "Beijing";
$areanames{en}->{86131248} = "Shanghai";
$areanames{en}->{86131249} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86131250} = "Wuhan\,\ Hubei";
$areanames{en}->{86131251} = "Wuhan\,\ Hubei";
$areanames{en}->{861312520} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861312521} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861312522} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861312523} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861312524} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861312525} = "Yichun\,\ Jiangxi";
$areanames{en}->{861312526} = "JiAn\,\ Jiangxi";
$areanames{en}->{861312527} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861312528} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861312529} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861312530} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861312531} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861312532} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861312533} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861312534} = "JiAn\,\ Jiangxi";
$areanames{en}->{861312535} = "JiAn\,\ Jiangxi";
$areanames{en}->{861312536} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861312537} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861312538} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861312539} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861312540} = "Shenyang\,\ Liaoning";
$areanames{en}->{861312541} = "Shenyang\,\ Liaoning";
$areanames{en}->{861312542} = "Shenyang\,\ Liaoning";
$areanames{en}->{861312543} = "Shenyang\,\ Liaoning";
$areanames{en}->{861312544} = "Shenyang\,\ Liaoning";
$areanames{en}->{861312545} = "Dalian\,\ Liaoning";
$areanames{en}->{861312546} = "Dalian\,\ Liaoning";
$areanames{en}->{861312547} = "Dalian\,\ Liaoning";
$areanames{en}->{861312548} = "Dalian\,\ Liaoning";
$areanames{en}->{861312549} = "Dalian\,\ Liaoning";
$areanames{en}->{861312550} = "Anshan\,\ Liaoning";
$areanames{en}->{861312551} = "Fushun\,\ Liaoning";
$areanames{en}->{861312552} = "Fushun\,\ Liaoning";
$areanames{en}->{861312553} = "Benxi\,\ Liaoning";
$areanames{en}->{861312554} = "Benxi\,\ Liaoning";
$areanames{en}->{861312555} = "Benxi\,\ Liaoning";
$areanames{en}->{861312556} = "Dandong\,\ Liaoning";
$areanames{en}->{861312557} = "Dandong\,\ Liaoning";
$areanames{en}->{861312558} = "Dandong\,\ Liaoning";
$areanames{en}->{861312559} = "Dandong\,\ Liaoning";
$areanames{en}->{861312560} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861312561} = "Yingkou\,\ Liaoning";
$areanames{en}->{861312562} = "Yingkou\,\ Liaoning";
$areanames{en}->{861312563} = "Yingkou\,\ Liaoning";
$areanames{en}->{861312564} = "Yingkou\,\ Liaoning";
$areanames{en}->{861312565} = "Fuxin\,\ Liaoning";
$areanames{en}->{861312566} = "Fuxin\,\ Liaoning";
$areanames{en}->{861312567} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861312568} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861312569} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861312570} = "Changchun\,\ Jilin";
$areanames{en}->{861312571} = "Jilin\,\ Jilin";
$areanames{en}->{861312572} = "Jilin\,\ Jilin";
$areanames{en}->{861312573} = "Yanbian\,\ Jilin";
$areanames{en}->{861312574} = "Changchun\,\ Jilin";
$areanames{en}->{861312575} = "Tonghua\,\ Jilin";
$areanames{en}->{861312576} = "Baicheng\,\ Jilin";
$areanames{en}->{861312577} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861312578} = "Songyuan\,\ Jilin";
$areanames{en}->{861312579} = "Baishan\,\ Jilin";
$areanames{en}->{861312580} = "Changchun\,\ Jilin";
$areanames{en}->{861312581} = "Changchun\,\ Jilin";
$areanames{en}->{861312582} = "Changchun\,\ Jilin";
$areanames{en}->{861312583} = "Siping\,\ Jilin";
$areanames{en}->{861312584} = "Jilin\,\ Jilin";
$areanames{en}->{861312585} = "Tonghua\,\ Jilin";
$areanames{en}->{861312586} = "Baicheng\,\ Jilin";
$areanames{en}->{861312587} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861312588} = "Jilin\,\ Jilin";
$areanames{en}->{861312589} = "Tonghua\,\ Jilin";
$areanames{en}->{861312590} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861312591} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861312592} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861312593} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861312594} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861312595} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861312596} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861312597} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861312598} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861312599} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86131260} = "Maoming\,\ Guangdong";
$areanames{en}->{86131261} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861312617} = "Meizhou\,\ Guangdong";
$areanames{en}->{86131262} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86131263} = "Huizhou\,\ Guangdong";
$areanames{en}->{86131264} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131265} = "Beijing";
$areanames{en}->{861312654} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{86131266} = "Beijing";
$areanames{en}->{86131267} = "Beijing";
$areanames{en}->{861312674} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{86131268} = "Beijing";
$areanames{en}->{861312684} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{86131269} = "Beijing";
$areanames{en}->{861312694} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{86131270} = "Qingdao\,\ Shandong";
$areanames{en}->{861312707} = "Yantai\,\ Shandong";
$areanames{en}->{861312708} = "Yantai\,\ Shandong";
$areanames{en}->{861312709} = "Rizhao\,\ Shandong";
$areanames{en}->{86131271} = "Jinan\,\ Shandong";
$areanames{en}->{861312716} = "Weifang\,\ Shandong";
$areanames{en}->{861312717} = "Weifang\,\ Shandong";
$areanames{en}->{861312718} = "Weifang\,\ Shandong";
$areanames{en}->{861312719} = "Dongying\,\ Shandong";
$areanames{en}->{861312720} = "Zibo\,\ Shandong";
$areanames{en}->{861312721} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861312722} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861312723} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861312724} = "Dongying\,\ Shandong";
$areanames{en}->{861312725} = "Dongying\,\ Shandong";
$areanames{en}->{861312726} = "Laiwu\,\ Shandong";
$areanames{en}->{861312727} = "TaiAn\,\ Shandong";
$areanames{en}->{861312728} = "TaiAn\,\ Shandong";
$areanames{en}->{861312729} = "Linyi\,\ Shandong";
$areanames{en}->{86131273} = "Cangzhou\,\ Hebei";
$areanames{en}->{86131274} = "Baoding\,\ Hebei";
$areanames{en}->{86131275} = "Shanghai";
$areanames{en}->{86131276} = "Shanghai";
$areanames{en}->{86131277} = "Shanghai";
$areanames{en}->{86131278} = "Shanghai";
$areanames{en}->{86131279} = "Shanghai";
$areanames{en}->{86131280} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131281} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131282} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131283} = "Jieyang\,\ Guangdong";
$areanames{en}->{86131284} = "Shantou\,\ Guangdong";
$areanames{en}->{861312840} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861312841} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861312842} = "Chaozhou\,\ Guangdong";
$areanames{en}->{86131285} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86131286} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131287} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131288} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131289} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131290} = "Foshan\,\ Guangdong";
$areanames{en}->{86131291} = "Foshan\,\ Guangdong";
$areanames{en}->{86131292} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86131293} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131294} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131295} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131296} = "Shantou\,\ Guangdong";
$areanames{en}->{86131297} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{86131298} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131299} = "Wuhan\,\ Hubei";
$areanames{en}->{861313000} = "Dalian\,\ Liaoning";
$areanames{en}->{861313001} = "Dalian\,\ Liaoning";
$areanames{en}->{861313002} = "Dalian\,\ Liaoning";
$areanames{en}->{861313003} = "Dalian\,\ Liaoning";
$areanames{en}->{861313004} = "Dalian\,\ Liaoning";
$areanames{en}->{861313005} = "Anshan\,\ Liaoning";
$areanames{en}->{861313006} = "Anshan\,\ Liaoning";
$areanames{en}->{861313007} = "Anshan\,\ Liaoning";
$areanames{en}->{861313008} = "Anshan\,\ Liaoning";
$areanames{en}->{861313009} = "Anshan\,\ Liaoning";
$areanames{en}->{861313010} = "Benxi\,\ Liaoning";
$areanames{en}->{861313011} = "Benxi\,\ Liaoning";
$areanames{en}->{861313012} = "Benxi\,\ Liaoning";
$areanames{en}->{861313013} = "Benxi\,\ Liaoning";
$areanames{en}->{861313014} = "Benxi\,\ Liaoning";
$areanames{en}->{861313015} = "Anshan\,\ Liaoning";
$areanames{en}->{861313016} = "Anshan\,\ Liaoning";
$areanames{en}->{861313017} = "Anshan\,\ Liaoning";
$areanames{en}->{861313018} = "Anshan\,\ Liaoning";
$areanames{en}->{861313019} = "Anshan\,\ Liaoning";
$areanames{en}->{86131302} = "Shenyang\,\ Liaoning";
$areanames{en}->{86131303} = "Fushun\,\ Liaoning";
$areanames{en}->{861313038} = "Benxi\,\ Liaoning";
$areanames{en}->{861313039} = "Benxi\,\ Liaoning";
$areanames{en}->{86131304} = "Dalian\,\ Liaoning";
$areanames{en}->{861313050} = "Dandong\,\ Liaoning";
$areanames{en}->{861313051} = "Dandong\,\ Liaoning";
$areanames{en}->{861313052} = "Dandong\,\ Liaoning";
$areanames{en}->{861313053} = "Dandong\,\ Liaoning";
$areanames{en}->{861313054} = "Dandong\,\ Liaoning";
$areanames{en}->{861313055} = "Yingkou\,\ Liaoning";
$areanames{en}->{861313056} = "Yingkou\,\ Liaoning";
$areanames{en}->{861313057} = "Yingkou\,\ Liaoning";
$areanames{en}->{861313058} = "Yingkou\,\ Liaoning";
$areanames{en}->{861313059} = "Yingkou\,\ Liaoning";
$areanames{en}->{86131306} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861313067} = "Fuxin\,\ Liaoning";
$areanames{en}->{861313068} = "Fuxin\,\ Liaoning";
$areanames{en}->{861313069} = "Fuxin\,\ Liaoning";
$areanames{en}->{86131307} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861313077} = "Tieling\,\ Liaoning";
$areanames{en}->{861313078} = "Tieling\,\ Liaoning";
$areanames{en}->{861313079} = "Tieling\,\ Liaoning";
$areanames{en}->{86131308} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861313087} = "Fuxin\,\ Liaoning";
$areanames{en}->{861313088} = "Panjin\,\ Liaoning";
$areanames{en}->{861313089} = "Tieling\,\ Liaoning";
$areanames{en}->{861313090} = "Panjin\,\ Liaoning";
$areanames{en}->{861313091} = "Panjin\,\ Liaoning";
$areanames{en}->{861313092} = "Panjin\,\ Liaoning";
$areanames{en}->{861313093} = "Panjin\,\ Liaoning";
$areanames{en}->{861313094} = "Panjin\,\ Liaoning";
$areanames{en}->{861313095} = "Huludao\,\ Liaoning";
$areanames{en}->{861313096} = "Huludao\,\ Liaoning";
$areanames{en}->{861313097} = "Huludao\,\ Liaoning";
$areanames{en}->{861313098} = "Huludao\,\ Liaoning";
$areanames{en}->{861313099} = "Huludao\,\ Liaoning";
$areanames{en}->{86131310} = "Handan\,\ Hebei";
$areanames{en}->{86131311} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86131312} = "Baoding\,\ Hebei";
$areanames{en}->{86131313} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{86131314} = "Chengde\,\ Hebei";
$areanames{en}->{86131315} = "Tangshan\,\ Hebei";
$areanames{en}->{86131316} = "Langfang\,\ Hebei";
$areanames{en}->{86131317} = "Cangzhou\,\ Hebei";
$areanames{en}->{86131318} = "Hengshui\,\ Hebei";
$areanames{en}->{86131319} = "Xingtai\,\ Hebei";
$areanames{en}->{86131320} = "Tianjin";
$areanames{en}->{86131321} = "Tianjin";
$areanames{en}->{86131322} = "Tianjin";
$areanames{en}->{86131323} = "Chongqing";
$areanames{en}->{861313240} = "Hengshui\,\ Hebei";
$areanames{en}->{861313241} = "Hengshui\,\ Hebei";
$areanames{en}->{861313242} = "Hengshui\,\ Hebei";
$areanames{en}->{861313243} = "Hengshui\,\ Hebei";
$areanames{en}->{861313244} = "Hengshui\,\ Hebei";
$areanames{en}->{861313245} = "Xingtai\,\ Hebei";
$areanames{en}->{861313246} = "Xingtai\,\ Hebei";
$areanames{en}->{861313247} = "Xingtai\,\ Hebei";
$areanames{en}->{861313248} = "Xingtai\,\ Hebei";
$areanames{en}->{861313249} = "Xingtai\,\ Hebei";
$areanames{en}->{86131325} = "Tianjin";
$areanames{en}->{861313260} = "Nanning\,\ Guangxi";
$areanames{en}->{861313261} = "Nanning\,\ Guangxi";
$areanames{en}->{861313262} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861313263} = "Guilin\,\ Guangxi";
$areanames{en}->{861313264} = "Guilin\,\ Guangxi";
$areanames{en}->{861313265} = "Yulin\,\ Guangxi";
$areanames{en}->{861313266} = "Guigang\,\ Guangxi";
$areanames{en}->{861313267} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861313268} = "Hechi\,\ Guangxi";
$areanames{en}->{861313269} = "Beihai\,\ Guangxi";
$areanames{en}->{861313270} = "Hechi\,\ Guangxi";
$areanames{en}->{861313271} = "Nanning\,\ Guangxi";
$areanames{en}->{861313272} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861313273} = "Guilin\,\ Guangxi";
$areanames{en}->{861313274} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861313275} = "Yulin\,\ Guangxi";
$areanames{en}->{861313276} = "Baise\,\ Guangxi";
$areanames{en}->{861313277} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861313278} = "Hechi\,\ Guangxi";
$areanames{en}->{861313279} = "Beihai\,\ Guangxi";
$areanames{en}->{861313280} = "Hechi\,\ Guangxi";
$areanames{en}->{861313281} = "Nanning\,\ Guangxi";
$areanames{en}->{861313282} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861313283} = "Guilin\,\ Guangxi";
$areanames{en}->{861313284} = "Guigang\,\ Guangxi";
$areanames{en}->{861313285} = "Yulin\,\ Guangxi";
$areanames{en}->{861313286} = "Baise\,\ Guangxi";
$areanames{en}->{861313287} = "Hezhou\,\ Guangxi";
$areanames{en}->{861313288} = "Guigang\,\ Guangxi";
$areanames{en}->{861313289} = "Guigang\,\ Guangxi";
$areanames{en}->{861313290} = "Nanning\,\ Guangxi";
$areanames{en}->{861313291} = "Nanning\,\ Guangxi";
$areanames{en}->{861313292} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861313293} = "Guilin\,\ Guangxi";
$areanames{en}->{861313294} = "Hezhou\,\ Guangxi";
$areanames{en}->{861313295} = "Yulin\,\ Guangxi";
$areanames{en}->{861313296} = "Baise\,\ Guangxi";
$areanames{en}->{861313297} = "Guilin\,\ Guangxi";
$areanames{en}->{861313298} = "Hechi\,\ Guangxi";
$areanames{en}->{861313299} = "Guigang\,\ Guangxi";
$areanames{en}->{861313300} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861313301} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861313302} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861313303} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861313304} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861313305} = "Changzhi\,\ Shanxi";
$areanames{en}->{861313306} = "Jincheng\,\ Shanxi";
$areanames{en}->{861313307} = "Linfen\,\ Shanxi";
$areanames{en}->{861313308} = "Lüliang\,\ Shanxi";
$areanames{en}->{861313309} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861313310} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861313311} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861313312} = "Datong\,\ Shanxi";
$areanames{en}->{861313313} = "Yangquan\,\ Shanxi";
$areanames{en}->{861313314} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861313315} = "Changzhi\,\ Shanxi";
$areanames{en}->{861313316} = "Jincheng\,\ Shanxi";
$areanames{en}->{861313317} = "Linfen\,\ Shanxi";
$areanames{en}->{861313318} = "Linfen\,\ Shanxi";
$areanames{en}->{861313319} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861313320} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861313321} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861313322} = "Datong\,\ Shanxi";
$areanames{en}->{861313323} = "Yangquan\,\ Shanxi";
$areanames{en}->{861313324} = "Lüliang\,\ Shanxi";
$areanames{en}->{861313325} = "Changzhi\,\ Shanxi";
$areanames{en}->{861313326} = "Linfen\,\ Shanxi";
$areanames{en}->{861313327} = "Linfen\,\ Shanxi";
$areanames{en}->{861313328} = "Datong\,\ Shanxi";
$areanames{en}->{861313329} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861313330} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861313331} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861313332} = "Datong\,\ Shanxi";
$areanames{en}->{861313333} = "Datong\,\ Shanxi";
$areanames{en}->{861313334} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861313335} = "Changzhi\,\ Shanxi";
$areanames{en}->{861313336} = "Jincheng\,\ Shanxi";
$areanames{en}->{861313337} = "Jincheng\,\ Shanxi";
$areanames{en}->{861313338} = "Lüliang\,\ Shanxi";
$areanames{en}->{861313339} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861313340} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861313341} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861313342} = "Datong\,\ Shanxi";
$areanames{en}->{861313343} = "Yangquan\,\ Shanxi";
$areanames{en}->{861313344} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861313345} = "Changzhi\,\ Shanxi";
$areanames{en}->{861313346} = "Jincheng\,\ Shanxi";
$areanames{en}->{861313347} = "Linfen\,\ Shanxi";
$areanames{en}->{861313348} = "Lüliang\,\ Shanxi";
$areanames{en}->{861313349} = "Shuozhou\,\ Shanxi";
$areanames{en}->{86131335} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861313360} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861313361} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861313362} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861313363} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861313364} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861313365} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861313366} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861313367} = "JiAn\,\ Jiangxi";
$areanames{en}->{861313368} = "JiAn\,\ Jiangxi";
$areanames{en}->{861313369} = "JiAn\,\ Jiangxi";
$areanames{en}->{861313370} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861313371} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861313372} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861313373} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861313374} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861313375} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861313376} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861313377} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861313378} = "Yichun\,\ Jiangxi";
$areanames{en}->{861313379} = "Yichun\,\ Jiangxi";
$areanames{en}->{861313380} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861313381} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861313382} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861313383} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861313384} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861313385} = "Yichun\,\ Jiangxi";
$areanames{en}->{861313386} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861313387} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861313388} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861313389} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861313390} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861313391} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861313392} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861313393} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861313394} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861313395} = "Yichun\,\ Jiangxi";
$areanames{en}->{861313396} = "JiAn\,\ Jiangxi";
$areanames{en}->{861313397} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861313398} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861313399} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861313400} = "Yichun\,\ Jiangxi";
$areanames{en}->{861313401} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861313402} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861313403} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861313404} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861313405} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861313406} = "JiAn\,\ Jiangxi";
$areanames{en}->{861313407} = "JiAn\,\ Jiangxi";
$areanames{en}->{861313408} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861313409} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861313410} = "Tieling\,\ Liaoning";
$areanames{en}->{861313411} = "Dalian\,\ Liaoning";
$areanames{en}->{861313412} = "Anshan\,\ Liaoning";
$areanames{en}->{861313413} = "Fushun\,\ Liaoning";
$areanames{en}->{861313414} = "Benxi\,\ Liaoning";
$areanames{en}->{861313415} = "Dandong\,\ Liaoning";
$areanames{en}->{861313416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861313417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861313418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861313419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861313420} = "Shenyang\,\ Liaoning";
$areanames{en}->{861313421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861313422} = "Shenyang\,\ Liaoning";
$areanames{en}->{861313423} = "Shenyang\,\ Liaoning";
$areanames{en}->{861313424} = "Shenyang\,\ Liaoning";
$areanames{en}->{861313425} = "Anshan\,\ Liaoning";
$areanames{en}->{861313426} = "Dalian\,\ Liaoning";
$areanames{en}->{861313427} = "Panjin\,\ Liaoning";
$areanames{en}->{861313428} = "Dalian\,\ Liaoning";
$areanames{en}->{861313429} = "Huludao\,\ Liaoning";
$areanames{en}->{861313430} = "Changchun\,\ Jilin";
$areanames{en}->{861313431} = "Changchun\,\ Jilin";
$areanames{en}->{861313432} = "Jilin\,\ Jilin";
$areanames{en}->{861313433} = "Yanbian\,\ Jilin";
$areanames{en}->{861313434} = "Siping\,\ Jilin";
$areanames{en}->{861313435} = "Tonghua\,\ Jilin";
$areanames{en}->{861313436} = "Baicheng\,\ Jilin";
$areanames{en}->{861313437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861313438} = "Songyuan\,\ Jilin";
$areanames{en}->{861313439} = "Baishan\,\ Jilin";
$areanames{en}->{86131344} = "Changchun\,\ Jilin";
$areanames{en}->{861313440} = "Jilin\,\ Jilin";
$areanames{en}->{861313441} = "Jilin\,\ Jilin";
$areanames{en}->{861313442} = "Jilin\,\ Jilin";
$areanames{en}->{861313444} = "Jilin\,\ Jilin";
$areanames{en}->{861313450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861313451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861313452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861313453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861313454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861313455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861313456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861313457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861313458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861313459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861313460} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861313461} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861313462} = "Datong\,\ Shanxi";
$areanames{en}->{861313463} = "Yangquan\,\ Shanxi";
$areanames{en}->{861313464} = "Lüliang\,\ Shanxi";
$areanames{en}->{861313465} = "Changzhi\,\ Shanxi";
$areanames{en}->{861313466} = "Jincheng\,\ Shanxi";
$areanames{en}->{861313467} = "Linfen\,\ Shanxi";
$areanames{en}->{861313468} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861313469} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861313470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861313471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861313472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861313473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861313474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861313475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861313476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861313477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861313478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861313479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861313480} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861313481} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861313482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861313483} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861313484} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861313485} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861313486} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861313487} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861313488} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861313489} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{86131349} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861313498} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861313499} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861313500} = "Yueyang\,\ Hunan";
$areanames{en}->{861313501} = "Changsha\,\ Hunan";
$areanames{en}->{861313502} = "Xiangtan\,\ Hunan";
$areanames{en}->{861313503} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861313504} = "Hengyang\,\ Hunan";
$areanames{en}->{861313505} = "Chenzhou\,\ Hunan";
$areanames{en}->{861313506} = "Changde\,\ Hunan";
$areanames{en}->{861313507} = "Yiyang\,\ Hunan";
$areanames{en}->{861313508} = "Shaoyang\,\ Hunan";
$areanames{en}->{861313509} = "Xiangxi\,\ Hunan";
$areanames{en}->{861313510} = "Yueyang\,\ Hunan";
$areanames{en}->{861313511} = "Changsha\,\ Hunan";
$areanames{en}->{861313512} = "Xiangtan\,\ Hunan";
$areanames{en}->{861313513} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861313514} = "Xiangxi\,\ Hunan";
$areanames{en}->{861313515} = "Chenzhou\,\ Hunan";
$areanames{en}->{861313516} = "Yiyang\,\ Hunan";
$areanames{en}->{861313517} = "Yiyang\,\ Hunan";
$areanames{en}->{861313518} = "Hengyang\,\ Hunan";
$areanames{en}->{861313519} = "Shaoyang\,\ Hunan";
$areanames{en}->{861313520} = "Xiangxi\,\ Hunan";
$areanames{en}->{861313521} = "Changsha\,\ Hunan";
$areanames{en}->{861313522} = "Yongzhou\,\ Hunan";
$areanames{en}->{861313523} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861313524} = "Loudi\,\ Hunan";
$areanames{en}->{861313525} = "Huaihua\,\ Hunan";
$areanames{en}->{861313526} = "Huaihua\,\ Hunan";
$areanames{en}->{861313527} = "Yongzhou\,\ Hunan";
$areanames{en}->{861313528} = "Changsha\,\ Hunan";
$areanames{en}->{861313529} = "Shaoyang\,\ Hunan";
$areanames{en}->{861313530} = "Yueyang\,\ Hunan";
$areanames{en}->{861313531} = "Changsha\,\ Hunan";
$areanames{en}->{861313532} = "Xiangtan\,\ Hunan";
$areanames{en}->{861313533} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861313534} = "Hengyang\,\ Hunan";
$areanames{en}->{861313535} = "Chenzhou\,\ Hunan";
$areanames{en}->{861313536} = "Changde\,\ Hunan";
$areanames{en}->{861313537} = "Yiyang\,\ Hunan";
$areanames{en}->{861313538} = "Loudi\,\ Hunan";
$areanames{en}->{861313539} = "Shaoyang\,\ Hunan";
$areanames{en}->{861313540} = "Hefei\,\ Anhui";
$areanames{en}->{861313541} = "Fuyang\,\ Anhui";
$areanames{en}->{861313542} = "LuAn\,\ Anhui";
$areanames{en}->{861313543} = "Xuancheng\,\ Anhui";
$areanames{en}->{861313544} = "MaAnshan\,\ Anhui";
$areanames{en}->{861313545} = "Chuzhou\,\ Anhui";
$areanames{en}->{861313546} = "Huaibei\,\ Anhui";
$areanames{en}->{861313547} = "Bozhou\,\ Anhui";
$areanames{en}->{861313548} = "Tongling\,\ Anhui";
$areanames{en}->{861313549} = "Chizhou\,\ Anhui";
$areanames{en}->{861313550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861313551} = "Hefei\,\ Anhui";
$areanames{en}->{861313552} = "Bengbu\,\ Anhui";
$areanames{en}->{861313553} = "Wuhu\,\ Anhui";
$areanames{en}->{861313554} = "Huainan\,\ Anhui";
$areanames{en}->{861313555} = "Hefei\,\ Anhui";
$areanames{en}->{861313556} = "Anqing\,\ Anhui";
$areanames{en}->{861313557} = "Suzhou\,\ Anhui";
$areanames{en}->{861313558} = "Fuyang\,\ Anhui";
$areanames{en}->{861313559} = "Huangshan\,\ Anhui";
$areanames{en}->{861313560} = "Xiaogan\,\ Hubei";
$areanames{en}->{861313561} = "Xiaogan\,\ Hubei";
$areanames{en}->{861313562} = "Xiaogan\,\ Hubei";
$areanames{en}->{861313563} = "Xiaogan\,\ Hubei";
$areanames{en}->{861313564} = "Xiaogan\,\ Hubei";
$areanames{en}->{861313565} = "Wuhan\,\ Hubei";
$areanames{en}->{861313566} = "Wuhan\,\ Hubei";
$areanames{en}->{861313567} = "Wuhan\,\ Hubei";
$areanames{en}->{861313568} = "Wuhan\,\ Hubei";
$areanames{en}->{861313569} = "Wuhan\,\ Hubei";
$areanames{en}->{861313570} = "Shiyan\,\ Hubei";
$areanames{en}->{861313571} = "Shiyan\,\ Hubei";
$areanames{en}->{861313572} = "Shiyan\,\ Hubei";
$areanames{en}->{861313573} = "Suizhou\,\ Hubei";
$areanames{en}->{861313574} = "Suizhou\,\ Hubei";
$areanames{en}->{861313575} = "Jingzhou\,\ Hubei";
$areanames{en}->{861313576} = "Jingzhou\,\ Hubei";
$areanames{en}->{861313577} = "Jingzhou\,\ Hubei";
$areanames{en}->{861313578} = "Jingzhou\,\ Hubei";
$areanames{en}->{861313579} = "Jingzhou\,\ Hubei";
$areanames{en}->{861313580} = "Yichang\,\ Hubei";
$areanames{en}->{861313581} = "Yichang\,\ Hubei";
$areanames{en}->{861313582} = "Yichang\,\ Hubei";
$areanames{en}->{861313583} = "Enshi\,\ Hubei";
$areanames{en}->{861313584} = "Enshi\,\ Hubei";
$areanames{en}->{861313585} = "Enshi\,\ Hubei";
$areanames{en}->{861313586} = "Xiangfan\,\ Hubei";
$areanames{en}->{861313587} = "Xiangfan\,\ Hubei";
$areanames{en}->{861313588} = "Xiangfan\,\ Hubei";
$areanames{en}->{861313589} = "Ezhou\,\ Hubei";
$areanames{en}->{861313590} = "Huanggang\,\ Hubei";
$areanames{en}->{861313591} = "Huanggang\,\ Hubei";
$areanames{en}->{861313592} = "Huangshi\,\ Hubei";
$areanames{en}->{861313593} = "Huangshi\,\ Hubei";
$areanames{en}->{861313594} = "Xianning\,\ Hubei";
$areanames{en}->{861313595} = "Xianning\,\ Hubei";
$areanames{en}->{861313596} = "Xianning\,\ Hubei";
$areanames{en}->{861313597} = "Jingmen\,\ Hubei";
$areanames{en}->{861313598} = "Jingmen\,\ Hubei";
$areanames{en}->{861313599} = "Wuhan\,\ Hubei";
$areanames{en}->{86131360} = "Haikou\,\ Hainan";
$areanames{en}->{86131361} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861313620} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861313621} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861313622} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861313623} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861313624} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861313625} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313626} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313627} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313628} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313629} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{86131363} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861313640} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313641} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313642} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313643} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313644} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861313645} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313646} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313647} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313648} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313649} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313650} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861313651} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861313652} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861313653} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861313654} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861313655} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313656} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313657} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313658} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861313659} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86131366} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861313660} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861313661} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861313662} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861313663} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861313670} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861313671} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861313672} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861313673} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861313674} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861313675} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861313676} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861313677} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861313678} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861313679} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{86131368} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861313686} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861313687} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861313688} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861313689} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861313690} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861313691} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861313692} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861313693} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861313694} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861313695} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861313696} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861313697} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861313698} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861313699} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861313700} = "Shangqiu\,\ Henan";
$areanames{en}->{861313701} = "Shangqiu\,\ Henan";
$areanames{en}->{861313702} = "Shangqiu\,\ Henan";
$areanames{en}->{861313703} = "Shangqiu\,\ Henan";
$areanames{en}->{861313704} = "Luoyang\,\ Henan";
$areanames{en}->{861313705} = "Luoyang\,\ Henan";
$areanames{en}->{861313706} = "Luoyang\,\ Henan";
$areanames{en}->{861313707} = "Nanyang\,\ Henan";
$areanames{en}->{861313708} = "Nanyang\,\ Henan";
$areanames{en}->{861313709} = "Nanyang\,\ Henan";
$areanames{en}->{86131371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861313716} = "Jiaozuo\,\ Henan";
$areanames{en}->{861313717} = "Jiaozuo\,\ Henan";
$areanames{en}->{861313718} = "Jiaozuo\,\ Henan";
$areanames{en}->{861313719} = "Anyang\,\ Henan";
$areanames{en}->{86131372} = "Zhumadian\,\ Henan";
$areanames{en}->{861313720} = "Anyang\,\ Henan";
$areanames{en}->{861313721} = "Anyang\,\ Henan";
$areanames{en}->{861313722} = "Hebi\,\ Henan";
$areanames{en}->{861313723} = "Hebi\,\ Henan";
$areanames{en}->{861313730} = "Xinxiang\,\ Henan";
$areanames{en}->{861313731} = "Xinxiang\,\ Henan";
$areanames{en}->{861313732} = "Xinxiang\,\ Henan";
$areanames{en}->{861313733} = "Puyang\,\ Henan";
$areanames{en}->{861313734} = "Puyang\,\ Henan";
$areanames{en}->{861313735} = "Puyang\,\ Henan";
$areanames{en}->{861313736} = "Xinyang\,\ Henan";
$areanames{en}->{861313737} = "Xinyang\,\ Henan";
$areanames{en}->{861313738} = "Xinyang\,\ Henan";
$areanames{en}->{861313739} = "Xinyang\,\ Henan";
$areanames{en}->{861313740} = "Xuchang\,\ Henan";
$areanames{en}->{861313741} = "Xuchang\,\ Henan";
$areanames{en}->{861313742} = "Xuchang\,\ Henan";
$areanames{en}->{861313743} = "Xuchang\,\ Henan";
$areanames{en}->{861313744} = "Zhoukou\,\ Henan";
$areanames{en}->{861313745} = "Zhoukou\,\ Henan";
$areanames{en}->{861313746} = "Zhoukou\,\ Henan";
$areanames{en}->{861313747} = "Zhoukou\,\ Henan";
$areanames{en}->{861313748} = "Sanmenxia\,\ Henan";
$areanames{en}->{861313749} = "Sanmenxia\,\ Henan";
$areanames{en}->{861313750} = "Pingdingshan\,\ Henan";
$areanames{en}->{861313751} = "Pingdingshan\,\ Henan";
$areanames{en}->{861313752} = "Pingdingshan\,\ Henan";
$areanames{en}->{861313753} = "Pingdingshan\,\ Henan";
$areanames{en}->{861313754} = "Luohe\,\ Henan";
$areanames{en}->{861313755} = "Luohe\,\ Henan";
$areanames{en}->{861313756} = "Kaifeng\,\ Henan";
$areanames{en}->{861313757} = "Kaifeng\,\ Henan";
$areanames{en}->{861313758} = "Kaifeng\,\ Henan";
$areanames{en}->{861313759} = "Kaifeng\,\ Henan";
$areanames{en}->{861313760} = "Xinyang\,\ Henan";
$areanames{en}->{861313761} = "Xinyang\,\ Henan";
$areanames{en}->{861313762} = "Xinyang\,\ Henan";
$areanames{en}->{861313763} = "Xinyang\,\ Henan";
$areanames{en}->{861313764} = "Xinyang\,\ Henan";
$areanames{en}->{861313765} = "Zhoukou\,\ Henan";
$areanames{en}->{861313766} = "Zhoukou\,\ Henan";
$areanames{en}->{861313767} = "Zhoukou\,\ Henan";
$areanames{en}->{861313768} = "Zhoukou\,\ Henan";
$areanames{en}->{861313769} = "Zhoukou\,\ Henan";
$areanames{en}->{861313770} = "Zhengzhou\,\ Henan";
$areanames{en}->{861313771} = "Zhengzhou\,\ Henan";
$areanames{en}->{861313772} = "Zhengzhou\,\ Henan";
$areanames{en}->{861313773} = "Zhengzhou\,\ Henan";
$areanames{en}->{861313774} = "Pingdingshan\,\ Henan";
$areanames{en}->{861313775} = "Pingdingshan\,\ Henan";
$areanames{en}->{861313776} = "Pingdingshan\,\ Henan";
$areanames{en}->{861313777} = "Nanyang\,\ Henan";
$areanames{en}->{861313778} = "Nanyang\,\ Henan";
$areanames{en}->{861313779} = "Nanyang\,\ Henan";
$areanames{en}->{861313780} = "Kaifeng\,\ Henan";
$areanames{en}->{861313781} = "Kaifeng\,\ Henan";
$areanames{en}->{861313782} = "Kaifeng\,\ Henan";
$areanames{en}->{861313783} = "Kaifeng\,\ Henan";
$areanames{en}->{861313784} = "Kaifeng\,\ Henan";
$areanames{en}->{861313785} = "Zhumadian\,\ Henan";
$areanames{en}->{861313786} = "Zhumadian\,\ Henan";
$areanames{en}->{861313787} = "Zhumadian\,\ Henan";
$areanames{en}->{861313788} = "Xuchang\,\ Henan";
$areanames{en}->{861313789} = "Xuchang\,\ Henan";
$areanames{en}->{861313790} = "Luoyang\,\ Henan";
$areanames{en}->{861313791} = "Jiaozuo\,\ Henan";
$areanames{en}->{861313792} = "Jiaozuo\,\ Henan";
$areanames{en}->{861313793} = "Jiaozuo\,\ Henan";
$areanames{en}->{861313794} = "Zhengzhou\,\ Henan";
$areanames{en}->{861313795} = "Luohe\,\ Henan";
$areanames{en}->{861313796} = "Luohe\,\ Henan";
$areanames{en}->{861313797} = "Sanmenxia\,\ Henan";
$areanames{en}->{861313798} = "Sanmenxia\,\ Henan";
$areanames{en}->{861313799} = "Luoyang\,\ Henan";
$areanames{en}->{86131380} = "Meizhou\,\ Guangdong";
$areanames{en}->{861313808} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861313810} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861313811} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861313812} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861313813} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861313814} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861313815} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313816} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313817} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313818} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313819} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86131382} = "Foshan\,\ Guangdong";
$areanames{en}->{86131383} = "Huizhou\,\ Guangdong";
$areanames{en}->{861313840} = "Shantou\,\ Guangdong";
$areanames{en}->{861313841} = "Shantou\,\ Guangdong";
$areanames{en}->{861313842} = "Shantou\,\ Guangdong";
$areanames{en}->{861313843} = "Shantou\,\ Guangdong";
$areanames{en}->{861313844} = "Shantou\,\ Guangdong";
$areanames{en}->{861313845} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861313846} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861313847} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861313848} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861313849} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861313850} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861313851} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861313852} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861313853} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861313854} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861313855} = "Shantou\,\ Guangdong";
$areanames{en}->{861313856} = "Shantou\,\ Guangdong";
$areanames{en}->{861313857} = "Shantou\,\ Guangdong";
$areanames{en}->{861313858} = "Shantou\,\ Guangdong";
$areanames{en}->{861313859} = "Shantou\,\ Guangdong";
$areanames{en}->{86131386} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131387} = "Maoming\,\ Guangdong";
$areanames{en}->{861313880} = "Dongguan\,\ Guangdong";
$areanames{en}->{861313881} = "Dongguan\,\ Guangdong";
$areanames{en}->{861313882} = "Dongguan\,\ Guangdong";
$areanames{en}->{861313883} = "Dongguan\,\ Guangdong";
$areanames{en}->{861313884} = "Dongguan\,\ Guangdong";
$areanames{en}->{861313885} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313886} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313887} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313888} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861313889} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131389} = "Haikou\,\ Hainan";
$areanames{en}->{86131390} = "Xining\,\ Qinghai";
$areanames{en}->{861313900} = "Haixi\,\ Qinghai";
$areanames{en}->{861313901} = "Haixi\,\ Qinghai";
$areanames{en}->{861313902} = "Haixi\,\ Qinghai";
$areanames{en}->{861313903} = "Haixi\,\ Qinghai";
$areanames{en}->{861313910} = "Haibei\,\ Qinghai";
$areanames{en}->{861313911} = "Haidong\,\ Qinghai";
$areanames{en}->{861313912} = "Haidong\,\ Qinghai";
$areanames{en}->{861313913} = "Huangnan\,\ Qinghai";
$areanames{en}->{861313914} = "Hainan\,\ Qinghai";
$areanames{en}->{861313915} = "Golog\,\ Qinghai";
$areanames{en}->{861313916} = "Yushu\,\ Qinghai";
$areanames{en}->{861313917} = "Haixi\,\ Qinghai";
$areanames{en}->{861313918} = "Haixi\,\ Qinghai";
$areanames{en}->{861313919} = "Haidong\,\ Qinghai";
$areanames{en}->{86131392} = "Lanzhou\,\ Gansu";
$areanames{en}->{861313930} = "Linxia\,\ Gansu";
$areanames{en}->{861313931} = "Lanzhou\,\ Gansu";
$areanames{en}->{861313932} = "Dingxi\,\ Gansu";
$areanames{en}->{861313933} = "Pingliang\,\ Gansu";
$areanames{en}->{861313934} = "Qingyang\,\ Gansu";
$areanames{en}->{861313935} = "Wuwei\,\ Gansu";
$areanames{en}->{861313936} = "Zhangye\,\ Gansu";
$areanames{en}->{861313937} = "Jiuquan\,\ Gansu";
$areanames{en}->{861313938} = "Tianshui\,\ Gansu";
$areanames{en}->{861313939} = "Longnan\,\ Gansu";
$areanames{en}->{861313940} = "Lanzhou\,\ Gansu";
$areanames{en}->{861313941} = "Longnan\,\ Gansu";
$areanames{en}->{861313942} = "Dingxi\,\ Gansu";
$areanames{en}->{861313943} = "Baiyin\,\ Gansu";
$areanames{en}->{861313944} = "Tianshui\,\ Gansu";
$areanames{en}->{861313945} = "Wuwei\,\ Gansu";
$areanames{en}->{861313946} = "Qingyang\,\ Gansu";
$areanames{en}->{861313947} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861313948} = "Jiuquan\,\ Gansu";
$areanames{en}->{861313949} = "Jiuquan\,\ Gansu";
$areanames{en}->{861313950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861313951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861313952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861313953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861313954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861313955} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861313956} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861313957} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861313958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861313959} = "Yinchuan\,\ Ningxia";
$areanames{en}->{86131396} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861313970} = "Changji\,\ Xinjiang";
$areanames{en}->{861313971} = "Hami\,\ Xinjiang";
$areanames{en}->{861313972} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861313973} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861313974} = "Aksu\,\ Xinjiang";
$areanames{en}->{861313975} = "Kashi\,\ Xinjiang";
$areanames{en}->{861313976} = "Hotan\,\ Xinjiang";
$areanames{en}->{861313977} = "Bortala\,\ Xinjiang";
$areanames{en}->{861313978} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861313979} = "Altay\,\ Xinjiang";
$areanames{en}->{861313980} = "Ili\,\ Xinjiang";
$areanames{en}->{861313981} = "Bortala\,\ Xinjiang";
$areanames{en}->{861313982} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861313983} = "Altay\,\ Xinjiang";
$areanames{en}->{861313984} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861313985} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861313986} = "Aksu\,\ Xinjiang";
$areanames{en}->{861313987} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861313988} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861313989} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861313990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861313991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861313992} = "Ili\,\ Xinjiang";
$areanames{en}->{861313993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861313994} = "Changji\,\ Xinjiang";
$areanames{en}->{861313995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861313996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861313997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861313998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861313999} = "Ili\,\ Xinjiang";
$areanames{en}->{86131400} = "Zhengzhou\,\ Henan";
$areanames{en}->{86131401} = "Zhengzhou\,\ Henan";
$areanames{en}->{86131402} = "Chongqing";
$areanames{en}->{86131403} = "Chongqing";
$areanames{en}->{861314040} = "Anyang\,\ Henan";
$areanames{en}->{861314041} = "Anyang\,\ Henan";
$areanames{en}->{861314042} = "Hebi\,\ Henan";
$areanames{en}->{861314043} = "Jiaozuo\,\ Henan";
$areanames{en}->{861314044} = "Jiaozuo\,\ Henan";
$areanames{en}->{861314045} = "Kaifeng\,\ Henan";
$areanames{en}->{861314046} = "Kaifeng\,\ Henan";
$areanames{en}->{861314047} = "Luoyang\,\ Henan";
$areanames{en}->{861314048} = "Luoyang\,\ Henan";
$areanames{en}->{861314049} = "Luoyang\,\ Henan";
$areanames{en}->{861314050} = "Luohe\,\ Henan";
$areanames{en}->{861314051} = "Nanyang\,\ Henan";
$areanames{en}->{861314052} = "Nanyang\,\ Henan";
$areanames{en}->{861314053} = "Pingdingshan\,\ Henan";
$areanames{en}->{861314054} = "Shangqiu\,\ Henan";
$areanames{en}->{861314055} = "Puyang\,\ Henan";
$areanames{en}->{861314056} = "Sanmenxia\,\ Henan";
$areanames{en}->{861314057} = "Shangqiu\,\ Henan";
$areanames{en}->{861314058} = "Xinxiang\,\ Henan";
$areanames{en}->{861314059} = "Xinxiang\,\ Henan";
$areanames{en}->{861314060} = "Xinyang\,\ Henan";
$areanames{en}->{861314061} = "Xinyang\,\ Henan";
$areanames{en}->{861314062} = "Xuchang\,\ Henan";
$areanames{en}->{861314063} = "Xuchang\,\ Henan";
$areanames{en}->{861314064} = "Zhoukou\,\ Henan";
$areanames{en}->{861314065} = "Zhoukou\,\ Henan";
$areanames{en}->{861314066} = "Zhoukou\,\ Henan";
$areanames{en}->{861314067} = "Zhumadian\,\ Henan";
$areanames{en}->{861314068} = "Zhumadian\,\ Henan";
$areanames{en}->{861314069} = "Zhumadian\,\ Henan";
$areanames{en}->{86131407} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86131408} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86131409} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86131410} = "Beijing";
$areanames{en}->{86131411} = "Beijing";
$areanames{en}->{86131412} = "Beijing";
$areanames{en}->{86131413} = "Beijing";
$areanames{en}->{86131414} = "Beijing";
$areanames{en}->{861314150} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861314151} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861314152} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861314153} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861314154} = "Yiyang\,\ Hunan";
$areanames{en}->{861314155} = "Yiyang\,\ Hunan";
$areanames{en}->{861314156} = "Suqian\,\ Jiangsu";
$areanames{en}->{861314157} = "Suqian\,\ Jiangsu";
$areanames{en}->{861314158} = "Suqian\,\ Jiangsu";
$areanames{en}->{861314159} = "Chenzhou\,\ Hunan";
$areanames{en}->{861314160} = "Xiangxi\,\ Hunan";
$areanames{en}->{861314161} = "Xiangxi\,\ Hunan";
$areanames{en}->{861314162} = "Xiangxi\,\ Hunan";
$areanames{en}->{861314163} = "Xiangxi\,\ Hunan";
$areanames{en}->{861314164} = "Xiangxi\,\ Hunan";
$areanames{en}->{861314165} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314166} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314167} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314168} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314169} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314170} = "Chenzhou\,\ Hunan";
$areanames{en}->{861314171} = "Chenzhou\,\ Hunan";
$areanames{en}->{861314172} = "Nantong\,\ Jiangsu";
$areanames{en}->{861314173} = "Nantong\,\ Jiangsu";
$areanames{en}->{861314174} = "Nantong\,\ Jiangsu";
$areanames{en}->{861314175} = "Dingxi\,\ Gansu";
$areanames{en}->{861314176} = "Dingxi\,\ Gansu";
$areanames{en}->{861314177} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861314178} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861314179} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{86131418} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861314190} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861314191} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861314192} = "Tianshui\,\ Gansu";
$areanames{en}->{861314193} = "Tianshui\,\ Gansu";
$areanames{en}->{861314194} = "Dingxi\,\ Gansu";
$areanames{en}->{861314195} = "Shaoyang\,\ Hunan";
$areanames{en}->{861314196} = "Shaoyang\,\ Hunan";
$areanames{en}->{861314197} = "Shaoyang\,\ Hunan";
$areanames{en}->{861314198} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861314199} = "Taizhou\,\ Jiangsu";
$areanames{en}->{86131420} = "Changsha\,\ Hunan";
$areanames{en}->{86131421} = "Changsha\,\ Hunan";
$areanames{en}->{86131422} = "Changsha\,\ Hunan";
$areanames{en}->{86131423} = "Hengyang\,\ Hunan";
$areanames{en}->{861314240} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314241} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314242} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314243} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314244} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314245} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861314246} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861314247} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861314248} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861314249} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{86131425} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861314257} = "Shaoyang\,\ Hunan";
$areanames{en}->{861314258} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861314259} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861314260} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861314261} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314262} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861314263} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314264} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314265} = "Nantong\,\ Jiangsu";
$areanames{en}->{861314266} = "Nantong\,\ Jiangsu";
$areanames{en}->{861314267} = "Nantong\,\ Jiangsu";
$areanames{en}->{861314268} = "Nantong\,\ Jiangsu";
$areanames{en}->{861314269} = "Nantong\,\ Jiangsu";
$areanames{en}->{86131427} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861314280} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314281} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314282} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314283} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314284} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314285} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861314286} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861314287} = "Xiangtan\,\ Hunan";
$areanames{en}->{861314288} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861314289} = "Taizhou\,\ Jiangsu";
$areanames{en}->{86131429} = "Nantong\,\ Jiangsu";
$areanames{en}->{86131430} = "Huizhou\,\ Guangdong";
$areanames{en}->{861314301} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314302} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314304} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314310} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861314311} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861314312} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861314313} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861314314} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861314315} = "Langfang\,\ Hebei";
$areanames{en}->{861314316} = "Foshan\,\ Guangdong";
$areanames{en}->{861314317} = "Foshan\,\ Guangdong";
$areanames{en}->{861314318} = "Foshan\,\ Guangdong";
$areanames{en}->{861314319} = "Foshan\,\ Guangdong";
$areanames{en}->{86131432} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131433} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131434} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314347} = "Huizhou\,\ Guangdong";
$areanames{en}->{861314348} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314349} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314350} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314351} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314352} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314353} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314354} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314355} = "Foshan\,\ Guangdong";
$areanames{en}->{861314356} = "Foshan\,\ Guangdong";
$areanames{en}->{861314357} = "Foshan\,\ Guangdong";
$areanames{en}->{861314358} = "Foshan\,\ Guangdong";
$areanames{en}->{861314359} = "Foshan\,\ Guangdong";
$areanames{en}->{861314360} = "Huizhou\,\ Guangdong";
$areanames{en}->{861314361} = "Huizhou\,\ Guangdong";
$areanames{en}->{861314362} = "Huizhou\,\ Guangdong";
$areanames{en}->{861314363} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314364} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314365} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314366} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314367} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314368} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314369} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131437} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131438} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131439} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314400} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314401} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314402} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314403} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314404} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314405} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861314406} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861314407} = "Jieyang\,\ Guangdong";
$areanames{en}->{861314408} = "Jieyang\,\ Guangdong";
$areanames{en}->{861314409} = "Jieyang\,\ Guangdong";
$areanames{en}->{861314410} = "Heyuan\,\ Guangdong";
$areanames{en}->{861314411} = "Foshan\,\ Guangdong";
$areanames{en}->{861314412} = "Foshan\,\ Guangdong";
$areanames{en}->{861314413} = "Foshan\,\ Guangdong";
$areanames{en}->{861314414} = "Foshan\,\ Guangdong";
$areanames{en}->{861314415} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861314416} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861314417} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861314418} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861314419} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861314420} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861314421} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861314422} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861314423} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861314424} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861314425} = "Shantou\,\ Guangdong";
$areanames{en}->{861314426} = "Shantou\,\ Guangdong";
$areanames{en}->{861314427} = "Shantou\,\ Guangdong";
$areanames{en}->{861314428} = "Shantou\,\ Guangdong";
$areanames{en}->{861314429} = "Shantou\,\ Guangdong";
$areanames{en}->{861314430} = "Changchun\,\ Jilin";
$areanames{en}->{861314431} = "Changchun\,\ Jilin";
$areanames{en}->{861314432} = "Jilin\,\ Jilin";
$areanames{en}->{861314433} = "Yanbian\,\ Jilin";
$areanames{en}->{861314434} = "Siping\,\ Jilin";
$areanames{en}->{861314435} = "Tonghua\,\ Jilin";
$areanames{en}->{861314436} = "Baicheng\,\ Jilin";
$areanames{en}->{861314437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861314438} = "Songyuan\,\ Jilin";
$areanames{en}->{861314439} = "Baishan\,\ Jilin";
$areanames{en}->{86131444} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314446} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861314447} = "Shanwei\,\ Guangdong";
$areanames{en}->{861314448} = "Shanwei\,\ Guangdong";
$areanames{en}->{861314449} = "Shanwei\,\ Guangdong";
$areanames{en}->{861314450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861314453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861314454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861314455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861314456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861314457} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861314458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861314459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861314460} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314461} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314462} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314463} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861314464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861314465} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861314466} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861314467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861314468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861314469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{86131447} = "Foshan\,\ Guangdong";
$areanames{en}->{861314480} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314481} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314482} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314483} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314484} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314485} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314486} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314487} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314488} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314489} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131449} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131450} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86131451} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861314510} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861314511} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861314520} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861314521} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861314522} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861314523} = "Xiangtan\,\ Hunan";
$areanames{en}->{861314524} = "Tianshui\,\ Gansu";
$areanames{en}->{861314525} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861314526} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314527} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861314528} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861314529} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861314530} = "Heze\,\ Shandong";
$areanames{en}->{861314531} = "Jinan\,\ Shandong";
$areanames{en}->{861314532} = "Qingdao\,\ Shandong";
$areanames{en}->{861314533} = "Zibo\,\ Shandong";
$areanames{en}->{861314534} = "Dezhou\,\ Shandong";
$areanames{en}->{861314535} = "Yantai\,\ Shandong";
$areanames{en}->{861314536} = "Weifang\,\ Shandong";
$areanames{en}->{861314537} = "Jining\,\ Shandong";
$areanames{en}->{861314538} = "TaiAn\,\ Shandong";
$areanames{en}->{861314539} = "Linyi\,\ Shandong";
$areanames{en}->{861314540} = "Jinan\,\ Shandong";
$areanames{en}->{861314541} = "Jinan\,\ Shandong";
$areanames{en}->{861314542} = "Qingdao\,\ Shandong";
$areanames{en}->{861314543} = "Binzhou\,\ Shandong";
$areanames{en}->{861314544} = "Rizhao\,\ Shandong";
$areanames{en}->{861314545} = "Dongying\,\ Shandong";
$areanames{en}->{861314546} = "Dongying\,\ Shandong";
$areanames{en}->{861314547} = "Jinan\,\ Shandong";
$areanames{en}->{861314548} = "Laiwu\,\ Shandong";
$areanames{en}->{861314549} = "Linyi\,\ Shandong";
$areanames{en}->{861314550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861314551} = "Hefei\,\ Anhui";
$areanames{en}->{861314552} = "Bengbu\,\ Anhui";
$areanames{en}->{861314553} = "Wuhu\,\ Anhui";
$areanames{en}->{861314554} = "Huainan\,\ Anhui";
$areanames{en}->{861314555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861314556} = "Anqing\,\ Anhui";
$areanames{en}->{861314557} = "Suzhou\,\ Anhui";
$areanames{en}->{861314558} = "Fuyang\,\ Anhui";
$areanames{en}->{861314559} = "Huangshan\,\ Anhui";
$areanames{en}->{861314560} = "Suzhou\,\ Anhui";
$areanames{en}->{861314561} = "Huaibei\,\ Anhui";
$areanames{en}->{861314562} = "Tongling\,\ Anhui";
$areanames{en}->{861314563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861314564} = "LuAn\,\ Anhui";
$areanames{en}->{861314565} = "Hefei\,\ Anhui";
$areanames{en}->{861314566} = "Chizhou\,\ Anhui";
$areanames{en}->{861314567} = "Bozhou\,\ Anhui";
$areanames{en}->{861314568} = "Bozhou\,\ Anhui";
$areanames{en}->{861314569} = "Xuancheng\,\ Anhui";
$areanames{en}->{86131457} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131458} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131459} = "Shenzhen\,\ Guangdong";
$areanames{en}->{8613146} = "Beijing";
$areanames{en}->{86131470} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131471} = "Wuhan\,\ Hubei";
$areanames{en}->{861314720} = "Ezhou\,\ Hubei";
$areanames{en}->{861314721} = "Jingzhou\,\ Hubei";
$areanames{en}->{861314722} = "Suizhou\,\ Hubei";
$areanames{en}->{861314723} = "Huangshi\,\ Hubei";
$areanames{en}->{861314724} = "Xianning\,\ Hubei";
$areanames{en}->{861314725} = "Jingmen\,\ Hubei";
$areanames{en}->{861314726} = "Enshi\,\ Hubei";
$areanames{en}->{861314727} = "Xiangfan\,\ Hubei";
$areanames{en}->{861314728} = "Shiyan\,\ Hubei";
$areanames{en}->{861314729} = "Xiaogan\,\ Hubei";
$areanames{en}->{86131473} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131474} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86131475} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861314760} = "Baicheng\,\ Jilin";
$areanames{en}->{861314761} = "Baicheng\,\ Jilin";
$areanames{en}->{861314762} = "Baicheng\,\ Jilin";
$areanames{en}->{861314763} = "Jilin\,\ Jilin";
$areanames{en}->{861314764} = "Changchun\,\ Jilin";
$areanames{en}->{861314765} = "Changchun\,\ Jilin";
$areanames{en}->{861314766} = "Changchun\,\ Jilin";
$areanames{en}->{861314767} = "Songyuan\,\ Jilin";
$areanames{en}->{861314768} = "Songyuan\,\ Jilin";
$areanames{en}->{861314769} = "Songyuan\,\ Jilin";
$areanames{en}->{861314770} = "Changchun\,\ Jilin";
$areanames{en}->{861314771} = "Changchun\,\ Jilin";
$areanames{en}->{861314772} = "Songyuan\,\ Jilin";
$areanames{en}->{861314773} = "Jilin\,\ Jilin";
$areanames{en}->{861314774} = "Jilin\,\ Jilin";
$areanames{en}->{861314775} = "Jilin\,\ Jilin";
$areanames{en}->{861314776} = "Jilin\,\ Jilin";
$areanames{en}->{861314777} = "Jilin\,\ Jilin";
$areanames{en}->{861314778} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861314779} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861314780} = "Shenyang\,\ Liaoning";
$areanames{en}->{861314781} = "Shenyang\,\ Liaoning";
$areanames{en}->{861314782} = "Shenyang\,\ Liaoning";
$areanames{en}->{861314783} = "Shenyang\,\ Liaoning";
$areanames{en}->{861314784} = "Dalian\,\ Liaoning";
$areanames{en}->{861314785} = "Dalian\,\ Liaoning";
$areanames{en}->{861314786} = "Dalian\,\ Liaoning";
$areanames{en}->{861314787} = "Dalian\,\ Liaoning";
$areanames{en}->{861314788} = "Anshan\,\ Liaoning";
$areanames{en}->{861314789} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314790} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314791} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314792} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314793} = "Yingkou\,\ Liaoning";
$areanames{en}->{861314794} = "Fuxin\,\ Liaoning";
$areanames{en}->{861314795} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861314796} = "Tieling\,\ Liaoning";
$areanames{en}->{861314797} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861314798} = "Panjin\,\ Liaoning";
$areanames{en}->{861314799} = "Huludao\,\ Liaoning";
$areanames{en}->{86131480} = "Shangqiu\,\ Henan";
$areanames{en}->{86131481} = "Shanghai";
$areanames{en}->{86131482} = "Zhoukou\,\ Henan";
$areanames{en}->{86131483} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86131484} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861314850} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314851} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314852} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314853} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314854} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861314855} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314856} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314857} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314858} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314859} = "Dongguan\,\ Guangdong";
$areanames{en}->{861314860} = "Heyuan\,\ Guangdong";
$areanames{en}->{861314861} = "Heyuan\,\ Guangdong";
$areanames{en}->{861314862} = "Meizhou\,\ Guangdong";
$areanames{en}->{861314863} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314864} = "Yunfu\,\ Guangdong";
$areanames{en}->{861314865} = "Yunfu\,\ Guangdong";
$areanames{en}->{861314866} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861314867} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861314868} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861314869} = "Shaoguan\,\ Guangdong";
$areanames{en}->{86131487} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131488} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131489} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314900} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861314901} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861314902} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861314903} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861314904} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861314905} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861314906} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861314907} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861314908} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861314909} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861314910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861314911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861314912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861314913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861314914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861314915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861314916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861314917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861314918} = "XiAn\,\ Shaanxi";
$areanames{en}->{861314919} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{86131492} = "XiAn\,\ Shaanxi";
$areanames{en}->{86131493} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861314930} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861314931} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861314932} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861314933} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86131494} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861314950} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314951} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314952} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861314953} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861314954} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861314955} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861314956} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861314957} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861314958} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861314959} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861314960} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314961} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861314962} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861314963} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861314964} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861314965} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861314966} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861314967} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861314968} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861314969} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861314970} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314971} = "Yingkou\,\ Liaoning";
$areanames{en}->{861314972} = "Anshan\,\ Liaoning";
$areanames{en}->{861314973} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314974} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314975} = "Fuxin\,\ Liaoning";
$areanames{en}->{861314976} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314977} = "Yingkou\,\ Liaoning";
$areanames{en}->{861314978} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861314979} = "Liaoyang\,\ Liaoning";
$areanames{en}->{86131498} = "Shenyang\,\ Liaoning";
$areanames{en}->{861314986} = "Dalian\,\ Liaoning";
$areanames{en}->{861314987} = "Dalian\,\ Liaoning";
$areanames{en}->{861314988} = "Dalian\,\ Liaoning";
$areanames{en}->{861314989} = "Dalian\,\ Liaoning";
$areanames{en}->{86131499} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861315000} = "Zhangye\,\ Gansu";
$areanames{en}->{861315001} = "Lanzhou\,\ Gansu";
$areanames{en}->{861315002} = "Lanzhou\,\ Gansu";
$areanames{en}->{861315003} = "Longnan\,\ Gansu";
$areanames{en}->{861315004} = "Linxia\,\ Gansu";
$areanames{en}->{861315005} = "Gannan\,\ Gansu";
$areanames{en}->{861315006} = "Tianshui\,\ Gansu";
$areanames{en}->{861315007} = "Tianshui\,\ Gansu";
$areanames{en}->{861315008} = "Longnan\,\ Gansu";
$areanames{en}->{861315009} = "Linxia\,\ Gansu";
$areanames{en}->{861315010} = "Dingxi\,\ Gansu";
$areanames{en}->{861315011} = "Dingxi\,\ Gansu";
$areanames{en}->{861315012} = "Qingyang\,\ Gansu";
$areanames{en}->{861315013} = "Qingyang\,\ Gansu";
$areanames{en}->{861315014} = "Zhangye\,\ Gansu";
$areanames{en}->{861315015} = "Wuwei\,\ Gansu";
$areanames{en}->{861315016} = "Wuwei\,\ Gansu";
$areanames{en}->{861315017} = "Jinchang\,\ Gansu";
$areanames{en}->{861315018} = "Pingliang\,\ Gansu";
$areanames{en}->{861315019} = "Jiuquan\,\ Gansu";
$areanames{en}->{861315020} = "Ili\,\ Xinjiang";
$areanames{en}->{861315021} = "Ili\,\ Xinjiang";
$areanames{en}->{861315022} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861315023} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861315024} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861315025} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861315026} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861315027} = "Aksu\,\ Xinjiang";
$areanames{en}->{861315028} = "Aksu\,\ Xinjiang";
$areanames{en}->{861315029} = "Kashi\,\ Xinjiang";
$areanames{en}->{861315030} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315031} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315032} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315033} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315034} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315035} = "Changji\,\ Xinjiang";
$areanames{en}->{861315036} = "Hami\,\ Xinjiang";
$areanames{en}->{861315037} = "Ili\,\ Xinjiang";
$areanames{en}->{861315038} = "Bortala\,\ Xinjiang";
$areanames{en}->{861315039} = "Bortala\,\ Xinjiang";
$areanames{en}->{861315040} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861315041} = "Kashi\,\ Xinjiang";
$areanames{en}->{861315042} = "Aksu\,\ Xinjiang";
$areanames{en}->{861315043} = "Hotan\,\ Xinjiang";
$areanames{en}->{861315044} = "Kashi\,\ Xinjiang";
$areanames{en}->{861315045} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315046} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315047} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315048} = "Aksu\,\ Xinjiang";
$areanames{en}->{861315049} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861315050} = "Yuxi\,\ Yunnan";
$areanames{en}->{861315051} = "Yuxi\,\ Yunnan";
$areanames{en}->{861315052} = "Yuxi\,\ Yunnan";
$areanames{en}->{861315053} = "Qujing\,\ Yunnan";
$areanames{en}->{861315054} = "Qujing\,\ Yunnan";
$areanames{en}->{861315055} = "Qujing\,\ Yunnan";
$areanames{en}->{861315056} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861315057} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861315058} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861315059} = "Honghe\,\ Yunnan";
$areanames{en}->{861315060} = "Honghe\,\ Yunnan";
$areanames{en}->{861315061} = "Honghe\,\ Yunnan";
$areanames{en}->{861315062} = "Honghe\,\ Yunnan";
$areanames{en}->{861315063} = "Dali\,\ Yunnan";
$areanames{en}->{861315064} = "Dali\,\ Yunnan";
$areanames{en}->{861315065} = "Dali\,\ Yunnan";
$areanames{en}->{861315066} = "Lijiang\,\ Yunnan";
$areanames{en}->{861315067} = "Lijiang\,\ Yunnan";
$areanames{en}->{861315068} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861315069} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861315070} = "Kunming\,\ Yunnan";
$areanames{en}->{861315071} = "Kunming\,\ Yunnan";
$areanames{en}->{861315072} = "Nujiang\,\ Yunnan";
$areanames{en}->{861315073} = "Deqen\,\ Yunnan";
$areanames{en}->{861315074} = "Kunming\,\ Yunnan";
$areanames{en}->{861315075} = "Kunming\,\ Yunnan";
$areanames{en}->{861315076} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861315077} = "Baoshan\,\ Yunnan";
$areanames{en}->{861315078} = "Wenshan\,\ Yunnan";
$areanames{en}->{861315079} = "Puer\,\ Yunnan";
$areanames{en}->{861315080} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861315081} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861315082} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861315083} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861315084} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861315085} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861315086} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861315087} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861315088} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861315089} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{86131509} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861315090} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861315099} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861315100} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861315101} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861315102} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861315103} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861315104} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861315105} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315106} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315107} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315108} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315109} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315110} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315111} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315112} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315113} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315114} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315115} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315116} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315117} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315118} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315119} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315120} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861315121} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861315122} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861315123} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861315124} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861315125} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861315126} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861315127} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861315128} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861315129} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861315130} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861315131} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861315132} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861315133} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861315134} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861315135} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861315136} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861315137} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861315138} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861315139} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861315140} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315141} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315142} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315143} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315144} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861315145} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861315146} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315147} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315148} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315149} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86131515} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861315150} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315151} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315160} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315161} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861315162} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315163} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315164} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315165} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315166} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861315167} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861315168} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861315169} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{86131517} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861315178} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861315179} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{86131518} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861315180} = "Suqian\,\ Jiangsu";
$areanames{en}->{861315181} = "Suqian\,\ Jiangsu";
$areanames{en}->{861315182} = "Suqian\,\ Jiangsu";
$areanames{en}->{861315183} = "Suqian\,\ Jiangsu";
$areanames{en}->{86131519} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861315198} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861315199} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{86131520} = "XiAn\,\ Shaanxi";
$areanames{en}->{86131521} = "XiAn\,\ Shaanxi";
$areanames{en}->{861315220} = "Baoji\,\ Shaanxi";
$areanames{en}->{861315221} = "Baoji\,\ Shaanxi";
$areanames{en}->{861315222} = "Baoji\,\ Shaanxi";
$areanames{en}->{861315223} = "Baoji\,\ Shaanxi";
$areanames{en}->{861315224} = "Baoji\,\ Shaanxi";
$areanames{en}->{861315225} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861315226} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861315227} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861315228} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861315229} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861315230} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861315231} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861315232} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861315233} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861315234} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861315235} = "Weinan\,\ Shaanxi";
$areanames{en}->{861315236} = "Weinan\,\ Shaanxi";
$areanames{en}->{861315237} = "Weinan\,\ Shaanxi";
$areanames{en}->{861315238} = "Weinan\,\ Shaanxi";
$areanames{en}->{861315239} = "Weinan\,\ Shaanxi";
$areanames{en}->{86131524} = "XiAn\,\ Shaanxi";
$areanames{en}->{861315250} = "Nanning\,\ Guangxi";
$areanames{en}->{861315251} = "Nanning\,\ Guangxi";
$areanames{en}->{861315252} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861315253} = "Guilin\,\ Guangxi";
$areanames{en}->{861315254} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861315255} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861315256} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861315257} = "Guilin\,\ Guangxi";
$areanames{en}->{861315258} = "Guilin\,\ Guangxi";
$areanames{en}->{861315259} = "Guilin\,\ Guangxi";
$areanames{en}->{86131526} = "Nanning\,\ Guangxi";
$areanames{en}->{861315262} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861315263} = "Guilin\,\ Guangxi";
$areanames{en}->{861315270} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861315271} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861315272} = "Datong\,\ Shanxi";
$areanames{en}->{861315273} = "Yangquan\,\ Shanxi";
$areanames{en}->{861315274} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861315275} = "Changzhi\,\ Shanxi";
$areanames{en}->{861315276} = "Jincheng\,\ Shanxi";
$areanames{en}->{861315277} = "Linfen\,\ Shanxi";
$areanames{en}->{861315278} = "Lüliang\,\ Shanxi";
$areanames{en}->{861315279} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861315280} = "Linfen\,\ Shanxi";
$areanames{en}->{861315281} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861315282} = "Datong\,\ Shanxi";
$areanames{en}->{861315283} = "Yangquan\,\ Shanxi";
$areanames{en}->{861315284} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861315285} = "Changzhi\,\ Shanxi";
$areanames{en}->{861315286} = "Jincheng\,\ Shanxi";
$areanames{en}->{861315287} = "Linfen\,\ Shanxi";
$areanames{en}->{861315288} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861315289} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861315290} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861315291} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861315292} = "Datong\,\ Shanxi";
$areanames{en}->{861315293} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861315294} = "Datong\,\ Shanxi";
$areanames{en}->{861315295} = "Changzhi\,\ Shanxi";
$areanames{en}->{861315296} = "Jincheng\,\ Shanxi";
$areanames{en}->{861315297} = "Linfen\,\ Shanxi";
$areanames{en}->{861315298} = "Lüliang\,\ Shanxi";
$areanames{en}->{861315299} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861315300} = "Jinan\,\ Shandong";
$areanames{en}->{861315301} = "Jinan\,\ Shandong";
$areanames{en}->{861315302} = "Jinan\,\ Shandong";
$areanames{en}->{861315303} = "Jinan\,\ Shandong";
$areanames{en}->{861315304} = "Jinan\,\ Shandong";
$areanames{en}->{861315305} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315306} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315307} = "Heze\,\ Shandong";
$areanames{en}->{861315308} = "Heze\,\ Shandong";
$areanames{en}->{861315309} = "Heze\,\ Shandong";
$areanames{en}->{86131531} = "Jinan\,\ Shandong";
$areanames{en}->{86131532} = "Qingdao\,\ Shandong";
$areanames{en}->{861315330} = "Weihai\,\ Shandong";
$areanames{en}->{861315331} = "Weihai\,\ Shandong";
$areanames{en}->{861315332} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315333} = "Rizhao\,\ Shandong";
$areanames{en}->{861315334} = "Rizhao\,\ Shandong";
$areanames{en}->{861315335} = "Zibo\,\ Shandong";
$areanames{en}->{861315336} = "Zibo\,\ Shandong";
$areanames{en}->{861315337} = "Zibo\,\ Shandong";
$areanames{en}->{861315338} = "Zibo\,\ Shandong";
$areanames{en}->{861315339} = "Zibo\,\ Shandong";
$areanames{en}->{861315340} = "Weihai\,\ Shandong";
$areanames{en}->{861315341} = "Dongying\,\ Shandong";
$areanames{en}->{861315342} = "Binzhou\,\ Shandong";
$areanames{en}->{861315343} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315344} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315345} = "Dezhou\,\ Shandong";
$areanames{en}->{861315346} = "Dezhou\,\ Shandong";
$areanames{en}->{861315347} = "Dezhou\,\ Shandong";
$areanames{en}->{861315348} = "Dezhou\,\ Shandong";
$areanames{en}->{861315349} = "Dezhou\,\ Shandong";
$areanames{en}->{861315350} = "Yantai\,\ Shandong";
$areanames{en}->{861315351} = "Yantai\,\ Shandong";
$areanames{en}->{861315352} = "Yantai\,\ Shandong";
$areanames{en}->{861315353} = "Yantai\,\ Shandong";
$areanames{en}->{861315354} = "Yantai\,\ Shandong";
$areanames{en}->{861315355} = "Dongying\,\ Shandong";
$areanames{en}->{861315356} = "Dongying\,\ Shandong";
$areanames{en}->{861315357} = "Weihai\,\ Shandong";
$areanames{en}->{861315358} = "Binzhou\,\ Shandong";
$areanames{en}->{861315359} = "Binzhou\,\ Shandong";
$areanames{en}->{86131536} = "Weifang\,\ Shandong";
$areanames{en}->{86131537} = "Jining\,\ Shandong";
$areanames{en}->{86131538} = "TaiAn\,\ Shandong";
$areanames{en}->{861315380} = "Liaocheng\,\ Shandong";
$areanames{en}->{861315381} = "Liaocheng\,\ Shandong";
$areanames{en}->{861315382} = "Liaocheng\,\ Shandong";
$areanames{en}->{861315383} = "Laiwu\,\ Shandong";
$areanames{en}->{86131539} = "Linyi\,\ Shandong";
$areanames{en}->{861315400} = "Yulin\,\ Shaanxi";
$areanames{en}->{861315401} = "Yulin\,\ Shaanxi";
$areanames{en}->{861315402} = "Yulin\,\ Shaanxi";
$areanames{en}->{861315403} = "Ankang\,\ Shaanxi";
$areanames{en}->{861315404} = "Ankang\,\ Shaanxi";
$areanames{en}->{861315405} = "Ankang\,\ Shaanxi";
$areanames{en}->{861315406} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861315407} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861315408} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861315409} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861315410} = "Tieling\,\ Liaoning";
$areanames{en}->{861315411} = "Dalian\,\ Liaoning";
$areanames{en}->{861315412} = "Anshan\,\ Liaoning";
$areanames{en}->{861315413} = "Fushun\,\ Liaoning";
$areanames{en}->{861315414} = "Benxi\,\ Liaoning";
$areanames{en}->{861315415} = "Dandong\,\ Liaoning";
$areanames{en}->{861315416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861315417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861315418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861315419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861315420} = "Tieling\,\ Liaoning";
$areanames{en}->{861315421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861315422} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861315423} = "Fushun\,\ Liaoning";
$areanames{en}->{861315424} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861315425} = "Anshan\,\ Liaoning";
$areanames{en}->{861315426} = "Dalian\,\ Liaoning";
$areanames{en}->{861315427} = "Panjin\,\ Liaoning";
$areanames{en}->{861315428} = "Panjin\,\ Liaoning";
$areanames{en}->{861315429} = "Huludao\,\ Liaoning";
$areanames{en}->{86131543} = "Changchun\,\ Jilin";
$areanames{en}->{861315432} = "Jilin\,\ Jilin";
$areanames{en}->{861315433} = "Yanbian\,\ Jilin";
$areanames{en}->{861315434} = "Siping\,\ Jilin";
$areanames{en}->{861315438} = "Songyuan\,\ Jilin";
$areanames{en}->{861315440} = "Aba\,\ Sichuan";
$areanames{en}->{861315441} = "Garze\,\ Sichuan";
$areanames{en}->{861315442} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861315443} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861315444} = "Mianyang\,\ Sichuan";
$areanames{en}->{861315445} = "Mianyang\,\ Sichuan";
$areanames{en}->{861315446} = "Mianyang\,\ Sichuan";
$areanames{en}->{861315447} = "Deyang\,\ Sichuan";
$areanames{en}->{861315448} = "Deyang\,\ Sichuan";
$areanames{en}->{861315449} = "Deyang\,\ Sichuan";
$areanames{en}->{861315450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861315451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861315452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861315453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861315454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861315455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861315456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861315457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861315458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861315459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861315460} = "Luzhou\,\ Sichuan";
$areanames{en}->{861315461} = "Ziyang\,\ Sichuan";
$areanames{en}->{861315462} = "Ziyang\,\ Sichuan";
$areanames{en}->{861315463} = "Zigong\,\ Sichuan";
$areanames{en}->{861315464} = "Zigong\,\ Sichuan";
$areanames{en}->{861315465} = "Zigong\,\ Sichuan";
$areanames{en}->{861315466} = "Zigong\,\ Sichuan";
$areanames{en}->{861315467} = "Zigong\,\ Sichuan";
$areanames{en}->{861315468} = "Neijiang\,\ Sichuan";
$areanames{en}->{861315469} = "Yibin\,\ Sichuan";
$areanames{en}->{861315470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861315471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861315472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861315473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861315474} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861315475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861315476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861315477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861315478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861315479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861315480} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861315481} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861315482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861315483} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861315484} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861315485} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861315486} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861315487} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861315488} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861315489} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861315490} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861315491} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861315492} = "Liangshan\,\ Sichuan";
$areanames{en}->{861315493} = "Ankang\,\ Shaanxi";
$areanames{en}->{861315494} = "Meishan\,\ Sichuan";
$areanames{en}->{861315495} = "Meishan\,\ Sichuan";
$areanames{en}->{861315496} = "Meishan\,\ Sichuan";
$areanames{en}->{861315497} = "Leshan\,\ Sichuan";
$areanames{en}->{861315498} = "Leshan\,\ Sichuan";
$areanames{en}->{861315499} = "Leshan\,\ Sichuan";
$areanames{en}->{86131550} = "Chuzhou\,\ Anhui";
$areanames{en}->{86131551} = "Hefei\,\ Anhui";
$areanames{en}->{86131552} = "Bengbu\,\ Anhui";
$areanames{en}->{861315530} = "Wuhu\,\ Anhui";
$areanames{en}->{861315531} = "Wuhu\,\ Anhui";
$areanames{en}->{861315532} = "Wuhu\,\ Anhui";
$areanames{en}->{861315533} = "Wuhu\,\ Anhui";
$areanames{en}->{861315534} = "Wuhu\,\ Anhui";
$areanames{en}->{861315535} = "MaAnshan\,\ Anhui";
$areanames{en}->{861315536} = "MaAnshan\,\ Anhui";
$areanames{en}->{861315537} = "Xuancheng\,\ Anhui";
$areanames{en}->{861315538} = "LuAn\,\ Anhui";
$areanames{en}->{861315539} = "LuAn\,\ Anhui";
$areanames{en}->{86131554} = "Huainan\,\ Anhui";
$areanames{en}->{86131555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861315556} = "Anqing\,\ Anhui";
$areanames{en}->{861315557} = "Suzhou\,\ Anhui";
$areanames{en}->{861315558} = "Fuyang\,\ Anhui";
$areanames{en}->{861315559} = "Huangshan\,\ Anhui";
$areanames{en}->{861315560} = "Anqing\,\ Anhui";
$areanames{en}->{861315561} = "Huaibei\,\ Anhui";
$areanames{en}->{861315562} = "Tongling\,\ Anhui";
$areanames{en}->{861315563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861315564} = "LuAn\,\ Anhui";
$areanames{en}->{861315565} = "Hefei\,\ Anhui";
$areanames{en}->{861315566} = "Chizhou\,\ Anhui";
$areanames{en}->{861315567} = "Bozhou\,\ Anhui";
$areanames{en}->{861315568} = "Bozhou\,\ Anhui";
$areanames{en}->{861315569} = "Anqing\,\ Anhui";
$areanames{en}->{861315570} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861315571} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861315572} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861315573} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861315574} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861315575} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861315576} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861315577} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861315578} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861315579} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861315580} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861315581} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861315582} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861315583} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861315584} = "JiAn\,\ Jiangxi";
$areanames{en}->{861315585} = "JiAn\,\ Jiangxi";
$areanames{en}->{861315586} = "JiAn\,\ Jiangxi";
$areanames{en}->{861315587} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861315588} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861315589} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861315590} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861315591} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861315592} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861315593} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861315594} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861315595} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861315596} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861315597} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861315598} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861315599} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861315600} = "Jinan\,\ Shandong";
$areanames{en}->{861315601} = "Jinan\,\ Shandong";
$areanames{en}->{861315602} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315603} = "Qingdao\,\ Shandong";
$areanames{en}->{861315604} = "Qingdao\,\ Shandong";
$areanames{en}->{861315605} = "Qingdao\,\ Shandong";
$areanames{en}->{861315606} = "Dongying\,\ Shandong";
$areanames{en}->{861315607} = "Dongying\,\ Shandong";
$areanames{en}->{861315608} = "Weihai\,\ Shandong";
$areanames{en}->{861315609} = "Weihai\,\ Shandong";
$areanames{en}->{86131561} = "Jinan\,\ Shandong";
$areanames{en}->{86131562} = "Qingdao\,\ Shandong";
$areanames{en}->{861315630} = "Weihai\,\ Shandong";
$areanames{en}->{861315631} = "Weihai\,\ Shandong";
$areanames{en}->{861315632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315633} = "Rizhao\,\ Shandong";
$areanames{en}->{861315634} = "Laiwu\,\ Shandong";
$areanames{en}->{861315635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861315636} = "Qingdao\,\ Shandong";
$areanames{en}->{861315637} = "Qingdao\,\ Shandong";
$areanames{en}->{861315638} = "Qingdao\,\ Shandong";
$areanames{en}->{861315639} = "Qingdao\,\ Shandong";
$areanames{en}->{861315640} = "Jinan\,\ Shandong";
$areanames{en}->{861315641} = "Jinan\,\ Shandong";
$areanames{en}->{861315642} = "Qingdao\,\ Shandong";
$areanames{en}->{861315643} = "Zibo\,\ Shandong";
$areanames{en}->{861315644} = "Jinan\,\ Shandong";
$areanames{en}->{861315645} = "Yantai\,\ Shandong";
$areanames{en}->{861315646} = "Weifang\,\ Shandong";
$areanames{en}->{861315647} = "Dongying\,\ Shandong";
$areanames{en}->{861315648} = "Qingdao\,\ Shandong";
$areanames{en}->{861315649} = "Binzhou\,\ Shandong";
$areanames{en}->{86131565} = "Hefei\,\ Anhui";
$areanames{en}->{86131566} = "Chizhou\,\ Anhui";
$areanames{en}->{86131567} = "Bozhou\,\ Anhui";
$areanames{en}->{861315680} = "Dongying\,\ Shandong";
$areanames{en}->{861315681} = "Dongying\,\ Shandong";
$areanames{en}->{861315682} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861315683} = "Binzhou\,\ Shandong";
$areanames{en}->{861315684} = "Heze\,\ Shandong";
$areanames{en}->{861315685} = "Qingdao\,\ Shandong";
$areanames{en}->{861315686} = "Qingdao\,\ Shandong";
$areanames{en}->{861315687} = "Qingdao\,\ Shandong";
$areanames{en}->{861315688} = "Qingdao\,\ Shandong";
$areanames{en}->{861315689} = "Qingdao\,\ Shandong";
$areanames{en}->{86131569} = "Yantai\,\ Shandong";
$areanames{en}->{861315696} = "Weifang\,\ Shandong";
$areanames{en}->{861315697} = "TaiAn\,\ Shandong";
$areanames{en}->{861315698} = "Zibo\,\ Shandong";
$areanames{en}->{861315699} = "Rizhao\,\ Shandong";
$areanames{en}->{86131570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{86131571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86131572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{86131573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{86131574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86131575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86131576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86131577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86131578} = "Lishui\,\ Zhejiang";
$areanames{en}->{86131579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86131580} = "Guiyang\,\ Guizhou";
$areanames{en}->{861315810} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861315811} = "Zunyi\,\ Guizhou";
$areanames{en}->{861315812} = "Zunyi\,\ Guizhou";
$areanames{en}->{861315813} = "Anshun\,\ Guizhou";
$areanames{en}->{861315814} = "Qiannan\,\ Guizhou";
$areanames{en}->{861315815} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861315816} = "Qiannan\,\ Guizhou";
$areanames{en}->{861315817} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861315818} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861315819} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861315820} = "Zunyi\,\ Guizhou";
$areanames{en}->{861315821} = "Zunyi\,\ Guizhou";
$areanames{en}->{861315822} = "Zunyi\,\ Guizhou";
$areanames{en}->{861315823} = "Anshun\,\ Guizhou";
$areanames{en}->{861315824} = "Qiannan\,\ Guizhou";
$areanames{en}->{861315825} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861315826} = "Tongren\,\ Guizhou";
$areanames{en}->{861315827} = "Bijie\,\ Guizhou";
$areanames{en}->{861315828} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861315829} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861315830} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861315831} = "Anshun\,\ Guizhou";
$areanames{en}->{861315832} = "Zunyi\,\ Guizhou";
$areanames{en}->{861315833} = "Anshun\,\ Guizhou";
$areanames{en}->{861315834} = "Qiannan\,\ Guizhou";
$areanames{en}->{861315835} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861315836} = "Tongren\,\ Guizhou";
$areanames{en}->{861315837} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861315838} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861315839} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861315840} = "Garze\,\ Sichuan";
$areanames{en}->{861315841} = "Aba\,\ Sichuan";
$areanames{en}->{861315842} = "Dazhou\,\ Sichuan";
$areanames{en}->{861315843} = "Bazhong\,\ Sichuan";
$areanames{en}->{861315844} = "Deyang\,\ Sichuan";
$areanames{en}->{861315845} = "Mianyang\,\ Sichuan";
$areanames{en}->{861315846} = "GuangAn\,\ Sichuan";
$areanames{en}->{861315847} = "Liangshan\,\ Sichuan";
$areanames{en}->{861315848} = "Suining\,\ Sichuan";
$areanames{en}->{861315849} = "Ziyang\,\ Sichuan";
$areanames{en}->{861315850} = "Nanchong\,\ Sichuan";
$areanames{en}->{861315851} = "Nanchong\,\ Sichuan";
$areanames{en}->{861315852} = "Nanchong\,\ Sichuan";
$areanames{en}->{861315853} = "YaAn\,\ Sichuan";
$areanames{en}->{861315854} = "YaAn\,\ Sichuan";
$areanames{en}->{861315855} = "Liangshan\,\ Sichuan";
$areanames{en}->{861315856} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861315857} = "Neijiang\,\ Sichuan";
$areanames{en}->{861315858} = "Neijiang\,\ Sichuan";
$areanames{en}->{861315859} = "Neijiang\,\ Sichuan";
$areanames{en}->{861315860} = "Luzhou\,\ Sichuan";
$areanames{en}->{861315861} = "Luzhou\,\ Sichuan";
$areanames{en}->{861315862} = "Luzhou\,\ Sichuan";
$areanames{en}->{861315863} = "Yibin\,\ Sichuan";
$areanames{en}->{861315864} = "Yibin\,\ Sichuan";
$areanames{en}->{861315865} = "Yibin\,\ Sichuan";
$areanames{en}->{861315866} = "Deyang\,\ Sichuan";
$areanames{en}->{861315867} = "Deyang\,\ Sichuan";
$areanames{en}->{861315868} = "Deyang\,\ Sichuan";
$areanames{en}->{861315869} = "Deyang\,\ Sichuan";
$areanames{en}->{861315870} = "Dazhou\,\ Sichuan";
$areanames{en}->{861315871} = "Bazhong\,\ Sichuan";
$areanames{en}->{861315872} = "GuangAn\,\ Sichuan";
$areanames{en}->{861315873} = "Suining\,\ Sichuan";
$areanames{en}->{861315874} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861315875} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861315876} = "Meishan\,\ Sichuan";
$areanames{en}->{861315877} = "Meishan\,\ Sichuan";
$areanames{en}->{861315878} = "Ziyang\,\ Sichuan";
$areanames{en}->{861315879} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861315880} = "Zigong\,\ Sichuan";
$areanames{en}->{861315881} = "Zigong\,\ Sichuan";
$areanames{en}->{861315882} = "Zigong\,\ Sichuan";
$areanames{en}->{861315883} = "Leshan\,\ Sichuan";
$areanames{en}->{861315884} = "Leshan\,\ Sichuan";
$areanames{en}->{861315885} = "Leshan\,\ Sichuan";
$areanames{en}->{861315886} = "Mianyang\,\ Sichuan";
$areanames{en}->{861315887} = "Mianyang\,\ Sichuan";
$areanames{en}->{861315888} = "Mianyang\,\ Sichuan";
$areanames{en}->{861315889} = "Mianyang\,\ Sichuan";
$areanames{en}->{86131589} = "Haikou\,\ Hainan";
$areanames{en}->{86131590} = "Quanzhou\,\ Fujian";
$areanames{en}->{86131591} = "Zhangzhou\,\ Fujian";
$areanames{en}->{86131592} = "Xiamen\,\ Fujian";
$areanames{en}->{861315924} = "Sanming\,\ Fujian";
$areanames{en}->{861315928} = "Nanping\,\ Fujian";
$areanames{en}->{861315929} = "Nanping\,\ Fujian";
$areanames{en}->{861315930} = "Longyan\,\ Fujian";
$areanames{en}->{861315931} = "Longyan\,\ Fujian";
$areanames{en}->{861315932} = "Longyan\,\ Fujian";
$areanames{en}->{861315933} = "Putian\,\ Fujian";
$areanames{en}->{861315934} = "Ningde\,\ Fujian";
$areanames{en}->{861315935} = "Ningde\,\ Fujian";
$areanames{en}->{861315936} = "Sanming\,\ Fujian";
$areanames{en}->{861315937} = "Sanming\,\ Fujian";
$areanames{en}->{861315938} = "Sanming\,\ Fujian";
$areanames{en}->{861315939} = "Sanming\,\ Fujian";
$areanames{en}->{861315940} = "Fuzhou\,\ Fujian";
$areanames{en}->{861315941} = "Fuzhou\,\ Fujian";
$areanames{en}->{861315942} = "Fuzhou\,\ Fujian";
$areanames{en}->{861315943} = "Fuzhou\,\ Fujian";
$areanames{en}->{861315944} = "Putian\,\ Fujian";
$areanames{en}->{861315945} = "Putian\,\ Fujian";
$areanames{en}->{861315946} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861315947} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861315948} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861315949} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861315950} = "Changchun\,\ Jilin";
$areanames{en}->{861315951} = "Changchun\,\ Jilin";
$areanames{en}->{861315952} = "Changchun\,\ Jilin";
$areanames{en}->{861315953} = "Changchun\,\ Jilin";
$areanames{en}->{861315954} = "Jilin\,\ Jilin";
$areanames{en}->{861315955} = "Jilin\,\ Jilin";
$areanames{en}->{861315956} = "Changchun\,\ Jilin";
$areanames{en}->{861315957} = "Jilin\,\ Jilin";
$areanames{en}->{861315958} = "Songyuan\,\ Jilin";
$areanames{en}->{861315959} = "Baicheng\,\ Jilin";
$areanames{en}->{861315960} = "Changchun\,\ Jilin";
$areanames{en}->{861315961} = "Changchun\,\ Jilin";
$areanames{en}->{861315962} = "Siping\,\ Jilin";
$areanames{en}->{861315963} = "Yanbian\,\ Jilin";
$areanames{en}->{861315964} = "Changchun\,\ Jilin";
$areanames{en}->{861315965} = "Tonghua\,\ Jilin";
$areanames{en}->{861315966} = "Jilin\,\ Jilin";
$areanames{en}->{861315967} = "Songyuan\,\ Jilin";
$areanames{en}->{861315968} = "Changchun\,\ Jilin";
$areanames{en}->{861315969} = "Baishan\,\ Jilin";
$areanames{en}->{861315970} = "Jilin\,\ Jilin";
$areanames{en}->{861315971} = "Songyuan\,\ Jilin";
$areanames{en}->{861315972} = "Tonghua\,\ Jilin";
$areanames{en}->{861315973} = "Tonghua\,\ Jilin";
$areanames{en}->{861315974} = "Changchun\,\ Jilin";
$areanames{en}->{861315975} = "Changchun\,\ Jilin";
$areanames{en}->{861315976} = "Baicheng\,\ Jilin";
$areanames{en}->{861315977} = "Changchun\,\ Jilin";
$areanames{en}->{861315978} = "Siping\,\ Jilin";
$areanames{en}->{861315979} = "Baishan\,\ Jilin";
$areanames{en}->{861315980} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861315981} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861315982} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861315983} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861315984} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861315985} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861315986} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861315987} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861315988} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861315989} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861315990} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861315991} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861315992} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861315993} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861315994} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861315995} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861315996} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861315997} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861315998} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861315999} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86131600} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861316000} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861316001} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{86131601} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861316017} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861316018} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861316019} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86131602} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861316020} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861316021} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861316022} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861316030} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861316031} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861316032} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861316033} = "Suqian\,\ Jiangsu";
$areanames{en}->{861316034} = "Suqian\,\ Jiangsu";
$areanames{en}->{861316035} = "Suqian\,\ Jiangsu";
$areanames{en}->{861316036} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316037} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316038} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316039} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316040} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861316041} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861316042} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861316043} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861316044} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861316045} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861316046} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861316047} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861316048} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861316049} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316050} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316051} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316052} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316053} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316054} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316055} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316056} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316057} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316058} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316059} = "Qingyuan\,\ Guangdong";
$areanames{en}->{86131606} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861316060} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316061} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316062} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316063} = "Chaozhou\,\ Guangdong";
$areanames{en}->{86131607} = "Huizhou\,\ Guangdong";
$areanames{en}->{86131608} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131609} = "Foshan\,\ Guangdong";
$areanames{en}->{8613161} = "Beijing";
$areanames{en}->{8613162} = "Shanghai";
$areanames{en}->{86131630} = "Tianjin";
$areanames{en}->{86131631} = "Tianjin";
$areanames{en}->{86131632} = "Wuhan\,\ Hubei";
$areanames{en}->{86131633} = "Wuhan\,\ Hubei";
$areanames{en}->{861316340} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861316341} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861316342} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861316343} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861316344} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861316345} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861316346} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861316347} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316348} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316349} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861316350} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861316351} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861316352} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861316353} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861316354} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861316355} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861316356} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861316357} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316358} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316359} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316360} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861316361} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861316362} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861316363} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316364} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316365} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861316366} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861316367} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861316368} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861316369} = "Harbin\,\ Heilongjiang";
$areanames{en}->{86131637} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316380} = "Nanping\,\ Fujian";
$areanames{en}->{861316381} = "Longyan\,\ Fujian";
$areanames{en}->{861316382} = "Sanming\,\ Fujian";
$areanames{en}->{861316383} = "Ningde\,\ Fujian";
$areanames{en}->{861316384} = "Sanmenxia\,\ Henan";
$areanames{en}->{861316385} = "Ningde\,\ Fujian";
$areanames{en}->{861316386} = "Putian\,\ Fujian";
$areanames{en}->{861316387} = "Fuzhou\,\ Fujian";
$areanames{en}->{861316388} = "Fuzhou\,\ Fujian";
$areanames{en}->{861316389} = "Fuzhou\,\ Fujian";
$areanames{en}->{86131639} = "Quanzhou\,\ Fujian";
$areanames{en}->{861316390} = "Xiamen\,\ Fujian";
$areanames{en}->{861316397} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861316398} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861316399} = "Xiamen\,\ Fujian";
$areanames{en}->{86131640} = "Tianjin";
$areanames{en}->{86131641} = "Wuhan\,\ Hubei";
$areanames{en}->{86131642} = "Beijing";
$areanames{en}->{86131643} = "Zhengzhou\,\ Henan";
$areanames{en}->{86131644} = "Chongqing";
$areanames{en}->{86131645} = "Dalian\,\ Liaoning";
$areanames{en}->{86131646} = "Wuhan\,\ Hubei";
$areanames{en}->{86131647} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316480} = "Fuzhou\,\ Fujian";
$areanames{en}->{861316481} = "Fuzhou\,\ Fujian";
$areanames{en}->{861316482} = "Fuzhou\,\ Fujian";
$areanames{en}->{861316483} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861316484} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861316485} = "Putian\,\ Fujian";
$areanames{en}->{861316486} = "Putian\,\ Fujian";
$areanames{en}->{861316487} = "Xiamen\,\ Fujian";
$areanames{en}->{861316488} = "Xiamen\,\ Fujian";
$areanames{en}->{861316489} = "Xiamen\,\ Fujian";
$areanames{en}->{861316490} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861316491} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861316492} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861316493} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861316494} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861316495} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861316496} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316497} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316498} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316499} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86131650} = "Qingdao\,\ Shandong";
$areanames{en}->{861316510} = "Jinan\,\ Shandong";
$areanames{en}->{861316511} = "Jinan\,\ Shandong";
$areanames{en}->{861316512} = "Jinan\,\ Shandong";
$areanames{en}->{861316513} = "Jinan\,\ Shandong";
$areanames{en}->{861316514} = "Jinan\,\ Shandong";
$areanames{en}->{861316515} = "Qingdao\,\ Shandong";
$areanames{en}->{861316516} = "Qingdao\,\ Shandong";
$areanames{en}->{861316517} = "Jining\,\ Shandong";
$areanames{en}->{861316518} = "Jining\,\ Shandong";
$areanames{en}->{861316519} = "Jining\,\ Shandong";
$areanames{en}->{861316520} = "Rizhao\,\ Shandong";
$areanames{en}->{861316521} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861316522} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861316523} = "Dezhou\,\ Shandong";
$areanames{en}->{861316524} = "Dezhou\,\ Shandong";
$areanames{en}->{861316525} = "Dongying\,\ Shandong";
$areanames{en}->{861316526} = "Weifang\,\ Shandong";
$areanames{en}->{861316527} = "Linyi\,\ Shandong";
$areanames{en}->{861316528} = "Linyi\,\ Shandong";
$areanames{en}->{861316529} = "Linyi\,\ Shandong";
$areanames{en}->{861316530} = "Heze\,\ Shandong";
$areanames{en}->{861316531} = "Jinan\,\ Shandong";
$areanames{en}->{861316532} = "Qingdao\,\ Shandong";
$areanames{en}->{861316533} = "Zibo\,\ Shandong";
$areanames{en}->{861316534} = "Dezhou\,\ Shandong";
$areanames{en}->{861316535} = "Yantai\,\ Shandong";
$areanames{en}->{861316536} = "Weifang\,\ Shandong";
$areanames{en}->{861316537} = "Jining\,\ Shandong";
$areanames{en}->{861316538} = "TaiAn\,\ Shandong";
$areanames{en}->{861316539} = "Linyi\,\ Shandong";
$areanames{en}->{861316540} = "Liaocheng\,\ Shandong";
$areanames{en}->{861316541} = "Jinan\,\ Shandong";
$areanames{en}->{861316542} = "Qingdao\,\ Shandong";
$areanames{en}->{861316543} = "Binzhou\,\ Shandong";
$areanames{en}->{861316544} = "Zibo\,\ Shandong";
$areanames{en}->{861316545} = "Yantai\,\ Shandong";
$areanames{en}->{861316546} = "Dongying\,\ Shandong";
$areanames{en}->{861316547} = "Jining\,\ Shandong";
$areanames{en}->{861316548} = "Zibo\,\ Shandong";
$areanames{en}->{861316549} = "Linyi\,\ Shandong";
$areanames{en}->{861316550} = "Handan\,\ Hebei";
$areanames{en}->{861316551} = "Handan\,\ Hebei";
$areanames{en}->{861316552} = "Chengde\,\ Hebei";
$areanames{en}->{861316553} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861316554} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861316555} = "Hengshui\,\ Hebei";
$areanames{en}->{861316556} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861316557} = "Baoding\,\ Hebei";
$areanames{en}->{861316558} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861316559} = "Baoding\,\ Hebei";
$areanames{en}->{861316560} = "Jingzhou\,\ Hubei";
$areanames{en}->{861316561} = "Yichang\,\ Hubei";
$areanames{en}->{861316562} = "Jingmen\,\ Hubei";
$areanames{en}->{861316563} = "Shiyan\,\ Hubei";
$areanames{en}->{861316564} = "Xiangfan\,\ Hubei";
$areanames{en}->{861316565} = "Huanggang\,\ Hubei";
$areanames{en}->{861316566} = "Xiaogan\,\ Hubei";
$areanames{en}->{861316567} = "Huangshi\,\ Hubei";
$areanames{en}->{861316568} = "Huangshi\,\ Hubei";
$areanames{en}->{861316569} = "Xianning\,\ Hubei";
$areanames{en}->{86131657} = "XiAn\,\ Shaanxi";
$areanames{en}->{861316570} = "Yulin\,\ Shaanxi";
$areanames{en}->{861316576} = "Ankang\,\ Shaanxi";
$areanames{en}->{861316577} = "Shangluo\,\ Shaanxi";
$areanames{en}->{86131658} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861316580} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861316581} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861316582} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861316590} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316591} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316592} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316593} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316594} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861316595} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861316596} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861316597} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861316598} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861316599} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86131660} = "Shanghai";
$areanames{en}->{86131661} = "Shanghai";
$areanames{en}->{86131662} = "Shanghai";
$areanames{en}->{86131663} = "Shanghai";
$areanames{en}->{86131664} = "Shanghai";
$areanames{en}->{861316650} = "Chengde\,\ Hebei";
$areanames{en}->{861316651} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861316652} = "Langfang\,\ Hebei";
$areanames{en}->{861316653} = "Langfang\,\ Hebei";
$areanames{en}->{861316654} = "Tangshan\,\ Hebei";
$areanames{en}->{861316655} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861316656} = "Cangzhou\,\ Hebei";
$areanames{en}->{861316657} = "Hengshui\,\ Hebei";
$areanames{en}->{861316658} = "Tangshan\,\ Hebei";
$areanames{en}->{861316659} = "Xingtai\,\ Hebei";
$areanames{en}->{86131666} = "Shenyang\,\ Liaoning";
$areanames{en}->{86131667} = "Shenyang\,\ Liaoning";
$areanames{en}->{86131668} = "Changchun\,\ Jilin";
$areanames{en}->{86131669} = "Jilin\,\ Jilin";
$areanames{en}->{86131670} = "Shanghai";
$areanames{en}->{86131671} = "Shanghai";
$areanames{en}->{86131672} = "Shanghai";
$areanames{en}->{86131673} = "Beijing";
$areanames{en}->{861316740} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861316741} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861316742} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861316743} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861316744} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861316745} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316746} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316747} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316748} = "Nantong\,\ Jiangsu";
$areanames{en}->{861316749} = "Nantong\,\ Jiangsu";
$areanames{en}->{86131675} = "Beijing";
$areanames{en}->{861316760} = "Chizhou\,\ Anhui";
$areanames{en}->{861316761} = "Tongling\,\ Anhui";
$areanames{en}->{861316762} = "Chuzhou\,\ Anhui";
$areanames{en}->{861316763} = "Wuhu\,\ Anhui";
$areanames{en}->{861316764} = "Huangshan\,\ Anhui";
$areanames{en}->{861316765} = "Fuyang\,\ Anhui";
$areanames{en}->{861316766} = "Fuyang\,\ Anhui";
$areanames{en}->{861316767} = "Bozhou\,\ Anhui";
$areanames{en}->{861316768} = "Bozhou\,\ Anhui";
$areanames{en}->{861316769} = "LuAn\,\ Anhui";
$areanames{en}->{861316770} = "Anqing\,\ Anhui";
$areanames{en}->{861316771} = "Anqing\,\ Anhui";
$areanames{en}->{861316772} = "Hefei\,\ Anhui";
$areanames{en}->{861316773} = "Hefei\,\ Anhui";
$areanames{en}->{861316774} = "Hefei\,\ Anhui";
$areanames{en}->{861316775} = "Xuancheng\,\ Anhui";
$areanames{en}->{861316776} = "Xuancheng\,\ Anhui";
$areanames{en}->{861316777} = "Suzhou\,\ Anhui";
$areanames{en}->{861316778} = "LuAn\,\ Anhui";
$areanames{en}->{861316779} = "LuAn\,\ Anhui";
$areanames{en}->{86131678} = "Chongqing";
$areanames{en}->{86131679} = "Chongqing";
$areanames{en}->{86131680} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316810} = "Meizhou\,\ Guangdong";
$areanames{en}->{861316811} = "Meizhou\,\ Guangdong";
$areanames{en}->{861316812} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861316813} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861316814} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861316815} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861316816} = "Yunfu\,\ Guangdong";
$areanames{en}->{861316817} = "Yunfu\,\ Guangdong";
$areanames{en}->{861316818} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316819} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316820} = "Shanwei\,\ Guangdong";
$areanames{en}->{861316821} = "Shanwei\,\ Guangdong";
$areanames{en}->{861316822} = "Shanwei\,\ Guangdong";
$areanames{en}->{861316823} = "Shanwei\,\ Guangdong";
$areanames{en}->{861316824} = "Shantou\,\ Guangdong";
$areanames{en}->{861316825} = "Shantou\,\ Guangdong";
$areanames{en}->{861316826} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316827} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316828} = "Heyuan\,\ Guangdong";
$areanames{en}->{861316829} = "Heyuan\,\ Guangdong";
$areanames{en}->{86131683} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131684} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131685} = "Foshan\,\ Guangdong";
$areanames{en}->{861316850} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316851} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316852} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316860} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316861} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316862} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316863} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316864} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316865} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861316866} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861316867} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861316868} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861316869} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86131687} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86131688} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131689} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131690} = "Shantou\,\ Guangdong";
$areanames{en}->{861316904} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316905} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316906} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861316910} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861316911} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861316912} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861316913} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861316914} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316915} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861316916} = "Maoming\,\ Guangdong";
$areanames{en}->{861316917} = "Maoming\,\ Guangdong";
$areanames{en}->{861316918} = "Maoming\,\ Guangdong";
$areanames{en}->{861316919} = "Maoming\,\ Guangdong";
$areanames{en}->{861316920} = "Meizhou\,\ Guangdong";
$areanames{en}->{861316921} = "Meizhou\,\ Guangdong";
$areanames{en}->{861316922} = "Meizhou\,\ Guangdong";
$areanames{en}->{861316923} = "Meizhou\,\ Guangdong";
$areanames{en}->{861316924} = "Meizhou\,\ Guangdong";
$areanames{en}->{861316925} = "Jieyang\,\ Guangdong";
$areanames{en}->{861316926} = "Jieyang\,\ Guangdong";
$areanames{en}->{861316927} = "Jieyang\,\ Guangdong";
$areanames{en}->{861316928} = "Jieyang\,\ Guangdong";
$areanames{en}->{861316929} = "Jieyang\,\ Guangdong";
$areanames{en}->{861316930} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316931} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316932} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316933} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316934} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861316935} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861316936} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861316937} = "Yunfu\,\ Guangdong";
$areanames{en}->{861316938} = "Yunfu\,\ Guangdong";
$areanames{en}->{861316939} = "Yunfu\,\ Guangdong";
$areanames{en}->{861316940} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861316941} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861316942} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861316943} = "Baoding\,\ Hebei";
$areanames{en}->{861316944} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316945} = "Heyuan\,\ Guangdong";
$areanames{en}->{861316946} = "Heyuan\,\ Guangdong";
$areanames{en}->{861316947} = "Shanwei\,\ Guangdong";
$areanames{en}->{861316948} = "Shanwei\,\ Guangdong";
$areanames{en}->{861316949} = "Shanwei\,\ Guangdong";
$areanames{en}->{861316950} = "Dongguan\,\ Guangdong";
$areanames{en}->{861316951} = "Dongguan\,\ Guangdong";
$areanames{en}->{861316952} = "Dongguan\,\ Guangdong";
$areanames{en}->{861316953} = "Dongguan\,\ Guangdong";
$areanames{en}->{861316954} = "Dongguan\,\ Guangdong";
$areanames{en}->{861316955} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316956} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316957} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316958} = "Huizhou\,\ Guangdong";
$areanames{en}->{861316959} = "Huizhou\,\ Guangdong";
$areanames{en}->{86131696} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861316970} = "Foshan\,\ Guangdong";
$areanames{en}->{861316971} = "Foshan\,\ Guangdong";
$areanames{en}->{861316972} = "Foshan\,\ Guangdong";
$areanames{en}->{861316973} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316974} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316975} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861316976} = "Maoming\,\ Guangdong";
$areanames{en}->{861316977} = "Maoming\,\ Guangdong";
$areanames{en}->{861316978} = "Maoming\,\ Guangdong";
$areanames{en}->{861316979} = "Maoming\,\ Guangdong";
$areanames{en}->{861316980} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316981} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316982} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316983} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316984} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861316985} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316986} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316987} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316988} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316989} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861316990} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316991} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316992} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316993} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316994} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861316995} = "Foshan\,\ Guangdong";
$areanames{en}->{861316996} = "Foshan\,\ Guangdong";
$areanames{en}->{861316997} = "Foshan\,\ Guangdong";
$areanames{en}->{861316998} = "Foshan\,\ Guangdong";
$areanames{en}->{861316999} = "Foshan\,\ Guangdong";
$areanames{en}->{861317000} = "Chuzhou\,\ Anhui";
$areanames{en}->{861317001} = "Hefei\,\ Anhui";
$areanames{en}->{861317002} = "Bengbu\,\ Anhui";
$areanames{en}->{861317003} = "Wuhu\,\ Anhui";
$areanames{en}->{861317004} = "Fuyang\,\ Anhui";
$areanames{en}->{861317005} = "MaAnshan\,\ Anhui";
$areanames{en}->{861317006} = "Anqing\,\ Anhui";
$areanames{en}->{861317007} = "Suzhou\,\ Anhui";
$areanames{en}->{861317008} = "Fuyang\,\ Anhui";
$areanames{en}->{861317009} = "Huangshan\,\ Anhui";
$areanames{en}->{861317010} = "Bozhou\,\ Anhui";
$areanames{en}->{861317011} = "Huaibei\,\ Anhui";
$areanames{en}->{861317012} = "Tongling\,\ Anhui";
$areanames{en}->{861317013} = "Xuancheng\,\ Anhui";
$areanames{en}->{861317014} = "LuAn\,\ Anhui";
$areanames{en}->{861317015} = "Hefei\,\ Anhui";
$areanames{en}->{861317016} = "Chizhou\,\ Anhui";
$areanames{en}->{861317017} = "Bozhou\,\ Anhui";
$areanames{en}->{861317018} = "LuAn\,\ Anhui";
$areanames{en}->{861317019} = "LuAn\,\ Anhui";
$areanames{en}->{861317020} = "Huainan\,\ Anhui";
$areanames{en}->{861317021} = "Suzhou\,\ Anhui";
$areanames{en}->{861317022} = "Bengbu\,\ Anhui";
$areanames{en}->{861317023} = "Wuhu\,\ Anhui";
$areanames{en}->{861317024} = "Anqing\,\ Anhui";
$areanames{en}->{861317025} = "Hefei\,\ Anhui";
$areanames{en}->{861317026} = "Xuancheng\,\ Anhui";
$areanames{en}->{861317027} = "Hefei\,\ Anhui";
$areanames{en}->{861317028} = "Anqing\,\ Anhui";
$areanames{en}->{861317029} = "Huangshan\,\ Anhui";
$areanames{en}->{861317030} = "Changsha\,\ Hunan";
$areanames{en}->{861317031} = "Changsha\,\ Hunan";
$areanames{en}->{861317032} = "Xiangtan\,\ Hunan";
$areanames{en}->{861317033} = "Hengyang\,\ Hunan";
$areanames{en}->{861317034} = "Hengyang\,\ Hunan";
$areanames{en}->{861317035} = "Chenzhou\,\ Hunan";
$areanames{en}->{861317036} = "Chenzhou\,\ Hunan";
$areanames{en}->{861317037} = "Yiyang\,\ Hunan";
$areanames{en}->{861317038} = "Loudi\,\ Hunan";
$areanames{en}->{861317039} = "Shaoyang\,\ Hunan";
$areanames{en}->{861317040} = "Changsha\,\ Hunan";
$areanames{en}->{861317041} = "Changsha\,\ Hunan";
$areanames{en}->{861317042} = "Xiangtan\,\ Hunan";
$areanames{en}->{861317043} = "Xiangxi\,\ Hunan";
$areanames{en}->{861317044} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861317045} = "Huaihua\,\ Hunan";
$areanames{en}->{861317046} = "Yongzhou\,\ Hunan";
$areanames{en}->{861317047} = "Changsha\,\ Hunan";
$areanames{en}->{861317048} = "Changsha\,\ Hunan";
$areanames{en}->{861317049} = "Shaoyang\,\ Hunan";
$areanames{en}->{861317050} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861317051} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861317052} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861317053} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861317054} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861317055} = "Lincang\,\ Yunnan";
$areanames{en}->{861317056} = "Nujiang\,\ Yunnan";
$areanames{en}->{861317057} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861317058} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861317059} = "Wenshan\,\ Yunnan";
$areanames{en}->{861317060} = "Kunming\,\ Yunnan";
$areanames{en}->{861317061} = "Kunming\,\ Yunnan";
$areanames{en}->{861317062} = "Kunming\,\ Yunnan";
$areanames{en}->{861317063} = "Kunming\,\ Yunnan";
$areanames{en}->{861317064} = "Yuxi\,\ Yunnan";
$areanames{en}->{861317065} = "Yuxi\,\ Yunnan";
$areanames{en}->{861317066} = "Yuxi\,\ Yunnan";
$areanames{en}->{861317067} = "Honghe\,\ Yunnan";
$areanames{en}->{861317068} = "Honghe\,\ Yunnan";
$areanames{en}->{861317069} = "Dehong\,\ Yunnan";
$areanames{en}->{861317070} = "Qujing\,\ Yunnan";
$areanames{en}->{861317071} = "Qujing\,\ Yunnan";
$areanames{en}->{861317072} = "Qujing\,\ Yunnan";
$areanames{en}->{861317073} = "Baoshan\,\ Yunnan";
$areanames{en}->{861317074} = "Puer\,\ Yunnan";
$areanames{en}->{861317075} = "Dali\,\ Yunnan";
$areanames{en}->{861317076} = "Dali\,\ Yunnan";
$areanames{en}->{861317077} = "Lijiang\,\ Yunnan";
$areanames{en}->{861317078} = "Lijiang\,\ Yunnan";
$areanames{en}->{861317079} = "Deqen\,\ Yunnan";
$areanames{en}->{861317080} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861317081} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861317082} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861317083} = "Yichun\,\ Jiangxi";
$areanames{en}->{861317084} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861317085} = "Yichun\,\ Jiangxi";
$areanames{en}->{861317086} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317087} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317088} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317089} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861317090} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861317091} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317092} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861317093} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861317094} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861317095} = "Yichun\,\ Jiangxi";
$areanames{en}->{861317096} = "JiAn\,\ Jiangxi";
$areanames{en}->{861317097} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861317098} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861317099} = "Shangrao\,\ Jiangxi";
$areanames{en}->{86131710} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{86131711} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861317110} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861317111} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861317112} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861317113} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{86131712} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861317130} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861317131} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861317132} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861317133} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861317134} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861317135} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861317136} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861317137} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861317138} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861317139} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{86131714} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861317140} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861317141} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861317142} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861317149} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861317150} = "Tangshan\,\ Hebei";
$areanames{en}->{861317151} = "Tangshan\,\ Hebei";
$areanames{en}->{861317152} = "Tangshan\,\ Hebei";
$areanames{en}->{861317153} = "Handan\,\ Hebei";
$areanames{en}->{861317154} = "Handan\,\ Hebei";
$areanames{en}->{861317155} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317156} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317157} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317158} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317159} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317160} = "Chengde\,\ Hebei";
$areanames{en}->{861317161} = "Chengde\,\ Hebei";
$areanames{en}->{861317162} = "Chengde\,\ Hebei";
$areanames{en}->{861317163} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861317164} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861317165} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861317166} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861317167} = "Baoding\,\ Hebei";
$areanames{en}->{861317168} = "Baoding\,\ Hebei";
$areanames{en}->{861317169} = "Baoding\,\ Hebei";
$areanames{en}->{861317170} = "Cangzhou\,\ Hebei";
$areanames{en}->{861317171} = "Hengshui\,\ Hebei";
$areanames{en}->{861317172} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861317173} = "Langfang\,\ Hebei";
$areanames{en}->{861317174} = "Hengshui\,\ Hebei";
$areanames{en}->{861317175} = "Xingtai\,\ Hebei";
$areanames{en}->{861317176} = "Hengshui\,\ Hebei";
$areanames{en}->{861317177} = "Handan\,\ Hebei";
$areanames{en}->{861317178} = "Handan\,\ Hebei";
$areanames{en}->{861317179} = "Handan\,\ Hebei";
$areanames{en}->{861317180} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317181} = "Tangshan\,\ Hebei";
$areanames{en}->{861317182} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861317183} = "Langfang\,\ Hebei";
$areanames{en}->{861317184} = "Tangshan\,\ Hebei";
$areanames{en}->{861317185} = "Xingtai\,\ Hebei";
$areanames{en}->{861317186} = "Handan\,\ Hebei";
$areanames{en}->{861317187} = "Baoding\,\ Hebei";
$areanames{en}->{861317188} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317189} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861317190} = "Baoding\,\ Hebei";
$areanames{en}->{861317191} = "Baoding\,\ Hebei";
$areanames{en}->{861317192} = "Baoding\,\ Hebei";
$areanames{en}->{861317193} = "Langfang\,\ Hebei";
$areanames{en}->{861317194} = "Langfang\,\ Hebei";
$areanames{en}->{861317195} = "Xingtai\,\ Hebei";
$areanames{en}->{861317196} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861317197} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861317198} = "Cangzhou\,\ Hebei";
$areanames{en}->{861317199} = "Cangzhou\,\ Hebei";
$areanames{en}->{86131720} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131721} = "Langfang\,\ Hebei";
$areanames{en}->{861317210} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861317211} = "Dongguan\,\ Guangdong";
$areanames{en}->{861317216} = "Dongguan\,\ Guangdong";
$areanames{en}->{86131722} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86131723} = "Foshan\,\ Guangdong";
$areanames{en}->{86131724} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861317250} = "Shantou\,\ Guangdong";
$areanames{en}->{861317251} = "Shantou\,\ Guangdong";
$areanames{en}->{861317252} = "Shantou\,\ Guangdong";
$areanames{en}->{861317253} = "Shantou\,\ Guangdong";
$areanames{en}->{861317254} = "Shantou\,\ Guangdong";
$areanames{en}->{861317255} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861317256} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861317257} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861317258} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861317259} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861317260} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861317261} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861317262} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861317263} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861317264} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861317265} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861317266} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861317267} = "Xingtai\,\ Hebei";
$areanames{en}->{861317268} = "Xingtai\,\ Hebei";
$areanames{en}->{861317269} = "Xingtai\,\ Hebei";
$areanames{en}->{861317270} = "Huizhou\,\ Guangdong";
$areanames{en}->{861317271} = "Huizhou\,\ Guangdong";
$areanames{en}->{861317272} = "Huizhou\,\ Guangdong";
$areanames{en}->{861317273} = "Huizhou\,\ Guangdong";
$areanames{en}->{861317274} = "Huizhou\,\ Guangdong";
$areanames{en}->{861317275} = "Heyuan\,\ Guangdong";
$areanames{en}->{861317276} = "Heyuan\,\ Guangdong";
$areanames{en}->{861317277} = "Heyuan\,\ Guangdong";
$areanames{en}->{861317278} = "Heyuan\,\ Guangdong";
$areanames{en}->{861317279} = "Heyuan\,\ Guangdong";
$areanames{en}->{861317280} = "Jieyang\,\ Guangdong";
$areanames{en}->{861317281} = "Jieyang\,\ Guangdong";
$areanames{en}->{861317282} = "Jieyang\,\ Guangdong";
$areanames{en}->{861317283} = "Jieyang\,\ Guangdong";
$areanames{en}->{861317284} = "Jieyang\,\ Guangdong";
$areanames{en}->{861317285} = "Shanwei\,\ Guangdong";
$areanames{en}->{861317286} = "Shanwei\,\ Guangdong";
$areanames{en}->{861317287} = "Shanwei\,\ Guangdong";
$areanames{en}->{861317288} = "Shanwei\,\ Guangdong";
$areanames{en}->{861317289} = "Shanwei\,\ Guangdong";
$areanames{en}->{861317290} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317291} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317292} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317293} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317294} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317295} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317296} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317297} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317298} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317299} = "Shaoguan\,\ Guangdong";
$areanames{en}->{86131730} = "Jinan\,\ Shandong";
$areanames{en}->{861317306} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317307} = "Linyi\,\ Shandong";
$areanames{en}->{861317308} = "Linyi\,\ Shandong";
$areanames{en}->{861317309} = "Linyi\,\ Shandong";
$areanames{en}->{86131731} = "Weifang\,\ Shandong";
$areanames{en}->{861317317} = "Jining\,\ Shandong";
$areanames{en}->{861317318} = "Jining\,\ Shandong";
$areanames{en}->{861317319} = "Jining\,\ Shandong";
$areanames{en}->{861317320} = "Qingdao\,\ Shandong";
$areanames{en}->{861317321} = "Qingdao\,\ Shandong";
$areanames{en}->{861317322} = "Qingdao\,\ Shandong";
$areanames{en}->{861317323} = "Qingdao\,\ Shandong";
$areanames{en}->{861317324} = "Qingdao\,\ Shandong";
$areanames{en}->{861317325} = "Liaocheng\,\ Shandong";
$areanames{en}->{861317326} = "Zibo\,\ Shandong";
$areanames{en}->{861317327} = "Zibo\,\ Shandong";
$areanames{en}->{861317328} = "Binzhou\,\ Shandong";
$areanames{en}->{861317329} = "Binzhou\,\ Shandong";
$areanames{en}->{861317330} = "Weihai\,\ Shandong";
$areanames{en}->{861317331} = "Weihai\,\ Shandong";
$areanames{en}->{861317332} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317333} = "Dezhou\,\ Shandong";
$areanames{en}->{861317334} = "Dezhou\,\ Shandong";
$areanames{en}->{861317335} = "Liaocheng\,\ Shandong";
$areanames{en}->{861317336} = "Dongying\,\ Shandong";
$areanames{en}->{861317337} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317338} = "TaiAn\,\ Shandong";
$areanames{en}->{861317339} = "Heze\,\ Shandong";
$areanames{en}->{861317340} = "Weihai\,\ Shandong";
$areanames{en}->{861317341} = "Zibo\,\ Shandong";
$areanames{en}->{861317342} = "Binzhou\,\ Shandong";
$areanames{en}->{861317343} = "Dezhou\,\ Shandong";
$areanames{en}->{861317344} = "Linyi\,\ Shandong";
$areanames{en}->{861317345} = "Jining\,\ Shandong";
$areanames{en}->{861317346} = "Dongying\,\ Shandong";
$areanames{en}->{861317347} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317348} = "TaiAn\,\ Shandong";
$areanames{en}->{861317349} = "Heze\,\ Shandong";
$areanames{en}->{86131735} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86131736} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86131737} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86131738} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86131739} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861317400} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861317401} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861317402} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861317403} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861317404} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317405} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317406} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317407} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861317408} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861317409} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861317410} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317411} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317412} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861317413} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861317414} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861317415} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861317416} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861317417} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861317418} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861317419} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861317420} = "Huaihua\,\ Hunan";
$areanames{en}->{861317421} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861317422} = "Xiangxi\,\ Hunan";
$areanames{en}->{861317423} = "Xiangxi\,\ Hunan";
$areanames{en}->{861317424} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861317425} = "Huaihua\,\ Hunan";
$areanames{en}->{861317426} = "Yongzhou\,\ Hunan";
$areanames{en}->{861317427} = "Yongzhou\,\ Hunan";
$areanames{en}->{861317428} = "Loudi\,\ Hunan";
$areanames{en}->{861317429} = "Shaoyang\,\ Hunan";
$areanames{en}->{86131743} = "Changchun\,\ Jilin";
$areanames{en}->{861317432} = "Jilin\,\ Jilin";
$areanames{en}->{86131744} = "Changchun\,\ Jilin";
$areanames{en}->{861317450} = "Fuzhou\,\ Fujian";
$areanames{en}->{861317451} = "Fuzhou\,\ Fujian";
$areanames{en}->{861317452} = "Fuzhou\,\ Fujian";
$areanames{en}->{861317453} = "Fuzhou\,\ Fujian";
$areanames{en}->{861317454} = "Putian\,\ Fujian";
$areanames{en}->{861317455} = "Putian\,\ Fujian";
$areanames{en}->{861317456} = "Putian\,\ Fujian";
$areanames{en}->{861317457} = "Ningde\,\ Fujian";
$areanames{en}->{861317458} = "Longyan\,\ Fujian";
$areanames{en}->{861317459} = "Longyan\,\ Fujian";
$areanames{en}->{86131746} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861317463} = "Ningde\,\ Fujian";
$areanames{en}->{861317464} = "Xinyang\,\ Henan";
$areanames{en}->{861317465} = "Putian\,\ Fujian";
$areanames{en}->{861317469} = "Nanping\,\ Fujian";
$areanames{en}->{861317470} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317471} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317472} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317473} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317474} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317475} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317476} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317477} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317478} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317479} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86131748} = "Tianjin";
$areanames{en}->{86131749} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86131750} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861317510} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861317511} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861317512} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861317513} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861317514} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861317515} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861317516} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861317517} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861317518} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861317519} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861317520} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861317521} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861317522} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861317523} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861317524} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861317525} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861317526} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861317527} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861317528} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861317529} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86131753} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317540} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317541} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317542} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317543} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317544} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317545} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317546} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317547} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317548} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317549} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317550} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317551} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317552} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317553} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317554} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861317555} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317556} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317557} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317558} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861317559} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{86131756} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861317570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861317571} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861317572} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861317573} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861317574} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861317575} = "Lishui\,\ Zhejiang";
$areanames{en}->{861317576} = "Lishui\,\ Zhejiang";
$areanames{en}->{861317577} = "Lishui\,\ Zhejiang";
$areanames{en}->{861317578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861317579} = "Lishui\,\ Zhejiang";
$areanames{en}->{861317580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861317581} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861317582} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861317583} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861317584} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861317585} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317587} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317588} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861317589} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86131759} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861317600} = "Jinan\,\ Shandong";
$areanames{en}->{861317601} = "Jinan\,\ Shandong";
$areanames{en}->{861317602} = "Jinan\,\ Shandong";
$areanames{en}->{861317603} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317604} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317605} = "Heze\,\ Shandong";
$areanames{en}->{861317606} = "Weifang\,\ Shandong";
$areanames{en}->{861317607} = "Linyi\,\ Shandong";
$areanames{en}->{861317608} = "Linyi\,\ Shandong";
$areanames{en}->{861317609} = "Linyi\,\ Shandong";
$areanames{en}->{861317610} = "Heze\,\ Shandong";
$areanames{en}->{861317611} = "Heze\,\ Shandong";
$areanames{en}->{861317612} = "TaiAn\,\ Shandong";
$areanames{en}->{861317613} = "TaiAn\,\ Shandong";
$areanames{en}->{861317614} = "Dezhou\,\ Shandong";
$areanames{en}->{861317615} = "Liaocheng\,\ Shandong";
$areanames{en}->{861317616} = "Liaocheng\,\ Shandong";
$areanames{en}->{861317617} = "Jining\,\ Shandong";
$areanames{en}->{861317618} = "Jining\,\ Shandong";
$areanames{en}->{861317619} = "Jining\,\ Shandong";
$areanames{en}->{861317620} = "Heze\,\ Shandong";
$areanames{en}->{861317621} = "Heze\,\ Shandong";
$areanames{en}->{861317622} = "Zibo\,\ Shandong";
$areanames{en}->{861317623} = "Rizhao\,\ Shandong";
$areanames{en}->{861317624} = "Weihai\,\ Shandong";
$areanames{en}->{861317625} = "Liaocheng\,\ Shandong";
$areanames{en}->{861317626} = "Dezhou\,\ Shandong";
$areanames{en}->{861317627} = "Dezhou\,\ Shandong";
$areanames{en}->{861317628} = "Binzhou\,\ Shandong";
$areanames{en}->{861317629} = "Binzhou\,\ Shandong";
$areanames{en}->{861317630} = "Weihai\,\ Shandong";
$areanames{en}->{861317631} = "Weihai\,\ Shandong";
$areanames{en}->{861317632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317633} = "Rizhao\,\ Shandong";
$areanames{en}->{861317634} = "Laiwu\,\ Shandong";
$areanames{en}->{861317635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861317636} = "Weifang\,\ Shandong";
$areanames{en}->{861317637} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861317638} = "Yantai\,\ Shandong";
$areanames{en}->{861317639} = "Qingdao\,\ Shandong";
$areanames{en}->{861317640} = "Jinan\,\ Shandong";
$areanames{en}->{861317641} = "Jinan\,\ Shandong";
$areanames{en}->{861317642} = "Binzhou\,\ Shandong";
$areanames{en}->{861317643} = "Zibo\,\ Shandong";
$areanames{en}->{861317644} = "Jinan\,\ Shandong";
$areanames{en}->{861317645} = "Yantai\,\ Shandong";
$areanames{en}->{861317646} = "Weifang\,\ Shandong";
$areanames{en}->{861317647} = "Dongying\,\ Shandong";
$areanames{en}->{861317648} = "Qingdao\,\ Shandong";
$areanames{en}->{861317649} = "Binzhou\,\ Shandong";
$areanames{en}->{861317650} = "Qingdao\,\ Shandong";
$areanames{en}->{861317651} = "Qingdao\,\ Shandong";
$areanames{en}->{861317652} = "Qingdao\,\ Shandong";
$areanames{en}->{861317653} = "Qingdao\,\ Shandong";
$areanames{en}->{861317654} = "TaiAn\,\ Shandong";
$areanames{en}->{861317655} = "Zibo\,\ Shandong";
$areanames{en}->{861317656} = "Zibo\,\ Shandong";
$areanames{en}->{861317657} = "Zibo\,\ Shandong";
$areanames{en}->{861317658} = "Zibo\,\ Shandong";
$areanames{en}->{861317659} = "Zibo\,\ Shandong";
$areanames{en}->{861317660} = "Dongying\,\ Shandong";
$areanames{en}->{861317661} = "Dongying\,\ Shandong";
$areanames{en}->{861317662} = "Dongying\,\ Shandong";
$areanames{en}->{861317663} = "Dongying\,\ Shandong";
$areanames{en}->{861317664} = "Dongying\,\ Shandong";
$areanames{en}->{861317665} = "Jinan\,\ Shandong";
$areanames{en}->{861317666} = "Jinan\,\ Shandong";
$areanames{en}->{861317667} = "Jinan\,\ Shandong";
$areanames{en}->{861317668} = "Jinan\,\ Shandong";
$areanames{en}->{861317669} = "Jinan\,\ Shandong";
$areanames{en}->{861317670} = "Weifang\,\ Shandong";
$areanames{en}->{861317671} = "Weifang\,\ Shandong";
$areanames{en}->{861317672} = "Weifang\,\ Shandong";
$areanames{en}->{861317673} = "Weifang\,\ Shandong";
$areanames{en}->{861317674} = "Weifang\,\ Shandong";
$areanames{en}->{861317675} = "Jining\,\ Shandong";
$areanames{en}->{861317676} = "Jining\,\ Shandong";
$areanames{en}->{861317677} = "Jining\,\ Shandong";
$areanames{en}->{861317678} = "Jining\,\ Shandong";
$areanames{en}->{861317679} = "Jining\,\ Shandong";
$areanames{en}->{861317680} = "Weihai\,\ Shandong";
$areanames{en}->{861317681} = "Weihai\,\ Shandong";
$areanames{en}->{861317682} = "TaiAn\,\ Shandong";
$areanames{en}->{861317683} = "TaiAn\,\ Shandong";
$areanames{en}->{861317684} = "Dezhou\,\ Shandong";
$areanames{en}->{861317685} = "Qingdao\,\ Shandong";
$areanames{en}->{861317686} = "Qingdao\,\ Shandong";
$areanames{en}->{861317687} = "Qingdao\,\ Shandong";
$areanames{en}->{861317688} = "Qingdao\,\ Shandong";
$areanames{en}->{861317689} = "Qingdao\,\ Shandong";
$areanames{en}->{861317690} = "Yantai\,\ Shandong";
$areanames{en}->{861317691} = "Yantai\,\ Shandong";
$areanames{en}->{861317692} = "Yantai\,\ Shandong";
$areanames{en}->{861317693} = "Yantai\,\ Shandong";
$areanames{en}->{861317694} = "Yantai\,\ Shandong";
$areanames{en}->{861317695} = "Liaocheng\,\ Shandong";
$areanames{en}->{861317696} = "Linyi\,\ Shandong";
$areanames{en}->{861317697} = "Linyi\,\ Shandong";
$areanames{en}->{861317698} = "Linyi\,\ Shandong";
$areanames{en}->{861317699} = "Linyi\,\ Shandong";
$areanames{en}->{861317700} = "Jingzhou\,\ Hubei";
$areanames{en}->{861317701} = "Jingzhou\,\ Hubei";
$areanames{en}->{861317702} = "Jingzhou\,\ Hubei";
$areanames{en}->{861317703} = "Jingzhou\,\ Hubei";
$areanames{en}->{861317704} = "Jingzhou\,\ Hubei";
$areanames{en}->{861317705} = "Yichang\,\ Hubei";
$areanames{en}->{861317706} = "Yichang\,\ Hubei";
$areanames{en}->{861317707} = "Yichang\,\ Hubei";
$areanames{en}->{861317708} = "Yichang\,\ Hubei";
$areanames{en}->{861317709} = "Yichang\,\ Hubei";
$areanames{en}->{861317710} = "Enshi\,\ Hubei";
$areanames{en}->{861317711} = "Enshi\,\ Hubei";
$areanames{en}->{861317712} = "Enshi\,\ Hubei";
$areanames{en}->{861317713} = "Enshi\,\ Hubei";
$areanames{en}->{861317714} = "Jingmen\,\ Hubei";
$areanames{en}->{861317715} = "Jingmen\,\ Hubei";
$areanames{en}->{861317716} = "Jingmen\,\ Hubei";
$areanames{en}->{861317717} = "Jingmen\,\ Hubei";
$areanames{en}->{861317718} = "Suizhou\,\ Hubei";
$areanames{en}->{861317719} = "Suizhou\,\ Hubei";
$areanames{en}->{861317720} = "Xiangfan\,\ Hubei";
$areanames{en}->{861317721} = "Xiangfan\,\ Hubei";
$areanames{en}->{861317722} = "Xiangfan\,\ Hubei";
$areanames{en}->{861317723} = "Xiangfan\,\ Hubei";
$areanames{en}->{861317724} = "Xiangfan\,\ Hubei";
$areanames{en}->{861317725} = "Xiaogan\,\ Hubei";
$areanames{en}->{861317726} = "Xiaogan\,\ Hubei";
$areanames{en}->{861317727} = "Xiaogan\,\ Hubei";
$areanames{en}->{861317728} = "Xiaogan\,\ Hubei";
$areanames{en}->{861317729} = "Xiaogan\,\ Hubei";
$areanames{en}->{861317730} = "Huangshi\,\ Hubei";
$areanames{en}->{861317731} = "Huangshi\,\ Hubei";
$areanames{en}->{861317732} = "Huangshi\,\ Hubei";
$areanames{en}->{861317733} = "Huangshi\,\ Hubei";
$areanames{en}->{861317734} = "Huanggang\,\ Hubei";
$areanames{en}->{861317735} = "Huanggang\,\ Hubei";
$areanames{en}->{861317736} = "Huanggang\,\ Hubei";
$areanames{en}->{861317737} = "Ezhou\,\ Hubei";
$areanames{en}->{861317738} = "Ezhou\,\ Hubei";
$areanames{en}->{861317739} = "Ezhou\,\ Hubei";
$areanames{en}->{861317740} = "Xianning\,\ Hubei";
$areanames{en}->{861317741} = "Xianning\,\ Hubei";
$areanames{en}->{861317742} = "Xianning\,\ Hubei";
$areanames{en}->{861317743} = "Xianning\,\ Hubei";
$areanames{en}->{861317744} = "Xianning\,\ Hubei";
$areanames{en}->{861317745} = "Shiyan\,\ Hubei";
$areanames{en}->{861317746} = "Shiyan\,\ Hubei";
$areanames{en}->{861317747} = "Shiyan\,\ Hubei";
$areanames{en}->{861317748} = "Shiyan\,\ Hubei";
$areanames{en}->{861317749} = "Wuhan\,\ Hubei";
$areanames{en}->{861317750} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861317751} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861317752} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861317753} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861317754} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861317755} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861317756} = "Yichun\,\ Jiangxi";
$areanames{en}->{861317757} = "Yichun\,\ Jiangxi";
$areanames{en}->{861317758} = "Yichun\,\ Jiangxi";
$areanames{en}->{861317759} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861317760} = "JiAn\,\ Jiangxi";
$areanames{en}->{861317761} = "JiAn\,\ Jiangxi";
$areanames{en}->{861317762} = "JiAn\,\ Jiangxi";
$areanames{en}->{861317763} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861317764} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861317765} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861317766} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861317767} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861317768} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861317769} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861317770} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861317771} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861317772} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861317773} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861317774} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861317775} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861317776} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861317777} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317778} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317779} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{86131778} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861317791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861317792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861317793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861317794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861317795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861317796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861317797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861317798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861317799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861317800} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861317801} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317802} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861317803} = "Fuzhou\,\ Fujian";
$areanames{en}->{861317804} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317805} = "Putian\,\ Fujian";
$areanames{en}->{861317806} = "Putian\,\ Fujian";
$areanames{en}->{861317807} = "Sanming\,\ Fujian";
$areanames{en}->{861317808} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317809} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317810} = "Ningde\,\ Fujian";
$areanames{en}->{861317811} = "Fuzhou\,\ Fujian";
$areanames{en}->{861317812} = "Ningde\,\ Fujian";
$areanames{en}->{861317813} = "Putian\,\ Fujian";
$areanames{en}->{861317814} = "Ningde\,\ Fujian";
$areanames{en}->{861317815} = "Longyan\,\ Fujian";
$areanames{en}->{861317816} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861317817} = "Nanping\,\ Fujian";
$areanames{en}->{861317818} = "Longyan\,\ Fujian";
$areanames{en}->{861317819} = "Putian\,\ Fujian";
$areanames{en}->{861317820} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317821} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317822} = "Longyan\,\ Fujian";
$areanames{en}->{861317823} = "Putian\,\ Fujian";
$areanames{en}->{861317824} = "Putian\,\ Fujian";
$areanames{en}->{861317825} = "Xiamen\,\ Fujian";
$areanames{en}->{861317826} = "Longyan\,\ Fujian";
$areanames{en}->{861317827} = "Xiamen\,\ Fujian";
$areanames{en}->{861317828} = "Ningde\,\ Fujian";
$areanames{en}->{861317829} = "Sanming\,\ Fujian";
$areanames{en}->{861317830} = "Ningde\,\ Fujian";
$areanames{en}->{861317831} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861317832} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317833} = "Nanping\,\ Fujian";
$areanames{en}->{861317834} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861317835} = "Xiamen\,\ Fujian";
$areanames{en}->{861317836} = "Quanzhou\,\ Fujian";
$areanames{en}->{861317837} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861317838} = "Fuzhou\,\ Fujian";
$areanames{en}->{861317839} = "Longyan\,\ Fujian";
$areanames{en}->{861317840} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317841} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317842} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317843} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317844} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861317845} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317846} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317847} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317848} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317849} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861317850} = "Foshan\,\ Guangdong";
$areanames{en}->{861317851} = "Foshan\,\ Guangdong";
$areanames{en}->{861317852} = "Foshan\,\ Guangdong";
$areanames{en}->{861317853} = "Foshan\,\ Guangdong";
$areanames{en}->{861317854} = "Foshan\,\ Guangdong";
$areanames{en}->{861317855} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861317856} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861317857} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861317858} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861317859} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86131786} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861317870} = "Meizhou\,\ Guangdong";
$areanames{en}->{861317871} = "Meizhou\,\ Guangdong";
$areanames{en}->{861317872} = "Meizhou\,\ Guangdong";
$areanames{en}->{861317873} = "Meizhou\,\ Guangdong";
$areanames{en}->{861317874} = "Meizhou\,\ Guangdong";
$areanames{en}->{861317875} = "Shantou\,\ Guangdong";
$areanames{en}->{861317876} = "Shantou\,\ Guangdong";
$areanames{en}->{861317877} = "Shantou\,\ Guangdong";
$areanames{en}->{861317878} = "Shantou\,\ Guangdong";
$areanames{en}->{861317879} = "Shantou\,\ Guangdong";
$areanames{en}->{86131788} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131789} = "Haikou\,\ Hainan";
$areanames{en}->{861317900} = "Changchun\,\ Jilin";
$areanames{en}->{861317901} = "Changchun\,\ Jilin";
$areanames{en}->{861317902} = "Siping\,\ Jilin";
$areanames{en}->{861317903} = "Siping\,\ Jilin";
$areanames{en}->{861317904} = "Changchun\,\ Jilin";
$areanames{en}->{861317905} = "Songyuan\,\ Jilin";
$areanames{en}->{861317906} = "Baicheng\,\ Jilin";
$areanames{en}->{861317907} = "Baishan\,\ Jilin";
$areanames{en}->{861317908} = "Yanbian\,\ Jilin";
$areanames{en}->{861317909} = "Yanbian\,\ Jilin";
$areanames{en}->{861317910} = "Changchun\,\ Jilin";
$areanames{en}->{861317911} = "Changchun\,\ Jilin";
$areanames{en}->{861317912} = "Changchun\,\ Jilin";
$areanames{en}->{861317913} = "Changchun\,\ Jilin";
$areanames{en}->{861317914} = "Yanbian\,\ Jilin";
$areanames{en}->{861317915} = "Yanbian\,\ Jilin";
$areanames{en}->{861317916} = "Baicheng\,\ Jilin";
$areanames{en}->{861317917} = "Baishan\,\ Jilin";
$areanames{en}->{861317918} = "Siping\,\ Jilin";
$areanames{en}->{861317919} = "Tonghua\,\ Jilin";
$areanames{en}->{861317920} = "Songyuan\,\ Jilin";
$areanames{en}->{861317921} = "Tonghua\,\ Jilin";
$areanames{en}->{861317922} = "Tonghua\,\ Jilin";
$areanames{en}->{861317923} = "Jilin\,\ Jilin";
$areanames{en}->{861317924} = "Jilin\,\ Jilin";
$areanames{en}->{861317925} = "Jilin\,\ Jilin";
$areanames{en}->{861317926} = "Jilin\,\ Jilin";
$areanames{en}->{861317927} = "Jilin\,\ Jilin";
$areanames{en}->{861317928} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861317929} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861317930} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861317931} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861317932} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861317933} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861317934} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861317935} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861317936} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861317937} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861317938} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861317939} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861317940} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317941} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317942} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861317943} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861317944} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317945} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861317946} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861317947} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861317948} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861317949} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861317950} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861317951} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861317952} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861317953} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861317954} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861317955} = "Suqian\,\ Jiangsu";
$areanames{en}->{861317956} = "Suqian\,\ Jiangsu";
$areanames{en}->{861317957} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861317958} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861317959} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861317960} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317961} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317962} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317963} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317964} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861317965} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317966} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317967} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317968} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317969} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861317970} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861317971} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861317972} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861317973} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861317974} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861317975} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861317976} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861317977} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861317978} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861317979} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861317980} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861317981} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861317982} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861317983} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861317984} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861317985} = "Ili\,\ Xinjiang";
$areanames{en}->{861317986} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861317987} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861317988} = "Aksu\,\ Xinjiang";
$areanames{en}->{861317989} = "Hotan\,\ Xinjiang";
$areanames{en}->{861317990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861317991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861317992} = "Ili\,\ Xinjiang";
$areanames{en}->{861317993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861317994} = "Changji\,\ Xinjiang";
$areanames{en}->{861317995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861317996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861317997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861317998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861317999} = "Ili\,\ Xinjiang";
$areanames{en}->{86131800} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861318000} = "Hengshui\,\ Hebei";
$areanames{en}->{861318001} = "Hengshui\,\ Hebei";
$areanames{en}->{861318002} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861318003} = "Handan\,\ Hebei";
$areanames{en}->{861318010} = "Chengde\,\ Hebei";
$areanames{en}->{861318011} = "Chengde\,\ Hebei";
$areanames{en}->{861318012} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861318013} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861318014} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861318015} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318016} = "Tangshan\,\ Hebei";
$areanames{en}->{861318017} = "Tangshan\,\ Hebei";
$areanames{en}->{861318018} = "Tangshan\,\ Hebei";
$areanames{en}->{861318019} = "Tangshan\,\ Hebei";
$areanames{en}->{86131802} = "Baoding\,\ Hebei";
$areanames{en}->{861318027} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861318028} = "Xingtai\,\ Hebei";
$areanames{en}->{861318029} = "Hengshui\,\ Hebei";
$areanames{en}->{861318030} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318031} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318032} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318033} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318034} = "Langfang\,\ Hebei";
$areanames{en}->{861318035} = "Langfang\,\ Hebei";
$areanames{en}->{861318036} = "Langfang\,\ Hebei";
$areanames{en}->{861318037} = "Langfang\,\ Hebei";
$areanames{en}->{861318038} = "Langfang\,\ Hebei";
$areanames{en}->{861318039} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{86131804} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861318040} = "Tangshan\,\ Hebei";
$areanames{en}->{861318041} = "Tangshan\,\ Hebei";
$areanames{en}->{861318042} = "Tangshan\,\ Hebei";
$areanames{en}->{861318043} = "Baoding\,\ Hebei";
$areanames{en}->{861318050} = "Handan\,\ Hebei";
$areanames{en}->{861318051} = "Handan\,\ Hebei";
$areanames{en}->{861318052} = "Handan\,\ Hebei";
$areanames{en}->{861318053} = "Handan\,\ Hebei";
$areanames{en}->{861318054} = "Xingtai\,\ Hebei";
$areanames{en}->{861318055} = "Xingtai\,\ Hebei";
$areanames{en}->{861318056} = "Xingtai\,\ Hebei";
$areanames{en}->{861318057} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861318058} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861318059} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86131806} = "Tonghua\,\ Jilin";
$areanames{en}->{861318060} = "Baicheng\,\ Jilin";
$areanames{en}->{861318061} = "Baicheng\,\ Jilin";
$areanames{en}->{861318062} = "Baicheng\,\ Jilin";
$areanames{en}->{861318063} = "Siping\,\ Jilin";
$areanames{en}->{861318070} = "Baishan\,\ Jilin";
$areanames{en}->{861318071} = "Baishan\,\ Jilin";
$areanames{en}->{861318072} = "Baishan\,\ Jilin";
$areanames{en}->{861318073} = "Yanbian\,\ Jilin";
$areanames{en}->{861318074} = "Changchun\,\ Jilin";
$areanames{en}->{861318075} = "Jilin\,\ Jilin";
$areanames{en}->{861318076} = "Jilin\,\ Jilin";
$areanames{en}->{861318077} = "Songyuan\,\ Jilin";
$areanames{en}->{861318078} = "Songyuan\,\ Jilin";
$areanames{en}->{861318079} = "Changchun\,\ Jilin";
$areanames{en}->{86131808} = "Changchun\,\ Jilin";
$areanames{en}->{861318090} = "Yanbian\,\ Jilin";
$areanames{en}->{861318091} = "Yanbian\,\ Jilin";
$areanames{en}->{861318092} = "Yanbian\,\ Jilin";
$areanames{en}->{861318093} = "Yanbian\,\ Jilin";
$areanames{en}->{861318094} = "Changchun\,\ Jilin";
$areanames{en}->{861318095} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861318096} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861318097} = "Siping\,\ Jilin";
$areanames{en}->{861318098} = "Siping\,\ Jilin";
$areanames{en}->{861318099} = "Changchun\,\ Jilin";
$areanames{en}->{861318100} = "Binzhou\,\ Shandong";
$areanames{en}->{861318101} = "Binzhou\,\ Shandong";
$areanames{en}->{861318102} = "Binzhou\,\ Shandong";
$areanames{en}->{861318103} = "Binzhou\,\ Shandong";
$areanames{en}->{861318104} = "Binzhou\,\ Shandong";
$areanames{en}->{861318105} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318106} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318107} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318108} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318109} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318110} = "Weihai\,\ Shandong";
$areanames{en}->{861318111} = "Weihai\,\ Shandong";
$areanames{en}->{861318112} = "Weihai\,\ Shandong";
$areanames{en}->{861318113} = "Weihai\,\ Shandong";
$areanames{en}->{861318114} = "Weihai\,\ Shandong";
$areanames{en}->{861318115} = "Rizhao\,\ Shandong";
$areanames{en}->{861318116} = "Rizhao\,\ Shandong";
$areanames{en}->{861318117} = "Rizhao\,\ Shandong";
$areanames{en}->{861318118} = "Rizhao\,\ Shandong";
$areanames{en}->{861318119} = "Rizhao\,\ Shandong";
$areanames{en}->{861318120} = "Linyi\,\ Shandong";
$areanames{en}->{861318121} = "Linyi\,\ Shandong";
$areanames{en}->{861318122} = "Linyi\,\ Shandong";
$areanames{en}->{861318123} = "Linyi\,\ Shandong";
$areanames{en}->{861318124} = "Linyi\,\ Shandong";
$areanames{en}->{861318125} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318126} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318127} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318128} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318129} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318130} = "Jining\,\ Shandong";
$areanames{en}->{861318131} = "Jining\,\ Shandong";
$areanames{en}->{861318132} = "Jining\,\ Shandong";
$areanames{en}->{861318133} = "Jining\,\ Shandong";
$areanames{en}->{861318134} = "Jining\,\ Shandong";
$areanames{en}->{861318135} = "Dezhou\,\ Shandong";
$areanames{en}->{861318136} = "Dezhou\,\ Shandong";
$areanames{en}->{861318137} = "Dezhou\,\ Shandong";
$areanames{en}->{861318138} = "Dezhou\,\ Shandong";
$areanames{en}->{861318139} = "Dezhou\,\ Shandong";
$areanames{en}->{861318140} = "Dongying\,\ Shandong";
$areanames{en}->{861318141} = "Dongying\,\ Shandong";
$areanames{en}->{861318142} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318143} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318144} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318145} = "Rizhao\,\ Shandong";
$areanames{en}->{861318146} = "Jining\,\ Shandong";
$areanames{en}->{861318147} = "Jining\,\ Shandong";
$areanames{en}->{861318148} = "Linyi\,\ Shandong";
$areanames{en}->{861318149} = "Linyi\,\ Shandong";
$areanames{en}->{861318150} = "Yantai\,\ Shandong";
$areanames{en}->{861318151} = "Yantai\,\ Shandong";
$areanames{en}->{861318152} = "Yantai\,\ Shandong";
$areanames{en}->{861318153} = "Yantai\,\ Shandong";
$areanames{en}->{861318154} = "Yantai\,\ Shandong";
$areanames{en}->{861318155} = "Heze\,\ Shandong";
$areanames{en}->{861318156} = "Heze\,\ Shandong";
$areanames{en}->{861318157} = "Heze\,\ Shandong";
$areanames{en}->{861318158} = "Heze\,\ Shandong";
$areanames{en}->{861318159} = "Heze\,\ Shandong";
$areanames{en}->{861318160} = "Yantai\,\ Shandong";
$areanames{en}->{861318161} = "Yantai\,\ Shandong";
$areanames{en}->{861318162} = "Yantai\,\ Shandong";
$areanames{en}->{861318163} = "Yantai\,\ Shandong";
$areanames{en}->{861318164} = "Yantai\,\ Shandong";
$areanames{en}->{861318165} = "Weifang\,\ Shandong";
$areanames{en}->{861318166} = "Weifang\,\ Shandong";
$areanames{en}->{861318167} = "Weifang\,\ Shandong";
$areanames{en}->{861318168} = "Weifang\,\ Shandong";
$areanames{en}->{861318169} = "Weifang\,\ Shandong";
$areanames{en}->{861318170} = "Jinan\,\ Shandong";
$areanames{en}->{861318171} = "Jinan\,\ Shandong";
$areanames{en}->{861318172} = "Jinan\,\ Shandong";
$areanames{en}->{861318173} = "Jinan\,\ Shandong";
$areanames{en}->{861318174} = "Jinan\,\ Shandong";
$areanames{en}->{861318175} = "Laiwu\,\ Shandong";
$areanames{en}->{861318176} = "Laiwu\,\ Shandong";
$areanames{en}->{861318177} = "TaiAn\,\ Shandong";
$areanames{en}->{861318178} = "TaiAn\,\ Shandong";
$areanames{en}->{861318179} = "TaiAn\,\ Shandong";
$areanames{en}->{861318180} = "TaiAn\,\ Shandong";
$areanames{en}->{861318181} = "TaiAn\,\ Shandong";
$areanames{en}->{861318182} = "TaiAn\,\ Shandong";
$areanames{en}->{861318183} = "TaiAn\,\ Shandong";
$areanames{en}->{861318184} = "TaiAn\,\ Shandong";
$areanames{en}->{861318185} = "Dongying\,\ Shandong";
$areanames{en}->{861318186} = "Dongying\,\ Shandong";
$areanames{en}->{861318187} = "Weihai\,\ Shandong";
$areanames{en}->{861318188} = "Weihai\,\ Shandong";
$areanames{en}->{861318189} = "Weihai\,\ Shandong";
$areanames{en}->{861318190} = "Zibo\,\ Shandong";
$areanames{en}->{861318191} = "Zibo\,\ Shandong";
$areanames{en}->{861318192} = "Zibo\,\ Shandong";
$areanames{en}->{861318193} = "Zibo\,\ Shandong";
$areanames{en}->{861318194} = "Zibo\,\ Shandong";
$areanames{en}->{861318195} = "Dongying\,\ Shandong";
$areanames{en}->{861318196} = "Dongying\,\ Shandong";
$areanames{en}->{861318197} = "Dongying\,\ Shandong";
$areanames{en}->{861318198} = "Dongying\,\ Shandong";
$areanames{en}->{861318199} = "Dongying\,\ Shandong";
$areanames{en}->{86131820} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861318206} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861318207} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861318208} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861318209} = "Wuxi\,\ Jiangsu";
$areanames{en}->{86131821} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86131822} = "Taizhou\,\ Jiangsu";
$areanames{en}->{86131823} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861318240} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861318241} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861318242} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861318243} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861318244} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861318245} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861318246} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861318247} = "Nantong\,\ Jiangsu";
$areanames{en}->{861318248} = "Nantong\,\ Jiangsu";
$areanames{en}->{861318249} = "Nantong\,\ Jiangsu";
$areanames{en}->{86131825} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86131826} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86131827} = "Wuxi\,\ Jiangsu";
$areanames{en}->{86131828} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86131829} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861318300} = "Zhengzhou\,\ Henan";
$areanames{en}->{861318301} = "Zhengzhou\,\ Henan";
$areanames{en}->{861318302} = "Xuchang\,\ Henan";
$areanames{en}->{861318303} = "Xuchang\,\ Henan";
$areanames{en}->{861318304} = "Shangqiu\,\ Henan";
$areanames{en}->{861318305} = "Luoyang\,\ Henan";
$areanames{en}->{861318306} = "Luoyang\,\ Henan";
$areanames{en}->{861318307} = "Luoyang\,\ Henan";
$areanames{en}->{861318308} = "Luoyang\,\ Henan";
$areanames{en}->{861318309} = "Xinxiang\,\ Henan";
$areanames{en}->{861318310} = "Xinxiang\,\ Henan";
$areanames{en}->{861318311} = "Xinxiang\,\ Henan";
$areanames{en}->{861318312} = "Jiaozuo\,\ Henan";
$areanames{en}->{861318313} = "Jiaozuo\,\ Henan";
$areanames{en}->{861318314} = "Zhumadian\,\ Henan";
$areanames{en}->{861318315} = "Anyang\,\ Henan";
$areanames{en}->{861318316} = "Anyang\,\ Henan";
$areanames{en}->{861318317} = "Puyang\,\ Henan";
$areanames{en}->{861318318} = "Puyang\,\ Henan";
$areanames{en}->{861318319} = "Luohe\,\ Henan";
$areanames{en}->{861318320} = "Luohe\,\ Henan";
$areanames{en}->{861318321} = "Luohe\,\ Henan";
$areanames{en}->{861318322} = "Zhoukou\,\ Henan";
$areanames{en}->{861318323} = "Zhoukou\,\ Henan";
$areanames{en}->{861318324} = "Sanmenxia\,\ Henan";
$areanames{en}->{861318325} = "Kaifeng\,\ Henan";
$areanames{en}->{861318326} = "Kaifeng\,\ Henan";
$areanames{en}->{861318327} = "Kaifeng\,\ Henan";
$areanames{en}->{861318328} = "Kaifeng\,\ Henan";
$areanames{en}->{861318329} = "Shangqiu\,\ Henan";
$areanames{en}->{861318330} = "Nanyang\,\ Henan";
$areanames{en}->{861318331} = "Nanyang\,\ Henan";
$areanames{en}->{861318332} = "Pingdingshan\,\ Henan";
$areanames{en}->{861318333} = "Pingdingshan\,\ Henan";
$areanames{en}->{861318334} = "Pingdingshan\,\ Henan";
$areanames{en}->{861318335} = "Pingdingshan\,\ Henan";
$areanames{en}->{861318336} = "Xinyang\,\ Henan";
$areanames{en}->{861318337} = "Xinyang\,\ Henan";
$areanames{en}->{861318338} = "Zhumadian\,\ Henan";
$areanames{en}->{861318339} = "Sanmenxia\,\ Henan";
$areanames{en}->{861318340} = "Nanchong\,\ Sichuan";
$areanames{en}->{861318341} = "Dazhou\,\ Sichuan";
$areanames{en}->{861318342} = "Deyang\,\ Sichuan";
$areanames{en}->{861318343} = "Mianyang\,\ Sichuan";
$areanames{en}->{861318344} = "Leshan\,\ Sichuan";
$areanames{en}->{861318345} = "Luzhou\,\ Sichuan";
$areanames{en}->{861318346} = "Zigong\,\ Sichuan";
$areanames{en}->{861318347} = "Yibin\,\ Sichuan";
$areanames{en}->{861318348} = "Neijiang\,\ Sichuan";
$areanames{en}->{861318349} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861318350} = "Dazhou\,\ Sichuan";
$areanames{en}->{861318351} = "Dazhou\,\ Sichuan";
$areanames{en}->{861318352} = "Bazhong\,\ Sichuan";
$areanames{en}->{861318353} = "Bazhong\,\ Sichuan";
$areanames{en}->{861318354} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861318355} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861318356} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861318357} = "Suining\,\ Sichuan";
$areanames{en}->{861318358} = "Suining\,\ Sichuan";
$areanames{en}->{861318359} = "Dazhou\,\ Sichuan";
$areanames{en}->{861318360} = "Luzhou\,\ Sichuan";
$areanames{en}->{861318361} = "Luzhou\,\ Sichuan";
$areanames{en}->{861318362} = "Leshan\,\ Sichuan";
$areanames{en}->{861318363} = "Leshan\,\ Sichuan";
$areanames{en}->{861318364} = "Meishan\,\ Sichuan";
$areanames{en}->{861318365} = "Meishan\,\ Sichuan";
$areanames{en}->{861318366} = "Meishan\,\ Sichuan";
$areanames{en}->{861318367} = "Neijiang\,\ Sichuan";
$areanames{en}->{861318368} = "Neijiang\,\ Sichuan";
$areanames{en}->{861318369} = "Neijiang\,\ Sichuan";
$areanames{en}->{861318370} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861318371} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861318372} = "Liangshan\,\ Sichuan";
$areanames{en}->{861318373} = "Liangshan\,\ Sichuan";
$areanames{en}->{861318374} = "YaAn\,\ Sichuan";
$areanames{en}->{861318375} = "Nanchong\,\ Sichuan";
$areanames{en}->{861318376} = "Nanchong\,\ Sichuan";
$areanames{en}->{861318377} = "Mianyang\,\ Sichuan";
$areanames{en}->{861318378} = "Mianyang\,\ Sichuan";
$areanames{en}->{861318379} = "Mianyang\,\ Sichuan";
$areanames{en}->{86131838} = "Chengdu\,\ Sichuan";
$areanames{en}->{861318390} = "GuangAn\,\ Sichuan";
$areanames{en}->{861318391} = "GuangAn\,\ Sichuan";
$areanames{en}->{861318392} = "Zigong\,\ Sichuan";
$areanames{en}->{861318393} = "Zigong\,\ Sichuan";
$areanames{en}->{861318394} = "Ziyang\,\ Sichuan";
$areanames{en}->{861318395} = "Ziyang\,\ Sichuan";
$areanames{en}->{861318396} = "Yibin\,\ Sichuan";
$areanames{en}->{861318397} = "Yibin\,\ Sichuan";
$areanames{en}->{861318398} = "Deyang\,\ Sichuan";
$areanames{en}->{861318399} = "Deyang\,\ Sichuan";
$areanames{en}->{86131840} = "Yantai\,\ Shandong";
$areanames{en}->{861318406} = "Heze\,\ Shandong";
$areanames{en}->{861318407} = "Heze\,\ Shandong";
$areanames{en}->{861318408} = "Heze\,\ Shandong";
$areanames{en}->{861318409} = "Heze\,\ Shandong";
$areanames{en}->{861318410} = "Dezhou\,\ Shandong";
$areanames{en}->{861318411} = "Dezhou\,\ Shandong";
$areanames{en}->{861318412} = "Dezhou\,\ Shandong";
$areanames{en}->{861318413} = "Qingdao\,\ Shandong";
$areanames{en}->{861318414} = "Qingdao\,\ Shandong";
$areanames{en}->{861318415} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318416} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318417} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318418} = "Weihai\,\ Shandong";
$areanames{en}->{861318419} = "Weihai\,\ Shandong";
$areanames{en}->{861318420} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318421} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318422} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318423} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318424} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318425} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318426} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318427} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318428} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318429} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318430} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318431} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318432} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318433} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318434} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318435} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318436} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318437} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318438} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318439} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318440} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861318441} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318442} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861318443} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318444} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318445} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861318446} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318447} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318448} = "Lishui\,\ Zhejiang";
$areanames{en}->{861318449} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861318450} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861318451} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861318452} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861318453} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861318454} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861318455} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861318456} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861318457} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861318458} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861318459} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861318460} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861318461} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861318462} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861318463} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861318464} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861318465} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861318466} = "Yichun\,\ Jiangxi";
$areanames{en}->{861318467} = "Yichun\,\ Jiangxi";
$areanames{en}->{861318468} = "Yichun\,\ Jiangxi";
$areanames{en}->{861318469} = "JiAn\,\ Jiangxi";
$areanames{en}->{861318470} = "Handan\,\ Hebei";
$areanames{en}->{861318471} = "Handan\,\ Hebei";
$areanames{en}->{861318472} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861318473} = "Langfang\,\ Hebei";
$areanames{en}->{861318474} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861318475} = "Xingtai\,\ Hebei";
$areanames{en}->{861318476} = "Hengshui\,\ Hebei";
$areanames{en}->{861318477} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861318478} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318479} = "Tangshan\,\ Hebei";
$areanames{en}->{861318480} = "Jieyang\,\ Guangdong";
$areanames{en}->{861318481} = "Jieyang\,\ Guangdong";
$areanames{en}->{861318482} = "Jieyang\,\ Guangdong";
$areanames{en}->{861318483} = "Jieyang\,\ Guangdong";
$areanames{en}->{861318484} = "Jieyang\,\ Guangdong";
$areanames{en}->{861318485} = "Shanwei\,\ Guangdong";
$areanames{en}->{861318486} = "Shanwei\,\ Guangdong";
$areanames{en}->{861318487} = "Shanwei\,\ Guangdong";
$areanames{en}->{861318488} = "Shanwei\,\ Guangdong";
$areanames{en}->{861318489} = "Shanwei\,\ Guangdong";
$areanames{en}->{861318490} = "Baoding\,\ Hebei";
$areanames{en}->{861318491} = "Tangshan\,\ Hebei";
$areanames{en}->{861318492} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861318493} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318494} = "Baoding\,\ Hebei";
$areanames{en}->{861318495} = "Xingtai\,\ Hebei";
$areanames{en}->{861318496} = "Hengshui\,\ Hebei";
$areanames{en}->{861318497} = "Hengshui\,\ Hebei";
$areanames{en}->{861318498} = "Cangzhou\,\ Hebei";
$areanames{en}->{861318499} = "Tangshan\,\ Hebei";
$areanames{en}->{86131850} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86131851} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86131852} = "Huzhou\,\ Zhejiang";
$areanames{en}->{86131853} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318540} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318541} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318542} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318543} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318544} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318545} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861318546} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861318547} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861318548} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861318549} = "Huzhou\,\ Zhejiang";
$areanames{en}->{86131855} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86131856} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861318571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861318573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861318574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861318576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861318579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86131858} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{86131859} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86131860} = "XiAn\,\ Shaanxi";
$areanames{en}->{86131861} = "XiAn\,\ Shaanxi";
$areanames{en}->{861318620} = "Weinan\,\ Shaanxi";
$areanames{en}->{861318621} = "Weinan\,\ Shaanxi";
$areanames{en}->{861318622} = "Weinan\,\ Shaanxi";
$areanames{en}->{861318623} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861318624} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861318625} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861318626} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861318627} = "Ankang\,\ Shaanxi";
$areanames{en}->{861318628} = "Ankang\,\ Shaanxi";
$areanames{en}->{861318629} = "Ankang\,\ Shaanxi";
$areanames{en}->{86131863} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861318636} = "Baoji\,\ Shaanxi";
$areanames{en}->{861318637} = "Baoji\,\ Shaanxi";
$areanames{en}->{861318638} = "Baoji\,\ Shaanxi";
$areanames{en}->{861318639} = "Baoji\,\ Shaanxi";
$areanames{en}->{861318640} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861318641} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861318642} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861318643} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861318644} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861318645} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861318646} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861318647} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861318648} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861318649} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{86131865} = "Nantong\,\ Jiangsu";
$areanames{en}->{861318660} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861318661} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861318662} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861318663} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861318664} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861318665} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861318666} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861318667} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861318668} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861318669} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861318670} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861318671} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861318672} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861318673} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861318674} = "Lishui\,\ Zhejiang";
$areanames{en}->{861318675} = "Lishui\,\ Zhejiang";
$areanames{en}->{861318676} = "Lishui\,\ Zhejiang";
$areanames{en}->{861318677} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861318678} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861318679} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861318680} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318681} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318682} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318683} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318684} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861318685} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318686} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318687} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318688} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318689} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861318690} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318691} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318692} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318693} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318694} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861318695} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318696} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318697} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318698} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861318699} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86131870} = "Changsha\,\ Hunan";
$areanames{en}->{861318710} = "Yongzhou\,\ Hunan";
$areanames{en}->{861318711} = "Yongzhou\,\ Hunan";
$areanames{en}->{861318712} = "Yongzhou\,\ Hunan";
$areanames{en}->{861318713} = "Yongzhou\,\ Hunan";
$areanames{en}->{861318714} = "Huaihua\,\ Hunan";
$areanames{en}->{861318715} = "Huaihua\,\ Hunan";
$areanames{en}->{861318716} = "Hengyang\,\ Hunan";
$areanames{en}->{861318717} = "Shaoyang\,\ Hunan";
$areanames{en}->{861318718} = "Shaoyang\,\ Hunan";
$areanames{en}->{861318719} = "Shaoyang\,\ Hunan";
$areanames{en}->{861318720} = "Hengyang\,\ Hunan";
$areanames{en}->{861318721} = "Changsha\,\ Hunan";
$areanames{en}->{861318722} = "Xiangtan\,\ Hunan";
$areanames{en}->{861318723} = "Hengyang\,\ Hunan";
$areanames{en}->{861318724} = "Hengyang\,\ Hunan";
$areanames{en}->{861318725} = "Chenzhou\,\ Hunan";
$areanames{en}->{861318726} = "Chenzhou\,\ Hunan";
$areanames{en}->{861318727} = "Chenzhou\,\ Hunan";
$areanames{en}->{861318728} = "Shaoyang\,\ Hunan";
$areanames{en}->{861318729} = "Shaoyang\,\ Hunan";
$areanames{en}->{861318730} = "Hengyang\,\ Hunan";
$areanames{en}->{861318731} = "Changsha\,\ Hunan";
$areanames{en}->{861318732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861318733} = "Hengyang\,\ Hunan";
$areanames{en}->{861318734} = "Hengyang\,\ Hunan";
$areanames{en}->{861318735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861318736} = "Chenzhou\,\ Hunan";
$areanames{en}->{861318737} = "Yiyang\,\ Hunan";
$areanames{en}->{861318738} = "Shaoyang\,\ Hunan";
$areanames{en}->{861318739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861318740} = "Kunming\,\ Yunnan";
$areanames{en}->{861318741} = "Kunming\,\ Yunnan";
$areanames{en}->{861318742} = "Kunming\,\ Yunnan";
$areanames{en}->{861318743} = "Kunming\,\ Yunnan";
$areanames{en}->{861318744} = "Kunming\,\ Yunnan";
$areanames{en}->{861318745} = "Qujing\,\ Yunnan";
$areanames{en}->{861318746} = "Dali\,\ Yunnan";
$areanames{en}->{861318747} = "Lincang\,\ Yunnan";
$areanames{en}->{861318748} = "Deqen\,\ Yunnan";
$areanames{en}->{861318749} = "Nujiang\,\ Yunnan";
$areanames{en}->{861318750} = "Baoshan\,\ Yunnan";
$areanames{en}->{861318751} = "Baoshan\,\ Yunnan";
$areanames{en}->{861318752} = "Baoshan\,\ Yunnan";
$areanames{en}->{861318753} = "Baoshan\,\ Yunnan";
$areanames{en}->{861318754} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861318755} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861318756} = "Dehong\,\ Yunnan";
$areanames{en}->{861318757} = "Dehong\,\ Yunnan";
$areanames{en}->{861318758} = "Lincang\,\ Yunnan";
$areanames{en}->{861318759} = "Lincang\,\ Yunnan";
$areanames{en}->{861318760} = "Wenshan\,\ Yunnan";
$areanames{en}->{861318761} = "Wenshan\,\ Yunnan";
$areanames{en}->{861318762} = "Wenshan\,\ Yunnan";
$areanames{en}->{861318763} = "Wenshan\,\ Yunnan";
$areanames{en}->{861318764} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861318765} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861318766} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861318767} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861318768} = "Dali\,\ Yunnan";
$areanames{en}->{861318769} = "Dali\,\ Yunnan";
$areanames{en}->{861318770} = "Kunming\,\ Yunnan";
$areanames{en}->{861318771} = "Yuxi\,\ Yunnan";
$areanames{en}->{861318772} = "Yuxi\,\ Yunnan";
$areanames{en}->{861318773} = "Yuxi\,\ Yunnan";
$areanames{en}->{861318774} = "Yuxi\,\ Yunnan";
$areanames{en}->{861318775} = "Lijiang\,\ Yunnan";
$areanames{en}->{861318776} = "Qujing\,\ Yunnan";
$areanames{en}->{861318777} = "Qujing\,\ Yunnan";
$areanames{en}->{861318778} = "Qujing\,\ Yunnan";
$areanames{en}->{861318779} = "Lijiang\,\ Yunnan";
$areanames{en}->{86131878} = "Kunming\,\ Yunnan";
$areanames{en}->{861318780} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861318790} = "Puer\,\ Yunnan";
$areanames{en}->{861318791} = "Puer\,\ Yunnan";
$areanames{en}->{861318792} = "Puer\,\ Yunnan";
$areanames{en}->{861318793} = "Puer\,\ Yunnan";
$areanames{en}->{861318794} = "Honghe\,\ Yunnan";
$areanames{en}->{861318795} = "Honghe\,\ Yunnan";
$areanames{en}->{861318796} = "Honghe\,\ Yunnan";
$areanames{en}->{861318797} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861318798} = "Deqen\,\ Yunnan";
$areanames{en}->{861318799} = "Nujiang\,\ Yunnan";
$areanames{en}->{86131880} = "Anshan\,\ Liaoning";
$areanames{en}->{861318810} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861318811} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861318812} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861318813} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861318814} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861318815} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861318816} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861318817} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861318818} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861318819} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861318820} = "Benxi\,\ Liaoning";
$areanames{en}->{861318821} = "Benxi\,\ Liaoning";
$areanames{en}->{861318822} = "Benxi\,\ Liaoning";
$areanames{en}->{861318823} = "Benxi\,\ Liaoning";
$areanames{en}->{861318824} = "Benxi\,\ Liaoning";
$areanames{en}->{861318825} = "Fushun\,\ Liaoning";
$areanames{en}->{861318826} = "Fushun\,\ Liaoning";
$areanames{en}->{861318827} = "Fushun\,\ Liaoning";
$areanames{en}->{861318828} = "Fushun\,\ Liaoning";
$areanames{en}->{861318829} = "Fushun\,\ Liaoning";
$areanames{en}->{861318830} = "Fuxin\,\ Liaoning";
$areanames{en}->{861318831} = "Fuxin\,\ Liaoning";
$areanames{en}->{861318832} = "Fuxin\,\ Liaoning";
$areanames{en}->{861318833} = "Fuxin\,\ Liaoning";
$areanames{en}->{861318834} = "Fuxin\,\ Liaoning";
$areanames{en}->{861318835} = "Dandong\,\ Liaoning";
$areanames{en}->{861318836} = "Dandong\,\ Liaoning";
$areanames{en}->{861318837} = "Dandong\,\ Liaoning";
$areanames{en}->{861318838} = "Dandong\,\ Liaoning";
$areanames{en}->{861318839} = "Dandong\,\ Liaoning";
$areanames{en}->{861318840} = "Tieling\,\ Liaoning";
$areanames{en}->{861318841} = "Tieling\,\ Liaoning";
$areanames{en}->{861318842} = "Tieling\,\ Liaoning";
$areanames{en}->{861318843} = "Tieling\,\ Liaoning";
$areanames{en}->{861318844} = "Tieling\,\ Liaoning";
$areanames{en}->{861318845} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318846} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318847} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318848} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318849} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318850} = "Huludao\,\ Liaoning";
$areanames{en}->{861318851} = "Huludao\,\ Liaoning";
$areanames{en}->{861318852} = "Huludao\,\ Liaoning";
$areanames{en}->{861318853} = "Huludao\,\ Liaoning";
$areanames{en}->{861318854} = "Huludao\,\ Liaoning";
$areanames{en}->{861318855} = "Panjin\,\ Liaoning";
$areanames{en}->{861318856} = "Panjin\,\ Liaoning";
$areanames{en}->{861318857} = "Panjin\,\ Liaoning";
$areanames{en}->{861318858} = "Panjin\,\ Liaoning";
$areanames{en}->{861318859} = "Panjin\,\ Liaoning";
$areanames{en}->{861318860} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318861} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318862} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318863} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318864} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861318865} = "Tieling\,\ Liaoning";
$areanames{en}->{861318866} = "Tieling\,\ Liaoning";
$areanames{en}->{861318867} = "Tieling\,\ Liaoning";
$areanames{en}->{861318868} = "Tieling\,\ Liaoning";
$areanames{en}->{861318869} = "Tieling\,\ Liaoning";
$areanames{en}->{861318870} = "Linyi\,\ Shandong";
$areanames{en}->{861318871} = "Linyi\,\ Shandong";
$areanames{en}->{861318872} = "Linyi\,\ Shandong";
$areanames{en}->{861318873} = "Linyi\,\ Shandong";
$areanames{en}->{861318874} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318875} = "Liaocheng\,\ Shandong";
$areanames{en}->{861318876} = "Yantai\,\ Shandong";
$areanames{en}->{861318877} = "Yantai\,\ Shandong";
$areanames{en}->{861318878} = "Yantai\,\ Shandong";
$areanames{en}->{861318879} = "Yantai\,\ Shandong";
$areanames{en}->{861318880} = "Jining\,\ Shandong";
$areanames{en}->{861318881} = "Jining\,\ Shandong";
$areanames{en}->{861318882} = "Jining\,\ Shandong";
$areanames{en}->{861318883} = "Weifang\,\ Shandong";
$areanames{en}->{861318884} = "Weifang\,\ Shandong";
$areanames{en}->{861318885} = "Weifang\,\ Shandong";
$areanames{en}->{861318886} = "Weifang\,\ Shandong";
$areanames{en}->{861318887} = "Jinan\,\ Shandong";
$areanames{en}->{861318888} = "Jinan\,\ Shandong";
$areanames{en}->{861318889} = "Jinan\,\ Shandong";
$areanames{en}->{861318890} = "Binzhou\,\ Shandong";
$areanames{en}->{861318891} = "Binzhou\,\ Shandong";
$areanames{en}->{861318892} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861318893} = "Jinan\,\ Shandong";
$areanames{en}->{861318894} = "Jinan\,\ Shandong";
$areanames{en}->{861318895} = "Qingdao\,\ Shandong";
$areanames{en}->{861318896} = "Qingdao\,\ Shandong";
$areanames{en}->{861318897} = "Qingdao\,\ Shandong";
$areanames{en}->{861318898} = "Qingdao\,\ Shandong";
$areanames{en}->{861318899} = "Qingdao\,\ Shandong";
$areanames{en}->{86131890} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131891} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86131892} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86131893} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861318940} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318941} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318942} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318943} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318944} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318945} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318946} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318947} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318948} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318949} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86131895} = "Maoming\,\ Guangdong";
$areanames{en}->{86131896} = "Foshan\,\ Guangdong";
$areanames{en}->{86131897} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861318979} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861318980} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318981} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318982} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318983} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318984} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861318985} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318986} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318987} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318988} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861318989} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86131899} = "Meizhou\,\ Guangdong";
$areanames{en}->{86131900} = "Shenyang\,\ Liaoning";
$areanames{en}->{86131901} = "Dalian\,\ Liaoning";
$areanames{en}->{861319020} = "Dandong\,\ Liaoning";
$areanames{en}->{861319021} = "Dandong\,\ Liaoning";
$areanames{en}->{861319022} = "Dandong\,\ Liaoning";
$areanames{en}->{861319023} = "Dandong\,\ Liaoning";
$areanames{en}->{861319024} = "Dandong\,\ Liaoning";
$areanames{en}->{861319025} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861319026} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861319027} = "Fuxin\,\ Liaoning";
$areanames{en}->{861319028} = "Fuxin\,\ Liaoning";
$areanames{en}->{861319029} = "Fuxin\,\ Liaoning";
$areanames{en}->{861319030} = "Panjin\,\ Liaoning";
$areanames{en}->{861319031} = "Panjin\,\ Liaoning";
$areanames{en}->{861319032} = "Panjin\,\ Liaoning";
$areanames{en}->{861319033} = "Panjin\,\ Liaoning";
$areanames{en}->{861319034} = "Panjin\,\ Liaoning";
$areanames{en}->{861319035} = "Huludao\,\ Liaoning";
$areanames{en}->{861319036} = "Huludao\,\ Liaoning";
$areanames{en}->{861319037} = "Huludao\,\ Liaoning";
$areanames{en}->{861319038} = "Huludao\,\ Liaoning";
$areanames{en}->{861319039} = "Huludao\,\ Liaoning";
$areanames{en}->{861319040} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861319041} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861319042} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861319043} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861319044} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861319045} = "Benxi\,\ Liaoning";
$areanames{en}->{861319046} = "Benxi\,\ Liaoning";
$areanames{en}->{861319047} = "Benxi\,\ Liaoning";
$areanames{en}->{861319048} = "Benxi\,\ Liaoning";
$areanames{en}->{861319049} = "Benxi\,\ Liaoning";
$areanames{en}->{86131905} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861319056} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861319057} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861319058} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861319059} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861319060} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861319061} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861319062} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861319063} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861319064} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861319065} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861319066} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861319067} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861319068} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861319069} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{86131907} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861319076} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319077} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319078} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861319079} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861319080} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861319081} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861319082} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861319083} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861319084} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861319085} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861319086} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861319087} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861319088} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861319089} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861319090} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319091} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319092} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319093} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319094} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319095} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861319096} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861319097} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319098} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319099} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{86131910} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861319101} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861319102} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861319103} = "Changzhi\,\ Shanxi";
$areanames{en}->{861319110} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861319111} = "Linfen\,\ Shanxi";
$areanames{en}->{861319112} = "Datong\,\ Shanxi";
$areanames{en}->{861319113} = "Yangquan\,\ Shanxi";
$areanames{en}->{861319114} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861319115} = "Changzhi\,\ Shanxi";
$areanames{en}->{861319116} = "Jincheng\,\ Shanxi";
$areanames{en}->{861319117} = "Linfen\,\ Shanxi";
$areanames{en}->{861319118} = "Lüliang\,\ Shanxi";
$areanames{en}->{861319119} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861319120} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861319121} = "Lüliang\,\ Shanxi";
$areanames{en}->{861319122} = "Datong\,\ Shanxi";
$areanames{en}->{861319123} = "Yangquan\,\ Shanxi";
$areanames{en}->{861319124} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861319125} = "Changzhi\,\ Shanxi";
$areanames{en}->{861319126} = "Jincheng\,\ Shanxi";
$areanames{en}->{861319127} = "Linfen\,\ Shanxi";
$areanames{en}->{861319128} = "Datong\,\ Shanxi";
$areanames{en}->{861319129} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861319130} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319131} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319132} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319133} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319134} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861319135} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861319136} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861319137} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861319138} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861319139} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{86131914} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861319140} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861319141} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861319142} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861319143} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861319150} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319151} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319152} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861319153} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861319154} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861319155} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861319156} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861319157} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861319158} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861319159} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861319160} = "Xingtai\,\ Hebei";
$areanames{en}->{861319161} = "Xingtai\,\ Hebei";
$areanames{en}->{861319162} = "Xingtai\,\ Hebei";
$areanames{en}->{861319163} = "Chengde\,\ Hebei";
$areanames{en}->{861319164} = "Baoding\,\ Hebei";
$areanames{en}->{861319165} = "Baoding\,\ Hebei";
$areanames{en}->{861319166} = "Baoding\,\ Hebei";
$areanames{en}->{861319167} = "Baoding\,\ Hebei";
$areanames{en}->{861319168} = "Baoding\,\ Hebei";
$areanames{en}->{861319169} = "Hengshui\,\ Hebei";
$areanames{en}->{861319170} = "Handan\,\ Hebei";
$areanames{en}->{861319171} = "Handan\,\ Hebei";
$areanames{en}->{861319172} = "Handan\,\ Hebei";
$areanames{en}->{861319173} = "Handan\,\ Hebei";
$areanames{en}->{861319174} = "Tangshan\,\ Hebei";
$areanames{en}->{861319175} = "Tangshan\,\ Hebei";
$areanames{en}->{861319176} = "Tangshan\,\ Hebei";
$areanames{en}->{861319177} = "Tangshan\,\ Hebei";
$areanames{en}->{861319178} = "Tangshan\,\ Hebei";
$areanames{en}->{861319179} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861319180} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861319181} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861319182} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861319183} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861319184} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861319185} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861319186} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861319187} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861319188} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861319189} = "Chengde\,\ Hebei";
$areanames{en}->{861319190} = "Hengshui\,\ Hebei";
$areanames{en}->{861319191} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861319192} = "Cangzhou\,\ Hebei";
$areanames{en}->{861319193} = "Cangzhou\,\ Hebei";
$areanames{en}->{861319194} = "Cangzhou\,\ Hebei";
$areanames{en}->{861319195} = "Langfang\,\ Hebei";
$areanames{en}->{861319196} = "Langfang\,\ Hebei";
$areanames{en}->{861319197} = "Langfang\,\ Hebei";
$areanames{en}->{861319198} = "Langfang\,\ Hebei";
$areanames{en}->{861319199} = "Cangzhou\,\ Hebei";
$areanames{en}->{86131920} = "Dongguan\,\ Guangdong";
$areanames{en}->{861319210} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861319211} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861319212} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861319213} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861319214} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861319215} = "Shantou\,\ Guangdong";
$areanames{en}->{861319216} = "Shantou\,\ Guangdong";
$areanames{en}->{861319217} = "Shantou\,\ Guangdong";
$areanames{en}->{861319218} = "Shantou\,\ Guangdong";
$areanames{en}->{861319219} = "Shantou\,\ Guangdong";
$areanames{en}->{86131922} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86131923} = "Shantou\,\ Guangdong";
$areanames{en}->{861319240} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319241} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319242} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319243} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319244} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319245} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319246} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319247} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319248} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319249} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319250} = "Shanwei\,\ Guangdong";
$areanames{en}->{861319251} = "Shanwei\,\ Guangdong";
$areanames{en}->{861319252} = "Shanwei\,\ Guangdong";
$areanames{en}->{861319253} = "Shanwei\,\ Guangdong";
$areanames{en}->{861319254} = "Shanwei\,\ Guangdong";
$areanames{en}->{861319255} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861319256} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861319257} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861319258} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861319259} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861319260} = "Yunfu\,\ Guangdong";
$areanames{en}->{861319261} = "Yunfu\,\ Guangdong";
$areanames{en}->{861319262} = "Yunfu\,\ Guangdong";
$areanames{en}->{861319263} = "Yunfu\,\ Guangdong";
$areanames{en}->{861319264} = "Yunfu\,\ Guangdong";
$areanames{en}->{861319265} = "Foshan\,\ Guangdong";
$areanames{en}->{861319266} = "Foshan\,\ Guangdong";
$areanames{en}->{861319267} = "Foshan\,\ Guangdong";
$areanames{en}->{861319268} = "Foshan\,\ Guangdong";
$areanames{en}->{861319269} = "Foshan\,\ Guangdong";
$areanames{en}->{861319270} = "Heyuan\,\ Guangdong";
$areanames{en}->{861319271} = "Heyuan\,\ Guangdong";
$areanames{en}->{861319272} = "Heyuan\,\ Guangdong";
$areanames{en}->{861319273} = "Heyuan\,\ Guangdong";
$areanames{en}->{861319274} = "Heyuan\,\ Guangdong";
$areanames{en}->{861319275} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861319276} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861319277} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861319278} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861319279} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861319280} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319281} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319282} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319283} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319284} = "Huizhou\,\ Guangdong";
$areanames{en}->{861319285} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319286} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319287} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319288} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861319289} = "Shaoguan\,\ Guangdong";
$areanames{en}->{86131929} = "Jieyang\,\ Guangdong";
$areanames{en}->{86131930} = "Chongqing";
$areanames{en}->{86131931} = "Chongqing";
$areanames{en}->{86131932} = "Chongqing";
$areanames{en}->{86131933} = "XiAn\,\ Shaanxi";
$areanames{en}->{861319340} = "Shangqiu\,\ Henan";
$areanames{en}->{861319341} = "Shangqiu\,\ Henan";
$areanames{en}->{861319342} = "Shangqiu\,\ Henan";
$areanames{en}->{861319343} = "Xuchang\,\ Henan";
$areanames{en}->{861319344} = "Xuchang\,\ Henan";
$areanames{en}->{861319345} = "Xuchang\,\ Henan";
$areanames{en}->{861319346} = "Xuchang\,\ Henan";
$areanames{en}->{861319347} = "Hebi\,\ Henan";
$areanames{en}->{861319348} = "Hebi\,\ Henan";
$areanames{en}->{861319349} = "Hebi\,\ Henan";
$areanames{en}->{861319350} = "Anyang\,\ Henan";
$areanames{en}->{861319351} = "Anyang\,\ Henan";
$areanames{en}->{861319352} = "Anyang\,\ Henan";
$areanames{en}->{861319353} = "Anyang\,\ Henan";
$areanames{en}->{861319354} = "Anyang\,\ Henan";
$areanames{en}->{861319355} = "Puyang\,\ Henan";
$areanames{en}->{861319356} = "Puyang\,\ Henan";
$areanames{en}->{861319357} = "Puyang\,\ Henan";
$areanames{en}->{861319358} = "Puyang\,\ Henan";
$areanames{en}->{861319359} = "Puyang\,\ Henan";
$areanames{en}->{861319360} = "Zhoukou\,\ Henan";
$areanames{en}->{861319361} = "Zhoukou\,\ Henan";
$areanames{en}->{861319362} = "Zhoukou\,\ Henan";
$areanames{en}->{861319363} = "Zhoukou\,\ Henan";
$areanames{en}->{861319364} = "Zhoukou\,\ Henan";
$areanames{en}->{861319365} = "Nanyang\,\ Henan";
$areanames{en}->{861319366} = "Nanyang\,\ Henan";
$areanames{en}->{861319367} = "Nanyang\,\ Henan";
$areanames{en}->{861319368} = "Nanyang\,\ Henan";
$areanames{en}->{861319369} = "Nanyang\,\ Henan";
$areanames{en}->{861319370} = "Zhumadian\,\ Henan";
$areanames{en}->{861319371} = "Zhumadian\,\ Henan";
$areanames{en}->{861319372} = "Zhumadian\,\ Henan";
$areanames{en}->{861319373} = "Zhumadian\,\ Henan";
$areanames{en}->{861319374} = "Zhumadian\,\ Henan";
$areanames{en}->{861319375} = "Kaifeng\,\ Henan";
$areanames{en}->{861319376} = "Kaifeng\,\ Henan";
$areanames{en}->{861319377} = "Kaifeng\,\ Henan";
$areanames{en}->{861319378} = "Kaifeng\,\ Henan";
$areanames{en}->{861319379} = "Kaifeng\,\ Henan";
$areanames{en}->{861319380} = "Nanyang\,\ Henan";
$areanames{en}->{861319381} = "Nanyang\,\ Henan";
$areanames{en}->{861319382} = "Nanyang\,\ Henan";
$areanames{en}->{861319383} = "Nanyang\,\ Henan";
$areanames{en}->{861319384} = "Nanyang\,\ Henan";
$areanames{en}->{861319385} = "Xinyang\,\ Henan";
$areanames{en}->{861319386} = "Xinyang\,\ Henan";
$areanames{en}->{861319387} = "Xinyang\,\ Henan";
$areanames{en}->{861319388} = "Xinyang\,\ Henan";
$areanames{en}->{861319389} = "Xinyang\,\ Henan";
$areanames{en}->{86131939} = "Sanmenxia\,\ Henan";
$areanames{en}->{861319390} = "Luohe\,\ Henan";
$areanames{en}->{861319391} = "Luohe\,\ Henan";
$areanames{en}->{861319392} = "Luohe\,\ Henan";
$areanames{en}->{861319393} = "Luohe\,\ Henan";
$areanames{en}->{861319400} = "Sanming\,\ Fujian";
$areanames{en}->{861319401} = "Nanping\,\ Fujian";
$areanames{en}->{861319402} = "Nanping\,\ Fujian";
$areanames{en}->{861319403} = "Ningde\,\ Fujian";
$areanames{en}->{861319404} = "Pingdingshan\,\ Henan";
$areanames{en}->{861319405} = "Nanping\,\ Fujian";
$areanames{en}->{861319406} = "Quanzhou\,\ Fujian";
$areanames{en}->{861319407} = "Xiamen\,\ Fujian";
$areanames{en}->{861319408} = "Xiamen\,\ Fujian";
$areanames{en}->{861319409} = "Xiamen\,\ Fujian";
$areanames{en}->{861319410} = "Tieling\,\ Liaoning";
$areanames{en}->{861319411} = "Dalian\,\ Liaoning";
$areanames{en}->{861319412} = "Anshan\,\ Liaoning";
$areanames{en}->{861319413} = "Fushun\,\ Liaoning";
$areanames{en}->{861319414} = "Benxi\,\ Liaoning";
$areanames{en}->{861319415} = "Dandong\,\ Liaoning";
$areanames{en}->{861319416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861319417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861319418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861319419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861319420} = "Shenyang\,\ Liaoning";
$areanames{en}->{861319421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861319422} = "Shenyang\,\ Liaoning";
$areanames{en}->{861319423} = "Shenyang\,\ Liaoning";
$areanames{en}->{861319424} = "Shenyang\,\ Liaoning";
$areanames{en}->{861319425} = "Anshan\,\ Liaoning";
$areanames{en}->{861319426} = "Dalian\,\ Liaoning";
$areanames{en}->{861319427} = "Panjin\,\ Liaoning";
$areanames{en}->{861319428} = "Dalian\,\ Liaoning";
$areanames{en}->{861319429} = "Huludao\,\ Liaoning";
$areanames{en}->{86131943} = "Changchun\,\ Jilin";
$areanames{en}->{861319432} = "Jilin\,\ Jilin";
$areanames{en}->{861319433} = "Yanbian\,\ Jilin";
$areanames{en}->{861319434} = "Siping\,\ Jilin";
$areanames{en}->{861319440} = "Putian\,\ Fujian";
$areanames{en}->{861319441} = "Putian\,\ Fujian";
$areanames{en}->{861319442} = "Putian\,\ Fujian";
$areanames{en}->{861319443} = "Putian\,\ Fujian";
$areanames{en}->{861319444} = "Putian\,\ Fujian";
$areanames{en}->{861319445} = "Fuzhou\,\ Fujian";
$areanames{en}->{861319446} = "Fuzhou\,\ Fujian";
$areanames{en}->{861319447} = "Fuzhou\,\ Fujian";
$areanames{en}->{861319448} = "Longyan\,\ Fujian";
$areanames{en}->{861319449} = "Longyan\,\ Fujian";
$areanames{en}->{861319450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861319451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861319452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861319453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861319454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861319455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861319456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861319457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861319458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861319459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86131946} = "Tianjin";
$areanames{en}->{861319470} = "YaAn\,\ Sichuan";
$areanames{en}->{861319471} = "YaAn\,\ Sichuan";
$areanames{en}->{861319472} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861319473} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861319474} = "Bazhong\,\ Sichuan";
$areanames{en}->{861319475} = "Zigong\,\ Sichuan";
$areanames{en}->{861319476} = "Meishan\,\ Sichuan";
$areanames{en}->{861319477} = "Leshan\,\ Sichuan";
$areanames{en}->{861319478} = "Ziyang\,\ Sichuan";
$areanames{en}->{861319479} = "Ziyang\,\ Sichuan";
$areanames{en}->{861319480} = "Suining\,\ Sichuan";
$areanames{en}->{861319481} = "GuangAn\,\ Sichuan";
$areanames{en}->{861319482} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319483} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319484} = "Deyang\,\ Sichuan";
$areanames{en}->{861319485} = "Deyang\,\ Sichuan";
$areanames{en}->{861319486} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319487} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319488} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319489} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319490} = "Neijiang\,\ Sichuan";
$areanames{en}->{861319491} = "Zigong\,\ Sichuan";
$areanames{en}->{861319492} = "Luzhou\,\ Sichuan";
$areanames{en}->{861319493} = "Yibin\,\ Sichuan";
$areanames{en}->{861319494} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861319495} = "Liangshan\,\ Sichuan";
$areanames{en}->{861319496} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319497} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319498} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319499} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319500} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861319501} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861319502} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861319503} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861319504} = "Guyuan\,\ Ningxia";
$areanames{en}->{861319505} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861319506} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861319507} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861319508} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861319509} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861319510} = "Guiyang\,\ Guizhou";
$areanames{en}->{861319511} = "Guiyang\,\ Guizhou";
$areanames{en}->{861319512} = "Zunyi\,\ Guizhou";
$areanames{en}->{861319513} = "Anshun\,\ Guizhou";
$areanames{en}->{861319514} = "Qiannan\,\ Guizhou";
$areanames{en}->{861319515} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861319516} = "Tongren\,\ Guizhou";
$areanames{en}->{861319517} = "Bijie\,\ Guizhou";
$areanames{en}->{861319518} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861319519} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861319520} = "Guiyang\,\ Guizhou";
$areanames{en}->{861319521} = "Guiyang\,\ Guizhou";
$areanames{en}->{861319522} = "Zunyi\,\ Guizhou";
$areanames{en}->{861319523} = "Anshun\,\ Guizhou";
$areanames{en}->{861319524} = "Qiannan\,\ Guizhou";
$areanames{en}->{861319525} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861319526} = "Tongren\,\ Guizhou";
$areanames{en}->{861319527} = "Bijie\,\ Guizhou";
$areanames{en}->{861319528} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861319529} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861319530} = "Chizhou\,\ Anhui";
$areanames{en}->{861319531} = "Wuhu\,\ Anhui";
$areanames{en}->{861319532} = "Wuhu\,\ Anhui";
$areanames{en}->{861319533} = "Wuhu\,\ Anhui";
$areanames{en}->{861319534} = "Xuancheng\,\ Anhui";
$areanames{en}->{861319535} = "Xuancheng\,\ Anhui";
$areanames{en}->{861319536} = "Xuancheng\,\ Anhui";
$areanames{en}->{861319537} = "LuAn\,\ Anhui";
$areanames{en}->{861319538} = "LuAn\,\ Anhui";
$areanames{en}->{861319539} = "LuAn\,\ Anhui";
$areanames{en}->{861319540} = "Bozhou\,\ Anhui";
$areanames{en}->{861319541} = "Bozhou\,\ Anhui";
$areanames{en}->{861319542} = "Bengbu\,\ Anhui";
$areanames{en}->{861319543} = "Bengbu\,\ Anhui";
$areanames{en}->{861319544} = "Wuhu\,\ Anhui";
$areanames{en}->{861319545} = "Hefei\,\ Anhui";
$areanames{en}->{861319546} = "MaAnshan\,\ Anhui";
$areanames{en}->{861319547} = "Huainan\,\ Anhui";
$areanames{en}->{861319548} = "Fuyang\,\ Anhui";
$areanames{en}->{861319549} = "Chizhou\,\ Anhui";
$areanames{en}->{861319550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861319551} = "Hefei\,\ Anhui";
$areanames{en}->{861319552} = "Bengbu\,\ Anhui";
$areanames{en}->{861319553} = "Wuhu\,\ Anhui";
$areanames{en}->{861319554} = "Huainan\,\ Anhui";
$areanames{en}->{861319555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861319556} = "Anqing\,\ Anhui";
$areanames{en}->{861319557} = "Suzhou\,\ Anhui";
$areanames{en}->{861319558} = "Fuyang\,\ Anhui";
$areanames{en}->{861319559} = "Huangshan\,\ Anhui";
$areanames{en}->{861319560} = "Huaibei\,\ Anhui";
$areanames{en}->{861319561} = "Huaibei\,\ Anhui";
$areanames{en}->{861319562} = "Tongling\,\ Anhui";
$areanames{en}->{861319563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861319564} = "LuAn\,\ Anhui";
$areanames{en}->{861319565} = "Hefei\,\ Anhui";
$areanames{en}->{861319566} = "Chizhou\,\ Anhui";
$areanames{en}->{861319567} = "Bozhou\,\ Anhui";
$areanames{en}->{861319568} = "Bozhou\,\ Anhui";
$areanames{en}->{861319569} = "Huaibei\,\ Anhui";
$areanames{en}->{861319570} = "Haixi\,\ Qinghai";
$areanames{en}->{861319571} = "Haixi\,\ Qinghai";
$areanames{en}->{861319572} = "Haixi\,\ Qinghai";
$areanames{en}->{861319573} = "Haidong\,\ Qinghai";
$areanames{en}->{861319574} = "Haidong\,\ Qinghai";
$areanames{en}->{861319575} = "Xining\,\ Qinghai";
$areanames{en}->{861319576} = "Xining\,\ Qinghai";
$areanames{en}->{861319577} = "Xining\,\ Qinghai";
$areanames{en}->{861319578} = "Xining\,\ Qinghai";
$areanames{en}->{861319579} = "Xining\,\ Qinghai";
$areanames{en}->{861319580} = "Longnan\,\ Gansu";
$areanames{en}->{861319581} = "Tianshui\,\ Gansu";
$areanames{en}->{861319582} = "Dingxi\,\ Gansu";
$areanames{en}->{861319583} = "Lanzhou\,\ Gansu";
$areanames{en}->{861319584} = "Qingyang\,\ Gansu";
$areanames{en}->{861319585} = "Linxia\,\ Gansu";
$areanames{en}->{861319586} = "Baiyin\,\ Gansu";
$areanames{en}->{861319587} = "Pingliang\,\ Gansu";
$areanames{en}->{861319588} = "Qingyang\,\ Gansu";
$areanames{en}->{861319589} = "Pingliang\,\ Gansu";
$areanames{en}->{861319590} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861319591} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861319592} = "Wuwei\,\ Gansu";
$areanames{en}->{861319593} = "Wuwei\,\ Gansu";
$areanames{en}->{861319594} = "Jiuquan\,\ Gansu";
$areanames{en}->{861319595} = "Jinchang\,\ Gansu";
$areanames{en}->{861319596} = "Zhangye\,\ Gansu";
$areanames{en}->{861319597} = "Jiuquan\,\ Gansu";
$areanames{en}->{861319598} = "Jiuquan\,\ Gansu";
$areanames{en}->{861319599} = "Jinchang\,\ Gansu";
$areanames{en}->{861319600} = "Changchun\,\ Jilin";
$areanames{en}->{861319601} = "Changchun\,\ Jilin";
$areanames{en}->{861319602} = "Changchun\,\ Jilin";
$areanames{en}->{861319603} = "Changchun\,\ Jilin";
$areanames{en}->{861319604} = "Changchun\,\ Jilin";
$areanames{en}->{861319605} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861319606} = "Jilin\,\ Jilin";
$areanames{en}->{861319607} = "Jilin\,\ Jilin";
$areanames{en}->{861319608} = "Jilin\,\ Jilin";
$areanames{en}->{861319609} = "Jilin\,\ Jilin";
$areanames{en}->{861319610} = "Baicheng\,\ Jilin";
$areanames{en}->{861319611} = "Songyuan\,\ Jilin";
$areanames{en}->{861319612} = "Songyuan\,\ Jilin";
$areanames{en}->{861319613} = "Songyuan\,\ Jilin";
$areanames{en}->{861319614} = "Tonghua\,\ Jilin";
$areanames{en}->{861319615} = "Tonghua\,\ Jilin";
$areanames{en}->{861319616} = "Tonghua\,\ Jilin";
$areanames{en}->{861319617} = "Tonghua\,\ Jilin";
$areanames{en}->{861319618} = "Tonghua\,\ Jilin";
$areanames{en}->{861319619} = "Baishan\,\ Jilin";
$areanames{en}->{861319620} = "Yanbian\,\ Jilin";
$areanames{en}->{861319621} = "Jilin\,\ Jilin";
$areanames{en}->{861319622} = "Jilin\,\ Jilin";
$areanames{en}->{861319623} = "Jilin\,\ Jilin";
$areanames{en}->{861319624} = "Jilin\,\ Jilin";
$areanames{en}->{861319625} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861319626} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861319627} = "Siping\,\ Jilin";
$areanames{en}->{861319628} = "Siping\,\ Jilin";
$areanames{en}->{861319629} = "Siping\,\ Jilin";
$areanames{en}->{861319630} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861319631} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861319632} = "Weinan\,\ Shaanxi";
$areanames{en}->{861319633} = "Weinan\,\ Shaanxi";
$areanames{en}->{861319634} = "Baoji\,\ Shaanxi";
$areanames{en}->{861319635} = "Baoji\,\ Shaanxi";
$areanames{en}->{861319636} = "Baoji\,\ Shaanxi";
$areanames{en}->{861319637} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861319638} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861319639} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861319640} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861319641} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861319642} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861319643} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861319644} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861319645} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861319646} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861319647} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861319648} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861319649} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{86131965} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861319660} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861319661} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861319662} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861319663} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861319664} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861319665} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861319666} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861319667} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861319668} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861319669} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{86131967} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861319680} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861319681} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861319682} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861319683} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861319684} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861319685} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861319686} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861319687} = "Suqian\,\ Jiangsu";
$areanames{en}->{861319688} = "Suqian\,\ Jiangsu";
$areanames{en}->{861319689} = "Suqian\,\ Jiangsu";
$areanames{en}->{86131969} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861319696} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861319697} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861319698} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861319699} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861319700} = "Huangshi\,\ Hubei";
$areanames{en}->{861319701} = "Huangshi\,\ Hubei";
$areanames{en}->{861319702} = "Huangshi\,\ Hubei";
$areanames{en}->{861319703} = "Huangshi\,\ Hubei";
$areanames{en}->{861319704} = "Huangshi\,\ Hubei";
$areanames{en}->{861319705} = "Huanggang\,\ Hubei";
$areanames{en}->{861319706} = "Huanggang\,\ Hubei";
$areanames{en}->{861319707} = "Huanggang\,\ Hubei";
$areanames{en}->{861319708} = "Huanggang\,\ Hubei";
$areanames{en}->{861319709} = "Huanggang\,\ Hubei";
$areanames{en}->{86131971} = "Xiangfan\,\ Hubei";
$areanames{en}->{861319710} = "Jingmen\,\ Hubei";
$areanames{en}->{861319711} = "Jingmen\,\ Hubei";
$areanames{en}->{861319712} = "Jingmen\,\ Hubei";
$areanames{en}->{861319713} = "Jingmen\,\ Hubei";
$areanames{en}->{86131972} = "Shiyan\,\ Hubei";
$areanames{en}->{861319720} = "Enshi\,\ Hubei";
$areanames{en}->{861319721} = "Enshi\,\ Hubei";
$areanames{en}->{861319722} = "Enshi\,\ Hubei";
$areanames{en}->{861319723} = "Enshi\,\ Hubei";
$areanames{en}->{861319730} = "Yichang\,\ Hubei";
$areanames{en}->{861319731} = "Yichang\,\ Hubei";
$areanames{en}->{861319732} = "Yichang\,\ Hubei";
$areanames{en}->{861319733} = "Yichang\,\ Hubei";
$areanames{en}->{861319734} = "Yichang\,\ Hubei";
$areanames{en}->{861319735} = "Xiaogan\,\ Hubei";
$areanames{en}->{861319736} = "Xiaogan\,\ Hubei";
$areanames{en}->{861319737} = "Xiaogan\,\ Hubei";
$areanames{en}->{861319738} = "Xiaogan\,\ Hubei";
$areanames{en}->{861319739} = "Xiaogan\,\ Hubei";
$areanames{en}->{861319740} = "Xianning\,\ Hubei";
$areanames{en}->{861319741} = "Xianning\,\ Hubei";
$areanames{en}->{861319742} = "Xianning\,\ Hubei";
$areanames{en}->{861319743} = "Ezhou\,\ Hubei";
$areanames{en}->{861319744} = "Ezhou\,\ Hubei";
$areanames{en}->{861319745} = "Wuhan\,\ Hubei";
$areanames{en}->{861319746} = "Suizhou\,\ Hubei";
$areanames{en}->{861319747} = "Jingzhou\,\ Hubei";
$areanames{en}->{861319748} = "Jingzhou\,\ Hubei";
$areanames{en}->{861319749} = "Jingzhou\,\ Hubei";
$areanames{en}->{861319750} = "Nanning\,\ Guangxi";
$areanames{en}->{861319751} = "Nanning\,\ Guangxi";
$areanames{en}->{861319752} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861319753} = "Hezhou\,\ Guangxi";
$areanames{en}->{861319754} = "Hezhou\,\ Guangxi";
$areanames{en}->{861319755} = "Guigang\,\ Guangxi";
$areanames{en}->{861319756} = "Baise\,\ Guangxi";
$areanames{en}->{861319757} = "Nanning\,\ Guangxi";
$areanames{en}->{861319758} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861319759} = "Beihai\,\ Guangxi";
$areanames{en}->{861319760} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861319761} = "Nanning\,\ Guangxi";
$areanames{en}->{861319762} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861319763} = "Guilin\,\ Guangxi";
$areanames{en}->{861319764} = "Guilin\,\ Guangxi";
$areanames{en}->{861319765} = "Yulin\,\ Guangxi";
$areanames{en}->{861319766} = "Guigang\,\ Guangxi";
$areanames{en}->{861319767} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861319768} = "Hechi\,\ Guangxi";
$areanames{en}->{861319769} = "Beihai\,\ Guangxi";
$areanames{en}->{861319770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861319771} = "Nanning\,\ Guangxi";
$areanames{en}->{861319772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861319773} = "Guilin\,\ Guangxi";
$areanames{en}->{861319774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861319775} = "Yulin\,\ Guangxi";
$areanames{en}->{861319776} = "Baise\,\ Guangxi";
$areanames{en}->{861319777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861319778} = "Hechi\,\ Guangxi";
$areanames{en}->{861319779} = "Beihai\,\ Guangxi";
$areanames{en}->{861319780} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861319781} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861319782} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861319783} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861319784} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861319785} = "Yichun\,\ Jiangxi";
$areanames{en}->{861319786} = "Yichun\,\ Jiangxi";
$areanames{en}->{861319787} = "Yichun\,\ Jiangxi";
$areanames{en}->{861319788} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861319789} = "JiAn\,\ Jiangxi";
$areanames{en}->{861319790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861319791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861319792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861319793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861319794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861319795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861319796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861319797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861319798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861319799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861319800} = "Neijiang\,\ Sichuan";
$areanames{en}->{861319801} = "Neijiang\,\ Sichuan";
$areanames{en}->{861319802} = "Neijiang\,\ Sichuan";
$areanames{en}->{861319803} = "Ziyang\,\ Sichuan";
$areanames{en}->{861319804} = "Ziyang\,\ Sichuan";
$areanames{en}->{861319805} = "Leshan\,\ Sichuan";
$areanames{en}->{861319806} = "Leshan\,\ Sichuan";
$areanames{en}->{861319807} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319808} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319809} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319810} = "GuangAn\,\ Sichuan";
$areanames{en}->{861319811} = "GuangAn\,\ Sichuan";
$areanames{en}->{861319812} = "Bazhong\,\ Sichuan";
$areanames{en}->{861319813} = "Bazhong\,\ Sichuan";
$areanames{en}->{861319814} = "Bazhong\,\ Sichuan";
$areanames{en}->{861319815} = "Deyang\,\ Sichuan";
$areanames{en}->{861319816} = "Suining\,\ Sichuan";
$areanames{en}->{861319817} = "Nanchong\,\ Sichuan";
$areanames{en}->{861319818} = "Nanchong\,\ Sichuan";
$areanames{en}->{861319819} = "Nanchong\,\ Sichuan";
$areanames{en}->{861319820} = "Zigong\,\ Sichuan";
$areanames{en}->{861319821} = "Zigong\,\ Sichuan";
$areanames{en}->{861319822} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861319823} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861319824} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861319825} = "Luzhou\,\ Sichuan";
$areanames{en}->{861319826} = "Luzhou\,\ Sichuan";
$areanames{en}->{861319827} = "Deyang\,\ Sichuan";
$areanames{en}->{861319828} = "Deyang\,\ Sichuan";
$areanames{en}->{861319829} = "Deyang\,\ Sichuan";
$areanames{en}->{861319830} = "Dazhou\,\ Sichuan";
$areanames{en}->{861319831} = "Dazhou\,\ Sichuan";
$areanames{en}->{861319832} = "Yibin\,\ Sichuan";
$areanames{en}->{861319833} = "Yibin\,\ Sichuan";
$areanames{en}->{861319834} = "Meishan\,\ Sichuan";
$areanames{en}->{861319835} = "Meishan\,\ Sichuan";
$areanames{en}->{861319836} = "Meishan\,\ Sichuan";
$areanames{en}->{861319837} = "Liangshan\,\ Sichuan";
$areanames{en}->{861319838} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861319839} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861319840} = "Zigong\,\ Sichuan";
$areanames{en}->{861319841} = "Suining\,\ Sichuan";
$areanames{en}->{861319842} = "Luzhou\,\ Sichuan";
$areanames{en}->{861319843} = "Nanchong\,\ Sichuan";
$areanames{en}->{861319844} = "Dazhou\,\ Sichuan";
$areanames{en}->{861319845} = "Neijiang\,\ Sichuan";
$areanames{en}->{861319846} = "Yibin\,\ Sichuan";
$areanames{en}->{861319847} = "Leshan\,\ Sichuan";
$areanames{en}->{861319848} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861319849} = "Liangshan\,\ Sichuan";
$areanames{en}->{86131985} = "Chengdu\,\ Sichuan";
$areanames{en}->{861319860} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861319861} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861319862} = "Meishan\,\ Sichuan";
$areanames{en}->{861319863} = "Liangshan\,\ Sichuan";
$areanames{en}->{861319864} = "Nanchong\,\ Sichuan";
$areanames{en}->{861319865} = "Suining\,\ Sichuan";
$areanames{en}->{861319866} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319867} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319868} = "Mianyang\,\ Sichuan";
$areanames{en}->{861319869} = "Bazhong\,\ Sichuan";
$areanames{en}->{861319870} = "Meishan\,\ Sichuan";
$areanames{en}->{861319871} = "Leshan\,\ Sichuan";
$areanames{en}->{861319872} = "Leshan\,\ Sichuan";
$areanames{en}->{861319873} = "Dazhou\,\ Sichuan";
$areanames{en}->{861319874} = "Dazhou\,\ Sichuan";
$areanames{en}->{861319875} = "Dazhou\,\ Sichuan";
$areanames{en}->{861319876} = "Zigong\,\ Sichuan";
$areanames{en}->{861319877} = "GuangAn\,\ Sichuan";
$areanames{en}->{861319878} = "Neijiang\,\ Sichuan";
$areanames{en}->{861319879} = "Neijiang\,\ Sichuan";
$areanames{en}->{861319880} = "Zigong\,\ Sichuan";
$areanames{en}->{861319881} = "Nanchong\,\ Sichuan";
$areanames{en}->{861319882} = "Nanchong\,\ Sichuan";
$areanames{en}->{861319883} = "Yibin\,\ Sichuan";
$areanames{en}->{861319884} = "Yibin\,\ Sichuan";
$areanames{en}->{861319885} = "Ziyang\,\ Sichuan";
$areanames{en}->{861319886} = "Luzhou\,\ Sichuan";
$areanames{en}->{861319887} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861319888} = "Deyang\,\ Sichuan";
$areanames{en}->{861319889} = "Deyang\,\ Sichuan";
$areanames{en}->{86131989} = "Haikou\,\ Hainan";
$areanames{en}->{86131990} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861319900} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861319901} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861319902} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861319903} = "Suihua\,\ Heilongjiang";
$areanames{en}->{86131991} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861319916} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861319917} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861319918} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861319919} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861319920} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861319921} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861319922} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861319923} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861319924} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861319925} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861319926} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861319927} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861319928} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861319929} = "Heihe\,\ Heilongjiang";
$areanames{en}->{86131993} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861319930} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861319931} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861319932} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{86131994} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861319940} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861319941} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861319942} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861319943} = "Jixi\,\ Heilongjiang";
$areanames{en}->{86131995} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861319959} = "Hegang\,\ Heilongjiang";
$areanames{en}->{86131996} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861319960} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861319961} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861319970} = "Changji\,\ Xinjiang";
$areanames{en}->{861319971} = "Hami\,\ Xinjiang";
$areanames{en}->{861319972} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861319973} = "Kashi\,\ Xinjiang";
$areanames{en}->{861319974} = "Aksu\,\ Xinjiang";
$areanames{en}->{861319975} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861319976} = "Hotan\,\ Xinjiang";
$areanames{en}->{861319977} = "Bortala\,\ Xinjiang";
$areanames{en}->{861319978} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861319979} = "Altay\,\ Xinjiang";
$areanames{en}->{86131998} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861319990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861319991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861319992} = "Ili\,\ Xinjiang";
$areanames{en}->{861319993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861319994} = "Changji\,\ Xinjiang";
$areanames{en}->{861319995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861319996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861319997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861319998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861319999} = "Ili\,\ Xinjiang";
$areanames{en}->{8613200} = "Shanghai";
$areanames{en}->{861320100} = "Changji\,\ Xinjiang";
$areanames{en}->{861320101} = "Changji\,\ Xinjiang";
$areanames{en}->{861320102} = "Changji\,\ Xinjiang";
$areanames{en}->{861320103} = "Changji\,\ Xinjiang";
$areanames{en}->{861320104} = "Turpan\,\ Xinjiang";
$areanames{en}->{861320105} = "Kashi\,\ Xinjiang";
$areanames{en}->{861320106} = "Hami\,\ Xinjiang";
$areanames{en}->{861320107} = "Hami\,\ Xinjiang";
$areanames{en}->{861320108} = "Karamay\,\ Xinjiang";
$areanames{en}->{861320109} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861320110} = "Ili\,\ Xinjiang";
$areanames{en}->{861320111} = "Ili\,\ Xinjiang";
$areanames{en}->{861320112} = "Ili\,\ Xinjiang";
$areanames{en}->{861320113} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861320114} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861320115} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861320116} = "Aksu\,\ Xinjiang";
$areanames{en}->{861320117} = "Aksu\,\ Xinjiang";
$areanames{en}->{861320118} = "Kashi\,\ Xinjiang";
$areanames{en}->{861320119} = "Kashi\,\ Xinjiang";
$areanames{en}->{86132012} = "Urumchi\,\ Xinjiang";
$areanames{en}->{86132013} = "Urumchi\,\ Xinjiang";
$areanames{en}->{86132014} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132015} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132016} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132017} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132018} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132019} = "Weinan\,\ Shaanxi";
$areanames{en}->{861320190} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861320191} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861320192} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861320193} = "Xianyang\,\ Shaanxi";
$areanames{en}->{86132020} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132021} = "Shantou\,\ Guangdong";
$areanames{en}->{861320220} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320221} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320222} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320223} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320224} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320225} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861320226} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861320227} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861320228} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861320229} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861320230} = "Huizhou\,\ Guangdong";
$areanames{en}->{861320231} = "Huizhou\,\ Guangdong";
$areanames{en}->{861320232} = "Huizhou\,\ Guangdong";
$areanames{en}->{861320233} = "Huizhou\,\ Guangdong";
$areanames{en}->{861320234} = "Huizhou\,\ Guangdong";
$areanames{en}->{861320235} = "Foshan\,\ Guangdong";
$areanames{en}->{861320236} = "Foshan\,\ Guangdong";
$areanames{en}->{861320237} = "Foshan\,\ Guangdong";
$areanames{en}->{861320238} = "Foshan\,\ Guangdong";
$areanames{en}->{861320239} = "Foshan\,\ Guangdong";
$areanames{en}->{86132024} = "Foshan\,\ Guangdong";
$areanames{en}->{861320250} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861320251} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861320252} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861320253} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861320254} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861320255} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320256} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320257} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320258} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320259} = "Jieyang\,\ Guangdong";
$areanames{en}->{861320260} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320261} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320262} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320263} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320264} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320265} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320266} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320267} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320268} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320269} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320270} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320271} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320272} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320273} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320274} = "Dongguan\,\ Guangdong";
$areanames{en}->{861320275} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320276} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320277} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320278} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861320279} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{86132028} = "Foshan\,\ Guangdong";
$areanames{en}->{86132029} = "Foshan\,\ Guangdong";
$areanames{en}->{86132030} = "Hengyang\,\ Hunan";
$areanames{en}->{861320300} = "Yueyang\,\ Hunan";
$areanames{en}->{861320301} = "Yueyang\,\ Hunan";
$areanames{en}->{861320302} = "Yueyang\,\ Hunan";
$areanames{en}->{861320303} = "Yueyang\,\ Hunan";
$areanames{en}->{86132031} = "Changsha\,\ Hunan";
$areanames{en}->{861320318} = "Loudi\,\ Hunan";
$areanames{en}->{861320319} = "Loudi\,\ Hunan";
$areanames{en}->{86132032} = "Shaoyang\,\ Hunan";
$areanames{en}->{861320320} = "Xiangtan\,\ Hunan";
$areanames{en}->{861320321} = "Xiangtan\,\ Hunan";
$areanames{en}->{861320322} = "Xiangtan\,\ Hunan";
$areanames{en}->{861320323} = "Xiangtan\,\ Hunan";
$areanames{en}->{86132033} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861320337} = "Chenzhou\,\ Hunan";
$areanames{en}->{861320338} = "Chenzhou\,\ Hunan";
$areanames{en}->{861320339} = "Chenzhou\,\ Hunan";
$areanames{en}->{861320340} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861320341} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861320342} = "Datong\,\ Shanxi";
$areanames{en}->{861320343} = "Yangquan\,\ Shanxi";
$areanames{en}->{861320344} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861320345} = "Changzhi\,\ Shanxi";
$areanames{en}->{861320346} = "Jincheng\,\ Shanxi";
$areanames{en}->{861320347} = "Linfen\,\ Shanxi";
$areanames{en}->{861320348} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861320349} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861320350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861320351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861320352} = "Datong\,\ Shanxi";
$areanames{en}->{861320353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861320354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861320355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861320356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861320357} = "Linfen\,\ Shanxi";
$areanames{en}->{861320358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861320359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861320360} = "Changde\,\ Hunan";
$areanames{en}->{861320361} = "Changde\,\ Hunan";
$areanames{en}->{861320362} = "Changde\,\ Hunan";
$areanames{en}->{861320363} = "Changde\,\ Hunan";
$areanames{en}->{861320364} = "Changde\,\ Hunan";
$areanames{en}->{861320365} = "Yiyang\,\ Hunan";
$areanames{en}->{861320366} = "Yiyang\,\ Hunan";
$areanames{en}->{861320367} = "Yiyang\,\ Hunan";
$areanames{en}->{861320368} = "Yiyang\,\ Hunan";
$areanames{en}->{861320369} = "Yiyang\,\ Hunan";
$areanames{en}->{861320370} = "Zhengzhou\,\ Henan";
$areanames{en}->{861320371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861320372} = "Zhengzhou\,\ Henan";
$areanames{en}->{861320373} = "Zhengzhou\,\ Henan";
$areanames{en}->{861320374} = "Zhengzhou\,\ Henan";
$areanames{en}->{861320375} = "Nanyang\,\ Henan";
$areanames{en}->{861320376} = "Nanyang\,\ Henan";
$areanames{en}->{861320377} = "Nanyang\,\ Henan";
$areanames{en}->{861320378} = "Nanyang\,\ Henan";
$areanames{en}->{861320379} = "Nanyang\,\ Henan";
$areanames{en}->{86132038} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132039} = "Jiaozuo\,\ Henan";
$areanames{en}->{861320400} = "Shenyang\,\ Liaoning";
$areanames{en}->{861320401} = "Shenyang\,\ Liaoning";
$areanames{en}->{861320402} = "Shenyang\,\ Liaoning";
$areanames{en}->{861320403} = "Shenyang\,\ Liaoning";
$areanames{en}->{861320404} = "Shenyang\,\ Liaoning";
$areanames{en}->{861320405} = "Dalian\,\ Liaoning";
$areanames{en}->{861320406} = "Dalian\,\ Liaoning";
$areanames{en}->{861320407} = "Dalian\,\ Liaoning";
$areanames{en}->{861320408} = "Dalian\,\ Liaoning";
$areanames{en}->{861320409} = "Dalian\,\ Liaoning";
$areanames{en}->{861320410} = "Tieling\,\ Liaoning";
$areanames{en}->{861320411} = "Dalian\,\ Liaoning";
$areanames{en}->{861320412} = "Anshan\,\ Liaoning";
$areanames{en}->{861320413} = "Fushun\,\ Liaoning";
$areanames{en}->{861320414} = "Benxi\,\ Liaoning";
$areanames{en}->{861320415} = "Dandong\,\ Liaoning";
$areanames{en}->{861320416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861320417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861320418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861320419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861320420} = "Tieling\,\ Liaoning";
$areanames{en}->{861320421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861320422} = "Anshan\,\ Liaoning";
$areanames{en}->{861320423} = "Anshan\,\ Liaoning";
$areanames{en}->{861320424} = "Fushun\,\ Liaoning";
$areanames{en}->{861320425} = "Fushun\,\ Liaoning";
$areanames{en}->{861320426} = "Benxi\,\ Liaoning";
$areanames{en}->{861320427} = "Panjin\,\ Liaoning";
$areanames{en}->{861320428} = "Fuxin\,\ Liaoning";
$areanames{en}->{861320429} = "Huludao\,\ Liaoning";
$areanames{en}->{861320430} = "Changchun\,\ Jilin";
$areanames{en}->{861320431} = "Changchun\,\ Jilin";
$areanames{en}->{861320432} = "Jilin\,\ Jilin";
$areanames{en}->{861320433} = "Yanbian\,\ Jilin";
$areanames{en}->{861320434} = "Siping\,\ Jilin";
$areanames{en}->{861320435} = "Tonghua\,\ Jilin";
$areanames{en}->{861320436} = "Baicheng\,\ Jilin";
$areanames{en}->{861320437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861320438} = "Songyuan\,\ Jilin";
$areanames{en}->{861320439} = "Baishan\,\ Jilin";
$areanames{en}->{86132044} = "Baicheng\,\ Jilin";
$areanames{en}->{861320449} = "Baishan\,\ Jilin";
$areanames{en}->{861320450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861320454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861320455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861320456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861320457} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861320459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86132046} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861320467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861320468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861320469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861320470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861320471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861320472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861320473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861320474} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861320475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861320476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861320477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861320478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861320479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861320480} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861320481} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861320482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861320483} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861320484} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861320485} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861320486} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861320487} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861320488} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861320489} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861320490} = "Chenzhou\,\ Hunan";
$areanames{en}->{861320491} = "Chenzhou\,\ Hunan";
$areanames{en}->{861320492} = "Huaihua\,\ Hunan";
$areanames{en}->{861320493} = "Huaihua\,\ Hunan";
$areanames{en}->{861320494} = "Loudi\,\ Hunan";
$areanames{en}->{861320495} = "Yongzhou\,\ Hunan";
$areanames{en}->{861320496} = "Yongzhou\,\ Hunan";
$areanames{en}->{861320497} = "Yongzhou\,\ Hunan";
$areanames{en}->{861320498} = "Xiangxi\,\ Hunan";
$areanames{en}->{861320499} = "Huaihua\,\ Hunan";
$areanames{en}->{861320500} = "Fuzhou\,\ Fujian";
$areanames{en}->{861320501} = "Fuzhou\,\ Fujian";
$areanames{en}->{861320502} = "Fuzhou\,\ Fujian";
$areanames{en}->{861320503} = "Fuzhou\,\ Fujian";
$areanames{en}->{861320504} = "Nanping\,\ Fujian";
$areanames{en}->{861320505} = "Quanzhou\,\ Fujian";
$areanames{en}->{861320506} = "Quanzhou\,\ Fujian";
$areanames{en}->{861320507} = "Quanzhou\,\ Fujian";
$areanames{en}->{861320508} = "Quanzhou\,\ Fujian";
$areanames{en}->{861320509} = "Quanzhou\,\ Fujian";
$areanames{en}->{86132051} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861320510} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86132052} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861320520} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861320530} = "Heze\,\ Shandong";
$areanames{en}->{861320531} = "Jinan\,\ Shandong";
$areanames{en}->{861320532} = "Qingdao\,\ Shandong";
$areanames{en}->{861320533} = "Zibo\,\ Shandong";
$areanames{en}->{861320534} = "Dezhou\,\ Shandong";
$areanames{en}->{861320535} = "Yantai\,\ Shandong";
$areanames{en}->{861320536} = "Weifang\,\ Shandong";
$areanames{en}->{861320537} = "Jining\,\ Shandong";
$areanames{en}->{861320538} = "TaiAn\,\ Shandong";
$areanames{en}->{861320539} = "Linyi\,\ Shandong";
$areanames{en}->{861320540} = "Jinan\,\ Shandong";
$areanames{en}->{861320541} = "Jinan\,\ Shandong";
$areanames{en}->{861320542} = "Jinan\,\ Shandong";
$areanames{en}->{861320543} = "Binzhou\,\ Shandong";
$areanames{en}->{861320544} = "Yantai\,\ Shandong";
$areanames{en}->{861320545} = "Yantai\,\ Shandong";
$areanames{en}->{861320546} = "Dongying\,\ Shandong";
$areanames{en}->{861320547} = "Dongying\,\ Shandong";
$areanames{en}->{861320548} = "Dongying\,\ Shandong";
$areanames{en}->{861320549} = "Dongying\,\ Shandong";
$areanames{en}->{861320550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861320551} = "Hefei\,\ Anhui";
$areanames{en}->{861320552} = "Bengbu\,\ Anhui";
$areanames{en}->{861320553} = "Wuhu\,\ Anhui";
$areanames{en}->{861320554} = "Huainan\,\ Anhui";
$areanames{en}->{861320555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861320556} = "Anqing\,\ Anhui";
$areanames{en}->{861320557} = "Suzhou\,\ Anhui";
$areanames{en}->{861320558} = "Fuyang\,\ Anhui";
$areanames{en}->{861320559} = "Huangshan\,\ Anhui";
$areanames{en}->{861320560} = "Hefei\,\ Anhui";
$areanames{en}->{861320561} = "Huaibei\,\ Anhui";
$areanames{en}->{861320562} = "Tongling\,\ Anhui";
$areanames{en}->{861320563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861320564} = "LuAn\,\ Anhui";
$areanames{en}->{861320565} = "MaAnshan\,\ Anhui";
$areanames{en}->{861320566} = "Chizhou\,\ Anhui";
$areanames{en}->{861320567} = "Bozhou\,\ Anhui";
$areanames{en}->{861320568} = "Fuyang\,\ Anhui";
$areanames{en}->{861320569} = "Hefei\,\ Anhui";
$areanames{en}->{861320570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861320571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861320572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861320573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861320574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861320575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861320576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861320577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861320578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861320579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861320580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861320581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861320582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861320583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861320584} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861320585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861320586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861320587} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861320588} = "Lishui\,\ Zhejiang";
$areanames{en}->{861320589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861320590} = "Fuzhou\,\ Fujian";
$areanames{en}->{861320591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861320592} = "Xiamen\,\ Fujian";
$areanames{en}->{861320593} = "Ningde\,\ Fujian";
$areanames{en}->{861320594} = "Putian\,\ Fujian";
$areanames{en}->{861320595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861320596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861320597} = "Longyan\,\ Fujian";
$areanames{en}->{861320598} = "Sanming\,\ Fujian";
$areanames{en}->{861320599} = "Nanping\,\ Fujian";
$areanames{en}->{86132060} = "Chongqing";
$areanames{en}->{86132061} = "Chongqing";
$areanames{en}->{86132062} = "Chongqing";
$areanames{en}->{861320630} = "Weihai\,\ Shandong";
$areanames{en}->{861320631} = "Weihai\,\ Shandong";
$areanames{en}->{861320632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861320633} = "Rizhao\,\ Shandong";
$areanames{en}->{861320634} = "Laiwu\,\ Shandong";
$areanames{en}->{861320635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861320636} = "Qingdao\,\ Shandong";
$areanames{en}->{861320637} = "Qingdao\,\ Shandong";
$areanames{en}->{861320638} = "Qingdao\,\ Shandong";
$areanames{en}->{861320639} = "Qingdao\,\ Shandong";
$areanames{en}->{86132064} = "Qingdao\,\ Shandong";
$areanames{en}->{861320640} = "Jinan\,\ Shandong";
$areanames{en}->{86132065} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320650} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320651} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{86132066} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320660} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320661} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320662} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320663} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320670} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861320671} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861320672} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320673} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861320674} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320675} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320676} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861320677} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861320678} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861320679} = "Heihe\,\ Heilongjiang";
$areanames{en}->{86132068} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861320686} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861320687} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861320688} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861320689} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861320690} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861320691} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861320692} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861320693} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861320694} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861320695} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861320696} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861320697} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861320698} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861320699} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861320700} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861320701} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861320702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861320703} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861320704} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861320705} = "Yichun\,\ Jiangxi";
$areanames{en}->{861320706} = "JiAn\,\ Jiangxi";
$areanames{en}->{861320707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861320708} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861320709} = "Nanchang\,\ Jiangxi";
$areanames{en}->{86132071} = "Wuhan\,\ Hubei";
$areanames{en}->{861320720} = "Yichang\,\ Hubei";
$areanames{en}->{861320721} = "Yichang\,\ Hubei";
$areanames{en}->{861320722} = "Yichang\,\ Hubei";
$areanames{en}->{861320723} = "Xiangfan\,\ Hubei";
$areanames{en}->{861320724} = "Xiangfan\,\ Hubei";
$areanames{en}->{861320725} = "Xiangfan\,\ Hubei";
$areanames{en}->{861320726} = "Shiyan\,\ Hubei";
$areanames{en}->{861320727} = "Jingzhou\,\ Hubei";
$areanames{en}->{861320728} = "Jingzhou\,\ Hubei";
$areanames{en}->{861320729} = "Jingzhou\,\ Hubei";
$areanames{en}->{861320730} = "Yueyang\,\ Hunan";
$areanames{en}->{861320731} = "Changsha\,\ Hunan";
$areanames{en}->{861320732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861320733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861320734} = "Hengyang\,\ Hunan";
$areanames{en}->{861320735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861320736} = "Changde\,\ Hunan";
$areanames{en}->{861320737} = "Yiyang\,\ Hunan";
$areanames{en}->{861320738} = "Loudi\,\ Hunan";
$areanames{en}->{861320739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861320740} = "Yueyang\,\ Hunan";
$areanames{en}->{861320741} = "Changsha\,\ Hunan";
$areanames{en}->{861320742} = "Changsha\,\ Hunan";
$areanames{en}->{861320743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861320744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861320745} = "Huaihua\,\ Hunan";
$areanames{en}->{861320746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861320747} = "Changsha\,\ Hunan";
$areanames{en}->{861320748} = "Changsha\,\ Hunan";
$areanames{en}->{861320749} = "Changsha\,\ Hunan";
$areanames{en}->{86132075} = "Tianjin";
$areanames{en}->{86132076} = "Tianjin";
$areanames{en}->{861320770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861320771} = "Nanning\,\ Guangxi";
$areanames{en}->{861320772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861320773} = "Guilin\,\ Guangxi";
$areanames{en}->{861320774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861320775} = "Yulin\,\ Guangxi";
$areanames{en}->{861320776} = "Baise\,\ Guangxi";
$areanames{en}->{861320777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861320778} = "Hechi\,\ Guangxi";
$areanames{en}->{861320779} = "Beihai\,\ Guangxi";
$areanames{en}->{861320780} = "Nanning\,\ Guangxi";
$areanames{en}->{861320781} = "Nanning\,\ Guangxi";
$areanames{en}->{861320782} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861320783} = "Guilin\,\ Guangxi";
$areanames{en}->{861320784} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861320785} = "Yulin\,\ Guangxi";
$areanames{en}->{861320786} = "Baise\,\ Guangxi";
$areanames{en}->{861320787} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861320788} = "Hechi\,\ Guangxi";
$areanames{en}->{861320789} = "Guigang\,\ Guangxi";
$areanames{en}->{861320790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861320791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861320792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861320793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861320794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861320795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861320796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861320797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861320798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861320799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861320800} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861320801} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861320802} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861320803} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861320804} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861320805} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861320806} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861320807} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861320808} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861320809} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86132081} = "Chengdu\,\ Sichuan";
$areanames{en}->{861320812} = "Nanchong\,\ Sichuan";
$areanames{en}->{861320813} = "Zigong\,\ Sichuan";
$areanames{en}->{861320814} = "Aba\,\ Sichuan";
$areanames{en}->{861320815} = "Ziyang\,\ Sichuan";
$areanames{en}->{861320820} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861320821} = "Dazhou\,\ Sichuan";
$areanames{en}->{861320822} = "GuangAn\,\ Sichuan";
$areanames{en}->{861320823} = "Nanchong\,\ Sichuan";
$areanames{en}->{861320824} = "Garze\,\ Sichuan";
$areanames{en}->{861320825} = "Suining\,\ Sichuan";
$areanames{en}->{861320826} = "Mianyang\,\ Sichuan";
$areanames{en}->{861320827} = "Mianyang\,\ Sichuan";
$areanames{en}->{861320828} = "Mianyang\,\ Sichuan";
$areanames{en}->{861320829} = "Mianyang\,\ Sichuan";
$areanames{en}->{861320830} = "Luzhou\,\ Sichuan";
$areanames{en}->{861320831} = "Yibin\,\ Sichuan";
$areanames{en}->{861320832} = "Neijiang\,\ Sichuan";
$areanames{en}->{861320833} = "Leshan\,\ Sichuan";
$areanames{en}->{861320834} = "Liangshan\,\ Sichuan";
$areanames{en}->{861320835} = "YaAn\,\ Sichuan";
$areanames{en}->{861320836} = "Bazhong\,\ Sichuan";
$areanames{en}->{861320837} = "Meishan\,\ Sichuan";
$areanames{en}->{861320838} = "Deyang\,\ Sichuan";
$areanames{en}->{861320839} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861320840} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861320841} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861320842} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861320843} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861320844} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861320845} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861320846} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861320847} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861320848} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861320849} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861320850} = "Anshun\,\ Guizhou";
$areanames{en}->{861320851} = "Guiyang\,\ Guizhou";
$areanames{en}->{861320852} = "Zunyi\,\ Guizhou";
$areanames{en}->{861320853} = "Anshun\,\ Guizhou";
$areanames{en}->{861320854} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861320855} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861320856} = "Qiannan\,\ Guizhou";
$areanames{en}->{861320857} = "Bijie\,\ Guizhou";
$areanames{en}->{861320858} = "Bijie\,\ Guizhou";
$areanames{en}->{861320859} = "Bijie\,\ Guizhou";
$areanames{en}->{861320860} = "Songyuan\,\ Jilin";
$areanames{en}->{861320861} = "Songyuan\,\ Jilin";
$areanames{en}->{861320862} = "Songyuan\,\ Jilin";
$areanames{en}->{861320863} = "Songyuan\,\ Jilin";
$areanames{en}->{861320864} = "Songyuan\,\ Jilin";
$areanames{en}->{861320865} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861320866} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861320867} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861320868} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861320869} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861320870} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861320871} = "Kunming\,\ Yunnan";
$areanames{en}->{861320872} = "Dali\,\ Yunnan";
$areanames{en}->{861320873} = "Honghe\,\ Yunnan";
$areanames{en}->{861320874} = "Qujing\,\ Yunnan";
$areanames{en}->{861320875} = "Baoshan\,\ Yunnan";
$areanames{en}->{861320876} = "Wenshan\,\ Yunnan";
$areanames{en}->{861320877} = "Yuxi\,\ Yunnan";
$areanames{en}->{861320878} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861320879} = "Puer\,\ Yunnan";
$areanames{en}->{861320880} = "Kunming\,\ Yunnan";
$areanames{en}->{861320881} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861320882} = "Dehong\,\ Yunnan";
$areanames{en}->{861320883} = "Lincang\,\ Yunnan";
$areanames{en}->{861320884} = "Kunming\,\ Yunnan";
$areanames{en}->{861320885} = "Kunming\,\ Yunnan";
$areanames{en}->{861320886} = "Nujiang\,\ Yunnan";
$areanames{en}->{861320887} = "Deqen\,\ Yunnan";
$areanames{en}->{861320888} = "Lijiang\,\ Yunnan";
$areanames{en}->{861320889} = "Kunming\,\ Yunnan";
$areanames{en}->{86132089} = "Haikou\,\ Hainan";
$areanames{en}->{861320900} = "Ili\,\ Xinjiang";
$areanames{en}->{861320901} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861320902} = "Hami\,\ Xinjiang";
$areanames{en}->{861320903} = "Hotan\,\ Xinjiang";
$areanames{en}->{861320904} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861320905} = "Aksu\,\ Xinjiang";
$areanames{en}->{861320906} = "Altay\,\ Xinjiang";
$areanames{en}->{861320907} = "Kashi\,\ Xinjiang";
$areanames{en}->{861320908} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861320909} = "Bortala\,\ Xinjiang";
$areanames{en}->{861320910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861320911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861320912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861320913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861320914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861320915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861320916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861320917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861320918} = "Weinan\,\ Shaanxi";
$areanames{en}->{861320919} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861320920} = "Baoji\,\ Shaanxi";
$areanames{en}->{861320921} = "Baoji\,\ Shaanxi";
$areanames{en}->{861320922} = "Baoji\,\ Shaanxi";
$areanames{en}->{861320923} = "Baoji\,\ Shaanxi";
$areanames{en}->{861320924} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861320925} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861320926} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861320927} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861320928} = "YanAn\,\ Shaanxi";
$areanames{en}->{861320929} = "YanAn\,\ Shaanxi";
$areanames{en}->{861320930} = "Linxia\,\ Gansu";
$areanames{en}->{861320931} = "Lanzhou\,\ Gansu";
$areanames{en}->{861320932} = "Dingxi\,\ Gansu";
$areanames{en}->{861320933} = "Pingliang\,\ Gansu";
$areanames{en}->{861320934} = "Qingyang\,\ Gansu";
$areanames{en}->{861320935} = "Wuwei\,\ Gansu";
$areanames{en}->{861320936} = "Zhangye\,\ Gansu";
$areanames{en}->{861320937} = "Jiuquan\,\ Gansu";
$areanames{en}->{861320938} = "Tianshui\,\ Gansu";
$areanames{en}->{861320939} = "Longnan\,\ Gansu";
$areanames{en}->{861320940} = "Jiuquan\,\ Gansu";
$areanames{en}->{861320941} = "Gannan\,\ Gansu";
$areanames{en}->{861320942} = "Jiuquan\,\ Gansu";
$areanames{en}->{861320943} = "Baiyin\,\ Gansu";
$areanames{en}->{861320944} = "Longnan\,\ Gansu";
$areanames{en}->{861320945} = "Jinchang\,\ Gansu";
$areanames{en}->{861320946} = "Lanzhou\,\ Gansu";
$areanames{en}->{861320947} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861320948} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861320949} = "Baiyin\,\ Gansu";
$areanames{en}->{861320950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861320953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861320954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861320955} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861320956} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861320957} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861320958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320959} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320960} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320961} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320962} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861320963} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861320964} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861320965} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861320966} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861320967} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861320968} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320969} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861320970} = "Haibei\,\ Qinghai";
$areanames{en}->{861320971} = "Xining\,\ Qinghai";
$areanames{en}->{861320972} = "Haidong\,\ Qinghai";
$areanames{en}->{861320973} = "Huangnan\,\ Qinghai";
$areanames{en}->{861320974} = "Hainan\,\ Qinghai";
$areanames{en}->{861320975} = "Haixi\,\ Qinghai";
$areanames{en}->{861320976} = "Haixi\,\ Qinghai";
$areanames{en}->{861320977} = "Haixi\,\ Qinghai";
$areanames{en}->{861320978} = "Xining\,\ Qinghai";
$areanames{en}->{861320979} = "Haixi\,\ Qinghai";
$areanames{en}->{861320980} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861320981} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861320982} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861320983} = "Datong\,\ Shanxi";
$areanames{en}->{861320984} = "Datong\,\ Shanxi";
$areanames{en}->{861320985} = "Changzhi\,\ Shanxi";
$areanames{en}->{861320986} = "Linfen\,\ Shanxi";
$areanames{en}->{861320987} = "Jincheng\,\ Shanxi";
$areanames{en}->{861320988} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861320989} = "Yuncheng\,\ Shanxi";
$areanames{en}->{86132099} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861320994} = "Changji\,\ Xinjiang";
$areanames{en}->{86132100} = "Qingdao\,\ Shandong";
$areanames{en}->{86132101} = "Qingdao\,\ Shandong";
$areanames{en}->{86132102} = "Qingdao\,\ Shandong";
$areanames{en}->{86132103} = "Dongying\,\ Shandong";
$areanames{en}->{861321040} = "Binzhou\,\ Shandong";
$areanames{en}->{861321041} = "Binzhou\,\ Shandong";
$areanames{en}->{861321042} = "Linyi\,\ Shandong";
$areanames{en}->{861321043} = "Linyi\,\ Shandong";
$areanames{en}->{861321044} = "Dezhou\,\ Shandong";
$areanames{en}->{861321045} = "Liaocheng\,\ Shandong";
$areanames{en}->{861321046} = "Liaocheng\,\ Shandong";
$areanames{en}->{861321047} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861321048} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861321049} = "Jining\,\ Shandong";
$areanames{en}->{86132105} = "Jinan\,\ Shandong";
$areanames{en}->{861321060} = "Laiwu\,\ Shandong";
$areanames{en}->{861321061} = "TaiAn\,\ Shandong";
$areanames{en}->{861321062} = "TaiAn\,\ Shandong";
$areanames{en}->{861321063} = "Rizhao\,\ Shandong";
$areanames{en}->{861321064} = "Rizhao\,\ Shandong";
$areanames{en}->{861321065} = "Linyi\,\ Shandong";
$areanames{en}->{861321066} = "Linyi\,\ Shandong";
$areanames{en}->{861321067} = "Zibo\,\ Shandong";
$areanames{en}->{861321068} = "Weifang\,\ Shandong";
$areanames{en}->{861321069} = "TaiAn\,\ Shandong";
$areanames{en}->{861321070} = "Binzhou\,\ Shandong";
$areanames{en}->{861321071} = "Binzhou\,\ Shandong";
$areanames{en}->{861321072} = "Binzhou\,\ Shandong";
$areanames{en}->{861321073} = "Weifang\,\ Shandong";
$areanames{en}->{861321074} = "Weifang\,\ Shandong";
$areanames{en}->{861321075} = "Weifang\,\ Shandong";
$areanames{en}->{861321076} = "Weifang\,\ Shandong";
$areanames{en}->{861321077} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861321078} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861321079} = "Jining\,\ Shandong";
$areanames{en}->{86132108} = "Qingdao\,\ Shandong";
$areanames{en}->{861321090} = "Weihai\,\ Shandong";
$areanames{en}->{861321091} = "Yantai\,\ Shandong";
$areanames{en}->{861321092} = "Yantai\,\ Shandong";
$areanames{en}->{861321093} = "Yantai\,\ Shandong";
$areanames{en}->{861321094} = "Yantai\,\ Shandong";
$areanames{en}->{861321095} = "Liaocheng\,\ Shandong";
$areanames{en}->{861321096} = "Liaocheng\,\ Shandong";
$areanames{en}->{861321097} = "Dezhou\,\ Shandong";
$areanames{en}->{861321098} = "Dezhou\,\ Shandong";
$areanames{en}->{861321099} = "Dezhou\,\ Shandong";
$areanames{en}->{861321100} = "Dongguan\,\ Guangdong";
$areanames{en}->{861321101} = "Dongguan\,\ Guangdong";
$areanames{en}->{861321102} = "Shanwei\,\ Guangdong";
$areanames{en}->{861321103} = "Shanwei\,\ Guangdong";
$areanames{en}->{861321104} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861321105} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861321106} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861321107} = "Xingtai\,\ Hebei";
$areanames{en}->{861321108} = "Xingtai\,\ Hebei";
$areanames{en}->{861321109} = "Xingtai\,\ Hebei";
$areanames{en}->{86132111} = "Foshan\,\ Guangdong";
$areanames{en}->{861321110} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861321111} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861321112} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86132112} = "Shantou\,\ Guangdong";
$areanames{en}->{861321126} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861321127} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861321128} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861321129} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86132113} = "Nanning\,\ Guangxi";
$areanames{en}->{861321140} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861321141} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861321142} = "Laibin\,\ Guangxi";
$areanames{en}->{861321143} = "Guilin\,\ Guangxi";
$areanames{en}->{861321144} = "Hezhou\,\ Guangxi";
$areanames{en}->{861321145} = "Yulin\,\ Guangxi";
$areanames{en}->{861321146} = "Baise\,\ Guangxi";
$areanames{en}->{861321147} = "Guigang\,\ Guangxi";
$areanames{en}->{861321148} = "Hechi\,\ Guangxi";
$areanames{en}->{861321149} = "Guigang\,\ Guangxi";
$areanames{en}->{861321150} = "Guilin\,\ Guangxi";
$areanames{en}->{861321151} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861321152} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861321153} = "Guilin\,\ Guangxi";
$areanames{en}->{861321154} = "Guilin\,\ Guangxi";
$areanames{en}->{861321155} = "Yulin\,\ Guangxi";
$areanames{en}->{861321156} = "Yulin\,\ Guangxi";
$areanames{en}->{861321157} = "Guigang\,\ Guangxi";
$areanames{en}->{861321158} = "Laibin\,\ Guangxi";
$areanames{en}->{861321159} = "Guilin\,\ Guangxi";
$areanames{en}->{86132116} = "Kunming\,\ Yunnan";
$areanames{en}->{86132117} = "Kunming\,\ Yunnan";
$areanames{en}->{861321180} = "Baoshan\,\ Yunnan";
$areanames{en}->{861321181} = "Wenshan\,\ Yunnan";
$areanames{en}->{861321182} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861321183} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861321184} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861321185} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861321186} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861321187} = "Qujing\,\ Yunnan";
$areanames{en}->{861321188} = "Qujing\,\ Yunnan";
$areanames{en}->{861321189} = "Qujing\,\ Yunnan";
$areanames{en}->{861321190} = "Dali\,\ Yunnan";
$areanames{en}->{861321191} = "Honghe\,\ Yunnan";
$areanames{en}->{861321192} = "Kunming\,\ Yunnan";
$areanames{en}->{861321193} = "Lincang\,\ Yunnan";
$areanames{en}->{861321194} = "Nujiang\,\ Yunnan";
$areanames{en}->{861321195} = "Yuxi\,\ Yunnan";
$areanames{en}->{861321196} = "Yuxi\,\ Yunnan";
$areanames{en}->{861321197} = "Deqen\,\ Yunnan";
$areanames{en}->{861321198} = "Puer\,\ Yunnan";
$areanames{en}->{861321199} = "Puer\,\ Yunnan";
$areanames{en}->{86132120} = "Tianjin";
$areanames{en}->{86132121} = "Tianjin";
$areanames{en}->{86132122} = "Tianjin";
$areanames{en}->{86132123} = "Chongqing";
$areanames{en}->{86132124} = "Chongqing";
$areanames{en}->{86132125} = "Chongqing";
$areanames{en}->{861321260} = "Xiangxi\,\ Hunan";
$areanames{en}->{861321261} = "Changsha\,\ Hunan";
$areanames{en}->{861321262} = "Changsha\,\ Hunan";
$areanames{en}->{861321263} = "Changsha\,\ Hunan";
$areanames{en}->{861321264} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861321265} = "Huaihua\,\ Hunan";
$areanames{en}->{861321266} = "Yongzhou\,\ Hunan";
$areanames{en}->{861321267} = "Loudi\,\ Hunan";
$areanames{en}->{861321268} = "Hengyang\,\ Hunan";
$areanames{en}->{861321269} = "Hengyang\,\ Hunan";
$areanames{en}->{86132127} = "Wuhan\,\ Hubei";
$areanames{en}->{861321280} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321281} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321282} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861321283} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861321284} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861321285} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861321286} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861321287} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861321288} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861321289} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861321290} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321291} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321292} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321293} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321294} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861321295} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861321296} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861321297} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861321298} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861321299} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{86132130} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132131} = "Zhengzhou\,\ Henan";
$areanames{en}->{861321320} = "Zhengzhou\,\ Henan";
$areanames{en}->{861321321} = "Zhengzhou\,\ Henan";
$areanames{en}->{861321322} = "Zhengzhou\,\ Henan";
$areanames{en}->{861321323} = "Zhengzhou\,\ Henan";
$areanames{en}->{861321324} = "Zhengzhou\,\ Henan";
$areanames{en}->{861321325} = "Anyang\,\ Henan";
$areanames{en}->{861321326} = "Anyang\,\ Henan";
$areanames{en}->{861321327} = "Anyang\,\ Henan";
$areanames{en}->{861321328} = "Anyang\,\ Henan";
$areanames{en}->{861321329} = "Anyang\,\ Henan";
$areanames{en}->{861321330} = "Zhoukou\,\ Henan";
$areanames{en}->{861321331} = "Zhoukou\,\ Henan";
$areanames{en}->{861321332} = "Zhoukou\,\ Henan";
$areanames{en}->{861321333} = "Zhoukou\,\ Henan";
$areanames{en}->{861321334} = "Zhoukou\,\ Henan";
$areanames{en}->{861321335} = "Xuchang\,\ Henan";
$areanames{en}->{861321336} = "Xuchang\,\ Henan";
$areanames{en}->{861321337} = "Xuchang\,\ Henan";
$areanames{en}->{861321338} = "Xuchang\,\ Henan";
$areanames{en}->{861321339} = "Xuchang\,\ Henan";
$areanames{en}->{861321340} = "Hebi\,\ Henan";
$areanames{en}->{861321341} = "Hebi\,\ Henan";
$areanames{en}->{861321342} = "Hebi\,\ Henan";
$areanames{en}->{861321343} = "Zhumadian\,\ Henan";
$areanames{en}->{861321344} = "Zhumadian\,\ Henan";
$areanames{en}->{861321345} = "Zhumadian\,\ Henan";
$areanames{en}->{861321346} = "Zhumadian\,\ Henan";
$areanames{en}->{861321347} = "Puyang\,\ Henan";
$areanames{en}->{861321348} = "Puyang\,\ Henan";
$areanames{en}->{861321349} = "Puyang\,\ Henan";
$areanames{en}->{86132135} = "Luoyang\,\ Henan";
$areanames{en}->{86132136} = "Luoyang\,\ Henan";
$areanames{en}->{86132137} = "Nanyang\,\ Henan";
$areanames{en}->{86132138} = "Pingdingshan\,\ Henan";
$areanames{en}->{861321386} = "Xinyang\,\ Henan";
$areanames{en}->{861321387} = "Xinyang\,\ Henan";
$areanames{en}->{861321388} = "Xinyang\,\ Henan";
$areanames{en}->{861321389} = "Xinyang\,\ Henan";
$areanames{en}->{86132139} = "Puyang\,\ Henan";
$areanames{en}->{861321397} = "Kaifeng\,\ Henan";
$areanames{en}->{861321398} = "Kaifeng\,\ Henan";
$areanames{en}->{861321399} = "Kaifeng\,\ Henan";
$areanames{en}->{86132140} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861321404} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861321407} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861321410} = "Tieling\,\ Liaoning";
$areanames{en}->{861321411} = "Dalian\,\ Liaoning";
$areanames{en}->{861321412} = "Anshan\,\ Liaoning";
$areanames{en}->{861321413} = "Fushun\,\ Liaoning";
$areanames{en}->{861321414} = "Benxi\,\ Liaoning";
$areanames{en}->{861321415} = "Dandong\,\ Liaoning";
$areanames{en}->{861321416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861321417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861321418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861321419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861321420} = "Dalian\,\ Liaoning";
$areanames{en}->{861321421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861321422} = "Dalian\,\ Liaoning";
$areanames{en}->{861321423} = "Shenyang\,\ Liaoning";
$areanames{en}->{861321424} = "Shenyang\,\ Liaoning";
$areanames{en}->{861321425} = "Shenyang\,\ Liaoning";
$areanames{en}->{861321426} = "Shenyang\,\ Liaoning";
$areanames{en}->{861321427} = "Panjin\,\ Liaoning";
$areanames{en}->{861321428} = "Dalian\,\ Liaoning";
$areanames{en}->{861321429} = "Huludao\,\ Liaoning";
$areanames{en}->{861321430} = "Changchun\,\ Jilin";
$areanames{en}->{861321431} = "Changchun\,\ Jilin";
$areanames{en}->{861321432} = "Jilin\,\ Jilin";
$areanames{en}->{861321433} = "Yanbian\,\ Jilin";
$areanames{en}->{861321434} = "Siping\,\ Jilin";
$areanames{en}->{861321435} = "Tonghua\,\ Jilin";
$areanames{en}->{861321436} = "Baicheng\,\ Jilin";
$areanames{en}->{861321437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861321438} = "Songyuan\,\ Jilin";
$areanames{en}->{861321439} = "Baishan\,\ Jilin";
$areanames{en}->{86132144} = "Changchun\,\ Jilin";
$areanames{en}->{861321444} = "Siping\,\ Jilin";
$areanames{en}->{861321445} = "Tonghua\,\ Jilin";
$areanames{en}->{861321450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861321453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861321454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861321455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861321456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861321457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861321458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861321459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861321460} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321461} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861321462} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861321463} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861321464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861321465} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861321466} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861321467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861321468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861321469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861321470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861321471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861321472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861321473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861321474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861321475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861321476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861321477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861321478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861321479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861321480} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861321481} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861321482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861321483} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861321484} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861321485} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861321486} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861321487} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861321488} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861321489} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{86132149} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861321497} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861321498} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861321499} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861321500} = "Fuzhou\,\ Fujian";
$areanames{en}->{861321501} = "Xiamen\,\ Fujian";
$areanames{en}->{861321502} = "Xiamen\,\ Fujian";
$areanames{en}->{861321503} = "Sanming\,\ Fujian";
$areanames{en}->{861321504} = "Fuzhou\,\ Fujian";
$areanames{en}->{861321505} = "Putian\,\ Fujian";
$areanames{en}->{861321506} = "Quanzhou\,\ Fujian";
$areanames{en}->{861321507} = "Quanzhou\,\ Fujian";
$areanames{en}->{861321508} = "Putian\,\ Fujian";
$areanames{en}->{861321509} = "Longyan\,\ Fujian";
$areanames{en}->{86132151} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132152} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132153} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132154} = "Langfang\,\ Hebei";
$areanames{en}->{861321542} = "Dongguan\,\ Guangdong";
$areanames{en}->{861321546} = "Dongguan\,\ Guangdong";
$areanames{en}->{861321550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861321551} = "Hefei\,\ Anhui";
$areanames{en}->{861321552} = "Bengbu\,\ Anhui";
$areanames{en}->{861321553} = "Wuhu\,\ Anhui";
$areanames{en}->{861321554} = "Huainan\,\ Anhui";
$areanames{en}->{861321555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861321556} = "Anqing\,\ Anhui";
$areanames{en}->{861321557} = "Suzhou\,\ Anhui";
$areanames{en}->{861321558} = "Fuyang\,\ Anhui";
$areanames{en}->{861321559} = "Huangshan\,\ Anhui";
$areanames{en}->{861321560} = "Hefei\,\ Anhui";
$areanames{en}->{861321561} = "Huaibei\,\ Anhui";
$areanames{en}->{861321562} = "Tongling\,\ Anhui";
$areanames{en}->{861321563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861321564} = "LuAn\,\ Anhui";
$areanames{en}->{861321565} = "Hefei\,\ Anhui";
$areanames{en}->{861321566} = "Chizhou\,\ Anhui";
$areanames{en}->{861321567} = "Bozhou\,\ Anhui";
$areanames{en}->{861321568} = "Fuyang\,\ Anhui";
$areanames{en}->{861321569} = "Hefei\,\ Anhui";
$areanames{en}->{86132157} = "Haikou\,\ Hainan";
$areanames{en}->{86132158} = "Haikou\,\ Hainan";
$areanames{en}->{861321590} = "Sanming\,\ Fujian";
$areanames{en}->{861321591} = "Xiamen\,\ Fujian";
$areanames{en}->{861321592} = "Xiamen\,\ Fujian";
$areanames{en}->{861321593} = "Nanping\,\ Fujian";
$areanames{en}->{861321594} = "Xiamen\,\ Fujian";
$areanames{en}->{861321595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861321596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861321597} = "Fuzhou\,\ Fujian";
$areanames{en}->{861321598} = "Fuzhou\,\ Fujian";
$areanames{en}->{861321599} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132160} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86132161} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86132162} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861321627} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861321628} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861321629} = "Quzhou\,\ Zhejiang";
$areanames{en}->{86132163} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861321640} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861321641} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861321642} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861321643} = "Lishui\,\ Zhejiang";
$areanames{en}->{861321644} = "Lishui\,\ Zhejiang";
$areanames{en}->{861321645} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861321646} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861321647} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861321648} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861321649} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86132165} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861321657} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861321658} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861321659} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{86132166} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861321670} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861321671} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861321672} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861321673} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861321674} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861321675} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861321676} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861321677} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861321678} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861321679} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861321680} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861321681} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861321682} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861321683} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861321684} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861321685} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861321686} = "Lishui\,\ Zhejiang";
$areanames{en}->{861321687} = "Lishui\,\ Zhejiang";
$areanames{en}->{861321688} = "Lishui\,\ Zhejiang";
$areanames{en}->{861321689} = "Lishui\,\ Zhejiang";
$areanames{en}->{86132169} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861321700} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861321701} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861321702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861321703} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861321704} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861321705} = "Yichun\,\ Jiangxi";
$areanames{en}->{861321706} = "JiAn\,\ Jiangxi";
$areanames{en}->{861321707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861321708} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861321709} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861321710} = "Xiangfan\,\ Hubei";
$areanames{en}->{861321711} = "Ezhou\,\ Hubei";
$areanames{en}->{861321712} = "Xiaogan\,\ Hubei";
$areanames{en}->{861321713} = "Huanggang\,\ Hubei";
$areanames{en}->{861321714} = "Huangshi\,\ Hubei";
$areanames{en}->{861321715} = "Xianning\,\ Hubei";
$areanames{en}->{861321716} = "Jingzhou\,\ Hubei";
$areanames{en}->{861321717} = "Yichang\,\ Hubei";
$areanames{en}->{861321718} = "Enshi\,\ Hubei";
$areanames{en}->{861321719} = "Shiyan\,\ Hubei";
$areanames{en}->{861321720} = "Xiangfan\,\ Hubei";
$areanames{en}->{861321721} = "Xiaogan\,\ Hubei";
$areanames{en}->{861321722} = "Suizhou\,\ Hubei";
$areanames{en}->{861321723} = "Huanggang\,\ Hubei";
$areanames{en}->{861321724} = "Jingmen\,\ Hubei";
$areanames{en}->{861321725} = "Huanggang\,\ Hubei";
$areanames{en}->{861321726} = "Jingzhou\,\ Hubei";
$areanames{en}->{861321727} = "Yichang\,\ Hubei";
$areanames{en}->{861321728} = "Enshi\,\ Hubei";
$areanames{en}->{861321729} = "Jingzhou\,\ Hubei";
$areanames{en}->{861321730} = "Yueyang\,\ Hunan";
$areanames{en}->{861321731} = "Changsha\,\ Hunan";
$areanames{en}->{861321732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861321733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861321734} = "Hengyang\,\ Hunan";
$areanames{en}->{861321735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861321736} = "Changde\,\ Hunan";
$areanames{en}->{861321737} = "Yiyang\,\ Hunan";
$areanames{en}->{861321738} = "Loudi\,\ Hunan";
$areanames{en}->{861321739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861321740} = "Yueyang\,\ Hunan";
$areanames{en}->{861321741} = "Changsha\,\ Hunan";
$areanames{en}->{861321742} = "Xiangtan\,\ Hunan";
$areanames{en}->{861321743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861321744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861321745} = "Huaihua\,\ Hunan";
$areanames{en}->{861321746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861321747} = "Huaihua\,\ Hunan";
$areanames{en}->{861321748} = "Changsha\,\ Hunan";
$areanames{en}->{861321749} = "Shaoyang\,\ Hunan";
$areanames{en}->{861321750} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861321751} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861321752} = "Huizhou\,\ Guangdong";
$areanames{en}->{861321753} = "Meizhou\,\ Guangdong";
$areanames{en}->{861321754} = "Shantou\,\ Guangdong";
$areanames{en}->{861321755} = "Shantou\,\ Guangdong";
$areanames{en}->{861321756} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861321757} = "Foshan\,\ Guangdong";
$areanames{en}->{861321758} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861321759} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861321760} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861321761} = "Heyuan\,\ Guangdong";
$areanames{en}->{861321762} = "Heyuan\,\ Guangdong";
$areanames{en}->{861321763} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861321764} = "Foshan\,\ Guangdong";
$areanames{en}->{861321765} = "Foshan\,\ Guangdong";
$areanames{en}->{861321766} = "Yunfu\,\ Guangdong";
$areanames{en}->{861321767} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861321768} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861321769} = "Dongguan\,\ Guangdong";
$areanames{en}->{861321770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861321771} = "Nanning\,\ Guangxi";
$areanames{en}->{861321772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861321773} = "Guilin\,\ Guangxi";
$areanames{en}->{861321774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861321775} = "Yulin\,\ Guangxi";
$areanames{en}->{861321776} = "Baise\,\ Guangxi";
$areanames{en}->{861321777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861321778} = "Hechi\,\ Guangxi";
$areanames{en}->{861321779} = "Beihai\,\ Guangxi";
$areanames{en}->{861321780} = "Nanning\,\ Guangxi";
$areanames{en}->{861321781} = "Nanning\,\ Guangxi";
$areanames{en}->{861321782} = "Laibin\,\ Guangxi";
$areanames{en}->{861321783} = "Guilin\,\ Guangxi";
$areanames{en}->{861321784} = "Hezhou\,\ Guangxi";
$areanames{en}->{861321785} = "Yulin\,\ Guangxi";
$areanames{en}->{861321786} = "Baise\,\ Guangxi";
$areanames{en}->{861321787} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861321788} = "Hechi\,\ Guangxi";
$areanames{en}->{861321789} = "Hezhou\,\ Guangxi";
$areanames{en}->{861321790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861321791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861321792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861321793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861321794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861321795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861321796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861321797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861321798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861321799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86132180} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86132181} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86132182} = "Nantong\,\ Jiangsu";
$areanames{en}->{86132183} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861321830} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861321831} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861321832} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861321833} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861321840} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861321841} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861321842} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861321843} = "Nantong\,\ Jiangsu";
$areanames{en}->{861321844} = "Nantong\,\ Jiangsu";
$areanames{en}->{861321845} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861321846} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861321847} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861321848} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861321849} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86132185} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861321850} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861321851} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861321852} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86132186} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861321860} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861321861} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861321862} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861321863} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86132187} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861321870} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861321871} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861321872} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861321880} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861321881} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861321882} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861321883} = "Nantong\,\ Jiangsu";
$areanames{en}->{861321884} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861321885} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861321886} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861321887} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861321888} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861321889} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86132189} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861321890} = "Suqian\,\ Jiangsu";
$areanames{en}->{861321891} = "Suqian\,\ Jiangsu";
$areanames{en}->{861321892} = "Suqian\,\ Jiangsu";
$areanames{en}->{861321893} = "Suqian\,\ Jiangsu";
$areanames{en}->{86132190} = "Chengdu\,\ Sichuan";
$areanames{en}->{86132191} = "Nanchong\,\ Sichuan";
$areanames{en}->{861321916} = "Dazhou\,\ Sichuan";
$areanames{en}->{861321917} = "Dazhou\,\ Sichuan";
$areanames{en}->{861321918} = "Dazhou\,\ Sichuan";
$areanames{en}->{861321919} = "Dazhou\,\ Sichuan";
$areanames{en}->{861321920} = "Suining\,\ Sichuan";
$areanames{en}->{861321921} = "Suining\,\ Sichuan";
$areanames{en}->{861321922} = "Suining\,\ Sichuan";
$areanames{en}->{861321923} = "Suining\,\ Sichuan";
$areanames{en}->{861321924} = "GuangAn\,\ Sichuan";
$areanames{en}->{861321925} = "GuangAn\,\ Sichuan";
$areanames{en}->{861321926} = "GuangAn\,\ Sichuan";
$areanames{en}->{861321927} = "GuangAn\,\ Sichuan";
$areanames{en}->{861321928} = "Bazhong\,\ Sichuan";
$areanames{en}->{861321929} = "Bazhong\,\ Sichuan";
$areanames{en}->{86132193} = "Luzhou\,\ Sichuan";
$areanames{en}->{861321930} = "Bazhong\,\ Sichuan";
$areanames{en}->{861321931} = "Bazhong\,\ Sichuan";
$areanames{en}->{861321932} = "Bazhong\,\ Sichuan";
$areanames{en}->{861321939} = "Yibin\,\ Sichuan";
$areanames{en}->{861321940} = "Nanchong\,\ Sichuan";
$areanames{en}->{861321941} = "Dazhou\,\ Sichuan";
$areanames{en}->{861321942} = "Neijiang\,\ Sichuan";
$areanames{en}->{861321943} = "Ziyang\,\ Sichuan";
$areanames{en}->{861321944} = "Leshan\,\ Sichuan";
$areanames{en}->{861321945} = "Meishan\,\ Sichuan";
$areanames{en}->{861321946} = "Garze\,\ Sichuan";
$areanames{en}->{861321947} = "Deyang\,\ Sichuan";
$areanames{en}->{861321948} = "Mianyang\,\ Sichuan";
$areanames{en}->{861321949} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861321950} = "Yibin\,\ Sichuan";
$areanames{en}->{861321951} = "Yibin\,\ Sichuan";
$areanames{en}->{861321952} = "Yibin\,\ Sichuan";
$areanames{en}->{861321953} = "Yibin\,\ Sichuan";
$areanames{en}->{861321954} = "Yibin\,\ Sichuan";
$areanames{en}->{861321955} = "Neijiang\,\ Sichuan";
$areanames{en}->{861321956} = "Neijiang\,\ Sichuan";
$areanames{en}->{861321957} = "Neijiang\,\ Sichuan";
$areanames{en}->{861321958} = "Neijiang\,\ Sichuan";
$areanames{en}->{861321959} = "Ziyang\,\ Sichuan";
$areanames{en}->{861321960} = "Yulin\,\ Shaanxi";
$areanames{en}->{861321961} = "Yulin\,\ Shaanxi";
$areanames{en}->{861321962} = "Yulin\,\ Shaanxi";
$areanames{en}->{861321963} = "Zigong\,\ Sichuan";
$areanames{en}->{861321964} = "Zigong\,\ Sichuan";
$areanames{en}->{861321965} = "Zigong\,\ Sichuan";
$areanames{en}->{861321966} = "Zigong\,\ Sichuan";
$areanames{en}->{861321967} = "Leshan\,\ Sichuan";
$areanames{en}->{861321968} = "Leshan\,\ Sichuan";
$areanames{en}->{861321969} = "Leshan\,\ Sichuan";
$areanames{en}->{861321970} = "Leshan\,\ Sichuan";
$areanames{en}->{861321971} = "Leshan\,\ Sichuan";
$areanames{en}->{861321972} = "Leshan\,\ Sichuan";
$areanames{en}->{861321973} = "Meishan\,\ Sichuan";
$areanames{en}->{861321974} = "Meishan\,\ Sichuan";
$areanames{en}->{861321975} = "Meishan\,\ Sichuan";
$areanames{en}->{861321976} = "Meishan\,\ Sichuan";
$areanames{en}->{861321977} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861321978} = "YaAn\,\ Sichuan";
$areanames{en}->{861321979} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861321980} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861321981} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861321982} = "Weinan\,\ Shaanxi";
$areanames{en}->{861321983} = "Yibin\,\ Sichuan";
$areanames{en}->{861321984} = "Aba\,\ Sichuan";
$areanames{en}->{861321985} = "Deyang\,\ Sichuan";
$areanames{en}->{861321986} = "Deyang\,\ Sichuan";
$areanames{en}->{861321987} = "Deyang\,\ Sichuan";
$areanames{en}->{861321988} = "Deyang\,\ Sichuan";
$areanames{en}->{861321989} = "Deyang\,\ Sichuan";
$areanames{en}->{86132199} = "Mianyang\,\ Sichuan";
$areanames{en}->{861321990} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861321991} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861321992} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861322000} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861322001} = "YanAn\,\ Shaanxi";
$areanames{en}->{861322002} = "Yulin\,\ Shaanxi";
$areanames{en}->{861322003} = "Weinan\,\ Shaanxi";
$areanames{en}->{861322004} = "Weinan\,\ Shaanxi";
$areanames{en}->{861322005} = "Weinan\,\ Shaanxi";
$areanames{en}->{861322006} = "YanAn\,\ Shaanxi";
$areanames{en}->{861322007} = "Baoji\,\ Shaanxi";
$areanames{en}->{861322008} = "YanAn\,\ Shaanxi";
$areanames{en}->{861322009} = "Baoji\,\ Shaanxi";
$areanames{en}->{86132201} = "Beijing";
$areanames{en}->{86132202} = "Chongqing";
$areanames{en}->{86132203} = "Chongqing";
$areanames{en}->{861322040} = "Lanzhou\,\ Gansu";
$areanames{en}->{861322041} = "Baiyin\,\ Gansu";
$areanames{en}->{861322042} = "Pingliang\,\ Gansu";
$areanames{en}->{861322043} = "Tianshui\,\ Gansu";
$areanames{en}->{861322044} = "Zhangye\,\ Gansu";
$areanames{en}->{861322045} = "Lanzhou\,\ Gansu";
$areanames{en}->{861322046} = "Lanzhou\,\ Gansu";
$areanames{en}->{861322047} = "Linxia\,\ Gansu";
$areanames{en}->{861322048} = "Lanzhou\,\ Gansu";
$areanames{en}->{861322049} = "Linxia\,\ Gansu";
$areanames{en}->{861322050} = "Dongying\,\ Shandong";
$areanames{en}->{861322051} = "Dongying\,\ Shandong";
$areanames{en}->{861322052} = "Dongying\,\ Shandong";
$areanames{en}->{861322053} = "Linyi\,\ Shandong";
$areanames{en}->{861322054} = "Linyi\,\ Shandong";
$areanames{en}->{861322055} = "Jinan\,\ Shandong";
$areanames{en}->{861322056} = "Jinan\,\ Shandong";
$areanames{en}->{861322057} = "Jinan\,\ Shandong";
$areanames{en}->{861322058} = "Jinan\,\ Shandong";
$areanames{en}->{861322059} = "Jinan\,\ Shandong";
$areanames{en}->{861322060} = "Laiwu\,\ Shandong";
$areanames{en}->{861322061} = "TaiAn\,\ Shandong";
$areanames{en}->{861322062} = "TaiAn\,\ Shandong";
$areanames{en}->{861322063} = "Rizhao\,\ Shandong";
$areanames{en}->{861322064} = "Rizhao\,\ Shandong";
$areanames{en}->{861322065} = "Linyi\,\ Shandong";
$areanames{en}->{861322066} = "Linyi\,\ Shandong";
$areanames{en}->{861322067} = "Zibo\,\ Shandong";
$areanames{en}->{861322068} = "Zibo\,\ Shandong";
$areanames{en}->{861322069} = "Zibo\,\ Shandong";
$areanames{en}->{861322070} = "Binzhou\,\ Shandong";
$areanames{en}->{861322071} = "Binzhou\,\ Shandong";
$areanames{en}->{861322072} = "Binzhou\,\ Shandong";
$areanames{en}->{861322073} = "Weifang\,\ Shandong";
$areanames{en}->{861322074} = "Weifang\,\ Shandong";
$areanames{en}->{861322075} = "Weifang\,\ Shandong";
$areanames{en}->{861322076} = "Weifang\,\ Shandong";
$areanames{en}->{861322077} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861322078} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861322079} = "Jining\,\ Shandong";
$areanames{en}->{861322080} = "Jining\,\ Shandong";
$areanames{en}->{861322081} = "Jining\,\ Shandong";
$areanames{en}->{861322082} = "Weihai\,\ Shandong";
$areanames{en}->{861322083} = "Weihai\,\ Shandong";
$areanames{en}->{861322084} = "Weihai\,\ Shandong";
$areanames{en}->{861322085} = "Qingdao\,\ Shandong";
$areanames{en}->{861322086} = "Qingdao\,\ Shandong";
$areanames{en}->{861322087} = "Qingdao\,\ Shandong";
$areanames{en}->{861322088} = "Qingdao\,\ Shandong";
$areanames{en}->{861322089} = "Qingdao\,\ Shandong";
$areanames{en}->{861322090} = "Weihai\,\ Shandong";
$areanames{en}->{861322091} = "Yantai\,\ Shandong";
$areanames{en}->{861322092} = "Yantai\,\ Shandong";
$areanames{en}->{861322093} = "Yantai\,\ Shandong";
$areanames{en}->{861322094} = "Yantai\,\ Shandong";
$areanames{en}->{861322095} = "Liaocheng\,\ Shandong";
$areanames{en}->{861322096} = "Liaocheng\,\ Shandong";
$areanames{en}->{861322097} = "Dezhou\,\ Shandong";
$areanames{en}->{861322098} = "Dezhou\,\ Shandong";
$areanames{en}->{861322099} = "Dezhou\,\ Shandong";
$areanames{en}->{86132210} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86132211} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861322120} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861322121} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861322122} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861322123} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861322124} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861322125} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861322126} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861322127} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861322128} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861322129} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86132213} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861322140} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861322141} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861322142} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861322143} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861322144} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861322145} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861322146} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861322147} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861322148} = "Lishui\,\ Zhejiang";
$areanames{en}->{861322149} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86132215} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86132216} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861322170} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861322171} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861322172} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861322173} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861322174} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861322175} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861322176} = "Lishui\,\ Zhejiang";
$areanames{en}->{861322177} = "Lishui\,\ Zhejiang";
$areanames{en}->{861322178} = "Lishui\,\ Zhejiang";
$areanames{en}->{861322179} = "Lishui\,\ Zhejiang";
$areanames{en}->{861322180} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861322181} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861322182} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861322183} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861322184} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861322185} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861322186} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861322187} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861322188} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861322189} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86132219} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86132220} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86132221} = "Nantong\,\ Jiangsu";
$areanames{en}->{86132222} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86132223} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861322230} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861322231} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861322240} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322241} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861322242} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861322243} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861322244} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861322245} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861322246} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861322247} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861322248} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861322249} = "Nantong\,\ Jiangsu";
$areanames{en}->{86132225} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861322254} = "Shaoyang\,\ Hunan";
$areanames{en}->{86132226} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861322266} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861322267} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861322268} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861322269} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{86132227} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861322270} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861322271} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{86132228} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322290} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322291} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322292} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322293} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322294} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322295} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861322296} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861322297} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861322298} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861322299} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86132230} = "Zhengzhou\,\ Henan";
$areanames{en}->{861322300} = "Shangqiu\,\ Henan";
$areanames{en}->{861322310} = "Handan\,\ Hebei";
$areanames{en}->{861322311} = "Handan\,\ Hebei";
$areanames{en}->{861322312} = "Handan\,\ Hebei";
$areanames{en}->{861322313} = "Handan\,\ Hebei";
$areanames{en}->{861322314} = "Handan\,\ Hebei";
$areanames{en}->{861322315} = "Tangshan\,\ Hebei";
$areanames{en}->{861322316} = "Tangshan\,\ Hebei";
$areanames{en}->{861322317} = "Tangshan\,\ Hebei";
$areanames{en}->{861322318} = "Tangshan\,\ Hebei";
$areanames{en}->{861322319} = "Tangshan\,\ Hebei";
$areanames{en}->{861322320} = "Baoding\,\ Hebei";
$areanames{en}->{861322321} = "Baoding\,\ Hebei";
$areanames{en}->{861322322} = "Baoding\,\ Hebei";
$areanames{en}->{861322323} = "Baoding\,\ Hebei";
$areanames{en}->{861322324} = "Baoding\,\ Hebei";
$areanames{en}->{861322325} = "Xingtai\,\ Hebei";
$areanames{en}->{861322326} = "Xingtai\,\ Hebei";
$areanames{en}->{861322327} = "Xingtai\,\ Hebei";
$areanames{en}->{861322328} = "Xingtai\,\ Hebei";
$areanames{en}->{861322329} = "Xingtai\,\ Hebei";
$areanames{en}->{86132233} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86132234} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861322350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861322351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861322352} = "Datong\,\ Shanxi";
$areanames{en}->{861322353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861322354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861322355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861322356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861322357} = "Linfen\,\ Shanxi";
$areanames{en}->{861322358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861322359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861322360} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861322361} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861322362} = "Datong\,\ Shanxi";
$areanames{en}->{861322363} = "Yangquan\,\ Shanxi";
$areanames{en}->{861322364} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861322365} = "Changzhi\,\ Shanxi";
$areanames{en}->{861322366} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861322367} = "Jincheng\,\ Shanxi";
$areanames{en}->{861322368} = "Linfen\,\ Shanxi";
$areanames{en}->{861322369} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861322370} = "Shangqiu\,\ Henan";
$areanames{en}->{861322371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861322372} = "Anyang\,\ Henan";
$areanames{en}->{861322373} = "Xinxiang\,\ Henan";
$areanames{en}->{861322374} = "Xinxiang\,\ Henan";
$areanames{en}->{861322375} = "Xinxiang\,\ Henan";
$areanames{en}->{861322376} = "Xinxiang\,\ Henan";
$areanames{en}->{861322377} = "Xinxiang\,\ Henan";
$areanames{en}->{861322378} = "Kaifeng\,\ Henan";
$areanames{en}->{861322379} = "Kaifeng\,\ Henan";
$areanames{en}->{86132238} = "Zhumadian\,\ Henan";
$areanames{en}->{861322380} = "Kaifeng\,\ Henan";
$areanames{en}->{861322390} = "Shangqiu\,\ Henan";
$areanames{en}->{861322391} = "Jiaozuo\,\ Henan";
$areanames{en}->{861322392} = "Jiaozuo\,\ Henan";
$areanames{en}->{861322393} = "Puyang\,\ Henan";
$areanames{en}->{861322394} = "Zhoukou\,\ Henan";
$areanames{en}->{861322395} = "Zhoukou\,\ Henan";
$areanames{en}->{861322396} = "Zhumadian\,\ Henan";
$areanames{en}->{861322397} = "Puyang\,\ Henan";
$areanames{en}->{861322398} = "Puyang\,\ Henan";
$areanames{en}->{861322399} = "Anyang\,\ Henan";
$areanames{en}->{86132240} = "Chongqing";
$areanames{en}->{861322410} = "Tieling\,\ Liaoning";
$areanames{en}->{861322411} = "Dalian\,\ Liaoning";
$areanames{en}->{861322412} = "Anshan\,\ Liaoning";
$areanames{en}->{861322413} = "Fushun\,\ Liaoning";
$areanames{en}->{861322414} = "Benxi\,\ Liaoning";
$areanames{en}->{861322415} = "Dandong\,\ Liaoning";
$areanames{en}->{861322416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861322417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861322418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861322419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861322420} = "Dalian\,\ Liaoning";
$areanames{en}->{861322421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861322422} = "Dalian\,\ Liaoning";
$areanames{en}->{861322423} = "Shenyang\,\ Liaoning";
$areanames{en}->{861322424} = "Shenyang\,\ Liaoning";
$areanames{en}->{861322425} = "Shenyang\,\ Liaoning";
$areanames{en}->{861322426} = "Shenyang\,\ Liaoning";
$areanames{en}->{861322427} = "Panjin\,\ Liaoning";
$areanames{en}->{861322428} = "Dalian\,\ Liaoning";
$areanames{en}->{861322429} = "Huludao\,\ Liaoning";
$areanames{en}->{861322430} = "Changchun\,\ Jilin";
$areanames{en}->{861322431} = "Changchun\,\ Jilin";
$areanames{en}->{861322432} = "Jilin\,\ Jilin";
$areanames{en}->{861322433} = "Yanbian\,\ Jilin";
$areanames{en}->{861322434} = "Siping\,\ Jilin";
$areanames{en}->{861322435} = "Tonghua\,\ Jilin";
$areanames{en}->{861322436} = "Baicheng\,\ Jilin";
$areanames{en}->{861322437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861322438} = "Songyuan\,\ Jilin";
$areanames{en}->{861322439} = "Baishan\,\ Jilin";
$areanames{en}->{861322440} = "Siping\,\ Jilin";
$areanames{en}->{861322441} = "Siping\,\ Jilin";
$areanames{en}->{861322442} = "Jilin\,\ Jilin";
$areanames{en}->{861322443} = "Yanbian\,\ Jilin";
$areanames{en}->{861322444} = "Siping\,\ Jilin";
$areanames{en}->{861322445} = "Tonghua\,\ Jilin";
$areanames{en}->{861322446} = "Baicheng\,\ Jilin";
$areanames{en}->{861322447} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861322448} = "Songyuan\,\ Jilin";
$areanames{en}->{861322449} = "Baishan\,\ Jilin";
$areanames{en}->{861322450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861322451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861322452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861322453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861322454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861322455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861322456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861322457} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861322458} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861322459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861322460} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861322461} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861322462} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861322463} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861322464} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861322465} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861322466} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861322467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861322468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861322469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861322470} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861322471} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861322472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861322473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861322474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861322475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861322476} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861322477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861322478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861322479} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861322480} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861322481} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861322482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861322483} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861322484} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861322485} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861322486} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861322487} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861322488} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861322489} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{86132249} = "Chongqing";
$areanames{en}->{861322500} = "Quanzhou\,\ Fujian";
$areanames{en}->{861322501} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861322502} = "Sanming\,\ Fujian";
$areanames{en}->{861322503} = "Xiamen\,\ Fujian";
$areanames{en}->{861322504} = "Ningde\,\ Fujian";
$areanames{en}->{861322505} = "Sanming\,\ Fujian";
$areanames{en}->{861322506} = "Putian\,\ Fujian";
$areanames{en}->{861322507} = "Xiamen\,\ Fujian";
$areanames{en}->{861322508} = "Xiamen\,\ Fujian";
$areanames{en}->{861322509} = "Putian\,\ Fujian";
$areanames{en}->{861322510} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861322511} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861322512} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861322513} = "Nantong\,\ Jiangsu";
$areanames{en}->{861322514} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861322515} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861322516} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861322517} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861322518} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861322519} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86132252} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861322520} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861322521} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861322530} = "Heze\,\ Shandong";
$areanames{en}->{861322531} = "Jinan\,\ Shandong";
$areanames{en}->{861322532} = "Qingdao\,\ Shandong";
$areanames{en}->{861322533} = "Zibo\,\ Shandong";
$areanames{en}->{861322534} = "Dezhou\,\ Shandong";
$areanames{en}->{861322535} = "Yantai\,\ Shandong";
$areanames{en}->{861322536} = "Weifang\,\ Shandong";
$areanames{en}->{861322537} = "Jining\,\ Shandong";
$areanames{en}->{861322538} = "TaiAn\,\ Shandong";
$areanames{en}->{861322539} = "Linyi\,\ Shandong";
$areanames{en}->{861322540} = "Heze\,\ Shandong";
$areanames{en}->{861322541} = "Jinan\,\ Shandong";
$areanames{en}->{861322542} = "Qingdao\,\ Shandong";
$areanames{en}->{861322543} = "Binzhou\,\ Shandong";
$areanames{en}->{861322544} = "Dezhou\,\ Shandong";
$areanames{en}->{861322545} = "Yantai\,\ Shandong";
$areanames{en}->{861322546} = "Dongying\,\ Shandong";
$areanames{en}->{861322547} = "Jining\,\ Shandong";
$areanames{en}->{861322548} = "TaiAn\,\ Shandong";
$areanames{en}->{861322549} = "Linyi\,\ Shandong";
$areanames{en}->{861322550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861322551} = "Hefei\,\ Anhui";
$areanames{en}->{861322552} = "Bengbu\,\ Anhui";
$areanames{en}->{861322553} = "Wuhu\,\ Anhui";
$areanames{en}->{861322554} = "Huainan\,\ Anhui";
$areanames{en}->{861322555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861322556} = "Anqing\,\ Anhui";
$areanames{en}->{861322557} = "Suzhou\,\ Anhui";
$areanames{en}->{861322558} = "Fuyang\,\ Anhui";
$areanames{en}->{861322559} = "Huangshan\,\ Anhui";
$areanames{en}->{861322560} = "Hefei\,\ Anhui";
$areanames{en}->{861322561} = "Huaibei\,\ Anhui";
$areanames{en}->{861322562} = "Tongling\,\ Anhui";
$areanames{en}->{861322563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861322564} = "LuAn\,\ Anhui";
$areanames{en}->{861322565} = "Hefei\,\ Anhui";
$areanames{en}->{861322566} = "Chizhou\,\ Anhui";
$areanames{en}->{861322567} = "Bozhou\,\ Anhui";
$areanames{en}->{861322568} = "Fuyang\,\ Anhui";
$areanames{en}->{861322569} = "Hefei\,\ Anhui";
$areanames{en}->{86132257} = "Anqing\,\ Anhui";
$areanames{en}->{861322575} = "Hefei\,\ Anhui";
$areanames{en}->{861322577} = "Suzhou\,\ Anhui";
$areanames{en}->{861322579} = "Huangshan\,\ Anhui";
$areanames{en}->{86132258} = "LuAn\,\ Anhui";
$areanames{en}->{861322585} = "Hefei\,\ Anhui";
$areanames{en}->{861322587} = "Bozhou\,\ Anhui";
$areanames{en}->{861322589} = "Hefei\,\ Anhui";
$areanames{en}->{861322590} = "Nanping\,\ Fujian";
$areanames{en}->{861322591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861322592} = "Xiamen\,\ Fujian";
$areanames{en}->{861322593} = "Longyan\,\ Fujian";
$areanames{en}->{861322594} = "Fuzhou\,\ Fujian";
$areanames{en}->{861322595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861322596} = "Xiamen\,\ Fujian";
$areanames{en}->{861322597} = "Nanping\,\ Fujian";
$areanames{en}->{861322598} = "Quanzhou\,\ Fujian";
$areanames{en}->{861322599} = "Fuzhou\,\ Fujian";
$areanames{en}->{86132260} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322606} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861322607} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861322608} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861322609} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861322610} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861322611} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861322612} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861322613} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861322614} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861322615} = "Jieyang\,\ Guangdong";
$areanames{en}->{861322616} = "Jieyang\,\ Guangdong";
$areanames{en}->{861322617} = "Jieyang\,\ Guangdong";
$areanames{en}->{861322618} = "Jieyang\,\ Guangdong";
$areanames{en}->{861322619} = "Jieyang\,\ Guangdong";
$areanames{en}->{861322620} = "Meizhou\,\ Guangdong";
$areanames{en}->{861322621} = "Meizhou\,\ Guangdong";
$areanames{en}->{861322622} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861322623} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861322624} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861322625} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861322626} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861322627} = "Maoming\,\ Guangdong";
$areanames{en}->{861322628} = "Maoming\,\ Guangdong";
$areanames{en}->{861322629} = "Maoming\,\ Guangdong";
$areanames{en}->{861322630} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322631} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322632} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322633} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322634} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322635} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861322636} = "Yunfu\,\ Guangdong";
$areanames{en}->{861322637} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861322638} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861322639} = "Yangjiang\,\ Guangdong";
$areanames{en}->{86132264} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861322646} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861322647} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861322648} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322649} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322650} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322651} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322652} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322653} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322654} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322655} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322656} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322657} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322658} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322659} = "Qingyuan\,\ Guangdong";
$areanames{en}->{86132266} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861322670} = "Foshan\,\ Guangdong";
$areanames{en}->{861322671} = "Foshan\,\ Guangdong";
$areanames{en}->{861322672} = "Foshan\,\ Guangdong";
$areanames{en}->{861322673} = "Foshan\,\ Guangdong";
$areanames{en}->{861322674} = "Shanwei\,\ Guangdong";
$areanames{en}->{861322675} = "Shanwei\,\ Guangdong";
$areanames{en}->{861322676} = "Heyuan\,\ Guangdong";
$areanames{en}->{861322677} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861322678} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861322679} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861322680} = "Shantou\,\ Guangdong";
$areanames{en}->{861322681} = "Shantou\,\ Guangdong";
$areanames{en}->{861322682} = "Shantou\,\ Guangdong";
$areanames{en}->{861322683} = "Shantou\,\ Guangdong";
$areanames{en}->{861322684} = "Shantou\,\ Guangdong";
$areanames{en}->{861322685} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861322686} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861322687} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861322688} = "Shanwei\,\ Guangdong";
$areanames{en}->{861322689} = "Heyuan\,\ Guangdong";
$areanames{en}->{86132269} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861322696} = "Foshan\,\ Guangdong";
$areanames{en}->{861322697} = "Foshan\,\ Guangdong";
$areanames{en}->{861322698} = "Foshan\,\ Guangdong";
$areanames{en}->{861322699} = "Foshan\,\ Guangdong";
$areanames{en}->{86132270} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132271} = "Xiaogan\,\ Hubei";
$areanames{en}->{861322710} = "Ezhou\,\ Hubei";
$areanames{en}->{861322711} = "Ezhou\,\ Hubei";
$areanames{en}->{861322720} = "Xianning\,\ Hubei";
$areanames{en}->{861322721} = "Xianning\,\ Hubei";
$areanames{en}->{861322722} = "Suizhou\,\ Hubei";
$areanames{en}->{861322723} = "Xianning\,\ Hubei";
$areanames{en}->{861322724} = "Shiyan\,\ Hubei";
$areanames{en}->{861322725} = "Yichang\,\ Hubei";
$areanames{en}->{861322726} = "Yichang\,\ Hubei";
$areanames{en}->{861322727} = "Yichang\,\ Hubei";
$areanames{en}->{861322728} = "Yichang\,\ Hubei";
$areanames{en}->{861322729} = "Yichang\,\ Hubei";
$areanames{en}->{86132273} = "Huanggang\,\ Hubei";
$areanames{en}->{861322730} = "Xiaogan\,\ Hubei";
$areanames{en}->{86132274} = "Enshi\,\ Hubei";
$areanames{en}->{86132275} = "Xiangfan\,\ Hubei";
$areanames{en}->{86132276} = "Jingzhou\,\ Hubei";
$areanames{en}->{861322760} = "Shiyan\,\ Hubei";
$areanames{en}->{861322761} = "Shiyan\,\ Hubei";
$areanames{en}->{86132277} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132278} = "XiAn\,\ Shaanxi";
$areanames{en}->{861322790} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861322791} = "YanAn\,\ Shaanxi";
$areanames{en}->{861322792} = "Yulin\,\ Shaanxi";
$areanames{en}->{861322793} = "Weinan\,\ Shaanxi";
$areanames{en}->{861322794} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861322795} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861322796} = "YanAn\,\ Shaanxi";
$areanames{en}->{861322797} = "Baoji\,\ Shaanxi";
$areanames{en}->{861322798} = "YanAn\,\ Shaanxi";
$areanames{en}->{861322799} = "Yulin\,\ Shaanxi";
$areanames{en}->{86132280} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132281} = "Chengdu\,\ Sichuan";
$areanames{en}->{861322820} = "Chengdu\,\ Sichuan";
$areanames{en}->{861322821} = "Chengdu\,\ Sichuan";
$areanames{en}->{861322822} = "Chengdu\,\ Sichuan";
$areanames{en}->{861322823} = "Mianyang\,\ Sichuan";
$areanames{en}->{861322824} = "Mianyang\,\ Sichuan";
$areanames{en}->{861322825} = "Nanchong\,\ Sichuan";
$areanames{en}->{861322826} = "Nanchong\,\ Sichuan";
$areanames{en}->{861322827} = "Dazhou\,\ Sichuan";
$areanames{en}->{861322828} = "Dazhou\,\ Sichuan";
$areanames{en}->{861322829} = "Weinan\,\ Shaanxi";
$areanames{en}->{861322830} = "GuangAn\,\ Sichuan";
$areanames{en}->{861322831} = "Yibin\,\ Sichuan";
$areanames{en}->{861322832} = "Yibin\,\ Sichuan";
$areanames{en}->{861322833} = "Deyang\,\ Sichuan";
$areanames{en}->{861322834} = "Bazhong\,\ Sichuan";
$areanames{en}->{861322835} = "Neijiang\,\ Sichuan";
$areanames{en}->{861322836} = "Yulin\,\ Shaanxi";
$areanames{en}->{861322837} = "Luzhou\,\ Sichuan";
$areanames{en}->{861322838} = "Leshan\,\ Sichuan";
$areanames{en}->{861322839} = "Mianyang\,\ Sichuan";
$areanames{en}->{861322840} = "Meishan\,\ Sichuan";
$areanames{en}->{861322841} = "Deyang\,\ Sichuan";
$areanames{en}->{861322842} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861322843} = "Baoji\,\ Shaanxi";
$areanames{en}->{861322844} = "Yulin\,\ Shaanxi";
$areanames{en}->{861322845} = "Nanchong\,\ Sichuan";
$areanames{en}->{861322846} = "Dazhou\,\ Sichuan";
$areanames{en}->{861322847} = "Baoji\,\ Shaanxi";
$areanames{en}->{861322848} = "Leshan\,\ Sichuan";
$areanames{en}->{861322849} = "Suining\,\ Sichuan";
$areanames{en}->{86132285} = "Chongqing";
$areanames{en}->{86132286} = "Chongqing";
$areanames{en}->{86132287} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861322870} = "Suqian\,\ Jiangsu";
$areanames{en}->{861322871} = "Suqian\,\ Jiangsu";
$areanames{en}->{861322872} = "Suqian\,\ Jiangsu";
$areanames{en}->{86132288} = "Nantong\,\ Jiangsu";
$areanames{en}->{861322890} = "Lhasa\,\ Tibet";
$areanames{en}->{861322891} = "Lhasa\,\ Tibet";
$areanames{en}->{861322892} = "Xigaze\,\ Tibet";
$areanames{en}->{861322893} = "Shannan\,\ Tibet";
$areanames{en}->{861322894} = "Nyingchi\,\ Tibet";
$areanames{en}->{861322895} = "Qamdo\,\ Tibet";
$areanames{en}->{861322896} = "Nagqu\,\ Tibet";
$areanames{en}->{861322897} = "Ngari\,\ Tibet";
$areanames{en}->{861322898} = "Lhasa\,\ Tibet";
$areanames{en}->{861322899} = "Lhasa\,\ Tibet";
$areanames{en}->{86132290} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861322906} = "Xingtai\,\ Hebei";
$areanames{en}->{861322907} = "Xingtai\,\ Hebei";
$areanames{en}->{861322908} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861322909} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861322910} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861322911} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861322912} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861322913} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861322914} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861322915} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322916} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322917} = "Jieyang\,\ Guangdong";
$areanames{en}->{861322918} = "Jieyang\,\ Guangdong";
$areanames{en}->{861322919} = "Jieyang\,\ Guangdong";
$areanames{en}->{86132292} = "Foshan\,\ Guangdong";
$areanames{en}->{861322930} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861322931} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861322932} = "Tangshan\,\ Hebei";
$areanames{en}->{861322933} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861322934} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861322935} = "Tangshan\,\ Hebei";
$areanames{en}->{861322936} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322937} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322938} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861322939} = "Shaoguan\,\ Guangdong";
$areanames{en}->{86132294} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132295} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861322958} = "Huizhou\,\ Guangdong";
$areanames{en}->{861322959} = "Huizhou\,\ Guangdong";
$areanames{en}->{86132296} = "Shantou\,\ Guangdong";
$areanames{en}->{861322960} = "Meizhou\,\ Guangdong";
$areanames{en}->{861322969} = "Shanwei\,\ Guangdong";
$areanames{en}->{861322970} = "Meizhou\,\ Guangdong";
$areanames{en}->{861322971} = "Yunfu\,\ Guangdong";
$areanames{en}->{861322972} = "Yunfu\,\ Guangdong";
$areanames{en}->{861322973} = "Shanwei\,\ Guangdong";
$areanames{en}->{861322974} = "Shanwei\,\ Guangdong";
$areanames{en}->{861322975} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322976} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322977} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322978} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861322979} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861322980} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322981} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322982} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322983} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322984} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861322985} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322986} = "Xingtai\,\ Hebei";
$areanames{en}->{861322987} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322988} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861322989} = "Xingtai\,\ Hebei";
$areanames{en}->{86132299} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861322990} = "Tangshan\,\ Hebei";
$areanames{en}->{86132300} = "Handan\,\ Hebei";
$areanames{en}->{86132301} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86132302} = "Baoding\,\ Hebei";
$areanames{en}->{86132303} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86132304} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86132305} = "Tangshan\,\ Hebei";
$areanames{en}->{861323060} = "Baoding\,\ Hebei";
$areanames{en}->{861323061} = "Baoding\,\ Hebei";
$areanames{en}->{861323062} = "Baoding\,\ Hebei";
$areanames{en}->{861323063} = "Baoding\,\ Hebei";
$areanames{en}->{861323064} = "Baoding\,\ Hebei";
$areanames{en}->{861323065} = "Langfang\,\ Hebei";
$areanames{en}->{861323066} = "Langfang\,\ Hebei";
$areanames{en}->{861323067} = "Langfang\,\ Hebei";
$areanames{en}->{861323068} = "Langfang\,\ Hebei";
$areanames{en}->{861323069} = "Langfang\,\ Hebei";
$areanames{en}->{86132307} = "Cangzhou\,\ Hebei";
$areanames{en}->{86132308} = "Tangshan\,\ Hebei";
$areanames{en}->{861323090} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861323091} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861323092} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861323093} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861323094} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861323095} = "Xingtai\,\ Hebei";
$areanames{en}->{861323096} = "Xingtai\,\ Hebei";
$areanames{en}->{861323097} = "Xingtai\,\ Hebei";
$areanames{en}->{861323098} = "Xingtai\,\ Hebei";
$areanames{en}->{861323099} = "Xingtai\,\ Hebei";
$areanames{en}->{86132310} = "Handan\,\ Hebei";
$areanames{en}->{86132311} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86132312} = "Baoding\,\ Hebei";
$areanames{en}->{86132313} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861323137} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861323138} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861323139} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86132314} = "Chengde\,\ Hebei";
$areanames{en}->{86132315} = "Tangshan\,\ Hebei";
$areanames{en}->{86132316} = "Langfang\,\ Hebei";
$areanames{en}->{86132317} = "Cangzhou\,\ Hebei";
$areanames{en}->{86132318} = "Hengshui\,\ Hebei";
$areanames{en}->{86132319} = "Xingtai\,\ Hebei";
$areanames{en}->{861323200} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861323201} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861323202} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861323203} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861323204} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861323205} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861323206} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861323207} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861323208} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861323209} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861323210} = "Yunfu\,\ Guangdong";
$areanames{en}->{861323211} = "Yunfu\,\ Guangdong";
$areanames{en}->{861323212} = "Yunfu\,\ Guangdong";
$areanames{en}->{861323213} = "Yunfu\,\ Guangdong";
$areanames{en}->{861323214} = "Yunfu\,\ Guangdong";
$areanames{en}->{861323215} = "Maoming\,\ Guangdong";
$areanames{en}->{861323216} = "Maoming\,\ Guangdong";
$areanames{en}->{861323217} = "Maoming\,\ Guangdong";
$areanames{en}->{861323218} = "Maoming\,\ Guangdong";
$areanames{en}->{861323219} = "Maoming\,\ Guangdong";
$areanames{en}->{86132322} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86132323} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861323230} = "Meizhou\,\ Guangdong";
$areanames{en}->{861323231} = "Meizhou\,\ Guangdong";
$areanames{en}->{861323232} = "Meizhou\,\ Guangdong";
$areanames{en}->{861323233} = "Meizhou\,\ Guangdong";
$areanames{en}->{861323240} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323241} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323242} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323243} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323244} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323245} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323246} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323247} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323248} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323249} = "Qingyuan\,\ Guangdong";
$areanames{en}->{86132325} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861323250} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861323251} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861323252} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861323260} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323261} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323262} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323263} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323264} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323265} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323266} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323267} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323268} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323269} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323270} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323271} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323272} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323273} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323274} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861323275} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323276} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323277} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323278} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323279} = "Heyuan\,\ Guangdong";
$areanames{en}->{861323280} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323281} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323282} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323283} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323284} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323285} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323286} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323287} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323288} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323289} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323290} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323291} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323292} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323293} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323294} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861323295} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323296} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323297} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323298} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861323299} = "Qingyuan\,\ Guangdong";
$areanames{en}->{86132330} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861323306} = "Linfen\,\ Shanxi";
$areanames{en}->{861323307} = "Linfen\,\ Shanxi";
$areanames{en}->{861323308} = "Linfen\,\ Shanxi";
$areanames{en}->{861323309} = "Linfen\,\ Shanxi";
$areanames{en}->{86132331} = "Datong\,\ Shanxi";
$areanames{en}->{861323310} = "Linfen\,\ Shanxi";
$areanames{en}->{861323311} = "Linfen\,\ Shanxi";
$areanames{en}->{861323312} = "Linfen\,\ Shanxi";
$areanames{en}->{86132332} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861323327} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323328} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323329} = "Jincheng\,\ Shanxi";
$areanames{en}->{86132333} = "Changzhi\,\ Shanxi";
$areanames{en}->{861323330} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323331} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323332} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323333} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323340} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861323341} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861323342} = "Datong\,\ Shanxi";
$areanames{en}->{861323343} = "Yangquan\,\ Shanxi";
$areanames{en}->{861323344} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861323345} = "Changzhi\,\ Shanxi";
$areanames{en}->{861323346} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323347} = "Linfen\,\ Shanxi";
$areanames{en}->{861323348} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861323349} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861323350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861323351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861323352} = "Datong\,\ Shanxi";
$areanames{en}->{861323353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861323354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861323355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861323356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861323357} = "Linfen\,\ Shanxi";
$areanames{en}->{861323358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861323359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{86132336} = "Taiyuan\,\ Shanxi";
$areanames{en}->{86132337} = "Pingdingshan\,\ Henan";
$areanames{en}->{861323376} = "Xinyang\,\ Henan";
$areanames{en}->{861323377} = "Xinyang\,\ Henan";
$areanames{en}->{861323378} = "Xinyang\,\ Henan";
$areanames{en}->{861323379} = "Luoyang\,\ Henan";
$areanames{en}->{861323380} = "Xinxiang\,\ Henan";
$areanames{en}->{861323381} = "Xinxiang\,\ Henan";
$areanames{en}->{861323382} = "Xinxiang\,\ Henan";
$areanames{en}->{861323383} = "Xinxiang\,\ Henan";
$areanames{en}->{861323384} = "Xinxiang\,\ Henan";
$areanames{en}->{861323385} = "Shangqiu\,\ Henan";
$areanames{en}->{861323386} = "Shangqiu\,\ Henan";
$areanames{en}->{861323387} = "Shangqiu\,\ Henan";
$areanames{en}->{861323388} = "Shangqiu\,\ Henan";
$areanames{en}->{861323389} = "Shangqiu\,\ Henan";
$areanames{en}->{86132339} = "Luoyang\,\ Henan";
$areanames{en}->{861323397} = "Xinyang\,\ Henan";
$areanames{en}->{861323400} = "Shenyang\,\ Liaoning";
$areanames{en}->{861323401} = "Shenyang\,\ Liaoning";
$areanames{en}->{861323402} = "Shenyang\,\ Liaoning";
$areanames{en}->{861323403} = "Shenyang\,\ Liaoning";
$areanames{en}->{861323404} = "Shenyang\,\ Liaoning";
$areanames{en}->{861323405} = "Dalian\,\ Liaoning";
$areanames{en}->{861323406} = "Dalian\,\ Liaoning";
$areanames{en}->{861323407} = "Dalian\,\ Liaoning";
$areanames{en}->{861323408} = "Dalian\,\ Liaoning";
$areanames{en}->{861323409} = "Dalian\,\ Liaoning";
$areanames{en}->{861323410} = "Tieling\,\ Liaoning";
$areanames{en}->{861323411} = "Dalian\,\ Liaoning";
$areanames{en}->{861323412} = "Anshan\,\ Liaoning";
$areanames{en}->{861323413} = "Fushun\,\ Liaoning";
$areanames{en}->{861323414} = "Benxi\,\ Liaoning";
$areanames{en}->{861323415} = "Dandong\,\ Liaoning";
$areanames{en}->{861323416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861323419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861323420} = "Tieling\,\ Liaoning";
$areanames{en}->{861323421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861323422} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861323423} = "Huludao\,\ Liaoning";
$areanames{en}->{861323424} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861323425} = "Dandong\,\ Liaoning";
$areanames{en}->{861323426} = "Dandong\,\ Liaoning";
$areanames{en}->{861323427} = "Panjin\,\ Liaoning";
$areanames{en}->{861323428} = "Panjin\,\ Liaoning";
$areanames{en}->{861323429} = "Huludao\,\ Liaoning";
$areanames{en}->{861323430} = "Changchun\,\ Jilin";
$areanames{en}->{861323431} = "Changchun\,\ Jilin";
$areanames{en}->{861323432} = "Jilin\,\ Jilin";
$areanames{en}->{861323433} = "Yanbian\,\ Jilin";
$areanames{en}->{861323434} = "Siping\,\ Jilin";
$areanames{en}->{861323435} = "Tonghua\,\ Jilin";
$areanames{en}->{861323436} = "Baicheng\,\ Jilin";
$areanames{en}->{861323437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861323438} = "Songyuan\,\ Jilin";
$areanames{en}->{861323439} = "Baishan\,\ Jilin";
$areanames{en}->{86132344} = "Changchun\,\ Jilin";
$areanames{en}->{861323450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861323454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861323455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861323456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861323457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861323458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861323459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861323460} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323461} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323462} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323463} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323464} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323465} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323466} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861323468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861323469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861323470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861323471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861323472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861323473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861323474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861323475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861323476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861323477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861323478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861323479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861323480} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861323481} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861323482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861323483} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861323484} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861323485} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861323486} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861323487} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861323488} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861323489} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861323490} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861323491} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861323492} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861323493} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323494} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861323495} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323496} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323497} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323498} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323499} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861323500} = "Xiamen\,\ Fujian";
$areanames{en}->{861323501} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861323502} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861323503} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861323504} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861323505} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861323506} = "Ningde\,\ Fujian";
$areanames{en}->{861323507} = "Putian\,\ Fujian";
$areanames{en}->{861323508} = "Putian\,\ Fujian";
$areanames{en}->{861323509} = "Longyan\,\ Fujian";
$areanames{en}->{86132351} = "Suqian\,\ Jiangsu";
$areanames{en}->{861323516} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861323517} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861323518} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861323519} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86132352} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861323520} = "Nantong\,\ Jiangsu";
$areanames{en}->{861323521} = "Nantong\,\ Jiangsu";
$areanames{en}->{861323522} = "Nantong\,\ Jiangsu";
$areanames{en}->{861323530} = "Heze\,\ Shandong";
$areanames{en}->{861323531} = "Jinan\,\ Shandong";
$areanames{en}->{861323532} = "Qingdao\,\ Shandong";
$areanames{en}->{861323533} = "Zibo\,\ Shandong";
$areanames{en}->{861323534} = "Dezhou\,\ Shandong";
$areanames{en}->{861323535} = "Yantai\,\ Shandong";
$areanames{en}->{861323536} = "Weifang\,\ Shandong";
$areanames{en}->{861323537} = "Jining\,\ Shandong";
$areanames{en}->{861323538} = "TaiAn\,\ Shandong";
$areanames{en}->{861323539} = "Linyi\,\ Shandong";
$areanames{en}->{861323540} = "Ezhou\,\ Hubei";
$areanames{en}->{861323541} = "Huanggang\,\ Hubei";
$areanames{en}->{861323542} = "Huanggang\,\ Hubei";
$areanames{en}->{861323543} = "Huanggang\,\ Hubei";
$areanames{en}->{861323544} = "Enshi\,\ Hubei";
$areanames{en}->{861323545} = "Enshi\,\ Hubei";
$areanames{en}->{861323546} = "Enshi\,\ Hubei";
$areanames{en}->{861323547} = "Xiaogan\,\ Hubei";
$areanames{en}->{861323548} = "Xiaogan\,\ Hubei";
$areanames{en}->{861323549} = "Xiaogan\,\ Hubei";
$areanames{en}->{861323550} = "Suizhou\,\ Hubei";
$areanames{en}->{861323551} = "Suizhou\,\ Hubei";
$areanames{en}->{861323552} = "Wuhan\,\ Hubei";
$areanames{en}->{861323553} = "Wuhan\,\ Hubei";
$areanames{en}->{861323554} = "Wuhan\,\ Hubei";
$areanames{en}->{861323555} = "Wuhan\,\ Hubei";
$areanames{en}->{861323556} = "Xianning\,\ Hubei";
$areanames{en}->{861323557} = "Xianning\,\ Hubei";
$areanames{en}->{861323558} = "Xianning\,\ Hubei";
$areanames{en}->{861323559} = "Enshi\,\ Hubei";
$areanames{en}->{861323560} = "Jingzhou\,\ Hubei";
$areanames{en}->{861323561} = "Jingzhou\,\ Hubei";
$areanames{en}->{861323562} = "Yichang\,\ Hubei";
$areanames{en}->{861323563} = "Yichang\,\ Hubei";
$areanames{en}->{861323564} = "Jingmen\,\ Hubei";
$areanames{en}->{861323565} = "Shiyan\,\ Hubei";
$areanames{en}->{861323566} = "Shiyan\,\ Hubei";
$areanames{en}->{861323567} = "Shiyan\,\ Hubei";
$areanames{en}->{861323568} = "Xiangfan\,\ Hubei";
$areanames{en}->{861323569} = "Xiangfan\,\ Hubei";
$areanames{en}->{861323570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861323571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861323572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861323573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861323574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861323575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861323576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861323577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861323578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861323579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861323580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861323581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861323582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861323583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861323584} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861323585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861323586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861323587} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861323588} = "Lishui\,\ Zhejiang";
$areanames{en}->{861323589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861323590} = "Fuzhou\,\ Fujian";
$areanames{en}->{861323591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861323592} = "Xiamen\,\ Fujian";
$areanames{en}->{861323593} = "Ningde\,\ Fujian";
$areanames{en}->{861323594} = "Putian\,\ Fujian";
$areanames{en}->{861323595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861323596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861323597} = "Longyan\,\ Fujian";
$areanames{en}->{861323598} = "Sanming\,\ Fujian";
$areanames{en}->{861323599} = "Nanping\,\ Fujian";
$areanames{en}->{86132360} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861323607} = "Nantong\,\ Jiangsu";
$areanames{en}->{861323608} = "Nantong\,\ Jiangsu";
$areanames{en}->{861323609} = "Nantong\,\ Jiangsu";
$areanames{en}->{86132361} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861323610} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861323611} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861323612} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861323613} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86132362} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861323627} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861323628} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861323629} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861323630} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861323631} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861323632} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861323633} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861323634} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861323635} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861323636} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861323637} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861323638} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861323639} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861323640} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861323641} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861323642} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861323643} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861323644} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861323645} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861323646} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861323647} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861323648} = "Nantong\,\ Jiangsu";
$areanames{en}->{861323649} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86132365} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86132366} = "Shenyang\,\ Liaoning";
$areanames{en}->{861323668} = "Benxi\,\ Liaoning";
$areanames{en}->{861323669} = "Benxi\,\ Liaoning";
$areanames{en}->{861323670} = "Fuxin\,\ Liaoning";
$areanames{en}->{861323671} = "Fuxin\,\ Liaoning";
$areanames{en}->{861323672} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323673} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323674} = "Tieling\,\ Liaoning";
$areanames{en}->{861323675} = "Tieling\,\ Liaoning";
$areanames{en}->{861323676} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861323677} = "Panjin\,\ Liaoning";
$areanames{en}->{861323678} = "Panjin\,\ Liaoning";
$areanames{en}->{861323679} = "Huludao\,\ Liaoning";
$areanames{en}->{861323680} = "Anshan\,\ Liaoning";
$areanames{en}->{861323681} = "Anshan\,\ Liaoning";
$areanames{en}->{861323682} = "Anshan\,\ Liaoning";
$areanames{en}->{861323683} = "Anshan\,\ Liaoning";
$areanames{en}->{861323684} = "Anshan\,\ Liaoning";
$areanames{en}->{861323685} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323686} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323687} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323688} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323689} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323690} = "Dalian\,\ Liaoning";
$areanames{en}->{861323691} = "Dalian\,\ Liaoning";
$areanames{en}->{861323692} = "Dalian\,\ Liaoning";
$areanames{en}->{861323693} = "Dalian\,\ Liaoning";
$areanames{en}->{861323694} = "Dalian\,\ Liaoning";
$areanames{en}->{861323695} = "Fushun\,\ Liaoning";
$areanames{en}->{861323696} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861323697} = "Dandong\,\ Liaoning";
$areanames{en}->{861323698} = "Dandong\,\ Liaoning";
$areanames{en}->{861323699} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323700} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861323701} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861323702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861323703} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861323704} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861323705} = "Yichun\,\ Jiangxi";
$areanames{en}->{861323706} = "JiAn\,\ Jiangxi";
$areanames{en}->{861323707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861323708} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861323709} = "Yichun\,\ Jiangxi";
$areanames{en}->{86132371} = "Wuhan\,\ Hubei";
$areanames{en}->{861323720} = "Huanggang\,\ Hubei";
$areanames{en}->{861323721} = "Huanggang\,\ Hubei";
$areanames{en}->{861323722} = "Huanggang\,\ Hubei";
$areanames{en}->{861323723} = "Huangshi\,\ Hubei";
$areanames{en}->{861323724} = "Huangshi\,\ Hubei";
$areanames{en}->{861323725} = "Huangshi\,\ Hubei";
$areanames{en}->{861323726} = "Suizhou\,\ Hubei";
$areanames{en}->{861323727} = "Jingmen\,\ Hubei";
$areanames{en}->{861323728} = "Jingmen\,\ Hubei";
$areanames{en}->{861323729} = "Jingmen\,\ Hubei";
$areanames{en}->{861323730} = "Yueyang\,\ Hunan";
$areanames{en}->{861323731} = "Changsha\,\ Hunan";
$areanames{en}->{861323732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861323733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861323734} = "Hengyang\,\ Hunan";
$areanames{en}->{861323735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861323736} = "Changde\,\ Hunan";
$areanames{en}->{861323737} = "Yiyang\,\ Hunan";
$areanames{en}->{861323738} = "Loudi\,\ Hunan";
$areanames{en}->{861323739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861323740} = "Yueyang\,\ Hunan";
$areanames{en}->{861323741} = "Changsha\,\ Hunan";
$areanames{en}->{861323742} = "Changsha\,\ Hunan";
$areanames{en}->{861323743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861323744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861323745} = "Huaihua\,\ Hunan";
$areanames{en}->{861323746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861323747} = "Changsha\,\ Hunan";
$areanames{en}->{861323748} = "Changsha\,\ Hunan";
$areanames{en}->{861323749} = "Changsha\,\ Hunan";
$areanames{en}->{861323750} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861323751} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861323752} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861323753} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861323754} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861323755} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861323756} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861323757} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861323758} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861323759} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861323760} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861323761} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861323762} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861323763} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861323764} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861323765} = "Yichun\,\ Jiangxi";
$areanames{en}->{861323766} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861323767} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861323768} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861323769} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861323770} = "Nanning\,\ Guangxi";
$areanames{en}->{861323771} = "Nanning\,\ Guangxi";
$areanames{en}->{861323772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861323773} = "Guilin\,\ Guangxi";
$areanames{en}->{861323774} = "Hezhou\,\ Guangxi";
$areanames{en}->{861323775} = "Guigang\,\ Guangxi";
$areanames{en}->{861323776} = "Baise\,\ Guangxi";
$areanames{en}->{861323777} = "Hezhou\,\ Guangxi";
$areanames{en}->{861323778} = "Hechi\,\ Guangxi";
$areanames{en}->{861323779} = "Laibin\,\ Guangxi";
$areanames{en}->{861323780} = "Nanning\,\ Guangxi";
$areanames{en}->{861323781} = "Nanning\,\ Guangxi";
$areanames{en}->{861323782} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861323783} = "Guilin\,\ Guangxi";
$areanames{en}->{861323784} = "Hezhou\,\ Guangxi";
$areanames{en}->{861323785} = "Guigang\,\ Guangxi";
$areanames{en}->{861323786} = "Yulin\,\ Guangxi";
$areanames{en}->{861323787} = "Laibin\,\ Guangxi";
$areanames{en}->{861323788} = "Hechi\,\ Guangxi";
$areanames{en}->{861323789} = "Laibin\,\ Guangxi";
$areanames{en}->{861323790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861323791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861323792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861323793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861323794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861323795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861323796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861323797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861323798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861323799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86132380} = "Dalian\,\ Liaoning";
$areanames{en}->{861323810} = "Fushun\,\ Liaoning";
$areanames{en}->{861323811} = "Fuxin\,\ Liaoning";
$areanames{en}->{861323812} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861323813} = "Fushun\,\ Liaoning";
$areanames{en}->{861323814} = "Tieling\,\ Liaoning";
$areanames{en}->{861323815} = "Dandong\,\ Liaoning";
$areanames{en}->{861323816} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323817} = "Anshan\,\ Liaoning";
$areanames{en}->{861323818} = "Anshan\,\ Liaoning";
$areanames{en}->{861323819} = "Anshan\,\ Liaoning";
$areanames{en}->{861323820} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323821} = "Fuxin\,\ Liaoning";
$areanames{en}->{861323822} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861323823} = "Panjin\,\ Liaoning";
$areanames{en}->{861323824} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323825} = "Dandong\,\ Liaoning";
$areanames{en}->{861323826} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323827} = "Yingkou\,\ Liaoning";
$areanames{en}->{861323828} = "Tieling\,\ Liaoning";
$areanames{en}->{861323829} = "Tieling\,\ Liaoning";
$areanames{en}->{86132383} = "Dongguan\,\ Guangdong";
$areanames{en}->{861323840} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861323841} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861323842} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861323843} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861323844} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861323845} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861323846} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861323847} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861323848} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861323849} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861323850} = "Anshun\,\ Guizhou";
$areanames{en}->{861323851} = "Anshun\,\ Guizhou";
$areanames{en}->{861323852} = "Bijie\,\ Guizhou";
$areanames{en}->{861323853} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861323854} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861323855} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861323856} = "Tongren\,\ Guizhou";
$areanames{en}->{861323857} = "Bijie\,\ Guizhou";
$areanames{en}->{861323858} = "Bijie\,\ Guizhou";
$areanames{en}->{861323859} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861323860} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861323861} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861323862} = "Qujing\,\ Yunnan";
$areanames{en}->{861323863} = "Lincang\,\ Yunnan";
$areanames{en}->{861323864} = "Qujing\,\ Yunnan";
$areanames{en}->{861323865} = "Baoshan\,\ Yunnan";
$areanames{en}->{861323866} = "Kunming\,\ Yunnan";
$areanames{en}->{861323867} = "Kunming\,\ Yunnan";
$areanames{en}->{861323868} = "Kunming\,\ Yunnan";
$areanames{en}->{861323869} = "Kunming\,\ Yunnan";
$areanames{en}->{861323870} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861323871} = "Kunming\,\ Yunnan";
$areanames{en}->{861323872} = "Dali\,\ Yunnan";
$areanames{en}->{861323873} = "Honghe\,\ Yunnan";
$areanames{en}->{861323874} = "Qujing\,\ Yunnan";
$areanames{en}->{861323875} = "Baoshan\,\ Yunnan";
$areanames{en}->{861323876} = "Wenshan\,\ Yunnan";
$areanames{en}->{861323877} = "Yuxi\,\ Yunnan";
$areanames{en}->{861323878} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861323879} = "Puer\,\ Yunnan";
$areanames{en}->{86132388} = "Shenyang\,\ Liaoning";
$areanames{en}->{861323890} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861323891} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861323892} = "Huludao\,\ Liaoning";
$areanames{en}->{861323893} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861323894} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861323895} = "Huludao\,\ Liaoning";
$areanames{en}->{861323896} = "Panjin\,\ Liaoning";
$areanames{en}->{861323897} = "Anshan\,\ Liaoning";
$areanames{en}->{861323898} = "Anshan\,\ Liaoning";
$areanames{en}->{861323899} = "Anshan\,\ Liaoning";
$areanames{en}->{861323900} = "Changji\,\ Xinjiang";
$areanames{en}->{861323901} = "Kashi\,\ Xinjiang";
$areanames{en}->{861323902} = "Ili\,\ Xinjiang";
$areanames{en}->{861323903} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861323904} = "Ili\,\ Xinjiang";
$areanames{en}->{861323905} = "Ili\,\ Xinjiang";
$areanames{en}->{861323906} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861323907} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861323908} = "Aksu\,\ Xinjiang";
$areanames{en}->{861323909} = "Bortala\,\ Xinjiang";
$areanames{en}->{861323910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861323911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861323912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861323913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861323914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861323915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861323916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861323917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861323918} = "YanAn\,\ Shaanxi";
$areanames{en}->{861323919} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{86132392} = "Yulin\,\ Shaanxi";
$areanames{en}->{861323920} = "YanAn\,\ Shaanxi";
$areanames{en}->{861323921} = "YanAn\,\ Shaanxi";
$areanames{en}->{861323922} = "YanAn\,\ Shaanxi";
$areanames{en}->{861323923} = "YanAn\,\ Shaanxi";
$areanames{en}->{861323930} = "Linxia\,\ Gansu";
$areanames{en}->{861323931} = "Lanzhou\,\ Gansu";
$areanames{en}->{861323932} = "Dingxi\,\ Gansu";
$areanames{en}->{861323933} = "Pingliang\,\ Gansu";
$areanames{en}->{861323934} = "Qingyang\,\ Gansu";
$areanames{en}->{861323935} = "Jinchang\,\ Gansu";
$areanames{en}->{861323936} = "Zhangye\,\ Gansu";
$areanames{en}->{861323937} = "Jiuquan\,\ Gansu";
$areanames{en}->{861323938} = "Tianshui\,\ Gansu";
$areanames{en}->{861323939} = "Longnan\,\ Gansu";
$areanames{en}->{861323940} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861323941} = "Gannan\,\ Gansu";
$areanames{en}->{861323942} = "Dingxi\,\ Gansu";
$areanames{en}->{861323943} = "Baiyin\,\ Gansu";
$areanames{en}->{861323944} = "Longnan\,\ Gansu";
$areanames{en}->{861323945} = "Wuwei\,\ Gansu";
$areanames{en}->{861323946} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861323947} = "Gannan\,\ Gansu";
$areanames{en}->{861323948} = "Zhangye\,\ Gansu";
$areanames{en}->{861323949} = "Jiuquan\,\ Gansu";
$areanames{en}->{861323950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861323951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861323952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861323953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861323954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861323955} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861323956} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861323957} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861323958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861323959} = "Yinchuan\,\ Ningxia";
$areanames{en}->{86132396} = "Lanzhou\,\ Gansu";
$areanames{en}->{861323960} = "Qingyang\,\ Gansu";
$areanames{en}->{861323961} = "Qingyang\,\ Gansu";
$areanames{en}->{861323970} = "Kashi\,\ Xinjiang";
$areanames{en}->{861323971} = "Turpan\,\ Xinjiang";
$areanames{en}->{861323972} = "Kashi\,\ Xinjiang";
$areanames{en}->{861323973} = "Hami\,\ Xinjiang";
$areanames{en}->{861323974} = "Hotan\,\ Xinjiang";
$areanames{en}->{861323975} = "Ili\,\ Xinjiang";
$areanames{en}->{861323976} = "Hotan\,\ Xinjiang";
$areanames{en}->{861323977} = "Karamay\,\ Xinjiang";
$areanames{en}->{861323978} = "Ili\,\ Xinjiang";
$areanames{en}->{861323979} = "Ili\,\ Xinjiang";
$areanames{en}->{861323980} = "Hotan\,\ Xinjiang";
$areanames{en}->{861323981} = "Hotan\,\ Xinjiang";
$areanames{en}->{861323982} = "Aksu\,\ Xinjiang";
$areanames{en}->{861323983} = "Aksu\,\ Xinjiang";
$areanames{en}->{861323984} = "Aksu\,\ Xinjiang";
$areanames{en}->{861323985} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861323986} = "Aksu\,\ Xinjiang";
$areanames{en}->{861323987} = "Kashi\,\ Xinjiang";
$areanames{en}->{861323988} = "Changji\,\ Xinjiang";
$areanames{en}->{861323989} = "Changji\,\ Xinjiang";
$areanames{en}->{861323990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861323991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861323992} = "Ili\,\ Xinjiang";
$areanames{en}->{861323993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861323994} = "Changji\,\ Xinjiang";
$areanames{en}->{861323995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861323996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861323997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861323998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861323999} = "Ili\,\ Xinjiang";
$areanames{en}->{8613240} = "Beijing";
$areanames{en}->{86132405} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132406} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324083} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861324084} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861324085} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861324086} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861324087} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861324088} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{8613241} = "Beijing";
$areanames{en}->{86132420} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324210} = "Foshan\,\ Guangdong";
$areanames{en}->{861324211} = "Foshan\,\ Guangdong";
$areanames{en}->{861324212} = "Foshan\,\ Guangdong";
$areanames{en}->{861324213} = "Foshan\,\ Guangdong";
$areanames{en}->{861324214} = "Foshan\,\ Guangdong";
$areanames{en}->{861324215} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324216} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324217} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324218} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324219} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324220} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324221} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324222} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324223} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324224} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324225} = "Jieyang\,\ Guangdong";
$areanames{en}->{861324226} = "Jieyang\,\ Guangdong";
$areanames{en}->{861324227} = "Jieyang\,\ Guangdong";
$areanames{en}->{861324228} = "Jieyang\,\ Guangdong";
$areanames{en}->{861324229} = "Jieyang\,\ Guangdong";
$areanames{en}->{861324230} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324231} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324232} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324233} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324234} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324235} = "Huizhou\,\ Guangdong";
$areanames{en}->{861324236} = "Huizhou\,\ Guangdong";
$areanames{en}->{861324237} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861324238} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861324239} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861324240} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324241} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324242} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324243} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324244} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324245} = "Foshan\,\ Guangdong";
$areanames{en}->{861324246} = "Foshan\,\ Guangdong";
$areanames{en}->{861324247} = "Xingtai\,\ Hebei";
$areanames{en}->{861324248} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324249} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86132425} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861324257} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861324258} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861324259} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861324260} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861324261} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861324262} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861324263} = "Tangshan\,\ Hebei";
$areanames{en}->{861324264} = "Tangshan\,\ Hebei";
$areanames{en}->{861324265} = "Shanwei\,\ Guangdong";
$areanames{en}->{861324266} = "Shanwei\,\ Guangdong";
$areanames{en}->{861324267} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861324268} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861324269} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86132427} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132428} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132429} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324300} = "Anyang\,\ Henan";
$areanames{en}->{861324301} = "Anyang\,\ Henan";
$areanames{en}->{861324302} = "Anyang\,\ Henan";
$areanames{en}->{861324303} = "Jiaozuo\,\ Henan";
$areanames{en}->{861324304} = "Jiaozuo\,\ Henan";
$areanames{en}->{861324305} = "Kaifeng\,\ Henan";
$areanames{en}->{861324306} = "Kaifeng\,\ Henan";
$areanames{en}->{861324307} = "Luoyang\,\ Henan";
$areanames{en}->{861324308} = "Luoyang\,\ Henan";
$areanames{en}->{861324309} = "Luoyang\,\ Henan";
$areanames{en}->{861324310} = "Luohe\,\ Henan";
$areanames{en}->{861324311} = "Luohe\,\ Henan";
$areanames{en}->{861324312} = "Nanyang\,\ Henan";
$areanames{en}->{861324313} = "Nanyang\,\ Henan";
$areanames{en}->{861324314} = "Nanyang\,\ Henan";
$areanames{en}->{861324315} = "Nanyang\,\ Henan";
$areanames{en}->{861324316} = "Pingdingshan\,\ Henan";
$areanames{en}->{861324317} = "Pingdingshan\,\ Henan";
$areanames{en}->{861324318} = "Pingdingshan\,\ Henan";
$areanames{en}->{861324319} = "Pingdingshan\,\ Henan";
$areanames{en}->{861324320} = "Puyang\,\ Henan";
$areanames{en}->{861324321} = "Puyang\,\ Henan";
$areanames{en}->{861324322} = "Puyang\,\ Henan";
$areanames{en}->{861324323} = "Sanmenxia\,\ Henan";
$areanames{en}->{861324324} = "Sanmenxia\,\ Henan";
$areanames{en}->{861324325} = "Shangqiu\,\ Henan";
$areanames{en}->{861324326} = "Shangqiu\,\ Henan";
$areanames{en}->{861324327} = "Shangqiu\,\ Henan";
$areanames{en}->{861324328} = "Xinxiang\,\ Henan";
$areanames{en}->{861324329} = "Xinxiang\,\ Henan";
$areanames{en}->{861324330} = "Xinyang\,\ Henan";
$areanames{en}->{861324331} = "Xinyang\,\ Henan";
$areanames{en}->{861324332} = "Xinyang\,\ Henan";
$areanames{en}->{861324333} = "Xuchang\,\ Henan";
$areanames{en}->{861324334} = "Xuchang\,\ Henan";
$areanames{en}->{861324335} = "Xuchang\,\ Henan";
$areanames{en}->{861324336} = "Xuchang\,\ Henan";
$areanames{en}->{861324337} = "Zhoukou\,\ Henan";
$areanames{en}->{861324338} = "Zhoukou\,\ Henan";
$areanames{en}->{861324339} = "Zhumadian\,\ Henan";
$areanames{en}->{861324340} = "Hebi\,\ Henan";
$areanames{en}->{861324341} = "Hebi\,\ Henan";
$areanames{en}->{861324342} = "Zhengzhou\,\ Henan";
$areanames{en}->{861324343} = "Zhengzhou\,\ Henan";
$areanames{en}->{861324344} = "Zhengzhou\,\ Henan";
$areanames{en}->{861324345} = "Jiaozuo\,\ Henan";
$areanames{en}->{861324346} = "Zhoukou\,\ Henan";
$areanames{en}->{861324347} = "Zhumadian\,\ Henan";
$areanames{en}->{861324348} = "Zhumadian\,\ Henan";
$areanames{en}->{861324349} = "Xinxiang\,\ Henan";
$areanames{en}->{86132435} = "Chongqing";
$areanames{en}->{86132436} = "Yongzhou\,\ Hunan";
$areanames{en}->{86132437} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132438} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324390} = "Huludao\,\ Liaoning";
$areanames{en}->{861324391} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861324392} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861324393} = "Yingkou\,\ Liaoning";
$areanames{en}->{861324394} = "Yingkou\,\ Liaoning";
$areanames{en}->{861324395} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861324396} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861324397} = "Huludao\,\ Liaoning";
$areanames{en}->{861324398} = "Huludao\,\ Liaoning";
$areanames{en}->{861324399} = "Huludao\,\ Liaoning";
$areanames{en}->{861324400} = "Jilin\,\ Jilin";
$areanames{en}->{861324401} = "Jilin\,\ Jilin";
$areanames{en}->{861324402} = "Jilin\,\ Jilin";
$areanames{en}->{861324403} = "Jilin\,\ Jilin";
$areanames{en}->{861324404} = "Jilin\,\ Jilin";
$areanames{en}->{861324405} = "Siping\,\ Jilin";
$areanames{en}->{861324406} = "Siping\,\ Jilin";
$areanames{en}->{861324407} = "Siping\,\ Jilin";
$areanames{en}->{861324408} = "Siping\,\ Jilin";
$areanames{en}->{861324409} = "Siping\,\ Jilin";
$areanames{en}->{86132441} = "YanAn\,\ Shaanxi";
$areanames{en}->{861324410} = "XiAn\,\ Shaanxi";
$areanames{en}->{861324420} = "Jilin\,\ Jilin";
$areanames{en}->{861324421} = "Jilin\,\ Jilin";
$areanames{en}->{861324422} = "Jilin\,\ Jilin";
$areanames{en}->{861324423} = "Jilin\,\ Jilin";
$areanames{en}->{861324424} = "Siping\,\ Jilin";
$areanames{en}->{861324425} = "Tonghua\,\ Jilin";
$areanames{en}->{861324426} = "Changchun\,\ Jilin";
$areanames{en}->{861324427} = "Changchun\,\ Jilin";
$areanames{en}->{861324428} = "Songyuan\,\ Jilin";
$areanames{en}->{861324429} = "Songyuan\,\ Jilin";
$areanames{en}->{861324430} = "Changchun\,\ Jilin";
$areanames{en}->{861324431} = "Changchun\,\ Jilin";
$areanames{en}->{861324432} = "Jilin\,\ Jilin";
$areanames{en}->{861324433} = "Yanbian\,\ Jilin";
$areanames{en}->{861324434} = "Siping\,\ Jilin";
$areanames{en}->{861324435} = "Tonghua\,\ Jilin";
$areanames{en}->{861324436} = "Baicheng\,\ Jilin";
$areanames{en}->{861324437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861324438} = "Songyuan\,\ Jilin";
$areanames{en}->{861324439} = "Baishan\,\ Jilin";
$areanames{en}->{861324440} = "Changchun\,\ Jilin";
$areanames{en}->{861324441} = "Changchun\,\ Jilin";
$areanames{en}->{861324442} = "Changchun\,\ Jilin";
$areanames{en}->{861324443} = "Changchun\,\ Jilin";
$areanames{en}->{861324444} = "Siping\,\ Jilin";
$areanames{en}->{861324445} = "Tonghua\,\ Jilin";
$areanames{en}->{861324446} = "Baicheng\,\ Jilin";
$areanames{en}->{861324447} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861324448} = "Songyuan\,\ Jilin";
$areanames{en}->{861324449} = "Songyuan\,\ Jilin";
$areanames{en}->{86132445} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861324459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86132446} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861324469} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86132447} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324480} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324481} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324482} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324483} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324484} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324485} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324486} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324487} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324488} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324489} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324490} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324491} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324492} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324493} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324494} = "Xingtai\,\ Hebei";
$areanames{en}->{861324495} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324496} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324497} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324498} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324499} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324500} = "Changde\,\ Hunan";
$areanames{en}->{861324501} = "Changde\,\ Hunan";
$areanames{en}->{861324502} = "Changde\,\ Hunan";
$areanames{en}->{861324503} = "Changde\,\ Hunan";
$areanames{en}->{861324504} = "Changde\,\ Hunan";
$areanames{en}->{861324505} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861324506} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861324507} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861324508} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861324509} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861324510} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861324511} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861324512} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861324513} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861324514} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861324515} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861324516} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861324517} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861324518} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861324519} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{86132452} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861324530} = "Jinan\,\ Shandong";
$areanames{en}->{861324531} = "Jinan\,\ Shandong";
$areanames{en}->{861324532} = "Qingdao\,\ Shandong";
$areanames{en}->{861324533} = "Zibo\,\ Shandong";
$areanames{en}->{861324534} = "Liaocheng\,\ Shandong";
$areanames{en}->{861324535} = "Yantai\,\ Shandong";
$areanames{en}->{861324536} = "Rizhao\,\ Shandong";
$areanames{en}->{861324537} = "Liaocheng\,\ Shandong";
$areanames{en}->{861324538} = "TaiAn\,\ Shandong";
$areanames{en}->{861324539} = "Linyi\,\ Shandong";
$areanames{en}->{861324540} = "Jinan\,\ Shandong";
$areanames{en}->{861324541} = "Jinan\,\ Shandong";
$areanames{en}->{861324542} = "Qingdao\,\ Shandong";
$areanames{en}->{861324543} = "Binzhou\,\ Shandong";
$areanames{en}->{861324544} = "Rizhao\,\ Shandong";
$areanames{en}->{861324545} = "Dongying\,\ Shandong";
$areanames{en}->{861324546} = "Dongying\,\ Shandong";
$areanames{en}->{861324547} = "Jinan\,\ Shandong";
$areanames{en}->{861324548} = "Laiwu\,\ Shandong";
$areanames{en}->{861324549} = "Linyi\,\ Shandong";
$areanames{en}->{86132455} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86132456} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86132457} = "Nantong\,\ Jiangsu";
$areanames{en}->{861324570} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861324571} = "Shaoyang\,\ Hunan";
$areanames{en}->{86132458} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861324590} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861324591} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861324592} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861324593} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861324594} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861324595} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861324596} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861324597} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861324598} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861324599} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{86132460} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324607} = "Shantou\,\ Guangdong";
$areanames{en}->{861324608} = "Shantou\,\ Guangdong";
$areanames{en}->{861324609} = "Shantou\,\ Guangdong";
$areanames{en}->{86132461} = "Huizhou\,\ Guangdong";
$areanames{en}->{86132462} = "Foshan\,\ Guangdong";
$areanames{en}->{861324630} = "Foshan\,\ Guangdong";
$areanames{en}->{861324631} = "Foshan\,\ Guangdong";
$areanames{en}->{861324632} = "Foshan\,\ Guangdong";
$areanames{en}->{861324633} = "Foshan\,\ Guangdong";
$areanames{en}->{861324634} = "Foshan\,\ Guangdong";
$areanames{en}->{861324635} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861324636} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861324637} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861324638} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861324639} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86132464} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324650} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861324651} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861324652} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861324653} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861324654} = "Foshan\,\ Guangdong";
$areanames{en}->{861324655} = "Foshan\,\ Guangdong";
$areanames{en}->{861324656} = "Huizhou\,\ Guangdong";
$areanames{en}->{861324657} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861324658} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324659} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86132466} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132467} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132468} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132469} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324690} = "Jieyang\,\ Guangdong";
$areanames{en}->{861324691} = "Jieyang\,\ Guangdong";
$areanames{en}->{861324700} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324701} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861324702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861324703} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861324704} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861324705} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324706} = "JiAn\,\ Jiangxi";
$areanames{en}->{861324707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324708} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324709} = "Nanchang\,\ Jiangxi";
$areanames{en}->{86132471} = "Wuhan\,\ Hubei";
$areanames{en}->{861324720} = "Huanggang\,\ Hubei";
$areanames{en}->{861324721} = "Xiaogan\,\ Hubei";
$areanames{en}->{861324722} = "Enshi\,\ Hubei";
$areanames{en}->{861324723} = "Huangshi\,\ Hubei";
$areanames{en}->{861324724} = "Xianning\,\ Hubei";
$areanames{en}->{861324725} = "Jingmen\,\ Hubei";
$areanames{en}->{861324726} = "Shiyan\,\ Hubei";
$areanames{en}->{861324727} = "Xiangfan\,\ Hubei";
$areanames{en}->{861324728} = "Yichang\,\ Hubei";
$areanames{en}->{861324729} = "Jingzhou\,\ Hubei";
$areanames{en}->{86132473} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132474} = "Xingtai\,\ Hebei";
$areanames{en}->{86132475} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324760} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324761} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324762} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324763} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324764} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324765} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324766} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324767} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324768} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324769} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324770} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324771} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324772} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861324773} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861324774} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861324775} = "Yichun\,\ Jiangxi";
$areanames{en}->{861324776} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324777} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324778} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324779} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324780} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324781} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324782} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861324783} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861324784} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324785} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861324786} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324787} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324788} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861324789} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324790} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861324792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861324793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861324794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861324795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861324796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861324797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861324798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861324799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86132480} = "Shanghai";
$areanames{en}->{86132481} = "Shanghai";
$areanames{en}->{86132482} = "Shanghai";
$areanames{en}->{86132483} = "Shanghai";
$areanames{en}->{86132484} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861324846} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861324847} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861324848} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861324849} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86132485} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86132486} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861324870} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861324871} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861324872} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861324873} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861324874} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861324875} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861324876} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861324877} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861324878} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861324879} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86132488} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86132489} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861324900} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324901} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324902} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324903} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324904} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324905} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324906} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324907} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324908} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324909} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132491} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861324910} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324911} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861324912} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86132492} = "Foshan\,\ Guangdong";
$areanames{en}->{861324930} = "Huizhou\,\ Guangdong";
$areanames{en}->{861324931} = "Huizhou\,\ Guangdong";
$areanames{en}->{861324932} = "Huizhou\,\ Guangdong";
$areanames{en}->{861324933} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861324934} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861324935} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861324936} = "Huizhou\,\ Guangdong";
$areanames{en}->{861324937} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324938} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861324939} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324940} = "Foshan\,\ Guangdong";
$areanames{en}->{861324941} = "Foshan\,\ Guangdong";
$areanames{en}->{861324942} = "Foshan\,\ Guangdong";
$areanames{en}->{861324943} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324944} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324945} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324946} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861324947} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324948} = "Shantou\,\ Guangdong";
$areanames{en}->{861324949} = "Shantou\,\ Guangdong";
$areanames{en}->{86132495} = "Shantou\,\ Guangdong";
$areanames{en}->{861324950} = "Xingtai\,\ Hebei";
$areanames{en}->{86132496} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132497} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132498} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132499} = "Dongguan\,\ Guangdong";
$areanames{en}->{861324999} = "Foshan\,\ Guangdong";
$areanames{en}->{861325000} = "Xingtai\,\ Hebei";
$areanames{en}->{861325001} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861325002} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861325003} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861325004} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861325005} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861325006} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861325007} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861325008} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861325009} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861325010} = "Foshan\,\ Guangdong";
$areanames{en}->{861325011} = "Foshan\,\ Guangdong";
$areanames{en}->{861325012} = "Foshan\,\ Guangdong";
$areanames{en}->{861325013} = "Foshan\,\ Guangdong";
$areanames{en}->{861325014} = "Foshan\,\ Guangdong";
$areanames{en}->{861325015} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325016} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325017} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325018} = "Shantou\,\ Guangdong";
$areanames{en}->{861325019} = "Shantou\,\ Guangdong";
$areanames{en}->{86132502} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325030} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325031} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325032} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325033} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325034} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325035} = "Foshan\,\ Guangdong";
$areanames{en}->{861325036} = "Foshan\,\ Guangdong";
$areanames{en}->{861325037} = "Foshan\,\ Guangdong";
$areanames{en}->{861325038} = "Foshan\,\ Guangdong";
$areanames{en}->{861325039} = "Maoming\,\ Guangdong";
$areanames{en}->{861325040} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861325041} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861325042} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861325043} = "Yunfu\,\ Guangdong";
$areanames{en}->{861325044} = "Jieyang\,\ Guangdong";
$areanames{en}->{861325045} = "Jieyang\,\ Guangdong";
$areanames{en}->{861325046} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861325047} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861325048} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861325049} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86132505} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325060} = "Huizhou\,\ Guangdong";
$areanames{en}->{861325061} = "Huizhou\,\ Guangdong";
$areanames{en}->{861325062} = "Huizhou\,\ Guangdong";
$areanames{en}->{861325063} = "Huizhou\,\ Guangdong";
$areanames{en}->{861325064} = "Shantou\,\ Guangdong";
$areanames{en}->{861325065} = "Shantou\,\ Guangdong";
$areanames{en}->{861325066} = "Jieyang\,\ Guangdong";
$areanames{en}->{861325067} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861325068} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861325069} = "Yangjiang\,\ Guangdong";
$areanames{en}->{86132507} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861325080} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325081} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325082} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325083} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325084} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325085} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861325086} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325087} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861325088} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861325089} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86132509} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325090} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861325091} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861325092} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861325099} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861325100} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325101} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325102} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325103} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861325104} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861325105} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861325106} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325107} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325108} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861325109} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86132511} = "Chongqing";
$areanames{en}->{86132512} = "Chongqing";
$areanames{en}->{86132513} = "Chongqing";
$areanames{en}->{86132514} = "Chongqing";
$areanames{en}->{861325150} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861325151} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861325152} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861325153} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861325154} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861325155} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861325156} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861325157} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861325158} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861325159} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861325160} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861325161} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861325162} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861325163} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861325164} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861325165} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861325166} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861325167} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861325168} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861325169} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{86132517} = "Changchun\,\ Jilin";
$areanames{en}->{861325176} = "Baicheng\,\ Jilin";
$areanames{en}->{861325177} = "Baicheng\,\ Jilin";
$areanames{en}->{861325178} = "Songyuan\,\ Jilin";
$areanames{en}->{861325179} = "Songyuan\,\ Jilin";
$areanames{en}->{861325180} = "Changchun\,\ Jilin";
$areanames{en}->{861325181} = "Changchun\,\ Jilin";
$areanames{en}->{861325182} = "Jilin\,\ Jilin";
$areanames{en}->{861325183} = "Yanbian\,\ Jilin";
$areanames{en}->{861325184} = "Siping\,\ Jilin";
$areanames{en}->{861325185} = "Tonghua\,\ Jilin";
$areanames{en}->{861325186} = "Baicheng\,\ Jilin";
$areanames{en}->{861325187} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861325188} = "Songyuan\,\ Jilin";
$areanames{en}->{861325189} = "Baishan\,\ Jilin";
$areanames{en}->{861325190} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325191} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861325192} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861325193} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861325194} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861325195} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861325196} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325197} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325198} = "Lishui\,\ Zhejiang";
$areanames{en}->{861325199} = "Lishui\,\ Zhejiang";
$areanames{en}->{86132520} = "Huzhou\,\ Zhejiang";
$areanames{en}->{86132521} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{86132522} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325220} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861325221} = "Huzhou\,\ Zhejiang";
$areanames{en}->{86132523} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861325240} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325241} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325242} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325243} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325244} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325245} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325246} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325247} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325248} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325249} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86132525} = "Jilin\,\ Jilin";
$areanames{en}->{861325250} = "Songyuan\,\ Jilin";
$areanames{en}->{861325251} = "Songyuan\,\ Jilin";
$areanames{en}->{861325260} = "Changchun\,\ Jilin";
$areanames{en}->{861325261} = "Changchun\,\ Jilin";
$areanames{en}->{861325262} = "Changchun\,\ Jilin";
$areanames{en}->{861325263} = "Changchun\,\ Jilin";
$areanames{en}->{861325264} = "Changchun\,\ Jilin";
$areanames{en}->{861325265} = "Tonghua\,\ Jilin";
$areanames{en}->{861325266} = "Tonghua\,\ Jilin";
$areanames{en}->{861325267} = "Tonghua\,\ Jilin";
$areanames{en}->{861325268} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861325269} = "Baishan\,\ Jilin";
$areanames{en}->{861325270} = "Shenyang\,\ Liaoning";
$areanames{en}->{861325271} = "Shenyang\,\ Liaoning";
$areanames{en}->{861325272} = "Shenyang\,\ Liaoning";
$areanames{en}->{861325273} = "Shenyang\,\ Liaoning";
$areanames{en}->{861325274} = "Fushun\,\ Liaoning";
$areanames{en}->{861325275} = "Fushun\,\ Liaoning";
$areanames{en}->{861325276} = "Fushun\,\ Liaoning";
$areanames{en}->{861325277} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861325278} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861325279} = "Tieling\,\ Liaoning";
$areanames{en}->{86132528} = "Shenyang\,\ Liaoning";
$areanames{en}->{86132529} = "Dalian\,\ Liaoning";
$areanames{en}->{86132530} = "Anyang\,\ Henan";
$areanames{en}->{861325308} = "Puyang\,\ Henan";
$areanames{en}->{861325309} = "Puyang\,\ Henan";
$areanames{en}->{86132531} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861325317} = "Chengde\,\ Hebei";
$areanames{en}->{861325318} = "Chengde\,\ Hebei";
$areanames{en}->{861325319} = "Chengde\,\ Hebei";
$areanames{en}->{86132532} = "Hengshui\,\ Hebei";
$areanames{en}->{86132533} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132534} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132535} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132536} = "Zhengzhou\,\ Henan";
$areanames{en}->{861325370} = "Xuchang\,\ Henan";
$areanames{en}->{861325371} = "Xuchang\,\ Henan";
$areanames{en}->{861325372} = "Xuchang\,\ Henan";
$areanames{en}->{861325373} = "Xuchang\,\ Henan";
$areanames{en}->{861325374} = "Xuchang\,\ Henan";
$areanames{en}->{861325375} = "Zhoukou\,\ Henan";
$areanames{en}->{861325376} = "Zhoukou\,\ Henan";
$areanames{en}->{861325377} = "Zhoukou\,\ Henan";
$areanames{en}->{861325378} = "Zhoukou\,\ Henan";
$areanames{en}->{861325379} = "Zhoukou\,\ Henan";
$areanames{en}->{86132538} = "Xinyang\,\ Henan";
$areanames{en}->{861325386} = "Jiaozuo\,\ Henan";
$areanames{en}->{861325387} = "Jiaozuo\,\ Henan";
$areanames{en}->{861325388} = "Jiaozuo\,\ Henan";
$areanames{en}->{861325389} = "Jiaozuo\,\ Henan";
$areanames{en}->{86132539} = "Sanmenxia\,\ Henan";
$areanames{en}->{861325390} = "Luohe\,\ Henan";
$areanames{en}->{861325391} = "Luohe\,\ Henan";
$areanames{en}->{8613254} = "Shanghai";
$areanames{en}->{861325500} = "Quanzhou\,\ Fujian";
$areanames{en}->{861325501} = "Putian\,\ Fujian";
$areanames{en}->{861325502} = "Longyan\,\ Fujian";
$areanames{en}->{861325503} = "Quanzhou\,\ Fujian";
$areanames{en}->{861325504} = "Fuzhou\,\ Fujian";
$areanames{en}->{861325505} = "Fuzhou\,\ Fujian";
$areanames{en}->{861325506} = "Xiamen\,\ Fujian";
$areanames{en}->{861325507} = "Nanping\,\ Fujian";
$areanames{en}->{861325508} = "Nanping\,\ Fujian";
$areanames{en}->{861325509} = "Sanming\,\ Fujian";
$areanames{en}->{86132551} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861325510} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861325511} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861325520} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861325521} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861325522} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861325523} = "Nantong\,\ Jiangsu";
$areanames{en}->{861325524} = "Nantong\,\ Jiangsu";
$areanames{en}->{861325525} = "Nantong\,\ Jiangsu";
$areanames{en}->{861325526} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861325527} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861325528} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861325529} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861325530} = "Heze\,\ Shandong";
$areanames{en}->{861325531} = "Jinan\,\ Shandong";
$areanames{en}->{861325532} = "Qingdao\,\ Shandong";
$areanames{en}->{861325533} = "Zibo\,\ Shandong";
$areanames{en}->{861325534} = "Dezhou\,\ Shandong";
$areanames{en}->{861325535} = "Yantai\,\ Shandong";
$areanames{en}->{861325536} = "Weifang\,\ Shandong";
$areanames{en}->{861325537} = "Jining\,\ Shandong";
$areanames{en}->{861325538} = "TaiAn\,\ Shandong";
$areanames{en}->{861325539} = "Linyi\,\ Shandong";
$areanames{en}->{861325540} = "Heze\,\ Shandong";
$areanames{en}->{861325541} = "Jinan\,\ Shandong";
$areanames{en}->{861325542} = "Qingdao\,\ Shandong";
$areanames{en}->{861325543} = "Binzhou\,\ Shandong";
$areanames{en}->{861325544} = "Dezhou\,\ Shandong";
$areanames{en}->{861325545} = "Yantai\,\ Shandong";
$areanames{en}->{861325546} = "Dongying\,\ Shandong";
$areanames{en}->{861325547} = "Jining\,\ Shandong";
$areanames{en}->{861325548} = "TaiAn\,\ Shandong";
$areanames{en}->{861325549} = "Linyi\,\ Shandong";
$areanames{en}->{861325550} = "Yantai\,\ Shandong";
$areanames{en}->{861325551} = "Yantai\,\ Shandong";
$areanames{en}->{861325552} = "Yantai\,\ Shandong";
$areanames{en}->{861325553} = "Yantai\,\ Shandong";
$areanames{en}->{861325554} = "Yantai\,\ Shandong";
$areanames{en}->{861325555} = "Qingdao\,\ Shandong";
$areanames{en}->{861325556} = "Qingdao\,\ Shandong";
$areanames{en}->{861325557} = "Qingdao\,\ Shandong";
$areanames{en}->{861325558} = "Qingdao\,\ Shandong";
$areanames{en}->{861325559} = "Qingdao\,\ Shandong";
$areanames{en}->{861325560} = "Dongying\,\ Shandong";
$areanames{en}->{861325561} = "Dongying\,\ Shandong";
$areanames{en}->{861325562} = "Dongying\,\ Shandong";
$areanames{en}->{861325563} = "Dongying\,\ Shandong";
$areanames{en}->{861325564} = "Weihai\,\ Shandong";
$areanames{en}->{861325565} = "Weihai\,\ Shandong";
$areanames{en}->{861325566} = "Weihai\,\ Shandong";
$areanames{en}->{861325567} = "Weihai\,\ Shandong";
$areanames{en}->{861325568} = "Jinan\,\ Shandong";
$areanames{en}->{861325569} = "Jinan\,\ Shandong";
$areanames{en}->{861325570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861325571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861325573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861325574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861325576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861325578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861325579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861325580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861325581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861325582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861325583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861325584} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861325585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861325586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325587} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861325588} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861325589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861325590} = "Xiamen\,\ Fujian";
$areanames{en}->{861325591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861325592} = "Zhengzhou\,\ Henan";
$areanames{en}->{861325593} = "Ningde\,\ Fujian";
$areanames{en}->{861325594} = "Xiamen\,\ Fujian";
$areanames{en}->{861325595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861325596} = "Zhengzhou\,\ Henan";
$areanames{en}->{861325597} = "Longyan\,\ Fujian";
$areanames{en}->{861325598} = "Xiamen\,\ Fujian";
$areanames{en}->{861325599} = "Fuzhou\,\ Fujian";
$areanames{en}->{86132560} = "Rizhao\,\ Shandong";
$areanames{en}->{86132561} = "Jinan\,\ Shandong";
$areanames{en}->{86132562} = "Dezhou\,\ Shandong";
$areanames{en}->{861325620} = "Heze\,\ Shandong";
$areanames{en}->{861325621} = "Heze\,\ Shandong";
$areanames{en}->{861325628} = "Binzhou\,\ Shandong";
$areanames{en}->{861325629} = "Binzhou\,\ Shandong";
$areanames{en}->{861325630} = "Weihai\,\ Shandong";
$areanames{en}->{861325631} = "Weihai\,\ Shandong";
$areanames{en}->{861325632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861325633} = "Rizhao\,\ Shandong";
$areanames{en}->{861325634} = "Laiwu\,\ Shandong";
$areanames{en}->{861325635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861325636} = "Weifang\,\ Shandong";
$areanames{en}->{861325637} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861325638} = "Yantai\,\ Shandong";
$areanames{en}->{861325639} = "Qingdao\,\ Shandong";
$areanames{en}->{861325640} = "Jinan\,\ Shandong";
$areanames{en}->{861325641} = "Jinan\,\ Shandong";
$areanames{en}->{861325642} = "Liaocheng\,\ Shandong";
$areanames{en}->{861325643} = "Heze\,\ Shandong";
$areanames{en}->{861325644} = "Jinan\,\ Shandong";
$areanames{en}->{861325645} = "Yantai\,\ Shandong";
$areanames{en}->{861325646} = "Weifang\,\ Shandong";
$areanames{en}->{861325647} = "Dongying\,\ Shandong";
$areanames{en}->{861325648} = "Yantai\,\ Shandong";
$areanames{en}->{861325649} = "Binzhou\,\ Shandong";
$areanames{en}->{86132565} = "Linyi\,\ Shandong";
$areanames{en}->{861325660} = "Liaocheng\,\ Shandong";
$areanames{en}->{861325661} = "Liaocheng\,\ Shandong";
$areanames{en}->{861325662} = "Yantai\,\ Shandong";
$areanames{en}->{861325663} = "Heze\,\ Shandong";
$areanames{en}->{861325664} = "Heze\,\ Shandong";
$areanames{en}->{861325665} = "Jinan\,\ Shandong";
$areanames{en}->{861325666} = "Jinan\,\ Shandong";
$areanames{en}->{861325667} = "Jinan\,\ Shandong";
$areanames{en}->{861325668} = "Jinan\,\ Shandong";
$areanames{en}->{861325669} = "Jinan\,\ Shandong";
$areanames{en}->{86132567} = "Jinan\,\ Shandong";
$areanames{en}->{86132568} = "Qingdao\,\ Shandong";
$areanames{en}->{861325680} = "Weihai\,\ Shandong";
$areanames{en}->{861325681} = "Weihai\,\ Shandong";
$areanames{en}->{86132569} = "Yantai\,\ Shandong";
$areanames{en}->{861325700} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861325701} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861325702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861325703} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861325704} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861325705} = "Yichun\,\ Jiangxi";
$areanames{en}->{861325706} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861325707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861325708} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861325709} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861325710} = "Xiangfan\,\ Hubei";
$areanames{en}->{861325711} = "Xiaogan\,\ Hubei";
$areanames{en}->{861325712} = "Xiaogan\,\ Hubei";
$areanames{en}->{861325713} = "Huanggang\,\ Hubei";
$areanames{en}->{861325714} = "Huanggang\,\ Hubei";
$areanames{en}->{861325715} = "Xianning\,\ Hubei";
$areanames{en}->{861325716} = "Jingzhou\,\ Hubei";
$areanames{en}->{861325717} = "Huanggang\,\ Hubei";
$areanames{en}->{861325718} = "Enshi\,\ Hubei";
$areanames{en}->{861325719} = "Huanggang\,\ Hubei";
$areanames{en}->{861325720} = "Xianning\,\ Hubei";
$areanames{en}->{861325721} = "Jingzhou\,\ Hubei";
$areanames{en}->{861325722} = "Suizhou\,\ Hubei";
$areanames{en}->{861325723} = "Jingmen\,\ Hubei";
$areanames{en}->{861325724} = "Jingmen\,\ Hubei";
$areanames{en}->{861325725} = "Enshi\,\ Hubei";
$areanames{en}->{861325726} = "Enshi\,\ Hubei";
$areanames{en}->{861325727} = "Xiangfan\,\ Hubei";
$areanames{en}->{861325728} = "Wuhan\,\ Hubei";
$areanames{en}->{861325729} = "Xiangfan\,\ Hubei";
$areanames{en}->{861325730} = "Yueyang\,\ Hunan";
$areanames{en}->{861325731} = "Changsha\,\ Hunan";
$areanames{en}->{861325732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861325733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861325734} = "Hengyang\,\ Hunan";
$areanames{en}->{861325735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861325736} = "Changde\,\ Hunan";
$areanames{en}->{861325737} = "Yiyang\,\ Hunan";
$areanames{en}->{861325738} = "Loudi\,\ Hunan";
$areanames{en}->{861325739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861325740} = "Yueyang\,\ Hunan";
$areanames{en}->{861325741} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861325742} = "Changde\,\ Hunan";
$areanames{en}->{861325743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861325744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861325745} = "Huaihua\,\ Hunan";
$areanames{en}->{861325746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861325747} = "Yiyang\,\ Hunan";
$areanames{en}->{861325748} = "Changsha\,\ Hunan";
$areanames{en}->{861325749} = "Xiangtan\,\ Hunan";
$areanames{en}->{861325750} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861325751} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861325752} = "Huizhou\,\ Guangdong";
$areanames{en}->{861325753} = "Meizhou\,\ Guangdong";
$areanames{en}->{861325754} = "Shantou\,\ Guangdong";
$areanames{en}->{861325755} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861325756} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861325757} = "Foshan\,\ Guangdong";
$areanames{en}->{861325758} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861325759} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861325760} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861325761} = "Shanwei\,\ Guangdong";
$areanames{en}->{861325762} = "Heyuan\,\ Guangdong";
$areanames{en}->{861325763} = "Baoding\,\ Hebei";
$areanames{en}->{861325764} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861325765} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861325766} = "Yunfu\,\ Guangdong";
$areanames{en}->{861325767} = "Maoming\,\ Guangdong";
$areanames{en}->{861325768} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861325769} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132577} = "Nanning\,\ Guangxi";
$areanames{en}->{861325780} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861325781} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861325782} = "Laibin\,\ Guangxi";
$areanames{en}->{861325783} = "Laibin\,\ Guangxi";
$areanames{en}->{861325784} = "Laibin\,\ Guangxi";
$areanames{en}->{861325785} = "Yulin\,\ Guangxi";
$areanames{en}->{861325786} = "Yulin\,\ Guangxi";
$areanames{en}->{861325787} = "Yulin\,\ Guangxi";
$areanames{en}->{861325788} = "Yulin\,\ Guangxi";
$areanames{en}->{861325789} = "Yulin\,\ Guangxi";
$areanames{en}->{861325790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861325791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861325792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861325793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861325794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861325795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861325796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861325797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861325798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861325799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86132580} = "Jining\,\ Shandong";
$areanames{en}->{861325806} = "Weifang\,\ Shandong";
$areanames{en}->{861325807} = "Weifang\,\ Shandong";
$areanames{en}->{861325808} = "Weifang\,\ Shandong";
$areanames{en}->{861325809} = "Weifang\,\ Shandong";
$areanames{en}->{86132581} = "Chengdu\,\ Sichuan";
$areanames{en}->{86132582} = "Chengdu\,\ Sichuan";
$areanames{en}->{86132583} = "Chengdu\,\ Sichuan";
$areanames{en}->{861325840} = "Nanchong\,\ Sichuan";
$areanames{en}->{861325841} = "Nanchong\,\ Sichuan";
$areanames{en}->{861325842} = "Mianyang\,\ Sichuan";
$areanames{en}->{861325843} = "Mianyang\,\ Sichuan";
$areanames{en}->{861325844} = "Mianyang\,\ Sichuan";
$areanames{en}->{861325845} = "Mianyang\,\ Sichuan";
$areanames{en}->{861325846} = "Deyang\,\ Sichuan";
$areanames{en}->{861325847} = "Deyang\,\ Sichuan";
$areanames{en}->{861325848} = "Suining\,\ Sichuan";
$areanames{en}->{861325849} = "GuangAn\,\ Sichuan";
$areanames{en}->{861325850} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861325851} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861325852} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861325853} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861325854} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861325855} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861325856} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861325857} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861325858} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861325859} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861325860} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861325861} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861325862} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861325863} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861325864} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861325865} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861325866} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861325867} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861325868} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861325869} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{86132587} = "Siping\,\ Jilin";
$areanames{en}->{861325874} = "Tonghua\,\ Jilin";
$areanames{en}->{861325875} = "Tonghua\,\ Jilin";
$areanames{en}->{861325876} = "Tonghua\,\ Jilin";
$areanames{en}->{861325877} = "Tonghua\,\ Jilin";
$areanames{en}->{861325880} = "Siping\,\ Jilin";
$areanames{en}->{861325881} = "Yanbian\,\ Jilin";
$areanames{en}->{861325882} = "Yanbian\,\ Jilin";
$areanames{en}->{861325883} = "Yanbian\,\ Jilin";
$areanames{en}->{861325884} = "Changchun\,\ Jilin";
$areanames{en}->{861325885} = "Tonghua\,\ Jilin";
$areanames{en}->{861325886} = "Baicheng\,\ Jilin";
$areanames{en}->{861325887} = "Baicheng\,\ Jilin";
$areanames{en}->{861325888} = "Changchun\,\ Jilin";
$areanames{en}->{861325889} = "Baishan\,\ Jilin";
$areanames{en}->{861325890} = "Binzhou\,\ Shandong";
$areanames{en}->{861325891} = "Binzhou\,\ Shandong";
$areanames{en}->{861325892} = "Heze\,\ Shandong";
$areanames{en}->{861325893} = "Heze\,\ Shandong";
$areanames{en}->{861325894} = "Rizhao\,\ Shandong";
$areanames{en}->{861325895} = "Rizhao\,\ Shandong";
$areanames{en}->{861325896} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861325897} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861325898} = "Liaocheng\,\ Shandong";
$areanames{en}->{861325899} = "Liaocheng\,\ Shandong";
$areanames{en}->{86132590} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861325906} = "Weinan\,\ Shaanxi";
$areanames{en}->{861325907} = "Weinan\,\ Shaanxi";
$areanames{en}->{861325908} = "Weinan\,\ Shaanxi";
$areanames{en}->{861325909} = "Weinan\,\ Shaanxi";
$areanames{en}->{861325910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861325911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861325912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861325913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861325914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861325915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861325916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861325917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861325918} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861325919} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861325920} = "Weinan\,\ Shaanxi";
$areanames{en}->{861325921} = "Baoji\,\ Shaanxi";
$areanames{en}->{861325922} = "Baoji\,\ Shaanxi";
$areanames{en}->{861325923} = "Baoji\,\ Shaanxi";
$areanames{en}->{861325924} = "Baoji\,\ Shaanxi";
$areanames{en}->{861325925} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861325926} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861325927} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861325928} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861325929} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{86132593} = "Yulin\,\ Shaanxi";
$areanames{en}->{861325930} = "YanAn\,\ Shaanxi";
$areanames{en}->{861325931} = "YanAn\,\ Shaanxi";
$areanames{en}->{861325932} = "YanAn\,\ Shaanxi";
$areanames{en}->{861325939} = "Ankang\,\ Shaanxi";
$areanames{en}->{86132594} = "XiAn\,\ Shaanxi";
$areanames{en}->{861325950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861325951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861325952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861325953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861325954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861325955} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861325956} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861325957} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861325958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861325959} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861325960} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861325961} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861325962} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861325963} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861325964} = "Guyuan\,\ Ningxia";
$areanames{en}->{861325965} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861325966} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861325967} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861325968} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861325969} = "Zhongwei\,\ Ningxia";
$areanames{en}->{86132597} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132598} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132599} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132600} = "Beijing";
$areanames{en}->{861326004} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{86132601} = "Beijing";
$areanames{en}->{861326014} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{86132602} = "Beijing";
$areanames{en}->{861326024} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{86132603} = "Beijing";
$areanames{en}->{861326034} = "Qingyang\,\ Gansu";
$areanames{en}->{86132604} = "Beijing";
$areanames{en}->{86132605} = "Wuhan\,\ Hubei";
$areanames{en}->{86132606} = "Wuhan\,\ Hubei";
$areanames{en}->{86132607} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86132608} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861326089} = "Shaoyang\,\ Hunan";
$areanames{en}->{86132609} = "Nanjing\,\ Jiangsu";
$areanames{en}->{8613261} = "Beijing";
$areanames{en}->{8613262} = "Shanghai";
$areanames{en}->{86132620} = "Nanyang\,\ Henan";
$areanames{en}->{86132621} = "Xinxiang\,\ Henan";
$areanames{en}->{86132623} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86132624} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861326300} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861326301} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861326302} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861326303} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861326304} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861326305} = "Yichun\,\ Jiangxi";
$areanames{en}->{861326306} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861326307} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861326308} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861326309} = "Nanchang\,\ Jiangxi";
$areanames{en}->{86132631} = "Beijing";
$areanames{en}->{86132632} = "Beijing";
$areanames{en}->{861326324} = "Qingyang\,\ Gansu";
$areanames{en}->{86132633} = "Beijing";
$areanames{en}->{861326334} = "Qingyang\,\ Gansu";
$areanames{en}->{86132634} = "Beijing";
$areanames{en}->{861326350} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861326351} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861326352} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861326353} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861326354} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861326355} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861326356} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861326357} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861326358} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861326359} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86132636} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861326364} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861326365} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861326370} = "Nanning\,\ Guangxi";
$areanames{en}->{861326371} = "Nanning\,\ Guangxi";
$areanames{en}->{861326372} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861326373} = "Guilin\,\ Guangxi";
$areanames{en}->{861326374} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861326375} = "Yulin\,\ Guangxi";
$areanames{en}->{861326376} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861326377} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861326378} = "Nanning\,\ Guangxi";
$areanames{en}->{861326379} = "Hezhou\,\ Guangxi";
$areanames{en}->{861326380} = "Nanning\,\ Guangxi";
$areanames{en}->{861326381} = "Nanning\,\ Guangxi";
$areanames{en}->{861326382} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861326383} = "Guilin\,\ Guangxi";
$areanames{en}->{861326384} = "Hezhou\,\ Guangxi";
$areanames{en}->{861326385} = "Laibin\,\ Guangxi";
$areanames{en}->{861326386} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861326387} = "Laibin\,\ Guangxi";
$areanames{en}->{861326388} = "Nanning\,\ Guangxi";
$areanames{en}->{861326389} = "Guigang\,\ Guangxi";
$areanames{en}->{861326390} = "Yichun\,\ Jiangxi";
$areanames{en}->{861326391} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861326392} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861326393} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861326394} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861326395} = "Yichun\,\ Jiangxi";
$areanames{en}->{861326396} = "JiAn\,\ Jiangxi";
$areanames{en}->{861326397} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861326398} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861326399} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{8613264} = "Beijing";
$areanames{en}->{861326454} = "Linxia\,\ Gansu";
$areanames{en}->{86132646} = "Jingzhou\,\ Hubei";
$areanames{en}->{861326470} = "Wuhan\,\ Hubei";
$areanames{en}->{861326471} = "Wuhan\,\ Hubei";
$areanames{en}->{861326472} = "Wuhan\,\ Hubei";
$areanames{en}->{861326473} = "Wuhan\,\ Hubei";
$areanames{en}->{861326474} = "Wuhan\,\ Hubei";
$areanames{en}->{861326475} = "Suizhou\,\ Hubei";
$areanames{en}->{861326476} = "Suizhou\,\ Hubei";
$areanames{en}->{861326477} = "Xiangfan\,\ Hubei";
$areanames{en}->{861326478} = "Xiangfan\,\ Hubei";
$areanames{en}->{861326479} = "Xiangfan\,\ Hubei";
$areanames{en}->{861326480} = "Huanggang\,\ Hubei";
$areanames{en}->{861326481} = "Huanggang\,\ Hubei";
$areanames{en}->{861326482} = "Huanggang\,\ Hubei";
$areanames{en}->{861326483} = "Huanggang\,\ Hubei";
$areanames{en}->{861326484} = "Xiaogan\,\ Hubei";
$areanames{en}->{861326485} = "Xiaogan\,\ Hubei";
$areanames{en}->{861326486} = "Xiaogan\,\ Hubei";
$areanames{en}->{861326487} = "Xiaogan\,\ Hubei";
$areanames{en}->{861326488} = "Shiyan\,\ Hubei";
$areanames{en}->{861326489} = "Shiyan\,\ Hubei";
$areanames{en}->{861326490} = "Yichang\,\ Hubei";
$areanames{en}->{861326491} = "Yichang\,\ Hubei";
$areanames{en}->{861326492} = "Enshi\,\ Hubei";
$areanames{en}->{861326493} = "Enshi\,\ Hubei";
$areanames{en}->{861326494} = "Ezhou\,\ Hubei";
$areanames{en}->{861326495} = "Jingmen\,\ Hubei";
$areanames{en}->{861326496} = "Jingmen\,\ Hubei";
$areanames{en}->{861326497} = "Wuhan\,\ Hubei";
$areanames{en}->{861326498} = "Wuhan\,\ Hubei";
$areanames{en}->{861326499} = "Ezhou\,\ Hubei";
$areanames{en}->{86132650} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132651} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132652} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132653} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132654} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132655} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326550} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861326551} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132656} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132657} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132658} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132659} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132660} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132661} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132662} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132663} = "Foshan\,\ Guangdong";
$areanames{en}->{861326640} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326641} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326642} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326643} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326644} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326645} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326646} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326647} = "Xingtai\,\ Hebei";
$areanames{en}->{861326648} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326649} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86132665} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132666} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132667} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132668} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326690} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861326691} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861326692} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326693} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326694} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326695} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326696} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326697} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326698} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326699} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132670} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86132671} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326720} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326721} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326722} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326723} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326724} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861326725} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326726} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326727} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326728} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326729} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132673} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132674} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132675} = "Dongguan\,\ Guangdong";
$areanames{en}->{861326760} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861326761} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861326762} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861326763} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861326764} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861326765} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326766} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326767} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326768} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326769} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861326770} = "Shanwei\,\ Guangdong";
$areanames{en}->{861326771} = "Shanwei\,\ Guangdong";
$areanames{en}->{861326772} = "Shanwei\,\ Guangdong";
$areanames{en}->{861326773} = "Shanwei\,\ Guangdong";
$areanames{en}->{861326774} = "Shanwei\,\ Guangdong";
$areanames{en}->{861326775} = "Shantou\,\ Guangdong";
$areanames{en}->{861326776} = "Shantou\,\ Guangdong";
$areanames{en}->{861326777} = "Shantou\,\ Guangdong";
$areanames{en}->{861326778} = "Shantou\,\ Guangdong";
$areanames{en}->{861326779} = "Shantou\,\ Guangdong";
$areanames{en}->{861326780} = "Meizhou\,\ Guangdong";
$areanames{en}->{861326781} = "Meizhou\,\ Guangdong";
$areanames{en}->{861326782} = "Meizhou\,\ Guangdong";
$areanames{en}->{861326783} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861326784} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861326785} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326786} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326787} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326788} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326789} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861326790} = "Huizhou\,\ Guangdong";
$areanames{en}->{861326791} = "Huizhou\,\ Guangdong";
$areanames{en}->{861326792} = "Huizhou\,\ Guangdong";
$areanames{en}->{861326793} = "Huizhou\,\ Guangdong";
$areanames{en}->{861326794} = "Huizhou\,\ Guangdong";
$areanames{en}->{861326795} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861326796} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861326797} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861326798} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861326799} = "Zhuhai\,\ Guangdong";
$areanames{en}->{8613268} = "Dongguan\,\ Guangdong";
$areanames{en}->{86132680} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132681} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132682} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132683} = "Guangzhou\,\ Guangdong";
$areanames{en}->{8613269} = "Beijing";
$areanames{en}->{861326914} = "Linxia\,\ Gansu";
$areanames{en}->{861326924} = "Linxia\,\ Gansu";
$areanames{en}->{861326934} = "Zhangye\,\ Gansu";
$areanames{en}->{861326954} = "Qingyang\,\ Gansu";
$areanames{en}->{861326984} = "Pingliang\,\ Gansu";
$areanames{en}->{861326994} = "Tianshui\,\ Gansu";
$areanames{en}->{86132700} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327000} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861327001} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{86132701} = "Wuxi\,\ Jiangsu";
$areanames{en}->{86132702} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861327030} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861327031} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861327032} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861327033} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861327034} = "Baiyin\,\ Gansu";
$areanames{en}->{861327035} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861327036} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861327037} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327038} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327039} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327040} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861327041} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861327042} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861327043} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327044} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861327045} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861327046} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861327047} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861327048} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861327049} = "Shaoyang\,\ Hunan";
$areanames{en}->{86132705} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{86132706} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327060} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861327063} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861327064} = "Chenzhou\,\ Hunan";
$areanames{en}->{861327065} = "Chenzhou\,\ Hunan";
$areanames{en}->{86132707} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861327076} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861327077} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861327078} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861327079} = "Taizhou\,\ Jiangsu";
$areanames{en}->{86132708} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86132709} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327096} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861327097} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861327098} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861327099} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86132710} = "Shangqiu\,\ Henan";
$areanames{en}->{861327110} = "Shangqiu\,\ Henan";
$areanames{en}->{861327111} = "Shangqiu\,\ Henan";
$areanames{en}->{861327112} = "Xinyang\,\ Henan";
$areanames{en}->{861327113} = "Xinyang\,\ Henan";
$areanames{en}->{861327114} = "Kaifeng\,\ Henan";
$areanames{en}->{861327115} = "Kaifeng\,\ Henan";
$areanames{en}->{861327116} = "Zhoukou\,\ Henan";
$areanames{en}->{861327117} = "Zhoukou\,\ Henan";
$areanames{en}->{861327118} = "Xuchang\,\ Henan";
$areanames{en}->{861327119} = "Xuchang\,\ Henan";
$areanames{en}->{86132712} = "Xuchang\,\ Henan";
$areanames{en}->{86132713} = "Nanyang\,\ Henan";
$areanames{en}->{86132714} = "Pingdingshan\,\ Henan";
$areanames{en}->{861327150} = "Luoyang\,\ Henan";
$areanames{en}->{861327151} = "Luoyang\,\ Henan";
$areanames{en}->{861327152} = "Luoyang\,\ Henan";
$areanames{en}->{861327153} = "Luoyang\,\ Henan";
$areanames{en}->{861327154} = "Luoyang\,\ Henan";
$areanames{en}->{861327155} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327156} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327157} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327158} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327159} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132716} = "Zhoukou\,\ Henan";
$areanames{en}->{86132717} = "Zhumadian\,\ Henan";
$areanames{en}->{861327178} = "Nanyang\,\ Henan";
$areanames{en}->{861327179} = "Nanyang\,\ Henan";
$areanames{en}->{86132718} = "Chongqing";
$areanames{en}->{86132719} = "Chongqing";
$areanames{en}->{86132720} = "Changsha\,\ Hunan";
$areanames{en}->{861327210} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861327211} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861327212} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861327213} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861327214} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861327215} = "Yiyang\,\ Hunan";
$areanames{en}->{861327216} = "Yiyang\,\ Hunan";
$areanames{en}->{861327217} = "Yiyang\,\ Hunan";
$areanames{en}->{861327218} = "Yiyang\,\ Hunan";
$areanames{en}->{861327219} = "Yiyang\,\ Hunan";
$areanames{en}->{86132722} = "Huaihua\,\ Hunan";
$areanames{en}->{861327220} = "Shaoyang\,\ Hunan";
$areanames{en}->{861327221} = "Hengyang\,\ Hunan";
$areanames{en}->{861327222} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861327223} = "Changsha\,\ Hunan";
$areanames{en}->{861327230} = "Hengyang\,\ Hunan";
$areanames{en}->{861327231} = "Hengyang\,\ Hunan";
$areanames{en}->{861327232} = "Hengyang\,\ Hunan";
$areanames{en}->{861327233} = "Hengyang\,\ Hunan";
$areanames{en}->{861327234} = "Hengyang\,\ Hunan";
$areanames{en}->{861327235} = "Chenzhou\,\ Hunan";
$areanames{en}->{861327236} = "Chenzhou\,\ Hunan";
$areanames{en}->{861327237} = "Chenzhou\,\ Hunan";
$areanames{en}->{861327238} = "Chenzhou\,\ Hunan";
$areanames{en}->{861327239} = "Chenzhou\,\ Hunan";
$areanames{en}->{86132724} = "Changsha\,\ Hunan";
$areanames{en}->{86132725} = "Chongqing";
$areanames{en}->{86132726} = "Chongqing";
$areanames{en}->{86132727} = "Chongqing";
$areanames{en}->{86132728} = "Chongqing";
$areanames{en}->{86132729} = "Chongqing";
$areanames{en}->{861327300} = "Zhoukou\,\ Henan";
$areanames{en}->{861327301} = "Zhoukou\,\ Henan";
$areanames{en}->{861327302} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327303} = "Puyang\,\ Henan";
$areanames{en}->{861327304} = "Kaifeng\,\ Henan";
$areanames{en}->{861327305} = "Luohe\,\ Henan";
$areanames{en}->{861327306} = "Luohe\,\ Henan";
$areanames{en}->{861327307} = "Luohe\,\ Henan";
$areanames{en}->{861327308} = "Sanmenxia\,\ Henan";
$areanames{en}->{861327309} = "Sanmenxia\,\ Henan";
$areanames{en}->{86132731} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86132732} = "Baoding\,\ Hebei";
$areanames{en}->{861327330} = "Hengshui\,\ Hebei";
$areanames{en}->{861327331} = "Hengshui\,\ Hebei";
$areanames{en}->{861327332} = "Hengshui\,\ Hebei";
$areanames{en}->{861327333} = "Hengshui\,\ Hebei";
$areanames{en}->{861327334} = "Hengshui\,\ Hebei";
$areanames{en}->{861327335} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861327336} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861327337} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861327338} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861327339} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861327340} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861327341} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861327342} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861327343} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861327344} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861327345} = "Xingtai\,\ Hebei";
$areanames{en}->{861327346} = "Xingtai\,\ Hebei";
$areanames{en}->{861327347} = "Xingtai\,\ Hebei";
$areanames{en}->{861327348} = "Xingtai\,\ Hebei";
$areanames{en}->{861327349} = "Xingtai\,\ Hebei";
$areanames{en}->{86132735} = "Tangshan\,\ Hebei";
$areanames{en}->{861327360} = "Langfang\,\ Hebei";
$areanames{en}->{861327361} = "Langfang\,\ Hebei";
$areanames{en}->{861327362} = "Langfang\,\ Hebei";
$areanames{en}->{861327363} = "Langfang\,\ Hebei";
$areanames{en}->{861327364} = "Langfang\,\ Hebei";
$areanames{en}->{861327365} = "Xingtai\,\ Hebei";
$areanames{en}->{861327366} = "Xingtai\,\ Hebei";
$areanames{en}->{861327367} = "Xingtai\,\ Hebei";
$areanames{en}->{861327368} = "Xingtai\,\ Hebei";
$areanames{en}->{861327369} = "Xingtai\,\ Hebei";
$areanames{en}->{861327370} = "Shangqiu\,\ Henan";
$areanames{en}->{861327371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327372} = "Xinxiang\,\ Henan";
$areanames{en}->{861327373} = "Xinxiang\,\ Henan";
$areanames{en}->{861327374} = "Xuchang\,\ Henan";
$areanames{en}->{861327375} = "Pingdingshan\,\ Henan";
$areanames{en}->{861327376} = "Xinyang\,\ Henan";
$areanames{en}->{861327377} = "Nanyang\,\ Henan";
$areanames{en}->{861327378} = "Kaifeng\,\ Henan";
$areanames{en}->{861327379} = "Nanyang\,\ Henan";
$areanames{en}->{861327380} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327381} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327382} = "Shangqiu\,\ Henan";
$areanames{en}->{861327383} = "Shangqiu\,\ Henan";
$areanames{en}->{861327384} = "Shangqiu\,\ Henan";
$areanames{en}->{861327385} = "Xuchang\,\ Henan";
$areanames{en}->{861327386} = "Xuchang\,\ Henan";
$areanames{en}->{861327387} = "Xuchang\,\ Henan";
$areanames{en}->{861327388} = "Pingdingshan\,\ Henan";
$areanames{en}->{861327389} = "Pingdingshan\,\ Henan";
$areanames{en}->{861327390} = "Jiaozuo\,\ Henan";
$areanames{en}->{861327391} = "Jiaozuo\,\ Henan";
$areanames{en}->{861327392} = "Hebi\,\ Henan";
$areanames{en}->{861327393} = "Puyang\,\ Henan";
$areanames{en}->{861327394} = "Zhoukou\,\ Henan";
$areanames{en}->{861327395} = "Luohe\,\ Henan";
$areanames{en}->{861327396} = "Zhumadian\,\ Henan";
$areanames{en}->{861327397} = "Xinyang\,\ Henan";
$areanames{en}->{861327398} = "Sanmenxia\,\ Henan";
$areanames{en}->{861327399} = "Zhumadian\,\ Henan";
$areanames{en}->{86132740} = "Chongqing";
$areanames{en}->{861327410} = "Tieling\,\ Liaoning";
$areanames{en}->{861327411} = "Dalian\,\ Liaoning";
$areanames{en}->{861327412} = "Anshan\,\ Liaoning";
$areanames{en}->{861327413} = "Fushun\,\ Liaoning";
$areanames{en}->{861327414} = "Benxi\,\ Liaoning";
$areanames{en}->{861327415} = "Dandong\,\ Liaoning";
$areanames{en}->{861327416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861327417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861327418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861327419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861327420} = "Tieling\,\ Liaoning";
$areanames{en}->{861327421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861327422} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861327423} = "Fushun\,\ Liaoning";
$areanames{en}->{861327424} = "Shenyang\,\ Liaoning";
$areanames{en}->{861327425} = "Shenyang\,\ Liaoning";
$areanames{en}->{861327426} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861327427} = "Panjin\,\ Liaoning";
$areanames{en}->{861327428} = "Huludao\,\ Liaoning";
$areanames{en}->{861327429} = "Huludao\,\ Liaoning";
$areanames{en}->{861327430} = "Changchun\,\ Jilin";
$areanames{en}->{861327431} = "Changchun\,\ Jilin";
$areanames{en}->{861327432} = "Jilin\,\ Jilin";
$areanames{en}->{861327433} = "Yanbian\,\ Jilin";
$areanames{en}->{861327434} = "Siping\,\ Jilin";
$areanames{en}->{861327435} = "Tonghua\,\ Jilin";
$areanames{en}->{861327436} = "Baicheng\,\ Jilin";
$areanames{en}->{861327437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327438} = "Songyuan\,\ Jilin";
$areanames{en}->{861327439} = "Baishan\,\ Jilin";
$areanames{en}->{86132744} = "Jilin\,\ Jilin";
$areanames{en}->{861327450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861327451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861327452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861327453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861327454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861327455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861327456} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861327457} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861327458} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861327459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861327460} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861327461} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861327462} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861327463} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861327464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861327465} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861327466} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861327467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861327468} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861327469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861327470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861327471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861327472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861327473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861327474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861327475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861327476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861327477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861327478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861327479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861327480} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861327481} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861327482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861327483} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861327484} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861327485} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861327486} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861327487} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861327488} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861327489} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{86132749} = "Chongqing";
$areanames{en}->{861327500} = "Xiamen\,\ Fujian";
$areanames{en}->{861327501} = "Fuzhou\,\ Fujian";
$areanames{en}->{861327502} = "Xiamen\,\ Fujian";
$areanames{en}->{861327503} = "Longyan\,\ Fujian";
$areanames{en}->{861327504} = "Xiamen\,\ Fujian";
$areanames{en}->{861327505} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327506} = "Sanming\,\ Fujian";
$areanames{en}->{861327507} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327508} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327509} = "Nanping\,\ Fujian";
$areanames{en}->{861327510} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861327511} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861327512} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861327513} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327514} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861327515} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327516} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861327517} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861327518} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327519} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327520} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327521} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327522} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327523} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327524} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861327525} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327526} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327527} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327528} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327529} = "Nantong\,\ Jiangsu";
$areanames{en}->{861327530} = "Heze\,\ Shandong";
$areanames{en}->{861327531} = "Jinan\,\ Shandong";
$areanames{en}->{861327532} = "Qingdao\,\ Shandong";
$areanames{en}->{861327533} = "Zibo\,\ Shandong";
$areanames{en}->{861327534} = "Dezhou\,\ Shandong";
$areanames{en}->{861327535} = "Yantai\,\ Shandong";
$areanames{en}->{861327536} = "Weifang\,\ Shandong";
$areanames{en}->{861327537} = "Jining\,\ Shandong";
$areanames{en}->{861327538} = "TaiAn\,\ Shandong";
$areanames{en}->{861327539} = "Linyi\,\ Shandong";
$areanames{en}->{861327540} = "Heze\,\ Shandong";
$areanames{en}->{861327541} = "Jinan\,\ Shandong";
$areanames{en}->{861327542} = "Qingdao\,\ Shandong";
$areanames{en}->{861327543} = "Binzhou\,\ Shandong";
$areanames{en}->{861327544} = "Dezhou\,\ Shandong";
$areanames{en}->{861327545} = "Yantai\,\ Shandong";
$areanames{en}->{861327546} = "Dongying\,\ Shandong";
$areanames{en}->{861327547} = "Jining\,\ Shandong";
$areanames{en}->{861327548} = "TaiAn\,\ Shandong";
$areanames{en}->{861327549} = "Linyi\,\ Shandong";
$areanames{en}->{861327550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861327551} = "Hefei\,\ Anhui";
$areanames{en}->{861327552} = "Bengbu\,\ Anhui";
$areanames{en}->{861327553} = "Wuhu\,\ Anhui";
$areanames{en}->{861327554} = "Huainan\,\ Anhui";
$areanames{en}->{861327555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861327556} = "Anqing\,\ Anhui";
$areanames{en}->{861327557} = "Suzhou\,\ Anhui";
$areanames{en}->{861327558} = "Fuyang\,\ Anhui";
$areanames{en}->{861327559} = "Huangshan\,\ Anhui";
$areanames{en}->{861327560} = "Hefei\,\ Anhui";
$areanames{en}->{861327561} = "Huaibei\,\ Anhui";
$areanames{en}->{861327562} = "Tongling\,\ Anhui";
$areanames{en}->{861327563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861327564} = "LuAn\,\ Anhui";
$areanames{en}->{861327565} = "Hefei\,\ Anhui";
$areanames{en}->{861327566} = "Chizhou\,\ Anhui";
$areanames{en}->{861327567} = "Bozhou\,\ Anhui";
$areanames{en}->{861327568} = "Fuyang\,\ Anhui";
$areanames{en}->{861327569} = "Hefei\,\ Anhui";
$areanames{en}->{86132757} = "Anqing\,\ Anhui";
$areanames{en}->{861327575} = "Hefei\,\ Anhui";
$areanames{en}->{861327576} = "Hefei\,\ Anhui";
$areanames{en}->{861327577} = "Hefei\,\ Anhui";
$areanames{en}->{861327579} = "Hefei\,\ Anhui";
$areanames{en}->{86132758} = "LuAn\,\ Anhui";
$areanames{en}->{861327585} = "Hefei\,\ Anhui";
$areanames{en}->{861327586} = "Hefei\,\ Anhui";
$areanames{en}->{861327587} = "Hefei\,\ Anhui";
$areanames{en}->{861327589} = "Hefei\,\ Anhui";
$areanames{en}->{861327590} = "Fuzhou\,\ Fujian";
$areanames{en}->{861327591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861327592} = "Xiamen\,\ Fujian";
$areanames{en}->{861327593} = "Ningde\,\ Fujian";
$areanames{en}->{861327594} = "Putian\,\ Fujian";
$areanames{en}->{861327595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861327597} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327598} = "Sanming\,\ Fujian";
$areanames{en}->{861327599} = "Nanping\,\ Fujian";
$areanames{en}->{861327600} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327601} = "Fuzhou\,\ Fujian";
$areanames{en}->{861327602} = "Xiamen\,\ Fujian";
$areanames{en}->{861327603} = "Ningde\,\ Fujian";
$areanames{en}->{861327604} = "Fuzhou\,\ Fujian";
$areanames{en}->{861327605} = "Sanming\,\ Fujian";
$areanames{en}->{861327606} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861327607} = "Nanping\,\ Fujian";
$areanames{en}->{861327608} = "Fuzhou\,\ Fujian";
$areanames{en}->{861327609} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327610} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327611} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327612} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327613} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327614} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327615} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861327616} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861327617} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861327618} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861327619} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{86132762} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861327620} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327621} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861327630} = "Weihai\,\ Shandong";
$areanames{en}->{861327631} = "Weihai\,\ Shandong";
$areanames{en}->{861327632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861327633} = "Rizhao\,\ Shandong";
$areanames{en}->{861327634} = "Laiwu\,\ Shandong";
$areanames{en}->{861327635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861327636} = "Weifang\,\ Shandong";
$areanames{en}->{861327637} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861327638} = "Yantai\,\ Shandong";
$areanames{en}->{861327639} = "Qingdao\,\ Shandong";
$areanames{en}->{861327640} = "Jinan\,\ Shandong";
$areanames{en}->{861327641} = "Jinan\,\ Shandong";
$areanames{en}->{861327642} = "Qingdao\,\ Shandong";
$areanames{en}->{861327643} = "Zibo\,\ Shandong";
$areanames{en}->{861327644} = "Jinan\,\ Shandong";
$areanames{en}->{861327645} = "Yantai\,\ Shandong";
$areanames{en}->{861327646} = "Weifang\,\ Shandong";
$areanames{en}->{861327647} = "Dongying\,\ Shandong";
$areanames{en}->{861327648} = "Qingdao\,\ Shandong";
$areanames{en}->{861327649} = "Jinan\,\ Shandong";
$areanames{en}->{86132765} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861327650} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861327651} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861327659} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{86132766} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861327669} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861327670} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861327671} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861327672} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861327673} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861327674} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861327675} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861327676} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861327677} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861327678} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861327679} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861327680} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861327681} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861327682} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861327683} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861327684} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861327685} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861327686} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861327687} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861327688} = "Lishui\,\ Zhejiang";
$areanames{en}->{861327689} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861327690} = "Zhengzhou\,\ Henan";
$areanames{en}->{861327691} = "Fuzhou\,\ Fujian";
$areanames{en}->{861327692} = "Putian\,\ Fujian";
$areanames{en}->{861327693} = "Longyan\,\ Fujian";
$areanames{en}->{861327694} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327695} = "Ningde\,\ Fujian";
$areanames{en}->{861327696} = "Xiamen\,\ Fujian";
$areanames{en}->{861327697} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861327698} = "Quanzhou\,\ Fujian";
$areanames{en}->{861327699} = "Fuzhou\,\ Fujian";
$areanames{en}->{86132770} = "Wuhan\,\ Hubei";
$areanames{en}->{861327700} = "Xiaogan\,\ Hubei";
$areanames{en}->{861327701} = "Xiaogan\,\ Hubei";
$areanames{en}->{861327702} = "Xiaogan\,\ Hubei";
$areanames{en}->{861327710} = "Xiangfan\,\ Hubei";
$areanames{en}->{861327711} = "Xiangfan\,\ Hubei";
$areanames{en}->{861327712} = "Xiaogan\,\ Hubei";
$areanames{en}->{861327713} = "Huanggang\,\ Hubei";
$areanames{en}->{861327714} = "Huanggang\,\ Hubei";
$areanames{en}->{861327715} = "Xianning\,\ Hubei";
$areanames{en}->{861327716} = "Jingzhou\,\ Hubei";
$areanames{en}->{861327717} = "Yichang\,\ Hubei";
$areanames{en}->{861327718} = "Enshi\,\ Hubei";
$areanames{en}->{861327719} = "Shiyan\,\ Hubei";
$areanames{en}->{861327720} = "Huanggang\,\ Hubei";
$areanames{en}->{861327721} = "Huanggang\,\ Hubei";
$areanames{en}->{861327722} = "Suizhou\,\ Hubei";
$areanames{en}->{861327723} = "Yichang\,\ Hubei";
$areanames{en}->{861327724} = "Jingmen\,\ Hubei";
$areanames{en}->{861327725} = "Yichang\,\ Hubei";
$areanames{en}->{861327726} = "Shiyan\,\ Hubei";
$areanames{en}->{861327727} = "Xiangfan\,\ Hubei";
$areanames{en}->{861327728} = "Wuhan\,\ Hubei";
$areanames{en}->{861327729} = "Xiangfan\,\ Hubei";
$areanames{en}->{86132773} = "Jingzhou\,\ Hubei";
$areanames{en}->{861327739} = "Yichang\,\ Hubei";
$areanames{en}->{86132774} = "Wuhan\,\ Hubei";
$areanames{en}->{861327740} = "Huanggang\,\ Hubei";
$areanames{en}->{861327741} = "Huanggang\,\ Hubei";
$areanames{en}->{861327742} = "Huanggang\,\ Hubei";
$areanames{en}->{861327743} = "Huanggang\,\ Hubei";
$areanames{en}->{86132775} = "Enshi\,\ Hubei";
$areanames{en}->{861327760} = "Suizhou\,\ Hubei";
$areanames{en}->{861327761} = "Suizhou\,\ Hubei";
$areanames{en}->{861327762} = "Suizhou\,\ Hubei";
$areanames{en}->{861327763} = "Jingmen\,\ Hubei";
$areanames{en}->{861327764} = "Jingmen\,\ Hubei";
$areanames{en}->{861327765} = "Jingmen\,\ Hubei";
$areanames{en}->{861327766} = "Jingmen\,\ Hubei";
$areanames{en}->{861327767} = "Wuhan\,\ Hubei";
$areanames{en}->{861327768} = "Wuhan\,\ Hubei";
$areanames{en}->{861327769} = "Wuhan\,\ Hubei";
$areanames{en}->{86132777} = "Nanning\,\ Guangxi";
$areanames{en}->{86132778} = "Nanning\,\ Guangxi";
$areanames{en}->{86132779} = "Wuhan\,\ Hubei";
$areanames{en}->{86132780} = "Siping\,\ Jilin";
$areanames{en}->{861327810} = "Changchun\,\ Jilin";
$areanames{en}->{861327811} = "Baishan\,\ Jilin";
$areanames{en}->{861327812} = "Siping\,\ Jilin";
$areanames{en}->{861327813} = "Siping\,\ Jilin";
$areanames{en}->{861327814} = "Siping\,\ Jilin";
$areanames{en}->{861327815} = "Tonghua\,\ Jilin";
$areanames{en}->{861327816} = "Baicheng\,\ Jilin";
$areanames{en}->{861327817} = "Baicheng\,\ Jilin";
$areanames{en}->{861327818} = "Baicheng\,\ Jilin";
$areanames{en}->{861327819} = "Baicheng\,\ Jilin";
$areanames{en}->{861327820} = "Jilin\,\ Jilin";
$areanames{en}->{861327821} = "Jilin\,\ Jilin";
$areanames{en}->{861327822} = "Jilin\,\ Jilin";
$areanames{en}->{861327823} = "Yanbian\,\ Jilin";
$areanames{en}->{861327824} = "Yanbian\,\ Jilin";
$areanames{en}->{861327825} = "Tonghua\,\ Jilin";
$areanames{en}->{861327826} = "Baicheng\,\ Jilin";
$areanames{en}->{861327827} = "Baicheng\,\ Jilin";
$areanames{en}->{861327828} = "Baicheng\,\ Jilin";
$areanames{en}->{861327829} = "Baishan\,\ Jilin";
$areanames{en}->{861327830} = "Songyuan\,\ Jilin";
$areanames{en}->{861327831} = "Songyuan\,\ Jilin";
$areanames{en}->{861327832} = "Songyuan\,\ Jilin";
$areanames{en}->{861327833} = "Yanbian\,\ Jilin";
$areanames{en}->{861327834} = "Yanbian\,\ Jilin";
$areanames{en}->{861327835} = "Tonghua\,\ Jilin";
$areanames{en}->{861327836} = "Baicheng\,\ Jilin";
$areanames{en}->{861327837} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327838} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327839} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327840} = "Siping\,\ Jilin";
$areanames{en}->{861327841} = "Siping\,\ Jilin";
$areanames{en}->{861327842} = "Siping\,\ Jilin";
$areanames{en}->{861327843} = "Siping\,\ Jilin";
$areanames{en}->{861327844} = "Siping\,\ Jilin";
$areanames{en}->{861327845} = "Tonghua\,\ Jilin";
$areanames{en}->{861327846} = "Baicheng\,\ Jilin";
$areanames{en}->{861327847} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327848} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327849} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327850} = "Siping\,\ Jilin";
$areanames{en}->{861327851} = "Siping\,\ Jilin";
$areanames{en}->{861327852} = "Siping\,\ Jilin";
$areanames{en}->{861327853} = "Siping\,\ Jilin";
$areanames{en}->{861327854} = "Siping\,\ Jilin";
$areanames{en}->{861327855} = "Tonghua\,\ Jilin";
$areanames{en}->{861327856} = "Baicheng\,\ Jilin";
$areanames{en}->{861327857} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861327858} = "Songyuan\,\ Jilin";
$areanames{en}->{861327859} = "Songyuan\,\ Jilin";
$areanames{en}->{86132786} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861327860} = "Baoshan\,\ Yunnan";
$areanames{en}->{861327861} = "Baoshan\,\ Yunnan";
$areanames{en}->{861327862} = "Baoshan\,\ Yunnan";
$areanames{en}->{86132787} = "Qujing\,\ Yunnan";
$areanames{en}->{861327870} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861327871} = "Kunming\,\ Yunnan";
$areanames{en}->{861327872} = "Kunming\,\ Yunnan";
$areanames{en}->{86132788} = "Changsha\,\ Hunan";
$areanames{en}->{861327880} = "Yueyang\,\ Hunan";
$areanames{en}->{861327881} = "Yongzhou\,\ Hunan";
$areanames{en}->{861327882} = "Xiangtan\,\ Hunan";
$areanames{en}->{861327883} = "Changde\,\ Hunan";
$areanames{en}->{86132789} = "Haikou\,\ Hainan";
$areanames{en}->{861327900} = "Changji\,\ Xinjiang";
$areanames{en}->{861327901} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327902} = "Hami\,\ Xinjiang";
$areanames{en}->{861327903} = "Hotan\,\ Xinjiang";
$areanames{en}->{861327904} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861327905} = "Changji\,\ Xinjiang";
$areanames{en}->{861327906} = "Aksu\,\ Xinjiang";
$areanames{en}->{861327907} = "Ili\,\ Xinjiang";
$areanames{en}->{861327908} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861327909} = "Aksu\,\ Xinjiang";
$areanames{en}->{861327910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861327911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861327912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861327913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861327914} = "Weinan\,\ Shaanxi";
$areanames{en}->{861327915} = "Weinan\,\ Shaanxi";
$areanames{en}->{861327916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861327917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861327918} = "Baoji\,\ Shaanxi";
$areanames{en}->{861327919} = "Baoji\,\ Shaanxi";
$areanames{en}->{86132792} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132793} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132794} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132795} = "Xianyang\,\ Shaanxi";
$areanames{en}->{86132796} = "Weinan\,\ Shaanxi";
$areanames{en}->{861327970} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327971} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327972} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327973} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327974} = "Ili\,\ Xinjiang";
$areanames{en}->{861327975} = "Ili\,\ Xinjiang";
$areanames{en}->{861327976} = "Aksu\,\ Xinjiang";
$areanames{en}->{861327977} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861327978} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861327979} = "Aksu\,\ Xinjiang";
$areanames{en}->{86132798} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327980} = "Aksu\,\ Xinjiang";
$areanames{en}->{861327983} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861327990} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861327992} = "Ili\,\ Xinjiang";
$areanames{en}->{861327993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861327994} = "Changji\,\ Xinjiang";
$areanames{en}->{861327995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861327996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861327997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861327998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861327999} = "Ili\,\ Xinjiang";
$areanames{en}->{86132800} = "Jining\,\ Shandong";
$areanames{en}->{861328000} = "Jinan\,\ Shandong";
$areanames{en}->{861328001} = "Jinan\,\ Shandong";
$areanames{en}->{861328002} = "Jinan\,\ Shandong";
$areanames{en}->{86132801} = "Weifang\,\ Shandong";
$areanames{en}->{86132802} = "Zaozhuang\,\ Shandong";
$areanames{en}->{86132803} = "Dongying\,\ Shandong";
$areanames{en}->{861328034} = "Weifang\,\ Shandong";
$areanames{en}->{861328040} = "Binzhou\,\ Shandong";
$areanames{en}->{861328041} = "Binzhou\,\ Shandong";
$areanames{en}->{861328042} = "Linyi\,\ Shandong";
$areanames{en}->{861328043} = "Linyi\,\ Shandong";
$areanames{en}->{861328044} = "Rizhao\,\ Shandong";
$areanames{en}->{861328045} = "Liaocheng\,\ Shandong";
$areanames{en}->{861328046} = "Liaocheng\,\ Shandong";
$areanames{en}->{861328047} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861328048} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861328049} = "Jining\,\ Shandong";
$areanames{en}->{86132805} = "Linyi\,\ Shandong";
$areanames{en}->{86132806} = "Zibo\,\ Shandong";
$areanames{en}->{86132807} = "Weifang\,\ Shandong";
$areanames{en}->{86132808} = "Qingdao\,\ Shandong";
$areanames{en}->{86132809} = "Yantai\,\ Shandong";
$areanames{en}->{86132810} = "Chengdu\,\ Sichuan";
$areanames{en}->{86132811} = "Chengdu\,\ Sichuan";
$areanames{en}->{86132812} = "Chengdu\,\ Sichuan";
$areanames{en}->{861328130} = "Leshan\,\ Sichuan";
$areanames{en}->{861328131} = "Leshan\,\ Sichuan";
$areanames{en}->{861328132} = "Leshan\,\ Sichuan";
$areanames{en}->{861328133} = "Leshan\,\ Sichuan";
$areanames{en}->{861328134} = "Leshan\,\ Sichuan";
$areanames{en}->{861328135} = "Deyang\,\ Sichuan";
$areanames{en}->{861328136} = "Deyang\,\ Sichuan";
$areanames{en}->{861328137} = "Deyang\,\ Sichuan";
$areanames{en}->{861328138} = "Deyang\,\ Sichuan";
$areanames{en}->{861328139} = "Deyang\,\ Sichuan";
$areanames{en}->{861328140} = "Mianyang\,\ Sichuan";
$areanames{en}->{861328141} = "Weinan\,\ Shaanxi";
$areanames{en}->{861328142} = "Dazhou\,\ Sichuan";
$areanames{en}->{861328143} = "Nanchong\,\ Sichuan";
$areanames{en}->{861328144} = "Leshan\,\ Sichuan";
$areanames{en}->{861328145} = "Chengdu\,\ Sichuan";
$areanames{en}->{861328146} = "Chengdu\,\ Sichuan";
$areanames{en}->{861328147} = "Chengdu\,\ Sichuan";
$areanames{en}->{861328148} = "Chengdu\,\ Sichuan";
$areanames{en}->{861328149} = "Chengdu\,\ Sichuan";
$areanames{en}->{86132815} = "Mianyang\,\ Sichuan";
$areanames{en}->{86132816} = "Luzhou\,\ Sichuan";
$areanames{en}->{861328168} = "GuangAn\,\ Sichuan";
$areanames{en}->{861328169} = "YaAn\,\ Sichuan";
$areanames{en}->{86132817} = "Dazhou\,\ Sichuan";
$areanames{en}->{861328176} = "GuangAn\,\ Sichuan";
$areanames{en}->{861328177} = "GuangAn\,\ Sichuan";
$areanames{en}->{861328178} = "Suining\,\ Sichuan";
$areanames{en}->{861328179} = "Suining\,\ Sichuan";
$areanames{en}->{86132818} = "Chengdu\,\ Sichuan";
$areanames{en}->{86132819} = "Nanchong\,\ Sichuan";
$areanames{en}->{861328196} = "Yibin\,\ Sichuan";
$areanames{en}->{861328197} = "Yibin\,\ Sichuan";
$areanames{en}->{861328198} = "Yibin\,\ Sichuan";
$areanames{en}->{861328199} = "YaAn\,\ Sichuan";
$areanames{en}->{861328200} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328201} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328202} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328203} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328204} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328205} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861328206} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861328207} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861328208} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861328209} = "Quzhou\,\ Zhejiang";
$areanames{en}->{86132821} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86132822} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861328230} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861328231} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861328232} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861328233} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861328234} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861328235} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861328236} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861328237} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861328238} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328239} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{86132824} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328240} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328241} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328242} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328243} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86132825} = "Lishui\,\ Zhejiang";
$areanames{en}->{861328250} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861328251} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861328254} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86132826} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86132827} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328280} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328281} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328282} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328283} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328284} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328285} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861328286} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861328287} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328288} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328289} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86132829} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861328300} = "Zhoukou\,\ Henan";
$areanames{en}->{861328301} = "Zhoukou\,\ Henan";
$areanames{en}->{861328302} = "Puyang\,\ Henan";
$areanames{en}->{861328303} = "Puyang\,\ Henan";
$areanames{en}->{861328304} = "Kaifeng\,\ Henan";
$areanames{en}->{861328305} = "Pingdingshan\,\ Henan";
$areanames{en}->{861328306} = "Pingdingshan\,\ Henan";
$areanames{en}->{861328307} = "Xinyang\,\ Henan";
$areanames{en}->{861328308} = "Zhumadian\,\ Henan";
$areanames{en}->{861328309} = "Zhumadian\,\ Henan";
$areanames{en}->{86132831} = "Handan\,\ Hebei";
$areanames{en}->{86132832} = "Cangzhou\,\ Hebei";
$areanames{en}->{861328330} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861328331} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861328332} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861328333} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861328334} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861328335} = "Chengde\,\ Hebei";
$areanames{en}->{861328336} = "Chengde\,\ Hebei";
$areanames{en}->{861328337} = "Chengde\,\ Hebei";
$areanames{en}->{861328338} = "Chengde\,\ Hebei";
$areanames{en}->{861328339} = "Chengde\,\ Hebei";
$areanames{en}->{861328340} = "Handan\,\ Hebei";
$areanames{en}->{861328341} = "Handan\,\ Hebei";
$areanames{en}->{861328342} = "Handan\,\ Hebei";
$areanames{en}->{861328343} = "Handan\,\ Hebei";
$areanames{en}->{861328344} = "Handan\,\ Hebei";
$areanames{en}->{861328345} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861328346} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861328347} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861328348} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861328349} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861328350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861328351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861328352} = "Datong\,\ Shanxi";
$areanames{en}->{861328353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861328354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861328355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861328356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861328357} = "Linfen\,\ Shanxi";
$areanames{en}->{861328358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861328359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861328360} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861328361} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861328362} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861328363} = "Yangquan\,\ Shanxi";
$areanames{en}->{861328364} = "Yangquan\,\ Shanxi";
$areanames{en}->{861328365} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861328366} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861328367} = "Lüliang\,\ Shanxi";
$areanames{en}->{861328368} = "Datong\,\ Shanxi";
$areanames{en}->{861328369} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861328370} = "Shangqiu\,\ Henan";
$areanames{en}->{861328371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861328372} = "Xinxiang\,\ Henan";
$areanames{en}->{861328373} = "Xinxiang\,\ Henan";
$areanames{en}->{861328374} = "Xuchang\,\ Henan";
$areanames{en}->{861328375} = "Pingdingshan\,\ Henan";
$areanames{en}->{861328376} = "Xinyang\,\ Henan";
$areanames{en}->{861328377} = "Nanyang\,\ Henan";
$areanames{en}->{861328378} = "Kaifeng\,\ Henan";
$areanames{en}->{861328379} = "Nanyang\,\ Henan";
$areanames{en}->{86132838} = "Zhengzhou\,\ Henan";
$areanames{en}->{861328390} = "Jiaozuo\,\ Henan";
$areanames{en}->{861328391} = "Jiaozuo\,\ Henan";
$areanames{en}->{861328392} = "Hebi\,\ Henan";
$areanames{en}->{861328393} = "Puyang\,\ Henan";
$areanames{en}->{861328394} = "Zhoukou\,\ Henan";
$areanames{en}->{861328395} = "Luohe\,\ Henan";
$areanames{en}->{861328396} = "Zhumadian\,\ Henan";
$areanames{en}->{861328397} = "Xinyang\,\ Henan";
$areanames{en}->{861328398} = "Sanmenxia\,\ Henan";
$areanames{en}->{861328399} = "Zhumadian\,\ Henan";
$areanames{en}->{861328400} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328401} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328402} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861328403} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861328404} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861328405} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861328406} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861328407} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861328408} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861328409} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861328410} = "Tieling\,\ Liaoning";
$areanames{en}->{861328411} = "Dalian\,\ Liaoning";
$areanames{en}->{861328412} = "Anshan\,\ Liaoning";
$areanames{en}->{861328413} = "Fushun\,\ Liaoning";
$areanames{en}->{861328414} = "Benxi\,\ Liaoning";
$areanames{en}->{861328415} = "Dandong\,\ Liaoning";
$areanames{en}->{861328416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861328417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861328418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861328419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861328420} = "Anshan\,\ Liaoning";
$areanames{en}->{861328421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861328422} = "Dalian\,\ Liaoning";
$areanames{en}->{861328423} = "Dalian\,\ Liaoning";
$areanames{en}->{861328424} = "Shenyang\,\ Liaoning";
$areanames{en}->{861328425} = "Shenyang\,\ Liaoning";
$areanames{en}->{861328426} = "Shenyang\,\ Liaoning";
$areanames{en}->{861328427} = "Panjin\,\ Liaoning";
$areanames{en}->{861328428} = "Shenyang\,\ Liaoning";
$areanames{en}->{861328429} = "Huludao\,\ Liaoning";
$areanames{en}->{86132843} = "Baoding\,\ Hebei";
$areanames{en}->{86132844} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861328450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861328453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861328454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861328455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861328456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861328457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861328458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861328459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861328460} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328461} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328462} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328463} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861328465} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861328466} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861328467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861328468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861328469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861328470} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861328471} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861328472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861328473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861328474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861328475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861328476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861328477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861328478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861328479} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861328480} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861328481} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861328482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861328483} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861328484} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861328485} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861328486} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861328487} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861328488} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861328489} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861328490} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861328491} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861328492} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861328493} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861328494} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861328495} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861328496} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861328497} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861328498} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861328499} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861328500} = "Fuzhou\,\ Fujian";
$areanames{en}->{861328501} = "Quanzhou\,\ Fujian";
$areanames{en}->{861328502} = "Fuzhou\,\ Fujian";
$areanames{en}->{861328503} = "Quanzhou\,\ Fujian";
$areanames{en}->{861328504} = "Quanzhou\,\ Fujian";
$areanames{en}->{861328505} = "Longyan\,\ Fujian";
$areanames{en}->{861328506} = "Nanping\,\ Fujian";
$areanames{en}->{861328507} = "Zhengzhou\,\ Henan";
$areanames{en}->{861328508} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861328509} = "Putian\,\ Fujian";
$areanames{en}->{86132851} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86132852} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861328527} = "Suqian\,\ Jiangsu";
$areanames{en}->{861328528} = "Suqian\,\ Jiangsu";
$areanames{en}->{861328529} = "Suqian\,\ Jiangsu";
$areanames{en}->{861328530} = "Heze\,\ Shandong";
$areanames{en}->{861328531} = "Jinan\,\ Shandong";
$areanames{en}->{861328532} = "Qingdao\,\ Shandong";
$areanames{en}->{861328533} = "Zibo\,\ Shandong";
$areanames{en}->{861328534} = "Dezhou\,\ Shandong";
$areanames{en}->{861328535} = "Yantai\,\ Shandong";
$areanames{en}->{861328536} = "Weifang\,\ Shandong";
$areanames{en}->{861328537} = "Jining\,\ Shandong";
$areanames{en}->{861328538} = "TaiAn\,\ Shandong";
$areanames{en}->{861328539} = "Linyi\,\ Shandong";
$areanames{en}->{861328540} = "Heze\,\ Shandong";
$areanames{en}->{861328541} = "Jinan\,\ Shandong";
$areanames{en}->{861328542} = "Qingdao\,\ Shandong";
$areanames{en}->{861328543} = "Binzhou\,\ Shandong";
$areanames{en}->{861328544} = "Dezhou\,\ Shandong";
$areanames{en}->{861328545} = "Yantai\,\ Shandong";
$areanames{en}->{861328546} = "Dongying\,\ Shandong";
$areanames{en}->{861328547} = "Jining\,\ Shandong";
$areanames{en}->{861328548} = "TaiAn\,\ Shandong";
$areanames{en}->{861328549} = "Linyi\,\ Shandong";
$areanames{en}->{861328550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861328551} = "Hefei\,\ Anhui";
$areanames{en}->{861328552} = "Bengbu\,\ Anhui";
$areanames{en}->{861328553} = "Wuhu\,\ Anhui";
$areanames{en}->{861328554} = "Huainan\,\ Anhui";
$areanames{en}->{861328555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861328556} = "Anqing\,\ Anhui";
$areanames{en}->{861328557} = "Suzhou\,\ Anhui";
$areanames{en}->{861328558} = "Fuyang\,\ Anhui";
$areanames{en}->{861328559} = "Huangshan\,\ Anhui";
$areanames{en}->{861328560} = "Hefei\,\ Anhui";
$areanames{en}->{861328561} = "Huaibei\,\ Anhui";
$areanames{en}->{861328562} = "Tongling\,\ Anhui";
$areanames{en}->{861328563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861328564} = "LuAn\,\ Anhui";
$areanames{en}->{861328565} = "Hefei\,\ Anhui";
$areanames{en}->{861328566} = "Suzhou\,\ Anhui";
$areanames{en}->{861328567} = "Bozhou\,\ Anhui";
$areanames{en}->{861328568} = "Bozhou\,\ Anhui";
$areanames{en}->{861328569} = "Hefei\,\ Anhui";
$areanames{en}->{861328570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861328571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861328573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861328574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861328575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861328576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861328577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861328579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861328580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861328581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861328582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861328583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861328584} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861328585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861328586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861328587} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861328588} = "Lishui\,\ Zhejiang";
$areanames{en}->{861328589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861328590} = "Longyan\,\ Fujian";
$areanames{en}->{861328591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861328592} = "Xiamen\,\ Fujian";
$areanames{en}->{861328593} = "Ningde\,\ Fujian";
$areanames{en}->{861328594} = "Fuzhou\,\ Fujian";
$areanames{en}->{861328595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861328596} = "Sanming\,\ Fujian";
$areanames{en}->{861328597} = "Xiamen\,\ Fujian";
$areanames{en}->{861328598} = "Fuzhou\,\ Fujian";
$areanames{en}->{861328599} = "Quanzhou\,\ Fujian";
$areanames{en}->{86132860} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861328609} = "Xingtai\,\ Hebei";
$areanames{en}->{86132861} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86132862} = "Huizhou\,\ Guangdong";
$areanames{en}->{86132863} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86132864} = "Shantou\,\ Guangdong";
$areanames{en}->{861328650} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861328651} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861328652} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861328653} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861328654} = "Handan\,\ Hebei";
$areanames{en}->{861328655} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861328656} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861328657} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861328658} = "Baoding\,\ Hebei";
$areanames{en}->{861328659} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861328660} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861328661} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861328662} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861328663} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861328664} = "Xingtai\,\ Hebei";
$areanames{en}->{861328665} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861328666} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861328667} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861328668} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861328669} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861328670} = "Heyuan\,\ Guangdong";
$areanames{en}->{861328671} = "Heyuan\,\ Guangdong";
$areanames{en}->{861328672} = "Heyuan\,\ Guangdong";
$areanames{en}->{861328673} = "Heyuan\,\ Guangdong";
$areanames{en}->{861328674} = "Heyuan\,\ Guangdong";
$areanames{en}->{861328675} = "Meizhou\,\ Guangdong";
$areanames{en}->{861328676} = "Meizhou\,\ Guangdong";
$areanames{en}->{861328677} = "Meizhou\,\ Guangdong";
$areanames{en}->{861328678} = "Meizhou\,\ Guangdong";
$areanames{en}->{861328679} = "Meizhou\,\ Guangdong";
$areanames{en}->{86132868} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328690} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861328691} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861328692} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861328693} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861328694} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861328695} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861328696} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861328697} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861328698} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861328699} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{86132870} = "Zibo\,\ Shandong";
$areanames{en}->{861328704} = "Liaocheng\,\ Shandong";
$areanames{en}->{861328705} = "Heze\,\ Shandong";
$areanames{en}->{86132871} = "Linyi\,\ Shandong";
$areanames{en}->{861328710} = "Laiwu\,\ Shandong";
$areanames{en}->{861328711} = "Laiwu\,\ Shandong";
$areanames{en}->{86132872} = "Jining\,\ Shandong";
$areanames{en}->{86132873} = "Dongying\,\ Shandong";
$areanames{en}->{861328734} = "TaiAn\,\ Shandong";
$areanames{en}->{861328739} = "Binzhou\,\ Shandong";
$areanames{en}->{861328740} = "Rizhao\,\ Shandong";
$areanames{en}->{861328741} = "Rizhao\,\ Shandong";
$areanames{en}->{861328742} = "Yantai\,\ Shandong";
$areanames{en}->{861328743} = "Yantai\,\ Shandong";
$areanames{en}->{861328744} = "Yantai\,\ Shandong";
$areanames{en}->{861328745} = "Yantai\,\ Shandong";
$areanames{en}->{861328746} = "Yantai\,\ Shandong";
$areanames{en}->{861328747} = "Weifang\,\ Shandong";
$areanames{en}->{861328748} = "Weifang\,\ Shandong";
$areanames{en}->{861328749} = "Heze\,\ Shandong";
$areanames{en}->{86132875} = "Liaocheng\,\ Shandong";
$areanames{en}->{861328760} = "TaiAn\,\ Shandong";
$areanames{en}->{861328761} = "TaiAn\,\ Shandong";
$areanames{en}->{861328762} = "TaiAn\,\ Shandong";
$areanames{en}->{861328763} = "TaiAn\,\ Shandong";
$areanames{en}->{861328764} = "TaiAn\,\ Shandong";
$areanames{en}->{861328765} = "Weifang\,\ Shandong";
$areanames{en}->{861328766} = "Weifang\,\ Shandong";
$areanames{en}->{861328767} = "Weifang\,\ Shandong";
$areanames{en}->{861328768} = "Weifang\,\ Shandong";
$areanames{en}->{861328769} = "Weifang\,\ Shandong";
$areanames{en}->{86132877} = "Jinan\,\ Shandong";
$areanames{en}->{86132878} = "Weihai\,\ Shandong";
$areanames{en}->{861328788} = "Zibo\,\ Shandong";
$areanames{en}->{861328789} = "Zibo\,\ Shandong";
$areanames{en}->{861328790} = "Heze\,\ Shandong";
$areanames{en}->{861328791} = "Heze\,\ Shandong";
$areanames{en}->{861328792} = "Heze\,\ Shandong";
$areanames{en}->{861328793} = "Heze\,\ Shandong";
$areanames{en}->{861328794} = "Heze\,\ Shandong";
$areanames{en}->{861328795} = "Yantai\,\ Shandong";
$areanames{en}->{861328796} = "Yantai\,\ Shandong";
$areanames{en}->{861328797} = "Yantai\,\ Shandong";
$areanames{en}->{861328798} = "Yantai\,\ Shandong";
$areanames{en}->{861328799} = "Yantai\,\ Shandong";
$areanames{en}->{86132880} = "Shantou\,\ Guangdong";
$areanames{en}->{861328810} = "Jieyang\,\ Guangdong";
$areanames{en}->{861328811} = "Jieyang\,\ Guangdong";
$areanames{en}->{861328812} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861328813} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861328814} = "Huizhou\,\ Guangdong";
$areanames{en}->{861328815} = "Huizhou\,\ Guangdong";
$areanames{en}->{861328816} = "Huizhou\,\ Guangdong";
$areanames{en}->{861328817} = "Huizhou\,\ Guangdong";
$areanames{en}->{861328818} = "Huizhou\,\ Guangdong";
$areanames{en}->{861328819} = "Yangjiang\,\ Guangdong";
$areanames{en}->{86132882} = "Foshan\,\ Guangdong";
$areanames{en}->{86132883} = "Foshan\,\ Guangdong";
$areanames{en}->{861328832} = "Langfang\,\ Hebei";
$areanames{en}->{861328840} = "Foshan\,\ Guangdong";
$areanames{en}->{861328841} = "Foshan\,\ Guangdong";
$areanames{en}->{861328842} = "Foshan\,\ Guangdong";
$areanames{en}->{861328843} = "Foshan\,\ Guangdong";
$areanames{en}->{861328844} = "Foshan\,\ Guangdong";
$areanames{en}->{861328845} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328846} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328847} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328848} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328849} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86132885} = "Jieyang\,\ Guangdong";
$areanames{en}->{86132886} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328870} = "Yunfu\,\ Guangdong";
$areanames{en}->{861328871} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861328872} = "Yunfu\,\ Guangdong";
$areanames{en}->{861328873} = "Yunfu\,\ Guangdong";
$areanames{en}->{861328874} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861328875} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861328876} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861328877} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861328878} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861328879} = "Handan\,\ Hebei";
$areanames{en}->{861328880} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328881} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328882} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328883} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328884} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861328885} = "Dongguan\,\ Guangdong";
$areanames{en}->{861328886} = "Dongguan\,\ Guangdong";
$areanames{en}->{861328887} = "Langfang\,\ Hebei";
$areanames{en}->{861328888} = "Dongguan\,\ Guangdong";
$areanames{en}->{861328889} = "Dongguan\,\ Guangdong";
$areanames{en}->{861328890} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861328891} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861328892} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861328893} = "Baoding\,\ Hebei";
$areanames{en}->{861328894} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861328895} = "Maoming\,\ Guangdong";
$areanames{en}->{861328896} = "Maoming\,\ Guangdong";
$areanames{en}->{861328897} = "Maoming\,\ Guangdong";
$areanames{en}->{861328898} = "Maoming\,\ Guangdong";
$areanames{en}->{861328899} = "Maoming\,\ Guangdong";
$areanames{en}->{861328900} = "Changji\,\ Xinjiang";
$areanames{en}->{861328901} = "Hotan\,\ Xinjiang";
$areanames{en}->{861328902} = "Hami\,\ Xinjiang";
$areanames{en}->{861328903} = "Hotan\,\ Xinjiang";
$areanames{en}->{861328904} = "Ili\,\ Xinjiang";
$areanames{en}->{861328905} = "Changji\,\ Xinjiang";
$areanames{en}->{861328906} = "Altay\,\ Xinjiang";
$areanames{en}->{861328907} = "Hotan\,\ Xinjiang";
$areanames{en}->{861328908} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861328909} = "Bortala\,\ Xinjiang";
$areanames{en}->{861328910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861328911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861328912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861328913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861328914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861328915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861328916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861328917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861328918} = "Baoji\,\ Shaanxi";
$areanames{en}->{861328919} = "Baoji\,\ Shaanxi";
$areanames{en}->{86132892} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132893} = "XiAn\,\ Shaanxi";
$areanames{en}->{861328940} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861328941} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861328942} = "Weinan\,\ Shaanxi";
$areanames{en}->{861328943} = "Baoji\,\ Shaanxi";
$areanames{en}->{861328944} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861328945} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861328946} = "YanAn\,\ Shaanxi";
$areanames{en}->{861328947} = "Yulin\,\ Shaanxi";
$areanames{en}->{861328948} = "Yulin\,\ Shaanxi";
$areanames{en}->{861328949} = "Yulin\,\ Shaanxi";
$areanames{en}->{861328950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861328951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861328952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861328953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861328954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861328955} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861328956} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861328957} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861328958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861328959} = "Guyuan\,\ Ningxia";
$areanames{en}->{86132896} = "YanAn\,\ Shaanxi";
$areanames{en}->{861328960} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861328961} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861328962} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{86132897} = "Yulin\,\ Shaanxi";
$areanames{en}->{86132898} = "XiAn\,\ Shaanxi";
$areanames{en}->{861328990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861328991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861328992} = "Ili\,\ Xinjiang";
$areanames{en}->{861328993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861328994} = "Changji\,\ Xinjiang";
$areanames{en}->{861328995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861328996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861328997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861328998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861328999} = "Ili\,\ Xinjiang";
$areanames{en}->{86132900} = "Chongqing";
$areanames{en}->{861329010} = "Jinan\,\ Shandong";
$areanames{en}->{861329011} = "Zibo\,\ Shandong";
$areanames{en}->{861329012} = "TaiAn\,\ Shandong";
$areanames{en}->{861329013} = "TaiAn\,\ Shandong";
$areanames{en}->{861329014} = "Laiwu\,\ Shandong";
$areanames{en}->{861329015} = "Weifang\,\ Shandong";
$areanames{en}->{861329016} = "Rizhao\,\ Shandong";
$areanames{en}->{861329017} = "Weihai\,\ Shandong";
$areanames{en}->{861329018} = "Yantai\,\ Shandong";
$areanames{en}->{861329019} = "Heze\,\ Shandong";
$areanames{en}->{861329020} = "Linyi\,\ Shandong";
$areanames{en}->{861329021} = "Linyi\,\ Shandong";
$areanames{en}->{861329022} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861329023} = "Dezhou\,\ Shandong";
$areanames{en}->{861329024} = "Jinan\,\ Shandong";
$areanames{en}->{861329025} = "Liaocheng\,\ Shandong";
$areanames{en}->{861329026} = "Liaocheng\,\ Shandong";
$areanames{en}->{861329027} = "Binzhou\,\ Shandong";
$areanames{en}->{861329028} = "Dezhou\,\ Shandong";
$areanames{en}->{861329029} = "Jinan\,\ Shandong";
$areanames{en}->{861329030} = "Jining\,\ Shandong";
$areanames{en}->{861329031} = "Dongying\,\ Shandong";
$areanames{en}->{861329032} = "Jinan\,\ Shandong";
$areanames{en}->{861329033} = "Jinan\,\ Shandong";
$areanames{en}->{861329034} = "Heze\,\ Shandong";
$areanames{en}->{861329035} = "Linyi\,\ Shandong";
$areanames{en}->{861329036} = "Yantai\,\ Shandong";
$areanames{en}->{861329037} = "Liaocheng\,\ Shandong";
$areanames{en}->{861329038} = "Laiwu\,\ Shandong";
$areanames{en}->{861329039} = "Rizhao\,\ Shandong";
$areanames{en}->{861329040} = "Handan\,\ Hebei";
$areanames{en}->{861329041} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861329042} = "Baoding\,\ Hebei";
$areanames{en}->{861329043} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861329044} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861329045} = "Tangshan\,\ Hebei";
$areanames{en}->{861329046} = "Langfang\,\ Hebei";
$areanames{en}->{861329047} = "Cangzhou\,\ Hebei";
$areanames{en}->{861329048} = "Handan\,\ Hebei";
$areanames{en}->{861329049} = "Xingtai\,\ Hebei";
$areanames{en}->{861329050} = "Handan\,\ Hebei";
$areanames{en}->{861329051} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861329052} = "Baoding\,\ Hebei";
$areanames{en}->{861329053} = "Tangshan\,\ Hebei";
$areanames{en}->{861329054} = "Baoding\,\ Hebei";
$areanames{en}->{861329055} = "Tangshan\,\ Hebei";
$areanames{en}->{861329056} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861329057} = "Handan\,\ Hebei";
$areanames{en}->{861329058} = "Hengshui\,\ Hebei";
$areanames{en}->{861329059} = "Xingtai\,\ Hebei";
$areanames{en}->{861329060} = "Handan\,\ Hebei";
$areanames{en}->{861329061} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861329062} = "Baoding\,\ Hebei";
$areanames{en}->{861329063} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861329064} = "Tangshan\,\ Hebei";
$areanames{en}->{861329065} = "Tangshan\,\ Hebei";
$areanames{en}->{861329066} = "Langfang\,\ Hebei";
$areanames{en}->{861329067} = "Cangzhou\,\ Hebei";
$areanames{en}->{861329068} = "Baoding\,\ Hebei";
$areanames{en}->{861329069} = "Xingtai\,\ Hebei";
$areanames{en}->{861329070} = "Jiaozuo\,\ Henan";
$areanames{en}->{861329071} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861329072} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329073} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329074} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329075} = "Xuchang\,\ Henan";
$areanames{en}->{861329076} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861329077} = "Puyang\,\ Henan";
$areanames{en}->{861329078} = "Xiamen\,\ Fujian";
$areanames{en}->{861329079} = "Anyang\,\ Henan";
$areanames{en}->{861329080} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329081} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329082} = "Anyang\,\ Henan";
$areanames{en}->{861329083} = "Putian\,\ Fujian";
$areanames{en}->{861329084} = "Sanmenxia\,\ Henan";
$areanames{en}->{861329085} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329086} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329087} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861329088} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329089} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329090} = "Zhengzhou\,\ Henan";
$areanames{en}->{861329091} = "Sanmenxia\,\ Henan";
$areanames{en}->{861329092} = "Pingdingshan\,\ Henan";
$areanames{en}->{861329093} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329094} = "Zhengzhou\,\ Henan";
$areanames{en}->{861329095} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329096} = "Zhengzhou\,\ Henan";
$areanames{en}->{861329097} = "Puyang\,\ Henan";
$areanames{en}->{861329098} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329099} = "Xinyang\,\ Henan";
$areanames{en}->{861329100} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861329101} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861329102} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861329103} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861329104} = "Baiyin\,\ Gansu";
$areanames{en}->{861329105} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861329106} = "Baiyin\,\ Gansu";
$areanames{en}->{861329107} = "Dingxi\,\ Gansu";
$areanames{en}->{861329108} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861329109} = "Suzhou\,\ Jiangsu";
$areanames{en}->{86132911} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861329110} = "Nantong\,\ Jiangsu";
$areanames{en}->{861329111} = "Nantong\,\ Jiangsu";
$areanames{en}->{861329112} = "Nantong\,\ Jiangsu";
$areanames{en}->{861329113} = "Nantong\,\ Jiangsu";
$areanames{en}->{861329120} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861329121} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861329122} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861329123} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861329124} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861329125} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861329126} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861329127} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861329128} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861329129} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861329130} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861329131} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861329132} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861329133} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861329134} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861329135} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861329136} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861329137} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861329138} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861329139} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861329140} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861329141} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861329142} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861329143} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329144} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861329145} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861329146} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861329147} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861329148} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861329149} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861329150} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329151} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329152} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329153} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329154} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329155} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861329156} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861329157} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861329158} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861329159} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86132916} = "Taizhou\,\ Zhejiang";
$areanames{en}->{86132917} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{86132918} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86132919} = "Ningbo\,\ Zhejiang";
$areanames{en}->{86132920} = "Handan\,\ Hebei";
$areanames{en}->{86132921} = "Xingtai\,\ Hebei";
$areanames{en}->{86132922} = "Hengshui\,\ Hebei";
$areanames{en}->{86132923} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86132924} = "Tangshan\,\ Hebei";
$areanames{en}->{86132925} = "Tangshan\,\ Hebei";
$areanames{en}->{86132926} = "Langfang\,\ Hebei";
$areanames{en}->{86132927} = "Cangzhou\,\ Hebei";
$areanames{en}->{86132928} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86132929} = "Baoding\,\ Hebei";
$areanames{en}->{86132930} = "Handan\,\ Hebei";
$areanames{en}->{861329310} = "Xingtai\,\ Hebei";
$areanames{en}->{861329311} = "Xingtai\,\ Hebei";
$areanames{en}->{861329312} = "Xingtai\,\ Hebei";
$areanames{en}->{861329313} = "Xingtai\,\ Hebei";
$areanames{en}->{861329314} = "Xingtai\,\ Hebei";
$areanames{en}->{861329315} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861329316} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861329317} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861329318} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861329319} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86132932} = "Chengde\,\ Hebei";
$areanames{en}->{86132933} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{86132934} = "Cangzhou\,\ Hebei";
$areanames{en}->{861329350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329352} = "Datong\,\ Shanxi";
$areanames{en}->{861329353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861329354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861329355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861329356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861329357} = "Linfen\,\ Shanxi";
$areanames{en}->{861329358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861329360} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329361} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329362} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329363} = "Yangquan\,\ Shanxi";
$areanames{en}->{861329364} = "Yangquan\,\ Shanxi";
$areanames{en}->{861329365} = "Yangquan\,\ Shanxi";
$areanames{en}->{861329366} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329367} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329368} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861329369} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861329370} = "Changzhi\,\ Shanxi";
$areanames{en}->{861329371} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329372} = "Datong\,\ Shanxi";
$areanames{en}->{861329373} = "Yangquan\,\ Shanxi";
$areanames{en}->{861329374} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329375} = "Changzhi\,\ Shanxi";
$areanames{en}->{861329376} = "Jincheng\,\ Shanxi";
$areanames{en}->{861329377} = "Linfen\,\ Shanxi";
$areanames{en}->{861329378} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329379} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861329380} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861329381} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329382} = "Datong\,\ Shanxi";
$areanames{en}->{861329383} = "Yangquan\,\ Shanxi";
$areanames{en}->{861329384} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329385} = "Changzhi\,\ Shanxi";
$areanames{en}->{861329386} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861329387} = "Linfen\,\ Shanxi";
$areanames{en}->{861329388} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329389} = "Jincheng\,\ Shanxi";
$areanames{en}->{861329390} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329391} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329392} = "Datong\,\ Shanxi";
$areanames{en}->{861329393} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329394} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329395} = "Changzhi\,\ Shanxi";
$areanames{en}->{861329396} = "Linfen\,\ Shanxi";
$areanames{en}->{861329397} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861329398} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861329399} = "Yuncheng\,\ Shanxi";
$areanames{en}->{86132940} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{86132941} = "Wuhan\,\ Hubei";
$areanames{en}->{861329420} = "Jingzhou\,\ Hubei";
$areanames{en}->{861329421} = "Shiyan\,\ Hubei";
$areanames{en}->{861329422} = "Shiyan\,\ Hubei";
$areanames{en}->{861329423} = "Huangshi\,\ Hubei";
$areanames{en}->{861329424} = "Yichang\,\ Hubei";
$areanames{en}->{861329425} = "Xiangfan\,\ Hubei";
$areanames{en}->{861329426} = "Huanggang\,\ Hubei";
$areanames{en}->{861329427} = "Huanggang\,\ Hubei";
$areanames{en}->{861329428} = "Jingmen\,\ Hubei";
$areanames{en}->{861329429} = "Ezhou\,\ Hubei";
$areanames{en}->{861329430} = "Changchun\,\ Jilin";
$areanames{en}->{861329431} = "Changchun\,\ Jilin";
$areanames{en}->{861329432} = "Jilin\,\ Jilin";
$areanames{en}->{861329433} = "Yanbian\,\ Jilin";
$areanames{en}->{861329434} = "Siping\,\ Jilin";
$areanames{en}->{861329435} = "Tonghua\,\ Jilin";
$areanames{en}->{861329436} = "Baicheng\,\ Jilin";
$areanames{en}->{861329437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861329438} = "Songyuan\,\ Jilin";
$areanames{en}->{861329439} = "Baishan\,\ Jilin";
$areanames{en}->{86132944} = "Jilin\,\ Jilin";
$areanames{en}->{861329450} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329451} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861329452} = "Datong\,\ Shanxi";
$areanames{en}->{861329453} = "Yangquan\,\ Shanxi";
$areanames{en}->{861329454} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861329455} = "Changzhi\,\ Shanxi";
$areanames{en}->{861329456} = "Jincheng\,\ Shanxi";
$areanames{en}->{861329457} = "Linfen\,\ Shanxi";
$areanames{en}->{861329458} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329459} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861329460} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329461} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329462} = "Datong\,\ Shanxi";
$areanames{en}->{861329463} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861329464} = "Jincheng\,\ Shanxi";
$areanames{en}->{861329465} = "Lüliang\,\ Shanxi";
$areanames{en}->{861329466} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861329467} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861329468} = "Linfen\,\ Shanxi";
$areanames{en}->{861329469} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861329470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861329471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861329472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861329473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861329474} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861329475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861329476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861329477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861329478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861329479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861329480} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861329481} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861329482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861329483} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861329484} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861329485} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861329486} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861329487} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861329488} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861329489} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861329490} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861329491} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861329492} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861329493} = "Kunming\,\ Yunnan";
$areanames{en}->{861329494} = "Kunming\,\ Yunnan";
$areanames{en}->{861329495} = "Kunming\,\ Yunnan";
$areanames{en}->{861329496} = "Kunming\,\ Yunnan";
$areanames{en}->{861329497} = "Kunming\,\ Yunnan";
$areanames{en}->{861329498} = "Honghe\,\ Yunnan";
$areanames{en}->{861329499} = "Honghe\,\ Yunnan";
$areanames{en}->{861329500} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329501} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329502} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329503} = "Pingdingshan\,\ Henan";
$areanames{en}->{861329504} = "Xuchang\,\ Henan";
$areanames{en}->{861329505} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329506} = "Sanming\,\ Fujian";
$areanames{en}->{861329507} = "Ningde\,\ Fujian";
$areanames{en}->{861329508} = "Kaifeng\,\ Henan";
$areanames{en}->{861329509} = "Nanping\,\ Fujian";
$areanames{en}->{86132951} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861329520} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861329521} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861329522} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861329523} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861329524} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861329525} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861329526} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861329527} = "Suqian\,\ Jiangsu";
$areanames{en}->{861329528} = "Suqian\,\ Jiangsu";
$areanames{en}->{861329529} = "Suqian\,\ Jiangsu";
$areanames{en}->{861329530} = "Heze\,\ Shandong";
$areanames{en}->{861329531} = "Jinan\,\ Shandong";
$areanames{en}->{861329532} = "Qingdao\,\ Shandong";
$areanames{en}->{861329533} = "Zibo\,\ Shandong";
$areanames{en}->{861329534} = "Dezhou\,\ Shandong";
$areanames{en}->{861329535} = "Yantai\,\ Shandong";
$areanames{en}->{861329536} = "Weifang\,\ Shandong";
$areanames{en}->{861329537} = "Jining\,\ Shandong";
$areanames{en}->{861329538} = "TaiAn\,\ Shandong";
$areanames{en}->{861329539} = "Linyi\,\ Shandong";
$areanames{en}->{861329540} = "Heze\,\ Shandong";
$areanames{en}->{861329541} = "Jinan\,\ Shandong";
$areanames{en}->{861329542} = "Qingdao\,\ Shandong";
$areanames{en}->{861329543} = "Binzhou\,\ Shandong";
$areanames{en}->{861329544} = "Liaocheng\,\ Shandong";
$areanames{en}->{861329545} = "Yantai\,\ Shandong";
$areanames{en}->{861329546} = "Dongying\,\ Shandong";
$areanames{en}->{861329547} = "Jining\,\ Shandong";
$areanames{en}->{861329548} = "TaiAn\,\ Shandong";
$areanames{en}->{861329549} = "Linyi\,\ Shandong";
$areanames{en}->{861329550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861329551} = "Hefei\,\ Anhui";
$areanames{en}->{861329552} = "Bengbu\,\ Anhui";
$areanames{en}->{861329553} = "Wuhu\,\ Anhui";
$areanames{en}->{861329554} = "Huainan\,\ Anhui";
$areanames{en}->{861329555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861329556} = "Anqing\,\ Anhui";
$areanames{en}->{861329557} = "Suzhou\,\ Anhui";
$areanames{en}->{861329558} = "Fuyang\,\ Anhui";
$areanames{en}->{861329559} = "Huangshan\,\ Anhui";
$areanames{en}->{861329560} = "Hefei\,\ Anhui";
$areanames{en}->{861329561} = "Huaibei\,\ Anhui";
$areanames{en}->{861329562} = "Tongling\,\ Anhui";
$areanames{en}->{861329563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861329564} = "LuAn\,\ Anhui";
$areanames{en}->{861329565} = "Wuhu\,\ Anhui";
$areanames{en}->{861329566} = "Chizhou\,\ Anhui";
$areanames{en}->{861329567} = "Bozhou\,\ Anhui";
$areanames{en}->{861329568} = "Fuyang\,\ Anhui";
$areanames{en}->{861329569} = "Hefei\,\ Anhui";
$areanames{en}->{861329570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861329571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861329572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861329573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861329575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861329576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861329577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861329578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861329579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861329580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861329581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861329582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861329583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329584} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861329585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861329586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861329587} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861329588} = "Lishui\,\ Zhejiang";
$areanames{en}->{861329589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861329590} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329592} = "Xiamen\,\ Fujian";
$areanames{en}->{861329593} = "Putian\,\ Fujian";
$areanames{en}->{861329594} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861329596} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861329597} = "Fuzhou\,\ Fujian";
$areanames{en}->{861329598} = "Luoyang\,\ Henan";
$areanames{en}->{861329599} = "Xinyang\,\ Henan";
$areanames{en}->{86132960} = "Shanghai";
$areanames{en}->{86132961} = "Shanghai";
$areanames{en}->{86132962} = "Shanghai";
$areanames{en}->{861329630} = "Weihai\,\ Shandong";
$areanames{en}->{861329631} = "Weihai\,\ Shandong";
$areanames{en}->{861329632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861329633} = "Rizhao\,\ Shandong";
$areanames{en}->{861329634} = "Laiwu\,\ Shandong";
$areanames{en}->{861329635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861329636} = "Weifang\,\ Shandong";
$areanames{en}->{861329637} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861329638} = "Yantai\,\ Shandong";
$areanames{en}->{861329639} = "Qingdao\,\ Shandong";
$areanames{en}->{861329640} = "Jinan\,\ Shandong";
$areanames{en}->{861329641} = "Jinan\,\ Shandong";
$areanames{en}->{861329642} = "Qingdao\,\ Shandong";
$areanames{en}->{861329643} = "Zibo\,\ Shandong";
$areanames{en}->{861329644} = "Jinan\,\ Shandong";
$areanames{en}->{861329645} = "Yantai\,\ Shandong";
$areanames{en}->{861329646} = "Weifang\,\ Shandong";
$areanames{en}->{861329647} = "Dongying\,\ Shandong";
$areanames{en}->{861329648} = "Qingdao\,\ Shandong";
$areanames{en}->{861329649} = "Heze\,\ Shandong";
$areanames{en}->{86132965} = "Wuhan\,\ Hubei";
$areanames{en}->{86132966} = "Wuhan\,\ Hubei";
$areanames{en}->{86132967} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861329670} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861329677} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329678} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861329679} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{86132968} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861329680} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861329687} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861329688} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861329689} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861329690} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861329691} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861329692} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861329693} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861329694} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861329695} = "Ulanqab\,\ Inner\ Mongolia";
$areanames{en}->{861329696} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861329697} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861329698} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861329699} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{86132970} = "Wuhan\,\ Hubei";
$areanames{en}->{86132971} = "Shiyan\,\ Hubei";
$areanames{en}->{861329710} = "Enshi\,\ Hubei";
$areanames{en}->{861329711} = "Jingzhou\,\ Hubei";
$areanames{en}->{861329712} = "Jingmen\,\ Hubei";
$areanames{en}->{861329713} = "Jingmen\,\ Hubei";
$areanames{en}->{861329720} = "Wuhan\,\ Hubei";
$areanames{en}->{861329721} = "Huangshi\,\ Hubei";
$areanames{en}->{861329722} = "Huangshi\,\ Hubei";
$areanames{en}->{861329723} = "Huangshi\,\ Hubei";
$areanames{en}->{861329724} = "Huangshi\,\ Hubei";
$areanames{en}->{861329725} = "Suizhou\,\ Hubei";
$areanames{en}->{861329726} = "Suizhou\,\ Hubei";
$areanames{en}->{861329727} = "Suizhou\,\ Hubei";
$areanames{en}->{861329728} = "Yichang\,\ Hubei";
$areanames{en}->{861329729} = "Xiangfan\,\ Hubei";
$areanames{en}->{861329730} = "Yueyang\,\ Hunan";
$areanames{en}->{861329731} = "Changsha\,\ Hunan";
$areanames{en}->{861329732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861329733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861329734} = "Hengyang\,\ Hunan";
$areanames{en}->{861329735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861329736} = "Changde\,\ Hunan";
$areanames{en}->{861329737} = "Yiyang\,\ Hunan";
$areanames{en}->{861329738} = "Loudi\,\ Hunan";
$areanames{en}->{861329739} = "Shaoyang\,\ Hunan";
$areanames{en}->{86132974} = "Changsha\,\ Hunan";
$areanames{en}->{861329743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861329744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861329745} = "Huaihua\,\ Hunan";
$areanames{en}->{861329746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861329750} = "Ezhou\,\ Hubei";
$areanames{en}->{861329751} = "Ezhou\,\ Hubei";
$areanames{en}->{861329752} = "Xiaogan\,\ Hubei";
$areanames{en}->{861329753} = "Xiaogan\,\ Hubei";
$areanames{en}->{861329754} = "Xiaogan\,\ Hubei";
$areanames{en}->{861329755} = "Xiaogan\,\ Hubei";
$areanames{en}->{861329756} = "Huanggang\,\ Hubei";
$areanames{en}->{861329757} = "Huanggang\,\ Hubei";
$areanames{en}->{861329758} = "Huanggang\,\ Hubei";
$areanames{en}->{861329759} = "Huanggang\,\ Hubei";
$areanames{en}->{861329760} = "Jingmen\,\ Hubei";
$areanames{en}->{861329761} = "Jingmen\,\ Hubei";
$areanames{en}->{861329762} = "Jingmen\,\ Hubei";
$areanames{en}->{861329763} = "Jingmen\,\ Hubei";
$areanames{en}->{861329764} = "Huangshi\,\ Hubei";
$areanames{en}->{861329765} = "Huangshi\,\ Hubei";
$areanames{en}->{861329766} = "Huangshi\,\ Hubei";
$areanames{en}->{861329767} = "Xianning\,\ Hubei";
$areanames{en}->{861329768} = "Xianning\,\ Hubei";
$areanames{en}->{861329769} = "Ezhou\,\ Hubei";
$areanames{en}->{861329770} = "Nanning\,\ Guangxi";
$areanames{en}->{861329771} = "Nanning\,\ Guangxi";
$areanames{en}->{861329772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329773} = "Guilin\,\ Guangxi";
$areanames{en}->{861329774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861329775} = "Yulin\,\ Guangxi";
$areanames{en}->{861329776} = "Baise\,\ Guangxi";
$areanames{en}->{861329777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861329778} = "Hechi\,\ Guangxi";
$areanames{en}->{861329779} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329780} = "Nanning\,\ Guangxi";
$areanames{en}->{861329781} = "Nanning\,\ Guangxi";
$areanames{en}->{861329782} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329783} = "Guilin\,\ Guangxi";
$areanames{en}->{861329784} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861329785} = "Yulin\,\ Guangxi";
$areanames{en}->{861329786} = "Yulin\,\ Guangxi";
$areanames{en}->{861329787} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861329788} = "Hechi\,\ Guangxi";
$areanames{en}->{861329789} = "Liuzhou\,\ Guangxi";
$areanames{en}->{86132979} = "Wuhan\,\ Hubei";
$areanames{en}->{86132980} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861329800} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861329801} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861329802} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861329803} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{86132981} = "Zhengzhou\,\ Henan";
$areanames{en}->{86132982} = "Xuchang\,\ Henan";
$areanames{en}->{861329827} = "Sanmenxia\,\ Henan";
$areanames{en}->{861329828} = "Sanmenxia\,\ Henan";
$areanames{en}->{861329829} = "Sanmenxia\,\ Henan";
$areanames{en}->{86132983} = "Zhengzhou\,\ Henan";
$areanames{en}->{861329837} = "Jiaozuo\,\ Henan";
$areanames{en}->{861329838} = "Jiaozuo\,\ Henan";
$areanames{en}->{861329839} = "Jiaozuo\,\ Henan";
$areanames{en}->{861329840} = "Zhengzhou\,\ Henan";
$areanames{en}->{861329841} = "Zhengzhou\,\ Henan";
$areanames{en}->{861329842} = "Zhengzhou\,\ Henan";
$areanames{en}->{861329843} = "Xuchang\,\ Henan";
$areanames{en}->{861329844} = "Xuchang\,\ Henan";
$areanames{en}->{861329845} = "Xuchang\,\ Henan";
$areanames{en}->{861329846} = "Jiaozuo\,\ Henan";
$areanames{en}->{861329847} = "Jiaozuo\,\ Henan";
$areanames{en}->{861329848} = "Sanmenxia\,\ Henan";
$areanames{en}->{861329849} = "Sanmenxia\,\ Henan";
$areanames{en}->{861329850} = "Yueyang\,\ Hunan";
$areanames{en}->{861329851} = "Yueyang\,\ Hunan";
$areanames{en}->{861329852} = "Xiangtan\,\ Hunan";
$areanames{en}->{861329853} = "Xiangtan\,\ Hunan";
$areanames{en}->{861329854} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861329855} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861329856} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861329857} = "Hengyang\,\ Hunan";
$areanames{en}->{861329858} = "Hengyang\,\ Hunan";
$areanames{en}->{861329859} = "Chenzhou\,\ Hunan";
$areanames{en}->{861329860} = "Changde\,\ Hunan";
$areanames{en}->{861329861} = "Changde\,\ Hunan";
$areanames{en}->{861329862} = "Yiyang\,\ Hunan";
$areanames{en}->{861329863} = "Hengyang\,\ Hunan";
$areanames{en}->{861329864} = "Shaoyang\,\ Hunan";
$areanames{en}->{861329865} = "Changsha\,\ Hunan";
$areanames{en}->{861329866} = "Huaihua\,\ Hunan";
$areanames{en}->{861329867} = "Yongzhou\,\ Hunan";
$areanames{en}->{861329868} = "Changsha\,\ Hunan";
$areanames{en}->{861329869} = "Changsha\,\ Hunan";
$areanames{en}->{861329870} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861329871} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861329872} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861329873} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861329874} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861329875} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861329876} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861329877} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861329878} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861329879} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861329880} = "Yanbian\,\ Jilin";
$areanames{en}->{861329881} = "Baishan\,\ Jilin";
$areanames{en}->{861329882} = "Songyuan\,\ Jilin";
$areanames{en}->{861329883} = "Songyuan\,\ Jilin";
$areanames{en}->{861329884} = "Tonghua\,\ Jilin";
$areanames{en}->{861329885} = "Tonghua\,\ Jilin";
$areanames{en}->{861329886} = "Tonghua\,\ Jilin";
$areanames{en}->{861329887} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861329888} = "Changchun\,\ Jilin";
$areanames{en}->{861329889} = "Siping\,\ Jilin";
$areanames{en}->{86132989} = "Lhasa\,\ Tibet";
$areanames{en}->{861329892} = "Xigaze\,\ Tibet";
$areanames{en}->{861329893} = "Shannan\,\ Tibet";
$areanames{en}->{861329894} = "Nyingchi\,\ Tibet";
$areanames{en}->{861329896} = "Nagqu\,\ Tibet";
$areanames{en}->{86132990} = "XiAn\,\ Shaanxi";
$areanames{en}->{86132991} = "XiAn\,\ Shaanxi";
$areanames{en}->{861329914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861329915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861329918} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861329920} = "Nanning\,\ Guangxi";
$areanames{en}->{861329921} = "Nanning\,\ Guangxi";
$areanames{en}->{861329922} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329923} = "Guilin\,\ Guangxi";
$areanames{en}->{861329924} = "Yulin\,\ Guangxi";
$areanames{en}->{861329925} = "Yulin\,\ Guangxi";
$areanames{en}->{861329926} = "Nanning\,\ Guangxi";
$areanames{en}->{861329927} = "Guilin\,\ Guangxi";
$areanames{en}->{861329928} = "Hechi\,\ Guangxi";
$areanames{en}->{861329929} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329930} = "Linxia\,\ Gansu";
$areanames{en}->{861329931} = "Lanzhou\,\ Gansu";
$areanames{en}->{861329932} = "Jiuquan\,\ Gansu";
$areanames{en}->{861329933} = "Baiyin\,\ Gansu";
$areanames{en}->{861329934} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861329935} = "Wuwei\,\ Gansu";
$areanames{en}->{861329936} = "Wuwei\,\ Gansu";
$areanames{en}->{861329937} = "Jiuquan\,\ Gansu";
$areanames{en}->{861329938} = "Jiuquan\,\ Gansu";
$areanames{en}->{861329939} = "Longnan\,\ Gansu";
$areanames{en}->{861329940} = "Nanning\,\ Guangxi";
$areanames{en}->{861329941} = "Nanning\,\ Guangxi";
$areanames{en}->{861329942} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329943} = "Guilin\,\ Guangxi";
$areanames{en}->{861329944} = "Yulin\,\ Guangxi";
$areanames{en}->{861329945} = "Yulin\,\ Guangxi";
$areanames{en}->{861329946} = "Yulin\,\ Guangxi";
$areanames{en}->{861329947} = "Guilin\,\ Guangxi";
$areanames{en}->{861329948} = "Hechi\,\ Guangxi";
$areanames{en}->{861329949} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861329951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861329952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861329953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861329954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861329955} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861329956} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861329957} = "Zhongwei\,\ Ningxia";
$areanames{en}->{861329958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861329959} = "Guyuan\,\ Ningxia";
$areanames{en}->{861329960} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329961} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329962} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329963} = "Guilin\,\ Guangxi";
$areanames{en}->{861329964} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861329965} = "Yulin\,\ Guangxi";
$areanames{en}->{861329966} = "Yulin\,\ Guangxi";
$areanames{en}->{861329967} = "Yulin\,\ Guangxi";
$areanames{en}->{861329968} = "Yulin\,\ Guangxi";
$areanames{en}->{861329969} = "Yulin\,\ Guangxi";
$areanames{en}->{861329970} = "Haibei\,\ Qinghai";
$areanames{en}->{861329971} = "Xining\,\ Qinghai";
$areanames{en}->{861329972} = "Haidong\,\ Qinghai";
$areanames{en}->{861329973} = "Huangnan\,\ Qinghai";
$areanames{en}->{861329974} = "Hainan\,\ Qinghai";
$areanames{en}->{861329975} = "Haidong\,\ Qinghai";
$areanames{en}->{861329976} = "Xining\,\ Qinghai";
$areanames{en}->{861329977} = "Haidong\,\ Qinghai";
$areanames{en}->{861329978} = "Xining\,\ Qinghai";
$areanames{en}->{861329979} = "Haidong\,\ Qinghai";
$areanames{en}->{861329980} = "Xining\,\ Qinghai";
$areanames{en}->{861329981} = "Xining\,\ Qinghai";
$areanames{en}->{861329982} = "Haidong\,\ Qinghai";
$areanames{en}->{861329983} = "Haidong\,\ Qinghai";
$areanames{en}->{861329984} = "Hainan\,\ Qinghai";
$areanames{en}->{861329985} = "Haidong\,\ Qinghai";
$areanames{en}->{861329986} = "Yushu\,\ Qinghai";
$areanames{en}->{861329987} = "Haixi\,\ Qinghai";
$areanames{en}->{861329988} = "Xining\,\ Qinghai";
$areanames{en}->{861329989} = "Haidong\,\ Qinghai";
$areanames{en}->{86132999} = "Tianjin";
$areanames{en}->{861330000} = "Nanning\,\ Guangxi";
$areanames{en}->{861330001} = "Anqing\,\ Anhui";
$areanames{en}->{861330002} = "Chongqing";
$areanames{en}->{861330003} = "Chongqing";
$areanames{en}->{861330010} = "Beijing";
$areanames{en}->{861330011} = "Beijing";
$areanames{en}->{861330018} = "Shanghai";
$areanames{en}->{861330019} = "Shanghai";
$areanames{en}->{86133003} = "Tianjin";
$areanames{en}->{86133005} = "Shanghai";
$areanames{en}->{86133006} = "Shanghai";
$areanames{en}->{86133007} = "Nanning\,\ Guangxi";
$areanames{en}->{86133008} = "Shanghai";
$areanames{en}->{86133009} = "Shanghai";
$areanames{en}->{86133010} = "Beijing";
$areanames{en}->{86133011} = "Beijing";
$areanames{en}->{86133012} = "Beijing";
$areanames{en}->{86133013} = "Beijing";
$areanames{en}->{861330140} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861330141} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861330142} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861330143} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861330144} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861330145} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861330146} = "Nantong\,\ Jiangsu";
$areanames{en}->{861330147} = "Nantong\,\ Jiangsu";
$areanames{en}->{861330148} = "Nantong\,\ Jiangsu";
$areanames{en}->{861330149} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861330150} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861330151} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861330152} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861330153} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861330154} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861330155} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861330156} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861330157} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861330158} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861330159} = "Nanjing\,\ Jiangsu";
$areanames{en}->{86133016} = "Shanghai";
$areanames{en}->{86133017} = "Shanghai";
$areanames{en}->{86133018} = "Shanghai";
$areanames{en}->{86133019} = "Shanghai";
$areanames{en}->{86133020} = "Tianjin";
$areanames{en}->{86133021} = "Tianjin";
$areanames{en}->{86133022} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861330230} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861330231} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861330232} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861330233} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861330234} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861330235} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861330236} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861330237} = "Yunfu\,\ Guangdong";
$areanames{en}->{861330238} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861330239} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86133024} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861330240} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861330241} = "Foshan\,\ Guangdong";
$areanames{en}->{861330242} = "Foshan\,\ Guangdong";
$areanames{en}->{861330249} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861330250} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861330251} = "Maoming\,\ Guangdong";
$areanames{en}->{861330252} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861330253} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861330254} = "Maoming\,\ Guangdong";
$areanames{en}->{861330255} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861330256} = "Foshan\,\ Guangdong";
$areanames{en}->{861330257} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861330258} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861330259} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861330260} = "Dongguan\,\ Guangdong";
$areanames{en}->{861330261} = "Dongguan\,\ Guangdong";
$areanames{en}->{861330262} = "Huizhou\,\ Guangdong";
$areanames{en}->{861330263} = "Heyuan\,\ Guangdong";
$areanames{en}->{861330264} = "Dongguan\,\ Guangdong";
$areanames{en}->{861330265} = "Huizhou\,\ Guangdong";
$areanames{en}->{861330266} = "Huizhou\,\ Guangdong";
$areanames{en}->{861330267} = "Shanwei\,\ Guangdong";
$areanames{en}->{861330268} = "Shanwei\,\ Guangdong";
$areanames{en}->{861330269} = "Dongguan\,\ Guangdong";
$areanames{en}->{86133027} = "Shantou\,\ Guangdong";
$areanames{en}->{861330275} = "Jieyang\,\ Guangdong";
$areanames{en}->{861330276} = "Jieyang\,\ Guangdong";
$areanames{en}->{861330278} = "Meizhou\,\ Guangdong";
$areanames{en}->{861330279} = "Chaozhou\,\ Guangdong";
$areanames{en}->{86133028} = "Foshan\,\ Guangdong";
$areanames{en}->{861330282} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861330286} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861330287} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861330288} = "Jiangmen\,\ Guangdong";
$areanames{en}->{86133029} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861330300} = "Handan\,\ Hebei";
$areanames{en}->{861330301} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330302} = "Baoding\,\ Hebei";
$areanames{en}->{861330303} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330304} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330305} = "Tangshan\,\ Hebei";
$areanames{en}->{861330306} = "Cangzhou\,\ Hebei";
$areanames{en}->{861330307} = "Cangzhou\,\ Hebei";
$areanames{en}->{861330308} = "Handan\,\ Hebei";
$areanames{en}->{861330309} = "Xingtai\,\ Hebei";
$areanames{en}->{861330310} = "Handan\,\ Hebei";
$areanames{en}->{861330311} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330312} = "Baoding\,\ Hebei";
$areanames{en}->{861330313} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861330314} = "Chengde\,\ Hebei";
$areanames{en}->{861330315} = "Tangshan\,\ Hebei";
$areanames{en}->{861330316} = "Langfang\,\ Hebei";
$areanames{en}->{861330317} = "Cangzhou\,\ Hebei";
$areanames{en}->{861330318} = "Hengshui\,\ Hebei";
$areanames{en}->{861330319} = "Xingtai\,\ Hebei";
$areanames{en}->{861330320} = "Handan\,\ Hebei";
$areanames{en}->{861330321} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330322} = "Baoding\,\ Hebei";
$areanames{en}->{861330323} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330324} = "Tangshan\,\ Hebei";
$areanames{en}->{861330325} = "Tangshan\,\ Hebei";
$areanames{en}->{861330326} = "Baoding\,\ Hebei";
$areanames{en}->{861330327} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861330328} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861330329} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330330} = "Handan\,\ Hebei";
$areanames{en}->{861330331} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861330332} = "Baoding\,\ Hebei";
$areanames{en}->{861330333} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861330334} = "Tangshan\,\ Hebei";
$areanames{en}->{861330335} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861330336} = "Langfang\,\ Hebei";
$areanames{en}->{861330337} = "Cangzhou\,\ Hebei";
$areanames{en}->{861330338} = "Hengshui\,\ Hebei";
$areanames{en}->{861330339} = "Xingtai\,\ Hebei";
$areanames{en}->{861330340} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861330341} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861330342} = "Datong\,\ Shanxi";
$areanames{en}->{861330343} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861330344} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861330345} = "Changzhi\,\ Shanxi";
$areanames{en}->{861330346} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861330347} = "Linfen\,\ Shanxi";
$areanames{en}->{861330348} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861330349} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861330350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861330351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861330352} = "Datong\,\ Shanxi";
$areanames{en}->{861330353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861330354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861330355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861330356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861330357} = "Linfen\,\ Shanxi";
$areanames{en}->{861330358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861330359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861330360} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330361} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330362} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861330363} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861330364} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330365} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330366} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330367} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861330368} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861330369} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861330370} = "Shangqiu\,\ Henan";
$areanames{en}->{861330371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861330372} = "Anyang\,\ Henan";
$areanames{en}->{861330373} = "Xinxiang\,\ Henan";
$areanames{en}->{861330374} = "Xuchang\,\ Henan";
$areanames{en}->{861330375} = "Pingdingshan\,\ Henan";
$areanames{en}->{861330376} = "Xinyang\,\ Henan";
$areanames{en}->{861330377} = "Nanyang\,\ Henan";
$areanames{en}->{861330378} = "Kaifeng\,\ Henan";
$areanames{en}->{861330379} = "Luoyang\,\ Henan";
$areanames{en}->{86133038} = "Zhengzhou\,\ Henan";
$areanames{en}->{861330380} = "Xinxiang\,\ Henan";
$areanames{en}->{861330387} = "Zhoukou\,\ Henan";
$areanames{en}->{861330388} = "Luoyang\,\ Henan";
$areanames{en}->{861330389} = "Jiaozuo\,\ Henan";
$areanames{en}->{861330390} = "Pingdingshan\,\ Henan";
$areanames{en}->{861330391} = "Jiaozuo\,\ Henan";
$areanames{en}->{861330392} = "Hebi\,\ Henan";
$areanames{en}->{861330393} = "Puyang\,\ Henan";
$areanames{en}->{861330394} = "Zhoukou\,\ Henan";
$areanames{en}->{861330395} = "Luohe\,\ Henan";
$areanames{en}->{861330396} = "Zhumadian\,\ Henan";
$areanames{en}->{861330397} = "Xinyang\,\ Henan";
$areanames{en}->{861330398} = "Sanmenxia\,\ Henan";
$areanames{en}->{861330399} = "Xuchang\,\ Henan";
$areanames{en}->{86133040} = "Shenyang\,\ Liaoning";
$areanames{en}->{861330406} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861330407} = "Yingkou\,\ Liaoning";
$areanames{en}->{861330408} = "Dalian\,\ Liaoning";
$areanames{en}->{861330409} = "Dalian\,\ Liaoning";
$areanames{en}->{861330410} = "Tieling\,\ Liaoning";
$areanames{en}->{861330411} = "Dalian\,\ Liaoning";
$areanames{en}->{861330412} = "Anshan\,\ Liaoning";
$areanames{en}->{861330413} = "Fushun\,\ Liaoning";
$areanames{en}->{861330414} = "Benxi\,\ Liaoning";
$areanames{en}->{861330415} = "Dandong\,\ Liaoning";
$areanames{en}->{861330416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861330417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861330418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861330419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861330420} = "Anshan\,\ Liaoning";
$areanames{en}->{861330421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861330422} = "Anshan\,\ Liaoning";
$areanames{en}->{861330423} = "Fushun\,\ Liaoning";
$areanames{en}->{861330424} = "Benxi\,\ Liaoning";
$areanames{en}->{861330425} = "Dandong\,\ Liaoning";
$areanames{en}->{861330426} = "Dalian\,\ Liaoning";
$areanames{en}->{861330427} = "Panjin\,\ Liaoning";
$areanames{en}->{861330428} = "Dalian\,\ Liaoning";
$areanames{en}->{861330429} = "Huludao\,\ Liaoning";
$areanames{en}->{861330430} = "Changchun\,\ Jilin";
$areanames{en}->{861330431} = "Changchun\,\ Jilin";
$areanames{en}->{861330432} = "Changchun\,\ Jilin";
$areanames{en}->{861330433} = "Changchun\,\ Jilin";
$areanames{en}->{861330434} = "Siping\,\ Jilin";
$areanames{en}->{861330435} = "Siping\,\ Jilin";
$areanames{en}->{861330436} = "Baicheng\,\ Jilin";
$areanames{en}->{861330437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861330438} = "Songyuan\,\ Jilin";
$areanames{en}->{861330439} = "Changchun\,\ Jilin";
$areanames{en}->{861330440} = "Jilin\,\ Jilin";
$areanames{en}->{861330441} = "Jilin\,\ Jilin";
$areanames{en}->{861330442} = "Jilin\,\ Jilin";
$areanames{en}->{861330443} = "Yanbian\,\ Jilin";
$areanames{en}->{861330444} = "Jilin\,\ Jilin";
$areanames{en}->{861330445} = "Tonghua\,\ Jilin";
$areanames{en}->{861330446} = "Yanbian\,\ Jilin";
$areanames{en}->{861330447} = "Yanbian\,\ Jilin";
$areanames{en}->{861330448} = "Yanbian\,\ Jilin";
$areanames{en}->{861330449} = "Baishan\,\ Jilin";
$areanames{en}->{861330450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861330453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861330454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861330455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861330456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861330457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861330458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861330459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{86133046} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330462} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861330467} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861330468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861330469} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861330470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861330471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861330472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861330473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861330474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861330475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861330476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861330477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861330478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861330479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861330480} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330481} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330482} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861330483} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861330484} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861330485} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861330486} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861330487} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861330488} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861330489} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861330490} = "Tieling\,\ Liaoning";
$areanames{en}->{861330491} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861330492} = "Anshan\,\ Liaoning";
$areanames{en}->{861330493} = "Fushun\,\ Liaoning";
$areanames{en}->{861330494} = "Benxi\,\ Liaoning";
$areanames{en}->{861330495} = "Dandong\,\ Liaoning";
$areanames{en}->{861330496} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861330497} = "Yingkou\,\ Liaoning";
$areanames{en}->{861330498} = "Fuxin\,\ Liaoning";
$areanames{en}->{861330499} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861330500} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330501} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330502} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330503} = "Ningde\,\ Fujian";
$areanames{en}->{861330504} = "Putian\,\ Fujian";
$areanames{en}->{861330505} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330506} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330507} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330508} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330509} = "Nanping\,\ Fujian";
$areanames{en}->{86133051} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861330510} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861330511} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861330512} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861330513} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861330520} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861330521} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861330522} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861330523} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861330524} = "Suqian\,\ Jiangsu";
$areanames{en}->{861330525} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861330526} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861330527} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861330528} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861330529} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861330530} = "Heze\,\ Shandong";
$areanames{en}->{861330531} = "Jinan\,\ Shandong";
$areanames{en}->{861330532} = "Qingdao\,\ Shandong";
$areanames{en}->{861330533} = "Zibo\,\ Shandong";
$areanames{en}->{861330534} = "Dezhou\,\ Shandong";
$areanames{en}->{861330535} = "Yantai\,\ Shandong";
$areanames{en}->{861330536} = "Weifang\,\ Shandong";
$areanames{en}->{861330537} = "Jining\,\ Shandong";
$areanames{en}->{861330538} = "TaiAn\,\ Shandong";
$areanames{en}->{861330539} = "Linyi\,\ Shandong";
$areanames{en}->{861330540} = "Heze\,\ Shandong";
$areanames{en}->{861330541} = "Jinan\,\ Shandong";
$areanames{en}->{861330542} = "Qingdao\,\ Shandong";
$areanames{en}->{861330543} = "Binzhou\,\ Shandong";
$areanames{en}->{861330544} = "Dezhou\,\ Shandong";
$areanames{en}->{861330545} = "Yantai\,\ Shandong";
$areanames{en}->{861330546} = "Dongying\,\ Shandong";
$areanames{en}->{861330547} = "Jining\,\ Shandong";
$areanames{en}->{861330548} = "TaiAn\,\ Shandong";
$areanames{en}->{861330549} = "Linyi\,\ Shandong";
$areanames{en}->{861330550} = "Chuzhou\,\ Anhui";
$areanames{en}->{861330551} = "Hefei\,\ Anhui";
$areanames{en}->{861330552} = "Bengbu\,\ Anhui";
$areanames{en}->{861330553} = "Wuhu\,\ Anhui";
$areanames{en}->{861330554} = "Huainan\,\ Anhui";
$areanames{en}->{861330555} = "MaAnshan\,\ Anhui";
$areanames{en}->{861330556} = "Anqing\,\ Anhui";
$areanames{en}->{861330557} = "Suzhou\,\ Anhui";
$areanames{en}->{861330558} = "Fuyang\,\ Anhui";
$areanames{en}->{861330559} = "Huangshan\,\ Anhui";
$areanames{en}->{861330560} = "Hefei\,\ Anhui";
$areanames{en}->{861330561} = "Huaibei\,\ Anhui";
$areanames{en}->{861330562} = "Tongling\,\ Anhui";
$areanames{en}->{861330563} = "Xuancheng\,\ Anhui";
$areanames{en}->{861330564} = "LuAn\,\ Anhui";
$areanames{en}->{861330565} = "Chaohu\,\ Anhui";
$areanames{en}->{861330566} = "Chizhou\,\ Anhui";
$areanames{en}->{861330567} = "Suzhou\,\ Anhui";
$areanames{en}->{861330568} = "Fuyang\,\ Anhui";
$areanames{en}->{861330569} = "Hefei\,\ Anhui";
$areanames{en}->{861330570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861330571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861330572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861330573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861330574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861330575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861330576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861330577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861330578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861330579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861330580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861330581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861330582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861330583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861330584} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861330585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861330586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861330587} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861330588} = "Lishui\,\ Zhejiang";
$areanames{en}->{861330589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861330590} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330591} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330592} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330593} = "Ningde\,\ Fujian";
$areanames{en}->{861330594} = "Putian\,\ Fujian";
$areanames{en}->{861330595} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330596} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330597} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330598} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330599} = "Nanping\,\ Fujian";
$areanames{en}->{86133060} = "Xiamen\,\ Fujian";
$areanames{en}->{861330606} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861330607} = "Longyan\,\ Fujian";
$areanames{en}->{861330608} = "Sanming\,\ Fujian";
$areanames{en}->{861330609} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330610} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861330611} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861330612} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861330613} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861330614} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861330615} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861330616} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861330617} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861330618} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861330619} = "Wuxi\,\ Jiangsu";
$areanames{en}->{86133062} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861330627} = "Nantong\,\ Jiangsu";
$areanames{en}->{861330628} = "Nantong\,\ Jiangsu";
$areanames{en}->{861330629} = "Nantong\,\ Jiangsu";
$areanames{en}->{861330630} = "Weihai\,\ Shandong";
$areanames{en}->{861330631} = "Weihai\,\ Shandong";
$areanames{en}->{861330632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861330633} = "Rizhao\,\ Shandong";
$areanames{en}->{861330634} = "Laiwu\,\ Shandong";
$areanames{en}->{861330635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861330636} = "Weifang\,\ Shandong";
$areanames{en}->{861330637} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861330638} = "Yantai\,\ Shandong";
$areanames{en}->{861330639} = "Qingdao\,\ Shandong";
$areanames{en}->{861330640} = "Jinan\,\ Shandong";
$areanames{en}->{861330641} = "Jinan\,\ Shandong";
$areanames{en}->{861330642} = "Qingdao\,\ Shandong";
$areanames{en}->{861330643} = "Zibo\,\ Shandong";
$areanames{en}->{861330644} = "Jinan\,\ Shandong";
$areanames{en}->{861330645} = "Yantai\,\ Shandong";
$areanames{en}->{861330646} = "Weifang\,\ Shandong";
$areanames{en}->{861330647} = "Dongying\,\ Shandong";
$areanames{en}->{861330648} = "Qingdao\,\ Shandong";
$areanames{en}->{861330649} = "Binzhou\,\ Shandong";
$areanames{en}->{86133065} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861330650} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861330651} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861330652} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861330653} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{86133066} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861330670} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861330671} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861330672} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861330673} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861330674} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861330675} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861330676} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861330677} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861330678} = "Lishui\,\ Zhejiang";
$areanames{en}->{861330679} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861330680} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861330681} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861330682} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861330683} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861330684} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861330685} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861330686} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861330687} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861330688} = "Lishui\,\ Zhejiang";
$areanames{en}->{861330689} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861330690} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330691} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330692} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330693} = "Fuzhou\,\ Fujian";
$areanames{en}->{861330694} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861330695} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861330696} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861330697} = "Longyan\,\ Fujian";
$areanames{en}->{861330698} = "Sanming\,\ Fujian";
$areanames{en}->{861330699} = "Quanzhou\,\ Fujian";
$areanames{en}->{861330700} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861330701} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861330702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861330703} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861330704} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861330705} = "Yichun\,\ Jiangxi";
$areanames{en}->{861330706} = "JiAn\,\ Jiangxi";
$areanames{en}->{861330707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861330708} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861330709} = "Nanchang\,\ Jiangxi";
$areanames{en}->{86133071} = "Wuhan\,\ Hubei";
$areanames{en}->{861330720} = "Yichang\,\ Hubei";
$areanames{en}->{861330721} = "Jingzhou\,\ Hubei";
$areanames{en}->{861330722} = "Xiantao\,\ Hubei";
$areanames{en}->{861330723} = "Huangshi\,\ Hubei";
$areanames{en}->{861330724} = "Xianning\,\ Hubei";
$areanames{en}->{861330725} = "Huanggang\,\ Hubei";
$areanames{en}->{861330726} = "Enshi\,\ Hubei";
$areanames{en}->{861330727} = "Xiangfan\,\ Hubei";
$areanames{en}->{861330728} = "Shiyan\,\ Hubei";
$areanames{en}->{861330729} = "Xiaogan\,\ Hubei";
$areanames{en}->{861330730} = "Yueyang\,\ Hunan";
$areanames{en}->{861330731} = "Changsha\,\ Hunan";
$areanames{en}->{861330732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861330733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861330734} = "Hengyang\,\ Hunan";
$areanames{en}->{861330735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861330736} = "Changde\,\ Hunan";
$areanames{en}->{861330737} = "Yiyang\,\ Hunan";
$areanames{en}->{861330738} = "Loudi\,\ Hunan";
$areanames{en}->{861330739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861330740} = "Yueyang\,\ Hunan";
$areanames{en}->{861330741} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861330742} = "Changde\,\ Hunan";
$areanames{en}->{861330743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861330744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861330745} = "Huaihua\,\ Hunan";
$areanames{en}->{861330746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861330747} = "Hengyang\,\ Hunan";
$areanames{en}->{861330748} = "Changsha\,\ Hunan";
$areanames{en}->{861330749} = "Changsha\,\ Hunan";
$areanames{en}->{86133075} = "Haikou\,\ Hainan";
$areanames{en}->{86133076} = "Haikou\,\ Hainan";
$areanames{en}->{861330770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861330771} = "Nanning\,\ Guangxi";
$areanames{en}->{861330772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861330773} = "Guilin\,\ Guangxi";
$areanames{en}->{861330774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861330775} = "Yulin\,\ Guangxi";
$areanames{en}->{861330776} = "Baise\,\ Guangxi";
$areanames{en}->{861330777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861330778} = "Hechi\,\ Guangxi";
$areanames{en}->{861330779} = "Beihai\,\ Guangxi";
$areanames{en}->{861330780} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861330781} = "Nanning\,\ Guangxi";
$areanames{en}->{861330782} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861330783} = "Guilin\,\ Guangxi";
$areanames{en}->{861330784} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861330785} = "Yulin\,\ Guangxi";
$areanames{en}->{861330786} = "Nanning\,\ Guangxi";
$areanames{en}->{861330787} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861330788} = "Hechi\,\ Guangxi";
$areanames{en}->{861330789} = "Beihai\,\ Guangxi";
$areanames{en}->{861330790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861330791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861330792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861330793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861330794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861330795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861330796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861330797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861330798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861330799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86133080} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330810} = "Deyang\,\ Sichuan";
$areanames{en}->{861330811} = "Mianyang\,\ Sichuan";
$areanames{en}->{861330812} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861330813} = "Leshan\,\ Sichuan";
$areanames{en}->{861330814} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861330815} = "Liangshan\,\ Sichuan";
$areanames{en}->{861330816} = "YaAn\,\ Sichuan";
$areanames{en}->{861330817} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330818} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330819} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330820} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330821} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330822} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330823} = "Chengdu\,\ Sichuan";
$areanames{en}->{861330824} = "Dazhou\,\ Sichuan";
$areanames{en}->{861330825} = "Chongqing";
$areanames{en}->{861330826} = "Chongqing";
$areanames{en}->{861330827} = "Chongqing";
$areanames{en}->{861330828} = "GuangAn\,\ Sichuan";
$areanames{en}->{861330829} = "Bazhong\,\ Sichuan";
$areanames{en}->{86133083} = "Chongqing";
$areanames{en}->{86133084} = "Changsha\,\ Hunan";
$areanames{en}->{861330850} = "Guiyang\,\ Guizhou";
$areanames{en}->{861330851} = "Guiyang\,\ Guizhou";
$areanames{en}->{861330852} = "Zunyi\,\ Guizhou";
$areanames{en}->{861330853} = "Anshun\,\ Guizhou";
$areanames{en}->{861330854} = "Qiannan\,\ Guizhou";
$areanames{en}->{861330855} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861330856} = "Tongren\,\ Guizhou";
$areanames{en}->{861330857} = "Bijie\,\ Guizhou";
$areanames{en}->{861330858} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861330859} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861330860} = "Yichang\,\ Hubei";
$areanames{en}->{861330861} = "Jingzhou\,\ Hubei";
$areanames{en}->{861330862} = "Wuhan\,\ Hubei";
$areanames{en}->{861330863} = "Wuhan\,\ Hubei";
$areanames{en}->{861330864} = "Wuhan\,\ Hubei";
$areanames{en}->{861330865} = "Wuhan\,\ Hubei";
$areanames{en}->{861330866} = "Suizhou\,\ Hubei";
$areanames{en}->{861330867} = "Xiangfan\,\ Hubei";
$areanames{en}->{861330868} = "Ezhou\,\ Hubei";
$areanames{en}->{861330869} = "Jingmen\,\ Hubei";
$areanames{en}->{861330870} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861330871} = "Kunming\,\ Yunnan";
$areanames{en}->{861330872} = "Dali\,\ Yunnan";
$areanames{en}->{861330873} = "Honghe\,\ Yunnan";
$areanames{en}->{861330874} = "Qujing\,\ Yunnan";
$areanames{en}->{861330875} = "Baoshan\,\ Yunnan";
$areanames{en}->{861330876} = "Wenshan\,\ Yunnan";
$areanames{en}->{861330877} = "Yuxi\,\ Yunnan";
$areanames{en}->{861330878} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861330879} = "Puer\,\ Yunnan";
$areanames{en}->{861330880} = "Kunming\,\ Yunnan";
$areanames{en}->{861330881} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861330882} = "Dehong\,\ Yunnan";
$areanames{en}->{861330883} = "Lincang\,\ Yunnan";
$areanames{en}->{861330884} = "Kunming\,\ Yunnan";
$areanames{en}->{861330885} = "Kunming\,\ Yunnan";
$areanames{en}->{861330886} = "Nujiang\,\ Yunnan";
$areanames{en}->{861330887} = "Deqen\,\ Yunnan";
$areanames{en}->{861330888} = "Lijiang\,\ Yunnan";
$areanames{en}->{861330889} = "Yuxi\,\ Yunnan";
$areanames{en}->{861330890} = "Lhasa\,\ Tibet";
$areanames{en}->{861330891} = "Lhasa\,\ Tibet";
$areanames{en}->{861330892} = "Xigaze\,\ Tibet";
$areanames{en}->{861330893} = "Shannan\,\ Tibet";
$areanames{en}->{861330894} = "Nyingchi\,\ Tibet";
$areanames{en}->{861330895} = "Qamdo\,\ Tibet";
$areanames{en}->{861330896} = "Nagqu\,\ Tibet";
$areanames{en}->{861330897} = "Ngari\,\ Tibet";
$areanames{en}->{861330898} = "Lhasa\,\ Tibet";
$areanames{en}->{861330899} = "Lhasa\,\ Tibet";
$areanames{en}->{861330900} = "Zigong\,\ Sichuan";
$areanames{en}->{861330901} = "Mianyang\,\ Sichuan";
$areanames{en}->{861330902} = "Deyang\,\ Sichuan";
$areanames{en}->{861330903} = "Leshan\,\ Sichuan";
$areanames{en}->{861330904} = "Aba\,\ Sichuan";
$areanames{en}->{861330905} = "Neijiang\,\ Sichuan";
$areanames{en}->{861330906} = "Suining\,\ Sichuan";
$areanames{en}->{861330907} = "Nanchong\,\ Sichuan";
$areanames{en}->{861330908} = "Luzhou\,\ Sichuan";
$areanames{en}->{861330909} = "Yibin\,\ Sichuan";
$areanames{en}->{861330910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861330911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861330912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861330913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861330914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861330915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861330916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861330917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861330918} = "XiAn\,\ Shaanxi";
$areanames{en}->{861330919} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{86133092} = "XiAn\,\ Shaanxi";
$areanames{en}->{861330930} = "Linxia\,\ Gansu";
$areanames{en}->{861330931} = "Lanzhou\,\ Gansu";
$areanames{en}->{861330932} = "Dingxi\,\ Gansu";
$areanames{en}->{861330933} = "Pingliang\,\ Gansu";
$areanames{en}->{861330934} = "Qingyang\,\ Gansu";
$areanames{en}->{861330935} = "Wuwei\,\ Gansu";
$areanames{en}->{861330936} = "Zhangye\,\ Gansu";
$areanames{en}->{861330937} = "Jiuquan\,\ Gansu";
$areanames{en}->{861330938} = "Tianshui\,\ Gansu";
$areanames{en}->{861330939} = "Longnan\,\ Gansu";
$areanames{en}->{86133094} = "Lanzhou\,\ Gansu";
$areanames{en}->{861330943} = "Baiyin\,\ Gansu";
$areanames{en}->{861330945} = "Jinchang\,\ Gansu";
$areanames{en}->{861330947} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861330950} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861330951} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861330952} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861330953} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861330954} = "Guyuan\,\ Ningxia";
$areanames{en}->{861330955} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861330956} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861330957} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861330958} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861330959} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861330960} = "Chuzhou\,\ Anhui";
$areanames{en}->{861330961} = "Huaibei\,\ Anhui";
$areanames{en}->{861330962} = "Bengbu\,\ Anhui";
$areanames{en}->{861330963} = "Wuhu\,\ Anhui";
$areanames{en}->{861330964} = "Huainan\,\ Anhui";
$areanames{en}->{861330965} = "Bengbu\,\ Anhui";
$areanames{en}->{861330966} = "Anqing\,\ Anhui";
$areanames{en}->{861330967} = "Bozhou\,\ Anhui";
$areanames{en}->{861330968} = "Fuyang\,\ Anhui";
$areanames{en}->{861330969} = "Hefei\,\ Anhui";
$areanames{en}->{861330970} = "Haibei\,\ Qinghai";
$areanames{en}->{861330971} = "Xining\,\ Qinghai";
$areanames{en}->{861330972} = "Haidong\,\ Qinghai";
$areanames{en}->{861330973} = "Huangnan\,\ Qinghai";
$areanames{en}->{861330974} = "Hainan\,\ Qinghai";
$areanames{en}->{861330975} = "Golog\,\ Qinghai";
$areanames{en}->{861330976} = "Yushu\,\ Qinghai";
$areanames{en}->{861330977} = "Haixi\,\ Qinghai";
$areanames{en}->{861330978} = "Xining\,\ Qinghai";
$areanames{en}->{861330979} = "Haixi\,\ Qinghai";
$areanames{en}->{861330980} = "Anshan\,\ Liaoning";
$areanames{en}->{861330981} = "Shenyang\,\ Liaoning";
$areanames{en}->{861330982} = "Shenyang\,\ Liaoning";
$areanames{en}->{861330983} = "Shenyang\,\ Liaoning";
$areanames{en}->{861330984} = "Dalian\,\ Liaoning";
$areanames{en}->{861330985} = "Dalian\,\ Liaoning";
$areanames{en}->{861330986} = "Dalian\,\ Liaoning";
$areanames{en}->{861330987} = "Panjin\,\ Liaoning";
$areanames{en}->{861330988} = "Shenyang\,\ Liaoning";
$areanames{en}->{861330989} = "Huludao\,\ Liaoning";
$areanames{en}->{861330990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861330991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861330992} = "Ili\,\ Xinjiang";
$areanames{en}->{861330993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861330994} = "Changji\,\ Xinjiang";
$areanames{en}->{861330995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861330996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861330997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861330998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861330999} = "Ili\,\ Xinjiang";
$areanames{en}->{86133100} = "Shanghai";
$areanames{en}->{86133101} = "Shanghai";
$areanames{en}->{86133102} = "Chongqing";
$areanames{en}->{861331030} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861331031} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861331032} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861331033} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861331034} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861331035} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861331036} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861331037} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861331038} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861331039} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861331040} = "Guiyang\,\ Guizhou";
$areanames{en}->{861331041} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331042} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331043} = "Anshun\,\ Guizhou";
$areanames{en}->{861331044} = "Qiannan\,\ Guizhou";
$areanames{en}->{861331045} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861331046} = "Tongren\,\ Guizhou";
$areanames{en}->{861331047} = "Bijie\,\ Guizhou";
$areanames{en}->{861331048} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331049} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331050} = "Jingmen\,\ Hubei";
$areanames{en}->{861331051} = "Jingmen\,\ Hubei";
$areanames{en}->{861331052} = "Jingmen\,\ Hubei";
$areanames{en}->{861331053} = "Enshi\,\ Hubei";
$areanames{en}->{861331054} = "Enshi\,\ Hubei";
$areanames{en}->{861331055} = "Enshi\,\ Hubei";
$areanames{en}->{861331056} = "Yichang\,\ Hubei";
$areanames{en}->{861331057} = "Yichang\,\ Hubei";
$areanames{en}->{861331058} = "Jingzhou\,\ Hubei";
$areanames{en}->{861331059} = "Jingzhou\,\ Hubei";
$areanames{en}->{861331060} = "Dezhou\,\ Shandong";
$areanames{en}->{861331061} = "Jinan\,\ Shandong";
$areanames{en}->{861331062} = "Liaocheng\,\ Shandong";
$areanames{en}->{861331063} = "Rizhao\,\ Shandong";
$areanames{en}->{861331064} = "Rizhao\,\ Shandong";
$areanames{en}->{861331065} = "Liaocheng\,\ Shandong";
$areanames{en}->{861331066} = "Qingdao\,\ Shandong";
$areanames{en}->{861331067} = "Qingdao\,\ Shandong";
$areanames{en}->{861331068} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861331069} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861331070} = "Bijie\,\ Guizhou";
$areanames{en}->{861331071} = "Tongren\,\ Guizhou";
$areanames{en}->{861331072} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331073} = "Anshun\,\ Guizhou";
$areanames{en}->{861331074} = "Qiannan\,\ Guizhou";
$areanames{en}->{861331075} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861331076} = "Tongren\,\ Guizhou";
$areanames{en}->{861331077} = "Bijie\,\ Guizhou";
$areanames{en}->{861331078} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861331079} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861331080} = "Dongguan\,\ Guangdong";
$areanames{en}->{861331081} = "Dongguan\,\ Guangdong";
$areanames{en}->{861331082} = "Dongguan\,\ Guangdong";
$areanames{en}->{861331083} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861331084} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861331085} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861331086} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861331087} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861331088} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861331089} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861331090} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861331091} = "YanAn\,\ Shaanxi";
$areanames{en}->{861331092} = "Yulin\,\ Shaanxi";
$areanames{en}->{861331093} = "Weinan\,\ Shaanxi";
$areanames{en}->{861331094} = "XiAn\,\ Shaanxi";
$areanames{en}->{861331095} = "Ankang\,\ Shaanxi";
$areanames{en}->{861331096} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861331097} = "XiAn\,\ Shaanxi";
$areanames{en}->{861331098} = "XiAn\,\ Shaanxi";
$areanames{en}->{861331099} = "Yulin\,\ Shaanxi";
$areanames{en}->{8613311} = "Beijing";
$areanames{en}->{86133116} = "Shanghai";
$areanames{en}->{86133117} = "Shanghai";
$areanames{en}->{86133118} = "Shanghai";
$areanames{en}->{86133119} = "Shanghai";
$areanames{en}->{86133120} = "Tianjin";
$areanames{en}->{86133121} = "Tianjin";
$areanames{en}->{86133122} = "Guiyang\,\ Guizhou";
$areanames{en}->{861331229} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86133123} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331236} = "Qiannan\,\ Guizhou";
$areanames{en}->{861331237} = "Qiannan\,\ Guizhou";
$areanames{en}->{861331238} = "Qiannan\,\ Guizhou";
$areanames{en}->{861331239} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861331240} = "Anshun\,\ Guizhou";
$areanames{en}->{861331241} = "Anshun\,\ Guizhou";
$areanames{en}->{861331242} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861331243} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861331244} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861331245} = "Tongren\,\ Guizhou";
$areanames{en}->{861331246} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861331247} = "Bijie\,\ Guizhou";
$areanames{en}->{861331248} = "Bijie\,\ Guizhou";
$areanames{en}->{861331249} = "Qianxinan\,\ Guizhou";
$areanames{en}->{86133125} = "Kunming\,\ Yunnan";
$areanames{en}->{861331260} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861331261} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861331262} = "Qujing\,\ Yunnan";
$areanames{en}->{861331263} = "Qujing\,\ Yunnan";
$areanames{en}->{861331264} = "Yuxi\,\ Yunnan";
$areanames{en}->{861331265} = "Yuxi\,\ Yunnan";
$areanames{en}->{861331266} = "Honghe\,\ Yunnan";
$areanames{en}->{861331267} = "Honghe\,\ Yunnan";
$areanames{en}->{861331268} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861331269} = "Lijiang\,\ Yunnan";
$areanames{en}->{861331270} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861331271} = "Lincang\,\ Yunnan";
$areanames{en}->{861331272} = "Dehong\,\ Yunnan";
$areanames{en}->{861331273} = "Deqen\,\ Yunnan";
$areanames{en}->{861331274} = "Dali\,\ Yunnan";
$areanames{en}->{861331275} = "Nujiang\,\ Yunnan";
$areanames{en}->{861331276} = "Wenshan\,\ Yunnan";
$areanames{en}->{861331277} = "Puer\,\ Yunnan";
$areanames{en}->{861331278} = "Dali\,\ Yunnan";
$areanames{en}->{861331279} = "Baoshan\,\ Yunnan";
$areanames{en}->{86133128} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86133129} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861331300} = "Handan\,\ Hebei";
$areanames{en}->{861331301} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331302} = "Baoding\,\ Hebei";
$areanames{en}->{861331303} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331304} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331305} = "Tangshan\,\ Hebei";
$areanames{en}->{861331306} = "Langfang\,\ Hebei";
$areanames{en}->{861331307} = "Cangzhou\,\ Hebei";
$areanames{en}->{861331308} = "Hengshui\,\ Hebei";
$areanames{en}->{861331309} = "Xingtai\,\ Hebei";
$areanames{en}->{861331310} = "Handan\,\ Hebei";
$areanames{en}->{861331311} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331312} = "Baoding\,\ Hebei";
$areanames{en}->{861331313} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861331314} = "Chengde\,\ Hebei";
$areanames{en}->{861331315} = "Tangshan\,\ Hebei";
$areanames{en}->{861331316} = "Langfang\,\ Hebei";
$areanames{en}->{861331317} = "Cangzhou\,\ Hebei";
$areanames{en}->{861331318} = "Hengshui\,\ Hebei";
$areanames{en}->{861331319} = "Xingtai\,\ Hebei";
$areanames{en}->{861331320} = "Handan\,\ Hebei";
$areanames{en}->{861331321} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331322} = "Baoding\,\ Hebei";
$areanames{en}->{861331323} = "Baoding\,\ Hebei";
$areanames{en}->{861331324} = "Baoding\,\ Hebei";
$areanames{en}->{861331325} = "Tangshan\,\ Hebei";
$areanames{en}->{861331326} = "Langfang\,\ Hebei";
$areanames{en}->{861331327} = "Cangzhou\,\ Hebei";
$areanames{en}->{861331328} = "Chengde\,\ Hebei";
$areanames{en}->{861331329} = "Tangshan\,\ Hebei";
$areanames{en}->{861331330} = "Handan\,\ Hebei";
$areanames{en}->{861331331} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331332} = "Baoding\,\ Hebei";
$areanames{en}->{861331333} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331334} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331335} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331336} = "Langfang\,\ Hebei";
$areanames{en}->{861331337} = "Cangzhou\,\ Hebei";
$areanames{en}->{861331338} = "Chengde\,\ Hebei";
$areanames{en}->{861331339} = "Xingtai\,\ Hebei";
$areanames{en}->{861331340} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861331341} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861331342} = "Datong\,\ Shanxi";
$areanames{en}->{861331343} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861331344} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861331345} = "Changzhi\,\ Shanxi";
$areanames{en}->{861331346} = "Jincheng\,\ Shanxi";
$areanames{en}->{861331347} = "Linfen\,\ Shanxi";
$areanames{en}->{861331348} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861331349} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861331350} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861331351} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861331352} = "Datong\,\ Shanxi";
$areanames{en}->{861331353} = "Yangquan\,\ Shanxi";
$areanames{en}->{861331354} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861331355} = "Changzhi\,\ Shanxi";
$areanames{en}->{861331356} = "Jincheng\,\ Shanxi";
$areanames{en}->{861331357} = "Linfen\,\ Shanxi";
$areanames{en}->{861331358} = "Lüliang\,\ Shanxi";
$areanames{en}->{861331359} = "Yuncheng\,\ Shanxi";
$areanames{en}->{86133136} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861331370} = "Xiamen\,\ Fujian";
$areanames{en}->{861331371} = "Ningde\,\ Fujian";
$areanames{en}->{861331372} = "Ningde\,\ Fujian";
$areanames{en}->{861331373} = "Sanming\,\ Fujian";
$areanames{en}->{861331374} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331375} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331376} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331377} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331378} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331379} = "Nanping\,\ Fujian";
$areanames{en}->{861331380} = "Sanming\,\ Fujian";
$areanames{en}->{861331381} = "Sanming\,\ Fujian";
$areanames{en}->{861331382} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331383} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331384} = "Xiamen\,\ Fujian";
$areanames{en}->{861331385} = "Xiamen\,\ Fujian";
$areanames{en}->{861331386} = "Xiamen\,\ Fujian";
$areanames{en}->{861331387} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331388} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331389} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331390} = "Nanping\,\ Fujian";
$areanames{en}->{861331391} = "Nanping\,\ Fujian";
$areanames{en}->{861331392} = "Longyan\,\ Fujian";
$areanames{en}->{861331393} = "Longyan\,\ Fujian";
$areanames{en}->{861331394} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331395} = "Putian\,\ Fujian";
$areanames{en}->{861331396} = "Putian\,\ Fujian";
$areanames{en}->{861331397} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331398} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331399} = "Longyan\,\ Fujian";
$areanames{en}->{861331400} = "Shenyang\,\ Liaoning";
$areanames{en}->{861331401} = "Shenyang\,\ Liaoning";
$areanames{en}->{861331402} = "Shenyang\,\ Liaoning";
$areanames{en}->{861331403} = "Anshan\,\ Liaoning";
$areanames{en}->{861331404} = "Anshan\,\ Liaoning";
$areanames{en}->{861331405} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861331406} = "Yingkou\,\ Liaoning";
$areanames{en}->{861331407} = "Yingkou\,\ Liaoning";
$areanames{en}->{861331408} = "Dandong\,\ Liaoning";
$areanames{en}->{861331409} = "Huludao\,\ Liaoning";
$areanames{en}->{861331410} = "Tieling\,\ Liaoning";
$areanames{en}->{861331411} = "Dalian\,\ Liaoning";
$areanames{en}->{861331412} = "Anshan\,\ Liaoning";
$areanames{en}->{861331413} = "Fushun\,\ Liaoning";
$areanames{en}->{861331414} = "Benxi\,\ Liaoning";
$areanames{en}->{861331415} = "Dandong\,\ Liaoning";
$areanames{en}->{861331416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861331417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861331418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861331419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861331420} = "Shenyang\,\ Liaoning";
$areanames{en}->{861331421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861331422} = "Shenyang\,\ Liaoning";
$areanames{en}->{861331423} = "Shenyang\,\ Liaoning";
$areanames{en}->{861331424} = "Shenyang\,\ Liaoning";
$areanames{en}->{861331425} = "Anshan\,\ Liaoning";
$areanames{en}->{861331426} = "Dalian\,\ Liaoning";
$areanames{en}->{861331427} = "Panjin\,\ Liaoning";
$areanames{en}->{861331428} = "Dalian\,\ Liaoning";
$areanames{en}->{861331429} = "Huludao\,\ Liaoning";
$areanames{en}->{861331430} = "Changchun\,\ Jilin";
$areanames{en}->{861331431} = "Changchun\,\ Jilin";
$areanames{en}->{861331432} = "Jilin\,\ Jilin";
$areanames{en}->{861331433} = "Yanbian\,\ Jilin";
$areanames{en}->{861331434} = "Siping\,\ Jilin";
$areanames{en}->{861331435} = "Tonghua\,\ Jilin";
$areanames{en}->{861331436} = "Jilin\,\ Jilin";
$areanames{en}->{861331437} = "Jilin\,\ Jilin";
$areanames{en}->{861331438} = "Yanbian\,\ Jilin";
$areanames{en}->{861331439} = "Changchun\,\ Jilin";
$areanames{en}->{861331440} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331441} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331442} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331443} = "Zunyi\,\ Guizhou";
$areanames{en}->{861331444} = "Qiannan\,\ Guizhou";
$areanames{en}->{861331445} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861331446} = "Tongren\,\ Guizhou";
$areanames{en}->{861331447} = "Bijie\,\ Guizhou";
$areanames{en}->{861331448} = "Qiannan\,\ Guizhou";
$areanames{en}->{861331449} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861331450} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861331451} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861331452} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861331453} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861331454} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861331455} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861331456} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861331457} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861331458} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861331459} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861331460} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861331461} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861331462} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861331463} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861331464} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861331465} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861331466} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861331467} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861331468} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861331469} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861331470} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861331471} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861331472} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861331473} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861331474} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861331475} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861331476} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861331477} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861331478} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861331479} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861331480} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861331481} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861331482} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861331483} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861331484} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861331485} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861331486} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861331487} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861331488} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861331489} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{86133149} = "Fuzhou\,\ Fujian";
$areanames{en}->{861331496} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331497} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331498} = "Quanzhou\,\ Fujian";
$areanames{en}->{861331499} = "Quanzhou\,\ Fujian";
$areanames{en}->{86133150} = "Handan\,\ Hebei";
$areanames{en}->{86133151} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86133152} = "Baoding\,\ Hebei";
$areanames{en}->{861331530} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861331531} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861331532} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861331533} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861331534} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861331535} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331536} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331537} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331538} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331539} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331540} = "Baoding\,\ Hebei";
$areanames{en}->{861331541} = "Baoding\,\ Hebei";
$areanames{en}->{861331542} = "Baoding\,\ Hebei";
$areanames{en}->{861331543} = "Baoding\,\ Hebei";
$areanames{en}->{861331544} = "Baoding\,\ Hebei";
$areanames{en}->{861331545} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331546} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331547} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331548} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331549} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86133155} = "Tangshan\,\ Hebei";
$areanames{en}->{861331560} = "Langfang\,\ Hebei";
$areanames{en}->{861331561} = "Langfang\,\ Hebei";
$areanames{en}->{861331562} = "Langfang\,\ Hebei";
$areanames{en}->{861331563} = "Langfang\,\ Hebei";
$areanames{en}->{861331564} = "Langfang\,\ Hebei";
$areanames{en}->{861331565} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331566} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331567} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331568} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861331569} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{86133157} = "Cangzhou\,\ Hebei";
$areanames{en}->{86133158} = "Hengshui\,\ Hebei";
$areanames{en}->{861331587} = "Chengde\,\ Hebei";
$areanames{en}->{861331588} = "Chengde\,\ Hebei";
$areanames{en}->{861331589} = "Chengde\,\ Hebei";
$areanames{en}->{861331590} = "Xingtai\,\ Hebei";
$areanames{en}->{861331591} = "Xingtai\,\ Hebei";
$areanames{en}->{861331592} = "Xingtai\,\ Hebei";
$areanames{en}->{861331593} = "Xingtai\,\ Hebei";
$areanames{en}->{861331594} = "Xingtai\,\ Hebei";
$areanames{en}->{861331595} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331596} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331597} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331598} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861331599} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{86133160} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86133161} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86133162} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86133163} = "Huizhou\,\ Guangdong";
$areanames{en}->{861331630} = "Foshan\,\ Guangdong";
$areanames{en}->{861331631} = "Foshan\,\ Guangdong";
$areanames{en}->{861331632} = "Foshan\,\ Guangdong";
$areanames{en}->{86133164} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86133165} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86133166} = "Dongguan\,\ Guangdong";
$areanames{en}->{86133167} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861331677} = "Huizhou\,\ Guangdong";
$areanames{en}->{861331678} = "Huizhou\,\ Guangdong";
$areanames{en}->{861331679} = "Huizhou\,\ Guangdong";
$areanames{en}->{86133168} = "Shenzhen\,\ Guangdong";
$areanames{en}->{86133169} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861331700} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861331701} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861331702} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861331703} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861331704} = "JiAn\,\ Jiangxi";
$areanames{en}->{861331705} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861331706} = "JiAn\,\ Jiangxi";
$areanames{en}->{861331707} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861331708} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861331709} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86133171} = "Wuhan\,\ Hubei";
$areanames{en}->{861331720} = "Yichang\,\ Hubei";
$areanames{en}->{861331721} = "Jingzhou\,\ Hubei";
$areanames{en}->{861331722} = "Jingzhou\,\ Hubei";
$areanames{en}->{861331723} = "Huangshi\,\ Hubei";
$areanames{en}->{861331724} = "Xianning\,\ Hubei";
$areanames{en}->{861331725} = "Huanggang\,\ Hubei";
$areanames{en}->{861331726} = "Enshi\,\ Hubei";
$areanames{en}->{861331727} = "Xiangfan\,\ Hubei";
$areanames{en}->{861331728} = "Shiyan\,\ Hubei";
$areanames{en}->{861331729} = "Shiyan\,\ Hubei";
$areanames{en}->{861331730} = "Yueyang\,\ Hunan";
$areanames{en}->{861331731} = "Changsha\,\ Hunan";
$areanames{en}->{861331732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861331733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861331734} = "Hengyang\,\ Hunan";
$areanames{en}->{861331735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861331736} = "Changde\,\ Hunan";
$areanames{en}->{861331737} = "Yiyang\,\ Hunan";
$areanames{en}->{861331738} = "Loudi\,\ Hunan";
$areanames{en}->{861331739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861331740} = "Yueyang\,\ Hunan";
$areanames{en}->{861331741} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861331742} = "Xiangtan\,\ Hunan";
$areanames{en}->{861331743} = "Xiangxi\,\ Hunan";
$areanames{en}->{861331744} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861331745} = "Huaihua\,\ Hunan";
$areanames{en}->{861331746} = "Yongzhou\,\ Hunan";
$areanames{en}->{861331747} = "Hengyang\,\ Hunan";
$areanames{en}->{861331748} = "Changsha\,\ Hunan";
$areanames{en}->{861331749} = "Changsha\,\ Hunan";
$areanames{en}->{861331750} = "Huanggang\,\ Hubei";
$areanames{en}->{861331751} = "Jingmen\,\ Hubei";
$areanames{en}->{861331752} = "Jingmen\,\ Hubei";
$areanames{en}->{861331753} = "Xiangfan\,\ Hubei";
$areanames{en}->{861331754} = "Xiangfan\,\ Hubei";
$areanames{en}->{861331755} = "Xiangfan\,\ Hubei";
$areanames{en}->{861331756} = "Yichang\,\ Hubei";
$areanames{en}->{861331757} = "Yichang\,\ Hubei";
$areanames{en}->{861331758} = "Jingzhou\,\ Hubei";
$areanames{en}->{861331759} = "Suizhou\,\ Hubei";
$areanames{en}->{861331760} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861331761} = "Nanning\,\ Guangxi";
$areanames{en}->{861331762} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861331763} = "Guilin\,\ Guangxi";
$areanames{en}->{861331764} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861331765} = "Yulin\,\ Guangxi";
$areanames{en}->{861331766} = "Baise\,\ Guangxi";
$areanames{en}->{861331767} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861331768} = "Hechi\,\ Guangxi";
$areanames{en}->{861331769} = "Beihai\,\ Guangxi";
$areanames{en}->{861331770} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861331771} = "Nanning\,\ Guangxi";
$areanames{en}->{861331772} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861331773} = "Guilin\,\ Guangxi";
$areanames{en}->{861331774} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861331775} = "Yulin\,\ Guangxi";
$areanames{en}->{861331776} = "Baise\,\ Guangxi";
$areanames{en}->{861331777} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861331778} = "Hechi\,\ Guangxi";
$areanames{en}->{861331779} = "Beihai\,\ Guangxi";
$areanames{en}->{861331780} = "Nanning\,\ Guangxi";
$areanames{en}->{861331781} = "Nanning\,\ Guangxi";
$areanames{en}->{861331782} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861331783} = "Guilin\,\ Guangxi";
$areanames{en}->{861331784} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861331785} = "Yulin\,\ Guangxi";
$areanames{en}->{861331786} = "Nanning\,\ Guangxi";
$areanames{en}->{861331787} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861331788} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861331789} = "Beihai\,\ Guangxi";
$areanames{en}->{861331790} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861331791} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861331792} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861331793} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861331794} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861331795} = "Yichun\,\ Jiangxi";
$areanames{en}->{861331796} = "JiAn\,\ Jiangxi";
$areanames{en}->{861331797} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861331798} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861331799} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{86133180} = "Shantou\,\ Guangdong";
$areanames{en}->{861331801} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861331802} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861331803} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861331804} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861331810} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861331811} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861331812} = "Meizhou\,\ Guangdong";
$areanames{en}->{861331813} = "Meizhou\,\ Guangdong";
$areanames{en}->{861331814} = "Meizhou\,\ Guangdong";
$areanames{en}->{861331815} = "Meizhou\,\ Guangdong";
$areanames{en}->{861331816} = "Meizhou\,\ Guangdong";
$areanames{en}->{861331817} = "Jieyang\,\ Guangdong";
$areanames{en}->{861331818} = "Jieyang\,\ Guangdong";
$areanames{en}->{861331819} = "Jieyang\,\ Guangdong";
$areanames{en}->{861331820} = "Foshan\,\ Guangdong";
$areanames{en}->{861331821} = "Foshan\,\ Guangdong";
$areanames{en}->{861331822} = "Foshan\,\ Guangdong";
$areanames{en}->{861331823} = "Heyuan\,\ Guangdong";
$areanames{en}->{861331824} = "Heyuan\,\ Guangdong";
$areanames{en}->{861331825} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861331826} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861331827} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861331828} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861331829} = "Zhongshan\,\ Guangdong";
$areanames{en}->{86133183} = "Foshan\,\ Guangdong";
$areanames{en}->{861331840} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861331841} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861331842} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861331843} = "Dongguan\,\ Guangdong";
$areanames{en}->{861331844} = "Dongguan\,\ Guangdong";
$areanames{en}->{861331845} = "Dongguan\,\ Guangdong";
$areanames{en}->{861331846} = "Dongguan\,\ Guangdong";
$areanames{en}->{861331847} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331848} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331849} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331850} = "Maoming\,\ Guangdong";
$areanames{en}->{861331851} = "Maoming\,\ Guangdong";
$areanames{en}->{861331852} = "Maoming\,\ Guangdong";
$areanames{en}->{861331853} = "Maoming\,\ Guangdong";
$areanames{en}->{861331854} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861331855} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861331856} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861331857} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861331858} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861331859} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861331860} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861331861} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861331862} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861331863} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861331864} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861331865} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861331866} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861331867} = "Shanwei\,\ Guangdong";
$areanames{en}->{861331868} = "Shanwei\,\ Guangdong";
$areanames{en}->{861331869} = "Shanwei\,\ Guangdong";
$areanames{en}->{86133187} = "Guangzhou\,\ Guangdong";
$areanames{en}->{86133188} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861331890} = "Yunfu\,\ Guangdong";
$areanames{en}->{861331891} = "Yunfu\,\ Guangdong";
$areanames{en}->{861331892} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861331893} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861331894} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331895} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331896} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331897} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331898} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861331899} = "Heyuan\,\ Guangdong";
$areanames{en}->{861331900} = "Changji\,\ Xinjiang";
$areanames{en}->{861331901} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861331902} = "Hami\,\ Xinjiang";
$areanames{en}->{861331903} = "Hotan\,\ Xinjiang";
$areanames{en}->{861331904} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861331905} = "Changji\,\ Xinjiang";
$areanames{en}->{861331906} = "Altay\,\ Xinjiang";
$areanames{en}->{861331907} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861331908} = "Kizilsu\,\ Xinjiang";
$areanames{en}->{861331909} = "Bortala\,\ Xinjiang";
$areanames{en}->{861331910} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861331911} = "YanAn\,\ Shaanxi";
$areanames{en}->{861331912} = "Yulin\,\ Shaanxi";
$areanames{en}->{861331913} = "Weinan\,\ Shaanxi";
$areanames{en}->{861331914} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861331915} = "Ankang\,\ Shaanxi";
$areanames{en}->{861331916} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861331917} = "Baoji\,\ Shaanxi";
$areanames{en}->{861331918} = "XiAn\,\ Shaanxi";
$areanames{en}->{861331919} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{86133192} = "XiAn\,\ Shaanxi";
$areanames{en}->{861331930} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861331931} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861331932} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861331933} = "JiAn\,\ Jiangxi";
$areanames{en}->{861331934} = "Yichun\,\ Jiangxi";
$areanames{en}->{861331935} = "Yichun\,\ Jiangxi";
$areanames{en}->{861331936} = "Yichun\,\ Jiangxi";
$areanames{en}->{861331937} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861331938} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861331939} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861331940} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861331941} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861331942} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861331943} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861331944} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861331945} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861331946} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861331947} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861331948} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861331949} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{86133195} = "Changsha\,\ Hunan";
$areanames{en}->{861331960} = "Changsha\,\ Hunan";
$areanames{en}->{861331961} = "Huaihua\,\ Hunan";
$areanames{en}->{861331962} = "Changde\,\ Hunan";
$areanames{en}->{861331963} = "Xiangxi\,\ Hunan";
$areanames{en}->{861331964} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861331965} = "Huaihua\,\ Hunan";
$areanames{en}->{861331966} = "Yongzhou\,\ Hunan";
$areanames{en}->{861331967} = "Chenzhou\,\ Hunan";
$areanames{en}->{861331968} = "Loudi\,\ Hunan";
$areanames{en}->{861331969} = "Shaoyang\,\ Hunan";
$areanames{en}->{861331970} = "Hami\,\ Xinjiang";
$areanames{en}->{861331971} = "Bortala\,\ Xinjiang";
$areanames{en}->{861331972} = "Ili\,\ Xinjiang";
$areanames{en}->{861331973} = "Ili\,\ Xinjiang";
$areanames{en}->{861331974} = "Ili\,\ Xinjiang";
$areanames{en}->{861331975} = "Tacheng\,\ Xinjiang";
$areanames{en}->{861331976} = "Altay\,\ Xinjiang";
$areanames{en}->{861331977} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861331978} = "Aksu\,\ Xinjiang";
$areanames{en}->{861331979} = "Hotan\,\ Xinjiang";
$areanames{en}->{86133198} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861331990} = "Karamay\,\ Xinjiang";
$areanames{en}->{861331991} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861331992} = "Ili\,\ Xinjiang";
$areanames{en}->{861331993} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861331994} = "Changji\,\ Xinjiang";
$areanames{en}->{861331995} = "Turpan\,\ Xinjiang";
$areanames{en}->{861331996} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861331997} = "Aksu\,\ Xinjiang";
$areanames{en}->{861331998} = "Kashi\,\ Xinjiang";
$areanames{en}->{861331999} = "Ili\,\ Xinjiang";
$areanames{en}->{861332000} = "Xinyu\,\ Jiangxi";
$areanames{en}->{861332001} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861332002} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861332003} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861332004} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861332005} = "Yichun\,\ Jiangxi";
$areanames{en}->{861332006} = "JiAn\,\ Jiangxi";
$areanames{en}->{861332007} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861332008} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861332009} = "Pingxiang\,\ Jiangxi";
$areanames{en}->{861332010} = "Yingtan\,\ Jiangxi";
$areanames{en}->{861332011} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861332012} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861332013} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861332014} = "Jingdezhen\,\ Jiangxi";
$areanames{en}->{861332015} = "Yichun\,\ Jiangxi";
$areanames{en}->{861332016} = "JiAn\,\ Jiangxi";
$areanames{en}->{861332017} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861332018} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{861332019} = "Fuzhou\,\ Jiangxi";
$areanames{en}->{86133202} = "Chongqing";
$areanames{en}->{86133203} = "Chongqing";
$areanames{en}->{861332040} = "Honghe\,\ Yunnan";
$areanames{en}->{861332041} = "Lijiang\,\ Yunnan";
$areanames{en}->{861332042} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861332043} = "Deqen\,\ Yunnan";
$areanames{en}->{861332044} = "Nujiang\,\ Yunnan";
$areanames{en}->{861332045} = "Dehong\,\ Yunnan";
$areanames{en}->{861332046} = "Wenshan\,\ Yunnan";
$areanames{en}->{861332047} = "Puer\,\ Yunnan";
$areanames{en}->{861332048} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861332049} = "Lincang\,\ Yunnan";
$areanames{en}->{861332050} = "Kunming\,\ Yunnan";
$areanames{en}->{861332051} = "Kunming\,\ Yunnan";
$areanames{en}->{861332052} = "Kunming\,\ Yunnan";
$areanames{en}->{861332053} = "Kunming\,\ Yunnan";
$areanames{en}->{861332054} = "Kunming\,\ Yunnan";
$areanames{en}->{861332055} = "Dali\,\ Yunnan";
$areanames{en}->{861332056} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861332057} = "Qujing\,\ Yunnan";
$areanames{en}->{861332058} = "Yuxi\,\ Yunnan";
$areanames{en}->{861332059} = "Baoshan\,\ Yunnan";
$areanames{en}->{861332060} = "YaAn\,\ Sichuan";
$areanames{en}->{861332061} = "Bazhong\,\ Sichuan";
$areanames{en}->{861332062} = "GuangAn\,\ Sichuan";
$areanames{en}->{861332063} = "Suining\,\ Sichuan";
$areanames{en}->{861332064} = "Suining\,\ Sichuan";
$areanames{en}->{861332065} = "Yibin\,\ Sichuan";
$areanames{en}->{861332066} = "Yibin\,\ Sichuan";
$areanames{en}->{861332067} = "Aba\,\ Sichuan";
$areanames{en}->{861332068} = "Ziyang\,\ Sichuan";
$areanames{en}->{861332069} = "Neijiang\,\ Sichuan";
$areanames{en}->{861332070} = "Neijiang\,\ Sichuan";
$areanames{en}->{861332071} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861332072} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861332073} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861332074} = "Luzhou\,\ Sichuan";
$areanames{en}->{861332075} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861332076} = "Nanchong\,\ Sichuan";
$areanames{en}->{861332077} = "Nanchong\,\ Sichuan";
$areanames{en}->{861332078} = "Luzhou\,\ Sichuan";
$areanames{en}->{861332079} = "Garze\,\ Sichuan";
$areanames{en}->{861332080} = "Zigong\,\ Sichuan";
$areanames{en}->{861332081} = "Zigong\,\ Sichuan";
$areanames{en}->{861332082} = "Dazhou\,\ Sichuan";
$areanames{en}->{861332083} = "Dazhou\,\ Sichuan";
$areanames{en}->{861332084} = "Ziyang\,\ Sichuan";
$areanames{en}->{861332085} = "Deyang\,\ Sichuan";
$areanames{en}->{861332086} = "Deyang\,\ Sichuan";
$areanames{en}->{861332087} = "Deyang\,\ Sichuan";
$areanames{en}->{861332088} = "Mianyang\,\ Sichuan";
$areanames{en}->{861332089} = "Mianyang\,\ Sichuan";
$areanames{en}->{861332090} = "Mianyang\,\ Sichuan";
$areanames{en}->{861332091} = "Leshan\,\ Sichuan";
$areanames{en}->{861332092} = "Leshan\,\ Sichuan";
$areanames{en}->{861332093} = "Meishan\,\ Sichuan";
$areanames{en}->{861332094} = "Chengdu\,\ Sichuan";
$areanames{en}->{861332095} = "Meishan\,\ Sichuan";
$areanames{en}->{861332096} = "Chengdu\,\ Sichuan";
$areanames{en}->{861332097} = "Liangshan\,\ Sichuan";
$areanames{en}->{861332098} = "Chengdu\,\ Sichuan";
$areanames{en}->{861332099} = "Chengdu\,\ Sichuan";
$areanames{en}->{86133210} = "Beijing";
$areanames{en}->{86133211} = "Beijing";
$areanames{en}->{861332120} = "Lanzhou\,\ Gansu";
$areanames{en}->{861332121} = "Lanzhou\,\ Gansu";
$areanames{en}->{861332122} = "Lanzhou\,\ Gansu";
$areanames{en}->{861332123} = "Qingyang\,\ Gansu";
$areanames{en}->{861332124} = "Gannan\,\ Gansu";
$areanames{en}->{861332125} = "Jinchang\,\ Gansu";
$areanames{en}->{861332126} = "Jiayuguan\,\ Gansu";
$areanames{en}->{861332127} = "Baiyin\,\ Gansu";
$areanames{en}->{861332128} = "Lanzhou\,\ Gansu";
$areanames{en}->{861332129} = "Jiuquan\,\ Gansu";
$areanames{en}->{861332130} = "Pingliang\,\ Gansu";
$areanames{en}->{861332131} = "Lanzhou\,\ Gansu";
$areanames{en}->{861332132} = "Dingxi\,\ Gansu";
$areanames{en}->{861332133} = "Lanzhou\,\ Gansu";
$areanames{en}->{861332134} = "Linxia\,\ Gansu";
$areanames{en}->{861332135} = "Wuwei\,\ Gansu";
$areanames{en}->{861332136} = "Zhangye\,\ Gansu";
$areanames{en}->{861332137} = "Jiuquan\,\ Gansu";
$areanames{en}->{861332138} = "Tianshui\,\ Gansu";
$areanames{en}->{861332139} = "Longnan\,\ Gansu";
$areanames{en}->{861332140} = "Changchun\,\ Jilin";
$areanames{en}->{861332141} = "Changchun\,\ Jilin";
$areanames{en}->{861332142} = "Jilin\,\ Jilin";
$areanames{en}->{861332143} = "Siping\,\ Jilin";
$areanames{en}->{861332144} = "Yanbian\,\ Jilin";
$areanames{en}->{861332145} = "Tonghua\,\ Jilin";
$areanames{en}->{861332146} = "Baicheng\,\ Jilin";
$areanames{en}->{861332147} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861332148} = "Songyuan\,\ Jilin";
$areanames{en}->{861332149} = "Baishan\,\ Jilin";
$areanames{en}->{861332150} = "Jilin\,\ Jilin";
$areanames{en}->{861332151} = "Yanbian\,\ Jilin";
$areanames{en}->{861332152} = "Songyuan\,\ Jilin";
$areanames{en}->{861332153} = "Tonghua\,\ Jilin";
$areanames{en}->{861332154} = "Changchun\,\ Jilin";
$areanames{en}->{861332155} = "Siping\,\ Jilin";
$areanames{en}->{861332156} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861332157} = "Baicheng\,\ Jilin";
$areanames{en}->{861332158} = "Changchun\,\ Jilin";
$areanames{en}->{861332159} = "Baishan\,\ Jilin";
$areanames{en}->{861332160} = "Nanning\,\ Guangxi";
$areanames{en}->{861332161} = "Nanning\,\ Guangxi";
$areanames{en}->{861332162} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861332163} = "Guilin\,\ Guangxi";
$areanames{en}->{861332164} = "Hezhou\,\ Guangxi";
$areanames{en}->{861332165} = "Yulin\,\ Guangxi";
$areanames{en}->{861332166} = "Nanning\,\ Guangxi";
$areanames{en}->{861332167} = "Guigang\,\ Guangxi";
$areanames{en}->{861332168} = "Guigang\,\ Guangxi";
$areanames{en}->{861332169} = "Beihai\,\ Guangxi";
$areanames{en}->{861332170} = "Nanning\,\ Guangxi";
$areanames{en}->{861332171} = "Nanning\,\ Guangxi";
$areanames{en}->{861332172} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861332173} = "Guilin\,\ Guangxi";
$areanames{en}->{861332174} = "Hezhou\,\ Guangxi";
$areanames{en}->{861332175} = "Yulin\,\ Guangxi";
$areanames{en}->{861332176} = "Baise\,\ Guangxi";
$areanames{en}->{861332177} = "Guigang\,\ Guangxi";
$areanames{en}->{861332178} = "Guigang\,\ Guangxi";
$areanames{en}->{861332179} = "Beihai\,\ Guangxi";
$areanames{en}->{86133218} = "Shanghai";
$areanames{en}->{86133219} = "Shanghai";
$areanames{en}->{86133220} = "Haikou\,\ Hainan";
$areanames{en}->{861332210} = "Anshan\,\ Liaoning";
$areanames{en}->{861332211} = "Anshan\,\ Liaoning";
$areanames{en}->{861332212} = "Fushun\,\ Liaoning";
$areanames{en}->{861332213} = "Fushun\,\ Liaoning";
$areanames{en}->{861332214} = "Benxi\,\ Liaoning";
$areanames{en}->{861332215} = "Benxi\,\ Liaoning";
$areanames{en}->{861332216} = "Dandong\,\ Liaoning";
$areanames{en}->{861332217} = "Dandong\,\ Liaoning";
$areanames{en}->{861332218} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861332219} = "Jinzhou\,\ Liaoning";
$areanames{en}->{86133222} = "Dalian\,\ Liaoning";
$areanames{en}->{861332230} = "Yingkou\,\ Liaoning";
$areanames{en}->{861332231} = "Yingkou\,\ Liaoning";
$areanames{en}->{861332232} = "Fuxin\,\ Liaoning";
$areanames{en}->{861332233} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861332234} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861332235} = "Tieling\,\ Liaoning";
$areanames{en}->{861332236} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861332237} = "Panjin\,\ Liaoning";
$areanames{en}->{861332238} = "Panjin\,\ Liaoning";
$areanames{en}->{861332239} = "Huludao\,\ Liaoning";
$areanames{en}->{86133224} = "Shenyang\,\ Liaoning";
$areanames{en}->{861332250} = "Lhasa\,\ Tibet";
$areanames{en}->{861332251} = "Lhasa\,\ Tibet";
$areanames{en}->{861332252} = "Xigaze\,\ Tibet";
$areanames{en}->{861332253} = "Shannan\,\ Tibet";
$areanames{en}->{861332254} = "Nyingchi\,\ Tibet";
$areanames{en}->{861332255} = "Qamdo\,\ Tibet";
$areanames{en}->{861332256} = "Nagqu\,\ Tibet";
$areanames{en}->{861332257} = "Ngari\,\ Tibet";
$areanames{en}->{861332258} = "Lhasa\,\ Tibet";
$areanames{en}->{861332259} = "Lhasa\,\ Tibet";
$areanames{en}->{861332260} = "Dongguan\,\ Guangdong";
$areanames{en}->{861332261} = "Dongguan\,\ Guangdong";
$areanames{en}->{861332262} = "Huizhou\,\ Guangdong";
$areanames{en}->{861332263} = "Heyuan\,\ Guangdong";
$areanames{en}->{861332264} = "Huizhou\,\ Guangdong";
$areanames{en}->{861332265} = "Meizhou\,\ Guangdong";
$areanames{en}->{861332266} = "Meizhou\,\ Guangdong";
$areanames{en}->{861332267} = "Shanwei\,\ Guangdong";
$areanames{en}->{861332268} = "Shanwei\,\ Guangdong";
$areanames{en}->{861332269} = "Heyuan\,\ Guangdong";
$areanames{en}->{86133227} = "Shantou\,\ Guangdong";
$areanames{en}->{861332275} = "Jieyang\,\ Guangdong";
$areanames{en}->{861332276} = "Jieyang\,\ Guangdong";
$areanames{en}->{861332278} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861332279} = "Chaozhou\,\ Guangdong";
$areanames{en}->{861332280} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861332281} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861332282} = "Foshan\,\ Guangdong";
$areanames{en}->{861332283} = "Foshan\,\ Guangdong";
$areanames{en}->{861332284} = "Foshan\,\ Guangdong";
$areanames{en}->{861332285} = "Foshan\,\ Guangdong";
$areanames{en}->{861332286} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861332287} = "Zhuhai\,\ Guangdong";
$areanames{en}->{861332288} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861332289} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861332290} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861332291} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861332292} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861332293} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861332294} = "Yunfu\,\ Guangdong";
$areanames{en}->{861332295} = "Yunfu\,\ Guangdong";
$areanames{en}->{861332296} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861332297} = "Zhaoqing\,\ Guangdong";
$areanames{en}->{861332298} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861332299} = "Shenzhen\,\ Guangdong";
$areanames{en}->{861332300} = "Handan\,\ Hebei";
$areanames{en}->{861332301} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861332302} = "Baoding\,\ Hebei";
$areanames{en}->{861332303} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861332304} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861332305} = "Tangshan\,\ Hebei";
$areanames{en}->{861332306} = "Langfang\,\ Hebei";
$areanames{en}->{861332307} = "Cangzhou\,\ Hebei";
$areanames{en}->{861332308} = "Hengshui\,\ Hebei";
$areanames{en}->{861332309} = "Xingtai\,\ Hebei";
$areanames{en}->{861332310} = "Handan\,\ Hebei";
$areanames{en}->{861332311} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861332312} = "Baoding\,\ Hebei";
$areanames{en}->{861332313} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861332314} = "Chengde\,\ Hebei";
$areanames{en}->{861332315} = "Tangshan\,\ Hebei";
$areanames{en}->{861332316} = "Langfang\,\ Hebei";
$areanames{en}->{861332317} = "Cangzhou\,\ Hebei";
$areanames{en}->{861332318} = "Hengshui\,\ Hebei";
$areanames{en}->{861332319} = "Xingtai\,\ Hebei";
$areanames{en}->{861332320} = "Handan\,\ Hebei";
$areanames{en}->{861332321} = "Shijiazhuang\,\ Hebei";
$areanames{en}->{861332322} = "Baoding\,\ Hebei";
$areanames{en}->{861332323} = "Zhangjiakou\,\ Hebei";
$areanames{en}->{861332324} = "Baoding\,\ Hebei";
$areanames{en}->{861332325} = "Tangshan\,\ Hebei";
$areanames{en}->{861332326} = "Langfang\,\ Hebei";
$areanames{en}->{861332327} = "Cangzhou\,\ Hebei";
$areanames{en}->{861332328} = "Qinhuangdao\,\ Hebei";
$areanames{en}->{861332329} = "Tangshan\,\ Hebei";
$areanames{en}->{86133233} = "Tianjin";
$areanames{en}->{86133234} = "Tianjin";
$areanames{en}->{861332350} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861332351} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861332352} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861332353} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861332354} = "Guyuan\,\ Ningxia";
$areanames{en}->{861332355} = "Wuzhong\,\ Ningxia";
$areanames{en}->{861332356} = "Shizuishan\,\ Ningxia";
$areanames{en}->{861332357} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861332358} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861332359} = "Yinchuan\,\ Ningxia";
$areanames{en}->{861332360} = "Shangqiu\,\ Henan";
$areanames{en}->{861332361} = "Hebi\,\ Henan";
$areanames{en}->{861332362} = "Anyang\,\ Henan";
$areanames{en}->{861332363} = "Puyang\,\ Henan";
$areanames{en}->{861332364} = "Zhumadian\,\ Henan";
$areanames{en}->{861332365} = "Kaifeng\,\ Henan";
$areanames{en}->{861332366} = "Sanmenxia\,\ Henan";
$areanames{en}->{861332367} = "Luohe\,\ Henan";
$areanames{en}->{861332368} = "Nanyang\,\ Henan";
$areanames{en}->{861332369} = "Nanyang\,\ Henan";
$areanames{en}->{861332370} = "Shangqiu\,\ Henan";
$areanames{en}->{861332371} = "Zhengzhou\,\ Henan";
$areanames{en}->{861332372} = "Anyang\,\ Henan";
$areanames{en}->{861332373} = "Xinxiang\,\ Henan";
$areanames{en}->{861332374} = "Xuchang\,\ Henan";
$areanames{en}->{861332375} = "Pingdingshan\,\ Henan";
$areanames{en}->{861332376} = "Xinyang\,\ Henan";
$areanames{en}->{861332377} = "Nanyang\,\ Henan";
$areanames{en}->{861332378} = "Kaifeng\,\ Henan";
$areanames{en}->{861332379} = "Luoyang\,\ Henan";
$areanames{en}->{86133238} = "Zhengzhou\,\ Henan";
$areanames{en}->{861332380} = "Xinxiang\,\ Henan";
$areanames{en}->{861332387} = "Zhoukou\,\ Henan";
$areanames{en}->{861332388} = "Luoyang\,\ Henan";
$areanames{en}->{861332389} = "Jiaozuo\,\ Henan";
$areanames{en}->{861332390} = "Pingdingshan\,\ Henan";
$areanames{en}->{861332391} = "Jiaozuo\,\ Henan";
$areanames{en}->{861332392} = "Hebi\,\ Henan";
$areanames{en}->{861332393} = "Puyang\,\ Henan";
$areanames{en}->{861332394} = "Zhoukou\,\ Henan";
$areanames{en}->{861332395} = "Luohe\,\ Henan";
$areanames{en}->{861332396} = "Zhumadian\,\ Henan";
$areanames{en}->{861332397} = "Xinyang\,\ Henan";
$areanames{en}->{861332398} = "Sanmenxia\,\ Henan";
$areanames{en}->{861332399} = "Xuchang\,\ Henan";
$areanames{en}->{86133240} = "Shenyang\,\ Liaoning";
$areanames{en}->{861332410} = "Tieling\,\ Liaoning";
$areanames{en}->{861332411} = "Dalian\,\ Liaoning";
$areanames{en}->{861332412} = "Anshan\,\ Liaoning";
$areanames{en}->{861332413} = "Fushun\,\ Liaoning";
$areanames{en}->{861332414} = "Benxi\,\ Liaoning";
$areanames{en}->{861332415} = "Dandong\,\ Liaoning";
$areanames{en}->{861332416} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861332417} = "Yingkou\,\ Liaoning";
$areanames{en}->{861332418} = "Fuxin\,\ Liaoning";
$areanames{en}->{861332419} = "Liaoyang\,\ Liaoning";
$areanames{en}->{861332420} = "Dalian\,\ Liaoning";
$areanames{en}->{861332421} = "Chaoyang\,\ Liaoning";
$areanames{en}->{861332422} = "Anshan\,\ Liaoning";
$areanames{en}->{861332423} = "Fushun\,\ Liaoning";
$areanames{en}->{861332424} = "Benxi\,\ Liaoning";
$areanames{en}->{861332425} = "Panjin\,\ Liaoning";
$areanames{en}->{861332426} = "Jinzhou\,\ Liaoning";
$areanames{en}->{861332427} = "Panjin\,\ Liaoning";
$areanames{en}->{861332428} = "Dandong\,\ Liaoning";
$areanames{en}->{861332429} = "Huludao\,\ Liaoning";
$areanames{en}->{861332430} = "Changchun\,\ Jilin";
$areanames{en}->{861332431} = "Changchun\,\ Jilin";
$areanames{en}->{861332432} = "Jilin\,\ Jilin";
$areanames{en}->{861332433} = "Yanbian\,\ Jilin";
$areanames{en}->{861332434} = "Siping\,\ Jilin";
$areanames{en}->{861332435} = "Tonghua\,\ Jilin";
$areanames{en}->{861332436} = "Baicheng\,\ Jilin";
$areanames{en}->{861332437} = "Liaoyuan\,\ Jilin";
$areanames{en}->{861332438} = "Songyuan\,\ Jilin";
$areanames{en}->{861332439} = "Baishan\,\ Jilin";
$areanames{en}->{861332440} = "Jilin\,\ Jilin";
$areanames{en}->{861332441} = "Jilin\,\ Jilin";
$areanames{en}->{861332442} = "Jilin\,\ Jilin";
$areanames{en}->{861332443} = "Yanbian\,\ Jilin";
$areanames{en}->{861332444} = "Jilin\,\ Jilin";
$areanames{en}->{861332445} = "Tonghua\,\ Jilin";
$areanames{en}->{861332446} = "Changchun\,\ Jilin";
$areanames{en}->{861332447} = "Changchun\,\ Jilin";
$areanames{en}->{861332448} = "Yanbian\,\ Jilin";
$areanames{en}->{861332449} = "Baishan\,\ Jilin";
$areanames{en}->{86133245} = "XiAn\,\ Shaanxi";
$areanames{en}->{861332460} = "Yulin\,\ Shaanxi";
$areanames{en}->{861332461} = "Yulin\,\ Shaanxi";
$areanames{en}->{861332462} = "Yulin\,\ Shaanxi";
$areanames{en}->{861332463} = "Ankang\,\ Shaanxi";
$areanames{en}->{861332464} = "Ankang\,\ Shaanxi";
$areanames{en}->{861332465} = "Ankang\,\ Shaanxi";
$areanames{en}->{861332466} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861332467} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861332468} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861332469} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861332470} = "Fangchenggang\,\ Guangxi";
$areanames{en}->{861332471} = "Nanning\,\ Guangxi";
$areanames{en}->{861332472} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861332473} = "Guilin\,\ Guangxi";
$areanames{en}->{861332474} = "Hezhou\,\ Guangxi";
$areanames{en}->{861332475} = "Guigang\,\ Guangxi";
$areanames{en}->{861332476} = "Baise\,\ Guangxi";
$areanames{en}->{861332477} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861332478} = "Hechi\,\ Guangxi";
$areanames{en}->{861332479} = "Beihai\,\ Guangxi";
$areanames{en}->{861332480} = "Hezhou\,\ Guangxi";
$areanames{en}->{861332481} = "Nanning\,\ Guangxi";
$areanames{en}->{861332482} = "Liuzhou\,\ Guangxi";
$areanames{en}->{861332483} = "Guilin\,\ Guangxi";
$areanames{en}->{861332484} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861332485} = "Yulin\,\ Guangxi";
$areanames{en}->{861332486} = "Guigang\,\ Guangxi";
$areanames{en}->{861332487} = "Qinzhou\,\ Guangxi";
$areanames{en}->{861332488} = "Wuzhou\,\ Guangxi";
$areanames{en}->{861332489} = "Beihai\,\ Guangxi";
$areanames{en}->{861332490} = "Qujing\,\ Yunnan";
$areanames{en}->{861332491} = "Qujing\,\ Yunnan";
$areanames{en}->{861332492} = "Honghe\,\ Yunnan";
$areanames{en}->{861332493} = "Honghe\,\ Yunnan";
$areanames{en}->{861332494} = "Dali\,\ Yunnan";
$areanames{en}->{861332495} = "Dali\,\ Yunnan";
$areanames{en}->{861332496} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861332497} = "Dehong\,\ Yunnan";
$areanames{en}->{861332498} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861332499} = "Puer\,\ Yunnan";
$areanames{en}->{861332500} = "Qingdao\,\ Shandong";
$areanames{en}->{861332501} = "Qingdao\,\ Shandong";
$areanames{en}->{861332502} = "Qingdao\,\ Shandong";
$areanames{en}->{861332503} = "Dongying\,\ Shandong";
$areanames{en}->{861332504} = "Dongying\,\ Shandong";
$areanames{en}->{861332505} = "Dongying\,\ Shandong";
$areanames{en}->{861332506} = "Dongying\,\ Shandong";
$areanames{en}->{861332507} = "Linyi\,\ Shandong";
$areanames{en}->{861332508} = "Linyi\,\ Shandong";
$areanames{en}->{861332509} = "Linyi\,\ Shandong";
$areanames{en}->{861332510} = "Jinan\,\ Shandong";
$areanames{en}->{861332511} = "Jinan\,\ Shandong";
$areanames{en}->{861332512} = "Jinan\,\ Shandong";
$areanames{en}->{861332513} = "Jinan\,\ Shandong";
$areanames{en}->{861332514} = "Yantai\,\ Shandong";
$areanames{en}->{861332515} = "Yantai\,\ Shandong";
$areanames{en}->{861332516} = "Yantai\,\ Shandong";
$areanames{en}->{861332517} = "Jining\,\ Shandong";
$areanames{en}->{861332518} = "Jining\,\ Shandong";
$areanames{en}->{861332519} = "Jining\,\ Shandong";
$areanames{en}->{861332520} = "Zibo\,\ Shandong";
$areanames{en}->{861332521} = "Zibo\,\ Shandong";
$areanames{en}->{861332522} = "Zibo\,\ Shandong";
$areanames{en}->{861332523} = "Zibo\,\ Shandong";
$areanames{en}->{861332524} = "Weifang\,\ Shandong";
$areanames{en}->{861332525} = "Weifang\,\ Shandong";
$areanames{en}->{861332526} = "Weifang\,\ Shandong";
$areanames{en}->{861332527} = "TaiAn\,\ Shandong";
$areanames{en}->{861332528} = "TaiAn\,\ Shandong";
$areanames{en}->{861332529} = "TaiAn\,\ Shandong";
$areanames{en}->{861332530} = "Xianyang\,\ Shaanxi";
$areanames{en}->{861332531} = "YanAn\,\ Shaanxi";
$areanames{en}->{861332532} = "Yulin\,\ Shaanxi";
$areanames{en}->{861332533} = "Weinan\,\ Shaanxi";
$areanames{en}->{861332534} = "Shangluo\,\ Shaanxi";
$areanames{en}->{861332535} = "Ankang\,\ Shaanxi";
$areanames{en}->{861332536} = "Hanzhong\,\ Shaanxi";
$areanames{en}->{861332537} = "Baoji\,\ Shaanxi";
$areanames{en}->{861332538} = "XiAn\,\ Shaanxi";
$areanames{en}->{861332539} = "Tongchuan\,\ Shaanxi";
$areanames{en}->{861332540} = "Yulin\,\ Shaanxi";
$areanames{en}->{861332541} = "Yulin\,\ Shaanxi";
$areanames{en}->{861332542} = "Yulin\,\ Shaanxi";
$areanames{en}->{861332543} = "Weinan\,\ Shaanxi";
$areanames{en}->{861332544} = "Weinan\,\ Shaanxi";
$areanames{en}->{861332545} = "XiAn\,\ Shaanxi";
$areanames{en}->{861332546} = "XiAn\,\ Shaanxi";
$areanames{en}->{861332547} = "XiAn\,\ Shaanxi";
$areanames{en}->{861332548} = "XiAn\,\ Shaanxi";
$areanames{en}->{861332549} = "XiAn\,\ Shaanxi";
$areanames{en}->{86133255} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861332550} = "Bayingolin\,\ Xinjiang";
$areanames{en}->{861332551} = "Aksu\,\ Xinjiang";
$areanames{en}->{861332552} = "Kashi\,\ Xinjiang";
$areanames{en}->{861332560} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861332561} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861332562} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861332563} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861332564} = "Urumchi\,\ Xinjiang";
$areanames{en}->{861332565} = "Ili\,\ Xinjiang";
$areanames{en}->{861332566} = "Shihezi\,\ Xinjiang";
$areanames{en}->{861332567} = "Karamay\,\ Xinjiang";
$areanames{en}->{861332568} = "Karamay\,\ Xinjiang";
$areanames{en}->{861332569} = "Ili\,\ Xinjiang";
$areanames{en}->{861332570} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861332571} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861332572} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861332573} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861332574} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861332575} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861332576} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861332577} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861332578} = "Lishui\,\ Zhejiang";
$areanames{en}->{861332579} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861332580} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861332581} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861332582} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861332583} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861332584} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861332585} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861332586} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861332587} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861332588} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861332589} = "Jinhua\,\ Zhejiang";
$areanames{en}->{861332590} = "Zhoushan\,\ Zhejiang";
$areanames{en}->{861332591} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861332592} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861332593} = "Jiaxing\,\ Zhejiang";
$areanames{en}->{861332594} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861332595} = "Shaoxing\,\ Zhejiang";
$areanames{en}->{861332596} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861332597} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861332598} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861332599} = "Jinhua\,\ Zhejiang";
$areanames{en}->{86133260} = "Taizhou\,\ Zhejiang";
$areanames{en}->{861332610} = "Quzhou\,\ Zhejiang";
$areanames{en}->{861332611} = "Lishui\,\ Zhejiang";
$areanames{en}->{861332612} = "Ningbo\,\ Zhejiang";
$areanames{en}->{861332613} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861332614} = "Hangzhou\,\ Zhejiang";
$areanames{en}->{861332615} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861332616} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861332617} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861332618} = "Huzhou\,\ Zhejiang";
$areanames{en}->{861332619} = "Wenzhou\,\ Zhejiang";
$areanames{en}->{861332620} = "Heze\,\ Shandong";
$areanames{en}->{861332621} = "Heze\,\ Shandong";
$areanames{en}->{861332622} = "Laiwu\,\ Shandong";
$areanames{en}->{861332623} = "Rizhao\,\ Shandong";
$areanames{en}->{861332624} = "Weihai\,\ Shandong";
$areanames{en}->{861332625} = "Liaocheng\,\ Shandong";
$areanames{en}->{861332626} = "Dezhou\,\ Shandong";
$areanames{en}->{861332627} = "Dezhou\,\ Shandong";
$areanames{en}->{861332628} = "Binzhou\,\ Shandong";
$areanames{en}->{861332629} = "Binzhou\,\ Shandong";
$areanames{en}->{861332630} = "Weihai\,\ Shandong";
$areanames{en}->{861332631} = "Weihai\,\ Shandong";
$areanames{en}->{861332632} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861332633} = "Rizhao\,\ Shandong";
$areanames{en}->{861332634} = "Laiwu\,\ Shandong";
$areanames{en}->{861332635} = "Liaocheng\,\ Shandong";
$areanames{en}->{861332636} = "Weifang\,\ Shandong";
$areanames{en}->{861332637} = "Zaozhuang\,\ Shandong";
$areanames{en}->{861332638} = "Yantai\,\ Shandong";
$areanames{en}->{861332639} = "Qingdao\,\ Shandong";
$areanames{en}->{86133264} = "Guangzhou\,\ Guangdong";
$areanames{en}->{861332650} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861332651} = "Zhanjiang\,\ Guangdong";
$areanames{en}->{861332652} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861332653} = "Shaoguan\,\ Guangdong";
$areanames{en}->{861332654} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861332655} = "Qingyuan\,\ Guangdong";
$areanames{en}->{861332656} = "Maoming\,\ Guangdong";
$areanames{en}->{861332657} = "Maoming\,\ Guangdong";
$areanames{en}->{861332658} = "Yangjiang\,\ Guangdong";
$areanames{en}->{861332659} = "Yangjiang\,\ Guangdong";
$areanames{en}->{86133266} = "Zhuhai\,\ Guangdong";
$areanames{en}->{86133267} = "Foshan\,\ Guangdong";
$areanames{en}->{861332680} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861332681} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861332682} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861332683} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861332684} = "Jiangmen\,\ Guangdong";
$areanames{en}->{861332685} = "Dongguan\,\ Guangdong";
$areanames{en}->{861332686} = "Dongguan\,\ Guangdong";
$areanames{en}->{861332687} = "Dongguan\,\ Guangdong";
$areanames{en}->{861332688} = "Dongguan\,\ Guangdong";
$areanames{en}->{861332689} = "Dongguan\,\ Guangdong";
$areanames{en}->{86133269} = "Zhongshan\,\ Guangdong";
$areanames{en}->{861332700} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861332701} = "Hulun\,\ Inner\ Mongolia";
$areanames{en}->{861332702} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861332703} = "Wuhai\,\ Inner\ Mongolia";
$areanames{en}->{861332704} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861332705} = "Tongliao\,\ Inner\ Mongolia";
$areanames{en}->{861332706} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861332707} = "Ordos\,\ Inner\ Mongolia";
$areanames{en}->{861332708} = "Bayannur\,\ Inner\ Mongolia";
$areanames{en}->{861332709} = "Xilin\,\ Inner\ Mongolia";
$areanames{en}->{861332710} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861332711} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861332712} = "Hohhot\,\ Inner\ Mongolia";
$areanames{en}->{861332713} = "Alxa\,\ Inner\ Mongolia";
$areanames{en}->{861332714} = "Hinggan\,\ Inner\ Mongolia";
$areanames{en}->{861332715} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861332716} = "Chifeng\,\ Inner\ Mongolia";
$areanames{en}->{861332717} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861332718} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861332719} = "Baotou\,\ Inner\ Mongolia";
$areanames{en}->{861332720} = "Yueyang\,\ Hunan";
$areanames{en}->{861332721} = "Changsha\,\ Hunan";
$areanames{en}->{861332722} = "Xiangtan\,\ Hunan";
$areanames{en}->{861332723} = "Xiangxi\,\ Hunan";
$areanames{en}->{861332724} = "Zhangjiajie\,\ Hunan";
$areanames{en}->{861332725} = "Huaihua\,\ Hunan";
$areanames{en}->{861332726} = "Yongzhou\,\ Hunan";
$areanames{en}->{861332727} = "Yiyang\,\ Hunan";
$areanames{en}->{861332728} = "Loudi\,\ Hunan";
$areanames{en}->{861332729} = "Shaoyang\,\ Hunan";
$areanames{en}->{861332730} = "Yueyang\,\ Hunan";
$areanames{en}->{861332731} = "Changsha\,\ Hunan";
$areanames{en}->{861332732} = "Xiangtan\,\ Hunan";
$areanames{en}->{861332733} = "Zhuzhou\,\ Hunan";
$areanames{en}->{861332734} = "Hengyang\,\ Hunan";
$areanames{en}->{861332735} = "Chenzhou\,\ Hunan";
$areanames{en}->{861332736} = "Changde\,\ Hunan";
$areanames{en}->{861332737} = "Yiyang\,\ Hunan";
$areanames{en}->{861332738} = "Loudi\,\ Hunan";
$areanames{en}->{861332739} = "Shaoyang\,\ Hunan";
$areanames{en}->{861332740} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861332741} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861332742} = "Datong\,\ Shanxi";
$areanames{en}->{861332743} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861332744} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861332745} = "Changzhi\,\ Shanxi";
$areanames{en}->{861332746} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861332747} = "Linfen\,\ Shanxi";
$areanames{en}->{861332748} = "Yuncheng\,\ Shanxi";
$areanames{en}->{861332749} = "Shuozhou\,\ Shanxi";
$areanames{en}->{861332750} = "Xinzhou\,\ Shanxi";
$areanames{en}->{861332751} = "Taiyuan\,\ Shanxi";
$areanames{en}->{861332752} = "Datong\,\ Shanxi";
$areanames{en}->{861332753} = "Yangquan\,\ Shanxi";
$areanames{en}->{861332754} = "Jinzhong\,\ Shanxi";
$areanames{en}->{861332755} = "Changzhi\,\ Shanxi";
$areanames{en}->{861332756} = "Jincheng\,\ Shanxi";
$areanames{en}->{861332757} = "Linfen\,\ Shanxi";
$areanames{en}->{861332758} = "Lüliang\,\ Shanxi";
$areanames{en}->{861332759} = "Yuncheng\,\ Shanxi";
$areanames{en}->{86133276} = "Xining\,\ Qinghai";
$areanames{en}->{861332760} = "Haixi\,\ Qinghai";
$areanames{en}->{861332761} = "Haixi\,\ Qinghai";
$areanames{en}->{861332762} = "Haidong\,\ Qinghai";
$areanames{en}->{861332770} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332771} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332772} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332773} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332774} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861332775} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861332776} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861332777} = "Zhenjiang\,\ Jiangsu";
$areanames{en}->{861332778} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861332779} = "Taizhou\,\ Jiangsu";
$areanames{en}->{861332780} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332781} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332782} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332783} = "Nanjing\,\ Jiangsu";
$areanames{en}->{861332784} = "Suqian\,\ Jiangsu";
$areanames{en}->{861332785} = "Suqian\,\ Jiangsu";
$areanames{en}->{861332786} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861332787} = "Lianyungang\,\ Jiangsu";
$areanames{en}->{861332788} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861332789} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861332790} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861332791} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861332792} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861332793} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861332794} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861332795} = "Xuzhou\,\ Jiangsu";
$areanames{en}->{861332796} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861332797} = "HuaiAn\,\ Jiangsu";
$areanames{en}->{861332798} = "Yancheng\,\ Jiangsu";
$areanames{en}->{861332799} = "Yancheng\,\ Jiangsu";
$areanames{en}->{86133280} = "Suzhou\,\ Jiangsu";
$areanames{en}->{861332806} = "Nantong\,\ Jiangsu";
$areanames{en}->{861332807} = "Nantong\,\ Jiangsu";
$areanames{en}->{861332808} = "Nantong\,\ Jiangsu";
$areanames{en}->{861332809} = "Nantong\,\ Jiangsu";
$areanames{en}->{861332810} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861332811} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861332812} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861332813} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861332814} = "Yangzhou\,\ Jiangsu";
$areanames{en}->{861332815} = "Wuxi\,\ Jiangsu";
$areanames{en}->{861332816} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861332817} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861332818} = "Changzhou\,\ Jiangsu";
$areanames{en}->{861332819} = "Changzhou\,\ Jiangsu";
$areanames{en}->{86133282} = "Fuzhou\,\ Fujian";
$areanames{en}->{861332828} = "Ningde\,\ Fujian";
$areanames{en}->{861332829} = "Ningde\,\ Fujian";
$areanames{en}->{861332830} = "Xiamen\,\ Fujian";
$areanames{en}->{861332831} = "Xiamen\,\ Fujian";
$areanames{en}->{861332832} = "Xiamen\,\ Fujian";
$areanames{en}->{861332833} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332834} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332835} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332836} = "Putian\,\ Fujian";
$areanames{en}->{861332837} = "Putian\,\ Fujian";
$areanames{en}->{861332838} = "Nanping\,\ Fujian";
$areanames{en}->{861332839} = "Nanping\,\ Fujian";
$areanames{en}->{861332840} = "Xiamen\,\ Fujian";
$areanames{en}->{861332841} = "Xiamen\,\ Fujian";
$areanames{en}->{861332842} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332843} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332844} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332845} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332846} = "Fuzhou\,\ Fujian";
$areanames{en}->{861332847} = "Fuzhou\,\ Fujian";
$areanames{en}->{861332848} = "Longyan\,\ Fujian";
$areanames{en}->{861332849} = "Longyan\,\ Fujian";
$areanames{en}->{86133285} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332858} = "Sanming\,\ Fujian";
$areanames{en}->{861332859} = "Sanming\,\ Fujian";
$areanames{en}->{86133286} = "Fuzhou\,\ Fujian";
$areanames{en}->{861332860} = "Nanping\,\ Fujian";
$areanames{en}->{861332861} = "Nanping\,\ Fujian";
$areanames{en}->{861332862} = "Nanping\,\ Fujian";
$areanames{en}->{861332863} = "Longyan\,\ Fujian";
$areanames{en}->{861332870} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332871} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332872} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332873} = "Longyan\,\ Fujian";
$areanames{en}->{861332874} = "Longyan\,\ Fujian";
$areanames{en}->{861332875} = "Xiamen\,\ Fujian";
$areanames{en}->{861332876} = "Xiamen\,\ Fujian";
$areanames{en}->{861332877} = "Xiamen\,\ Fujian";
$areanames{en}->{861332878} = "Xiamen\,\ Fujian";
$areanames{en}->{861332879} = "Xiamen\,\ Fujian";
$areanames{en}->{861332880} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332881} = "Zhangzhou\,\ Fujian";
$areanames{en}->{861332882} = "Putian\,\ Fujian";
$areanames{en}->{861332883} = "Putian\,\ Fujian";
$areanames{en}->{861332884} = "Putian\,\ Fujian";
$areanames{en}->{861332885} = "Fuzhou\,\ Fujian";
$areanames{en}->{861332886} = "Fuzhou\,\ Fujian";
$areanames{en}->{861332887} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332888} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332889} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332890} = "Sanming\,\ Fujian";
$areanames{en}->{861332891} = "Sanming\,\ Fujian";
$areanames{en}->{861332892} = "Sanming\,\ Fujian";
$areanames{en}->{861332893} = "Ningde\,\ Fujian";
$areanames{en}->{861332894} = "Ningde\,\ Fujian";
$areanames{en}->{861332895} = "Ningde\,\ Fujian";
$areanames{en}->{861332896} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332897} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332898} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332899} = "Quanzhou\,\ Fujian";
$areanames{en}->{861332900} = "Chuzhou\,\ Anhui";
$areanames{en}->{861332901} = "Hefei\,\ Anhui";
$areanames{en}->{861332902} = "Bengbu\,\ Anhui";
$areanames{en}->{861332903} = "Wuhu\,\ Anhui";
$areanames{en}->{861332904} = "Hefei\,\ Anhui";
$areanames{en}->{861332905} = "MaAnshan\,\ Anhui";
$areanames{en}->{861332906} = "Anqing\,\ Anhui";
$areanames{en}->{861332907} = "Suzhou\,\ Anhui";
$areanames{en}->{861332908} = "Fuyang\,\ Anhui";
$areanames{en}->{861332909} = "Huangshan\,\ Anhui";
$areanames{en}->{861332910} = "Huainan\,\ Anhui";
$areanames{en}->{861332911} = "Huaibei\,\ Anhui";
$areanames{en}->{861332912} = "Tongling\,\ Anhui";
$areanames{en}->{861332913} = "Xuancheng\,\ Anhui";
$areanames{en}->{861332914} = "Wuhu\,\ Anhui";
$areanames{en}->{861332915} = "Chaohu\,\ Anhui";
$areanames{en}->{861332916} = "Chizhou\,\ Anhui";
$areanames{en}->{861332917} = "Suzhou\,\ Anhui";
$areanames{en}->{861332918} = "MaAnshan\,\ Anhui";
$areanames{en}->{861332919} = "LuAn\,\ Anhui";
$areanames{en}->{861332920} = "Chuzhou\,\ Anhui";
$areanames{en}->{861332921} = "Huaibei\,\ Anhui";
$areanames{en}->{861332922} = "Bengbu\,\ Anhui";
$areanames{en}->{861332923} = "LuAn\,\ Anhui";
$areanames{en}->{861332924} = "Fuyang\,\ Anhui";
$areanames{en}->{861332925} = "Chaohu\,\ Anhui";
$areanames{en}->{861332926} = "Anqing\,\ Anhui";
$areanames{en}->{861332927} = "Bozhou\,\ Anhui";
$areanames{en}->{861332928} = "Huainan\,\ Anhui";
$areanames{en}->{861332929} = "Xuancheng\,\ Anhui";
$areanames{en}->{861332930} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861332931} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861332932} = "Qitaihe\,\ Heilongjiang";
$areanames{en}->{861332933} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861332934} = "Shuangyashan\,\ Heilongjiang";
$areanames{en}->{861332935} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861332936} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861332937} = "Da\ Hinggan\ Ling\,\ Heilongjiang";
$areanames{en}->{861332938} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861332939} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861332940} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861332941} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861332942} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861332943} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861332944} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861332945} = "Suihua\,\ Heilongjiang";
$areanames{en}->{861332946} = "Heihe\,\ Heilongjiang";
$areanames{en}->{861332947} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861332948} = "Yichun\,\ Heilongjiang";
$areanames{en}->{861332949} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861332950} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861332951} = "Harbin\,\ Heilongjiang";
$areanames{en}->{861332952} = "Qiqihar\,\ Heilongjiang";
$areanames{en}->{861332953} = "Mudanjiang\,\ Heilongjiang";
$areanames{en}->{861332954} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861332955} = "Jiamusi\,\ Heilongjiang";
$areanames{en}->{861332956} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861332957} = "Jixi\,\ Heilongjiang";
$areanames{en}->{861332958} = "Hegang\,\ Heilongjiang";
$areanames{en}->{861332959} = "Daqing\,\ Heilongjiang";
$areanames{en}->{861332960} = "Guiyang\,\ Guizhou";
$areanames{en}->{861332961} = "Guiyang\,\ Guizhou";
$areanames{en}->{861332962} = "Zunyi\,\ Guizhou";
$areanames{en}->{861332963} = "Anshun\,\ Guizhou";
$areanames{en}->{861332964} = "Qiannan\,\ Guizhou";
$areanames{en}->{861332965} = "Qiandongnan\,\ Guizhou";
$areanames{en}->{861332966} = "Tongren\,\ Guizhou";
$areanames{en}->{861332967} = "Bijie\,\ Guizhou";
$areanames{en}->{861332968} = "Liupanshui\,\ Guizhou";
$areanames{en}->{861332969} = "Qianxinan\,\ Guizhou";
$areanames{en}->{861332970} = "Wuhan\,\ Hubei";
$areanames{en}->{861332971} = "Wuhan\,\ Hubei";
$areanames{en}->{861332972} = "Wuhan\,\ Hubei";
$areanames{en}->{861332973} = "Wuhan\,\ Hubei";
$areanames{en}->{861332974} = "Xiantao\,\ Hubei";
$areanames{en}->{861332975} = "Xiantao\,\ Hubei";
$areanames{en}->{861332976} = "Jingzhou\,\ Hubei";
$areanames{en}->{861332977} = "Jingzhou\,\ Hubei";
$areanames{en}->{861332978} = "Jingmen\,\ Hubei";
$areanames{en}->{861332979} = "Jingmen\,\ Hubei";
$areanames{en}->{861332980} = "Yichang\,\ Hubei";
$areanames{en}->{861332981} = "Yichang\,\ Hubei";
$areanames{en}->{861332982} = "Enshi\,\ Hubei";
$areanames{en}->{861332983} = "Enshi\,\ Hubei";
$areanames{en}->{861332984} = "Shiyan\,\ Hubei";
$areanames{en}->{861332985} = "Shiyan\,\ Hubei";
$areanames{en}->{861332986} = "Xiangfan\,\ Hubei";
$areanames{en}->{861332987} = "Xiangfan\,\ Hubei";
$areanames{en}->{861332988} = "Suizhou\,\ Hubei";
$areanames{en}->{861332989} = "Suizhou\,\ Hubei";
$areanames{en}->{861332990} = "Xiaogan\,\ Hubei";
$areanames{en}->{861332991} = "Xiaogan\,\ Hubei";
$areanames{en}->{861332992} = "Huangshi\,\ Hubei";
$areanames{en}->{861332993} = "Huangshi\,\ Hubei";
$areanames{en}->{861332994} = "Huanggang\,\ Hubei";
$areanames{en}->{861332995} = "Huanggang\,\ Hubei";
$areanames{en}->{861332996} = "Ezhou\,\ Hubei";
$areanames{en}->{861332997} = "Ezhou\,\ Hubei";
$areanames{en}->{861332998} = "Xianning\,\ Hubei";
$areanames{en}->{861332999} = "Xianning\,\ Hubei";
$areanames{en}->{861333000} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861333001} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861333002} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861333003} = "Jiujiang\,\ Jiangxi";
$areanames{en}->{861333004} = "Shangrao\,\ Jiangxi";
$areanames{en}->{861333005} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861333006} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861333007} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861333008} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861333009} = "Nanchang\,\ Jiangxi";
$areanames{en}->{86133301} = "Ganzhou\,\ Jiangxi";
$areanames{en}->{861333010} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861333011} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861333012} = "Nanchang\,\ Jiangxi";
$areanames{en}->{861333019} = "Yichun\,\ Jiangxi";
$areanames{en}->{86133302} = "Chongqing";
$areanames{en}->{86133303} = "Chongqing";
$areanames{en}->{861333040} = "Honghe\,\ Yunnan";
$areanames{en}->{861333041} = "Kunming\,\ Yunnan";
$areanames{en}->{861333042} = "Zhaotong\,\ Yunnan";
$areanames{en}->{861333043} = "Kunming\,\ Yunnan";
$areanames{en}->{861333044} = "Kunming\,\ Yunnan";
$areanames{en}->{861333045} = "Dehong\,\ Yunnan";
$areanames{en}->{861333046} = "Kunming\,\ Yunnan";
$areanames{en}->{861333047} = "Puer\,\ Yunnan";
$areanames{en}->{861333048} = "Xishuangbanna\,\ Yunnan";
$areanames{en}->{861333049} = "Kunming\,\ Yunnan";
$areanames{en}->{861333050} = "Kunming\,\ Yunnan";
$areanames{en}->{861333051} = "Kunming\,\ Yunnan";
$areanames{en}->{861333052} = "Kunming\,\ Yunnan";
$areanames{en}->{861333053} = "Kunming\,\ Yunnan";
$areanames{en}->{861333054} = "Kunming\,\ Yunnan";
$areanames{en}->{861333055} = "Dali\,\ Yunnan";
$areanames{en}->{861333056} = "Chuxiong\,\ Yunnan";
$areanames{en}->{861333057} = "Qujing\,\ Yunnan";
$areanames{en}->{861333058} = "Yuxi\,\ Yunnan";
$areanames{en}->{861333059} = "Baoshan\,\ Yunnan";
$areanames{en}->{861333060} = "YaAn\,\ Sichuan";
$areanames{en}->{861333061} = "Bazhong\,\ Sichuan";
$areanames{en}->{861333062} = "GuangAn\,\ Sichuan";
$areanames{en}->{861333063} = "Suining\,\ Sichuan";
$areanames{en}->{861333064} = "Suining\,\ Sichuan";
$areanames{en}->{861333065} = "Yibin\,\ Sichuan";
$areanames{en}->{861333066} = "Yibin\,\ Sichuan";
$areanames{en}->{861333067} = "Bazhong\,\ Sichuan";
$areanames{en}->{861333068} = "Ziyang\,\ Sichuan";
$areanames{en}->{861333069} = "Neijiang\,\ Sichuan";
$areanames{en}->{861333070} = "Neijiang\,\ Sichuan";
$areanames{en}->{861333071} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861333072} = "Panzhihua\,\ Sichuan";
$areanames{en}->{861333073} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861333074} = "Luzhou\,\ Sichuan";
$areanames{en}->{861333075} = "Guangyuan\,\ Sichuan";
$areanames{en}->{861333076} = "Nanchong\,\ Sichuan";
$areanames{en}->{861333077} = "Nanchong\,\ Sichuan";
$areanames{en}->{861333078} = "Luzhou\,\ Sichuan";
$areanames{en}->{861333079} = "Garze\,\ Sichuan";
$areanames{en}->{861333080} = "Zigong\,\ Sichuan";
$areanames{en}->{861333081} = "Zigong\,\ Sichuan";
$areanames{en}->{861333082} = "Dazhou\,\ Sichuan";
$areanames{en}->{861333083} = "Dazhou\,\ Sichuan";
$areanames{en}->{861333084} = "Ziyang\,\ Sichuan";
$areanames{en}->{861333085} = "Deyang\,\ Sichuan";
$areanames{en}->{861333086} = "Deyang\,\ Sichuan";
$areanames{en}->{861333087} = "Deyang\,\ Sichuan";
$areanames{en}->{861333088} = "Mianyang\,\ Sichuan";
$areanames{en}->{861333089} = "Mianyang\,\ Sichuan";
$areanames{en}->{