# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Context2D(Object):
    r"""
    Context2D - Class for drawing 2D primitives to a graphical context.
    
    Superclass: Object
    
    This defines the interface for drawing onto a 2D context. The context
    must be set up with a ContextDevice2D derived class that provides
    the functions to facilitate the low level calls to the context.
    Currently only an open_gl based device is provided, but this could be
    extended in the future.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkContext2D, obj, update, **traits)
    
    def _get_context3d(self):
        return wrap_vtk(self._vtk_obj.GetContext3D())
    def _set_context3d(self, arg):
        old_val = self._get_context3d()
        self._wrap_call(self._vtk_obj.SetContext3D,
                        deref_vtk(arg))
        self.trait_property_changed('context3d', old_val, arg)
    context3d = traits.Property(_get_context3d, _set_context3d, desc=\
        r"""
        Get the Context3D device, in order to do some 3D rendering.
        This API is very experimental, and may be moved around.
        """
    )

    def _get_transform(self):
        return wrap_vtk(self._vtk_obj.GetTransform())
    def _set_transform(self, arg):
        old_val = self._get_transform()
        self._wrap_call(self._vtk_obj.SetTransform,
                        deref_vtk(arg))
        self.trait_property_changed('transform', old_val, arg)
    transform = traits.Property(_get_transform, _set_transform, desc=\
        r"""
        Compute the current transform applied to the context.
        """
    )

    def _get_brush(self):
        return wrap_vtk(self._vtk_obj.GetBrush())
    brush = traits.Property(_get_brush, desc=\
        r"""
        Get the pen which controls the outlines of shapes as well as
        lines, points and related primitives.
        """
    )

    def _get_buffer_id_mode(self):
        return self._vtk_obj.GetBufferIdMode()
    buffer_id_mode = traits.Property(_get_buffer_id_mode, desc=\
        r"""
        Tell if the context is in buffer_id creation mode. Initial value
        is false.
        """
    )

    def _get_device(self):
        return wrap_vtk(self._vtk_obj.GetDevice())
    device = traits.Property(_get_device, desc=\
        r"""
        
        """
    )

    def _get_pen(self):
        return wrap_vtk(self._vtk_obj.GetPen())
    pen = traits.Property(_get_pen, desc=\
        r"""
        Get the pen which controls the outlines of shapes, as well as
        lines, points and related primitives. This object can be modified
        and the changes will be reflected in subsequent drawing
        operations.
        """
    )

    def _get_text_prop(self):
        return wrap_vtk(self._vtk_obj.GetTextProp())
    text_prop = traits.Property(_get_text_prop, desc=\
        r"""
        Get the text properties object for the Context2D.
        """
    )

    def append_transform(self, *args):
        """
        append_transform(self, transform:Transform2D) -> None
        C++: void append_transform(Transform2D *transform)
        Append the transform for the context, the underlying device will
        use the matrix of the transform. Note, this is set immediately,
        later changes to the matrix will have no effect until it is set
        again. The matrix of the transform will multiply the current
        context transform.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AppendTransform, *my_args)
        return ret

    def apply_brush(self, *args):
        """
        apply_brush(self, brush:Brush) -> None
        C++: void apply_brush(Brush *brush)
        Apply the supplied brush which controls the outlines of shapes,
        as well as lines, points and related primitives. This makes a
        deep copy of the Brush object in the Context2D, it does not
        hold a pointer to the supplied object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyBrush, *my_args)
        return ret

    def apply_id(self, *args):
        """
        apply_id(self, id:int) -> None
        C++: void apply_id(IdType id)
        Apply id as a color.
        """
        ret = self._wrap_call(self._vtk_obj.ApplyId, *args)
        return ret

    def apply_pen(self, *args):
        """
        apply_pen(self, pen:Pen) -> None
        C++: void apply_pen(Pen *pen)
        Apply the supplied pen which controls the outlines of shapes, as
        well as lines, points and related primitives. This makes a deep
        copy of the Pen object in the Context2D, it does not hold a
        pointer to the supplied object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyPen, *my_args)
        return ret

    def apply_text_prop(self, *args):
        """
        apply_text_prop(self, prop:TextProperty) -> None
        C++: void apply_text_prop(TextProperty *prop)
        Apply the supplied text property which controls how text is
        rendered. This makes a deep copy of the TextProperty object in
        the Context2D, it does not hold a pointer to the supplied
        object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ApplyTextProp, *my_args)
        return ret

    def begin(self, *args):
        """
        begin(self, device:ContextDevice2D) -> bool
        C++: bool begin(ContextDevice2D *device)
        Begin painting on a ContextDevice2D, no painting can occur
        before this call has been made. Only one painter is allowed at a
        time on any given paint device. Returns true if successful,
        otherwise false.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Begin, *my_args)
        return ret

    def buffer_id_mode_begin(self, *args):
        """
        buffer_id_mode_begin(self, bufferId:AbstractContextBufferId)
            -> None
        C++: void buffer_id_mode_begin(AbstractContextBufferId *bufferId)
        Start buffer_id creation Mode.
        \\pre not_yet: !get_buffer_id_mode()
        \\pre bufferId_exists: bufferId!=0
        \\post started: get_buffer_id_mode()
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.BufferIdModeBegin, *my_args)
        return ret

    def buffer_id_mode_end(self):
        """
        buffer_id_mode_end(self) -> None
        C++: void buffer_id_mode_end()
        Finalize buffer_id creation Mode. It makes sure that the content
        of the bufferId passed in argument of buffer_id_mode_begin() is
        correctly set.
        \\pre started: get_buffer_id_mode()
        \\post done: !get_buffer_id_mode()
        """
        ret = self._vtk_obj.BufferIdModeEnd()
        return ret
        

    def compute_font_size_for_bounded_string(self, *args):
        """
        compute_font_size_for_bounded_string(self, string:str, width:float,
            height:float) -> int
        C++: int compute_font_size_for_bounded_string(
            const StdString &string, float width, float height)
        Calculate the largest possible font size where the supplied
        string will fit within the specified bounds.  In addition to
        being returned, this font size is also used to update the
        TextProperty used by this object. NOTE: text rotation is
        ignored for the purposes of this function.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeFontSizeForBoundedString, *args)
        return ret

    def compute_justified_string_bounds(self, *args):
        """
        compute_justified_string_bounds(self, string:str, bounds:[float,
            float, float, float]) -> None
        C++: void compute_justified_string_bounds(const char *string,
            float bounds[4])
        Compute the bounds of the supplied string while taking into
        account the justification and rotation of the currently applied
        text property.
        """
        ret = self._wrap_call(self._vtk_obj.ComputeJustifiedStringBounds, *args)
        return ret

    def compute_string_bounds(self, *args):
        """
        compute_string_bounds(self, string:str, bounds:Points2D) -> None
        C++: void compute_string_bounds(const StdString &string,
            Points2D *bounds)
        compute_string_bounds(self, string:str, bounds:[float, float, float,
             float]) -> None
        C++: void compute_string_bounds(const StdString &string,
            float bounds[4])
        compute_string_bounds(self, string:str, bounds:Points2D) -> None
        C++: void compute_string_bounds(const UnicodeString &string,
            Points2D *bounds)
        compute_string_bounds(self, string:str, bounds:[float, float, float,
             float]) -> None
        C++: void compute_string_bounds(const UnicodeString &string,
            float bounds[4])
        Compute the bounds of the supplied string. The bounds will be
        copied to the supplied bounds variable, the first two elements
        are the bottom corner of the string, and the second two elements
        are the width and height of the bounding box.
        
        * NOTE:the text justification from the current text property is
        * NOT considered when computing these bounds.
        """
        my_args = deref_array(args, [('string', 'vtkPoints2D'), ('string', ['float', 'float', 'float', 'float']), ('string', 'vtkPoints2D'), ('string', ['float', 'float', 'float', 'float'])])
        ret = self._wrap_call(self._vtk_obj.ComputeStringBounds, *my_args)
        return ret

    def draw_arc(self, *args):
        """
        draw_arc(self, x:float, y:float, r:float, startAngle:float,
            stopAngle:float) -> None
        C++: void draw_arc(float x, float y, float r, float startAngle,
            float stopAngle)
        Draw a circular arc with center at x,y with radius r between
        angles startAngle and stopAngle (expressed in degrees).
        \\pre positive_radius: r>=0
        """
        ret = self._wrap_call(self._vtk_obj.DrawArc, *args)
        return ret

    def draw_ellipse(self, *args):
        """
        draw_ellipse(self, x:float, y:float, rx:float, ry:float) -> None
        C++: void draw_ellipse(float x, float y, float rx, float ry)
        Draw an ellipse with center at x, y and radii rx, ry.
        \\pre positive_rx: rx>=0
        \\pre positive_ry: ry>=0
        """
        ret = self._wrap_call(self._vtk_obj.DrawEllipse, *args)
        return ret

    def draw_ellipse_wedge(self, *args):
        """
        draw_ellipse_wedge(self, x:float, y:float, outRx:float, outRy:float,
             inRx:float, inRy:float, startAngle:float, stopAngle:float)
            -> None
        C++: void draw_ellipse_wedge(float x, float y, float outRx,
            float outRy, float inRx, float inRy, float startAngle,
            float stopAngle)
        Draw an elliptic wedge with center at x, y, outer radii outRx,
        outRy, inner radii inRx, inRy between angles startAngle and
        stopAngle (expressed in degrees).
        \\pre positive_outRx: outRx>=0
        \\pre positive_outRy: outRy>=0
        \\pre positive_inRx: inRx>=0
        \\pre positive_inRy: inRy>=0
        \\pre ordered_rx: inRx<=outRx
        \\pre ordered_ry: inRy<=outRy
        """
        ret = self._wrap_call(self._vtk_obj.DrawEllipseWedge, *args)
        return ret

    def draw_elliptic_arc(self, *args):
        """
        draw_elliptic_arc(self, x:float, y:float, rX:float, rY:float,
            startAngle:float, stopAngle:float) -> None
        C++: void draw_elliptic_arc(float x, float y, float rX, float rY,
            float startAngle, float stopAngle)
        Draw an elliptic arc with center at x,y with radii rX and rY
        between angles startAngle and stopAngle (expressed in degrees).
        \\pre positive_rX: rX>=0
        \\pre positive_rY: rY>=0
        """
        ret = self._wrap_call(self._vtk_obj.DrawEllipticArc, *args)
        return ret

    def draw_image(self, *args):
        """
        draw_image(self, x:float, y:float, image:ImageData) -> None
        C++: void draw_image(float x, float y, ImageData *image)
        draw_image(self, x:float, y:float, scale:float, image:ImageData)
             -> None
        C++: void draw_image(float x, float y, float scale,
            ImageData *image)
        draw_image(self, pos:Rectf, image:ImageData) -> None
        C++: void draw_image(const Rectf &pos, ImageData *image)
        Draw the supplied image at the given x, y location (bottom
        corner).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.DrawImage, *my_args)
        return ret

    def draw_line(self, *args):
        """
        draw_line(self, x1:float, y1:float, x2:float, y2:float) -> None
        C++: void draw_line(float x1, float y1, float x2, float y2)
        draw_line(self, p:[float, float, float, float]) -> None
        C++: void draw_line(float p[4])
        draw_line(self, points:Points2D) -> None
        C++: void draw_line(Points2D *points)
        Draw a line between the specified points.
        """
        my_args = deref_array(args, [('float', 'float', 'float', 'float'), (['float', 'float', 'float', 'float'],), ['vtkPoints2D']])
        ret = self._wrap_call(self._vtk_obj.DrawLine, *my_args)
        return ret

    def draw_lines(self, *args):
        """
        draw_lines(self, points:Points2D) -> None
        C++: void draw_lines(Points2D *points)
        draw_lines(self, points:[float, ...], n:int) -> None
        C++: void draw_lines(float *points, int n)
        Draw multiple lines between the specified pairs of points.
        \\sa draw_poly()
        """
        my_args = deref_array(args, [['vtkPoints2D'], ('tuple', 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawLines, *my_args)
        return ret

    def draw_markers(self, *args):
        """
        draw_markers(self, shape:int, highlight:bool, points:[float, ...],
            n:int, colors:[int, ...], nc_comps:int) -> None
        C++: virtual void draw_markers(int shape, bool highlight,
            float *points, int n, unsigned char *colors, int nc_comps)
        draw_markers(self, shape:int, highlight:bool, points:[float, ...],
            n:int) -> None
        C++: virtual void draw_markers(int shape, bool highlight,
            float *points, int n)
        draw_markers(self, shape:int, highlight:bool, points:Points2D)
            -> None
        C++: virtual void draw_markers(int shape, bool highlight,
            Points2D *points)
        draw_markers(self, shape:int, highlight:bool, points:Points2D,
            colors:UnsignedCharArray) -> None
        C++: virtual void draw_markers(int shape, bool highlight,
            Points2D *points, UnsignedCharArray *colors)
        Draw a series of markers centered at the points supplied. The
        shape argument controls the marker shape, and can be one of
        - VTK_MARKER_CROSS
        - VTK_MARKER_PLUS
        - VTK_MARKER_SQUARE
        - VTK_MARKER_CIRCLE
        - VTK_MARKER_DIAMOND Marker size is determined by the current pen
        width.
        \\param shape the shape of the marker
        \\param highlight whether to highlight the marker or not
        \\param points where to draw the markers
        \\param n number of points
        \\param colors is an optional array of colors.
        \\param nc_comps is the number of components for the color.
        """
        my_args = deref_array(args, [('int', 'bool', 'tuple', 'int', ['int', Ellipsis], 'int'), ('int', 'bool', 'tuple', 'int'), ('int', 'bool', 'vtkPoints2D'), ('int', 'bool', 'vtkPoints2D', 'vtkUnsignedCharArray')])
        ret = self._wrap_call(self._vtk_obj.DrawMarkers, *my_args)
        return ret

    def draw_math_text_string(self, *args):
        """
        draw_math_text_string(self, point:Points2D, string:str) -> None
        C++: void draw_math_text_string(Points2D *point,
            const StdString &string)
        draw_math_text_string(self, x:float, y:float, string:str) -> None
        C++: void draw_math_text_string(float x, float y,
            const StdString &string)
        draw_math_text_string(self, point:Points2D, string:str,
            fallback:str) -> None
        C++: void draw_math_text_string(Points2D *point,
            const StdString &string, const StdString &fallback)
        draw_math_text_string(self, x:float, y:float, string:str,
            fallback:str) -> None
        C++: void draw_math_text_string(float x, float y,
            const StdString &string, const StdString &fallback)
        Draw a math_text formatted equation to the screen. See
        http://matplotlib.sourceforge.net/users/mathtext.html for more
        information. math_text requires matplotlib and python, and the
        Matplotlib module must be enabled manually during build
        configuration. This method will do nothing but print a warning if
        MathTextUtilities::GetInstance() returns NULL.
        """
        my_args = deref_array(args, [('vtkPoints2D', 'string'), ('float', 'float', 'string'), ('vtkPoints2D', 'string', 'string'), ('float', 'float', 'string', 'string')])
        ret = self._wrap_call(self._vtk_obj.DrawMathTextString, *my_args)
        return ret

    def draw_point(self, *args):
        """
        draw_point(self, x:float, y:float) -> None
        C++: void draw_point(float x, float y)
        Draw a point at the supplied x and y coordinate
        """
        ret = self._wrap_call(self._vtk_obj.DrawPoint, *args)
        return ret

    def draw_point_sprites(self, *args):
        """
        draw_point_sprites(self, sprite:ImageData, points:Points2D)
            -> None
        C++: void draw_point_sprites(ImageData *sprite,
            Points2D *points)
        draw_point_sprites(self, sprite:ImageData, points:Points2D,
            colors:UnsignedCharArray) -> None
        C++: void draw_point_sprites(ImageData *sprite,
            Points2D *points, UnsignedCharArray *colors)
        draw_point_sprites(self, sprite:ImageData, points:[float, ...],
            n:int, colors:[int, ...], nc_comps:int) -> None
        C++: void draw_point_sprites(ImageData *sprite, float *points,
            int n, unsigned char *colors, int nc_comps)
        draw_point_sprites(self, sprite:ImageData, points:[float, ...],
            n:int) -> None
        C++: void draw_point_sprites(ImageData *sprite, float *points,
            int n)
        Draw a series of point sprites, images centred at the points
        supplied. The supplied ImageData is the sprite to be drawn,
        only squares will be drawn and the size is set using
        set_point_size.
        """
        my_args = deref_array(args, [('vtkImageData', 'vtkPoints2D'), ('vtkImageData', 'vtkPoints2D', 'vtkUnsignedCharArray'), ('vtkImageData', 'tuple', 'int', ['int', Ellipsis], 'int'), ('vtkImageData', 'tuple', 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawPointSprites, *my_args)
        return ret

    def draw_points(self, *args):
        """
        draw_points(self, x:[float, ...], y:[float, ...], n:int) -> None
        C++: void draw_points(float *x, float *y, int n)
        draw_points(self, points:Points2D) -> None
        C++: void draw_points(Points2D *points)
        draw_points(self, points:[float, ...], n:int) -> None
        C++: void draw_points(float *points, int n)
        Draw the specified number of points using the x and y arrays
        supplied
        """
        my_args = deref_array(args, [('tuple', 'tuple', 'int'), ['vtkPoints2D'], ('tuple', 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawPoints, *my_args)
        return ret

    def draw_poly(self, *args):
        """
        draw_poly(self, x:[float, ...], y:[float, ...], n:int) -> None
        C++: void draw_poly(float *x, float *y, int n)
        draw_poly(self, points:Points2D) -> None
        C++: void draw_poly(Points2D *points)
        draw_poly(self, points:[float, ...], n:int) -> None
        C++: void draw_poly(float *points, int n)
        draw_poly(self, points:[float, ...], n:int, colors:[int, ...],
            nc_comps:int) -> None
        C++: void draw_poly(float *points, int n, unsigned char *colors,
            int nc_comps)
        Draw a poly line between the specified points.
        """
        my_args = deref_array(args, [('tuple', 'tuple', 'int'), ['vtkPoints2D'], ('tuple', 'int'), ('tuple', 'int', ['int', Ellipsis], 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawPoly, *my_args)
        return ret

    def draw_poly_data(self, *args):
        """
        draw_poly_data(self, x:float, y:float, polyData:PolyData,
            colors:UnsignedCharArray, scalarMode:int) -> None
        C++: void draw_poly_data(float x, float y, PolyData *polyData,
            UnsignedCharArray *colors, int scalarMode)
        Draw the supplied polyData at the given x, y position (bottom
        corner).
        
        ote Supports only 2D meshes.
        """
        my_args = deref_array(args, [('float', 'float', 'vtkPolyData', 'vtkUnsignedCharArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawPolyData, *my_args)
        return ret

    def draw_polygon(self, *args):
        """
        draw_polygon(self, x:[float, ...], y:[float, ...], n:int) -> None
        C++: void draw_polygon(float *x, float *y, int n)
        draw_polygon(self, points:Points2D) -> None
        C++: void draw_polygon(Points2D *points)
        draw_polygon(self, points:[float, ...], n:int) -> None
        C++: void draw_polygon(float *points, int n)
        draw_polygon(self, x:[float, ...], y:[float, ...], n:int,
            color:[int, ...], nc_comps:int) -> None
        C++: void draw_polygon(float *x, float *y, int n,
            unsigned char *color, int nc_comps)
        draw_polygon(self, points:Points2D, color:[int, ...],
            nc_comps:int) -> None
        C++: void draw_polygon(Points2D *points, unsigned char *color,
            int nc_comps)
        draw_polygon(self, points:[float, ...], n:int, color:[int, ...],
            nc_comps:int) -> None
        C++: void draw_polygon(float *points, int n, unsigned char *color,
            int nc_comps)
        Draw a polygon specified specified by the points using the x and
        y arrays supplied
        """
        my_args = deref_array(args, [('tuple', 'tuple', 'int'), ['vtkPoints2D'], ('tuple', 'int'), ('tuple', 'tuple', 'int', ['int', Ellipsis], 'int'), ('vtkPoints2D', ['int', Ellipsis], 'int'), ('tuple', 'int', ['int', Ellipsis], 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawPolygon, *my_args)
        return ret

    def draw_quad(self, *args):
        """
        draw_quad(self, x1:float, y1:float, x2:float, y2:float, x3:float,
            y3:float, x4:float, y4:float) -> None
        C++: void draw_quad(float x1, float y1, float x2, float y2,
            float x3, float y3, float x4, float y4)
        draw_quad(self, p:[float, ...]) -> None
        C++: void draw_quad(float *p)
        Draw a quadrilateral at the specified points (4 points, 8 floats
        in x, y).
        """
        ret = self._wrap_call(self._vtk_obj.DrawQuad, *args)
        return ret

    def draw_quad_strip(self, *args):
        """
        draw_quad_strip(self, points:Points2D) -> None
        C++: void draw_quad_strip(Points2D *points)
        draw_quad_strip(self, p:[float, ...], n:int) -> None
        C++: void draw_quad_strip(float *p, int n)
        Draw a strip of quads
        """
        my_args = deref_array(args, [['vtkPoints2D'], ('tuple', 'int')])
        ret = self._wrap_call(self._vtk_obj.DrawQuadStrip, *my_args)
        return ret

    def draw_rect(self, *args):
        """
        draw_rect(self, x:float, y:float, w:float, h:float) -> None
        C++: void draw_rect(float x, float y, float w, float h)
        Draw a rectangle with origin at x, y and width w, height h
        """
        ret = self._wrap_call(self._vtk_obj.DrawRect, *args)
        return ret

    def draw_string(self, *args):
        """
        draw_string(self, point:Points2D, string:str) -> None
        C++: void draw_string(Points2D *point,
            const StdString &string)
        draw_string(self, x:float, y:float, string:str) -> None
        C++: void draw_string(float x, float y, const StdString &string)
        draw_string(self, point:Points2D, string:str) -> None
        C++: void draw_string(Points2D *point,
            const UnicodeString &string)
        draw_string(self, x:float, y:float, string:str) -> None
        C++: void draw_string(float x, float y,
            const UnicodeString &string)
        Draw some text to the screen.
        """
        my_args = deref_array(args, [('vtkPoints2D', 'string'), ('float', 'float', 'string'), ('vtkPoints2D', 'string'), ('float', 'float', 'string')])
        ret = self._wrap_call(self._vtk_obj.DrawString, *my_args)
        return ret

    def draw_string_rect(self, *args):
        """
        draw_string_rect(self, rect:Points2D, string:str) -> None
        C++: void draw_string_rect(Points2D *rect,
            const StdString &string)
        draw_string_rect(self, rect:Points2D, string:str) -> None
        C++: void draw_string_rect(Points2D *rect,
            const UnicodeString &string)
        draw_string_rect(self, rect:(float, float, float, float),
            string:str) -> None
        C++: void draw_string_rect(const float rect[4],
            const StdString &string)
        draw_string_rect(self, rect:(float, float, float, float),
            string:str) -> None
        C++: void draw_string_rect(const float rect[4],
            const UnicodeString &string)
        Draw some text to the screen in a bounding rectangle with the
        alignment of the text properties respecting the rectangle. The
        points should be supplied as bottom corner (x, y), width, height.
        """
        my_args = deref_array(args, [('vtkPoints2D', 'string'), ('vtkPoints2D', 'string'), (('float', 'float', 'float', 'float'), 'string'), (('float', 'float', 'float', 'float'), 'string')])
        ret = self._wrap_call(self._vtk_obj.DrawStringRect, *my_args)
        return ret

    def draw_wedge(self, *args):
        """
        draw_wedge(self, x:float, y:float, outRadius:float, inRadius:float,
             startAngle:float, stopAngle:float) -> None
        C++: void draw_wedge(float x, float y, float outRadius,
            float inRadius, float startAngle, float stopAngle)
        Draw a circular wedge with center at x, y, outer radius
        outRadius, inner radius inRadius between angles startAngle and
        stopAngle (expressed in degrees).
        \\pre positive_outRadius: outRadius>=0
        \\pre positive_inRadius: inRadius>=0
        \\pre ordered_radii: inRadius<=outRadius
        """
        ret = self._wrap_call(self._vtk_obj.DrawWedge, *args)
        return ret

    def end(self):
        """
        end(self) -> bool
        C++: bool end()
        Ends painting on the device, you would not usually need to call
        this as it should be called by the destructor. Returns true if
        the painter is no longer active, otherwise false.
        """
        ret = self._vtk_obj.End()
        return ret
        

    def float_to_int(self, *args):
        """
        float_to_int(x:float) -> int
        C++: static int float_to_int(float x)
        Float to int conversion, performs truncation but with a rounding
        tolerance for float values that are within 1/256 of their closest
        integer.
        """
        ret = self._wrap_call(self._vtk_obj.FloatToInt, *args)
        return ret

    def math_text_is_supported(self):
        """
        math_text_is_supported(self) -> bool
        C++: bool math_text_is_supported()
        Return true if math_text rendering available on the current
        device.
        """
        ret = self._vtk_obj.MathTextIsSupported()
        return ret
        

    def pop_matrix(self):
        """
        pop_matrix(self) -> None
        C++: void pop_matrix()"""
        ret = self._vtk_obj.PopMatrix()
        return ret
        

    def push_matrix(self):
        """
        push_matrix(self) -> None
        C++: void push_matrix()
        Push/pop the transformation matrix for the painter (sets the
        underlying matrix for the device when available).
        """
        ret = self._vtk_obj.PushMatrix()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Context2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Context2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Context2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Context2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

