import unittest
import calc_release_version


class TestVersionSort(unittest.TestCase):
    def test_version_sort(self):
        # At time of writing, `input_tags` is the output of `git tag -l "r3.*"`:
        input_tags = ["3.0.0", "3.0.0-rc0", "3.0.1", "3.0.2", "3.0.3", "3.1.0", "3.1.0-beta0", "3.1.0-rc0", "3.1.1", "3.1.2", "3.1.3", "3.1.4", "3.2.0", "3.2.0-rc0", "3.2.0-rc1", "3.2.1", "3.3.0", "3.3.0-rc0", "3.3.1", "3.3.2", "3.4.0", "3.4.1", "3.4.2", "3.5.0", "3.5.1", "3.6.0", "3.6.0-rc0", "3.6.1", "3.6.2", "3.6.3", "3.6.4", "3.6.5", "3.6.6", "3.6.7", "3.7.0", "3.7.0-beta1", "3.7.1", "3.7.2", "3.8.0", "3.8.1", "3.9.0"]
        expected_tags = ["3.0.0-rc0", "3.0.0", "3.0.1", "3.0.2", "3.0.3", "3.1.0-beta0", "3.1.0-rc0", "3.1.0", "3.1.1", "3.1.2", "3.1.3", "3.1.4", "3.2.0-rc0", "3.2.0-rc1", "3.2.0", "3.2.1", "3.3.0-rc0", "3.3.0", "3.3.1", "3.3.2", "3.4.0", "3.4.1", "3.4.2", "3.5.0", "3.5.1", "3.6.0-rc0", "3.6.0", "3.6.1", "3.6.2", "3.6.3", "3.6.4", "3.6.5", "3.6.6", "3.6.7", "3.7.0-beta1", "3.7.0", "3.7.1", "3.7.2", "3.8.0", "3.8.1", "3.9.0"]
        got_tags = sorted(input_tags, key=calc_release_version.Version)
        self.assertEqual(got_tags, expected_tags)


if __name__ == "__main__":
    unittest.main()
