$! cxxcompile.dcl - DCL command procedure to compile a C++ source file.
$
$	cxxflags = p1					! misc cxx qualifiers
$	cxxmacros = f$edit(p2, "TRIM,COMPRESS")	! list of macro definitions for
$	! the /define qualifier
$	cxxincludes = f$edit(p3, "TRIM,COMPRESS")	! list of directories for the
$	! /include qualifier
$	cxxrepositories = f$edit(p4, "TRIM,COMPRESS")	! list of directories for the
$	! /repository qualifier
$	mmssource = p5				! source file
$	_mmstarget = p6				! object file
$	additional1 = p7				! additional qualifiers
$	additional2 = p8				! additional qualifiers
$
$	_self=f$environment("procedure")
$	_here=f$parse(_self,,,"device")+f$parse(_self,,,"directory")
$	_there=f$environment("default")
$
$	! convert the list arguments from space delimited to comma seperated, quoted
$	! strings.  This preserves case-sensitivity and allows UNIX style directory
$	! names in some cases (works for /include on VMS 7.x; doesn't work for
$	! repository qualifier).
$
$	call parselist cxxmacros
$	if outputlist .eqs. ""
$	then
$	    definequalifier=""
$	else
$	    definequalifier="/define=(" + outputlist + ")"
$	endif
$
$	nounix=0
$	if f$getsyi("version") .LTS. "V7"
$	then
$	    nounix=1
$	endif
$
$	call parselist cxxincludes 'nounix'
$	if outputlist .eqs. ""
$	then
$	    includequalifier=""
$	else
$	    includequalifier="/include=(" + outputlist + ")"
$	endif
$
$	call parselist cxxrepositories 1
$	if outputlist .eqs. ""
$	then
$	    repositoryqualifier=""
$	else
$	    repositoryqualifier="/repository=(" + outputlist + ")"
$	endif
$
$	! work around CXX/MMS/Librarian (not sure who to blame) case sensitivity bug
$
$	_name=f$parse(f$search(mmssource),,,"name")
$	_type=f$edit(f$parse(mmssource,,,"type"),"lowercase")
$	_ucname=f$edit(_name,"UPCASE")
$	if _name .nes. _ucname
$	then
$	    _device=f$parse(mmssource,,,"device")
$	    _directory=f$parse(mmssource,,,"directory")
$	    _fullucname=_directory+_ucname+_type
$	    _fullname=_directory+_name+_type
$	    _saveset=f$parse(_ucname+_type+"-bak")-";"
$	    _extended=1
$	    purge 'mmssource'
$	    backup 'mmssource' '_saveset'/save
$	    delete 'mmssource';
$	    backup '_saveset'/save '_fullucname'
$
$	    ! Now that we've moved all these files around we need to cleanup no
$	    ! matter what (before we might just stop dead in our tracks).
$
$	    set noon
$	else
$	    _extended=0
$	endif
$
$	write sys$output "Compiling "+_name+_type+"..."
$
$	_oldver=f$verify(COMPILE_VERIFY)
$	CXX 'CXXFLAGS' 'mmssource' /object='_mmstarget' 'definequalifier'-
	    'includequalifier'-
	    'repositoryqualifier'-
	    'additional1'-
	    'additional2'
$	cxxstatus=$status
$	_x=f$verify(_oldver)
$
$	if _extended
$	then
$	    delete 'mmssource';*
$	    backup '_saveset'/save '_fullname'
$	    delete '_saveset';*
$	    set on
$	endif
$
$	diagnostics = f$parse(_mmstarget,,,"name") + ".DIA"
$	listfile = f$parse(_mmstarget,,,"name") + ".LIS"
$	! Don't use f$parse(_mmstarget,,,"directory") because we don't want
$	! the full path name:
$
$	_targetdir=f$extract(f$locate("[",_mmstarget), -
			     f$locate("]",_mmstarget)+1, -
			     _mmstarget)
$
$	_n=f$locate(":",_mmstarget)
$	if _n.lt.f$length(_mmstarget)
$	then _targetdev=f$extract(0,_n,_mmstarget)
$	else _targetdev=""
$	endif
$
$	_dependencyfile = _targetdev+_targetdir+f$parse(_mmstarget,,,"name") + ".D"
$	If cxxstatus
$	then if F$Search(diagnostics) .NES. "" Then delete 'diagnostics';*
$	else if F$Search(_mmstarget) .NES. "" Then delete/log '_mmstarget';*
$	endif
$	If "''F$Search(_mmstarget)'" .NES. "" Then purge '_mmstarget'
$	If "''F$Search(listfile)'" .NES. "" Then purge 'listfile'
$	If "''F$Search(_dependencyfile)'" .NES. ""
$	Then
$	    purge '_dependencyfile'
$	    oldver=f$verify(COMPILE_VERIFY)
$	    python '_here'postProcessDfile.py '_dependencyfile' '_there' '_mmstarget'
$	    x=f$verify(oldver)
$	Endif
$
$	exit 'cxxstatus
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$
$ parselist: subroutine
$
$	! in python this would be:
$	!
$	! def parselist(s):
$	!   import string
$	!   return '"' + string.join(string.split(s),'" "') + '"'
$
$	inputlist='p1'	! Note that this is passed by name due to bugs in pass
$	! by value (call sub "''x'" does some harmful parsing).
$	converttovms=p2
$	outputlist==""
$	if inputlist .eqs. "" then exit
$	if converttovms
$	then
$	    quote=""
$	else
$	    quote=""""
$	endif
$	outputlist==quote
$	idx=0
$	element=f$element(idx, " ", inputlist)
$
$ next_listitem:
$
$	if converttovms
$	then
$	    call unixtovmsdir "''element'"
$	    element=outputdir
$	endif
$	outputlist == outputlist + element + quote
$	idx = idx + 1
$	element=f$element(idx, " ", inputlist)
$	if element .eqs. " " then goto end_listitem
$	outputlist == outputlist + "," + quote
$	goto next_listitem
$
$ end_listitem:
$	endsubroutine		! parselist
$
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$
$ unixtovmsdir: subroutine	! convert UNIX style directory names to VMS
$	! format.
$
$	! Takes unix style or vms style directory name as its only argument.
$
$	! if the argument contains any colons (:) or braces ([]) then the
$	! argument is assumed to be a VMS directory name and is returned
$	! without modification.
$
$	! Otherwise, the argument is converted to a VMS style specification.
$
$	! The result is returned in the global variable outputdir.
$
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$
$	arg = f$edit(p1,"TRIM,COMPRESS")
$	outputdir == ""
$
$	! if argument looks like a vms name then return it without modification:
$
$	if	f$locate(":",arg) .lt. f$length(arg) .or.-
		f$locate("[",arg) .lt. f$length(arg) .or.-
		f$locate("]",arg) .lt. f$length(arg)
$	then
$	    outputdir == arg
$	    goto u2vms_end
$	endif
$
$	! degenerate cases
$
$	if arg .eqs. ""
$	then
$	    outputdir == ""
$	    goto u2vms_end
$	endif
$
$	if arg .eqs. "/"
$	then
$	    outputdir == "[000000]"
$	    goto u2vms_end
$	endif
$
$	! to make life easier, if the argument ends with a slash then remove it
$
$	if f$extract(f$length(arg)-1,1,arg) .eqs. "/"
$	then
$	    arg = f$extract(0,f$length(arg)-1,arg)
$	endif
$
$	idx=0
$	sub1=f$element(idx,"/",arg)		! previous subdirectory
$
$	idx = idx + 1
$	sub2 = f$element(idx,"/",arg)	! next subdirectory
$
$	! sub2 .eqs. "/" indicates the end of the string has been found.
$	! Note that it is imposible for f$element(0, delim, x) to return delim.
$
$	if sub2 .eqs. "/"		! ^[^/]+$ (no slash found)
$	then
$
$	    if sub1 .eqs. "."		! ^\.$
$	    then
$		outputdir=="[]"
$		goto u2vms_end
$	    endif
$
$	    if sub1 .eqs. ".."	! ^\.\.$
$	    then
$		outputdir=="[-]"
$		goto u2vms_end
$	    endif
$
$	    if f$search(arg + ".dir") .eqs. ""
$	    then
$		outputdir=="[." + arg + "]"
$	    else
$		outputdir==arg + ":"
$	    endif
$
$	    goto u2vms_end
$
$	endif
$
$	! found at least one slash.
$
$	if sub1 .eqs. ""		! ^/
$	then
$
$	    ! leading slash indicates a VMS device name follows
$
$	    if sub2 .eqs. ""		! ^/$ or ^//
$	    then
$
$		! advance sub1 and sub2
$		sub1 = sub2
$		idx=idx + 1
$		sub2 = f$element(idx,"/",arg)
$
$		if sub2 .eqs. "/"	! ^/$
$		then
$		    ! not sure how to interpret this.  sys$login: is a tempting
$		    ! interpretation, but I think ~ or /~ would be closer (which isn't
$		    ! handled).
$		    outputdir=="[000000]"
$		    goto u2vms_end
$
$		else		      ! ^//
$
$		    ! cygwin interprets //c as c: so do something similar (but don't
$		    ! bother looking for something stupid like //., //.. or /// - just
$		    ! let it blow up).
$		    outputdir == sub2 + ":"
$		    ! advance sub1 and sub2
$		    sub1 = sub2
$		    idx = idx + 1
$		    sub2 = f$element(idx,"/",arg)
$		    if sub2 .eqs. "/" then goto u2vms_end
$
$		endif
$
$	    else			! ^/[^/]+
$
$		! advance
$		sub1 = sub2
$		idx = idx + 1
$		sub2 = f$element(idx,"/",arg)
$		outputdir == sub1 + ":"
$
$		if sub2 .eqs. "/" then goto u2vms_end
$
$		! advance
$		sub1 = sub2
$		idx = idx + 1
$		sub2 = f$element(idx,"/",arg)
$
$	    endif
$
$	endif
$
$	outputdir==outputdir + "["
$
$ u2vms_next:
$
$	if sub1 .eqs. "."
$	then
$	    outputdir == outputdir + "."
$	else
$	    if sub1 .eqs. ".."
$	    then
$		outputdir == outputdir + "-"
$	    else
$		! special case: sub1/sub2 -> [.sub1.sub2]
$		if idx .eq. 1
$		then
$		    outputdir == outputdir + "." + sub1
$		else
$		    outputdir == outputdir + sub1
$		endif
$		if sub2 .nes. "/" then outputdir == outputdir + "."
$	    endif
$	endif
$
$	if sub2 .eqs. "/"
$	then
$	    outputdir == outputdir + "]"
$	    goto u2vms_end
$	endif
$
$	! advance sub1 and sub2
$
$	sub1 = sub2
$	idx=idx+1
$	sub2 = f$element(idx,"/",arg)
$	goto u2vms_next
$
$ u2vms_end: exit
$
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$
$	     endsubroutine !unixtovmsdir
$
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
