
#include "src/trace_processor/perfetto_sql/grammar/perfettosql_keywordhash_helper.h"
/***** This file contains automatically generated code ******
**
** The code in this file has been automatically generated by
**
**   sqlite/tool/mkkeywordhash.c
**
** The code in this file implements a function that determines whether
** or not a given identifier is really an SQL keyword.  The same thing
** might be implemented more directly using a hand-written hash table.
** But by using this automatically generated code, the size of the code
** is substantially reduced.  This is important for embedded applications
** on platforms with limited memory.
*/
/* Hash score: 243 */
/* zKWText[] encodes 1064 bytes of keyword text in 708 bytes */
/*   REINDEXEDESCAPERFETTOFFSETABLEFTHENDATABASELECTIESAVEPOINT         */
/*   ERSECTRANSACTIONOTNULLSBEFOREIGNOREGEXPLAINCLUDEFERRABLEACHECK     */
/*   EYISNULLIKELSEXCLUDELEGATESCONSTRAINTORDERAISEXCEPTRIGGERANGE      */
/*   NERATEDELETEMPORARYMACROSSUNIQUERYWITHOUTEREFERENCESATTACH         */
/*   AVINGLOBEGINSTEADDETACHBETWEENATURALTERELEASEXCLUSIVEXISTS         */
/*   CASCADEFAULTCASECOLLATECREATECURRENT_DATEIMMEDIATEJOINNER          */
/*   ECURSIVEMATCHMODULEPLANALYZEPRAGMATERIALIZEDEFERREDISTINCT         */
/*   UPDATEVALUESVIRTUALWAYSWHENOTHINGROUPSWHERENAMEABORTAFTER          */
/*   EPLACEANDROPARTITIONAUTOINCREMENTCASTCOLUMNCOMMITCONFLICT          */
/*   CURRENT_TIMESTAMPRECEDINGFAILASTFILTERESTRICTFIRSTFOLLOWING        */
/*   FROMFULLIMITFUNCTIONIFINSERTOTHERSOVERETURNINGRETURNSRIGHT         */
/*   ROLLBACKROWSUNBOUNDEDUNIONUSINGVACUUMVIEWINDOWBYINITIALLY          */
/*   PRIMARY                                                            */
static const char zKWText[707] = {
    'R', 'E', 'I', 'N', 'D', 'E', 'X', 'E', 'D', 'E', 'S', 'C', 'A', 'P', 'E',
    'R', 'F', 'E', 'T', 'T', 'O', 'F', 'F', 'S', 'E', 'T', 'A', 'B', 'L', 'E',
    'F', 'T', 'H', 'E', 'N', 'D', 'A', 'T', 'A', 'B', 'A', 'S', 'E', 'L', 'E',
    'C', 'T', 'I', 'E', 'S', 'A', 'V', 'E', 'P', 'O', 'I', 'N', 'T', 'E', 'R',
    'S', 'E', 'C', 'T', 'R', 'A', 'N', 'S', 'A', 'C', 'T', 'I', 'O', 'N', 'O',
    'T', 'N', 'U', 'L', 'L', 'S', 'B', 'E', 'F', 'O', 'R', 'E', 'I', 'G', 'N',
    'O', 'R', 'E', 'G', 'E', 'X', 'P', 'L', 'A', 'I', 'N', 'C', 'L', 'U', 'D',
    'E', 'F', 'E', 'R', 'R', 'A', 'B', 'L', 'E', 'A', 'C', 'H', 'E', 'C', 'K',
    'E', 'Y', 'I', 'S', 'N', 'U', 'L', 'L', 'I', 'K', 'E', 'L', 'S', 'E', 'X',
    'C', 'L', 'U', 'D', 'E', 'L', 'E', 'G', 'A', 'T', 'E', 'S', 'C', 'O', 'N',
    'S', 'T', 'R', 'A', 'I', 'N', 'T', 'O', 'R', 'D', 'E', 'R', 'A', 'I', 'S',
    'E', 'X', 'C', 'E', 'P', 'T', 'R', 'I', 'G', 'G', 'E', 'R', 'A', 'N', 'G',
    'E', 'N', 'E', 'R', 'A', 'T', 'E', 'D', 'E', 'L', 'E', 'T', 'E', 'M', 'P',
    'O', 'R', 'A', 'R', 'Y', 'M', 'A', 'C', 'R', 'O', 'S', 'S', 'U', 'N', 'I',
    'Q', 'U', 'E', 'R', 'Y', 'W', 'I', 'T', 'H', 'O', 'U', 'T', 'E', 'R', 'E',
    'F', 'E', 'R', 'E', 'N', 'C', 'E', 'S', 'A', 'T', 'T', 'A', 'C', 'H', 'A',
    'V', 'I', 'N', 'G', 'L', 'O', 'B', 'E', 'G', 'I', 'N', 'S', 'T', 'E', 'A',
    'D', 'D', 'E', 'T', 'A', 'C', 'H', 'B', 'E', 'T', 'W', 'E', 'E', 'N', 'A',
    'T', 'U', 'R', 'A', 'L', 'T', 'E', 'R', 'E', 'L', 'E', 'A', 'S', 'E', 'X',
    'C', 'L', 'U', 'S', 'I', 'V', 'E', 'X', 'I', 'S', 'T', 'S', 'C', 'A', 'S',
    'C', 'A', 'D', 'E', 'F', 'A', 'U', 'L', 'T', 'C', 'A', 'S', 'E', 'C', 'O',
    'L', 'L', 'A', 'T', 'E', 'C', 'R', 'E', 'A', 'T', 'E', 'C', 'U', 'R', 'R',
    'E', 'N', 'T', '_', 'D', 'A', 'T', 'E', 'I', 'M', 'M', 'E', 'D', 'I', 'A',
    'T', 'E', 'J', 'O', 'I', 'N', 'N', 'E', 'R', 'E', 'C', 'U', 'R', 'S', 'I',
    'V', 'E', 'M', 'A', 'T', 'C', 'H', 'M', 'O', 'D', 'U', 'L', 'E', 'P', 'L',
    'A', 'N', 'A', 'L', 'Y', 'Z', 'E', 'P', 'R', 'A', 'G', 'M', 'A', 'T', 'E',
    'R', 'I', 'A', 'L', 'I', 'Z', 'E', 'D', 'E', 'F', 'E', 'R', 'R', 'E', 'D',
    'I', 'S', 'T', 'I', 'N', 'C', 'T', 'U', 'P', 'D', 'A', 'T', 'E', 'V', 'A',
    'L', 'U', 'E', 'S', 'V', 'I', 'R', 'T', 'U', 'A', 'L', 'W', 'A', 'Y', 'S',
    'W', 'H', 'E', 'N', 'O', 'T', 'H', 'I', 'N', 'G', 'R', 'O', 'U', 'P', 'S',
    'W', 'H', 'E', 'R', 'E', 'N', 'A', 'M', 'E', 'A', 'B', 'O', 'R', 'T', 'A',
    'F', 'T', 'E', 'R', 'E', 'P', 'L', 'A', 'C', 'E', 'A', 'N', 'D', 'R', 'O',
    'P', 'A', 'R', 'T', 'I', 'T', 'I', 'O', 'N', 'A', 'U', 'T', 'O', 'I', 'N',
    'C', 'R', 'E', 'M', 'E', 'N', 'T', 'C', 'A', 'S', 'T', 'C', 'O', 'L', 'U',
    'M', 'N', 'C', 'O', 'M', 'M', 'I', 'T', 'C', 'O', 'N', 'F', 'L', 'I', 'C',
    'T', 'C', 'U', 'R', 'R', 'E', 'N', 'T', '_', 'T', 'I', 'M', 'E', 'S', 'T',
    'A', 'M', 'P', 'R', 'E', 'C', 'E', 'D', 'I', 'N', 'G', 'F', 'A', 'I', 'L',
    'A', 'S', 'T', 'F', 'I', 'L', 'T', 'E', 'R', 'E', 'S', 'T', 'R', 'I', 'C',
    'T', 'F', 'I', 'R', 'S', 'T', 'F', 'O', 'L', 'L', 'O', 'W', 'I', 'N', 'G',
    'F', 'R', 'O', 'M', 'F', 'U', 'L', 'L', 'I', 'M', 'I', 'T', 'F', 'U', 'N',
    'C', 'T', 'I', 'O', 'N', 'I', 'F', 'I', 'N', 'S', 'E', 'R', 'T', 'O', 'T',
    'H', 'E', 'R', 'S', 'O', 'V', 'E', 'R', 'E', 'T', 'U', 'R', 'N', 'I', 'N',
    'G', 'R', 'E', 'T', 'U', 'R', 'N', 'S', 'R', 'I', 'G', 'H', 'T', 'R', 'O',
    'L', 'L', 'B', 'A', 'C', 'K', 'R', 'O', 'W', 'S', 'U', 'N', 'B', 'O', 'U',
    'N', 'D', 'E', 'D', 'U', 'N', 'I', 'O', 'N', 'U', 'S', 'I', 'N', 'G', 'V',
    'A', 'C', 'U', 'U', 'M', 'V', 'I', 'E', 'W', 'I', 'N', 'D', 'O', 'W', 'B',
    'Y', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'L', 'Y', 'P', 'R', 'I', 'M', 'A',
    'R', 'Y',
};
/* aKWHash[i] is the hash value for the i-th keyword */
static const unsigned char aKWHash[127] = {
    135, 96,  141, 84,  112, 54,  6,   0,   98,  0,  88,  102, 0,   8,   17,
    90,  68,  0,   20,  101, 9,   93,  142, 16,  0,  0,   147, 0,   40,  127,
    89,  32,  114, 0,   28,  0,   0,   129, 82,  0,  80,  36,  0,   59,  110,
    154, 0,   143, 121, 0,   0,   75,  0,   94,  35, 0,   14,  0,   52,  64,
    13,  42,  5,   66,  149, 117, 128, 0,   103, 95, 71,  152, 67,  126, 104,
    0,   76,  0,   30,  48,  0,   57,  0,   0,   0,  116, 29,  118, 122, 131,
    33,  133, 130, 0,   107, 0,   15,  109, 151, 50, 136, 146, 92,  85,  24,
    55,  132, 0,   0,   115, 45,  137, 46,  0,   19, 0,   0,   138, 0,   105,
    25,  27,  0,   10,  72,  123, 97,
};
/* aKWNext[] forms the hash collision chain.  If aKWHash[i]==0
** then the i-th keyword has no more hash collisions.  Otherwise,
** the next keyword with the same hash is aKWHash[i]-1. */
static const unsigned char aKWNext[155] = {
    0,   0,  0,   0,   0,   4,  0, 0,   34,  65, 0,   0,  0,   0,   0,   150,
    139, 31, 0,   144, 140, 0,  0, 0,   0,   86, 0,   0,  0,   113, 120, 0,
    12,  0,  0,   0,   0,   21, 0, 7,   145, 0,  0,   0,  0,   0,   62,  0,
    0,   0,  47,  0,   148, 0,  0, 125, 0,   0,  0,   0,  0,   74,  0,   0,
    0,   0,  0,   0,   2,   0,  0, 0,   23,  0,  0,   53, 79,  0,   70,  0,
    1,   77, 0,   0,   0,   39, 0, 0,   0,   0,  0,   0,  0,   134, 0,   111,
    0,   58, 60,  63,  0,   0,  0, 153, 3,   0,  0,   0,  73,  61,  69,  38,
    0,   0,  0,   0,   0,   43, 0, 0,   0,   83, 108, 56, 119, 11,  37,  0,
    0,   81, 100, 124, 0,   44, 0, 0,   0,   87, 22,  0,  0,   49,  0,   78,
    0,   99, 26,  18,  51,  41, 0, 106, 0,   0,  91,
};
/* aKWLen[i] is the length (in bytes) of the i-th keyword */
static const unsigned char aKWLen[155] = {
    0, 7,  7, 5, 4, 6,  8,  6, 2, 3, 5, 4, 4,  3, 8,  2, 6, 4,  9, 9, 11, 6,  2,
    7, 3,  2, 5, 4, 6,  7,  3, 6, 6, 7, 7, 10, 4, 5,  3, 6, 4,  4, 7, 9,  10, 4,
    5, 5,  6, 7, 5, 9,  6,  9, 4, 2, 5, 5, 6,  5, 7,  4, 5, 10, 6, 6, 4,  5,  7,
    3, 6,  7, 7, 5, 7,  9,  6, 7, 3, 7, 4, 7,  6, 12, 9, 4, 5,  9, 5, 6,  4,  7,
    6, 12, 8, 8, 2, 6,  6,  7, 6, 4, 7, 6, 5,  5, 6,  5, 5, 7,  3, 4, 9,  13, 2,
    2, 4,  6, 6, 8, 17, 12, 7, 9, 4, 4, 6, 8,  5, 9,  4, 4, 5,  8, 2, 6,  6,  4,
    9, 7,  5, 8, 4, 3,  9,  5, 5, 6, 4, 6, 2,  2, 9,  3, 7,
};
/* aKWOffset[i] is the index into zKWText[] of the start of
** the text for the i-th keyword. */
static const unsigned short int aKWOffset[155] = {
    0,   0,   2,   2,   8,   9,   13,  20,  20,  23,  25,  28,  31,  33,  35,
    40,  41,  46,  49,  55,  63,  68,  72,  73,  73,  73,  76,  76,  81,  83,
    83,  87,  91,  94,  99,  104, 113, 115, 119, 122, 127, 130, 133, 138, 147,
    154, 157, 161, 165, 170, 176, 179, 187, 191, 191, 195, 200, 202, 207, 210,
    215, 215, 219, 223, 233, 238, 243, 246, 249, 254, 256, 262, 268, 273, 277,
    283, 291, 297, 298, 302, 309, 313, 320, 326, 338, 347, 349, 353, 362, 367,
    373, 375, 382, 386, 397, 404, 405, 412, 418, 424, 429, 435, 438, 444, 444,
    450, 453, 459, 464, 468, 475, 477, 480, 489, 491, 493, 502, 506, 512, 518,
    526, 526, 526, 542, 551, 554, 558, 563, 571, 576, 585, 589, 592, 597, 605,
    607, 613, 619, 622, 631, 638, 643, 651, 651, 655, 664, 669, 674, 680, 683,
    686, 689, 691, 696, 700,
};
/* aKWCode[i] is the parser symbol code for the i-th keyword */
static const unsigned char aKWCode[155] = {
    0,
    TK_REINDEX,
    TK_INDEXED,
    TK_INDEX,
    TK_DESC,
    TK_ESCAPE,
    TK_PERFETTO,
    TK_OFFSET,
    TK_OF,
    TK_SET,
    TK_TABLE,
    TK_JOIN_KW,
    TK_THEN,
    TK_END,
    TK_DATABASE,
    TK_AS,
    TK_SELECT,
    TK_TIES,
    TK_SAVEPOINT,
    TK_INTERSECT,
    TK_TRANSACTION,
    TK_ACTION,
    TK_ON,
    TK_NOTNULL,
    TK_NOT,
    TK_NO,
    TK_NULLS,
    TK_NULL,
    TK_BEFORE,
    TK_FOREIGN,
    TK_FOR,
    TK_IGNORE,
    TK_LIKE_KW,
    TK_EXPLAIN,
    TK_INCLUDE,
    TK_DEFERRABLE,
    TK_EACH,
    TK_CHECK,
    TK_KEY,
    TK_ISNULL,
    TK_LIKE_KW,
    TK_ELSE,
    TK_EXCLUDE,
    TK_DELEGATES,
    TK_CONSTRAINT,
    TK_INTO,
    TK_ORDER,
    TK_RAISE,
    TK_EXCEPT,
    TK_TRIGGER,
    TK_RANGE,
    TK_GENERATED,
    TK_DELETE,
    TK_TEMP,
    TK_TEMP,
    TK_OR,
    TK_MACRO,
    TK_JOIN_KW,
    TK_UNIQUE,
    TK_QUERY,
    TK_WITHOUT,
    TK_WITH,
    TK_JOIN_KW,
    TK_REFERENCES,
    TK_ATTACH,
    TK_HAVING,
    TK_LIKE_KW,
    TK_BEGIN,
    TK_INSTEAD,
    TK_ADD,
    TK_DETACH,
    TK_BETWEEN,
    TK_JOIN_KW,
    TK_ALTER,
    TK_RELEASE,
    TK_EXCLUSIVE,
    TK_EXISTS,
    TK_CASCADE,
    TK_ASC,
    TK_DEFAULT,
    TK_CASE,
    TK_COLLATE,
    TK_CREATE,
    TK_CTIME_KW,
    TK_IMMEDIATE,
    TK_JOIN,
    TK_JOIN_KW,
    TK_RECURSIVE,
    TK_MATCH,
    TK_MODULE,
    TK_PLAN,
    TK_ANALYZE,
    TK_PRAGMA,
    TK_MATERIALIZED,
    TK_DEFERRED,
    TK_DISTINCT,
    TK_IS,
    TK_UPDATE,
    TK_VALUES,
    TK_VIRTUAL,
    TK_ALWAYS,
    TK_WHEN,
    TK_NOTHING,
    TK_GROUPS,
    TK_GROUP,
    TK_WHERE,
    TK_RENAME,
    TK_ABORT,
    TK_AFTER,
    TK_REPLACE,
    TK_AND,
    TK_DROP,
    TK_PARTITION,
    TK_AUTOINCR,
    TK_TO,
    TK_IN,
    TK_CAST,
    TK_COLUMNKW,
    TK_COMMIT,
    TK_CONFLICT,
    TK_CTIME_KW,
    TK_CTIME_KW,
    TK_CURRENT,
    TK_PRECEDING,
    TK_FAIL,
    TK_LAST,
    TK_FILTER,
    TK_RESTRICT,
    TK_FIRST,
    TK_FOLLOWING,
    TK_FROM,
    TK_JOIN_KW,
    TK_LIMIT,
    TK_FUNCTION,
    TK_IF,
    TK_INSERT,
    TK_OTHERS,
    TK_OVER,
    TK_RETURNING,
    TK_RETURNS,
    TK_JOIN_KW,
    TK_ROLLBACK,
    TK_ROWS,
    TK_ROW,
    TK_UNBOUNDED,
    TK_UNION,
    TK_USING,
    TK_VACUUM,
    TK_VIEW,
    TK_WINDOW,
    TK_DO,
    TK_BY,
    TK_INITIALLY,
    TK_ALL,
    TK_PRIMARY,
};
/* Hash table decoded:
**   0: INSERT
**   1: IS
**   2: ROLLBACK TRIGGER
**   3: IMMEDIATE
**   4: PARTITION
**   5: TEMP
**   6: PERFETTO
**   7:
**   8: VALUES WITHOUT
**   9:
**  10: MATCH
**  11: NOTHING
**  12:
**  13: OF INCLUDE
**  14: TIES IGNORE
**  15: PLAN
**  16: INSTEAD INDEXED
**  17:
**  18: TRANSACTION RIGHT
**  19: WHEN
**  20: SET HAVING
**  21: MATERIALIZED IF
**  22: ROWS
**  23: SELECT RETURNS
**  24:
**  25:
**  26: VACUUM SAVEPOINT
**  27:
**  28: LIKE UNION VIRTUAL REFERENCES
**  29: RESTRICT
**  30: MODULE
**  31: REGEXP THEN
**  32: TO
**  33:
**  34: BEFORE
**  35:
**  36:
**  37: FOLLOWING COLLATE CASCADE
**  38: CREATE
**  39:
**  40: CASE REINDEX
**  41: EACH
**  42:
**  43: QUERY
**  44: AND ADD
**  45: PRIMARY ANALYZE
**  46:
**  47: ROW ASC DETACH
**  48: CURRENT_TIME CURRENT_DATE
**  49:
**  50:
**  51: EXCLUSIVE TEMPORARY
**  52:
**  53: DEFERRED
**  54: DEFERRABLE
**  55:
**  56: DATABASE
**  57:
**  58: DELETE VIEW GENERATED
**  59: ATTACH
**  60: END
**  61: EXCLUDE
**  62: ESCAPE DESC
**  63: GLOB
**  64: WINDOW ELSE
**  65: COLUMN DELEGATES
**  66: FIRST
**  67:
**  68: GROUPS ALL
**  69: DISTINCT DROP KEY
**  70: BETWEEN
**  71: INITIALLY
**  72: BEGIN
**  73: FILTER CHECK ACTION
**  74: GROUP INDEX
**  75:
**  76: EXISTS DEFAULT
**  77:
**  78: FOR CURRENT_TIMESTAMP
**  79: EXCEPT
**  80:
**  81: CROSS
**  82:
**  83:
**  84:
**  85: CAST
**  86: FOREIGN AUTOINCREMENT
**  87: COMMIT
**  88: CURRENT AFTER ALTER
**  89: FULL FAIL CONFLICT
**  90: EXPLAIN
**  91: FUNCTION CONSTRAINT
**  92: FROM ALWAYS
**  93:
**  94: ABORT
**  95:
**  96: AS DO
**  97: REPLACE WITH RELEASE
**  98: BY RENAME
**  99: RANGE RAISE
** 100: OTHERS
** 101: USING NULLS
** 102: PRAGMA
** 103: JOIN ISNULL OFFSET
** 104: NOT
** 105: OR LAST LEFT
** 106: LIMIT
** 107:
** 108:
** 109: IN
** 110: INTO
** 111: OVER RECURSIVE
** 112: ORDER OUTER
** 113:
** 114: INTERSECT UNBOUNDED
** 115:
** 116:
** 117: RETURNING ON
** 118:
** 119: WHERE
** 120: NO INNER
** 121: NULL
** 122:
** 123: TABLE
** 124: NATURAL NOTNULL
** 125: PRECEDING MACRO
** 126: UPDATE UNIQUE
*/
/* Check to see if z[0..n-1] is a keyword. If it is, write the
** parser symbol code for that keyword into *pType.  Always
** return the integer n (the length of the token). */
static int keywordCode(const char* z, int n, int* pType) {
  int i, j;
  const char* zKW;
  assert(n >= 2);
  i = ((charMap(z[0]) * 4) ^ (charMap(z[n - 1]) * 3) ^ n * 1) % 127;
  for (i = (int)aKWHash[i]; i > 0; i = aKWNext[i]) {
    if (aKWLen[i] != n)
      continue;
    zKW = &zKWText[aKWOffset[i]];
#ifdef SQLITE_ASCII
    if ((z[0] & ~0x20) != zKW[0])
      continue;
    if ((z[1] & ~0x20) != zKW[1])
      continue;
    j = 2;
    while (j < n && (z[j] & ~0x20) == zKW[j]) {
      j++;
    }
#endif
#ifdef SQLITE_EBCDIC
    if (toupper(z[0]) != zKW[0])
      continue;
    if (toupper(z[1]) != zKW[1])
      continue;
    j = 2;
    while (j < n && toupper(z[j]) == zKW[j]) {
      j++;
    }
#endif
    if (j < n)
      continue;
    testcase(i == 1);   /* REINDEX */
    testcase(i == 2);   /* INDEXED */
    testcase(i == 3);   /* INDEX */
    testcase(i == 4);   /* DESC */
    testcase(i == 5);   /* ESCAPE */
    testcase(i == 6);   /* PERFETTO */
    testcase(i == 7);   /* OFFSET */
    testcase(i == 8);   /* OF */
    testcase(i == 9);   /* SET */
    testcase(i == 10);  /* TABLE */
    testcase(i == 11);  /* LEFT */
    testcase(i == 12);  /* THEN */
    testcase(i == 13);  /* END */
    testcase(i == 14);  /* DATABASE */
    testcase(i == 15);  /* AS */
    testcase(i == 16);  /* SELECT */
    testcase(i == 17);  /* TIES */
    testcase(i == 18);  /* SAVEPOINT */
    testcase(i == 19);  /* INTERSECT */
    testcase(i == 20);  /* TRANSACTION */
    testcase(i == 21);  /* ACTION */
    testcase(i == 22);  /* ON */
    testcase(i == 23);  /* NOTNULL */
    testcase(i == 24);  /* NOT */
    testcase(i == 25);  /* NO */
    testcase(i == 26);  /* NULLS */
    testcase(i == 27);  /* NULL */
    testcase(i == 28);  /* BEFORE */
    testcase(i == 29);  /* FOREIGN */
    testcase(i == 30);  /* FOR */
    testcase(i == 31);  /* IGNORE */
    testcase(i == 32);  /* REGEXP */
    testcase(i == 33);  /* EXPLAIN */
    testcase(i == 34);  /* INCLUDE */
    testcase(i == 35);  /* DEFERRABLE */
    testcase(i == 36);  /* EACH */
    testcase(i == 37);  /* CHECK */
    testcase(i == 38);  /* KEY */
    testcase(i == 39);  /* ISNULL */
    testcase(i == 40);  /* LIKE */
    testcase(i == 41);  /* ELSE */
    testcase(i == 42);  /* EXCLUDE */
    testcase(i == 43);  /* DELEGATES */
    testcase(i == 44);  /* CONSTRAINT */
    testcase(i == 45);  /* INTO */
    testcase(i == 46);  /* ORDER */
    testcase(i == 47);  /* RAISE */
    testcase(i == 48);  /* EXCEPT */
    testcase(i == 49);  /* TRIGGER */
    testcase(i == 50);  /* RANGE */
    testcase(i == 51);  /* GENERATED */
    testcase(i == 52);  /* DELETE */
    testcase(i == 53);  /* TEMPORARY */
    testcase(i == 54);  /* TEMP */
    testcase(i == 55);  /* OR */
    testcase(i == 56);  /* MACRO */
    testcase(i == 57);  /* CROSS */
    testcase(i == 58);  /* UNIQUE */
    testcase(i == 59);  /* QUERY */
    testcase(i == 60);  /* WITHOUT */
    testcase(i == 61);  /* WITH */
    testcase(i == 62);  /* OUTER */
    testcase(i == 63);  /* REFERENCES */
    testcase(i == 64);  /* ATTACH */
    testcase(i == 65);  /* HAVING */
    testcase(i == 66);  /* GLOB */
    testcase(i == 67);  /* BEGIN */
    testcase(i == 68);  /* INSTEAD */
    testcase(i == 69);  /* ADD */
    testcase(i == 70);  /* DETACH */
    testcase(i == 71);  /* BETWEEN */
    testcase(i == 72);  /* NATURAL */
    testcase(i == 73);  /* ALTER */
    testcase(i == 74);  /* RELEASE */
    testcase(i == 75);  /* EXCLUSIVE */
    testcase(i == 76);  /* EXISTS */
    testcase(i == 77);  /* CASCADE */
    testcase(i == 78);  /* ASC */
    testcase(i == 79);  /* DEFAULT */
    testcase(i == 80);  /* CASE */
    testcase(i == 81);  /* COLLATE */
    testcase(i == 82);  /* CREATE */
    testcase(i == 83);  /* CURRENT_DATE */
    testcase(i == 84);  /* IMMEDIATE */
    testcase(i == 85);  /* JOIN */
    testcase(i == 86);  /* INNER */
    testcase(i == 87);  /* RECURSIVE */
    testcase(i == 88);  /* MATCH */
    testcase(i == 89);  /* MODULE */
    testcase(i == 90);  /* PLAN */
    testcase(i == 91);  /* ANALYZE */
    testcase(i == 92);  /* PRAGMA */
    testcase(i == 93);  /* MATERIALIZED */
    testcase(i == 94);  /* DEFERRED */
    testcase(i == 95);  /* DISTINCT */
    testcase(i == 96);  /* IS */
    testcase(i == 97);  /* UPDATE */
    testcase(i == 98);  /* VALUES */
    testcase(i == 99);  /* VIRTUAL */
    testcase(i == 100); /* ALWAYS */
    testcase(i == 101); /* WHEN */
    testcase(i == 102); /* NOTHING */
    testcase(i == 103); /* GROUPS */
    testcase(i == 104); /* GROUP */
    testcase(i == 105); /* WHERE */
    testcase(i == 106); /* RENAME */
    testcase(i == 107); /* ABORT */
    testcase(i == 108); /* AFTER */
    testcase(i == 109); /* REPLACE */
    testcase(i == 110); /* AND */
    testcase(i == 111); /* DROP */
    testcase(i == 112); /* PARTITION */
    testcase(i == 113); /* AUTOINCREMENT */
    testcase(i == 114); /* TO */
    testcase(i == 115); /* IN */
    testcase(i == 116); /* CAST */
    testcase(i == 117); /* COLUMN */
    testcase(i == 118); /* COMMIT */
    testcase(i == 119); /* CONFLICT */
    testcase(i == 120); /* CURRENT_TIMESTAMP */
    testcase(i == 121); /* CURRENT_TIME */
    testcase(i == 122); /* CURRENT */
    testcase(i == 123); /* PRECEDING */
    testcase(i == 124); /* FAIL */
    testcase(i == 125); /* LAST */
    testcase(i == 126); /* FILTER */
    testcase(i == 127); /* RESTRICT */
    testcase(i == 128); /* FIRST */
    testcase(i == 129); /* FOLLOWING */
    testcase(i == 130); /* FROM */
    testcase(i == 131); /* FULL */
    testcase(i == 132); /* LIMIT */
    testcase(i == 133); /* FUNCTION */
    testcase(i == 134); /* IF */
    testcase(i == 135); /* INSERT */
    testcase(i == 136); /* OTHERS */
    testcase(i == 137); /* OVER */
    testcase(i == 138); /* RETURNING */
    testcase(i == 139); /* RETURNS */
    testcase(i == 140); /* RIGHT */
    testcase(i == 141); /* ROLLBACK */
    testcase(i == 142); /* ROWS */
    testcase(i == 143); /* ROW */
    testcase(i == 144); /* UNBOUNDED */
    testcase(i == 145); /* UNION */
    testcase(i == 146); /* USING */
    testcase(i == 147); /* VACUUM */
    testcase(i == 148); /* VIEW */
    testcase(i == 149); /* WINDOW */
    testcase(i == 150); /* DO */
    testcase(i == 151); /* BY */
    testcase(i == 152); /* INITIALLY */
    testcase(i == 153); /* ALL */
    testcase(i == 154); /* PRIMARY */
    *pType = aKWCode[i];
    break;
  }
  return n;
}
int sqlite3KeywordCode(const unsigned char* z, int n) {
  int id = TK_ID;
  if (n >= 2)
    keywordCode((char*)z, n, &id);
  return id;
}
