# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Amount(msrest.serialization.Model):
    """The amount plus currency .

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar currency: Amount currency.
    :vartype currency: str
    :ivar value: Amount.
    :vartype value: float
    """

    _validation = {
        'currency': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'currency': {'key': 'currency', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Amount, self).__init__(**kwargs)
        self.currency = None
        self.value = None


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.tags = None


class Balance(Resource):
    """A balance resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar currency: The ISO currency in which the meter is charged, for example, USD.
    :vartype currency: str
    :ivar beginning_balance: The beginning balance for the billing period.
    :vartype beginning_balance: float
    :ivar ending_balance: The ending balance for the billing period (for open periods this will be
     updated daily).
    :vartype ending_balance: float
    :ivar new_purchases: Total new purchase amount.
    :vartype new_purchases: float
    :ivar adjustments: Total adjustment amount.
    :vartype adjustments: float
    :ivar utilized: Total Commitment usage.
    :vartype utilized: float
    :ivar service_overage: Overage for Azure services.
    :vartype service_overage: float
    :ivar charges_billed_separately: Charges Billed separately.
    :vartype charges_billed_separately: float
    :ivar total_overage: serviceOverage + chargesBilledSeparately.
    :vartype total_overage: float
    :ivar total_usage: Azure service commitment + total Overage.
    :vartype total_usage: float
    :ivar azure_marketplace_service_charges: Total charges for Azure Marketplace.
    :vartype azure_marketplace_service_charges: float
    :param billing_frequency: The billing frequency. Possible values include: "Month", "Quarter",
     "Year".
    :type billing_frequency: str or ~azure.mgmt.consumption.models.BillingFrequency
    :ivar price_hidden: Price is hidden or not.
    :vartype price_hidden: bool
    :ivar new_purchases_details: List of new purchases.
    :vartype new_purchases_details:
     list[~azure.mgmt.consumption.models.BalancePropertiesNewPurchasesDetailsItem]
    :ivar adjustment_details: List of Adjustments (Promo credit, SIE credit etc.).
    :vartype adjustment_details:
     list[~azure.mgmt.consumption.models.BalancePropertiesAdjustmentDetailsItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'currency': {'readonly': True},
        'beginning_balance': {'readonly': True},
        'ending_balance': {'readonly': True},
        'new_purchases': {'readonly': True},
        'adjustments': {'readonly': True},
        'utilized': {'readonly': True},
        'service_overage': {'readonly': True},
        'charges_billed_separately': {'readonly': True},
        'total_overage': {'readonly': True},
        'total_usage': {'readonly': True},
        'azure_marketplace_service_charges': {'readonly': True},
        'price_hidden': {'readonly': True},
        'new_purchases_details': {'readonly': True},
        'adjustment_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'beginning_balance': {'key': 'properties.beginningBalance', 'type': 'float'},
        'ending_balance': {'key': 'properties.endingBalance', 'type': 'float'},
        'new_purchases': {'key': 'properties.newPurchases', 'type': 'float'},
        'adjustments': {'key': 'properties.adjustments', 'type': 'float'},
        'utilized': {'key': 'properties.utilized', 'type': 'float'},
        'service_overage': {'key': 'properties.serviceOverage', 'type': 'float'},
        'charges_billed_separately': {'key': 'properties.chargesBilledSeparately', 'type': 'float'},
        'total_overage': {'key': 'properties.totalOverage', 'type': 'float'},
        'total_usage': {'key': 'properties.totalUsage', 'type': 'float'},
        'azure_marketplace_service_charges': {'key': 'properties.azureMarketplaceServiceCharges', 'type': 'float'},
        'billing_frequency': {'key': 'properties.billingFrequency', 'type': 'str'},
        'price_hidden': {'key': 'properties.priceHidden', 'type': 'bool'},
        'new_purchases_details': {'key': 'properties.newPurchasesDetails', 'type': '[BalancePropertiesNewPurchasesDetailsItem]'},
        'adjustment_details': {'key': 'properties.adjustmentDetails', 'type': '[BalancePropertiesAdjustmentDetailsItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Balance, self).__init__(**kwargs)
        self.currency = None
        self.beginning_balance = None
        self.ending_balance = None
        self.new_purchases = None
        self.adjustments = None
        self.utilized = None
        self.service_overage = None
        self.charges_billed_separately = None
        self.total_overage = None
        self.total_usage = None
        self.azure_marketplace_service_charges = None
        self.billing_frequency = kwargs.get('billing_frequency', None)
        self.price_hidden = None
        self.new_purchases_details = None
        self.adjustment_details = None


class BalancePropertiesAdjustmentDetailsItem(msrest.serialization.Model):
    """BalancePropertiesAdjustmentDetailsItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: the name of new adjustment.
    :vartype name: str
    :ivar value: the value of new adjustment.
    :vartype value: float
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BalancePropertiesAdjustmentDetailsItem, self).__init__(**kwargs)
        self.name = None
        self.value = None


class BalancePropertiesNewPurchasesDetailsItem(msrest.serialization.Model):
    """BalancePropertiesNewPurchasesDetailsItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: the name of new purchase.
    :vartype name: str
    :ivar value: the value of new purchase.
    :vartype value: float
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BalancePropertiesNewPurchasesDetailsItem, self).__init__(**kwargs)
        self.name = None
        self.value = None


class ProxyResource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :type e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.e_tag = kwargs.get('e_tag', None)


class Budget(ProxyResource):
    """A budget resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :type e_tag: str
    :param category: The category of the budget, whether the budget tracks cost or usage. Possible
     values include: "Cost".
    :type category: str or ~azure.mgmt.consumption.models.CategoryType
    :param amount: The total amount of cost to track with the budget.
    :type amount: float
    :param time_grain: The time covered by a budget. Tracking of the amount will be reset based on
     the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD
     customers. Possible values include: "Monthly", "Quarterly", "Annually", "BillingMonth",
     "BillingQuarter", "BillingAnnual".
    :type time_grain: str or ~azure.mgmt.consumption.models.TimeGrainType
    :param time_period: Has start and end date of the budget. The start date must be first of the
     month and should be less than the end date. Budget start date must be on or after June 1, 2017.
     Future start date should not be more than twelve months. Past start date should  be selected
     within the timegrain period. There are no restrictions on the end date.
    :type time_period: ~azure.mgmt.consumption.models.BudgetTimePeriod
    :param filter: May be used to filter budgets by resource group, resource, or meter.
    :type filter: ~azure.mgmt.consumption.models.BudgetFilter
    :ivar current_spend: The current amount of cost which is being tracked for a budget.
    :vartype current_spend: ~azure.mgmt.consumption.models.CurrentSpend
    :param notifications: Dictionary of notifications associated with the budget. Budget can have
     up to five notifications.
    :type notifications: dict[str, ~azure.mgmt.consumption.models.Notification]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'current_spend': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'amount': {'key': 'properties.amount', 'type': 'float'},
        'time_grain': {'key': 'properties.timeGrain', 'type': 'str'},
        'time_period': {'key': 'properties.timePeriod', 'type': 'BudgetTimePeriod'},
        'filter': {'key': 'properties.filter', 'type': 'BudgetFilter'},
        'current_spend': {'key': 'properties.currentSpend', 'type': 'CurrentSpend'},
        'notifications': {'key': 'properties.notifications', 'type': '{Notification}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Budget, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.amount = kwargs.get('amount', None)
        self.time_grain = kwargs.get('time_grain', None)
        self.time_period = kwargs.get('time_period', None)
        self.filter = kwargs.get('filter', None)
        self.current_spend = None
        self.notifications = kwargs.get('notifications', None)


class BudgetComparisonExpression(msrest.serialization.Model):
    """The comparison expression to be used in the budgets.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the column to use in comparison.
    :type name: str
    :param operator: Required. The operator to use for comparison. Possible values include: "In".
    :type operator: str or ~azure.mgmt.consumption.models.BudgetOperatorType
    :param values: Required. Array of values to use for comparison.
    :type values: list[str]
    """

    _validation = {
        'name': {'required': True},
        'operator': {'required': True},
        'values': {'required': True, 'min_items': 1},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BudgetComparisonExpression, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.operator = kwargs['operator']
        self.values = kwargs['values']


class BudgetFilter(msrest.serialization.Model):
    """May be used to filter budgets by resource group, resource, or meter.

    :param and_property: The logical "AND" expression. Must have at least 2 items.
    :type and_property: list[~azure.mgmt.consumption.models.BudgetFilterProperties]
    :param not_property: The logical "NOT" expression.
    :type not_property: ~azure.mgmt.consumption.models.BudgetFilterProperties
    :param dimensions: Has comparison expression for a dimension.
    :type dimensions: ~azure.mgmt.consumption.models.BudgetComparisonExpression
    :param tags: A set of tags. Has comparison expression for a tag.
    :type tags: ~azure.mgmt.consumption.models.BudgetComparisonExpression
    """

    _validation = {
        'and_property': {'min_items': 2},
    }

    _attribute_map = {
        'and_property': {'key': 'and', 'type': '[BudgetFilterProperties]'},
        'not_property': {'key': 'not', 'type': 'BudgetFilterProperties'},
        'dimensions': {'key': 'dimensions', 'type': 'BudgetComparisonExpression'},
        'tags': {'key': 'tags', 'type': 'BudgetComparisonExpression'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BudgetFilter, self).__init__(**kwargs)
        self.and_property = kwargs.get('and_property', None)
        self.not_property = kwargs.get('not_property', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.tags = kwargs.get('tags', None)


class BudgetFilterProperties(msrest.serialization.Model):
    """The Dimensions or Tags to filter a budget by.

    :param dimensions: Has comparison expression for a dimension.
    :type dimensions: ~azure.mgmt.consumption.models.BudgetComparisonExpression
    :param tags: A set of tags. Has comparison expression for a tag.
    :type tags: ~azure.mgmt.consumption.models.BudgetComparisonExpression
    """

    _attribute_map = {
        'dimensions': {'key': 'dimensions', 'type': 'BudgetComparisonExpression'},
        'tags': {'key': 'tags', 'type': 'BudgetComparisonExpression'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BudgetFilterProperties, self).__init__(**kwargs)
        self.dimensions = kwargs.get('dimensions', None)
        self.tags = kwargs.get('tags', None)


class BudgetsListResult(msrest.serialization.Model):
    """Result of listing budgets. It contains a list of available budgets in the scope provided.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of budgets.
    :vartype value: list[~azure.mgmt.consumption.models.Budget]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Budget]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BudgetsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class BudgetTimePeriod(msrest.serialization.Model):
    """The start and end date for a budget.

    All required parameters must be populated in order to send to Azure.

    :param start_date: Required. The start date for the budget.
    :type start_date: ~datetime.datetime
    :param end_date: The end date for the budget. If not provided, we default this to 10 years from
     the start date.
    :type end_date: ~datetime.datetime
    """

    _validation = {
        'start_date': {'required': True},
    }

    _attribute_map = {
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BudgetTimePeriod, self).__init__(**kwargs)
        self.start_date = kwargs['start_date']
        self.end_date = kwargs.get('end_date', None)


class ChargesListResult(msrest.serialization.Model):
    """Result of listing charge summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of charge summary.
    :vartype value: list[~azure.mgmt.consumption.models.ChargeSummary]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ChargeSummary]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ChargesListResult, self).__init__(**kwargs)
        self.value = None


class ChargeSummary(Resource):
    """A charge summary resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LegacyChargeSummary, ModernChargeSummary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of charge summary.Constant filled by server.
     Possible values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.ChargeSummaryKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'legacy': 'LegacyChargeSummary', 'modern': 'ModernChargeSummary'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ChargeSummary, self).__init__(**kwargs)
        self.kind = 'ChargeSummary'  # type: str


class CreditBalanceSummary(msrest.serialization.Model):
    """Summary of credit balances.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar estimated_balance: Estimated balance.
    :vartype estimated_balance: ~azure.mgmt.consumption.models.Amount
    :ivar current_balance: Current balance.
    :vartype current_balance: ~azure.mgmt.consumption.models.Amount
    """

    _validation = {
        'estimated_balance': {'readonly': True},
        'current_balance': {'readonly': True},
    }

    _attribute_map = {
        'estimated_balance': {'key': 'estimatedBalance', 'type': 'Amount'},
        'current_balance': {'key': 'currentBalance', 'type': 'Amount'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreditBalanceSummary, self).__init__(**kwargs)
        self.estimated_balance = None
        self.current_balance = None


class CreditSummary(Resource):
    """A credit summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar balance_summary: Summary of balances associated with this credit summary.
    :vartype balance_summary: ~azure.mgmt.consumption.models.CreditBalanceSummary
    :ivar pending_credit_adjustments: Pending credit adjustments.
    :vartype pending_credit_adjustments: ~azure.mgmt.consumption.models.Amount
    :ivar expired_credit: Expired credit.
    :vartype expired_credit: ~azure.mgmt.consumption.models.Amount
    :ivar pending_eligible_charges: Pending eligible charges.
    :vartype pending_eligible_charges: ~azure.mgmt.consumption.models.Amount
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'balance_summary': {'readonly': True},
        'pending_credit_adjustments': {'readonly': True},
        'expired_credit': {'readonly': True},
        'pending_eligible_charges': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'balance_summary': {'key': 'properties.balanceSummary', 'type': 'CreditBalanceSummary'},
        'pending_credit_adjustments': {'key': 'properties.pendingCreditAdjustments', 'type': 'Amount'},
        'expired_credit': {'key': 'properties.expiredCredit', 'type': 'Amount'},
        'pending_eligible_charges': {'key': 'properties.pendingEligibleCharges', 'type': 'Amount'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreditSummary, self).__init__(**kwargs)
        self.balance_summary = None
        self.pending_credit_adjustments = None
        self.expired_credit = None
        self.pending_eligible_charges = None


class CurrentSpend(msrest.serialization.Model):
    """The current amount of cost which is being tracked for a budget.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar amount: The total amount of cost which is being tracked by the budget.
    :vartype amount: float
    :ivar unit: The unit of measure for the budget amount.
    :vartype unit: str
    """

    _validation = {
        'amount': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'amount': {'key': 'amount', 'type': 'float'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CurrentSpend, self).__init__(**kwargs)
        self.amount = None
        self.unit = None


class ErrorDetails(msrest.serialization.Model):
    """The details of the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.message = None


class ErrorResponse(msrest.serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The reason is provided in the error message. 

Some Error responses: 


* 
  429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after" header. 

* 
  503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After" header.

    :param error: The details of the error.
    :type error: ~azure.mgmt.consumption.models.ErrorDetails
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class Events(msrest.serialization.Model):
    """Result of listing event summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of event summary.
    :vartype value: list[~azure.mgmt.consumption.models.EventSummary]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Events, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class EventSummary(Resource):
    """An event summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar transaction_date: Transaction date.
    :vartype transaction_date: ~datetime.datetime
    :ivar description: Transaction description.
    :vartype description: str
    :ivar new_credit: New Credit.
    :vartype new_credit: ~azure.mgmt.consumption.models.Amount
    :ivar adjustments: Adjustments amount.
    :vartype adjustments: ~azure.mgmt.consumption.models.Amount
    :ivar credit_expired: Credit expired.
    :vartype credit_expired: ~azure.mgmt.consumption.models.Amount
    :ivar charges: Charges amount.
    :vartype charges: ~azure.mgmt.consumption.models.Amount
    :ivar closed_balance: Closed balance.
    :vartype closed_balance: ~azure.mgmt.consumption.models.Amount
    :param event_type: The type of event. Possible values include: "SettledCharges",
     "PendingCharges", "PendingAdjustments", "PendingNewCredit", "PendingExpiredCredit", "UnKnown",
     "NewCredit".
    :type event_type: str or ~azure.mgmt.consumption.models.EventType
    :ivar invoice_number: Invoice number.
    :vartype invoice_number: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'transaction_date': {'readonly': True},
        'description': {'readonly': True},
        'new_credit': {'readonly': True},
        'adjustments': {'readonly': True},
        'credit_expired': {'readonly': True},
        'charges': {'readonly': True},
        'closed_balance': {'readonly': True},
        'invoice_number': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'transaction_date': {'key': 'properties.transactionDate', 'type': 'iso-8601'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'new_credit': {'key': 'properties.newCredit', 'type': 'Amount'},
        'adjustments': {'key': 'properties.adjustments', 'type': 'Amount'},
        'credit_expired': {'key': 'properties.creditExpired', 'type': 'Amount'},
        'charges': {'key': 'properties.charges', 'type': 'Amount'},
        'closed_balance': {'key': 'properties.closedBalance', 'type': 'Amount'},
        'event_type': {'key': 'properties.eventType', 'type': 'str'},
        'invoice_number': {'key': 'properties.invoiceNumber', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSummary, self).__init__(**kwargs)
        self.transaction_date = None
        self.description = None
        self.new_credit = None
        self.adjustments = None
        self.credit_expired = None
        self.charges = None
        self.closed_balance = None
        self.event_type = kwargs.get('event_type', None)
        self.invoice_number = None


class Forecast(Resource):
    """A forecast resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar usage_date: The usage date of the forecast.
    :vartype usage_date: str
    :param grain: The granularity of forecast. Possible values include: "Daily", "Monthly",
     "Yearly".
    :type grain: str or ~azure.mgmt.consumption.models.Grain
    :ivar charge: The amount of charge.
    :vartype charge: float
    :ivar currency: The ISO currency in which the meter is charged, for example, USD.
    :vartype currency: str
    :param charge_type: The type of the charge. Could be actual or forecast. Possible values
     include: "Actual", "Forecast".
    :type charge_type: str or ~azure.mgmt.consumption.models.ChargeType
    :ivar confidence_levels: The details about the forecast confidence levels. This is populated
     only when chargeType is Forecast.
    :vartype confidence_levels:
     list[~azure.mgmt.consumption.models.ForecastPropertiesConfidenceLevelsItem]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'usage_date': {'readonly': True},
        'charge': {'readonly': True},
        'currency': {'readonly': True},
        'confidence_levels': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'usage_date': {'key': 'properties.usageDate', 'type': 'str'},
        'grain': {'key': 'properties.grain', 'type': 'str'},
        'charge': {'key': 'properties.charge', 'type': 'float'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'charge_type': {'key': 'properties.chargeType', 'type': 'str'},
        'confidence_levels': {'key': 'properties.confidenceLevels', 'type': '[ForecastPropertiesConfidenceLevelsItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Forecast, self).__init__(**kwargs)
        self.usage_date = None
        self.grain = kwargs.get('grain', None)
        self.charge = None
        self.currency = None
        self.charge_type = kwargs.get('charge_type', None)
        self.confidence_levels = None


class ForecastPropertiesConfidenceLevelsItem(msrest.serialization.Model):
    """ForecastPropertiesConfidenceLevelsItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar percentage: The percentage level of the confidence.
    :vartype percentage: float
    :param bound: The boundary of the percentage, values could be 'Upper' or 'Lower'. Possible
     values include: "Upper", "Lower".
    :type bound: str or ~azure.mgmt.consumption.models.Bound
    :ivar value: The amount of forecast within the percentage level.
    :vartype value: float
    """

    _validation = {
        'percentage': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'percentage': {'key': 'percentage', 'type': 'float'},
        'bound': {'key': 'bound', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ForecastPropertiesConfidenceLevelsItem, self).__init__(**kwargs)
        self.percentage = None
        self.bound = kwargs.get('bound', None)
        self.value = None


class ForecastsListResult(msrest.serialization.Model):
    """Result of listing forecasts. It contains a list of available forecasts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of forecasts.
    :vartype value: list[~azure.mgmt.consumption.models.Forecast]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Forecast]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ForecastsListResult, self).__init__(**kwargs)
        self.value = None


class LegacyChargeSummary(ChargeSummary):
    """Legacy charge summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of charge summary.Constant filled by server.
     Possible values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.ChargeSummaryKind
    :ivar billing_period_id: The id of the billing period resource that the charge belongs to.
    :vartype billing_period_id: str
    :ivar usage_start: Usage start date.
    :vartype usage_start: str
    :ivar usage_end: Usage end date.
    :vartype usage_end: str
    :ivar azure_charges: Azure Charges.
    :vartype azure_charges: float
    :ivar charges_billed_separately: Charges Billed separately.
    :vartype charges_billed_separately: float
    :ivar marketplace_charges: Marketplace Charges.
    :vartype marketplace_charges: float
    :ivar currency: Currency Code.
    :vartype currency: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
        'billing_period_id': {'readonly': True},
        'usage_start': {'readonly': True},
        'usage_end': {'readonly': True},
        'azure_charges': {'readonly': True},
        'charges_billed_separately': {'readonly': True},
        'marketplace_charges': {'readonly': True},
        'currency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'billing_period_id': {'key': 'properties.billingPeriodId', 'type': 'str'},
        'usage_start': {'key': 'properties.usageStart', 'type': 'str'},
        'usage_end': {'key': 'properties.usageEnd', 'type': 'str'},
        'azure_charges': {'key': 'properties.azureCharges', 'type': 'float'},
        'charges_billed_separately': {'key': 'properties.chargesBilledSeparately', 'type': 'float'},
        'marketplace_charges': {'key': 'properties.marketplaceCharges', 'type': 'float'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LegacyChargeSummary, self).__init__(**kwargs)
        self.kind = 'legacy'  # type: str
        self.billing_period_id = None
        self.usage_start = None
        self.usage_end = None
        self.azure_charges = None
        self.charges_billed_separately = None
        self.marketplace_charges = None
        self.currency = None


class ResourceAttributes(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Resource sku.
    :vartype sku: str
    """

    _validation = {
        'location': {'readonly': True},
        'sku': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceAttributes, self).__init__(**kwargs)
        self.location = None
        self.sku = None


class ReservationRecommendation(Resource, ResourceAttributes):
    """A reservation recommendation resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LegacyReservationRecommendation, ModernReservationRecommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Resource sku.
    :vartype sku: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of reservation recommendation.Constant filled by
     server.  Possible values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.ReservationRecommendationKind
    """

    _validation = {
        'location': {'readonly': True},
        'sku': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'legacy': 'LegacyReservationRecommendation', 'modern': 'ModernReservationRecommendation'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationRecommendation, self).__init__(**kwargs)
        self.location = None
        self.sku = None
        self.kind = 'ReservationRecommendation'  # type: str
        self.id = None
        self.name = None
        self.type = None
        self.tags = None
        self.kind = 'ReservationRecommendation'  # type: str


class LegacyReservationRecommendation(ReservationRecommendation):
    """Legacy reservation recommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Resource sku.
    :vartype sku: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of reservation recommendation.Constant filled by
     server.  Possible values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.ReservationRecommendationKind
    :ivar look_back_period: The number of days of usage to look back for recommendation.
    :vartype look_back_period: str
    :ivar instance_flexibility_ratio: The instance Flexibility Ratio.
    :vartype instance_flexibility_ratio: int
    :ivar instance_flexibility_group: The instance Flexibility Group.
    :vartype instance_flexibility_group: str
    :ivar normalized_size: The normalized Size.
    :vartype normalized_size: str
    :ivar recommended_quantity_normalized: The recommended Quantity Normalized.
    :vartype recommended_quantity_normalized: float
    :ivar meter_id: The meter id (GUID).
    :vartype meter_id: str
    :ivar term: RI recommendations in one or three year terms.
    :vartype term: str
    :ivar cost_with_no_reserved_instances: The total amount of cost without reserved instances.
    :vartype cost_with_no_reserved_instances: float
    :ivar recommended_quantity: Recommended quality for reserved instances.
    :vartype recommended_quantity: float
    :ivar total_cost_with_reserved_instances: The total amount of cost with reserved instances.
    :vartype total_cost_with_reserved_instances: float
    :ivar net_savings: Total estimated savings with reserved instances.
    :vartype net_savings: float
    :ivar first_usage_date: The usage date for looking back.
    :vartype first_usage_date: ~datetime.datetime
    :ivar scope: Shared or single recommendation.
    :vartype scope: str
    :ivar sku_properties: List of sku properties.
    :vartype sku_properties: list[~azure.mgmt.consumption.models.SkuProperty]
    """

    _validation = {
        'location': {'readonly': True},
        'sku': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
        'look_back_period': {'readonly': True},
        'instance_flexibility_ratio': {'readonly': True},
        'instance_flexibility_group': {'readonly': True},
        'normalized_size': {'readonly': True},
        'recommended_quantity_normalized': {'readonly': True},
        'meter_id': {'readonly': True},
        'term': {'readonly': True},
        'cost_with_no_reserved_instances': {'readonly': True},
        'recommended_quantity': {'readonly': True},
        'total_cost_with_reserved_instances': {'readonly': True},
        'net_savings': {'readonly': True},
        'first_usage_date': {'readonly': True},
        'scope': {'readonly': True},
        'sku_properties': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'look_back_period': {'key': 'properties.lookBackPeriod', 'type': 'str'},
        'instance_flexibility_ratio': {'key': 'properties.instanceFlexibilityRatio', 'type': 'int'},
        'instance_flexibility_group': {'key': 'properties.instanceFlexibilityGroup', 'type': 'str'},
        'normalized_size': {'key': 'properties.normalizedSize', 'type': 'str'},
        'recommended_quantity_normalized': {'key': 'properties.recommendedQuantityNormalized', 'type': 'float'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'cost_with_no_reserved_instances': {'key': 'properties.costWithNoReservedInstances', 'type': 'float'},
        'recommended_quantity': {'key': 'properties.recommendedQuantity', 'type': 'float'},
        'total_cost_with_reserved_instances': {'key': 'properties.totalCostWithReservedInstances', 'type': 'float'},
        'net_savings': {'key': 'properties.netSavings', 'type': 'float'},
        'first_usage_date': {'key': 'properties.firstUsageDate', 'type': 'iso-8601'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'sku_properties': {'key': 'properties.skuProperties', 'type': '[SkuProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LegacyReservationRecommendation, self).__init__(**kwargs)
        self.kind = 'legacy'  # type: str
        self.look_back_period = None
        self.instance_flexibility_ratio = None
        self.instance_flexibility_group = None
        self.normalized_size = None
        self.recommended_quantity_normalized = None
        self.meter_id = None
        self.term = None
        self.cost_with_no_reserved_instances = None
        self.recommended_quantity = None
        self.total_cost_with_reserved_instances = None
        self.net_savings = None
        self.first_usage_date = None
        self.scope = None
        self.sku_properties = None


class ReservationTransaction(Resource):
    """Reservation transaction resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar event_date: The date of the transaction.
    :vartype event_date: ~datetime.datetime
    :ivar reservation_order_id: The reservation order ID is the identifier for a reservation
     purchase. Each reservation order ID represents a single purchase transaction. A reservation
     order contains reservations. The reservation order specifies the VM size and region for the
     reservations.
    :vartype reservation_order_id: str
    :ivar description: The description of the transaction.
    :vartype description: str
    :ivar event_type: The type of the transaction (Purchase, Cancel, etc.).
    :vartype event_type: str
    :ivar quantity: The quantity of the transaction.
    :vartype quantity: float
    :ivar amount: The charge of the transaction.
    :vartype amount: float
    :ivar currency: The ISO currency in which the transaction is charged, for example, USD.
    :vartype currency: str
    :ivar reservation_order_name: The name of the reservation order.
    :vartype reservation_order_name: str
    :ivar purchasing_enrollment: The purchasing enrollment.
    :vartype purchasing_enrollment: str
    :ivar purchasing_subscription_guid: The subscription guid that makes the transaction.
    :vartype purchasing_subscription_guid: str
    :ivar purchasing_subscription_name: The subscription name that makes the transaction.
    :vartype purchasing_subscription_name: str
    :ivar arm_sku_name: This is the ARM Sku name. It can be used to join with the serviceType field
     in additional info in usage records.
    :vartype arm_sku_name: str
    :ivar term: This is the term of the transaction.
    :vartype term: str
    :ivar region: The region of the transaction.
    :vartype region: str
    :ivar account_name: The name of the account that makes the transaction.
    :vartype account_name: str
    :ivar account_owner_email: The email of the account owner that makes the transaction.
    :vartype account_owner_email: str
    :ivar department_name: The department name.
    :vartype department_name: str
    :ivar cost_center: The cost center of this department if it is a department and a cost center
     is provided.
    :vartype cost_center: str
    :ivar current_enrollment: The current enrollment.
    :vartype current_enrollment: str
    :ivar billing_frequency: The billing frequency, which can be either one-time or recurring.
    :vartype billing_frequency: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'event_date': {'readonly': True},
        'reservation_order_id': {'readonly': True},
        'description': {'readonly': True},
        'event_type': {'readonly': True},
        'quantity': {'readonly': True},
        'amount': {'readonly': True},
        'currency': {'readonly': True},
        'reservation_order_name': {'readonly': True},
        'purchasing_enrollment': {'readonly': True},
        'purchasing_subscription_guid': {'readonly': True},
        'purchasing_subscription_name': {'readonly': True},
        'arm_sku_name': {'readonly': True},
        'term': {'readonly': True},
        'region': {'readonly': True},
        'account_name': {'readonly': True},
        'account_owner_email': {'readonly': True},
        'department_name': {'readonly': True},
        'cost_center': {'readonly': True},
        'current_enrollment': {'readonly': True},
        'billing_frequency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'event_date': {'key': 'properties.eventDate', 'type': 'iso-8601'},
        'reservation_order_id': {'key': 'properties.reservationOrderId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'event_type': {'key': 'properties.eventType', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'float'},
        'amount': {'key': 'properties.amount', 'type': 'float'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'reservation_order_name': {'key': 'properties.reservationOrderName', 'type': 'str'},
        'purchasing_enrollment': {'key': 'properties.purchasingEnrollment', 'type': 'str'},
        'purchasing_subscription_guid': {'key': 'properties.purchasingSubscriptionGuid', 'type': 'str'},
        'purchasing_subscription_name': {'key': 'properties.purchasingSubscriptionName', 'type': 'str'},
        'arm_sku_name': {'key': 'properties.armSkuName', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'region': {'key': 'properties.region', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'account_owner_email': {'key': 'properties.accountOwnerEmail', 'type': 'str'},
        'department_name': {'key': 'properties.departmentName', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'current_enrollment': {'key': 'properties.currentEnrollment', 'type': 'str'},
        'billing_frequency': {'key': 'properties.billingFrequency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationTransaction, self).__init__(**kwargs)
        self.event_date = None
        self.reservation_order_id = None
        self.description = None
        self.event_type = None
        self.quantity = None
        self.amount = None
        self.currency = None
        self.reservation_order_name = None
        self.purchasing_enrollment = None
        self.purchasing_subscription_guid = None
        self.purchasing_subscription_name = None
        self.arm_sku_name = None
        self.term = None
        self.region = None
        self.account_name = None
        self.account_owner_email = None
        self.department_name = None
        self.cost_center = None
        self.current_enrollment = None
        self.billing_frequency = None


class LegacyReservationTransaction(ReservationTransaction):
    """Legacy Reservation transaction resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar event_date: The date of the transaction.
    :vartype event_date: ~datetime.datetime
    :ivar reservation_order_id: The reservation order ID is the identifier for a reservation
     purchase. Each reservation order ID represents a single purchase transaction. A reservation
     order contains reservations. The reservation order specifies the VM size and region for the
     reservations.
    :vartype reservation_order_id: str
    :ivar description: The description of the transaction.
    :vartype description: str
    :ivar event_type: The type of the transaction (Purchase, Cancel, etc.).
    :vartype event_type: str
    :ivar quantity: The quantity of the transaction.
    :vartype quantity: float
    :ivar amount: The charge of the transaction.
    :vartype amount: float
    :ivar currency: The ISO currency in which the transaction is charged, for example, USD.
    :vartype currency: str
    :ivar reservation_order_name: The name of the reservation order.
    :vartype reservation_order_name: str
    :ivar purchasing_enrollment: The purchasing enrollment.
    :vartype purchasing_enrollment: str
    :ivar purchasing_subscription_guid: The subscription guid that makes the transaction.
    :vartype purchasing_subscription_guid: str
    :ivar purchasing_subscription_name: The subscription name that makes the transaction.
    :vartype purchasing_subscription_name: str
    :ivar arm_sku_name: This is the ARM Sku name. It can be used to join with the serviceType field
     in additional info in usage records.
    :vartype arm_sku_name: str
    :ivar term: This is the term of the transaction.
    :vartype term: str
    :ivar region: The region of the transaction.
    :vartype region: str
    :ivar account_name: The name of the account that makes the transaction.
    :vartype account_name: str
    :ivar account_owner_email: The email of the account owner that makes the transaction.
    :vartype account_owner_email: str
    :ivar department_name: The department name.
    :vartype department_name: str
    :ivar cost_center: The cost center of this department if it is a department and a cost center
     is provided.
    :vartype cost_center: str
    :ivar current_enrollment: The current enrollment.
    :vartype current_enrollment: str
    :ivar billing_frequency: The billing frequency, which can be either one-time or recurring.
    :vartype billing_frequency: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'event_date': {'readonly': True},
        'reservation_order_id': {'readonly': True},
        'description': {'readonly': True},
        'event_type': {'readonly': True},
        'quantity': {'readonly': True},
        'amount': {'readonly': True},
        'currency': {'readonly': True},
        'reservation_order_name': {'readonly': True},
        'purchasing_enrollment': {'readonly': True},
        'purchasing_subscription_guid': {'readonly': True},
        'purchasing_subscription_name': {'readonly': True},
        'arm_sku_name': {'readonly': True},
        'term': {'readonly': True},
        'region': {'readonly': True},
        'account_name': {'readonly': True},
        'account_owner_email': {'readonly': True},
        'department_name': {'readonly': True},
        'cost_center': {'readonly': True},
        'current_enrollment': {'readonly': True},
        'billing_frequency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'event_date': {'key': 'properties.eventDate', 'type': 'iso-8601'},
        'reservation_order_id': {'key': 'properties.reservationOrderId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'event_type': {'key': 'properties.eventType', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'float'},
        'amount': {'key': 'properties.amount', 'type': 'float'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'reservation_order_name': {'key': 'properties.reservationOrderName', 'type': 'str'},
        'purchasing_enrollment': {'key': 'properties.purchasingEnrollment', 'type': 'str'},
        'purchasing_subscription_guid': {'key': 'properties.purchasingSubscriptionGuid', 'type': 'str'},
        'purchasing_subscription_name': {'key': 'properties.purchasingSubscriptionName', 'type': 'str'},
        'arm_sku_name': {'key': 'properties.armSkuName', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'region': {'key': 'properties.region', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'account_owner_email': {'key': 'properties.accountOwnerEmail', 'type': 'str'},
        'department_name': {'key': 'properties.departmentName', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'current_enrollment': {'key': 'properties.currentEnrollment', 'type': 'str'},
        'billing_frequency': {'key': 'properties.billingFrequency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LegacyReservationTransaction, self).__init__(**kwargs)


class UsageDetail(Resource):
    """An usage detail resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LegacyUsageDetail, ModernUsageDetail.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of usage details.Constant filled by server.  Possible
     values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.UsageDetailsKind
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'legacy': 'LegacyUsageDetail', 'modern': 'ModernUsageDetail'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageDetail, self).__init__(**kwargs)
        self.kind = 'UsageDetail'  # type: str


class LegacyUsageDetail(UsageDetail):
    """Legacy usage detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of usage details.Constant filled by server.  Possible
     values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.UsageDetailsKind
    :ivar billing_account_id: Billing Account identifier.
    :vartype billing_account_id: str
    :ivar billing_account_name: Billing Account Name.
    :vartype billing_account_name: str
    :ivar billing_period_start_date: The billing period start date.
    :vartype billing_period_start_date: ~datetime.datetime
    :ivar billing_period_end_date: The billing period end date.
    :vartype billing_period_end_date: ~datetime.datetime
    :ivar billing_profile_id: Billing Profile identifier.
    :vartype billing_profile_id: str
    :ivar billing_profile_name: Billing Profile Name.
    :vartype billing_profile_name: str
    :ivar account_owner_id: Account Owner Id.
    :vartype account_owner_id: str
    :ivar account_name: Account Name.
    :vartype account_name: str
    :ivar subscription_id: Subscription guid.
    :vartype subscription_id: str
    :ivar subscription_name: Subscription name.
    :vartype subscription_name: str
    :ivar date: Date for the usage record.
    :vartype date: ~datetime.datetime
    :ivar product: Product name for the consumed service or purchase. Not available for
     Marketplace.
    :vartype product: str
    :ivar part_number: Part Number of the service used. Can be used to join with the price sheet.
     Not available for marketplace.
    :vartype part_number: str
    :ivar meter_id: The meter id (GUID). Not available for marketplace. For reserved instance this
     represents the primary meter for which the reservation was purchased. For the actual VM Size
     for which the reservation is purchased see productOrderName.
    :vartype meter_id: str
    :ivar meter_details: The details about the meter. By default this is not populated, unless it's
     specified in $expand.
    :vartype meter_details: ~azure.mgmt.consumption.models.MeterDetailsResponse
    :ivar quantity: The usage quantity.
    :vartype quantity: float
    :ivar effective_price: Effective Price that's charged for the usage.
    :vartype effective_price: float
    :ivar cost: The amount of cost before tax.
    :vartype cost: float
    :ivar unit_price: Unit Price is the price applicable to you. (your EA or other contract price).
    :vartype unit_price: float
    :ivar billing_currency: Billing Currency.
    :vartype billing_currency: str
    :ivar resource_location: Resource Location.
    :vartype resource_location: str
    :ivar consumed_service: Consumed service name. Name of the azure resource provider that emits
     the usage or was purchased. This value is not provided for marketplace usage.
    :vartype consumed_service: str
    :ivar resource_id: Azure resource manager resource identifier.
    :vartype resource_id: str
    :ivar resource_name: Resource Name.
    :vartype resource_name: str
    :ivar service_info1: Service Info 1.
    :vartype service_info1: str
    :ivar service_info2: Service Info 2.
    :vartype service_info2: str
    :ivar additional_info: Additional details of this usage item. By default this is not populated,
     unless it's specified in $expand. Use this field to get usage line item specific details such
     as the actual VM Size (ServiceType) or the ratio in which the reservation discount is applied.
    :vartype additional_info: str
    :ivar invoice_section: Invoice Section Name.
    :vartype invoice_section: str
    :ivar cost_center: The cost center of this department if it is a department and a cost center
     is provided.
    :vartype cost_center: str
    :ivar resource_group: Resource Group Name.
    :vartype resource_group: str
    :ivar reservation_id: ARM resource id of the reservation. Only applies to records relevant to
     reservations.
    :vartype reservation_id: str
    :ivar reservation_name: User provided display name of the reservation. Last known name for a
     particular day is populated in the daily data. Only applies to records relevant to
     reservations.
    :vartype reservation_name: str
    :ivar product_order_id: Product Order Id. For reservations this is the Reservation Order ID.
    :vartype product_order_id: str
    :ivar product_order_name: Product Order Name. For reservations this is the SKU that was
     purchased.
    :vartype product_order_name: str
    :ivar offer_id: Offer Id. Ex: MS-AZR-0017P, MS-AZR-0148P.
    :vartype offer_id: str
    :ivar is_azure_credit_eligible: Is Azure Credit Eligible.
    :vartype is_azure_credit_eligible: bool
    :ivar term: Term (in months). 1 month for monthly recurring purchase. 12 months for a 1 year
     reservation. 36 months for a 3 year reservation.
    :vartype term: str
    :ivar publisher_name: Publisher Name.
    :vartype publisher_name: str
    :ivar publisher_type: Publisher Type.
    :vartype publisher_type: str
    :ivar plan_name: Plan Name.
    :vartype plan_name: str
    :ivar charge_type: Indicates a charge represents credits, usage, a Marketplace purchase, a
     reservation fee, or a refund.
    :vartype charge_type: str
    :ivar frequency: Indicates how frequently this charge will occur. OneTime for purchases which
     only happen once, Monthly for fees which recur every month, and UsageBased for charges based on
     how much a service is used.
    :vartype frequency: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
        'billing_account_id': {'readonly': True},
        'billing_account_name': {'readonly': True},
        'billing_period_start_date': {'readonly': True},
        'billing_period_end_date': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_name': {'readonly': True},
        'account_owner_id': {'readonly': True},
        'account_name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'subscription_name': {'readonly': True},
        'date': {'readonly': True},
        'product': {'readonly': True},
        'part_number': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_details': {'readonly': True},
        'quantity': {'readonly': True},
        'effective_price': {'readonly': True},
        'cost': {'readonly': True},
        'unit_price': {'readonly': True},
        'billing_currency': {'readonly': True},
        'resource_location': {'readonly': True},
        'consumed_service': {'readonly': True},
        'resource_id': {'readonly': True},
        'resource_name': {'readonly': True},
        'service_info1': {'readonly': True},
        'service_info2': {'readonly': True},
        'additional_info': {'readonly': True},
        'invoice_section': {'readonly': True},
        'cost_center': {'readonly': True},
        'resource_group': {'readonly': True},
        'reservation_id': {'readonly': True},
        'reservation_name': {'readonly': True},
        'product_order_id': {'readonly': True},
        'product_order_name': {'readonly': True},
        'offer_id': {'readonly': True},
        'is_azure_credit_eligible': {'readonly': True},
        'term': {'readonly': True},
        'publisher_name': {'readonly': True},
        'publisher_type': {'readonly': True},
        'plan_name': {'readonly': True},
        'charge_type': {'readonly': True},
        'frequency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'billing_account_id': {'key': 'properties.billingAccountId', 'type': 'str'},
        'billing_account_name': {'key': 'properties.billingAccountName', 'type': 'str'},
        'billing_period_start_date': {'key': 'properties.billingPeriodStartDate', 'type': 'iso-8601'},
        'billing_period_end_date': {'key': 'properties.billingPeriodEndDate', 'type': 'iso-8601'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_name': {'key': 'properties.billingProfileName', 'type': 'str'},
        'account_owner_id': {'key': 'properties.accountOwnerId', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'subscription_name': {'key': 'properties.subscriptionName', 'type': 'str'},
        'date': {'key': 'properties.date', 'type': 'iso-8601'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'part_number': {'key': 'properties.partNumber', 'type': 'str'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'meter_details': {'key': 'properties.meterDetails', 'type': 'MeterDetailsResponse'},
        'quantity': {'key': 'properties.quantity', 'type': 'float'},
        'effective_price': {'key': 'properties.effectivePrice', 'type': 'float'},
        'cost': {'key': 'properties.cost', 'type': 'float'},
        'unit_price': {'key': 'properties.unitPrice', 'type': 'float'},
        'billing_currency': {'key': 'properties.billingCurrency', 'type': 'str'},
        'resource_location': {'key': 'properties.resourceLocation', 'type': 'str'},
        'consumed_service': {'key': 'properties.consumedService', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'resource_name': {'key': 'properties.resourceName', 'type': 'str'},
        'service_info1': {'key': 'properties.serviceInfo1', 'type': 'str'},
        'service_info2': {'key': 'properties.serviceInfo2', 'type': 'str'},
        'additional_info': {'key': 'properties.additionalInfo', 'type': 'str'},
        'invoice_section': {'key': 'properties.invoiceSection', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
        'reservation_name': {'key': 'properties.reservationName', 'type': 'str'},
        'product_order_id': {'key': 'properties.productOrderId', 'type': 'str'},
        'product_order_name': {'key': 'properties.productOrderName', 'type': 'str'},
        'offer_id': {'key': 'properties.offerId', 'type': 'str'},
        'is_azure_credit_eligible': {'key': 'properties.isAzureCreditEligible', 'type': 'bool'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'publisher_name': {'key': 'properties.publisherName', 'type': 'str'},
        'publisher_type': {'key': 'properties.publisherType', 'type': 'str'},
        'plan_name': {'key': 'properties.planName', 'type': 'str'},
        'charge_type': {'key': 'properties.chargeType', 'type': 'str'},
        'frequency': {'key': 'properties.frequency', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LegacyUsageDetail, self).__init__(**kwargs)
        self.kind = 'legacy'  # type: str
        self.billing_account_id = None
        self.billing_account_name = None
        self.billing_period_start_date = None
        self.billing_period_end_date = None
        self.billing_profile_id = None
        self.billing_profile_name = None
        self.account_owner_id = None
        self.account_name = None
        self.subscription_id = None
        self.subscription_name = None
        self.date = None
        self.product = None
        self.part_number = None
        self.meter_id = None
        self.meter_details = None
        self.quantity = None
        self.effective_price = None
        self.cost = None
        self.unit_price = None
        self.billing_currency = None
        self.resource_location = None
        self.consumed_service = None
        self.resource_id = None
        self.resource_name = None
        self.service_info1 = None
        self.service_info2 = None
        self.additional_info = None
        self.invoice_section = None
        self.cost_center = None
        self.resource_group = None
        self.reservation_id = None
        self.reservation_name = None
        self.product_order_id = None
        self.product_order_name = None
        self.offer_id = None
        self.is_azure_credit_eligible = None
        self.term = None
        self.publisher_name = None
        self.publisher_type = None
        self.plan_name = None
        self.charge_type = None
        self.frequency = None


class Lots(msrest.serialization.Model):
    """Result of listing lot summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of lot summary.
    :vartype value: list[~azure.mgmt.consumption.models.LotSummary]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LotSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Lots, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class LotSummary(Resource):
    """A lot summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar original_amount: Original amount.
    :vartype original_amount: ~azure.mgmt.consumption.models.Amount
    :ivar closed_balance: Closed balance.
    :vartype closed_balance: ~azure.mgmt.consumption.models.Amount
    :ivar source: Lot source. Possible values include: "PurchasedCredit", "PromotionalCredit".
    :vartype source: str or ~azure.mgmt.consumption.models.LotSource
    :ivar start_date: Start date.
    :vartype start_date: ~datetime.datetime
    :ivar expiration_date: Expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar po_number: PO number.
    :vartype po_number: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'original_amount': {'readonly': True},
        'closed_balance': {'readonly': True},
        'source': {'readonly': True},
        'start_date': {'readonly': True},
        'expiration_date': {'readonly': True},
        'po_number': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'original_amount': {'key': 'properties.originalAmount', 'type': 'Amount'},
        'closed_balance': {'key': 'properties.closedBalance', 'type': 'Amount'},
        'source': {'key': 'properties.source', 'type': 'str'},
        'start_date': {'key': 'properties.startDate', 'type': 'iso-8601'},
        'expiration_date': {'key': 'properties.expirationDate', 'type': 'iso-8601'},
        'po_number': {'key': 'properties.poNumber', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LotSummary, self).__init__(**kwargs)
        self.original_amount = None
        self.closed_balance = None
        self.source = None
        self.start_date = None
        self.expiration_date = None
        self.po_number = None


class ManagementGroupAggregatedCostResult(Resource):
    """A management group aggregated cost resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar billing_period_id: The id of the billing period resource that the aggregated cost belongs
     to.
    :vartype billing_period_id: str
    :ivar usage_start: The start of the date time range covered by aggregated cost.
    :vartype usage_start: ~datetime.datetime
    :ivar usage_end: The end of the date time range covered by the aggregated cost.
    :vartype usage_end: ~datetime.datetime
    :ivar azure_charges: Azure Charges.
    :vartype azure_charges: float
    :ivar marketplace_charges: Marketplace Charges.
    :vartype marketplace_charges: float
    :ivar charges_billed_separately: Charges Billed Separately.
    :vartype charges_billed_separately: float
    :ivar currency: The ISO currency in which the meter is charged, for example, USD.
    :vartype currency: str
    :param children: Children of a management group.
    :type children: list[~azure.mgmt.consumption.models.ManagementGroupAggregatedCostResult]
    :param included_subscriptions: List of subscription Guids included in the calculation of
     aggregated cost.
    :type included_subscriptions: list[str]
    :param excluded_subscriptions: List of subscription Guids excluded from the calculation of
     aggregated cost.
    :type excluded_subscriptions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'billing_period_id': {'readonly': True},
        'usage_start': {'readonly': True},
        'usage_end': {'readonly': True},
        'azure_charges': {'readonly': True},
        'marketplace_charges': {'readonly': True},
        'charges_billed_separately': {'readonly': True},
        'currency': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'billing_period_id': {'key': 'properties.billingPeriodId', 'type': 'str'},
        'usage_start': {'key': 'properties.usageStart', 'type': 'iso-8601'},
        'usage_end': {'key': 'properties.usageEnd', 'type': 'iso-8601'},
        'azure_charges': {'key': 'properties.azureCharges', 'type': 'float'},
        'marketplace_charges': {'key': 'properties.marketplaceCharges', 'type': 'float'},
        'charges_billed_separately': {'key': 'properties.chargesBilledSeparately', 'type': 'float'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[ManagementGroupAggregatedCostResult]'},
        'included_subscriptions': {'key': 'properties.includedSubscriptions', 'type': '[str]'},
        'excluded_subscriptions': {'key': 'properties.excludedSubscriptions', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupAggregatedCostResult, self).__init__(**kwargs)
        self.billing_period_id = None
        self.usage_start = None
        self.usage_end = None
        self.azure_charges = None
        self.marketplace_charges = None
        self.charges_billed_separately = None
        self.currency = None
        self.children = kwargs.get('children', None)
        self.included_subscriptions = kwargs.get('included_subscriptions', None)
        self.excluded_subscriptions = kwargs.get('excluded_subscriptions', None)


class Marketplace(Resource):
    """An marketplace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar billing_period_id: The id of the billing period resource that the usage belongs to.
    :vartype billing_period_id: str
    :ivar usage_start: The start of the date time range covered by the usage detail.
    :vartype usage_start: ~datetime.datetime
    :ivar usage_end: The end of the date time range covered by the usage detail.
    :vartype usage_end: ~datetime.datetime
    :ivar resource_rate: The marketplace resource rate.
    :vartype resource_rate: float
    :ivar offer_name: The type of offer.
    :vartype offer_name: str
    :ivar resource_group: The name of resource group.
    :vartype resource_group: str
    :ivar order_number: The order number.
    :vartype order_number: str
    :ivar instance_name: The name of the resource instance that the usage is about.
    :vartype instance_name: str
    :ivar instance_id: The uri of the resource instance that the usage is about.
    :vartype instance_id: str
    :ivar currency: The ISO currency in which the meter is charged, for example, USD.
    :vartype currency: str
    :ivar consumed_quantity: The quantity of usage.
    :vartype consumed_quantity: float
    :ivar unit_of_measure: The unit of measure.
    :vartype unit_of_measure: str
    :ivar pretax_cost: The amount of cost before tax.
    :vartype pretax_cost: float
    :ivar is_estimated: The estimated usage is subject to change.
    :vartype is_estimated: bool
    :ivar meter_id: The meter id (GUID).
    :vartype meter_id: str
    :ivar subscription_guid: Subscription guid.
    :vartype subscription_guid: str
    :ivar subscription_name: Subscription name.
    :vartype subscription_name: str
    :ivar account_name: Account name.
    :vartype account_name: str
    :ivar department_name: Department name.
    :vartype department_name: str
    :ivar consumed_service: Consumed service name.
    :vartype consumed_service: str
    :ivar cost_center: The cost center of this department if it is a department and a costcenter
     exists.
    :vartype cost_center: str
    :ivar additional_properties: Additional details of this usage item. By default this is not
     populated, unless it's specified in $expand.
    :vartype additional_properties: str
    :ivar publisher_name: The name of publisher.
    :vartype publisher_name: str
    :ivar plan_name: The name of plan.
    :vartype plan_name: str
    :ivar is_recurring_charge: Flag indicating whether this is a recurring charge or not.
    :vartype is_recurring_charge: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'billing_period_id': {'readonly': True},
        'usage_start': {'readonly': True},
        'usage_end': {'readonly': True},
        'resource_rate': {'readonly': True},
        'offer_name': {'readonly': True},
        'resource_group': {'readonly': True},
        'order_number': {'readonly': True},
        'instance_name': {'readonly': True},
        'instance_id': {'readonly': True},
        'currency': {'readonly': True},
        'consumed_quantity': {'readonly': True},
        'unit_of_measure': {'readonly': True},
        'pretax_cost': {'readonly': True},
        'is_estimated': {'readonly': True},
        'meter_id': {'readonly': True},
        'subscription_guid': {'readonly': True},
        'subscription_name': {'readonly': True},
        'account_name': {'readonly': True},
        'department_name': {'readonly': True},
        'consumed_service': {'readonly': True},
        'cost_center': {'readonly': True},
        'additional_properties': {'readonly': True},
        'publisher_name': {'readonly': True},
        'plan_name': {'readonly': True},
        'is_recurring_charge': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'billing_period_id': {'key': 'properties.billingPeriodId', 'type': 'str'},
        'usage_start': {'key': 'properties.usageStart', 'type': 'iso-8601'},
        'usage_end': {'key': 'properties.usageEnd', 'type': 'iso-8601'},
        'resource_rate': {'key': 'properties.resourceRate', 'type': 'float'},
        'offer_name': {'key': 'properties.offerName', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'order_number': {'key': 'properties.orderNumber', 'type': 'str'},
        'instance_name': {'key': 'properties.instanceName', 'type': 'str'},
        'instance_id': {'key': 'properties.instanceId', 'type': 'str'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'consumed_quantity': {'key': 'properties.consumedQuantity', 'type': 'float'},
        'unit_of_measure': {'key': 'properties.unitOfMeasure', 'type': 'str'},
        'pretax_cost': {'key': 'properties.pretaxCost', 'type': 'float'},
        'is_estimated': {'key': 'properties.isEstimated', 'type': 'bool'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'subscription_guid': {'key': 'properties.subscriptionGuid', 'type': 'str'},
        'subscription_name': {'key': 'properties.subscriptionName', 'type': 'str'},
        'account_name': {'key': 'properties.accountName', 'type': 'str'},
        'department_name': {'key': 'properties.departmentName', 'type': 'str'},
        'consumed_service': {'key': 'properties.consumedService', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'additional_properties': {'key': 'properties.additionalProperties', 'type': 'str'},
        'publisher_name': {'key': 'properties.publisherName', 'type': 'str'},
        'plan_name': {'key': 'properties.planName', 'type': 'str'},
        'is_recurring_charge': {'key': 'properties.isRecurringCharge', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Marketplace, self).__init__(**kwargs)
        self.billing_period_id = None
        self.usage_start = None
        self.usage_end = None
        self.resource_rate = None
        self.offer_name = None
        self.resource_group = None
        self.order_number = None
        self.instance_name = None
        self.instance_id = None
        self.currency = None
        self.consumed_quantity = None
        self.unit_of_measure = None
        self.pretax_cost = None
        self.is_estimated = None
        self.meter_id = None
        self.subscription_guid = None
        self.subscription_name = None
        self.account_name = None
        self.department_name = None
        self.consumed_service = None
        self.cost_center = None
        self.additional_properties = None
        self.publisher_name = None
        self.plan_name = None
        self.is_recurring_charge = None


class MarketplacesListResult(msrest.serialization.Model):
    """Result of listing marketplaces. It contains a list of available marketplaces in reverse chronological order by billing period.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of marketplaces.
    :vartype value: list[~azure.mgmt.consumption.models.Marketplace]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Marketplace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarketplacesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class MeterDetails(msrest.serialization.Model):
    """The properties of the meter detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_name: The name of the meter, within the given meter category.
    :vartype meter_name: str
    :ivar meter_category: The category of the meter, for example, 'Cloud services', 'Networking',
     etc..
    :vartype meter_category: str
    :ivar meter_sub_category: The subcategory of the meter, for example, 'A6 Cloud services',
     'ExpressRoute (IXP)', etc..
    :vartype meter_sub_category: str
    :ivar unit: The unit in which the meter consumption is charged, for example, 'Hours', 'GB',
     etc.
    :vartype unit: str
    :ivar meter_location: The location in which the Azure service is available.
    :vartype meter_location: str
    :ivar total_included_quantity: The total included quantity associated with the offer.
    :vartype total_included_quantity: float
    :ivar pretax_standard_rate: The pretax listing price.
    :vartype pretax_standard_rate: float
    :ivar service_name: The name of the service.
    :vartype service_name: str
    :ivar service_tier: The service tier.
    :vartype service_tier: str
    """

    _validation = {
        'meter_name': {'readonly': True},
        'meter_category': {'readonly': True},
        'meter_sub_category': {'readonly': True},
        'unit': {'readonly': True},
        'meter_location': {'readonly': True},
        'total_included_quantity': {'readonly': True},
        'pretax_standard_rate': {'readonly': True},
        'service_name': {'readonly': True},
        'service_tier': {'readonly': True},
    }

    _attribute_map = {
        'meter_name': {'key': 'meterName', 'type': 'str'},
        'meter_category': {'key': 'meterCategory', 'type': 'str'},
        'meter_sub_category': {'key': 'meterSubCategory', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'meter_location': {'key': 'meterLocation', 'type': 'str'},
        'total_included_quantity': {'key': 'totalIncludedQuantity', 'type': 'float'},
        'pretax_standard_rate': {'key': 'pretaxStandardRate', 'type': 'float'},
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'service_tier': {'key': 'serviceTier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MeterDetails, self).__init__(**kwargs)
        self.meter_name = None
        self.meter_category = None
        self.meter_sub_category = None
        self.unit = None
        self.meter_location = None
        self.total_included_quantity = None
        self.pretax_standard_rate = None
        self.service_name = None
        self.service_tier = None


class MeterDetailsResponse(msrest.serialization.Model):
    """The properties of the meter detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_name: The name of the meter, within the given meter category.
    :vartype meter_name: str
    :ivar meter_category: The category of the meter, for example, 'Cloud services', 'Networking',
     etc..
    :vartype meter_category: str
    :ivar meter_sub_category: The subcategory of the meter, for example, 'A6 Cloud services',
     'ExpressRoute (IXP)', etc..
    :vartype meter_sub_category: str
    :ivar unit_of_measure: The unit in which the meter consumption is charged, for example,
     'Hours', 'GB', etc.
    :vartype unit_of_measure: str
    :ivar service_family: The service family.
    :vartype service_family: str
    """

    _validation = {
        'meter_name': {'readonly': True},
        'meter_category': {'readonly': True},
        'meter_sub_category': {'readonly': True},
        'unit_of_measure': {'readonly': True},
        'service_family': {'readonly': True},
    }

    _attribute_map = {
        'meter_name': {'key': 'meterName', 'type': 'str'},
        'meter_category': {'key': 'meterCategory', 'type': 'str'},
        'meter_sub_category': {'key': 'meterSubCategory', 'type': 'str'},
        'unit_of_measure': {'key': 'unitOfMeasure', 'type': 'str'},
        'service_family': {'key': 'serviceFamily', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MeterDetailsResponse, self).__init__(**kwargs)
        self.meter_name = None
        self.meter_category = None
        self.meter_sub_category = None
        self.unit_of_measure = None
        self.service_family = None


class ModernChargeSummary(ChargeSummary):
    """Modern charge summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of charge summary.Constant filled by server.
     Possible values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.ChargeSummaryKind
    :ivar billing_period_id: The id of the billing period resource that the charge belongs to.
    :vartype billing_period_id: str
    :ivar usage_start: Usage start date.
    :vartype usage_start: str
    :ivar usage_end: Usage end date.
    :vartype usage_end: str
    :ivar azure_charges: Azure Charges.
    :vartype azure_charges: ~azure.mgmt.consumption.models.Amount
    :ivar charges_billed_separately: Charges Billed separately.
    :vartype charges_billed_separately: ~azure.mgmt.consumption.models.Amount
    :ivar marketplace_charges: Marketplace Charges.
    :vartype marketplace_charges: ~azure.mgmt.consumption.models.Amount
    :ivar billing_account_id: Billing Account Id.
    :vartype billing_account_id: str
    :ivar billing_profile_id: Billing Profile Id.
    :vartype billing_profile_id: str
    :ivar invoice_section_id: Invoice Section Id.
    :vartype invoice_section_id: str
    :ivar customer_id: Customer Id.
    :vartype customer_id: str
    :ivar is_invoiced: Is charge Invoiced.
    :vartype is_invoiced: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
        'billing_period_id': {'readonly': True},
        'usage_start': {'readonly': True},
        'usage_end': {'readonly': True},
        'azure_charges': {'readonly': True},
        'charges_billed_separately': {'readonly': True},
        'marketplace_charges': {'readonly': True},
        'billing_account_id': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'invoice_section_id': {'readonly': True},
        'customer_id': {'readonly': True},
        'is_invoiced': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'billing_period_id': {'key': 'properties.billingPeriodId', 'type': 'str'},
        'usage_start': {'key': 'properties.usageStart', 'type': 'str'},
        'usage_end': {'key': 'properties.usageEnd', 'type': 'str'},
        'azure_charges': {'key': 'properties.azureCharges', 'type': 'Amount'},
        'charges_billed_separately': {'key': 'properties.chargesBilledSeparately', 'type': 'Amount'},
        'marketplace_charges': {'key': 'properties.marketplaceCharges', 'type': 'Amount'},
        'billing_account_id': {'key': 'properties.billingAccountId', 'type': 'str'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'invoice_section_id': {'key': 'properties.invoiceSectionId', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'is_invoiced': {'key': 'properties.isInvoiced', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ModernChargeSummary, self).__init__(**kwargs)
        self.kind = 'modern'  # type: str
        self.billing_period_id = None
        self.usage_start = None
        self.usage_end = None
        self.azure_charges = None
        self.charges_billed_separately = None
        self.marketplace_charges = None
        self.billing_account_id = None
        self.billing_profile_id = None
        self.invoice_section_id = None
        self.customer_id = None
        self.is_invoiced = None


class ModernReservationRecommendation(ReservationRecommendation):
    """Modern reservation recommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Resource location.
    :vartype location: str
    :ivar sku: Resource sku.
    :vartype sku: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of reservation recommendation.Constant filled by
     server.  Possible values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.ReservationRecommendationKind
    :ivar look_back_period: The number of days of usage to look back for recommendation.
    :vartype look_back_period: str
    :ivar instance_flexibility_ratio: The instance Flexibility Ratio.
    :vartype instance_flexibility_ratio: int
    :ivar instance_flexibility_group: The instance Flexibility Group.
    :vartype instance_flexibility_group: str
    :ivar normalized_size: The normalized Size.
    :vartype normalized_size: str
    :ivar recommended_quantity_normalized: The recommended Quantity Normalized.
    :vartype recommended_quantity_normalized: float
    :ivar meter_id: The meter id (GUID).
    :vartype meter_id: str
    :ivar term: RI recommendations in one or three year terms.
    :vartype term: str
    :ivar cost_with_no_reserved_instances: The total amount of cost without reserved instances.
    :vartype cost_with_no_reserved_instances: ~azure.mgmt.consumption.models.Amount
    :ivar recommended_quantity: Recommended quality for reserved instances.
    :vartype recommended_quantity: float
    :ivar total_cost_with_reserved_instances: The total amount of cost with reserved instances.
    :vartype total_cost_with_reserved_instances: ~azure.mgmt.consumption.models.Amount
    :ivar net_savings: Total estimated savings with reserved instances.
    :vartype net_savings: ~azure.mgmt.consumption.models.Amount
    :ivar first_usage_date: The usage date for looking back.
    :vartype first_usage_date: ~datetime.datetime
    :ivar scope: Shared or single recommendation.
    :vartype scope: str
    :ivar sku_properties: List of sku properties.
    :vartype sku_properties: list[~azure.mgmt.consumption.models.SkuProperty]
    """

    _validation = {
        'location': {'readonly': True},
        'sku': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
        'look_back_period': {'readonly': True},
        'instance_flexibility_ratio': {'readonly': True},
        'instance_flexibility_group': {'readonly': True},
        'normalized_size': {'readonly': True},
        'recommended_quantity_normalized': {'readonly': True},
        'meter_id': {'readonly': True},
        'term': {'readonly': True},
        'cost_with_no_reserved_instances': {'readonly': True},
        'recommended_quantity': {'readonly': True},
        'total_cost_with_reserved_instances': {'readonly': True},
        'net_savings': {'readonly': True},
        'first_usage_date': {'readonly': True},
        'scope': {'readonly': True},
        'sku_properties': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'look_back_period': {'key': 'properties.lookBackPeriod', 'type': 'str'},
        'instance_flexibility_ratio': {'key': 'properties.instanceFlexibilityRatio', 'type': 'int'},
        'instance_flexibility_group': {'key': 'properties.instanceFlexibilityGroup', 'type': 'str'},
        'normalized_size': {'key': 'properties.normalizedSize', 'type': 'str'},
        'recommended_quantity_normalized': {'key': 'properties.recommendedQuantityNormalized', 'type': 'float'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'cost_with_no_reserved_instances': {'key': 'properties.costWithNoReservedInstances', 'type': 'Amount'},
        'recommended_quantity': {'key': 'properties.recommendedQuantity', 'type': 'float'},
        'total_cost_with_reserved_instances': {'key': 'properties.totalCostWithReservedInstances', 'type': 'Amount'},
        'net_savings': {'key': 'properties.netSavings', 'type': 'Amount'},
        'first_usage_date': {'key': 'properties.firstUsageDate', 'type': 'iso-8601'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'sku_properties': {'key': 'properties.skuProperties', 'type': '[SkuProperty]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ModernReservationRecommendation, self).__init__(**kwargs)
        self.kind = 'modern'  # type: str
        self.look_back_period = None
        self.instance_flexibility_ratio = None
        self.instance_flexibility_group = None
        self.normalized_size = None
        self.recommended_quantity_normalized = None
        self.meter_id = None
        self.term = None
        self.cost_with_no_reserved_instances = None
        self.recommended_quantity = None
        self.total_cost_with_reserved_instances = None
        self.net_savings = None
        self.first_usage_date = None
        self.scope = None
        self.sku_properties = None


class ModernReservationTransaction(Resource):
    """Modern Reservation transaction resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar amount: The charge of the transaction.
    :vartype amount: float
    :ivar arm_sku_name: This is the ARM Sku name. It can be used to join with the serviceType field
     in additional info in usage records.
    :vartype arm_sku_name: str
    :ivar billing_frequency: The billing frequency, which can be either one-time or recurring.
    :vartype billing_frequency: str
    :ivar billing_profile_id: Billing profile Id.
    :vartype billing_profile_id: str
    :ivar billing_profile_name: Billing profile name.
    :vartype billing_profile_name: str
    :ivar currency: The ISO currency in which the transaction is charged, for example, USD.
    :vartype currency: str
    :ivar description: The description of the transaction.
    :vartype description: str
    :ivar event_date: The date of the transaction.
    :vartype event_date: ~datetime.datetime
    :ivar event_type: The type of the transaction (Purchase, Cancel, etc.).
    :vartype event_type: str
    :ivar invoice: Invoice Number.
    :vartype invoice: str
    :ivar invoice_id: Invoice Id as on the invoice where the specific transaction appears.
    :vartype invoice_id: str
    :ivar invoice_section_id: Invoice Section Id.
    :vartype invoice_section_id: str
    :ivar invoice_section_name: Invoice Section Name.
    :vartype invoice_section_name: str
    :ivar purchasing_subscription_guid: The subscription guid that makes the transaction.
    :vartype purchasing_subscription_guid: str
    :ivar purchasing_subscription_name: The subscription name that makes the transaction.
    :vartype purchasing_subscription_name: str
    :ivar quantity: The quantity of the transaction.
    :vartype quantity: float
    :ivar region: The region of the transaction.
    :vartype region: str
    :ivar reservation_order_id: The reservation order ID is the identifier for a reservation
     purchase. Each reservation order ID represents a single purchase transaction. A reservation
     order contains reservations. The reservation order specifies the VM size and region for the
     reservations.
    :vartype reservation_order_id: str
    :ivar reservation_order_name: The name of the reservation order.
    :vartype reservation_order_name: str
    :ivar term: This is the term of the transaction.
    :vartype term: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'amount': {'readonly': True},
        'arm_sku_name': {'readonly': True},
        'billing_frequency': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_name': {'readonly': True},
        'currency': {'readonly': True},
        'description': {'readonly': True},
        'event_date': {'readonly': True},
        'event_type': {'readonly': True},
        'invoice': {'readonly': True},
        'invoice_id': {'readonly': True},
        'invoice_section_id': {'readonly': True},
        'invoice_section_name': {'readonly': True},
        'purchasing_subscription_guid': {'readonly': True},
        'purchasing_subscription_name': {'readonly': True},
        'quantity': {'readonly': True},
        'region': {'readonly': True},
        'reservation_order_id': {'readonly': True},
        'reservation_order_name': {'readonly': True},
        'term': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'amount': {'key': 'properties.amount', 'type': 'float'},
        'arm_sku_name': {'key': 'properties.armSkuName', 'type': 'str'},
        'billing_frequency': {'key': 'properties.billingFrequency', 'type': 'str'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_name': {'key': 'properties.billingProfileName', 'type': 'str'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'event_date': {'key': 'properties.eventDate', 'type': 'iso-8601'},
        'event_type': {'key': 'properties.eventType', 'type': 'str'},
        'invoice': {'key': 'properties.invoice', 'type': 'str'},
        'invoice_id': {'key': 'properties.invoiceId', 'type': 'str'},
        'invoice_section_id': {'key': 'properties.invoiceSectionId', 'type': 'str'},
        'invoice_section_name': {'key': 'properties.invoiceSectionName', 'type': 'str'},
        'purchasing_subscription_guid': {'key': 'properties.purchasingSubscriptionGuid', 'type': 'str'},
        'purchasing_subscription_name': {'key': 'properties.purchasingSubscriptionName', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'float'},
        'region': {'key': 'properties.region', 'type': 'str'},
        'reservation_order_id': {'key': 'properties.reservationOrderId', 'type': 'str'},
        'reservation_order_name': {'key': 'properties.reservationOrderName', 'type': 'str'},
        'term': {'key': 'properties.term', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ModernReservationTransaction, self).__init__(**kwargs)
        self.amount = None
        self.arm_sku_name = None
        self.billing_frequency = None
        self.billing_profile_id = None
        self.billing_profile_name = None
        self.currency = None
        self.description = None
        self.event_date = None
        self.event_type = None
        self.invoice = None
        self.invoice_id = None
        self.invoice_section_id = None
        self.invoice_section_name = None
        self.purchasing_subscription_guid = None
        self.purchasing_subscription_name = None
        self.quantity = None
        self.region = None
        self.reservation_order_id = None
        self.reservation_order_name = None
        self.term = None


class ModernReservationTransactionsListResult(msrest.serialization.Model):
    """Result of listing reservation recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of reservation recommendations.
    :vartype value: list[~azure.mgmt.consumption.models.ModernReservationTransaction]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ModernReservationTransaction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ModernReservationTransactionsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ModernUsageDetail(UsageDetail):
    """Modern usage detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param kind: Required. Specifies the kind of usage details.Constant filled by server.  Possible
     values include: "legacy", "modern".
    :type kind: str or ~azure.mgmt.consumption.models.UsageDetailsKind
    :ivar billing_account_id: Billing Account identifier.
    :vartype billing_account_id: str
    :ivar billing_account_name: Name of the Billing Account.
    :vartype billing_account_name: str
    :ivar billing_period_start_date: Billing Period Start Date as in the invoice.
    :vartype billing_period_start_date: ~datetime.datetime
    :ivar billing_period_end_date: Billing Period End Date as in the invoice.
    :vartype billing_period_end_date: ~datetime.datetime
    :ivar billing_profile_id: Identifier for the billing profile that groups costs across invoices
     in the a singular billing currency across across the customers who have onboarded the Microsoft
     customer agreement and the customers in CSP who have made entitlement purchases like SaaS,
     Marketplace, RI, etc.
    :vartype billing_profile_id: str
    :ivar billing_profile_name: Name of the billing profile that groups costs across invoices in
     the a singular billing currency across across the customers who have onboarded the Microsoft
     customer agreement and the customers in CSP who have made entitlement purchases like SaaS,
     Marketplace, RI, etc.
    :vartype billing_profile_name: str
    :ivar subscription_guid: Unique Microsoft generated identifier for the Azure Subscription.
    :vartype subscription_guid: str
    :ivar subscription_name: Name of the Azure Subscription.
    :vartype subscription_name: str
    :ivar date: Date for the usage record.
    :vartype date: ~datetime.datetime
    :ivar product: Name of the product that has accrued charges by consumption or purchase as
     listed in the invoice. Not available for Marketplace.
    :vartype product: str
    :ivar meter_id: The meter id (GUID). Not available for marketplace. For reserved instance this
     represents the primary meter for which the reservation was purchased. For the actual VM Size
     for which the reservation is purchased see productOrderName.
    :vartype meter_id: str
    :ivar meter_name: Identifies the name of the meter against which consumption is measured.
    :vartype meter_name: str
    :ivar meter_region: Identifies the location of the datacenter for certain services that are
     priced based on datacenter location.
    :vartype meter_region: str
    :ivar meter_category: Identifies the top-level service for the usage.
    :vartype meter_category: str
    :ivar meter_sub_category: Defines the type or sub-category of Azure service that can affect the
     rate.
    :vartype meter_sub_category: str
    :ivar service_family: List the service family for the product purchased or charged (Example:
     Storage ; Compute).
    :vartype service_family: str
    :ivar quantity: Measure the quantity purchased or consumed.The amount of the meter used during
     the billing period.
    :vartype quantity: float
    :ivar unit_of_measure: Identifies the Unit that the service is charged in. For example, GB,
     hours, 10,000 s.
    :vartype unit_of_measure: str
    :ivar instance_name: Instance Name.
    :vartype instance_name: str
    :ivar cost_in_usd: Estimated extendedCost or blended cost before tax in USD.
    :vartype cost_in_usd: float
    :ivar unit_price: Unit Price is the price applicable to you. (your EA or other contract price).
    :vartype unit_price: float
    :ivar billing_currency_code: The currency defining the billed cost.
    :vartype billing_currency_code: str
    :ivar resource_location: Name of the resource location.
    :vartype resource_location: str
    :ivar consumed_service: Consumed service name. Name of the azure resource provider that emits
     the usage or was purchased. This value is not provided for marketplace usage.
    :vartype consumed_service: str
    :ivar service_info1: Service Info 1.
    :vartype service_info1: str
    :ivar service_info2: Service Info 2.
    :vartype service_info2: str
    :ivar additional_info: Additional details of this usage item. Use this field to get usage line
     item specific details such as the actual VM Size (ServiceType) or the ratio in which the
     reservation discount is applied.
    :vartype additional_info: str
    :ivar invoice_section_id: Identifier of the project that is being charged in the invoice. Not
     applicable for Microsoft Customer Agreements onboarded by partners.
    :vartype invoice_section_id: str
    :ivar invoice_section_name: Name of the project that is being charged in the invoice. Not
     applicable for Microsoft Customer Agreements onboarded by partners.
    :vartype invoice_section_name: str
    :ivar cost_center: The cost center of this department if it is a department and a cost center
     is provided.
    :vartype cost_center: str
    :ivar resource_group: Name of the Azure resource group used for cohesive lifecycle management
     of resources.
    :vartype resource_group: str
    :ivar reservation_id: ARM resource id of the reservation. Only applies to records relevant to
     reservations.
    :vartype reservation_id: str
    :ivar reservation_name: User provided display name of the reservation. Last known name for a
     particular day is populated in the daily data. Only applies to records relevant to
     reservations.
    :vartype reservation_name: str
    :ivar product_order_id: The identifier for the asset or Azure plan name that the subscription
     belongs to. For example: Azure Plan. For reservations this is the Reservation Order ID.
    :vartype product_order_id: str
    :ivar product_order_name: Product Order Name. For reservations this is the SKU that was
     purchased.
    :vartype product_order_name: str
    :ivar is_azure_credit_eligible: Determines if the cost is eligible to be paid for using Azure
     credits.
    :vartype is_azure_credit_eligible: bool
    :ivar term: Term (in months). Displays the term for the validity of the offer. For example. In
     case of reserved instances it displays 12 months for yearly term of reserved instance. For one
     time purchases or recurring purchases, the terms displays 1 month; This is not applicable for
     Azure consumption.
    :vartype term: str
    :ivar publisher_name: Name of the publisher of the service including Microsoft or Third Party
     publishers.
    :vartype publisher_name: str
    :ivar publisher_type: Type of publisher that identifies if the publisher is first party, third
     party reseller or third party agency.
    :vartype publisher_type: str
    :ivar charge_type: Indicates a charge represents credits, usage, a Marketplace purchase, a
     reservation fee, or a refund.
    :vartype charge_type: str
    :ivar frequency: Indicates how frequently this charge will occur. OneTime for purchases which
     only happen once, Monthly for fees which recur every month, and UsageBased for charges based on
     how much a service is used.
    :vartype frequency: str
    :ivar cost_in_billing_currency: ExtendedCost or blended cost before tax in billed currency.
    :vartype cost_in_billing_currency: float
    :ivar cost_in_pricing_currency: ExtendedCost or blended cost before tax in pricing currency to
     correlate with prices.
    :vartype cost_in_pricing_currency: float
    :ivar exchange_rate: Exchange rate used in conversion from pricing currency to billing
     currency.
    :vartype exchange_rate: str
    :ivar exchange_rate_date: Date on which exchange rate used in conversion from pricing currency
     to billing currency.
    :vartype exchange_rate_date: ~datetime.datetime
    :ivar invoice_id: Invoice ID as on the invoice where the specific transaction appears.
    :vartype invoice_id: str
    :ivar previous_invoice_id: Reference to an original invoice there is a refund (negative cost).
     This is populated only when there is a refund.
    :vartype previous_invoice_id: str
    :ivar pricing_currency_code: Pricing Billing Currency.
    :vartype pricing_currency_code: str
    :ivar product_identifier: Identifer for the product that has accrued charges by consumption or
     purchase . This is the concatenated key of productId and SKuId in partner center.
    :vartype product_identifier: str
    :ivar resource_location_normalized: Resource Location Normalized.
    :vartype resource_location_normalized: str
    :ivar service_period_start_date: Start date for the rating period when the service usage was
     rated for charges. The prices for Azure services are determined for the rating period.
    :vartype service_period_start_date: ~datetime.datetime
    :ivar service_period_end_date: End date for the period when the service usage was rated for
     charges. The prices for Azure services are determined based on the rating period.
    :vartype service_period_end_date: ~datetime.datetime
    :ivar customer_tenant_id: Identifier of the customer's AAD tenant.
    :vartype customer_tenant_id: str
    :ivar customer_name: Name of the customer's AAD tenant.
    :vartype customer_name: str
    :ivar partner_tenant_id: Identifier for the partner's AAD tenant.
    :vartype partner_tenant_id: str
    :ivar partner_name: Name of the partner' AAD tenant.
    :vartype partner_name: str
    :ivar reseller_mpn_id: MPNId for the reseller associated with the subscription.
    :vartype reseller_mpn_id: str
    :ivar reseller_name: Reseller Name.
    :vartype reseller_name: str
    :ivar publisher_id: Publisher Id.
    :vartype publisher_id: str
    :ivar market_price: Market Price that's charged for the usage.
    :vartype market_price: float
    :ivar exchange_rate_pricing_to_billing: Exchange Rate from pricing currency to billing
     currency.
    :vartype exchange_rate_pricing_to_billing: float
    :ivar payg_cost_in_billing_currency: The amount of PayG cost before tax in billing currency.
    :vartype payg_cost_in_billing_currency: float
    :ivar payg_cost_in_usd: The amount of PayG cost before tax in US Dollar currency.
    :vartype payg_cost_in_usd: float
    :ivar partner_earned_credit_rate: Rate of discount applied if there is a partner earned credit
     (PEC) based on partner admin link access.
    :vartype partner_earned_credit_rate: float
    :ivar partner_earned_credit_applied: Flag to indicate if partner earned credit has been applied
     or not.
    :vartype partner_earned_credit_applied: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'kind': {'required': True},
        'billing_account_id': {'readonly': True},
        'billing_account_name': {'readonly': True},
        'billing_period_start_date': {'readonly': True},
        'billing_period_end_date': {'readonly': True},
        'billing_profile_id': {'readonly': True},
        'billing_profile_name': {'readonly': True},
        'subscription_guid': {'readonly': True},
        'subscription_name': {'readonly': True},
        'date': {'readonly': True},
        'product': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_name': {'readonly': True},
        'meter_region': {'readonly': True},
        'meter_category': {'readonly': True},
        'meter_sub_category': {'readonly': True},
        'service_family': {'readonly': True},
        'quantity': {'readonly': True},
        'unit_of_measure': {'readonly': True},
        'instance_name': {'readonly': True},
        'cost_in_usd': {'readonly': True},
        'unit_price': {'readonly': True},
        'billing_currency_code': {'readonly': True},
        'resource_location': {'readonly': True},
        'consumed_service': {'readonly': True},
        'service_info1': {'readonly': True},
        'service_info2': {'readonly': True},
        'additional_info': {'readonly': True},
        'invoice_section_id': {'readonly': True},
        'invoice_section_name': {'readonly': True},
        'cost_center': {'readonly': True},
        'resource_group': {'readonly': True},
        'reservation_id': {'readonly': True},
        'reservation_name': {'readonly': True},
        'product_order_id': {'readonly': True},
        'product_order_name': {'readonly': True},
        'is_azure_credit_eligible': {'readonly': True},
        'term': {'readonly': True},
        'publisher_name': {'readonly': True},
        'publisher_type': {'readonly': True},
        'charge_type': {'readonly': True},
        'frequency': {'readonly': True},
        'cost_in_billing_currency': {'readonly': True},
        'cost_in_pricing_currency': {'readonly': True},
        'exchange_rate': {'readonly': True},
        'exchange_rate_date': {'readonly': True},
        'invoice_id': {'readonly': True},
        'previous_invoice_id': {'readonly': True},
        'pricing_currency_code': {'readonly': True},
        'product_identifier': {'readonly': True},
        'resource_location_normalized': {'readonly': True},
        'service_period_start_date': {'readonly': True},
        'service_period_end_date': {'readonly': True},
        'customer_tenant_id': {'readonly': True},
        'customer_name': {'readonly': True},
        'partner_tenant_id': {'readonly': True},
        'partner_name': {'readonly': True},
        'reseller_mpn_id': {'readonly': True},
        'reseller_name': {'readonly': True},
        'publisher_id': {'readonly': True},
        'market_price': {'readonly': True},
        'exchange_rate_pricing_to_billing': {'readonly': True},
        'payg_cost_in_billing_currency': {'readonly': True},
        'payg_cost_in_usd': {'readonly': True},
        'partner_earned_credit_rate': {'readonly': True},
        'partner_earned_credit_applied': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'billing_account_id': {'key': 'properties.billingAccountId', 'type': 'str'},
        'billing_account_name': {'key': 'properties.billingAccountName', 'type': 'str'},
        'billing_period_start_date': {'key': 'properties.billingPeriodStartDate', 'type': 'iso-8601'},
        'billing_period_end_date': {'key': 'properties.billingPeriodEndDate', 'type': 'iso-8601'},
        'billing_profile_id': {'key': 'properties.billingProfileId', 'type': 'str'},
        'billing_profile_name': {'key': 'properties.billingProfileName', 'type': 'str'},
        'subscription_guid': {'key': 'properties.subscriptionGuid', 'type': 'str'},
        'subscription_name': {'key': 'properties.subscriptionName', 'type': 'str'},
        'date': {'key': 'properties.date', 'type': 'iso-8601'},
        'product': {'key': 'properties.product', 'type': 'str'},
        'meter_id': {'key': 'properties.meterId', 'type': 'str'},
        'meter_name': {'key': 'properties.meterName', 'type': 'str'},
        'meter_region': {'key': 'properties.meterRegion', 'type': 'str'},
        'meter_category': {'key': 'properties.meterCategory', 'type': 'str'},
        'meter_sub_category': {'key': 'properties.meterSubCategory', 'type': 'str'},
        'service_family': {'key': 'properties.serviceFamily', 'type': 'str'},
        'quantity': {'key': 'properties.quantity', 'type': 'float'},
        'unit_of_measure': {'key': 'properties.unitOfMeasure', 'type': 'str'},
        'instance_name': {'key': 'properties.instanceName', 'type': 'str'},
        'cost_in_usd': {'key': 'properties.costInUSD', 'type': 'float'},
        'unit_price': {'key': 'properties.unitPrice', 'type': 'float'},
        'billing_currency_code': {'key': 'properties.billingCurrencyCode', 'type': 'str'},
        'resource_location': {'key': 'properties.resourceLocation', 'type': 'str'},
        'consumed_service': {'key': 'properties.consumedService', 'type': 'str'},
        'service_info1': {'key': 'properties.serviceInfo1', 'type': 'str'},
        'service_info2': {'key': 'properties.serviceInfo2', 'type': 'str'},
        'additional_info': {'key': 'properties.additionalInfo', 'type': 'str'},
        'invoice_section_id': {'key': 'properties.invoiceSectionId', 'type': 'str'},
        'invoice_section_name': {'key': 'properties.invoiceSectionName', 'type': 'str'},
        'cost_center': {'key': 'properties.costCenter', 'type': 'str'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
        'reservation_name': {'key': 'properties.reservationName', 'type': 'str'},
        'product_order_id': {'key': 'properties.productOrderId', 'type': 'str'},
        'product_order_name': {'key': 'properties.productOrderName', 'type': 'str'},
        'is_azure_credit_eligible': {'key': 'properties.isAzureCreditEligible', 'type': 'bool'},
        'term': {'key': 'properties.term', 'type': 'str'},
        'publisher_name': {'key': 'properties.publisherName', 'type': 'str'},
        'publisher_type': {'key': 'properties.publisherType', 'type': 'str'},
        'charge_type': {'key': 'properties.chargeType', 'type': 'str'},
        'frequency': {'key': 'properties.frequency', 'type': 'str'},
        'cost_in_billing_currency': {'key': 'properties.costInBillingCurrency', 'type': 'float'},
        'cost_in_pricing_currency': {'key': 'properties.costInPricingCurrency', 'type': 'float'},
        'exchange_rate': {'key': 'properties.exchangeRate', 'type': 'str'},
        'exchange_rate_date': {'key': 'properties.exchangeRateDate', 'type': 'iso-8601'},
        'invoice_id': {'key': 'properties.invoiceId', 'type': 'str'},
        'previous_invoice_id': {'key': 'properties.previousInvoiceId', 'type': 'str'},
        'pricing_currency_code': {'key': 'properties.pricingCurrencyCode', 'type': 'str'},
        'product_identifier': {'key': 'properties.productIdentifier', 'type': 'str'},
        'resource_location_normalized': {'key': 'properties.resourceLocationNormalized', 'type': 'str'},
        'service_period_start_date': {'key': 'properties.servicePeriodStartDate', 'type': 'iso-8601'},
        'service_period_end_date': {'key': 'properties.servicePeriodEndDate', 'type': 'iso-8601'},
        'customer_tenant_id': {'key': 'properties.customerTenantId', 'type': 'str'},
        'customer_name': {'key': 'properties.customerName', 'type': 'str'},
        'partner_tenant_id': {'key': 'properties.partnerTenantId', 'type': 'str'},
        'partner_name': {'key': 'properties.partnerName', 'type': 'str'},
        'reseller_mpn_id': {'key': 'properties.resellerMpnId', 'type': 'str'},
        'reseller_name': {'key': 'properties.resellerName', 'type': 'str'},
        'publisher_id': {'key': 'properties.publisherId', 'type': 'str'},
        'market_price': {'key': 'properties.marketPrice', 'type': 'float'},
        'exchange_rate_pricing_to_billing': {'key': 'properties.exchangeRatePricingToBilling', 'type': 'float'},
        'payg_cost_in_billing_currency': {'key': 'properties.paygCostInBillingCurrency', 'type': 'float'},
        'payg_cost_in_usd': {'key': 'properties.paygCostInUSD', 'type': 'float'},
        'partner_earned_credit_rate': {'key': 'properties.partnerEarnedCreditRate', 'type': 'float'},
        'partner_earned_credit_applied': {'key': 'properties.partnerEarnedCreditApplied', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ModernUsageDetail, self).__init__(**kwargs)
        self.kind = 'modern'  # type: str
        self.billing_account_id = None
        self.billing_account_name = None
        self.billing_period_start_date = None
        self.billing_period_end_date = None
        self.billing_profile_id = None
        self.billing_profile_name = None
        self.subscription_guid = None
        self.subscription_name = None
        self.date = None
        self.product = None
        self.meter_id = None
        self.meter_name = None
        self.meter_region = None
        self.meter_category = None
        self.meter_sub_category = None
        self.service_family = None
        self.quantity = None
        self.unit_of_measure = None
        self.instance_name = None
        self.cost_in_usd = None
        self.unit_price = None
        self.billing_currency_code = None
        self.resource_location = None
        self.consumed_service = None
        self.service_info1 = None
        self.service_info2 = None
        self.additional_info = None
        self.invoice_section_id = None
        self.invoice_section_name = None
        self.cost_center = None
        self.resource_group = None
        self.reservation_id = None
        self.reservation_name = None
        self.product_order_id = None
        self.product_order_name = None
        self.is_azure_credit_eligible = None
        self.term = None
        self.publisher_name = None
        self.publisher_type = None
        self.charge_type = None
        self.frequency = None
        self.cost_in_billing_currency = None
        self.cost_in_pricing_currency = None
        self.exchange_rate = None
        self.exchange_rate_date = None
        self.invoice_id = None
        self.previous_invoice_id = None
        self.pricing_currency_code = None
        self.product_identifier = None
        self.resource_location_normalized = None
        self.service_period_start_date = None
        self.service_period_end_date = None
        self.customer_tenant_id = None
        self.customer_name = None
        self.partner_tenant_id = None
        self.partner_name = None
        self.reseller_mpn_id = None
        self.reseller_name = None
        self.publisher_id = None
        self.market_price = None
        self.exchange_rate_pricing_to_billing = None
        self.payg_cost_in_billing_currency = None
        self.payg_cost_in_usd = None
        self.partner_earned_credit_rate = None
        self.partner_earned_credit_applied = None


class Notification(msrest.serialization.Model):
    """The notification associated with a budget.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. The notification is enabled or not.
    :type enabled: bool
    :param operator: Required. The comparison operator. Possible values include: "EqualTo",
     "GreaterThan", "GreaterThanOrEqualTo".
    :type operator: str or ~azure.mgmt.consumption.models.OperatorType
    :param threshold: Required. Threshold value associated with a notification. Notification is
     sent when the cost exceeded the threshold. It is always percent and has to be between 0 and
     1000.
    :type threshold: float
    :param contact_emails: Required. Email addresses to send the budget notification to when the
     threshold is exceeded.
    :type contact_emails: list[str]
    :param contact_roles: Contact roles to send the budget notification to when the threshold is
     exceeded.
    :type contact_roles: list[str]
    :param contact_groups: Action groups to send the budget notification to when the threshold is
     exceeded.
    :type contact_groups: list[str]
    :param threshold_type: The type of threshold. Possible values include: "Actual".
    :type threshold_type: str or ~azure.mgmt.consumption.models.ThresholdType
    """

    _validation = {
        'enabled': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
        'contact_emails': {'required': True, 'max_items': 50, 'min_items': 1},
        'contact_groups': {'max_items': 50, 'min_items': 0},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'contact_emails': {'key': 'contactEmails', 'type': '[str]'},
        'contact_roles': {'key': 'contactRoles', 'type': '[str]'},
        'contact_groups': {'key': 'contactGroups', 'type': '[str]'},
        'threshold_type': {'key': 'thresholdType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Notification, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.operator = kwargs['operator']
        self.threshold = kwargs['threshold']
        self.contact_emails = kwargs['contact_emails']
        self.contact_roles = kwargs.get('contact_roles', None)
        self.contact_groups = kwargs.get('contact_groups', None)
        self.threshold_type = kwargs.get('threshold_type', None)


class Operation(msrest.serialization.Model):
    """A Consumption REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.consumption.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft.Consumption.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: UsageDetail, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class OperationListResult(msrest.serialization.Model):
    """Result of listing consumption operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of consumption operations supported by the Microsoft.Consumption resource
     provider.
    :vartype value: list[~azure.mgmt.consumption.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PriceSheetProperties(msrest.serialization.Model):
    """The properties of the price sheet.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar billing_period_id: The id of the billing period resource that the usage belongs to.
    :vartype billing_period_id: str
    :ivar meter_id: The meter id (GUID).
    :vartype meter_id: str
    :ivar meter_details: The details about the meter. By default this is not populated, unless it's
     specified in $expand.
    :vartype meter_details: ~azure.mgmt.consumption.models.MeterDetails
    :ivar unit_of_measure: Unit of measure.
    :vartype unit_of_measure: str
    :ivar included_quantity: Included quality for an offer.
    :vartype included_quantity: float
    :ivar part_number: Part Number.
    :vartype part_number: str
    :ivar unit_price: Unit Price.
    :vartype unit_price: float
    :ivar currency_code: Currency Code.
    :vartype currency_code: str
    :ivar offer_id: Offer Id.
    :vartype offer_id: str
    """

    _validation = {
        'billing_period_id': {'readonly': True},
        'meter_id': {'readonly': True},
        'meter_details': {'readonly': True},
        'unit_of_measure': {'readonly': True},
        'included_quantity': {'readonly': True},
        'part_number': {'readonly': True},
        'unit_price': {'readonly': True},
        'currency_code': {'readonly': True},
        'offer_id': {'readonly': True},
    }

    _attribute_map = {
        'billing_period_id': {'key': 'billingPeriodId', 'type': 'str'},
        'meter_id': {'key': 'meterId', 'type': 'str'},
        'meter_details': {'key': 'meterDetails', 'type': 'MeterDetails'},
        'unit_of_measure': {'key': 'unitOfMeasure', 'type': 'str'},
        'included_quantity': {'key': 'includedQuantity', 'type': 'float'},
        'part_number': {'key': 'partNumber', 'type': 'str'},
        'unit_price': {'key': 'unitPrice', 'type': 'float'},
        'currency_code': {'key': 'currencyCode', 'type': 'str'},
        'offer_id': {'key': 'offerId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PriceSheetProperties, self).__init__(**kwargs)
        self.billing_period_id = None
        self.meter_id = None
        self.meter_details = None
        self.unit_of_measure = None
        self.included_quantity = None
        self.part_number = None
        self.unit_price = None
        self.currency_code = None
        self.offer_id = None


class PriceSheetResult(Resource):
    """An pricesheet resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar pricesheets: Price sheet.
    :vartype pricesheets: list[~azure.mgmt.consumption.models.PriceSheetProperties]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'pricesheets': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'pricesheets': {'key': 'properties.pricesheets', 'type': '[PriceSheetProperties]'},
        'next_link': {'key': 'properties.nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PriceSheetResult, self).__init__(**kwargs)
        self.pricesheets = None
        self.next_link = None


class ReservationDetail(Resource):
    """reservation detail resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar reservation_order_id: The reservation order ID is the identifier for a reservation
     purchase. Each reservation order ID represents a single purchase transaction. A reservation
     order contains reservations. The reservation order specifies the VM size and region for the
     reservations.
    :vartype reservation_order_id: str
    :ivar instance_flexibility_ratio: The instance Flexibility Ratio.
    :vartype instance_flexibility_ratio: str
    :ivar instance_flexibility_group: The instance Flexibility Group.
    :vartype instance_flexibility_group: str
    :ivar reservation_id: The reservation ID is the identifier of a reservation within a
     reservation order. Each reservation is the grouping for applying the benefit scope and also
     specifies the number of instances to which the reservation benefit can be applied to.
    :vartype reservation_id: str
    :ivar sku_name: This is the ARM Sku name. It can be used to join with the serviceType field in
     additional info in usage records.
    :vartype sku_name: str
    :ivar reserved_hours: This is the total hours reserved for the day. E.g. if reservation for 1
     instance was made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent
     days.
    :vartype reserved_hours: float
    :ivar usage_date: The date on which consumption occurred.
    :vartype usage_date: ~datetime.datetime
    :ivar used_hours: This is the total hours used by the instance.
    :vartype used_hours: float
    :ivar instance_id: This identifier is the name of the resource or the fully qualified Resource
     ID.
    :vartype instance_id: str
    :ivar total_reserved_quantity: This is the total count of instances that are reserved for the
     reservationId.
    :vartype total_reserved_quantity: float
    :ivar kind: The reservation kind.
    :vartype kind: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'reservation_order_id': {'readonly': True},
        'instance_flexibility_ratio': {'readonly': True},
        'instance_flexibility_group': {'readonly': True},
        'reservation_id': {'readonly': True},
        'sku_name': {'readonly': True},
        'reserved_hours': {'readonly': True},
        'usage_date': {'readonly': True},
        'used_hours': {'readonly': True},
        'instance_id': {'readonly': True},
        'total_reserved_quantity': {'readonly': True},
        'kind': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'reservation_order_id': {'key': 'properties.reservationOrderId', 'type': 'str'},
        'instance_flexibility_ratio': {'key': 'properties.instanceFlexibilityRatio', 'type': 'str'},
        'instance_flexibility_group': {'key': 'properties.instanceFlexibilityGroup', 'type': 'str'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
        'sku_name': {'key': 'properties.skuName', 'type': 'str'},
        'reserved_hours': {'key': 'properties.reservedHours', 'type': 'float'},
        'usage_date': {'key': 'properties.usageDate', 'type': 'iso-8601'},
        'used_hours': {'key': 'properties.usedHours', 'type': 'float'},
        'instance_id': {'key': 'properties.instanceId', 'type': 'str'},
        'total_reserved_quantity': {'key': 'properties.totalReservedQuantity', 'type': 'float'},
        'kind': {'key': 'properties.kind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationDetail, self).__init__(**kwargs)
        self.reservation_order_id = None
        self.instance_flexibility_ratio = None
        self.instance_flexibility_group = None
        self.reservation_id = None
        self.sku_name = None
        self.reserved_hours = None
        self.usage_date = None
        self.used_hours = None
        self.instance_id = None
        self.total_reserved_quantity = None
        self.kind = None


class ReservationDetailsListResult(msrest.serialization.Model):
    """Result of listing reservation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of reservation details.
    :vartype value: list[~azure.mgmt.consumption.models.ReservationDetail]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationDetailsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ReservationRecommendationDetailsCalculatedSavingsProperties(msrest.serialization.Model):
    """Details of estimated savings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar on_demand_cost: The cost without reservation.
    :vartype on_demand_cost: float
    :ivar overage_cost: The difference between total reservation cost and reservation cost.
    :vartype overage_cost: float
    :ivar quantity: The quantity for calculated savings.
    :vartype quantity: float
    :ivar reservation_cost: The exact cost of the estimated usage using reservation.
    :vartype reservation_cost: float
    :ivar total_reservation_cost: The cost of the suggested quantity.
    :vartype total_reservation_cost: float
    :ivar savings: The amount saved by purchasing the recommended quantity of reservation.
    :vartype savings: float
    """

    _validation = {
        'on_demand_cost': {'readonly': True},
        'overage_cost': {'readonly': True},
        'quantity': {'readonly': True},
        'reservation_cost': {'readonly': True},
        'total_reservation_cost': {'readonly': True},
        'savings': {'readonly': True},
    }

    _attribute_map = {
        'on_demand_cost': {'key': 'onDemandCost', 'type': 'float'},
        'overage_cost': {'key': 'overageCost', 'type': 'float'},
        'quantity': {'key': 'quantity', 'type': 'float'},
        'reservation_cost': {'key': 'reservationCost', 'type': 'float'},
        'total_reservation_cost': {'key': 'totalReservationCost', 'type': 'float'},
        'savings': {'key': 'savings', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationRecommendationDetailsCalculatedSavingsProperties, self).__init__(**kwargs)
        self.on_demand_cost = None
        self.overage_cost = None
        self.quantity = None
        self.reservation_cost = None
        self.total_reservation_cost = None
        self.savings = None


class ReservationRecommendationDetailsModel(Resource):
    """Reservation recommendation details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar currency: An ISO 4217 currency code identifier for the costs and savings.
    :vartype currency: str
    :ivar resource: Resource specific properties.
    :vartype resource:
     ~azure.mgmt.consumption.models.ReservationRecommendationDetailsResourceProperties
    :ivar resource_group: Resource Group.
    :vartype resource_group: str
    :ivar savings: Savings information for the recommendation.
    :vartype savings:
     ~azure.mgmt.consumption.models.ReservationRecommendationDetailsSavingsProperties
    :ivar scope: Scope of the reservation, ex: Single or Shared.
    :vartype scope: str
    :ivar usage: Historical usage details used to calculate the estimated savings.
    :vartype usage: ~azure.mgmt.consumption.models.ReservationRecommendationDetailsUsageProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'currency': {'readonly': True},
        'resource': {'readonly': True},
        'resource_group': {'readonly': True},
        'savings': {'readonly': True},
        'scope': {'readonly': True},
        'usage': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'currency': {'key': 'properties.currency', 'type': 'str'},
        'resource': {'key': 'properties.resource', 'type': 'ReservationRecommendationDetailsResourceProperties'},
        'resource_group': {'key': 'properties.resourceGroup', 'type': 'str'},
        'savings': {'key': 'properties.savings', 'type': 'ReservationRecommendationDetailsSavingsProperties'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'usage': {'key': 'properties.usage', 'type': 'ReservationRecommendationDetailsUsageProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationRecommendationDetailsModel, self).__init__(**kwargs)
        self.currency = None
        self.resource = None
        self.resource_group = None
        self.savings = None
        self.scope = None
        self.usage = None


class ReservationRecommendationDetailsResourceProperties(msrest.serialization.Model):
    """Details of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar applied_scopes: List of subscriptions for which the reservation is applied.
    :vartype applied_scopes: list[str]
    :ivar on_demand_rate: On demand rate of the resource.
    :vartype on_demand_rate: float
    :ivar product: Azure product ex: Standard_E8s_v3 etc.
    :vartype product: str
    :ivar region: Azure resource region ex:EastUS, WestUS etc.
    :vartype region: str
    :ivar reservation_rate: Reservation rate of the resource.
    :vartype reservation_rate: float
    :ivar resource_type: The azure resource type.
    :vartype resource_type: str
    """

    _validation = {
        'applied_scopes': {'readonly': True},
        'on_demand_rate': {'readonly': True},
        'product': {'readonly': True},
        'region': {'readonly': True},
        'reservation_rate': {'readonly': True},
        'resource_type': {'readonly': True},
    }

    _attribute_map = {
        'applied_scopes': {'key': 'appliedScopes', 'type': '[str]'},
        'on_demand_rate': {'key': 'onDemandRate', 'type': 'float'},
        'product': {'key': 'product', 'type': 'str'},
        'region': {'key': 'region', 'type': 'str'},
        'reservation_rate': {'key': 'reservationRate', 'type': 'float'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationRecommendationDetailsResourceProperties, self).__init__(**kwargs)
        self.applied_scopes = None
        self.on_demand_rate = None
        self.product = None
        self.region = None
        self.reservation_rate = None
        self.resource_type = None


class ReservationRecommendationDetailsSavingsProperties(msrest.serialization.Model):
    """Details of the estimated savings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param calculated_savings: List of calculated savings.
    :type calculated_savings:
     list[~azure.mgmt.consumption.models.ReservationRecommendationDetailsCalculatedSavingsProperties]
    :ivar look_back_period: Number of days of usage to look back used for computing the
     recommendation.
    :vartype look_back_period: int
    :ivar recommended_quantity: Number of recommended units of the resource.
    :vartype recommended_quantity: float
    :ivar reservation_order_term: Term period of the reservation, ex: P1Y or P3Y.
    :vartype reservation_order_term: str
    :ivar savings_type: Type of savings, ex: instance.
    :vartype savings_type: str
    :ivar unit_of_measure: Measurement unit ex: hour etc.
    :vartype unit_of_measure: str
    """

    _validation = {
        'look_back_period': {'readonly': True},
        'recommended_quantity': {'readonly': True},
        'reservation_order_term': {'readonly': True},
        'savings_type': {'readonly': True},
        'unit_of_measure': {'readonly': True},
    }

    _attribute_map = {
        'calculated_savings': {'key': 'calculatedSavings', 'type': '[ReservationRecommendationDetailsCalculatedSavingsProperties]'},
        'look_back_period': {'key': 'lookBackPeriod', 'type': 'int'},
        'recommended_quantity': {'key': 'recommendedQuantity', 'type': 'float'},
        'reservation_order_term': {'key': 'reservationOrderTerm', 'type': 'str'},
        'savings_type': {'key': 'savingsType', 'type': 'str'},
        'unit_of_measure': {'key': 'unitOfMeasure', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationRecommendationDetailsSavingsProperties, self).__init__(**kwargs)
        self.calculated_savings = kwargs.get('calculated_savings', None)
        self.look_back_period = None
        self.recommended_quantity = None
        self.reservation_order_term = None
        self.savings_type = None
        self.unit_of_measure = None


class ReservationRecommendationDetailsUsageProperties(msrest.serialization.Model):
    """Details about historical usage data that has been used for computing the recommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar first_consumption_date: The first usage date used for looking back for computing the
     recommendation.
    :vartype first_consumption_date: str
    :ivar last_consumption_date: The last usage date used for looking back for computing the
     recommendation.
    :vartype last_consumption_date: str
    :ivar look_back_unit_type: What the usage data values represent ex: virtual machine instance.
    :vartype look_back_unit_type: str
    :ivar usage_data: The breakdown of historical resource usage.  The values are in the order of
     usage between the firstConsumptionDate and the lastConsumptionDate.
    :vartype usage_data: list[float]
    :ivar usage_grain: The grain of the values represented in the usage data ex: hourly.
    :vartype usage_grain: str
    """

    _validation = {
        'first_consumption_date': {'readonly': True},
        'last_consumption_date': {'readonly': True},
        'look_back_unit_type': {'readonly': True},
        'usage_data': {'readonly': True},
        'usage_grain': {'readonly': True},
    }

    _attribute_map = {
        'first_consumption_date': {'key': 'firstConsumptionDate', 'type': 'str'},
        'last_consumption_date': {'key': 'lastConsumptionDate', 'type': 'str'},
        'look_back_unit_type': {'key': 'lookBackUnitType', 'type': 'str'},
        'usage_data': {'key': 'usageData', 'type': '[float]'},
        'usage_grain': {'key': 'usageGrain', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationRecommendationDetailsUsageProperties, self).__init__(**kwargs)
        self.first_consumption_date = None
        self.last_consumption_date = None
        self.look_back_unit_type = None
        self.usage_data = None
        self.usage_grain = None


class ReservationRecommendationsListResult(msrest.serialization.Model):
    """Result of listing reservation recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of reservation recommendations.
    :vartype value: list[~azure.mgmt.consumption.models.ReservationRecommendation]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationRecommendation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationRecommendationsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ReservationSummariesListResult(msrest.serialization.Model):
    """Result of listing reservation summaries.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of reservation summaries.
    :vartype value: list[~azure.mgmt.consumption.models.ReservationSummary]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationSummary]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationSummariesListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ReservationSummary(Resource):
    """reservation summary resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar reservation_order_id: The reservation order ID is the identifier for a reservation
     purchase. Each reservation order ID represents a single purchase transaction. A reservation
     order contains reservations. The reservation order specifies the VM size and region for the
     reservations.
    :vartype reservation_order_id: str
    :ivar reservation_id: The reservation ID is the identifier of a reservation within a
     reservation order. Each reservation is the grouping for applying the benefit scope and also
     specifies the number of instances to which the reservation benefit can be applied to.
    :vartype reservation_id: str
    :ivar sku_name: This is the ARM Sku name. It can be used to join with the serviceType field in
     additional info in usage records.
    :vartype sku_name: str
    :ivar reserved_hours: This is the total hours reserved. E.g. if reservation for 1 instance was
     made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent days.
    :vartype reserved_hours: float
    :ivar usage_date: Data corresponding to the utilization record. If the grain of data is
     monthly, it will be first day of month.
    :vartype usage_date: ~datetime.datetime
    :ivar used_hours: Total used hours by the reservation.
    :vartype used_hours: float
    :ivar min_utilization_percentage: This is the minimum hourly utilization in the usage time (day
     or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5,
     utilization was 10%, this field will return 10% for that day.
    :vartype min_utilization_percentage: float
    :ivar avg_utilization_percentage: This is average utilization for the entire time range. (day
     or month depending on the grain).
    :vartype avg_utilization_percentage: float
    :ivar max_utilization_percentage: This is the maximum hourly utilization in the usage time (day
     or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5,
     utilization was 100%, this field will return 100% for that day.
    :vartype max_utilization_percentage: float
    :ivar kind: The reservation kind.
    :vartype kind: str
    :ivar purchased_quantity: This is the purchased quantity for the reservationId.
    :vartype purchased_quantity: float
    :ivar remaining_quantity: This is the remaining quantity for the reservationId.
    :vartype remaining_quantity: float
    :ivar total_reserved_quantity: This is the total count of instances that are reserved for the
     reservationId.
    :vartype total_reserved_quantity: float
    :ivar used_quantity: This is the used quantity for the reservationId.
    :vartype used_quantity: float
    :ivar utilized_percentage: This is the utilized percentage for the reservation Id.
    :vartype utilized_percentage: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'tags': {'readonly': True},
        'reservation_order_id': {'readonly': True},
        'reservation_id': {'readonly': True},
        'sku_name': {'readonly': True},
        'reserved_hours': {'readonly': True},
        'usage_date': {'readonly': True},
        'used_hours': {'readonly': True},
        'min_utilization_percentage': {'readonly': True},
        'avg_utilization_percentage': {'readonly': True},
        'max_utilization_percentage': {'readonly': True},
        'kind': {'readonly': True},
        'purchased_quantity': {'readonly': True},
        'remaining_quantity': {'readonly': True},
        'total_reserved_quantity': {'readonly': True},
        'used_quantity': {'readonly': True},
        'utilized_percentage': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'reservation_order_id': {'key': 'properties.reservationOrderId', 'type': 'str'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
        'sku_name': {'key': 'properties.skuName', 'type': 'str'},
        'reserved_hours': {'key': 'properties.reservedHours', 'type': 'float'},
        'usage_date': {'key': 'properties.usageDate', 'type': 'iso-8601'},
        'used_hours': {'key': 'properties.usedHours', 'type': 'float'},
        'min_utilization_percentage': {'key': 'properties.minUtilizationPercentage', 'type': 'float'},
        'avg_utilization_percentage': {'key': 'properties.avgUtilizationPercentage', 'type': 'float'},
        'max_utilization_percentage': {'key': 'properties.maxUtilizationPercentage', 'type': 'float'},
        'kind': {'key': 'properties.kind', 'type': 'str'},
        'purchased_quantity': {'key': 'properties.purchasedQuantity', 'type': 'float'},
        'remaining_quantity': {'key': 'properties.remainingQuantity', 'type': 'float'},
        'total_reserved_quantity': {'key': 'properties.totalReservedQuantity', 'type': 'float'},
        'used_quantity': {'key': 'properties.usedQuantity', 'type': 'float'},
        'utilized_percentage': {'key': 'properties.utilizedPercentage', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationSummary, self).__init__(**kwargs)
        self.reservation_order_id = None
        self.reservation_id = None
        self.sku_name = None
        self.reserved_hours = None
        self.usage_date = None
        self.used_hours = None
        self.min_utilization_percentage = None
        self.avg_utilization_percentage = None
        self.max_utilization_percentage = None
        self.kind = None
        self.purchased_quantity = None
        self.remaining_quantity = None
        self.total_reserved_quantity = None
        self.used_quantity = None
        self.utilized_percentage = None


class ReservationTransactionsListResult(msrest.serialization.Model):
    """Result of listing reservation recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of reservation recommendations.
    :vartype value: list[~azure.mgmt.consumption.models.ReservationTransaction]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ReservationTransaction]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReservationTransactionsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SkuProperty(msrest.serialization.Model):
    """The Sku property.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of sku property.
    :vartype name: str
    :ivar value: The value of sku property.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuProperty, self).__init__(**kwargs)
        self.name = None
        self.value = None


class Tag(msrest.serialization.Model):
    """The tag resource.

    :param key: Tag key.
    :type key: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Tag, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)


class TagsResult(ProxyResource):
    """A resource listing all tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param e_tag: eTag of the resource. To handle concurrent update scenario, this field will be
     used to determine whether the user is updating the latest version or not.
    :type e_tag: str
    :param tags: A set of tags. A list of Tag.
    :type tags: list[~azure.mgmt.consumption.models.Tag]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'tags': {'key': 'properties.tags', 'type': '[Tag]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsResult, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class UsageDetailsListResult(msrest.serialization.Model):
    """Result of listing usage details. It contains a list of available usage details in reverse chronological order by billing period.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of usage details.
    :vartype value: list[~azure.mgmt.consumption.models.UsageDetail]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UsageDetail]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageDetailsListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
