/*
 * AUTOGENERATED - DO NOT EDIT
 *
 * This file is generated from server-decoration.xml by mir_wayland_generator
 */

#include "server-decoration_wrapper.h"

#include <boost/exception/diagnostic_information.hpp>
#include <wayland-server-core.h>

#include "mir/log.h"
#include "mir/wayland/protocol_error.h"

namespace mir
{
namespace wayland
{
extern struct wl_interface const org_kde_kwin_server_decoration_interface_data;
extern struct wl_interface const org_kde_kwin_server_decoration_manager_interface_data;
extern struct wl_interface const wl_surface_interface_data;
}
}

namespace mw = mir::wayland;

namespace
{
struct wl_interface const* all_null_types [] {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr};
}

// KwinServerDecorationManager

struct mw::KwinServerDecorationManager::Thunks
{
    static int const supported_version;

    static void create_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t id, struct wl_resource* surface)
    {
        wl_resource* id_resolved{
            wl_resource_create(client, &org_kde_kwin_server_decoration_interface_data, wl_resource_get_version(resource), id)};
        if (id_resolved == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            auto me = static_cast<KwinServerDecorationManager*>(wl_resource_get_user_data(resource));
            me->create(id_resolved, surface);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "KwinServerDecorationManager::create()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<KwinServerDecorationManager*>(wl_resource_get_user_data(resource));
    }

    static void bind_thunk(struct wl_client* client, void* data, uint32_t version, uint32_t id)
    {
        auto me = static_cast<KwinServerDecorationManager::Global*>(data);
        auto resource = wl_resource_create(
            client,
            &org_kde_kwin_server_decoration_manager_interface_data,
            std::min((int)version, Thunks::supported_version),
            id);
        if (resource == nullptr)
        {
            wl_client_post_no_memory(client);
            BOOST_THROW_EXCEPTION((std::bad_alloc{}));
        }
        try
        {
            me->bind(resource);
        }
        catch(...)
        {
            internal_error_processing_request(client, "KwinServerDecorationManager global bind");
        }
    }

    static struct wl_interface const* create_types[];
    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::KwinServerDecorationManager::Thunks::supported_version = 1;

mw::KwinServerDecorationManager::KwinServerDecorationManager(struct wl_resource* resource, Version<1>)
    : Resource{resource}
{
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::KwinServerDecorationManager::~KwinServerDecorationManager()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::KwinServerDecorationManager::send_default_mode_event(uint32_t mode) const
{
    wl_resource_post_event(resource, Opcode::default_mode, mode);
}

bool mw::KwinServerDecorationManager::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &org_kde_kwin_server_decoration_manager_interface_data, Thunks::request_vtable);
}

void mw::KwinServerDecorationManager::destroy_and_delete() const
{
    // Will result in this object being deleted
    wl_resource_destroy(resource);
}

uint32_t const mw::KwinServerDecorationManager::Mode::None;
uint32_t const mw::KwinServerDecorationManager::Mode::Client;
uint32_t const mw::KwinServerDecorationManager::Mode::Server;

mw::KwinServerDecorationManager::Global::Global(wl_display* display, Version<1>)
    : wayland::Global{
          wl_global_create(
              display,
              &org_kde_kwin_server_decoration_manager_interface_data,
              Thunks::supported_version,
              this,
              &Thunks::bind_thunk)}
{
}

auto mw::KwinServerDecorationManager::Global::interface_name() const -> char const*
{
    return KwinServerDecorationManager::interface_name;
}

struct wl_interface const* mw::KwinServerDecorationManager::Thunks::create_types[] {
    &org_kde_kwin_server_decoration_interface_data,
    &wl_surface_interface_data};

struct wl_message const mw::KwinServerDecorationManager::Thunks::request_messages[] {
    {"create", "no", create_types}};

struct wl_message const mw::KwinServerDecorationManager::Thunks::event_messages[] {
    {"default_mode", "u", all_null_types}};

void const* mw::KwinServerDecorationManager::Thunks::request_vtable[] {
    (void*)Thunks::create_thunk};

mw::KwinServerDecorationManager* mw::KwinServerDecorationManager::from(struct wl_resource* resource)
{
    if (resource &&
        wl_resource_instance_of(resource, &org_kde_kwin_server_decoration_manager_interface_data, KwinServerDecorationManager::Thunks::request_vtable))
    {
        return static_cast<KwinServerDecorationManager*>(wl_resource_get_user_data(resource));
    }
    else
    {
        return nullptr;
    }
}

// KwinServerDecoration

struct mw::KwinServerDecoration::Thunks
{
    static int const supported_version;

    static void release_thunk(struct wl_client* client, struct wl_resource* resource)
    {
        try
        {
            wl_resource_destroy(resource);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "KwinServerDecoration::release()");
        }
    }

    static void request_mode_thunk(struct wl_client* client, struct wl_resource* resource, uint32_t mode)
    {
        try
        {
            auto me = static_cast<KwinServerDecoration*>(wl_resource_get_user_data(resource));
            me->request_mode(mode);
        }
        catch(ProtocolError const& err)
        {
            wl_resource_post_error(err.resource(), err.code(), "%s", err.message());
        }
        catch(...)
        {
            internal_error_processing_request(client, "KwinServerDecoration::request_mode()");
        }
    }

    static void resource_destroyed_thunk(wl_resource* resource)
    {
        delete static_cast<KwinServerDecoration*>(wl_resource_get_user_data(resource));
    }

    static struct wl_message const request_messages[];
    static struct wl_message const event_messages[];
    static void const* request_vtable[];
};

int const mw::KwinServerDecoration::Thunks::supported_version = 1;

mw::KwinServerDecoration::KwinServerDecoration(struct wl_resource* resource, Version<1>)
    : Resource{resource}
{
    wl_resource_set_implementation(resource, Thunks::request_vtable, this, &Thunks::resource_destroyed_thunk);
}

mw::KwinServerDecoration::~KwinServerDecoration()
{
    wl_resource_set_implementation(resource, nullptr, nullptr, nullptr);
}

void mw::KwinServerDecoration::send_mode_event(uint32_t mode) const
{
    wl_resource_post_event(resource, Opcode::mode, mode);
}

bool mw::KwinServerDecoration::is_instance(wl_resource* resource)
{
    return wl_resource_instance_of(resource, &org_kde_kwin_server_decoration_interface_data, Thunks::request_vtable);
}

uint32_t const mw::KwinServerDecoration::Mode::None;
uint32_t const mw::KwinServerDecoration::Mode::Client;
uint32_t const mw::KwinServerDecoration::Mode::Server;

struct wl_message const mw::KwinServerDecoration::Thunks::request_messages[] {
    {"release", "", all_null_types},
    {"request_mode", "u", all_null_types}};

struct wl_message const mw::KwinServerDecoration::Thunks::event_messages[] {
    {"mode", "u", all_null_types}};

void const* mw::KwinServerDecoration::Thunks::request_vtable[] {
    (void*)Thunks::release_thunk,
    (void*)Thunks::request_mode_thunk};

mw::KwinServerDecoration* mw::KwinServerDecoration::from(struct wl_resource* resource)
{
    if (resource &&
        wl_resource_instance_of(resource, &org_kde_kwin_server_decoration_interface_data, KwinServerDecoration::Thunks::request_vtable))
    {
        return static_cast<KwinServerDecoration*>(wl_resource_get_user_data(resource));
    }
    else
    {
        return nullptr;
    }
}

namespace mir
{
namespace wayland
{

struct wl_interface const org_kde_kwin_server_decoration_manager_interface_data {
    mw::KwinServerDecorationManager::interface_name,
    mw::KwinServerDecorationManager::Thunks::supported_version,
    1, mw::KwinServerDecorationManager::Thunks::request_messages,
    1, mw::KwinServerDecorationManager::Thunks::event_messages};

struct wl_interface const org_kde_kwin_server_decoration_interface_data {
    mw::KwinServerDecoration::interface_name,
    mw::KwinServerDecoration::Thunks::supported_version,
    2, mw::KwinServerDecoration::Thunks::request_messages,
    1, mw::KwinServerDecoration::Thunks::event_messages};

}
}
