% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contraction.R
\name{contraction}
\alias{contraction}
\title{Numerical and Symbolic Tensor Contraction}
\usage{
contraction(x, i = NULL, drop = TRUE)
}
\arguments{
\item{x}{indexed \code{array}. See \code{\link{index}}.}

\item{i}{subset of repeated indices to sum up. If \code{NULL}, the summation takes place on all the repeated indices.}

\item{drop}{\code{logical}. Drop summation indices? If \code{FALSE}, keep dummy dimensions.}
}
\value{
\code{array}.
}
\description{
Sums over repeated indices in an \code{array}.
}
\examples{
### matrix trace
x <- matrix(letters[1:4], nrow = 2)
contraction(x)

### tensor trace
x <- array(1:27, dim = c(3,3,3))
contraction(x)

#### tensor contraction over repeated indices
x <- array(1:27, dim = c(3,3,3))
index(x) <- c("i","i","j")
contraction(x)

#### tensor contraction over specific repeated indices only
x <- array(1:16, dim = c(2,2,2,2))
index(x) <- c("i","i","k","k")
contraction(x, i = "k")

#### tensor contraction keeping dummy dimensions
x <- array(letters[1:16], dim = c(2,2,2,2))
index(x) <- c("i","i","k","k")
contraction(x, drop = FALSE)

}
\references{
Guidotti E (2022). "calculus: High-Dimensional Numerical and Symbolic Calculus in R." Journal of Statistical Software, 104(5), 1-37. \doi{10.18637/jss.v104.i05}
}
\seealso{
Other tensor algebra: 
\code{\link{delta}()},
\code{\link{diagonal}()},
\code{\link{einstein}()},
\code{\link{epsilon}()},
\code{\link{index}()}
}
\concept{tensor algebra}
